/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDConnectionWrapperPooling;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.jci.UConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class CUBRIDPooledConnection
implements PooledConnection {
    protected UConnection u_con;
    protected boolean isClosed;
    protected CUBRIDConnection storedConnection;
    protected CUBRIDConnection cubConnection;
    private Vector<ConnectionEventListener> eventListeners;

    protected CUBRIDPooledConnection() {
        this.initConnection();
    }

    protected CUBRIDPooledConnection(UConnection uCon) {
        this.initConnection();
        this.u_con = uCon;
    }

    protected CUBRIDPooledConnection(CUBRIDConnection cCon) {
        this.initConnection();
        this.storedConnection = cCon;
    }

    private void initConnection() {
        this.cubConnection = null;
        this.storedConnection = null;
        this.eventListeners = new Vector();
        this.isClosed = false;
        this.u_con = null;
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.isClosed) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.pooled_connection_closed);
        }
        if (this.cubConnection != null) {
            this.cubConnection.closeConnection();
        }
        if (this.u_con == null && this.storedConnection != null) {
            this.u_con = this.storedConnection.getUConnection();
        }
        if (!this.u_con.check_cas()) {
            this.u_con.reset_connection();
        }
        this.cubConnection = new CUBRIDConnectionWrapperPooling(this.u_con, null, null, this);
        return this.cubConnection;
    }

    public synchronized void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.cubConnection != null) {
            this.cubConnection.closeConnection();
        }
        if (this.storedConnection != null) {
            this.storedConnection.closeConnection();
        }
        if (this.u_con != null) {
            this.u_con.close();
        }
        this.eventListeners.clear();
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.isClosed) {
            return;
        }
        this.eventListeners.addElement(listener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.isClosed) {
            return;
        }
        this.eventListeners.removeElement(listener);
    }

    synchronized void notifyConnectionClosed() {
        this.cubConnection = null;
        ConnectionEvent e = new ConnectionEvent(this);
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            this.eventListeners.elementAt(i).connectionClosed(e);
        }
    }

    synchronized void notifyConnectionErrorOccurred(SQLException ex) {
        this.cubConnection = null;
        ConnectionEvent e = new ConnectionEvent(this, ex);
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            this.eventListeners.elementAt(i).connectionErrorOccurred(e);
        }
    }

    public void addStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException();
    }
}

