/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import java.io.IOException;
import java.io.Reader;

class CUBRIDReader
extends Reader {
    private int position;
    private String valueBuffer;

    CUBRIDReader(String v) {
        this.valueBuffer = v;
        this.position = 0;
    }

    public synchronized int available() throws IOException {
        if (this.valueBuffer == null) {
            return 0;
        }
        return this.valueBuffer.length() - this.position;
    }

    public synchronized int read(char[] cbuf, int off, int len) throws IOException {
        int i;
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.valueBuffer == null) {
            return -1;
        }
        for (i = this.position; i < len + this.position && i < this.valueBuffer.length(); ++i) {
            cbuf[i - this.position + off] = this.valueBuffer.charAt(i);
        }
        int temp = this.position;
        this.position = i;
        if (this.position == this.valueBuffer.length()) {
            this.close();
        }
        return i - temp;
    }

    public synchronized void close() throws IOException {
        this.valueBuffer = null;
    }

    public boolean ready() {
        return true;
    }
}

