/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDBlob;
import cubrid.jdbc.driver.CUBRIDClob;
import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDInputStream;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDReader;
import cubrid.jdbc.driver.CUBRIDResultSetMetaData;
import cubrid.jdbc.driver.CUBRIDStatement;
import cubrid.jdbc.jci.UColumnInfo;
import cubrid.jdbc.jci.UError;
import cubrid.jdbc.jci.UStatement;
import cubrid.sql.CUBRIDOID;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CUBRIDResultSet
implements ResultSet {
    public boolean complete_on_close;
    private CUBRIDConnection con;
    private CUBRIDStatement stmt;
    protected UStatement u_stmt;
    protected int number_of_rows;
    private int current_row;
    protected UColumnInfo[] column_info;
    protected HashMap<String, Integer> col_name_to_index;
    protected boolean is_closed;
    private boolean was_null;
    private boolean close_u_stmt_on_close;
    protected UError error;
    private CUBRIDResultSetMetaData meta_data;
    protected ArrayList<Object> streams;
    private int type;
    private int concurrency;
    private boolean is_scrollable;
    private boolean is_updatable;
    private boolean is_sensitive;
    private boolean is_holdable;
    private int fetch_direction;
    private int fetch_size;
    private boolean inserting;
    private boolean[] updatable;
    private boolean[] updated;
    private Object[] updates;
    private int number_of_updates;
    private String main_table_name;

    protected CUBRIDResultSet(CUBRIDConnection c, CUBRIDStatement s, int t, int concur, boolean holdable) throws SQLException {
        this.con = c;
        this.stmt = s;
        this.u_stmt = s.u_stmt;
        this.number_of_rows = this.u_stmt.getExecuteResult();
        this.current_row = -1;
        this.column_info = this.u_stmt.getColumnInfo();
        this.col_name_to_index = this.u_stmt.getColumnNameToIndexMap();
        this.is_closed = false;
        this.was_null = false;
        this.complete_on_close = false;
        this.close_u_stmt_on_close = false;
        this.meta_data = null;
        this.streams = new ArrayList();
        this.type = t;
        this.concurrency = concur;
        this.is_scrollable = t != 1003;
        this.is_updatable = concur == 1008;
        this.is_sensitive = t == 1005;
        this.is_holdable = false;
        if (holdable && this.con.u_con.supportHoldableResult()) {
            this.is_holdable = true;
        }
        this.fetch_direction = s.getFetchDirection();
        this.u_stmt.setFetchDirection(this.fetch_direction);
        this.fetch_size = s.getFetchSize();
        this.u_stmt.setFetchSize(this.fetch_size);
        this.inserting = false;
        if (this.is_updatable) {
            this.updatable = new boolean[this.column_info.length];
            this.updated = new boolean[this.column_info.length];
            this.updates = new Object[this.column_info.length];
            this.main_table_name = null;
            for (int i = 0; i < this.column_info.length; ++i) {
                boolean bl = this.updatable[i] = this.column_info[i].getRealColumnName().length() > 0;
                if (!this.updatable[i]) continue;
                this.main_table_name = this.column_info[i].getClassName();
            }
            this.clearCurrentRow();
        }
    }

    public CUBRIDResultSet(UStatement s) {
        this.con = null;
        this.stmt = null;
        this.u_stmt = s;
        this.current_row = -1;
        if (this.u_stmt != null) {
            this.number_of_rows = this.u_stmt.getExecuteResult();
            this.column_info = this.u_stmt.getColumnInfo();
            this.col_name_to_index = this.u_stmt.getColumnNameToIndexMap();
        } else {
            this.number_of_rows = 0;
        }
        this.is_closed = false;
        this.was_null = false;
        this.complete_on_close = false;
        this.close_u_stmt_on_close = true;
        this.streams = new ArrayList();
        this.type = 1003;
        this.concurrency = 1007;
        this.is_scrollable = false;
        this.is_updatable = false;
        this.is_sensitive = false;
        this.is_holdable = false;
        this.fetch_direction = 1000;
        this.fetch_size = 0;
        this.inserting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        this.checkIsOpen();
        if (this.u_stmt == null) {
            return false;
        }
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDStatement cUBRIDStatement = this.stmt;
                synchronized (cUBRIDStatement) {
                    CUBRIDResultSet cUBRIDResultSet = this;
                    synchronized (cUBRIDResultSet) {
                        this.checkIsOpen();
                        this.clearCurrentRow();
                        ++this.current_row;
                        if (this.current_row >= this.number_of_rows) {
                            this.current_row = this.number_of_rows;
                            return false;
                        }
                        if (this.u_stmt.isFetchCompleted(this.current_row)) {
                            return false;
                        }
                        this.move();
                        this.inserting = false;
                        return this.AfterNext();
                    }
                }
            }
        }
        catch (NullPointerException e) {
            CUBRIDResultSet cUBRIDResultSet = this;
            synchronized (cUBRIDResultSet) {
                this.checkIsOpen();
                this.clearCurrentRow();
                ++this.current_row;
                if (this.current_row >= this.number_of_rows) {
                    this.current_row = this.number_of_rows;
                    return false;
                }
                if (this.u_stmt.isFetchCompleted(this.current_row)) {
                    return false;
                }
                this.move();
                this.inserting = false;
                return this.AfterNext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean AfterNext() throws SQLException {
        if (this.u_stmt == null) {
            return false;
        }
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.fetch();
            this.error = this.u_stmt.getRecentError();
        }
        if (this.error.getJdbcErrorCode() == -10012) {
            return false;
        }
        return !this.u_stmt.isFetchCompleted(this.current_row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDStatement cUBRIDStatement = this.stmt;
                synchronized (cUBRIDStatement) {
                    CUBRIDResultSet cUBRIDResultSet = this;
                    synchronized (cUBRIDResultSet) {
                        if (this.is_closed) {
                            return;
                        }
                        this.is_closed = true;
                        this.clearCurrentRow();
                        if (this.stmt.getResultSetHoldability() == 1) {
                            this.u_stmt.closeCursor();
                        }
                        if (this.complete_on_close) {
                            this.stmt.complete();
                        }
                        if (this.close_u_stmt_on_close) {
                            this.u_stmt.close();
                        }
                        this.streams = null;
                        this.stmt = null;
                        this.u_stmt.closeResult();
                        if (!this.u_stmt.isReturnable()) {
                            this.u_stmt = null;
                        }
                        this.column_info = null;
                        this.col_name_to_index = null;
                        this.error = null;
                        this.is_holdable = false;
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        this.checkIsOpen();
        return this.was_null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getString(int columnIndex) throws SQLException {
        String value;
        Object obj;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            obj = this.u_stmt.getObject(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        if (obj != null && obj instanceof Clob) {
            Clob clob = (Clob)obj;
            int length = clob.length() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)clob.length();
            return clob.getSubString(1L, length);
        }
        UStatement uStatement2 = this.u_stmt;
        synchronized (uStatement2) {
            value = this.u_stmt.getString(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        boolean value;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getBoolean(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte getByte(int columnIndex) throws SQLException {
        byte value;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getByte(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized short getShort(int columnIndex) throws SQLException {
        short value;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getShort(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getInt(int columnIndex) throws SQLException {
        int value;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getInt(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long getLong(int columnIndex) throws SQLException {
        long value;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getLong(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized float getFloat(int columnIndex) throws SQLException {
        float value;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getFloat(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized double getDouble(int columnIndex) throws SQLException {
        double value;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getDouble(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        byte[] value;
        Object obj;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            obj = this.u_stmt.getObject(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        if (obj != null && obj instanceof Blob) {
            Blob blob = (Blob)obj;
            int length = blob.length() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)blob.length();
            return blob.getBytes(1L, length);
        }
        UStatement uStatement2 = this.u_stmt;
        synchronized (uStatement2) {
            value = this.u_stmt.getBytes(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Date getDate(int columnIndex) throws SQLException {
        Date value;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getDate(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Time getTime(int columnIndex) throws SQLException {
        Time value;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getTime(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        Timestamp value;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getTimestamp(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        String str;
        Object obj;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            obj = this.u_stmt.getObject(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        if (obj != null && obj instanceof Clob) {
            Clob clob = (Clob)obj;
            InputStream stream = clob.getAsciiStream();
            this.addStream(stream);
            return stream;
        }
        Object stream = this.u_stmt;
        synchronized (stream) {
            str = this.u_stmt.getString(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        if (str == null) {
            return null;
        }
        stream = new CUBRIDInputStream(str.getBytes());
        this.addStream(stream);
        return stream;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        byte[] bytes;
        Object obj;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            obj = this.u_stmt.getObject(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        if (obj != null && obj instanceof Blob) {
            Blob blob = (Blob)obj;
            InputStream stream = blob.getBinaryStream();
            this.addStream(stream);
            return stream;
        }
        Object stream = this.u_stmt;
        synchronized (stream) {
            bytes = this.u_stmt.getBytes(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        if (bytes == null) {
            return null;
        }
        stream = new CUBRIDInputStream(bytes);
        this.addStream(stream);
        return stream;
    }

    @Override
    public synchronized String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public synchronized boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public synchronized byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public synchronized short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public synchronized int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public synchronized long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public synchronized float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public synchronized double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public synchronized Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public synchronized Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public synchronized Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public synchronized InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkIsOpen();
        return null;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkIsOpen();
    }

    @Override
    public synchronized String getCursorName() throws SQLException {
        this.checkIsOpen();
        return "";
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.checkIsOpen();
        if (this.meta_data == null) {
            this.meta_data = new CUBRIDResultSetMetaData(this.u_stmt.getColumnInfo());
        }
        return this.meta_data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object getObject(int columnIndex) throws SQLException {
        Object value;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getObject(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    @Override
    public synchronized Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public synchronized int findColumn(String columnName) throws SQLException {
        this.checkIsOpen();
        Integer index = this.col_name_to_index.get(columnName.toLowerCase());
        if (index == null) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_column_name, null);
        }
        return index + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        String str;
        Object obj;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            obj = this.u_stmt.getObject(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        if (obj != null && obj instanceof Clob) {
            Clob clob = (Clob)obj;
            Reader stream = clob.getCharacterStream();
            this.addStream(stream);
            return stream;
        }
        UStatement stream = this.u_stmt;
        synchronized (stream) {
            str = this.u_stmt.getString(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        if (str == null) {
            return null;
        }
        byte[] b = str.getBytes();
        CUBRIDReader stream2 = null;
        try {
            stream2 = new CUBRIDReader(new String(b, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.addStream(stream2);
        return stream2;
    }

    @Override
    public synchronized Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        BigDecimal value;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getBigDecimal(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        if (this.number_of_rows == 0) {
            return false;
        }
        return this.current_row == -1;
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        if (this.number_of_rows == 0) {
            return false;
        }
        return this.current_row == this.number_of_rows;
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        if (this.number_of_rows == 0) {
            return false;
        }
        return this.current_row == 0;
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        if (this.number_of_rows == 0) {
            return false;
        }
        return this.current_row == this.number_of_rows - 1;
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        this.clearCurrentRow();
        this.current_row = -1;
        this.inserting = false;
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        this.clearCurrentRow();
        this.current_row = this.number_of_rows;
        this.inserting = false;
    }

    @Override
    public synchronized boolean first() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        this.clearCurrentRow();
        this.inserting = false;
        this.current_row = 0;
        if (this.number_of_rows <= 0) {
            return false;
        }
        this.move();
        return true;
    }

    @Override
    public synchronized boolean last() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        this.clearCurrentRow();
        this.inserting = false;
        this.current_row = this.number_of_rows - 1;
        if (this.current_row < 0) {
            this.current_row = -1;
            return false;
        }
        this.move();
        return true;
    }

    @Override
    public synchronized int getRow() throws SQLException {
        this.checkIsOpen();
        if (this.current_row > -1 && this.current_row < this.number_of_rows) {
            return this.current_row + 1;
        }
        return 0;
    }

    @Override
    public synchronized boolean absolute(int row) throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        this.clearCurrentRow();
        if (row == 0) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.argument_zero, null);
        }
        this.current_row = row > 0 ? row - 1 : this.number_of_rows + row;
        this.inserting = false;
        if (this.current_row < 0) {
            this.current_row = -1;
            return false;
        }
        if (this.current_row >= this.number_of_rows) {
            this.current_row = this.number_of_rows;
            return false;
        }
        this.move();
        return true;
    }

    @Override
    public synchronized boolean relative(int rows) throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        this.clearCurrentRow();
        if (this.current_row == -1 || this.current_row == this.number_of_rows) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_row, null);
        }
        this.current_row += rows;
        this.inserting = false;
        if (this.current_row < 0) {
            this.current_row = -1;
            return false;
        }
        if (this.current_row >= this.number_of_rows) {
            this.current_row = this.number_of_rows;
            return false;
        }
        this.move();
        return true;
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        this.checkIsOpen();
        this.checkIsScrollable();
        this.clearCurrentRow();
        --this.current_row;
        this.inserting = false;
        if (this.current_row < 0) {
            this.current_row = -1;
            return false;
        }
        this.move();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        this.checkIsOpen();
        if (!this.is_scrollable) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.non_scrollable, null);
        }
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new IllegalArgumentException();
        }
        this.fetch_direction = direction;
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.setFetchDirection(direction);
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        this.checkIsOpen();
        return this.fetch_direction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        this.checkIsOpen();
        if (rows < 0) {
            throw new IllegalArgumentException();
        }
        this.fetch_size = rows;
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.setFetchSize(rows);
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        this.checkIsOpen();
        return this.fetch_size;
    }

    @Override
    public synchronized int getType() throws SQLException {
        this.checkIsOpen();
        return this.type;
    }

    @Override
    public synchronized int getConcurrency() throws SQLException {
        this.checkIsOpen();
        return this.concurrency;
    }

    @Override
    public synchronized boolean rowUpdated() throws SQLException {
        this.checkIsOpen();
        this.checkIsSensitive();
        this.checkRowIsValidForGet();
        return false;
    }

    @Override
    public synchronized boolean rowInserted() throws SQLException {
        this.checkIsOpen();
        this.checkIsSensitive();
        this.checkRowIsValidForGet();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean rowDeleted() throws SQLException {
        this.checkIsOpen();
        this.checkIsSensitive();
        this.checkRowIsValidForGet();
        boolean b = false;
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.fetch();
            b = this.u_stmt.cursorIsInstance(this.current_row);
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
        return !b;
    }

    @Override
    public synchronized void updateNull(int columnIndex) throws SQLException {
        this.updateValue(columnIndex, null);
    }

    @Override
    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.updateValue(columnIndex, new Boolean(x));
    }

    @Override
    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        this.updateValue(columnIndex, new Byte(x));
    }

    @Override
    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        this.updateValue(columnIndex, new Short(x));
    }

    @Override
    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        this.updateValue(columnIndex, new Integer(x));
    }

    @Override
    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        this.updateValue(columnIndex, new Long(x));
    }

    @Override
    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        this.updateValue(columnIndex, new Float(x));
    }

    @Override
    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        this.updateValue(columnIndex, new Double(x));
    }

    @Override
    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.checkRowIsValidForUpdate();
        this.checkColumnIsValid(columnIndex);
        this.checkColumnIsUpdatable(columnIndex);
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        byte[] value = new byte[length];
        int len = 0;
        try {
            len = x.read(value);
        }
        catch (IOException e) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream, e);
        }
        if (len == -1) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.empty_inputstream, null);
        }
        this.updateValue(columnIndex, new String(value, 0, len));
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.checkRowIsValidForUpdate();
        this.checkColumnIsValid(columnIndex);
        this.checkColumnIsUpdatable(columnIndex);
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        byte[] value = new byte[length];
        int len = 0;
        try {
            len = x.read(value);
        }
        catch (IOException e) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream, null);
        }
        if (len == -1) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.empty_inputstream, null);
        }
        byte[] value2 = new byte[len];
        for (int i = 0; i < len; ++i) {
            value2[i] = value[i];
        }
        this.updateValue(columnIndex, value2);
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.checkRowIsValidForUpdate();
        this.checkColumnIsValid(columnIndex);
        this.checkColumnIsUpdatable(columnIndex);
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        char[] value = new char[length];
        int len = 0;
        try {
            len = x.read(value);
        }
        catch (IOException e) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream, e);
        }
        if (len == -1) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.empty_reader, null);
        }
        try {
            this.updateValue(columnIndex, new String(value, 0, len).getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        try {
            this.updateObject(columnIndex, (Object)new BigDecimal(((Number)x).toString()).setScale(scale));
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            this.updateObject(columnIndex, x);
        }
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public synchronized void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public synchronized void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void insertRow() throws SQLException {
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDResultSet cUBRIDResultSet = this;
                synchronized (cUBRIDResultSet) {
                    int i;
                    this.checkIsOpen();
                    this.checkIsUpdatable();
                    if (!this.inserting) {
                        throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_row, null);
                    }
                    if (this.main_table_name == null) {
                        return;
                    }
                    String sql = "insert into [" + this.main_table_name + "] (";
                    boolean first = true;
                    for (i = 0; i < this.column_info.length; ++i) {
                        if (!this.updated[i]) continue;
                        if (!first) {
                            sql = sql + ",";
                        }
                        first = false;
                        sql = sql + "[" + this.column_info[i].getRealColumnName() + "]";
                    }
                    sql = sql + ") values (";
                    first = true;
                    for (i = 0; i < this.column_info.length; ++i) {
                        if (!this.updated[i]) continue;
                        if (!first) {
                            sql = sql + ",";
                        }
                        first = false;
                        sql = sql + this.valueToString(this.updates[i]);
                    }
                    sql = sql + ")";
                    UStatement t_u_stmt = this.con.prepare(sql, (byte)0);
                    t_u_stmt.execute(false, 0, 0, false, false, false, false, false, false, null, 0);
                    this.error = t_u_stmt.getRecentError();
                    t_u_stmt.close();
                    if (this.error.getErrorCode() != 0) {
                        throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.insertion_query_fail, null);
                    }
                }
            }
        }
        catch (NullPointerException e) {
            this.checkIsOpen();
        }
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.checkRowIsValidForGet();
        int[] indices = new int[this.number_of_updates];
        Object[] values = new Object[this.number_of_updates];
        int j = 0;
        for (int i = 0; i < this.column_info.length; ++i) {
            if (!this.updated[i]) continue;
            indices[j] = i;
            values[j++] = this.updates[i];
        }
        this.u_stmt.updateRows(this.current_row, indices, values);
        this.error = this.u_stmt.getRecentError();
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
        if (this.is_sensitive) {
            this.refreshRow();
        } else {
            this.clearCurrentRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deleteRow() throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.checkRowIsValidForGet();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.fetch();
            this.u_stmt.deleteCursor(this.current_row);
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        this.checkIsOpen();
        this.checkIsSensitive();
        this.checkRowIsValidForGet();
        this.clearCurrentRow();
        this.u_stmt.reFetch();
        this.error = this.u_stmt.getRecentError();
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.checkRowIsValidForUpdate();
        this.number_of_updates = 0;
        for (int i = 0; i < this.updates.length; ++i) {
            this.updates[i] = null;
            this.updated[i] = false;
        }
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.clearCurrentRow();
        this.inserting = true;
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.clearCurrentRow();
        this.inserting = false;
    }

    @Override
    public synchronized Statement getStatement() throws SQLException {
        this.checkIsOpen();
        return this.stmt;
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Blob getBlob(int columnIndex) throws SQLException {
        CUBRIDBlob value;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getBlob(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        CUBRIDClob value;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getClob(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex);
    }

    @Override
    public synchronized Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(columnName);
    }

    @Override
    public synchronized Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(columnIndex);
    }

    @Override
    public synchronized Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(columnName);
    }

    @Override
    public synchronized Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public synchronized Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(columnName);
    }

    @Override
    public synchronized URL getURL(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized URL getURL(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void updateArray(String columnName, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateValue(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateClob(int columnIndex, Clob x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateClob(String columnName, Clob x) throws SQLException {
        this.updateValue(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void updateRef(String columnName, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CUBRIDOID getOID(int columnIndex) throws SQLException {
        CUBRIDOID value;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getColumnOID(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    public synchronized CUBRIDOID getOID(String columnName) throws SQLException {
        return this.getOID(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getCollection(int columnIndex) throws SQLException {
        Object value;
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            value = this.u_stmt.getCollection(columnIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return value;
    }

    public synchronized Object getCollection(String columnName) throws SQLException {
        return this.getCollection(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CUBRIDOID getOID() throws SQLException {
        this.checkIsOpen();
        this.checkRowIsValidForGet();
        CUBRIDOID oid = null;
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            oid = this.u_stmt.getCursorOID();
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                return oid;
            }
            case -21021: {
                return null;
            }
        }
        throw this.con.createCUBRIDException(this.error);
    }

    private void checkIsOpen() throws SQLException {
        if (this.is_closed) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.result_set_closed, null);
        }
    }

    private void checkIsUpdatable() throws SQLException {
        if (!this.is_updatable) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.non_updatable, null);
        }
    }

    private void checkIsSensitive() throws SQLException {
        if (!this.is_sensitive) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.non_sensitive, null);
        }
    }

    private void checkIsScrollable() throws SQLException {
        if (!this.is_scrollable) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.non_scrollable, null);
        }
    }

    private void checkRowIsValidForGet() throws SQLException {
        if (this.current_row == this.number_of_rows || this.current_row == -1 || this.inserting) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_row, null);
        }
    }

    private void checkRowIsValidForUpdate() throws SQLException {
        if (!(this.current_row != this.number_of_rows && this.current_row != -1 || this.inserting)) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_row, null);
        }
    }

    private void checkColumnIsValid(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.column_info.length) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_index, null);
        }
    }

    private void checkColumnIsUpdatable(int columnIndex) throws SQLException {
        if (!this.updatable[columnIndex - 1]) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.non_updatable_column, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeGetValue(int columnIndex) throws SQLException {
        this.checkRowIsValidForGet();
        this.checkColumnIsValid(columnIndex);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.fetch();
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
    }

    private void checkGetXXXError() throws SQLException {
        switch (this.error.getErrorCode()) {
            case 0: {
                this.was_null = false;
                break;
            }
            case -21008: {
                this.was_null = true;
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
    }

    private void updateValue(int columnIndex, Object value) throws SQLException {
        this.checkIsOpen();
        this.checkIsUpdatable();
        this.checkRowIsValidForUpdate();
        this.checkColumnIsValid(columnIndex);
        this.checkColumnIsUpdatable(columnIndex);
        this.updates[columnIndex - 1] = value;
        if (!this.updated[columnIndex - 1]) {
            this.updated[columnIndex - 1] = true;
            ++this.number_of_updates;
        }
    }

    protected void clearCurrentRow() throws SQLException {
        Iterator<Object> iter = this.streams.iterator();
        try {
            while (iter.hasNext()) {
                Object stream = iter.next();
                if (stream instanceof Closeable) {
                    ((Closeable)stream).close();
                }
                iter.remove();
            }
        }
        catch (IOException stream) {
            // empty catch block
        }
        if (this.is_updatable) {
            this.number_of_updates = 0;
            for (int i = 0; i < this.updates.length; ++i) {
                this.updates[i] = null;
                this.updated[i] = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void move() throws SQLException {
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.moveCursor(this.current_row, 0);
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
    }

    private void addStream(Object s) throws SQLException {
        this.streams.add(s);
    }

    private String valueToString(Object value) throws SQLException {
        if (value == null) {
            return "null";
        }
        String strvalue = null;
        if (value instanceof Time) {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
            strvalue = "'" + format.format((java.util.Date)value) + "'";
        } else if (value instanceof Date) {
            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
            strvalue = "'" + format.format((java.util.Date)value) + "'";
        } else if (value instanceof Timestamp) {
            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            strvalue = "'" + format.format((java.util.Date)value) + "'";
        } else if (value instanceof CUBRIDOID) {
            strvalue = "'" + ((CUBRIDOID)value).getOidString() + "'";
        } else if (value instanceof byte[]) {
            byte[] v = (byte[])value;
            strvalue = "";
            for (int i = v.length - 1; i >= 0; --i) {
                int t = v[i] + 256;
                for (int j = 0; j < 2; ++j) {
                    if (t % 16 < 10) {
                        strvalue = t % 16 + strvalue;
                    }
                    if (t % 16 == 10) {
                        strvalue = "A" + strvalue;
                    }
                    if (t % 16 == 11) {
                        strvalue = "B" + strvalue;
                    }
                    if (t % 16 == 12) {
                        strvalue = "C" + strvalue;
                    }
                    if (t % 16 == 13) {
                        strvalue = "D" + strvalue;
                    }
                    if (t % 16 == 14) {
                        strvalue = "E" + strvalue;
                    }
                    if (t % 16 == 15) {
                        strvalue = "F" + strvalue;
                    }
                    t /= 16;
                }
            }
            strvalue = "X'" + strvalue + "'";
        } else if (value instanceof String) {
            strvalue = "'" + value.toString() + "'";
        } else if (value instanceof Boolean) {
            strvalue = "B'";
            strvalue = strvalue + ((Boolean)value != false ? "1" : "0");
            strvalue = strvalue + "'";
        } else {
            strvalue = value.toString();
        }
        return strvalue;
    }

    public int getServerHandle() {
        if (this.u_stmt == null || !this.u_stmt.isReturnable()) {
            return 0;
        }
        return this.u_stmt.getServerHandle();
    }

    public void setReturnable() {
        if (!this.is_closed) {
            this.u_stmt.setReturnable();
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkIsOpen();
        return this.is_holdable ? 1 : 2;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

