/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDXAConnection;
import cubrid.jdbc.driver.CUBRIDXidInfo;
import cubrid.jdbc.driver.CUBRIDXidTable;
import cubrid.jdbc.jci.UConnection;
import java.io.PrintStream;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class CUBRIDXAResource
implements XAResource {
    private CUBRIDXAConnection xacon;
    private PrintStream debug_out;
    private String xacon_key;

    protected CUBRIDXAResource(CUBRIDXAConnection xacon, String xacon_key) {
        this.xacon = xacon;
        this.xacon_key = xacon_key;
        this.debug_out = null;
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource(" + xacon_key + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        CUBRIDXidInfo xidInfo;
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.commit(" + xid + "," + onePhase + ")");
        }
        if ((xidInfo = CUBRIDXidTable.getXid(this.xacon_key, xid)) == null) {
            throw new XAException(-4);
        }
        CUBRIDXidInfo cUBRIDXidInfo = xidInfo;
        synchronized (cUBRIDXidInfo) {
            if (onePhase ? xidInfo.status != 0 : xidInfo.status != 3 && xidInfo.status != 4) {
                throw new XAException(-6);
            }
            this.end_tran(xidInfo.ucon, xid, xidInfo.status, true);
            xidInfo.status = 5;
        }
        CUBRIDXidTable.removeXid(this.xacon_key, xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int flags) throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.end(" + xid + "," + flags + ")");
        }
        if (flags != 0x4000000 && flags != 0x20000000 && flags != 0x2000000) {
            throw new XAException(-5);
        }
        CUBRIDXidInfo xidInfo = CUBRIDXidTable.getXid(this.xacon_key, xid);
        if (xidInfo == null) {
            throw new XAException(-4);
        }
        CUBRIDXidInfo cUBRIDXidInfo = xidInfo;
        synchronized (cUBRIDXidInfo) {
            if (xidInfo.status != 1 && xidInfo.status != 2 && xidInfo.status != 0) {
                throw new XAException(-6);
            }
            if (!this.xacon.xa_end()) {
                throw new XAException(-3);
            }
            xidInfo.status = flags == 0x2000000 ? 2 : 0;
        }
    }

    public void forget(Xid xid) throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.forget()");
        }
    }

    public int getTransactionTimeout() throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.getTransactionTimeout()");
        }
        return 0;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.isSameRM()");
        }
        return xares instanceof CUBRIDXAResource && this.xacon_key.compareTo(((CUBRIDXAResource)xares).xacon_key) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        CUBRIDXidInfo xidInfo;
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.prepare()");
        }
        if ((xidInfo = CUBRIDXidTable.getXid(this.xacon_key, xid)) == null) {
            throw new XAException(-4);
        }
        CUBRIDXidInfo cUBRIDXidInfo = xidInfo;
        synchronized (cUBRIDXidInfo) {
            if (xidInfo.status != 0) {
                throw new XAException(-6);
            }
            UConnection ucon = xidInfo.ucon;
            if (ucon == null) {
                throw new XAException(-3);
            }
            UConnection uConnection = ucon;
            synchronized (uConnection) {
                ucon.xa_prepare(xid);
                if (ucon.getRecentError().getErrorCode() != 0) {
                    throw new XAException(-3);
                }
            }
            xidInfo.status = 3;
        }
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        UConnection ucon;
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.recover()");
        }
        try {
            ucon = this.xacon.createUConnection();
        }
        catch (Exception e) {
            throw new XAException(-3);
        }
        Xid[] xid = ucon.xa_recover();
        if (ucon.getRecentError().getErrorCode() != 0) {
            throw new XAException(-3);
        }
        for (int i = 0; i < xid.length; ++i) {
            CUBRIDXidInfo xidInfo = new CUBRIDXidInfo(xid[i], null, 4);
            CUBRIDXidTable.putXidInfo(this.xacon_key, xidInfo);
        }
        ucon.close();
        return xid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        CUBRIDXidInfo xidInfo;
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.rollback()");
        }
        if ((xidInfo = CUBRIDXidTable.getXid(this.xacon_key, xid)) == null) {
            throw new XAException(-4);
        }
        CUBRIDXidInfo cUBRIDXidInfo = xidInfo;
        synchronized (cUBRIDXidInfo) {
            this.end_tran(xidInfo.ucon, xid, xidInfo.status, false);
            xidInfo.status = 5;
        }
        CUBRIDXidTable.removeXid(this.xacon_key, xid);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.setTransactionTimeout()");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int flags) throws XAException {
        if (this.debug_out != null) {
            this.debug_out.println("CUBRIDXAResource.start(" + xid + "," + flags + ")");
        }
        if (!this.checkXid(xid)) {
            throw new XAException(-5);
        }
        CUBRIDXidInfo xidInfo = CUBRIDXidTable.getXid(this.xacon_key, xid);
        if (flags == 0) {
            if (xidInfo != null) {
                throw new XAException(-8);
            }
            UConnection ucon = this.xacon.xa_start(flags, null);
            if (ucon == null) {
                throw new XAException(-3);
            }
            xidInfo = new CUBRIDXidInfo(xid, ucon, 1);
            CUBRIDXidTable.putXidInfo(this.xacon_key, xidInfo);
        } else if (flags == 0x200000 || flags == 0x8000000) {
            if (xidInfo == null) {
                throw new XAException(-4);
            }
            CUBRIDXidInfo cUBRIDXidInfo = xidInfo;
            synchronized (cUBRIDXidInfo) {
                if (xidInfo.status != 0 && xidInfo.status != 2) {
                    throw new XAException(-6);
                }
                if (this.xacon.xa_start(flags, xidInfo.ucon) == null) {
                    throw new XAException(-3);
                }
                xidInfo.status = 1;
            }
        } else {
            throw new XAException(-5);
        }
    }

    private boolean checkXid(Xid xid) {
        byte[] gid = xid.getGlobalTransactionId();
        byte[] bid = xid.getBranchQualifier();
        if (gid == null || gid.length == 0 || gid.length > 64) {
            return false;
        }
        return bid != null && bid.length != 0 && bid.length <= 64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void end_tran(UConnection ucon, Xid xid, int status, boolean type) throws XAException {
        if (ucon == null) {
            try {
                ucon = this.xacon.createUConnection();
            }
            catch (Exception e) {
                throw new XAException(-3);
            }
        }
        UConnection uConnection = ucon;
        synchronized (uConnection) {
            if (status == 4) {
                ucon.xa_endTransaction(xid, type);
            } else {
                ucon.endTransaction(type);
            }
            if (ucon.getRecentError().getErrorCode() != 0) {
                throw new XAException(-7);
            }
        }
        ucon = this.xacon.xa_end_tran(ucon);
        if (ucon != null) {
            uConnection = ucon;
            synchronized (uConnection) {
                ucon.close();
            }
        }
    }
}

