/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConnectionProperties {
    static ArrayList<Field> PROPERTY_LIST = new ArrayList();
    BooleanConnectionProperty logOnException = new BooleanConnectionProperty("logOnException", false);
    BooleanConnectionProperty logSlowQueries = new BooleanConnectionProperty("logSlowQueries", false);
    IntegerConnectionProperty slowQueryThresholdMillis = new IntegerConnectionProperty("slowQueryThresholdMillis", (Object)60000, 0, Integer.MAX_VALUE);
    StringConnectionProperty logFile = new StringConnectionProperty("logFile", "cubrid_jdbc.log");
    CharSetConnectionProperty charSet = new CharSetConnectionProperty("charSet", System.getProperty("file.encoding"));
    IntegerConnectionProperty rcTime = new IntegerConnectionProperty("rcTime", (Object)600, 0, Integer.MAX_VALUE);
    IntegerConnectionProperty queryTimeout = new IntegerConnectionProperty("queryTimeout", (Object)-1, -1, 2000000);
    IntegerConnectionProperty connectTimeout = new IntegerConnectionProperty("connectTimeout", (Object)this.getDefaultConnectTimeout(), -1, 2000000);
    StringConnectionProperty altHosts = new StringConnectionProperty("altHosts", null);
    BooleanConnectionProperty connLoadBal = new BooleanConnectionProperty("loadBalance", false);
    ZeroDateTimeBehaviorConnectionProperty zeroDateTimeBehavior = new ZeroDateTimeBehaviorConnectionProperty("zeroDateTimeBehavior", "exception");
    BooleanConnectionProperty useLazyConnection = new BooleanConnectionProperty("useLazyConnection", false);

    public void setProperties(String properties) throws SQLException {
        if (properties == null) {
            return;
        }
        Properties p = new Properties();
        StringTokenizer st = new StringTokenizer(properties, "?&;");
        while (st.hasMoreTokens()) {
            String prop = st.nextToken();
            StringTokenizer pt = new StringTokenizer(prop, "=");
            if (!pt.hasMoreTokens()) continue;
            String name = pt.nextToken().toLowerCase();
            if (!pt.hasMoreTokens()) continue;
            String value = pt.nextToken();
            p.put(name, value);
        }
        this.setProperties(p);
    }

    public void setProperties(Properties info) throws SQLException {
        if (info == null) {
            return;
        }
        int numProperties = PROPERTY_LIST.size();
        for (int i = 0; i < numProperties; ++i) {
            Field propertyField = PROPERTY_LIST.get(i);
            try {
                ConnectionProperty prop = (ConnectionProperty)propertyField.get(this);
                String propName = prop.getPropertyName().toLowerCase();
                String propValue = info.getProperty(propName);
                if (propValue == null) {
                    propName = prop.getPropertyName();
                    propValue = info.getProperty(propName);
                }
                if (propValue == null) continue;
                prop.setValue(propValue);
                continue;
            }
            catch (IllegalAccessException iae) {
                throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_url, " illegal access properties", null);
            }
        }
        if (this.getConnLoadBal() && this.getAltHosts() == null) {
            this.connLoadBal.setValue("false");
        }
        if (this.getReconnectTime() < 60) {
            this.rcTime.setValue(60);
        }
    }

    private int getDefaultConnectTimeout() {
        int timeout = DriverManager.getLoginTimeout();
        return timeout > 0 ? timeout : 30;
    }

    public boolean getLogOnException() {
        return this.logOnException.getValueAsBoolean();
    }

    public boolean getLogSlowQueris() {
        return this.logSlowQueries.getValueAsBoolean();
    }

    public int getSlowQueryThresholdMillis() {
        return this.slowQueryThresholdMillis.getValueAsInteger();
    }

    public String getLogFile() {
        return this.logFile.getValueAsString();
    }

    public String getCharSet() {
        return this.charSet.getValueAsString();
    }

    public int getReconnectTime() {
        return this.rcTime.getValueAsInteger();
    }

    public int getQueryTimeout() {
        return this.queryTimeout.getValueAsInteger();
    }

    public int getConnectTimeout() {
        return this.connectTimeout.getValueAsInteger();
    }

    public String getAltHosts() {
        return this.altHosts.getValueAsString();
    }

    public boolean getConnLoadBal() {
        return this.connLoadBal.getValueAsBoolean();
    }

    public String getZeroDateTimeBehavior() {
        return this.zeroDateTimeBehavior.getValueAsString();
    }

    public boolean getUseLazyConnection() {
        return this.useLazyConnection.getValueAsBoolean();
    }

    static {
        try {
            Field[] declaredFields = ConnectionProperties.class.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                if (!ConnectionProperty.class.isAssignableFrom(declaredFields[i].getType())) continue;
                PROPERTY_LIST.add(declaredFields[i]);
            }
        }
        catch (Exception e) {
            RuntimeException rtEx = new RuntimeException();
            rtEx.initCause(e);
            throw rtEx;
        }
    }

    class ZeroDateTimeBehaviorConnectionProperty
    extends StringConnectionProperty {
        ZeroDateTimeBehaviorConnectionProperty(String propertyName, Object defaultValue) {
            super(propertyName, defaultValue);
        }

        boolean validateValue(Object o) {
            String behavior;
            return o instanceof String && ((behavior = (String)o).equals("convertToNull") || behavior.equals("exception") || behavior.equals("round"));
        }
    }

    class CharSetConnectionProperty
    extends StringConnectionProperty {
        CharSetConnectionProperty(String propertyName, Object defaultValue) {
            super(propertyName, defaultValue);
        }

        String getValueAsString() {
            if (this.valueAsObject == null) {
                return System.getProperty("file.encoding");
            }
            return (String)this.valueAsObject;
        }

        boolean validateValue(Object o) {
            if (o instanceof String) {
                try {
                    byte[] s = new byte[]{0};
                    new String(s, (String)o);
                    return true;
                }
                catch (UnsupportedEncodingException e) {
                    return false;
                }
            }
            return false;
        }
    }

    class StringConnectionProperty
    extends ConnectionProperty {
        StringConnectionProperty(String propertyName, Object defaultValue) {
            super(propertyName, defaultValue, 0L, 0L);
        }

        String getValueAsString() {
            return (String)this.valueAsObject;
        }

        boolean validateValue(Object o) {
            return o != null;
        }
    }

    class LongConnectionProperty
    extends ConnectionProperty {
        LongConnectionProperty(String propertyName, Object defaultValue, long lowerBound, long upperBound) {
            super(propertyName, defaultValue, lowerBound, upperBound);
        }

        long getValueAsLong() {
            if (this.valueAsObject instanceof String) {
                this.valueAsObject = Long.valueOf((String)this.valueAsObject);
            }
            return (Long)this.valueAsObject;
        }

        boolean validateValue(Object o) {
            if (o instanceof Long || o instanceof Integer) {
                return true;
            }
            if (o instanceof String) {
                try {
                    Long.valueOf((String)o);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    class IntegerConnectionProperty
    extends ConnectionProperty {
        IntegerConnectionProperty(String propertyName, Object defaultValue, int lowerBound, int upperBound) {
            super(propertyName, defaultValue, lowerBound, upperBound);
        }

        int getValueAsInteger() {
            if (this.valueAsObject instanceof String) {
                this.valueAsObject = Integer.valueOf((String)this.valueAsObject);
            }
            return (Integer)this.valueAsObject;
        }

        boolean validateValue(Object o) {
            long value;
            if (o instanceof Integer) {
                value = ((Integer)o).intValue();
            } else if (o instanceof String) {
                try {
                    value = Integer.valueOf((String)o).intValue();
                }
                catch (NumberFormatException e) {
                    return false;
                }
            } else {
                return false;
            }
            return value >= this.lowerBound && value <= this.upperBound;
        }
    }

    class BooleanConnectionProperty
    extends ConnectionProperty {
        String[] allowableValues;

        BooleanConnectionProperty(String propertyName, Object defaultValue) {
            super(propertyName, defaultValue, 0L, 0L);
            this.allowableValues = new String[]{"true", "false", "yes", "no", "on", "off"};
        }

        boolean getValueAsBoolean() {
            if (this.valueAsObject instanceof String) {
                this.valueAsObject = Boolean.valueOf((String)this.valueAsObject);
            }
            return (Boolean)this.valueAsObject;
        }

        boolean validateValue(Object o) {
            if (o instanceof Boolean) {
                return true;
            }
            if (o instanceof String) {
                for (int i = 0; i < this.allowableValues.length; ++i) {
                    if (!this.allowableValues[i].equalsIgnoreCase((String)o)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    abstract class ConnectionProperty {
        String propertyName;
        Object defaultValue;
        Object valueAsObject;
        long lowerBound;
        long upperBound;

        public ConnectionProperty() {
        }

        ConnectionProperty(String propertyName, Object defaultValue, long lowerBound, long upperBound) {
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
            this.valueAsObject = defaultValue;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        abstract boolean validateValue(Object var1);

        Object getValueAsObject() {
            return this.valueAsObject;
        }

        void setValue(Object o) throws SQLException {
            if (!this.validateValue(o)) {
                throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_url, " '" + o + "' uncompitable value for the " + this.propertyName, null);
            }
            this.valueAsObject = o;
        }

        String getPropertyName() {
            return this.propertyName;
        }
    }
}

