/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.jci.UJciException;
import cubrid.jdbc.jci.UUType;
import cubrid.sql.CUBRIDOID;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

class CUBRIDArray {
    private byte baseType;
    private int length;
    private Object[] internalArray;

    CUBRIDArray(byte type, int arrayLength) throws UJciException {
        this.baseType = type;
        this.length = arrayLength;
        if (this.length < 0) {
            return;
        }
        switch (type) {
            case 5: 
            case 6: {
                this.internalArray = (Object[])new byte[this.length][];
                break;
            }
            case 9: 
            case 26: {
                this.internalArray = new Short[this.length];
                break;
            }
            case 8: 
            case 27: {
                this.internalArray = new Integer[this.length];
                break;
            }
            case 21: 
            case 28: {
                this.internalArray = new Long[this.length];
                break;
            }
            case 11: {
                this.internalArray = new Float[this.length];
                break;
            }
            case 10: 
            case 12: {
                this.internalArray = new Double[this.length];
                break;
            }
            case 7: {
                this.internalArray = new BigDecimal[this.length];
                break;
            }
            case 13: {
                this.internalArray = new Date[this.length];
                break;
            }
            case 14: {
                this.internalArray = new Time[this.length];
                break;
            }
            case 15: 
            case 22: {
                this.internalArray = new Timestamp[this.length];
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 25: {
                this.internalArray = new String[this.length];
                break;
            }
            case 19: {
                this.internalArray = new CUBRIDOID[this.length];
                break;
            }
            case 23: {
                this.internalArray = new Blob[this.length];
                break;
            }
            case 24: {
                this.internalArray = new Clob[this.length];
                break;
            }
            case 0: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                this.baseType = 0;
                this.internalArray = new Object[this.length];
                break;
            }
            default: {
                throw new UJciException(-21005);
            }
        }
    }

    CUBRIDArray(Object values) throws UJciException {
        this.baseType = values instanceof Object[] && ((Object[])values).length == 0 ? (byte)19 : UUType.getObjArrBaseDBtype(values);
        if (this.baseType == 0) {
            throw new UJciException(-21016);
        }
        this.internalArray = (Object[])((Object[])values).clone();
        this.length = ((Object[])values).length;
    }

    Object getArray() {
        return this.internalArray;
    }

    Object getArrayClone() {
        Object[] obj;
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (this.internalArray == null) {
                            return null;
                        }
                        obj = (Object[])this.internalArray.clone();
                        if (!(obj instanceof Date[])) break block5;
                        for (int i = 0; i < obj.length; ++i) {
                            if (obj[i] == null) continue;
                            obj[i] = ((Date)obj[i]).clone();
                        }
                        break block6;
                    }
                    if (!(obj instanceof Time[])) break block7;
                    for (int i = 0; i < obj.length; ++i) {
                        if (obj[i] == null) continue;
                        obj[i] = ((Time)obj[i]).clone();
                    }
                    break block6;
                }
                if (!(obj instanceof Timestamp[])) break block8;
                for (int i = 0; i < obj.length; ++i) {
                    if (obj[i] == null) continue;
                    obj[i] = ((Timestamp)obj[i]).clone();
                }
                break block6;
            }
            if (!(obj instanceof byte[][])) break block6;
            for (int i = 0; i < obj.length; ++i) {
                if (obj[i] == null) continue;
                obj[i] = ((byte[])obj[i]).clone();
            }
        }
        return obj;
    }

    int getBaseType() {
        return this.baseType;
    }

    int getLength() {
        return this.length;
    }

    synchronized void setElement(int index, Object data) {
        this.internalArray[index] = data;
    }
}

