/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.jci.UJciException;

public class UColumnInfo {
    private byte type;
    private byte collectionBaseType;
    private short scale;
    private int precision;
    private String name;
    private String className;
    private String attributeName;
    private boolean isNullable;
    private String defaultValue;
    private byte is_auto_increment;
    private byte is_unique_key;
    private byte is_primary_key;
    private byte is_foreign_key;
    private byte is_reverse_index;
    private byte is_reverse_unique;
    private byte is_shared;

    UColumnInfo(byte cType, short cScale, int cPrecision, String cName) throws UJciException {
        byte[] realType = UColumnInfo.confirmType(cType);
        this.type = realType[0];
        this.collectionBaseType = realType[1];
        this.scale = cScale;
        this.precision = cPrecision;
        this.name = cName;
        this.className = null;
        this.attributeName = null;
        this.isNullable = false;
        this.defaultValue = null;
        this.is_auto_increment = 0;
        this.is_unique_key = 0;
        this.is_primary_key = 0;
        this.is_foreign_key = 0;
        this.is_reverse_index = 0;
        this.is_reverse_unique = 0;
        this.is_shared = 0;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public byte getIsAutoIncrement() {
        return this.is_auto_increment;
    }

    public byte getIsUniqueKey() {
        return this.is_unique_key;
    }

    public byte getIsPrimaryKey() {
        return this.is_primary_key;
    }

    public byte getIsForeignKey() {
        return this.is_foreign_key;
    }

    public byte getIsReverseIndex() {
        return this.is_reverse_index;
    }

    public byte getIsReverseUnique() {
        return this.is_reverse_unique;
    }

    public byte getIsShared() {
        return this.is_shared;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public String getClassName() {
        return this.className;
    }

    public int getCollectionBaseType() {
        return this.collectionBaseType;
    }

    public String getColumnName() {
        return this.name;
    }

    public int getColumnPrecision() {
        return this.precision;
    }

    public int getColumnScale() {
        return this.scale;
    }

    public byte getColumnType() {
        return this.type;
    }

    public String getFQDN() {
        return this.findFQDN(this.type, this.precision, this.collectionBaseType);
    }

    public String getRealColumnName() {
        return this.attributeName;
    }

    static byte[] confirmType(byte originalType) throws UJciException {
        int collectionTypeOrNot = 0;
        byte[] typeInfo = new byte[2];
        collectionTypeOrNot = originalType & 0x60;
        switch (collectionTypeOrNot) {
            case 0: {
                typeInfo[0] = originalType;
                typeInfo[1] = -1;
                return typeInfo;
            }
            case 32: {
                typeInfo[0] = 16;
                typeInfo[1] = (byte)(originalType & 0x1F);
                if (typeInfo[1] < 0 || typeInfo[1] > 28) {
                    throw new UJciException(-21005);
                }
                return typeInfo;
            }
            case 64: {
                typeInfo[0] = 17;
                typeInfo[1] = (byte)(originalType & 0x1F);
                if (typeInfo[1] < 0 || typeInfo[1] > 28) {
                    throw new UJciException(-21005);
                }
                return typeInfo;
            }
            case 96: {
                typeInfo[0] = 18;
                typeInfo[1] = (byte)(originalType & 0x1F);
                if (typeInfo[1] < 0 || typeInfo[1] > 28) {
                    throw new UJciException(-21005);
                }
                return typeInfo;
            }
        }
        typeInfo[0] = 0;
        typeInfo[1] = -1;
        return typeInfo;
    }

    synchronized void setRemainedData(String aName, String cName, boolean hNull) {
        this.attributeName = aName;
        this.className = cName;
        this.isNullable = hNull;
    }

    synchronized void setExtraData(String defValue, byte bAI, byte bUK, byte bPK, byte bFK, byte bRI, byte bRU, byte sh) {
        this.defaultValue = defValue;
        this.is_auto_increment = bAI;
        this.is_unique_key = bUK;
        this.is_primary_key = bPK;
        this.is_foreign_key = bFK;
        this.is_reverse_index = bRI;
        this.is_reverse_unique = bRU;
        this.is_shared = sh;
    }

    private String findFQDN(byte cType, int cPrecision, byte cBaseType) {
        switch (cType) {
            case 0: {
                return "null";
            }
            case 5: {
                return cPrecision == 8 ? "java.lang.Boolean" : "byte[]";
            }
            case 6: {
                return "byte[]";
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 25: {
                return "java.lang.String";
            }
            case 7: {
                return "java.math.BigDecimal";
            }
            case 9: 
            case 26: {
                return "java.lang.Short";
            }
            case 8: 
            case 27: {
                return "java.lang.Integer";
            }
            case 21: 
            case 28: {
                return "java.lang.Long";
            }
            case 11: {
                return "java.lang.Float";
            }
            case 10: 
            case 12: {
                return "java.lang.Double";
            }
            case 13: {
                return "java.sql.Date";
            }
            case 14: {
                return "java.sql.Time";
            }
            case 15: 
            case 22: {
                return "java.sql.Timestamp";
            }
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 19: {
                return "cubrid.sql.CUBRIDOID";
            }
            case 23: {
                return "java.sql.Blob";
            }
            case 24: {
                return "java.sql.Clob";
            }
            default: {
                return "";
            }
        }
        switch (cBaseType) {
            case 0: {
                return "null";
            }
            case 5: {
                return cPrecision == 8 ? "java.lang.Boolean[]" : "byte[][]";
            }
            case 6: {
                return "byte[][]";
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 25: {
                return "java.lang.String[]";
            }
            case 7: {
                return "java.lang.Double[]";
            }
            case 9: 
            case 26: {
                return "java.lang.Short[]";
            }
            case 8: 
            case 27: {
                return "java.lang.Integer[]";
            }
            case 21: 
            case 28: {
                return "java.lang.Long[]";
            }
            case 11: {
                return "java.lang.Float[]";
            }
            case 10: 
            case 12: {
                return "java.lang.Double[]";
            }
            case 13: {
                return "java.sql.Date[]";
            }
            case 14: {
                return "java.sql.Time[]";
            }
            case 15: 
            case 22: {
                return "java.sql.Timestamp[]";
            }
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 19: {
                return "cubrid.sql.CUBRIDOID[]";
            }
            case 23: {
                return "java.sql.Blob[]";
            }
            case 24: {
                return "java.sql.Clob[]";
            }
        }
        return null;
    }
}

