/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UErrorCode;

public class UError {
    public static final int METHOD_USER_ERROR_BASE = -100000;
    private UConnection connection = null;
    private int jciErrorCode;
    private int serverErrorCode;
    private String errorMessage;
    private StackTraceElement[] stackTrace;

    UError(UConnection c) {
        this.connection = c;
        this.jciErrorCode = 0;
    }

    public UError(UError src) {
        this.copyValue(src);
    }

    public int getErrorCode() {
        return this.jciErrorCode;
    }

    private int getSessionNumber(byte[] session) {
        byte ch1 = session[8];
        byte ch2 = session[9];
        byte ch3 = session[10];
        byte ch4 = session[11];
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public String getErrorMsg(boolean include_con_info) {
        if (this.connection != null && include_con_info) {
            String sessionInfo = "";
            sessionInfo = this.connection.protoVersionIsAbove(3) ? String.format("[SESSION-%d],", this.getSessionNumber(this.connection.sessionId)) : String.format("[SESSION-%d],", this.connection.oldSessionId);
            String infoType = "";
            if (this.connection.isConnectedToProxy()) {
                sessionInfo = "";
                infoType = "PROXY INFO";
            } else {
                infoType = "CAS INFO";
            }
            if (this.connection.protoVersionIsAbove(4)) {
                return String.format("%s[%s-%s:%d,%d,%d],%s[URL-%s].", this.errorMessage, infoType, this.connection.CASIp, this.connection.CASPort, this.connection.casId, this.connection.processId, sessionInfo, this.connection.url);
            }
            return String.format("%s[%s-%s:%d,%d],%s[URL-%s].", this.errorMessage, infoType, this.connection.CASIp, this.connection.CASPort, this.connection.processId, sessionInfo, this.connection.url);
        }
        return this.errorMessage;
    }

    public int getJdbcErrorCode() {
        if (this.jciErrorCode == 0) {
            return 0;
        }
        if (this.jciErrorCode == -21002) {
            return this.serverErrorCode;
        }
        return this.jciErrorCode;
    }

    void copyValue(UError object) {
        this.connection = object.connection;
        this.jciErrorCode = object.jciErrorCode;
        this.errorMessage = object.errorMessage;
        this.serverErrorCode = object.serverErrorCode;
        this.stackTrace = object.stackTrace;
    }

    synchronized void setDBError(int code, String message) {
        this.jciErrorCode = -21002;
        this.serverErrorCode = code;
        this.errorMessage = message;
    }

    synchronized void setErrorCode(int code) {
        this.jciErrorCode = code;
        if (code != 0) {
            this.errorMessage = UErrorCode.codeToMessage(code);
        }
    }

    void setErrorMessage(int code, String addMessage) {
        this.setErrorCode(code);
        this.errorMessage = this.errorMessage + ":" + addMessage;
    }

    void clear() {
        this.jciErrorCode = 0;
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void changeStackTrace(Throwable t) {
        if (this.stackTrace != null) {
            t.setStackTrace(this.stackTrace);
        }
    }
}

