/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.driver.CUBRIDBlob;
import cubrid.jdbc.driver.CUBRIDClob;
import cubrid.jdbc.driver.CUBRIDLobHandle;
import cubrid.jdbc.jci.CUBRIDArray;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UGetTypeConvertedValue;
import cubrid.jdbc.jci.UJciException;
import cubrid.jdbc.jci.UStatementCacheData;
import cubrid.jdbc.util.ByteArrayBuffer;
import cubrid.sql.CUBRIDOID;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.transaction.xa.Xid;

class UOutputBuffer {
    private UConnection u_con;
    private OutputStream output;
    private ByteArrayBuffer dataBuffer;
    private Calendar c = Calendar.getInstance();

    UOutputBuffer(UConnection ucon) throws IOException {
        this.u_con = ucon;
        this.output = this.u_con.getOutputStream();
        this.dataBuffer = new ByteArrayBuffer();
    }

    private void initBuffer() throws IOException {
        this.dataBuffer.reset();
    }

    void sendData() throws IOException {
        this.dataBuffer.writeToStream(this.u_con.getCASInfo(), this.output);
        this.initBuffer();
    }

    void newRequest(OutputStream out, byte func_code) throws IOException {
        this.output = out;
        this.initBuffer();
        this.dataBuffer.writeByte(func_code);
    }

    void newRequest(byte func_code) throws IOException {
        this.output = this.u_con.getOutputStream();
        this.initBuffer();
        this.dataBuffer.writeByte(func_code);
    }

    int addInt(int intValue) throws IOException {
        this.dataBuffer.writeInt(4);
        this.dataBuffer.writeInt(intValue);
        return 8;
    }

    int addLong(long longValue) throws IOException {
        this.dataBuffer.writeInt(8);
        this.dataBuffer.writeLong(longValue);
        return 12;
    }

    int addByte(byte bValue) throws IOException {
        this.dataBuffer.writeInt(1);
        this.dataBuffer.writeByte(bValue);
        return 5;
    }

    int addBytes(byte[] value) throws IOException {
        return this.addBytes(value, 0, value.length);
    }

    int addBytes(byte[] value, int offset, int len) throws IOException {
        this.dataBuffer.writeInt(len);
        this.dataBuffer.write(value, offset, len);
        return len + 4;
    }

    int addNull() throws IOException {
        this.dataBuffer.writeInt(0);
        return 4;
    }

    int addStringWithNull(String str) throws IOException {
        byte[] b;
        try {
            b = str.getBytes(this.u_con.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            b = str.getBytes();
        }
        this.dataBuffer.writeInt(b.length + 1);
        this.dataBuffer.write(b, 0, b.length);
        this.dataBuffer.writeByte((byte)0);
        return b.length + 5;
    }

    int addDouble(double value) throws IOException {
        this.dataBuffer.writeInt(8);
        this.dataBuffer.writeDouble(value);
        return 12;
    }

    int addShort(short value) throws IOException {
        this.dataBuffer.writeInt(2);
        this.dataBuffer.writeShort(value);
        return 6;
    }

    int addFloat(float value) throws IOException {
        this.dataBuffer.writeInt(4);
        this.dataBuffer.writeFloat(value);
        return 8;
    }

    int addDate(Date value) throws IOException {
        this.dataBuffer.writeInt(14);
        this.writeDate(value);
        return 18;
    }

    private void writeDate(Date date) throws IOException {
        this.c.setTime(date);
        this.dataBuffer.writeShort(this.c.get(1));
        this.dataBuffer.writeShort(this.c.get(2) + 1);
        this.dataBuffer.writeShort(this.c.get(5));
        this.dataBuffer.writeShort(0);
        this.dataBuffer.writeShort(0);
        this.dataBuffer.writeShort(0);
        this.dataBuffer.writeShort(0);
    }

    int addTime(Time value) throws IOException {
        this.dataBuffer.writeInt(14);
        this.writeTime(value);
        return 18;
    }

    private void writeTime(Time date) throws IOException {
        this.c.setTime(date);
        this.dataBuffer.writeShort(0);
        this.dataBuffer.writeShort(0);
        this.dataBuffer.writeShort(0);
        this.dataBuffer.writeShort(this.c.get(11));
        this.dataBuffer.writeShort(this.c.get(12));
        this.dataBuffer.writeShort(this.c.get(13));
        this.dataBuffer.writeShort(0);
    }

    int addTimestamp(Timestamp value) throws IOException {
        this.dataBuffer.writeInt(14);
        this.writeTimestamp(value, false);
        return 18;
    }

    private void writeTimestamp(Timestamp date, boolean withMili) throws IOException {
        this.c.setTime(date);
        this.dataBuffer.writeShort(this.c.get(1));
        this.dataBuffer.writeShort(this.c.get(2) + 1);
        this.dataBuffer.writeShort(this.c.get(5));
        this.dataBuffer.writeShort(this.c.get(11));
        this.dataBuffer.writeShort(this.c.get(12));
        this.dataBuffer.writeShort(this.c.get(13));
        if (withMili) {
            this.dataBuffer.writeShort(this.c.get(14));
        } else {
            this.dataBuffer.writeShort(0);
        }
    }

    int addDatetime(Timestamp value) throws IOException {
        this.dataBuffer.writeInt(14);
        this.writeTimestamp(value, true);
        return 18;
    }

    int addOID(CUBRIDOID value) throws IOException {
        byte[] b = value.getOID();
        if (b == null || b.length != 8) {
            b = new byte[8];
        }
        this.dataBuffer.writeInt(8);
        this.dataBuffer.write(b, 0, b.length);
        return 12;
    }

    int addXid(Xid xid) throws IOException {
        byte[] gid = xid.getGlobalTransactionId();
        byte[] bid = xid.getBranchQualifier();
        int msgSize = 12 + gid.length + bid.length;
        this.dataBuffer.writeInt(msgSize);
        this.dataBuffer.writeInt(xid.getFormatId());
        this.dataBuffer.writeInt(gid.length);
        this.dataBuffer.writeInt(bid.length);
        this.dataBuffer.write(gid, 0, gid.length);
        this.dataBuffer.write(bid, 0, bid.length);
        return msgSize + 4;
    }

    int addCacheTime(UStatementCacheData cache_data) throws IOException {
        int sec;
        int usec;
        if (cache_data == null) {
            usec = 0;
            sec = 0;
        } else {
            sec = (int)(cache_data.srvCacheTime >>> 32);
            usec = (int)cache_data.srvCacheTime;
        }
        this.dataBuffer.writeInt(8);
        this.dataBuffer.writeInt(sec);
        this.dataBuffer.writeInt(usec);
        return 12;
    }

    int addBlob(CUBRIDBlob value) throws IOException {
        return this.addLob(value.getLobHandle());
    }

    int addClob(CUBRIDClob value) throws IOException {
        return this.addLob(value.getLobHandle());
    }

    private int addLob(CUBRIDLobHandle lobHandle) throws IOException {
        byte[] packedLobHandle = lobHandle.getPackedLobHandle();
        this.dataBuffer.writeInt(packedLobHandle.length);
        this.dataBuffer.write(packedLobHandle, 0, packedLobHandle.length);
        return packedLobHandle.length + 4;
    }

    int writeParameter(byte type, Object value, boolean setDefaultValue) throws UJciException, IOException {
        if (!setDefaultValue && value == null) {
            return this.addNull();
        }
        switch (type) {
            case 0: {
                return this.addNull();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 25: {
                String stringData = value == null ? "" : UGetTypeConvertedValue.getString(value);
                return this.addStringWithNull(stringData);
            }
            case 7: {
                String stringData = value == null ? "" : UGetTypeConvertedValue.getString(value);
                return this.addStringWithNull(stringData);
            }
            case 5: 
            case 6: {
                if (value == null) {
                    return this.addByte((byte)0);
                }
                if (value instanceof byte[] && ((byte[])value).length > 1) {
                    return this.addBytes(UGetTypeConvertedValue.getBytes(value));
                }
                return this.addByte(UGetTypeConvertedValue.getByte(value));
            }
            case 10: 
            case 12: {
                if (value == null) {
                    return this.addDouble(0.0);
                }
                return this.addDouble(UGetTypeConvertedValue.getDouble(value));
            }
            case 13: {
                if (value == null) {
                    return this.addDate(UGetTypeConvertedValue.getDate(new Timestamp(0L)));
                }
                return this.addDate(UGetTypeConvertedValue.getDate(value));
            }
            case 14: {
                if (value == null) {
                    return this.addTime(UGetTypeConvertedValue.getTime(new Timestamp(0L)));
                }
                return this.addTime(UGetTypeConvertedValue.getTime(value));
            }
            case 15: {
                if (value == null) {
                    return this.addTimestamp(UGetTypeConvertedValue.getTimestamp(new Timestamp(0L)));
                }
                return this.addTimestamp(UGetTypeConvertedValue.getTimestamp(value));
            }
            case 22: {
                if (value == null) {
                    return this.addDatetime(UGetTypeConvertedValue.getTimestamp(new Timestamp(0L)));
                }
                return this.addDatetime(UGetTypeConvertedValue.getTimestamp(value));
            }
            case 11: {
                if (value == null) {
                    return this.addFloat(UGetTypeConvertedValue.getFloat(0));
                }
                return this.addFloat(UGetTypeConvertedValue.getFloat(value));
            }
            case 9: 
            case 26: {
                if (value == null) {
                    return this.addShort(UGetTypeConvertedValue.getShort(0));
                }
                return this.addShort(UGetTypeConvertedValue.getShort(value));
            }
            case 8: 
            case 27: {
                if (value == null) {
                    return this.addInt(UGetTypeConvertedValue.getInt(0));
                }
                return this.addInt(UGetTypeConvertedValue.getInt(value));
            }
            case 21: 
            case 28: {
                if (value == null) {
                    return this.addLong(UGetTypeConvertedValue.getLong(0));
                }
                return this.addLong(UGetTypeConvertedValue.getLong(value));
            }
            case 16: 
            case 17: 
            case 18: {
                if (value == null) {
                    return this.addNull();
                }
                if (!(value instanceof CUBRIDArray)) {
                    throw this.u_con.createJciException(-21005);
                }
                return this.writeCollection((CUBRIDArray)value, setDefaultValue);
            }
            case 19: {
                if (value == null) {
                    return this.addNull();
                }
                if (!(value instanceof CUBRIDOID)) {
                    throw this.u_con.createJciException(-21005);
                }
                return this.addOID((CUBRIDOID)value);
            }
            case 23: {
                if (value == null) {
                    return this.addNull();
                }
                if (!(value instanceof CUBRIDBlob)) {
                    throw this.u_con.createJciException(-21005);
                }
                return this.addBlob((CUBRIDBlob)value);
            }
            case 24: {
                if (value == null) {
                    return this.addNull();
                }
                if (!(value instanceof CUBRIDClob)) {
                    throw this.u_con.createJciException(-21005);
                }
                return this.addClob((CUBRIDClob)value);
            }
            case 20: {
                return this.addNull();
            }
        }
        throw this.u_con.createJciException(-21005);
    }

    private int writeCollection(CUBRIDArray data, boolean setDefaultValue) throws UJciException, IOException {
        Object[] values = (Object[])data.getArray();
        if (values == null) {
            this.dataBuffer.writeInt(1);
            this.dataBuffer.writeByte((byte)data.getBaseType());
            return 5;
        }
        int collection_size = 1;
        ByteArrayBuffer saveBuffer = this.dataBuffer;
        this.dataBuffer = new ByteArrayBuffer();
        this.dataBuffer.writeByte((byte)data.getBaseType());
        switch (data.getBaseType()) {
            case 5: 
            case 6: {
                int i;
                Object byteValues = null;
                if (values instanceof byte[][]) {
                    byteValues = (byte[][])values;
                } else if (values instanceof Boolean[]) {
                    byteValues = new byte[values.length][];
                    for (i = 0; i < ((byte[][])byteValues).length; ++i) {
                        if (((Boolean[])values)[i] != null) {
                            byteValues[i] = new byte[1];
                            byteValues[i][0] = ((Boolean[])values)[i] == true ? (byte)1 : 0;
                            continue;
                        }
                        byteValues[i] = null;
                    }
                }
                for (i = 0; byteValues != null && i < ((byte[][])byteValues).length; ++i) {
                    if (byteValues[i] == null) {
                        collection_size += this.addNull();
                        continue;
                    }
                    collection_size += this.addBytes(byteValues[i]);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null) {
                        collection_size += this.addNull();
                        continue;
                    }
                    collection_size += this.addStringWithNull(UGetTypeConvertedValue.getString(values[i]));
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null) {
                        collection_size += this.addNull();
                        continue;
                    }
                    collection_size += this.writeParameter((byte)data.getBaseType(), values[i], setDefaultValue);
                }
                break;
            }
            default: {
                for (int i = 0; i < values.length; ++i) {
                    collection_size += this.addNull();
                }
            }
        }
        saveBuffer.merge(collection_size, this.dataBuffer);
        this.dataBuffer = saveBuffer;
        return collection_size + 4;
    }
}

