/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.driver.CUBRIDBlob;
import cubrid.jdbc.driver.CUBRIDClob;
import cubrid.jdbc.driver.CUBRIDOutResultSet;
import cubrid.jdbc.jci.CUBRIDArray;
import cubrid.jdbc.jci.UBatchResult;
import cubrid.jdbc.jci.UBindKey;
import cubrid.jdbc.jci.UBindParameter;
import cubrid.jdbc.jci.UColumnInfo;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UError;
import cubrid.jdbc.jci.UGetTypeConvertedValue;
import cubrid.jdbc.jci.UInputBuffer;
import cubrid.jdbc.jci.UJCIManager;
import cubrid.jdbc.jci.UJciException;
import cubrid.jdbc.jci.UOutputBuffer;
import cubrid.jdbc.jci.UResCache;
import cubrid.jdbc.jci.UResultInfo;
import cubrid.jdbc.jci.UResultTuple;
import cubrid.jdbc.jci.UStatementCacheData;
import cubrid.jdbc.jci.UStmtCache;
import cubrid.jdbc.jci.UUType;
import cubrid.jdbc.jci.UUpdateParameter;
import cubrid.jdbc.jci.UUrlCache;
import cubrid.sql.CUBRIDOID;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UStatement {
    public static final int CURSOR_SET = 0;
    public static final int CURSOR_CUR = 1;
    public static final int CURSOR_END = 2;
    public static final byte QUERY_INFO_PLAN = 1;
    private static final byte ASYNC_EXECUTE = 1;
    private static final byte NORMAL = 0;
    private static final byte GET_BY_OID = 1;
    private static final byte GET_SCHEMA_INFO = 2;
    private static final byte GET_AUTOINCREMENT_KEYS = 3;
    private static final byte TRUE = -128;
    private static final byte FALSE = 0;
    private static final int DEFAULT_FETCH_SIZE = 100;
    private static final byte EXEC_FLAG_ASYNC = 1;
    private static final byte EXEC_FLAG_QUERY_ALL = 2;
    private static final byte EXEC_FLAG_QUERY_INFO = 4;
    private static final byte EXEC_FLAG_ONLY_QUERY_PLAN = 8;
    private static final byte EXEC_FLAG_HOLDABLE_RESULT = 32;
    private static final byte EXEC_FLAG_GET_GENERATED_KEYS = 64;
    private byte statementType;
    private UConnection relatedConnection;
    private boolean isClosed;
    private boolean realFetched;
    private boolean isUpdatable;
    private boolean isSensitive;
    private int serverHandler;
    private int parameterNumber;
    private int columnNumber;
    private UBindParameter bindParameter;
    private ArrayList<UBindParameter> batchParameter;
    private UColumnInfo[] columnInfo;
    private HashMap<String, Integer> colNameToIndex;
    private UResultInfo[] resultInfo;
    private byte commandTypeIs;
    private byte firstStmtType;
    private byte executeFlag;
    private int fetchDirection;
    private int fetchSize;
    private int maxFetchSize;
    private int fetchedTupleNumber;
    private boolean isFetchCompleted;
    private int totalTupleNumber;
    private int currentFirstCursor;
    private int cursorPosition;
    private int executeResult;
    private UResultTuple[] tuples;
    private int numQueriesExecuted;
    private UError errorHandler;
    private UOutputBuffer outBuffer;
    private int schemaType;
    private boolean isReturnable = false;
    private String sql_stmt;
    private byte prepare_flag;
    private UInputBuffer tmp_inbuffer;
    private boolean isAutoCommit = false;
    private boolean isGeneratedKeys = false;
    public int result_cache_lifetime;
    private boolean result_cacheable = false;
    private UStmtCache stmt_cache;

    UStatement(UConnection relatedC, UInputBuffer inBuffer, boolean assign_only, String sql, byte _prepare_flag) throws UJciException {
        this.errorHandler = new UError(relatedC);
        if (assign_only) {
            this.relatedConnection = relatedC;
            this.tmp_inbuffer = inBuffer;
            this.sql_stmt = sql;
            this.prepare_flag = _prepare_flag;
        } else {
            this.init(relatedC, inBuffer, sql, _prepare_flag, true);
        }
        if (this.result_cacheable && (this.prepare_flag & 1) == 0 && (this.prepare_flag & 2) == 0) {
            UUrlCache url_cache = relatedC.getUrlCache();
            this.stmt_cache = url_cache.getStmtCache(sql);
        }
    }

    private void init(UConnection relatedC, UInputBuffer inBuffer, String sql, byte _prepare_flag, boolean clear_bind_info) throws UJciException {
        this.sql_stmt = sql;
        this.prepare_flag = _prepare_flag;
        this.outBuffer = relatedC.outBuffer;
        this.statementType = 0;
        this.relatedConnection = relatedC;
        this.serverHandler = inBuffer.getResCode();
        this.result_cache_lifetime = inBuffer.readInt();
        if (this.result_cache_lifetime >= 0 && UJCIManager.result_cache_enable) {
            this.result_cacheable = true;
        }
        this.firstStmtType = this.commandTypeIs = inBuffer.readByte();
        this.parameterNumber = inBuffer.readInt();
        this.isUpdatable = inBuffer.readByte() == 1;
        this.columnNumber = inBuffer.readInt();
        this.readColumnInfo(inBuffer);
        if (clear_bind_info) {
            this.bindParameter = this.parameterNumber > 0 ? new UBindParameter(this.parameterNumber, this.relatedConnection.getDbmsType()) : null;
            this.batchParameter = null;
        }
        this.fetchSize = 100;
        this.isFetchCompleted = false;
        this.fetchedTupleNumber = 0;
        this.totalTupleNumber = 0;
        this.cursorPosition = 0;
        this.currentFirstCursor = 0;
        this.maxFetchSize = 0;
        this.realFetched = false;
        this.isClosed = false;
        if (this.commandTypeIs == 126) {
            this.columnNumber = this.parameterNumber + 1;
        }
    }

    UStatement(UConnection relatedC, CUBRIDOID oid, String[] attributeName, UInputBuffer inBuffer) throws UJciException {
        this.outBuffer = relatedC.outBuffer;
        this.statementType = 1;
        this.relatedConnection = relatedC;
        this.errorHandler = new UError(this.relatedConnection);
        this.serverHandler = -1;
        inBuffer.readString(inBuffer.readInt(), this.relatedConnection.getCharset());
        this.columnNumber = inBuffer.readInt();
        this.readColumnInfo(inBuffer);
        this.fetchSize = 1;
        this.tuples = new UResultTuple[this.fetchSize];
        this.readATupleByOid(oid, inBuffer);
        this.bindParameter = null;
        this.batchParameter = null;
        this.fetchedTupleNumber = 1;
        this.totalTupleNumber = 1;
        this.executeResult = 1;
        this.cursorPosition = 0;
        this.currentFirstCursor = 0;
        this.maxFetchSize = 0;
        this.realFetched = false;
        this.isUpdatable = false;
        this.isClosed = false;
    }

    UStatement(UConnection relatedC, String cName, String attributePattern, int type, UInputBuffer inBuffer) throws UJciException {
        this.outBuffer = relatedC.outBuffer;
        this.statementType = (byte)2;
        this.relatedConnection = relatedC;
        this.schemaType = type;
        this.errorHandler = new UError(this.relatedConnection);
        this.serverHandler = inBuffer.getResCode();
        this.totalTupleNumber = inBuffer.readInt();
        this.columnNumber = inBuffer.readInt();
        this.readColumnInfo(inBuffer);
        this.fetchSize = 100;
        this.fetchedTupleNumber = 0;
        this.cursorPosition = 0;
        this.currentFirstCursor = 0;
        this.bindParameter = null;
        this.batchParameter = null;
        this.maxFetchSize = 0;
        this.realFetched = false;
        this.isUpdatable = false;
        this.isClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UStatement(UConnection u_con, int srv_handle) throws UJciException, IOException {
        UInputBuffer inBuffer;
        this.relatedConnection = u_con;
        this.outBuffer = u_con.outBuffer;
        this.statementType = 0;
        this.errorHandler = new UError(this.relatedConnection);
        this.bindParameter = null;
        this.fetchSize = 100;
        this.fetchedTupleNumber = 0;
        this.totalTupleNumber = 0;
        this.cursorPosition = 0;
        this.currentFirstCursor = 0;
        this.maxFetchSize = 0;
        this.realFetched = false;
        this.isClosed = false;
        UConnection uConnection = u_con;
        synchronized (uConnection) {
            this.outBuffer.newRequest((byte)33);
            this.outBuffer.addInt(srv_handle);
            inBuffer = u_con.send_recv_msg();
        }
        this.serverHandler = inBuffer.readInt();
        this.commandTypeIs = inBuffer.readByte();
        this.totalTupleNumber = inBuffer.readInt();
        this.isUpdatable = inBuffer.readByte() == 1;
        this.columnNumber = inBuffer.readInt();
        this.readColumnInfo(inBuffer);
        this.executeResult = this.totalTupleNumber;
    }

    public UStatement(UStatement u_stmt) {
        this.serverHandler = u_stmt.serverHandler;
        this.relatedConnection = u_stmt.relatedConnection;
        this.outBuffer = u_stmt.outBuffer;
        this.statementType = 0;
        this.errorHandler = new UError(this.relatedConnection);
        this.bindParameter = null;
        this.fetchSize = 100;
        this.fetchedTupleNumber = 0;
        this.totalTupleNumber = 0;
        this.cursorPosition = 0;
        this.currentFirstCursor = 0;
        this.maxFetchSize = 0;
        this.realFetched = false;
        this.isClosed = false;
    }

    public UResCache getResCache() {
        UBindKey key = this.bindParameter == null ? new UBindKey(null) : new UBindKey(this.bindParameter.values);
        return this.stmt_cache.get(key);
    }

    public int getParameterCount() {
        return this.parameterNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int index, int sqlType) {
        this.errorHandler = new UError(this.relatedConnection);
        if (index < 0 || index >= this.parameterNumber) {
            this.errorHandler.setErrorCode(-21006);
            return;
        }
        UBindParameter uBindParameter = this.bindParameter;
        synchronized (uBindParameter) {
            try {
                this.bindParameter.setOutParam(index, sqlType);
            }
            catch (UJciException e) {
                e.toUError(this.errorHandler);
            }
        }
    }

    public void bind(int index, boolean value) {
        Byte data = new Byte(value ? (byte)-128 : 0);
        this.bindValue(index, (byte)9, data);
    }

    public void bind(int index, byte value) {
        Short data = new Short(value);
        this.bindValue(index, (byte)9, data);
    }

    public void bind(int index, short value) {
        Short data = new Short(value);
        this.bindValue(index, (byte)9, data);
    }

    public void bind(int index, int value) {
        Integer data = new Integer(value);
        this.bindValue(index, (byte)8, data);
    }

    public void bind(int index, long value) {
        Long data = new Long(value);
        this.bindValue(index, (byte)21, data);
    }

    public void bind(int index, float value) {
        Float data = new Float(value);
        this.bindValue(index, (byte)11, data);
    }

    public void bind(int index, double value) {
        Double data = new Double(value);
        this.bindValue(index, (byte)12, data);
    }

    public void bind(int index, BigDecimal value) {
        this.bindValue(index, (byte)7, value);
    }

    public void bind(int index, String value) {
        this.bindValue(index, (byte)2, value);
    }

    public void bind(int index, byte[] value) {
        byte[] data = value == null ? null : (byte[])value.clone();
        this.bindValue(index, (byte)6, data);
    }

    public void bind(int index, Date value) {
        this.bindValue(index, (byte)13, value);
    }

    public void bind(int index, Time value) {
        this.bindValue(index, (byte)14, value);
    }

    public void bind(int index, Timestamp value) {
        byte type = UUType.getObjectDBtype(value);
        this.bindValue(index, type, value);
    }

    public void bind(int index, Object value) {
        byte type = UUType.getObjectDBtype(value);
        if (type == 18) {
            this.bindCollection(index, (Object[])value);
            return;
        }
        if (type == 0 && value != null) {
            this.errorHandler = new UError(this.relatedConnection);
            this.errorHandler.setErrorCode(-21016);
            return;
        }
        this.bindValue(index, type, value);
    }

    public void bindCollection(int index, Object[] values) {
        CUBRIDArray collectionData;
        if (values == null) {
            collectionData = null;
        } else {
            try {
                collectionData = new CUBRIDArray(values);
            }
            catch (UJciException e) {
                this.errorHandler = new UError(this.relatedConnection);
                e.toUError(this.errorHandler);
                return;
            }
        }
        this.bindValue(index, (byte)18, collectionData);
    }

    public void bindOID(int index, CUBRIDOID oid) {
        this.bindValue(index, (byte)19, oid);
    }

    public void bindBlob(int index, Blob blob) {
        this.bindValue(index, (byte)23, blob);
    }

    public void bindClob(int index, Clob clob) {
        this.bindValue(index, (byte)24, clob);
    }

    public void addBatch() {
        this.errorHandler = new UError(this.relatedConnection);
        if (this.bindParameter == null) {
            return;
        }
        if (!this.bindParameter.checkAllBinded()) {
            this.errorHandler.setErrorCode(-21007);
            return;
        }
        if (this.batchParameter == null) {
            this.batchParameter = new ArrayList();
        }
        this.batchParameter.add(this.bindParameter);
        this.bindParameter = new UBindParameter(this.parameterNumber, this.relatedConnection.getDbmsType());
    }

    public void bindNull(int index) {
        this.bindValue(index, (byte)0, null);
    }

    public UError cancel() {
        UError localError = new UError(this.relatedConnection);
        if (this.isClosed) {
            localError.setErrorCode(-21017);
            return localError;
        }
        if (this.statementType == 1) {
            return localError;
        }
        try {
            this.relatedConnection.cancel();
        }
        catch (UJciException e) {
            this.relatedConnection.logException(e);
            e.toUError(localError);
        }
        catch (IOException e) {
            this.relatedConnection.logException(e);
            localError.setErrorCode(-21003);
        }
        return localError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBatch() {
        this.errorHandler = new UError(this.relatedConnection);
        if (this.batchParameter == null) {
            return;
        }
        ArrayList<UBindParameter> arrayList = this.batchParameter;
        synchronized (arrayList) {
            this.batchParameter.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearBind() {
        this.errorHandler = new UError(this.relatedConnection);
        if (this.bindParameter == null) {
            return;
        }
        UBindParameter uBindParameter = this.bindParameter;
        synchronized (uBindParameter) {
            this.bindParameter.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean close_srv_handle) {
        block16: {
            if (this.isClosed) {
                this.errorHandler.setErrorCode(-21017);
                return;
            }
            this.relatedConnection.pooled_ustmts.remove(this);
            this.fetchedTupleNumber = 0;
            this.totalTupleNumber = 0;
            this.cursorPosition = 0;
            this.currentFirstCursor = 0;
            this.isClosed = true;
            if (this.stmt_cache != null) {
                this.stmt_cache.decr_ref_count();
            }
            try {
                if (this.isReturnable || !close_srv_handle || this.relatedConnection.getAutoCommit() && !this.relatedConnection.brokerInfoStatementPooling() && (this.prepare_flag & 8) == 0) break block16;
                if (this.getSqlType()) {
                    UConnection uConnection = this.relatedConnection;
                    synchronized (uConnection) {
                        this.outBuffer.newRequest((byte)6);
                        this.outBuffer.addInt(this.serverHandler);
                        this.outBuffer.addByte(this.relatedConnection.getAutoCommit() ? (byte)1 : 0);
                        this.relatedConnection.send_recv_msg();
                        break block16;
                    }
                }
                this.relatedConnection.deferred_close_handle.add(new Integer(this.serverHandler));
            }
            catch (UJciException e) {
                if (this.relatedConnection.isActive()) {
                    e.setStackTrace(e.getStackTrace());
                    e.toUError(this.errorHandler);
                }
            }
            catch (IOException e) {
                if (this.relatedConnection.isActive()) {
                    e.setStackTrace(e.getStackTrace());
                    this.errorHandler.setErrorCode(-21003);
                }
            }
            finally {
                this.fetchedTupleNumber = 0;
                this.totalTupleNumber = 0;
                this.cursorPosition = 0;
                this.currentFirstCursor = 0;
                this.isClosed = true;
                if (this.stmt_cache != null) {
                    this.stmt_cache.decr_ref_count();
                }
            }
        }
    }

    public synchronized void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean cursorIsInstance(int cursor) {
        Object instance_obj;
        this.errorHandler = new UError(this.relatedConnection);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return false;
        }
        if (this.currentFirstCursor < 0 || cursor < 0 || cursor >= 0 && (cursor < this.currentFirstCursor || cursor > this.currentFirstCursor + this.fetchedTupleNumber - 1)) {
            this.errorHandler.setErrorCode(-21016);
            return false;
        }
        if (!this.tuples[this.cursorPosition - this.currentFirstCursor].oidIsIncluded()) {
            this.errorHandler.setErrorCode(-21021);
            return false;
        }
        UConnection uConnection = this.relatedConnection;
        synchronized (uConnection) {
            instance_obj = this.relatedConnection.oidCmd(this.tuples[this.cursorPosition - this.currentFirstCursor].getOid(), (byte)2);
        }
        this.errorHandler.copyValue(this.relatedConnection.getRecentError());
        return instance_obj != null;
    }

    public synchronized void closeCursor() {
        if (this.isReturnable) {
            return;
        }
        if (!this.relatedConnection.isConnectedToCubrid()) {
            return;
        }
        try {
            byte code = 42;
            if (this.relatedConnection.protoVersionIsSame(2)) {
                code = 41;
            }
            this.outBuffer.newRequest(code);
            this.outBuffer.addInt(this.serverHandler);
            this.relatedConnection.send_recv_msg();
        }
        catch (UJciException e) {
            this.relatedConnection.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.relatedConnection.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteCursor(int cursor) {
        this.errorHandler = new UError(this.relatedConnection);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        if (this.currentFirstCursor < 0 || cursor < 0 || cursor >= 0 && (cursor < this.currentFirstCursor || cursor > this.currentFirstCursor + this.fetchedTupleNumber - 1)) {
            this.errorHandler.setErrorCode(-21016);
            return;
        }
        if (!this.tuples[this.cursorPosition - this.currentFirstCursor].oidIsIncluded()) {
            this.errorHandler.setErrorCode(-21021);
            return;
        }
        UConnection uConnection = this.relatedConnection;
        synchronized (uConnection) {
            this.relatedConnection.oidCmd(this.tuples[this.cursorPosition - this.currentFirstCursor].getOid(), (byte)1);
        }
        this.errorHandler.copyValue(this.relatedConnection.getRecentError());
    }

    private void setExecuteOptions(int maxRow, boolean isAsync, boolean isExecuteAll, boolean isQueryPlan, boolean isOnlyPlan, boolean isHoldable, boolean isSensitive) {
        this.executeFlag = 0;
        if (isAsync) {
            this.executeFlag = (byte)(this.executeFlag | 1);
        }
        if (isExecuteAll) {
            this.executeFlag = (byte)(this.executeFlag | 2);
        }
        if (isQueryPlan) {
            this.executeFlag = (byte)(this.executeFlag | 4);
        }
        if (isOnlyPlan) {
            this.executeFlag = (byte)(this.executeFlag | 4);
            this.executeFlag = (byte)(this.executeFlag | 8);
        }
        if (isHoldable && this.relatedConnection.supportHoldableResult()) {
            this.executeFlag = (byte)(this.executeFlag | 0x20);
        }
        if (this.isGeneratedKeys) {
            this.executeFlag = (byte)(this.executeFlag | 0x40);
        }
        if (this.isGeneratedKeys) {
            this.executeFlag = (byte)(this.executeFlag | 0x40);
        }
        this.isSensitive = isSensitive;
        this.maxFetchSize = maxRow;
    }

    private void writeExecuteRequest(int maxField, boolean isScrollable, int queryTimeout) throws IOException, UJciException {
        byte is_auto_commit = 0;
        byte is_forward_only = 0;
        long remainingTime = 0L;
        this.outBuffer.newRequest((byte)3);
        this.outBuffer.addInt(this.serverHandler);
        this.outBuffer.addByte(this.executeFlag);
        this.outBuffer.addInt(maxField < 0 ? 0 : maxField);
        this.outBuffer.addInt(0);
        if (this.firstStmtType == 126 && this.bindParameter != null) {
            this.outBuffer.addBytes(this.bindParameter.paramMode);
        } else {
            this.outBuffer.addNull();
        }
        if (this.firstStmtType == 21) {
            this.outBuffer.addByte((byte)1);
        } else {
            this.outBuffer.addByte((byte)0);
        }
        if (this.relatedConnection.getAutoCommit() && !this.isGeneratedKeys) {
            is_auto_commit = 1;
        }
        this.outBuffer.addByte(is_auto_commit);
        if (!isScrollable) {
            is_forward_only = 1;
        }
        this.outBuffer.addByte(is_forward_only);
        this.outBuffer.addCacheTime(null);
        if (this.relatedConnection.protoVersionIsAbove(2)) {
            remainingTime = this.relatedConnection.getRemainingTime(queryTimeout * 1000);
        } else if (this.relatedConnection.protoVersionIsAbove(1)) {
            remainingTime = this.relatedConnection.getRemainingTime(queryTimeout * 1000);
            remainingTime = (long)Math.ceil((double)remainingTime / 1000.0);
        }
        if (queryTimeout > 0 && remainingTime <= 0L) {
            throw this.relatedConnection.createJciException(-21024);
        }
        this.outBuffer.addInt((int)remainingTime);
        if (this.bindParameter != null) {
            this.bindParameter.writeParameter(this.outBuffer);
        }
    }

    private void readResultMeta(UInputBuffer inBuffer) throws UJciException {
        if (this.relatedConnection.protoVersionIsAbove(2) && inBuffer.readByte() == 1) {
            inBuffer.readInt();
            this.commandTypeIs = inBuffer.readByte();
            inBuffer.readInt();
            this.isUpdatable = inBuffer.readByte() == 1;
            this.columnNumber = inBuffer.readInt();
            this.readColumnInfo(inBuffer);
            if (this.commandTypeIs == 126) {
                this.columnNumber = this.parameterNumber + 1;
            }
        }
    }

    private void fetchResultData(UInputBuffer inBuffer) throws UJciException {
        this.executeResult = inBuffer.getResCode();
        if (this.maxFetchSize > 0) {
            this.executeResult = Math.min(this.maxFetchSize, this.executeResult);
        }
        this.totalTupleNumber = this.executeResult;
        this.batchParameter = null;
        if (this.commandTypeIs == 21 && this.totalTupleNumber > 0) {
            inBuffer.readInt();
            this.read_fetch_data(inBuffer, (byte)8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInternal(int maxRow, int maxField, boolean isScrollable, int queryTimeout) throws UJciException, IOException {
        UInputBuffer inBuffer = null;
        this.errorHandler.clear();
        this.relatedConnection.setShardId(-1);
        UConnection uConnection = this.relatedConnection;
        synchronized (uConnection) {
            this.writeExecuteRequest(maxField, isScrollable, queryTimeout);
            inBuffer = this.relatedConnection.send_recv_msg();
        }
        inBuffer.readByte();
        this.readResultInfo(inBuffer);
        this.readResultMeta(inBuffer);
        if (this.relatedConnection.protoVersionIsAbove(5)) {
            this.relatedConnection.setShardId(inBuffer.readInt());
        }
        this.fetchResultData(inBuffer);
        for (int i = 0; i < this.resultInfo.length; ++i) {
            if (this.resultInfo[i].statementType == 21) continue;
            this.relatedConnection.update_executed = true;
            break;
        }
    }

    public synchronized void execute(boolean isAsync, int maxRow, int maxField, boolean isExecuteAll, boolean isSensitive, boolean isScrollable, boolean isQueryPlan, boolean isOnlyPlan, boolean isHoldable, UStatementCacheData cacheData, int queryTimeout) {
        this.isFetchCompleted = false;
        this.flushLobStreams();
        this.errorHandler = new UError(this.relatedConnection);
        if (this.isClosed) {
            if (this.relatedConnection.brokerInfoStatementPooling()) {
                try {
                    this.reset();
                }
                catch (UJciException e) {
                    e.toUError(this.errorHandler);
                    return;
                }
            } else {
                this.errorHandler.setErrorCode(-21017);
                return;
            }
        }
        if (this.statementType == 2) {
            return;
        }
        if (this.bindParameter != null && !this.bindParameter.checkAllBinded()) {
            this.errorHandler.setErrorCode(-21007);
            return;
        }
        this.setExecuteOptions(maxRow, isAsync, isExecuteAll, isQueryPlan, isOnlyPlan, isHoldable, isSensitive);
        this.currentFirstCursor = -1;
        this.fetchedTupleNumber = 0;
        this.cursorPosition = this.firstStmtType == 126 ? 0 : -1;
        this.result_cacheable = false;
        boolean isFirstExecInTran = !this.relatedConnection.isActive();
        try {
            this.executeInternal(maxRow, maxField, isScrollable, queryTimeout);
            return;
        }
        catch (UJciException e) {
            this.relatedConnection.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.relatedConnection.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
        if (this.relatedConnection.isErrorToReconnect(this.errorHandler.getJdbcErrorCode()) && (!this.relatedConnection.isActive() || isFirstExecInTran)) {
            if (!this.relatedConnection.brokerInfoReconnectWhenServerDown() || this.relatedConnection.isErrorCommunication(this.errorHandler.getJdbcErrorCode())) {
                this.relatedConnection.clientSocketClose();
            }
            try {
                this.reset();
                this.executeInternal(maxRow, maxField, isScrollable, queryTimeout);
                return;
            }
            catch (UJciException e) {
                this.relatedConnection.logException(e);
                e.toUError(this.errorHandler);
            }
            catch (IOException e) {
                this.relatedConnection.logException(e);
                this.errorHandler.setErrorCode(-21003);
            }
        }
        while (this.relatedConnection.brokerInfoStatementPooling() && this.errorHandler.getJdbcErrorCode() == -10024) {
            try {
                this.reset();
                this.executeInternal(maxRow, maxField, isScrollable, queryTimeout);
                return;
            }
            catch (UJciException e) {
                this.relatedConnection.logException(e);
                e.toUError(this.errorHandler);
            }
            catch (IOException e) {
                this.relatedConnection.logException(e);
                this.errorHandler.setErrorCode(-21003);
            }
        }
    }

    private void reset() throws UJciException {
        this.close();
        UStatement tmp = this.relatedConnection.prepare(this.sql_stmt, this.prepare_flag, true);
        UError err = this.relatedConnection.getRecentError();
        if (err.getErrorCode() != 0) {
            int indicator = err.getErrorCode() == -21002 ? -2 : -1;
            throw new UJciException(err.getErrorCode(), indicator, err.getJdbcErrorCode(), err.getErrorMsg(false));
        }
        this.relatedConnection.pooled_ustmts.remove(tmp);
        this.relatedConnection.pooled_ustmts.add(this);
        this.init(this.relatedConnection, tmp.tmp_inbuffer, this.sql_stmt, this.prepare_flag, false);
    }

    public synchronized CUBRIDOID executeInsert(boolean isAsync) {
        this.errorHandler = new UError(this.relatedConnection);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return null;
        }
        if (this.commandTypeIs != 20) {
            this.errorHandler.setErrorCode(-21022);
            return null;
        }
        this.execute(isAsync, 0, 0, false, false, false, false, false, false, null, 0);
        if (this.errorHandler.getErrorCode() != 0) {
            return null;
        }
        if (this.resultInfo != null && this.resultInfo[0] != null) {
            return this.resultInfo[0].getCUBRIDOID();
        }
        this.errorHandler.setErrorCode(-21021);
        return null;
    }

    public synchronized void setAutoCommit(boolean autoCommit) {
        this.isAutoCommit = autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExecuteBatchRequest(int queryTimeout) throws IOException, UJciException {
        this.outBuffer.newRequest(this.relatedConnection.getOutputStream(), (byte)21);
        this.outBuffer.addInt(this.serverHandler);
        if (this.relatedConnection.protoVersionIsAbove(4)) {
            long remainingTime = this.relatedConnection.getRemainingTime(queryTimeout * 1000);
            if (queryTimeout > 0 && remainingTime <= 0L) {
                throw this.relatedConnection.createJciException(-21024);
            }
            this.outBuffer.addInt((int)remainingTime);
        }
        this.outBuffer.addByte(this.isAutoCommit ? (byte)1 : 0);
        if (this.batchParameter != null) {
            ArrayList<UBindParameter> arrayList = this.batchParameter;
            synchronized (arrayList) {
                for (int i = 0; i < this.batchParameter.size(); ++i) {
                    UBindParameter b = this.batchParameter.get(i);
                    b.writeParameter(this.outBuffer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UBatchResult executeBatchInternal(int queryTimeout) throws IOException, UJciException {
        UInputBuffer inBuffer = null;
        this.errorHandler.clear();
        this.relatedConnection.setShardId(-1);
        UConnection uConnection = this.relatedConnection;
        synchronized (uConnection) {
            this.writeExecuteBatchRequest(queryTimeout);
            inBuffer = this.relatedConnection.send_recv_msg();
        }
        this.batchParameter = null;
        UBatchResult batchResult = new UBatchResult(inBuffer.readInt());
        for (int i = 0; i < batchResult.getResultNumber(); ++i) {
            batchResult.setStatementType(i, this.statementType);
            int result = inBuffer.readInt();
            if (result < 0) {
                int err_code = inBuffer.readInt();
                batchResult.setResultError(i, err_code, inBuffer.readString(inBuffer.readInt(), UJCIManager.sysCharsetName));
                continue;
            }
            batchResult.setResult(i, result);
            inBuffer.readInt();
            inBuffer.readShort();
            inBuffer.readShort();
        }
        if (this.relatedConnection.protoVersionIsAbove(5)) {
            this.relatedConnection.setShardId(inBuffer.readInt());
        }
        return batchResult;
    }

    public synchronized UBatchResult executeBatch(int queryTimeout) {
        boolean isFirstExecInTran;
        block17: {
            this.errorHandler = new UError(this.relatedConnection);
            if (this.isClosed) {
                if (this.relatedConnection.brokerInfoStatementPooling()) {
                    try {
                        this.reset();
                    }
                    catch (UJciException e) {
                        e.toUError(this.errorHandler);
                        return null;
                    }
                } else {
                    this.errorHandler.setErrorCode(-21017);
                    return null;
                }
            }
            isFirstExecInTran = !this.relatedConnection.isActive();
            try {
                UBatchResult batchResult = this.executeBatchInternal(queryTimeout);
                return batchResult;
            }
            catch (UJciException e) {
                this.relatedConnection.logException(e);
                e.toUError(this.errorHandler);
            }
            catch (IOException e) {
                this.relatedConnection.logException(e);
                if (this.errorHandler.getErrorCode() == -21013) break block17;
                this.errorHandler.setErrorCode(-21003);
            }
        }
        if (this.relatedConnection.isErrorToReconnect(this.errorHandler.getJdbcErrorCode()) && (!this.relatedConnection.isActive() || isFirstExecInTran)) {
            if (!this.relatedConnection.brokerInfoReconnectWhenServerDown() || this.relatedConnection.isErrorCommunication(this.errorHandler.getJdbcErrorCode())) {
                this.relatedConnection.clientSocketClose();
            }
            try {
                this.reset();
                UBatchResult batchResult = this.executeBatchInternal(queryTimeout);
                return batchResult;
            }
            catch (UJciException e) {
                this.relatedConnection.logException(e);
                e.toUError(this.errorHandler);
            }
            catch (IOException e) {
                this.relatedConnection.logException(e);
                this.errorHandler.setErrorCode(-21003);
            }
        }
        while (this.relatedConnection.brokerInfoStatementPooling() && this.errorHandler.getJdbcErrorCode() == -10024) {
            try {
                this.reset();
                UBatchResult batchResult = this.executeBatchInternal(queryTimeout);
                return batchResult;
            }
            catch (UJciException e) {
                this.relatedConnection.logException(e);
                e.toUError(this.errorHandler);
            }
            catch (IOException e) {
                this.relatedConnection.logException(e);
                this.errorHandler.setErrorCode(-21003);
            }
        }
        return null;
    }

    public synchronized void fetch() {
        this.errorHandler = new UError(this.relatedConnection);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        this.realFetched = false;
        if (this.statementType == 1) {
            return;
        }
        if (this.cursorPosition < 0 || this.executeFlag != 1 && this.totalTupleNumber <= 0) {
            this.errorHandler.setErrorCode(-21004);
            return;
        }
        if (this.currentFirstCursor >= 0 && this.currentFirstCursor <= this.cursorPosition && this.cursorPosition <= this.currentFirstCursor + this.fetchedTupleNumber - 1) {
            return;
        }
        this.reFetch();
    }

    public synchronized BigDecimal getBigDecimal(int index) {
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getBigDecimal(obj);
        }
        catch (UJciException e) {
            e.toUError(this.errorHandler);
            return null;
        }
    }

    public synchronized boolean getBoolean(int index) {
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return false;
        }
        try {
            return UGetTypeConvertedValue.getBoolean(obj);
        }
        catch (UJciException e) {
            e.toUError(this.errorHandler);
            return false;
        }
    }

    public synchronized byte getByte(int index) {
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return 0;
        }
        try {
            return UGetTypeConvertedValue.getByte(obj);
        }
        catch (UJciException e) {
            e.toUError(this.errorHandler);
            return 0;
        }
    }

    public synchronized byte[] getBytes(int index) {
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getBytes(obj);
        }
        catch (UJciException e) {
            e.toUError(this.errorHandler);
            return null;
        }
    }

    public synchronized Object getCollection(int index) {
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof CUBRIDArray)) {
            this.errorHandler.setErrorCode(-21005);
            return null;
        }
        return ((CUBRIDArray)obj).getArrayClone();
    }

    public UColumnInfo[] getColumnInfo() {
        UError localError = new UError(this.relatedConnection);
        if (this.isClosed) {
            localError.setErrorCode(-21017);
            this.errorHandler = localError;
            return null;
        }
        this.errorHandler = localError;
        return this.columnInfo;
    }

    public HashMap<String, Integer> getColumnNameToIndexMap() {
        UError localError = new UError(this.relatedConnection);
        if (this.isClosed) {
            localError.setErrorCode(-21017);
            this.errorHandler = localError;
            return null;
        }
        this.errorHandler = localError;
        return this.colNameToIndex;
    }

    public synchronized CUBRIDOID getColumnOID(int index) {
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof CUBRIDOID)) {
            this.errorHandler.setErrorCode(-21001);
            return null;
        }
        return (CUBRIDOID)obj;
    }

    public synchronized CUBRIDOID getCursorOID() {
        this.errorHandler = new UError(this.relatedConnection);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return null;
        }
        if (!this.checkReFetch()) {
            return null;
        }
        return this.tuples[this.cursorPosition - this.currentFirstCursor].getOid();
    }

    public synchronized CUBRIDBlob getBlob(int index) {
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return null;
        }
        if (obj instanceof CUBRIDBlob) {
            return (CUBRIDBlob)obj;
        }
        this.errorHandler.setErrorCode(-21005);
        return null;
    }

    public synchronized CUBRIDClob getClob(int index) {
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return null;
        }
        if (obj instanceof CUBRIDClob) {
            return (CUBRIDClob)obj;
        }
        this.errorHandler.setErrorCode(-21005);
        return null;
    }

    public synchronized Date getDate(int index) {
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getDate(obj);
        }
        catch (UJciException e) {
            e.toUError(this.errorHandler);
            return null;
        }
    }

    public synchronized double getDouble(int index) {
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return 0.0;
        }
        try {
            return UGetTypeConvertedValue.getDouble(obj);
        }
        catch (UJciException e) {
            e.toUError(this.errorHandler);
            return 0.0;
        }
    }

    public int getExecuteResult() {
        UError localError = new UError(this.relatedConnection);
        if (this.isClosed) {
            localError.setErrorCode(-21017);
            this.errorHandler = localError;
            return 0;
        }
        this.errorHandler = localError;
        return this.executeResult;
    }

    public int getFetchDirection() {
        UError localError = new UError(this.relatedConnection);
        if (this.isClosed) {
            localError.setErrorCode(-21017);
            this.errorHandler = localError;
            return 0;
        }
        this.errorHandler = localError;
        return this.fetchDirection;
    }

    public int getFetchSize() {
        UError localError = new UError(this.relatedConnection);
        if (this.isClosed) {
            localError.setErrorCode(-21017);
            this.errorHandler = localError;
            return 0;
        }
        this.errorHandler = localError;
        return this.fetchSize;
    }

    public synchronized float getFloat(int index) {
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return 0.0f;
        }
        try {
            return UGetTypeConvertedValue.getFloat(obj);
        }
        catch (UJciException e) {
            e.toUError(this.errorHandler);
            return 0.0f;
        }
    }

    public synchronized int getInt(int index) {
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return 0;
        }
        try {
            return UGetTypeConvertedValue.getInt(obj);
        }
        catch (UJciException e) {
            e.toUError(this.errorHandler);
            return 0;
        }
    }

    public synchronized long getLong(int index) {
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return 0L;
        }
        try {
            return UGetTypeConvertedValue.getLong(obj);
        }
        catch (UJciException e) {
            e.toUError(this.errorHandler);
            return 0L;
        }
    }

    public synchronized Object getObject(int index) {
        Object retValue;
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return null;
        }
        try {
            if (this.commandTypeIs != 126 && this.columnInfo[index].getColumnType() == 5 && this.columnInfo[index].getColumnPrecision() == 8) {
                retValue = new Boolean(UGetTypeConvertedValue.getBoolean(obj));
            } else if (obj instanceof CUBRIDArray) {
                retValue = ((CUBRIDArray)obj).getArrayClone();
            } else if (obj instanceof byte[]) {
                retValue = ((byte[])obj).clone();
            } else if (obj instanceof Date) {
                retValue = ((Date)obj).clone();
            } else if (obj instanceof Time) {
                retValue = ((Time)obj).clone();
            } else if (obj instanceof Timestamp) {
                retValue = new Timestamp(((Timestamp)obj).getTime());
            } else if (obj instanceof CUBRIDOutResultSet) {
                try {
                    ((CUBRIDOutResultSet)obj).createInstance();
                    retValue = obj;
                }
                catch (Exception e) {
                    retValue = null;
                }
            } else {
                retValue = obj;
            }
        }
        catch (UJciException e) {
            e.toUError(this.errorHandler);
            return null;
        }
        return retValue;
    }

    public UError getRecentError() {
        return this.errorHandler;
    }

    public UResultInfo[] getResultInfo() {
        UError localError = new UError(this.relatedConnection);
        if (this.isClosed) {
            localError.setErrorCode(-21017);
            this.errorHandler = localError;
            return null;
        }
        this.errorHandler = localError;
        return this.resultInfo;
    }

    public synchronized short getShort(int index) {
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return 0;
        }
        try {
            return UGetTypeConvertedValue.getShort(obj);
        }
        catch (UJciException e) {
            e.toUError(this.errorHandler);
            return 0;
        }
    }

    public boolean getSqlType() {
        UError localError = new UError(this.relatedConnection);
        if (this.isClosed) {
            localError.setErrorCode(-21017);
            this.errorHandler = localError;
            return false;
        }
        if (this.commandTypeIs == 21 || this.commandTypeIs == 24 || this.commandTypeIs == 41 || this.commandTypeIs == 14) {
            this.errorHandler = localError;
            return true;
        }
        this.errorHandler = localError;
        return false;
    }

    public synchronized String getString(int index) {
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getString(obj);
        }
        catch (UJciException e) {
            e.toUError(this.errorHandler);
            return null;
        }
    }

    public synchronized Time getTime(int index) {
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getTime(obj);
        }
        catch (UJciException e) {
            e.toUError(this.errorHandler);
            return null;
        }
    }

    public synchronized Timestamp getTimestamp(int index) {
        this.errorHandler = new UError(this.relatedConnection);
        Object obj = this.beforeGetXXX(index);
        if (obj == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getTimestamp(obj);
        }
        catch (UJciException e) {
            e.toUError(this.errorHandler);
            return null;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isOIDIncluded() {
        UError localError = new UError(this.relatedConnection);
        if (this.isClosed) {
            localError.setErrorCode(-21017);
            this.errorHandler = localError;
            return false;
        }
        this.errorHandler = localError;
        return this.isUpdatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveCursor(int offset, int origin) {
        this.errorHandler = new UError(this.relatedConnection);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        if (origin != 0 && origin != 1 && origin != 2 || this.executeFlag != 1 && this.totalTupleNumber == 0) {
            this.errorHandler.setErrorCode(-21004);
            return;
        }
        int currentCursor = this.cursorPosition;
        if (origin == 0) {
            this.cursorPosition = offset;
        } else if (origin == 1) {
            this.cursorPosition += offset;
        }
        if (origin == 0 || origin == 1) {
            if (this.executeFlag == 1) {
                if (this.cursorPosition <= this.currentFirstCursor + this.fetchedTupleNumber - 1 || this.totalTupleNumber != 0 && this.cursorPosition < this.totalTupleNumber) {
                    return;
                }
            } else {
                if (this.cursorPosition < this.totalTupleNumber) {
                    return;
                }
                this.errorHandler.setErrorCode(-21004);
                this.cursorPosition = currentCursor;
                return;
            }
        }
        if (origin == 2 && this.totalTupleNumber != 0) {
            this.cursorPosition = this.totalTupleNumber - offset - 1;
            if (this.cursorPosition >= 0) {
                return;
            }
            this.errorHandler.setErrorCode(-21004);
            this.cursorPosition = currentCursor;
            return;
        }
        if (origin == 1) {
            origin = 0;
            offset += currentCursor;
        }
        try {
            UInputBuffer inBuffer;
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)7);
                this.outBuffer.addInt(this.serverHandler);
                this.outBuffer.addInt(offset);
                this.outBuffer.addInt(origin);
                inBuffer = this.relatedConnection.send_recv_msg();
            }
            this.totalTupleNumber = inBuffer.readInt();
        }
        catch (UJciException e) {
            this.relatedConnection.logException(e);
            this.cursorPosition = currentCursor;
            e.toUError(this.errorHandler);
            return;
        }
        catch (IOException e) {
            this.relatedConnection.logException(e);
            this.cursorPosition = currentCursor;
            this.errorHandler.setErrorCode(-21003);
            return;
        }
        if (this.totalTupleNumber < 0) {
            this.totalTupleNumber = 0;
        } else if (this.totalTupleNumber <= this.cursorPosition) {
            this.errorHandler.setErrorCode(-21004);
            this.cursorPosition = currentCursor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean nextResult() {
        this.errorHandler = new UError(this.relatedConnection);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return false;
        }
        try {
            UInputBuffer inBuffer;
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)19);
                this.outBuffer.addInt(this.serverHandler);
                this.outBuffer.addInt(0);
                inBuffer = this.relatedConnection.send_recv_msg();
            }
            this.executeResult = inBuffer.readInt();
            this.commandTypeIs = inBuffer.readByte();
            this.isUpdatable = inBuffer.readByte() == 1;
            this.columnNumber = inBuffer.readInt();
            this.readColumnInfo(inBuffer);
        }
        catch (UJciException e) {
            this.relatedConnection.logException(e);
            this.closeInternal();
            e.toUError(this.errorHandler);
            return false;
        }
        catch (IOException e) {
            this.relatedConnection.logException(e);
            this.closeInternal();
            this.errorHandler.setErrorCode(-21003);
            return false;
        }
        this.fetchedTupleNumber = 0;
        this.cursorPosition = -1;
        this.currentFirstCursor = -1;
        this.executeResult = this.maxFetchSize > 0 && this.executeResult > this.maxFetchSize ? this.maxFetchSize : this.executeResult;
        this.totalTupleNumber = this.executeResult;
        this.realFetched = false;
        return true;
    }

    public boolean realFetched() {
        return this.realFetched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reFetch() {
        this.errorHandler = new UError(this.relatedConnection);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        if (this.statementType == 1) {
            return;
        }
        try {
            UInputBuffer inBuffer;
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)8);
                this.outBuffer.addInt(this.serverHandler);
                if (this.fetchDirection == 1001) {
                    int startPos = this.cursorPosition - this.fetchSize + 2;
                    if (startPos < 1) {
                        startPos = 1;
                    }
                    this.outBuffer.addInt(startPos);
                } else {
                    this.outBuffer.addInt(this.cursorPosition + 1);
                }
                this.outBuffer.addInt(this.fetchSize);
                this.outBuffer.addByte(this.isSensitive ? (byte)1 : 0);
                this.outBuffer.addInt(0);
                inBuffer = this.relatedConnection.send_recv_msg();
            }
            this.read_fetch_data(inBuffer, (byte)8);
            this.realFetched = true;
        }
        catch (UJciException e) {
            this.relatedConnection.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.relatedConnection.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
    }

    public synchronized void setFetchDirection(int direction) {
        this.errorHandler = new UError(this.relatedConnection);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            this.errorHandler.setErrorCode(-21016);
            return;
        }
        this.fetchDirection = direction;
    }

    public synchronized void setFetchSize(int size) {
        this.errorHandler = new UError(this.relatedConnection);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        if (size < 0) {
            this.errorHandler.setErrorCode(-21016);
            return;
        }
        this.fetchSize = size == 0 ? 100 : size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateRows(int cursorPosition, int[] indexes, Object[] values) {
        this.errorHandler = new UError(this.relatedConnection);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return;
        }
        try {
            UUpdateParameter updateParameter = new UUpdateParameter(this.columnInfo, indexes, values);
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)22);
                this.outBuffer.addInt(this.serverHandler);
                this.outBuffer.addInt(cursorPosition + 1);
                updateParameter.writeParameter(this.outBuffer);
                this.relatedConnection.send_recv_msg();
            }
        }
        catch (UJciException e) {
            this.relatedConnection.logException(e);
            e.toUError(this.errorHandler);
        }
        catch (IOException e) {
            this.relatedConnection.logException(e);
            this.errorHandler.setErrorCode(-21003);
        }
    }

    public synchronized byte getCommandType() {
        return this.commandTypeIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getQueryplan() {
        String plan = null;
        this.errorHandler = new UError(this.relatedConnection);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return null;
        }
        try {
            UInputBuffer inBuffer;
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)24);
                this.outBuffer.addInt(this.serverHandler);
                this.outBuffer.addByte((byte)1);
                inBuffer = this.relatedConnection.send_recv_msg();
            }
            plan = inBuffer.readString(inBuffer.remainedCapacity(), this.relatedConnection.getCharset());
        }
        catch (UJciException e) {
            this.relatedConnection.logException(e);
            this.closeInternal();
            e.toUError(this.errorHandler);
            return null;
        }
        catch (IOException e) {
            this.relatedConnection.logException(e);
            this.closeInternal();
            this.errorHandler.setErrorCode(-21003);
            return null;
        }
        return plan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getGeneratedKeys() {
        this.errorHandler = new UError(this.relatedConnection);
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return false;
        }
        try {
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)34);
                this.outBuffer.addInt(this.serverHandler);
                UInputBuffer inBuffer = this.relatedConnection.send_recv_msg();
                this.commandTypeIs = inBuffer.readByte();
                this.totalTupleNumber = inBuffer.readInt();
                this.isUpdatable = inBuffer.readByte() == 1;
                this.columnNumber = inBuffer.readInt();
                this.statementType = (byte)3;
                this.readColumnInfo(inBuffer);
                this.executeResult = this.totalTupleNumber;
                this.read_fetch_data(inBuffer, (byte)34);
            }
        }
        catch (UJciException e) {
            this.relatedConnection.logException(e);
            this.closeInternal();
            e.toUError(this.errorHandler);
            return false;
        }
        catch (IOException e) {
            this.relatedConnection.logException(e);
            this.closeInternal();
            this.errorHandler.setErrorCode(-21003);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindValue(int index, byte type, Object data) {
        UError localError = new UError(this.relatedConnection);
        if (this.bindParameter == null || index < 0 || index >= this.parameterNumber) {
            localError.setErrorCode(-21006);
            this.errorHandler = localError;
            return;
        }
        try {
            UBindParameter uBindParameter = this.bindParameter;
            synchronized (uBindParameter) {
                this.bindParameter.setParameter(index, type, data);
            }
        }
        catch (UJciException e) {
            e.toUError(localError);
        }
        this.errorHandler = localError;
    }

    private Object beforeGetXXX(int index) {
        Object obj;
        if (this.isClosed) {
            this.errorHandler.setErrorCode(-21017);
            return null;
        }
        if (index < 0 || index >= this.columnNumber) {
            this.errorHandler.setErrorCode(-21009);
            return null;
        }
        if (!this.checkReFetch()) {
            return null;
        }
        if (this.fetchedTupleNumber <= 0) {
            this.errorHandler.setErrorCode(-21004);
            return null;
        }
        if (this.tuples == null || this.tuples[this.cursorPosition - this.currentFirstCursor] == null || (obj = this.tuples[this.cursorPosition - this.currentFirstCursor].getAttribute(index)) == null) {
            this.errorHandler.setErrorCode(-21008);
            return null;
        }
        return obj;
    }

    private boolean checkReFetch() {
        if (this.currentFirstCursor < 0 || this.cursorPosition >= 0 && (this.cursorPosition < this.currentFirstCursor || this.cursorPosition > this.currentFirstCursor + this.fetchedTupleNumber - 1)) {
            this.fetch();
            if (this.errorHandler.getErrorCode() != 0) {
                return false;
            }
        }
        return true;
    }

    private byte readTypeFromData(int index, UInputBuffer inBuffer) throws UJciException {
        if (this.commandTypeIs == 24 || this.commandTypeIs == 14 || this.commandTypeIs == 126 || this.columnInfo[index].getColumnType() == 0) {
            return inBuffer.readByte();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void closeInternal() {
        Object object;
        if (this.columnInfo != null) {
            object = this.columnInfo;
            // MONITORENTER : this.columnInfo
            for (int i = 0; i < this.columnInfo.length; ++i) {
                this.columnInfo[i] = null;
            }
            // MONITOREXIT : object
            this.columnInfo = null;
            this.colNameToIndex.clear();
            this.colNameToIndex = null;
        }
        if (this.bindParameter != null) {
            object = this.bindParameter;
            // MONITORENTER : object
            this.bindParameter.close();
            // MONITOREXIT : object
            this.bindParameter = null;
        }
        this.closeResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeResult() {
        if (this.tuples == null) return;
        UResultTuple[] uResultTupleArray = this.tuples;
        synchronized (this.tuples) {
            for (int i = 0; i < this.tuples.length; ++i) {
                if (this.tuples[i] == null) continue;
                this.tuples[i].close();
                this.tuples[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.tuples = null;
            return;
        }
    }

    private void confirmSchemaTypeInfo(int index) throws UJciException {
        if (this.statementType != 2) {
            return;
        }
        switch (this.schemaType) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                Short fetchedType = (Short)this.tuples[index].getAttribute(1);
                byte[] realType = UColumnInfo.confirmType(fetchedType.byteValue());
                this.tuples[index].setAttribute(1, new Short(realType[0]));
            }
        }
    }

    private Object readAAttribute(int index, UInputBuffer inBuffer) throws UJciException {
        int size = inBuffer.readInt();
        if (size <= 0) {
            return null;
        }
        byte localType = this.readTypeFromData(index, inBuffer);
        if (localType == 0) {
            localType = this.columnInfo[index].getColumnType();
        } else {
            --size;
        }
        return this.readData(inBuffer, localType, size);
    }

    private Object readData(UInputBuffer inBuffer, int dataType, int dataSize) throws UJciException {
        switch (dataType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 25: {
                return inBuffer.readString(dataSize, this.relatedConnection.getCharset());
            }
            case 7: {
                return new BigDecimal(inBuffer.readString(dataSize, UJCIManager.sysCharsetName));
            }
            case 21: 
            case 28: {
                return new Long(inBuffer.readLong());
            }
            case 8: 
            case 27: {
                return new Integer(inBuffer.readInt());
            }
            case 9: 
            case 26: {
                return new Short(inBuffer.readShort());
            }
            case 13: {
                return inBuffer.readDate();
            }
            case 14: {
                return inBuffer.readTime();
            }
            case 15: {
                return inBuffer.readTimestamp();
            }
            case 22: {
                return inBuffer.readDatetime();
            }
            case 19: {
                return inBuffer.readOID(this.relatedConnection.cubridcon);
            }
            case 16: 
            case 17: 
            case 18: {
                CUBRIDArray aArray = new CUBRIDArray(inBuffer.readByte(), inBuffer.readInt());
                int baseType = aArray.getBaseType();
                for (int i = 0; i < aArray.getLength(); ++i) {
                    int eleSize = inBuffer.readInt();
                    if (eleSize <= 0) {
                        aArray.setElement(i, null);
                        continue;
                    }
                    aArray.setElement(i, this.readData(inBuffer, baseType, eleSize));
                }
                return aArray;
            }
            case 10: 
            case 12: {
                return new Double(inBuffer.readDouble());
            }
            case 11: {
                return new Float(inBuffer.readFloat());
            }
            case 5: 
            case 6: {
                return inBuffer.readBytes(dataSize);
            }
            case 20: {
                return new CUBRIDOutResultSet(this.relatedConnection, inBuffer.readInt());
            }
            case 23: {
                return inBuffer.readBlob(dataSize, this.relatedConnection.cubridcon);
            }
            case 24: {
                return inBuffer.readClob(dataSize, this.relatedConnection.cubridcon);
            }
            case 0: {
                return null;
            }
        }
        throw new UJciException(-21005);
    }

    private void read_fetch_data(UInputBuffer inBuffer, byte functionCode) throws UJciException {
        this.fetchedTupleNumber = inBuffer.readInt();
        if (this.fetchedTupleNumber < 0) {
            this.fetchedTupleNumber = 0;
        }
        if (functionCode == 34) {
            this.isFetchCompleted = true;
        }
        this.tuples = new UResultTuple[this.fetchedTupleNumber];
        for (int i = 0; i < this.fetchedTupleNumber; ++i) {
            this.readATuple(i, inBuffer);
        }
        if (functionCode == 34) {
            this.isFetchCompleted = true;
        }
        if (functionCode == 8 && this.relatedConnection.protoVersionIsAbove(5)) {
            this.isFetchCompleted = inBuffer.readByte() == 1;
        }
    }

    private void readATupleByOid(CUBRIDOID oid, UInputBuffer inBuffer) throws UJciException {
        this.tuples[0] = new UResultTuple(1, this.columnNumber);
        this.tuples[0].setOid(oid);
        for (int i = 0; i < this.columnNumber; ++i) {
            this.tuples[0].setAttribute(i, this.readAAttribute(i, inBuffer));
        }
        this.currentFirstCursor = 0;
    }

    private void readATuple(int index, UInputBuffer inBuffer) throws UJciException {
        this.tuples[index] = new UResultTuple(inBuffer.readInt(), this.columnNumber);
        this.tuples[index].setOid(inBuffer.readOID(this.relatedConnection.cubridcon));
        for (int i = 0; i < this.columnNumber; ++i) {
            this.tuples[index].setAttribute(i, this.readAAttribute(i, inBuffer));
        }
        this.confirmSchemaTypeInfo(index);
        if (index == 0) {
            this.currentFirstCursor = this.tuples[index].tupleNumber() - 1;
        }
    }

    private void readColumnInfo(UInputBuffer inBuffer) throws UJciException {
        this.columnInfo = new UColumnInfo[this.columnNumber];
        this.colNameToIndex = new HashMap(this.columnNumber);
        for (int i = 0; i < this.columnNumber; ++i) {
            byte type = inBuffer.readByte();
            short scale = inBuffer.readShort();
            int precision = inBuffer.readInt();
            String name = inBuffer.readString(inBuffer.readInt(), this.relatedConnection.getCharset());
            this.columnInfo[i] = new UColumnInfo(type, scale, precision, name);
            if (this.statementType == 0) {
                String attributeName = inBuffer.readString(inBuffer.readInt(), this.relatedConnection.getCharset());
                String className = inBuffer.readString(inBuffer.readInt(), this.relatedConnection.getCharset());
                byte byteData = inBuffer.readByte();
                this.columnInfo[i].setRemainedData(attributeName, className, byteData == 0);
                String defValue = inBuffer.readString(inBuffer.readInt(), this.relatedConnection.getCharset());
                byte bAI = inBuffer.readByte();
                byte bUK = inBuffer.readByte();
                byte bPK = inBuffer.readByte();
                byte bRI = inBuffer.readByte();
                byte bRU = inBuffer.readByte();
                byte bFK = inBuffer.readByte();
                byte bSh = inBuffer.readByte();
                this.columnInfo[i].setExtraData(defValue, bAI, bUK, bPK, bFK, bRI, bRU, bSh);
            }
            this.colNameToIndex.put(name.toLowerCase(), i);
        }
    }

    private void readResultInfo(UInputBuffer inBuffer) throws UJciException {
        this.numQueriesExecuted = inBuffer.readInt();
        this.resultInfo = new UResultInfo[this.numQueriesExecuted];
        for (int i = 0; i < this.resultInfo.length; ++i) {
            this.resultInfo[i] = new UResultInfo(inBuffer.readByte(), inBuffer.readInt());
            this.resultInfo[i].setResultOid(inBuffer.readOID(this.relatedConnection.cubridcon));
            this.resultInfo[i].setSrvCacheTime(inBuffer.readInt(), inBuffer.readInt());
        }
    }

    public int getNumQueriesExecuted() {
        return this.numQueriesExecuted;
    }

    public int getServerHandle() {
        return this.serverHandler;
    }

    public void setReturnable() {
        this.isReturnable = true;
    }

    public boolean isReturnable() {
        return this.isReturnable;
    }

    public void setCacheData(UStatementCacheData cache_data) {
        this.totalTupleNumber = cache_data.tuple_count;
        this.tuples = cache_data.tuples;
        this.resultInfo = cache_data.resultInfo;
        this.currentFirstCursor = 0;
        this.cursorPosition = 0;
        this.fetchedTupleNumber = this.totalTupleNumber;
        this.executeResult = this.totalTupleNumber;
        this.realFetched = true;
    }

    public boolean is_result_cacheable() {
        return this.result_cacheable && !this.relatedConnection.update_executed;
    }

    public void setAutoGeneratedKeys(boolean isGeneratedKeys) {
        this.isGeneratedKeys = isGeneratedKeys;
    }

    protected void finalize() {
        if (this.stmt_cache != null) {
            this.stmt_cache.decr_ref_count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushLobStreams() {
        if (this.bindParameter != null) {
            UBindParameter uBindParameter = this.bindParameter;
            synchronized (uBindParameter) {
                this.bindParameter.flushLobStreams();
            }
        }
    }

    public String getQuery() {
        return this.sql_stmt;
    }

    public UBindParameter getBindParameter() {
        return this.bindParameter;
    }

    public boolean hasBatch() {
        return this.batchParameter != null && this.batchParameter.size() != 0;
    }

    public boolean isFetchCompleted(int current_row) {
        return this.relatedConnection.isConnectedToOracle() && this.isFetchCompleted && current_row >= this.currentFirstCursor + this.fetchedTupleNumber;
    }
}

