/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.jci.UBindKey;
import cubrid.jdbc.jci.UResCache;
import java.util.ArrayList;
import java.util.Hashtable;

public class UStmtCache {
    String key;
    private Hashtable<UBindKey, UResCache> res_cache_table;
    private ArrayList<UResCache> res_cache_remove_list;
    int ref_count;

    UStmtCache(String key) {
        this.key = key;
        this.res_cache_table = new Hashtable(30);
        this.res_cache_remove_list = new ArrayList(100);
        this.ref_count = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UResCache get(UBindKey key) {
        Hashtable<UBindKey, UResCache> hashtable = this.res_cache_table;
        synchronized (hashtable) {
            UResCache res_cache = this.res_cache_table.get(key);
            if (res_cache == null) {
                res_cache = new UResCache(key);
                this.res_cache_table.put(key, res_cache);
                ArrayList<UResCache> arrayList = this.res_cache_remove_list;
                synchronized (arrayList) {
                    this.res_cache_remove_list.add(res_cache);
                }
            }
            return res_cache;
        }
    }

    synchronized void incr_ref_count() {
        ++this.ref_count;
    }

    synchronized void decr_ref_count() {
        --this.ref_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Hashtable<UBindKey, UResCache> hashtable = this.res_cache_table;
        synchronized (hashtable) {
            this.res_cache_table.clear();
            ArrayList<UResCache> arrayList = this.res_cache_remove_list;
            synchronized (arrayList) {
                this.res_cache_remove_list.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int remove_expired_res(long checkTime) {
        for (int i = 0; i < this.res_cache_remove_list.size(); ++i) {
            UResCache rc = this.res_cache_remove_list.get(i);
            if (!rc.isExpired(checkTime)) continue;
            this.res_cache_table.remove(rc.key);
            ArrayList<UResCache> arrayList = this.res_cache_remove_list;
            synchronized (arrayList) {
                UResCache lastObj = this.res_cache_remove_list.remove(this.res_cache_remove_list.size() - 1);
                if (i < this.res_cache_remove_list.size()) {
                    this.res_cache_remove_list.set(i, lastObj);
                    --i;
                }
                continue;
            }
        }
        return this.res_cache_remove_list.size();
    }
}

