/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.driver.CUBRIDBlob;
import cubrid.jdbc.driver.CUBRIDClob;
import cubrid.sql.CUBRIDOID;
import cubrid.sql.CUBRIDTimestamp;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public abstract class UUType {
    public static final int U_TYPE_MIN = 0;
    public static final int U_TYPE_MAX = 28;
    public static final byte U_TYPE_NULL = 0;
    public static final byte U_TYPE_CHAR = 1;
    public static final byte U_TYPE_STRING = 2;
    public static final byte U_TYPE_VARCHAR = 2;
    public static final byte U_TYPE_NCHAR = 3;
    public static final byte U_TYPE_VARNCHAR = 4;
    public static final byte U_TYPE_BIT = 5;
    public static final byte U_TYPE_VARBIT = 6;
    public static final byte U_TYPE_NUMERIC = 7;
    public static final byte U_TYPE_DECIMAL = 7;
    public static final byte U_TYPE_INT = 8;
    public static final byte U_TYPE_SHORT = 9;
    public static final byte U_TYPE_MONETARY = 10;
    public static final byte U_TYPE_FLOAT = 11;
    public static final byte U_TYPE_DOUBLE = 12;
    public static final byte U_TYPE_DATE = 13;
    public static final byte U_TYPE_TIME = 14;
    public static final byte U_TYPE_TIMESTAMP = 15;
    public static final byte U_TYPE_SET = 16;
    public static final byte U_TYPE_MULTISET = 17;
    public static final byte U_TYPE_SEQUENCE = 18;
    public static final byte U_TYPE_OBJECT = 19;
    public static final byte U_TYPE_RESULTSET = 20;
    public static final byte U_TYPE_BIGINT = 21;
    public static final byte U_TYPE_DATETIME = 22;
    public static final byte U_TYPE_BLOB = 23;
    public static final byte U_TYPE_CLOB = 24;
    public static final byte U_TYPE_ENUM = 25;
    public static final byte U_TYPE_USHORT = 26;
    public static final byte U_TYPE_UINT = 27;
    public static final byte U_TYPE_UBIGINT = 28;

    static boolean isCollectionType(byte type) {
        return type == 16 || type == 17 || type == 18;
    }

    static byte getObjArrBaseDBtype(Object values) {
        if (values instanceof String[]) {
            return 2;
        }
        if (values instanceof Byte[]) {
            return 9;
        }
        if (values instanceof byte[][]) {
            return 6;
        }
        if (values instanceof Boolean[]) {
            return 5;
        }
        if (values instanceof Short[]) {
            return 9;
        }
        if (values instanceof Integer[]) {
            return 8;
        }
        if (values instanceof Long[]) {
            return 21;
        }
        if (values instanceof Double[]) {
            return 12;
        }
        if (values instanceof Float[]) {
            return 11;
        }
        if (values instanceof BigDecimal[]) {
            return 7;
        }
        if (values instanceof Date[]) {
            return 13;
        }
        if (values instanceof Time[]) {
            return 14;
        }
        if (values instanceof Timestamp[]) {
            for (int i = 0; i < ((Object[])values).length; ++i) {
                if (CUBRIDTimestamp.isTimestampType((Timestamp)((Object[])values)[i])) continue;
                return 22;
            }
            return 15;
        }
        if (values instanceof CUBRIDOID[]) {
            return 19;
        }
        if (values instanceof CUBRIDBlob[]) {
            return 23;
        }
        if (values instanceof CUBRIDClob[]) {
            return 24;
        }
        return 0;
    }

    static byte getObjectDBtype(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof String) {
            return 2;
        }
        if (value instanceof Byte) {
            return 9;
        }
        if (value instanceof byte[]) {
            return 6;
        }
        if (value instanceof Boolean) {
            return 5;
        }
        if (value instanceof Short) {
            return 9;
        }
        if (value instanceof Integer) {
            return 8;
        }
        if (value instanceof Long) {
            return 21;
        }
        if (value instanceof Double) {
            return 12;
        }
        if (value instanceof Float) {
            return 11;
        }
        if (value instanceof BigDecimal || value instanceof Long) {
            return 7;
        }
        if (value instanceof Date) {
            return 13;
        }
        if (value instanceof Time) {
            return 14;
        }
        if (value instanceof Timestamp) {
            if (CUBRIDTimestamp.isTimestampType((Timestamp)value)) {
                return 15;
            }
            return 22;
        }
        if (value instanceof CUBRIDOID) {
            return 19;
        }
        if (value instanceof CUBRIDBlob) {
            return 23;
        }
        if (value instanceof CUBRIDClob) {
            return 24;
        }
        if (value instanceof Object[]) {
            return 18;
        }
        return 0;
    }
}

