/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import net.sf.jsqlparser.statement.create.view.AutoRefreshOption;
import net.sf.jsqlparser.statement.create.view.CreateView;
import net.sf.jsqlparser.statement.create.view.TemporaryOption;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import net.sf.jsqlparser.util.deparser.SelectDeParser;

public class CreateViewDeParser
extends AbstractDeParser<CreateView> {
    private final SelectVisitor selectVisitor;

    public CreateViewDeParser(StringBuilder buffer) {
        super(buffer);
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        this.selectVisitor = selectDeParser;
    }

    public CreateViewDeParser(StringBuilder buffer, SelectVisitor selectVisitor) {
        super(buffer);
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void deParse(CreateView createView) {
        this.buffer.append("CREATE ");
        if (createView.isOrReplace()) {
            this.buffer.append("OR REPLACE ");
        }
        switch (createView.getForce()) {
            case FORCE: {
                this.buffer.append("FORCE ");
                break;
            }
            case NO_FORCE: {
                this.buffer.append("NO FORCE ");
                break;
            }
            case NONE: {
                break;
            }
        }
        if (createView.getTemporary() != TemporaryOption.NONE) {
            this.buffer.append(createView.getTemporary().name()).append(" ");
        }
        if (createView.isMaterialized()) {
            this.buffer.append("MATERIALIZED ");
        }
        this.buffer.append("VIEW ").append(createView.getView().getFullyQualifiedName());
        if (createView.isIfNotExists()) {
            this.buffer.append(" IF NOT EXISTS");
        }
        if (createView.getAutoRefresh() != AutoRefreshOption.NONE) {
            this.buffer.append(" AUTO REFRESH ").append(createView.getAutoRefresh().name());
        }
        if (createView.getColumnNames() != null) {
            this.buffer.append(PlainSelect.getStringList(createView.getColumnNames(), true, true));
        }
        this.buffer.append(" AS ");
        Select select = createView.getSelect();
        if (select.getWithItemsList() != null) {
            this.buffer.append("WITH ");
            boolean first = true;
            for (WithItem item : select.getWithItemsList()) {
                if (!first) {
                    this.buffer.append(", ");
                } else {
                    first = false;
                }
                item.accept(this.selectVisitor);
            }
            this.buffer.append(" ");
        }
        createView.getSelect().getSelectBody().accept(this.selectVisitor);
        if (createView.isWithReadOnly()) {
            this.buffer.append(" WITH READ ONLY");
        }
    }
}

