/*-
 * #%L
 * JSQLParser library
 * %%
 * Copyright (C) 2004 - 2023 JSQLParser
 * %%
 * Dual licensed under GNU LGPL 2.1 or Apache License 2.0
 * #L%
 */
/* CCJSqlParser.java */
/* Generated By:JJTree&JavaCC: Do not edit this line. CCJSqlParser.java */
package net.sf.jsqlparser.parser;

import java.lang.reflect.Field;
import java.lang.Integer;

import net.sf.jsqlparser.parser.feature.*;
import net.sf.jsqlparser.expression.*;
import net.sf.jsqlparser.expression.operators.arithmetic.*;
import net.sf.jsqlparser.expression.operators.conditional.*;
import net.sf.jsqlparser.expression.operators.relational.*;
import net.sf.jsqlparser.schema.*;
import net.sf.jsqlparser.statement.*;
import net.sf.jsqlparser.statement.analyze.*;
import net.sf.jsqlparser.statement.alter.*;
import net.sf.jsqlparser.statement.alter.sequence.*;
import net.sf.jsqlparser.statement.comment.*;
import net.sf.jsqlparser.statement.create.function.*;
import net.sf.jsqlparser.statement.create.index.*;
import net.sf.jsqlparser.statement.create.procedure.*;
import net.sf.jsqlparser.statement.create.schema.*;
import net.sf.jsqlparser.statement.create.synonym.*;
import net.sf.jsqlparser.statement.create.sequence.*;
import net.sf.jsqlparser.statement.create.table.*;
import net.sf.jsqlparser.statement.create.view.*;
import net.sf.jsqlparser.statement.delete.*;
import net.sf.jsqlparser.statement.drop.*;
import net.sf.jsqlparser.statement.insert.*;
import net.sf.jsqlparser.statement.execute.*;
import net.sf.jsqlparser.statement.select.*;
import net.sf.jsqlparser.statement.show.*;
import net.sf.jsqlparser.statement.truncate.*;
import net.sf.jsqlparser.statement.update.*;
import net.sf.jsqlparser.statement.upsert.*;
import net.sf.jsqlparser.statement.merge.*;
import net.sf.jsqlparser.statement.grant.*;
import java.util.*;

/**
 * The parser generated by JavaCC
 */
public class CCJSqlParser extends AbstractJSqlParser<CCJSqlParser>/*@bgen(jjtree)*/implements CCJSqlParserTreeConstants, CCJSqlParserConstants {/*@bgen(jjtree)*/
  protected JJTCCJSqlParserState jjtree = new JJTCCJSqlParserState();public int bracketsCounter = 0;
    public int caseCounter = 0;
    public boolean interrupted = false;

    public CCJSqlParser withConfiguration(FeatureConfiguration configuration) {
        token_source.configuration = configuration;
        return this;
    }

    public FeatureConfiguration getConfiguration() {
        return token_source.configuration;
    }

    public CCJSqlParser me () {
        return this;
    }

    private void linkAST(ASTNodeAccess access, SimpleNode node) {
        access.setASTNode(node);
        node.jjtSetValue(access);
    }

    public Node getASTRoot() {
        return jjtree.rootNode();
    }

  final public Statement Statement() throws ParseException {/*@bgen(jjtree) Statement */
    SimpleNode jjtn000 = new SimpleNode(JJTSTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));IfElseStatement ifElseStatement = null;
    Statement stm = null;
    Statement stm2 = null;
    Expression condition;
    try {
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_IF:{
          jj_consume_token(K_IF);
          condition = Condition();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_ANALYZE:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_PURGE:
          case K_RENAME:
          case K_REPLACE:
          case K_RESET:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_SHOW:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUE:
          case K_VALUES:
          case K_WITH:
          case 379:{
            stm = SingleStatement();
            break;
            }
          case K_BEGIN:{
            stm = Block();
            break;
            }
          default:
            jj_la1[0] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
ifElseStatement = new IfElseStatement(condition, stm);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ST_SEMICOLON:{
            jj_consume_token(ST_SEMICOLON);
ifElseStatement.setUsingSemicolonForIfStatement(true);
            break;
            }
          default:
            jj_la1[1] = jj_gen;
            ;
          }
          if (jj_2_1(2)) {
            jj_consume_token(K_ELSE);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ALTER:
            case K_ANALYZE:
            case K_CALL:
            case K_COMMIT:
            case K_COMMENT:
            case K_CREATE:
            case K_DECLARE:
            case K_DELETE:
            case K_DESCRIBE:
            case K_DROP:
            case K_EXEC:
            case K_EXECUTE:
            case K_EXPLAIN:
            case K_GRANT:
            case K_INSERT:
            case K_MERGE:
            case K_PURGE:
            case K_RENAME:
            case K_REPLACE:
            case K_RESET:
            case K_ROLLBACK:
            case K_SAVEPOINT:
            case K_SELECT:
            case K_SET:
            case K_SHOW:
            case K_TRUNCATE:
            case K_UPDATE:
            case K_UPSERT:
            case K_USE:
            case K_VALUE:
            case K_VALUES:
            case K_WITH:
            case 379:{
              stm2 = SingleStatement();
              break;
              }
            case K_BEGIN:{
              stm2 = Block();
              break;
              }
            default:
              jj_la1[2] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
ifElseStatement.setElseStatement(stm2);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case ST_SEMICOLON:{
              jj_consume_token(ST_SEMICOLON);
ifElseStatement.setUsingSemicolonForElseStatement(true);
              break;
              }
            default:
              jj_la1[3] = jj_gen;
              ;
            }
          } else {
            ;
          }
          jj_consume_token(0);
          break;
          }
        case K_ALTER:
        case K_ANALYZE:
        case K_BEGIN:
        case K_CALL:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_DECLARE:
        case K_DELETE:
        case K_DESCRIBE:
        case K_DROP:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_GRANT:
        case K_INSERT:
        case K_MERGE:
        case K_PURGE:
        case K_RENAME:
        case K_REPLACE:
        case K_RESET:
        case K_ROLLBACK:
        case K_SAVEPOINT:
        case K_SELECT:
        case K_SET:
        case K_SHOW:
        case K_TRUNCATE:
        case K_UPDATE:
        case K_UPSERT:
        case K_USE:
        case K_VALUE:
        case K_VALUES:
        case K_WITH:
        case 379:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_ANALYZE:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_PURGE:
          case K_RENAME:
          case K_REPLACE:
          case K_RESET:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_SHOW:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUE:
          case K_VALUES:
          case K_WITH:
          case 379:{
            stm = SingleStatement();
            break;
            }
          case K_BEGIN:{
            stm = Block();
            break;
            }
          default:
            jj_la1[4] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ST_SEMICOLON:{
            jj_consume_token(ST_SEMICOLON);
            break;
            }
          default:
            jj_la1[5] = jj_gen;
            ;
          }
          jj_consume_token(0);
          break;
          }
        default:
          jj_la1[6] = jj_gen;
          if (getAsBoolean(Feature.allowUnsupportedStatements)) {
            stm = UnsupportedStatement();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
        }
        else
            {if (true) throw e;}
      }
jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtn000.jjtSetLastToken(getToken(0));
return ifElseStatement!=null ? ifElseStatement : stm;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Statement SingleStatement() throws ParseException {Statement stm = null;
    List<WithItem> with = null;
    try {
      if (jj_2_3(3)) {
        if (jj_2_2(2)) {
          with = WithList();
        } else {
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:
        case K_VALUE:
        case K_VALUES:
        case K_WITH:
        case 379:{
          stm = SelectWithWithItems(with);
          break;
          }
        case K_INSERT:{
          stm = Insert(with);
          break;
          }
        case K_UPDATE:{
          stm = Update(with);
          break;
          }
        case K_DELETE:{
          stm = Delete(with);
          break;
          }
        case K_MERGE:{
          stm = Merge(with);
          break;
          }
        default:
          jj_la1[7] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:
        case K_VALUE:
        case K_VALUES:
        case K_WITH:
        case 379:{
          stm = Select();
          break;
          }
        default:
          jj_la1[8] = jj_gen;
          if (jj_2_4(3)) {
            stm = Upsert();
          } else if (jj_2_5(2)) {
            stm = Alter();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_RENAME:{
              // @todo: merge this into the ALTER TABLE statement
                          stm = RenameTableStatement();
              break;
              }
            case K_CREATE:{
              stm = Create();
              break;
              }
            case K_DROP:{
              stm = Drop();
              break;
              }
            case K_ANALYZE:{
              stm = Analyze();
              break;
              }
            case K_TRUNCATE:{
              stm = Truncate();
              break;
              }
            case K_CALL:
            case K_EXEC:
            case K_EXECUTE:{
              stm = Execute();
              break;
              }
            case K_SET:{
              stm = Set();
              break;
              }
            case K_RESET:{
              stm = Reset();
              break;
              }
            case K_SHOW:{
              stm = Show();
              break;
              }
            case K_USE:{
              stm = Use();
              break;
              }
            case K_SAVEPOINT:{
              stm = SavepointStatement();
              break;
              }
            case K_ROLLBACK:{
              stm = RollbackStatement();
              break;
              }
            case K_COMMIT:{
              stm = Commit();
              break;
              }
            case K_COMMENT:{
              stm = Comment();
              break;
              }
            case K_DESCRIBE:{
              stm = Describe();
              break;
              }
            case K_EXPLAIN:{
              stm = Explain();
              break;
              }
            case K_DECLARE:{
              stm = Declare();
              break;
              }
            case K_GRANT:{
              stm = Grant();
              break;
              }
            case K_PURGE:{
              stm = PurgeStatement();
              break;
              }
            default:
              jj_la1[9] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
return stm;
    } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
            return null;
        } else
            {if (true) throw e;}
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Block Block() throws ParseException {/*@bgen(jjtree) Block */
    SimpleNode jjtn000 = new SimpleNode(JJTBLOCK);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Statements stmts = new Statements();
    List<Statement> list = new ArrayList<Statement>();
    Statement stm;
    Block block = new Block();
    try {
      jj_consume_token(K_BEGIN);
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ST_SEMICOLON:{
          ;
          break;
          }
        default:
          jj_la1[10] = jj_gen;
          break label_1;
        }
        jj_consume_token(ST_SEMICOLON);
      }
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALTER:
        case K_ANALYZE:
        case K_CALL:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_DECLARE:
        case K_DELETE:
        case K_DESCRIBE:
        case K_DROP:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_GRANT:
        case K_INSERT:
        case K_MERGE:
        case K_PURGE:
        case K_RENAME:
        case K_REPLACE:
        case K_RESET:
        case K_ROLLBACK:
        case K_SAVEPOINT:
        case K_SELECT:
        case K_SET:
        case K_SHOW:
        case K_TRUNCATE:
        case K_UPDATE:
        case K_UPSERT:
        case K_USE:
        case K_VALUE:
        case K_VALUES:
        case K_WITH:
        case 379:{
          stm = SingleStatement();
          break;
          }
        case K_BEGIN:{
          stm = Block();
          break;
          }
        default:
          jj_la1[11] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(ST_SEMICOLON);
list.add(stm);
        label_2:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_ANALYZE:
          case K_BEGIN:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_PURGE:
          case K_RENAME:
          case K_REPLACE:
          case K_RESET:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_SHOW:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUE:
          case K_VALUES:
          case K_WITH:
          case 379:{
            ;
            break;
            }
          default:
            jj_la1[12] = jj_gen;
            break label_2;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_ANALYZE:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_PURGE:
          case K_RENAME:
          case K_REPLACE:
          case K_RESET:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_SHOW:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUE:
          case K_VALUES:
          case K_WITH:
          case 379:{
            stm = SingleStatement();
            break;
            }
          case K_BEGIN:{
            stm = Block();
            break;
            }
          default:
            jj_la1[13] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(ST_SEMICOLON);
list.add(stm);
        }
      } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
        } else {
            {if (true) throw e;}
        }
      }
stmts.setStatements(list);
        block.setStatements(stmts);
      jj_consume_token(K_END);
      if (jj_2_6(2)) {
        jj_consume_token(ST_SEMICOLON);
block.setSemicolonAfterEnd(true);
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return block;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Statements Statements() throws ParseException {/*@bgen(jjtree) Statements */
    SimpleNode jjtn000 = new SimpleNode(JJTSTATEMENTS);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Statements stmts = new Statements();
    IfElseStatement ifElseStatement = null;
    Statement stm = null;
    Statement stm2 = null;
    Expression condition;
    try {
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ST_SEMICOLON:{
          ;
          break;
          }
        default:
          jj_la1[14] = jj_gen;
          break label_3;
        }
        jj_consume_token(ST_SEMICOLON);
      }
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_IF:{
          jj_consume_token(K_IF);
          condition = Condition();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_ANALYZE:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_PURGE:
          case K_RENAME:
          case K_REPLACE:
          case K_RESET:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_SHOW:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUE:
          case K_VALUES:
          case K_WITH:
          case 379:{
            stm = SingleStatement();
            break;
            }
          case K_BEGIN:{
            stm = Block();
            break;
            }
          default:
            jj_la1[15] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
ifElseStatement = new IfElseStatement(condition, stm);
          if (jj_2_7(2)) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case ST_SEMICOLON:{
              jj_consume_token(ST_SEMICOLON);
ifElseStatement.setUsingSemicolonForIfStatement(true);
              break;
              }
            default:
              jj_la1[16] = jj_gen;
              ;
            }
            jj_consume_token(K_ELSE);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ALTER:
            case K_ANALYZE:
            case K_CALL:
            case K_COMMIT:
            case K_COMMENT:
            case K_CREATE:
            case K_DECLARE:
            case K_DELETE:
            case K_DESCRIBE:
            case K_DROP:
            case K_EXEC:
            case K_EXECUTE:
            case K_EXPLAIN:
            case K_GRANT:
            case K_INSERT:
            case K_MERGE:
            case K_PURGE:
            case K_RENAME:
            case K_REPLACE:
            case K_RESET:
            case K_ROLLBACK:
            case K_SAVEPOINT:
            case K_SELECT:
            case K_SET:
            case K_SHOW:
            case K_TRUNCATE:
            case K_UPDATE:
            case K_UPSERT:
            case K_USE:
            case K_VALUE:
            case K_VALUES:
            case K_WITH:
            case 379:{
              stm2 = SingleStatement();
              break;
              }
            case K_BEGIN:{
              stm2 = Block();
              break;
              }
            default:
              jj_la1[17] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
ifElseStatement.setElseStatement(stm2);
          } else {
            ;
          }
stmts.add( ifElseStatement );
          break;
          }
        case K_ALTER:
        case K_ANALYZE:
        case K_BEGIN:
        case K_CALL:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_DECLARE:
        case K_DELETE:
        case K_DESCRIBE:
        case K_DROP:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_GRANT:
        case K_INSERT:
        case K_MERGE:
        case K_PURGE:
        case K_RENAME:
        case K_REPLACE:
        case K_RESET:
        case K_ROLLBACK:
        case K_SAVEPOINT:
        case K_SELECT:
        case K_SET:
        case K_SHOW:
        case K_TRUNCATE:
        case K_UPDATE:
        case K_UPSERT:
        case K_USE:
        case K_VALUE:
        case K_VALUES:
        case K_WITH:
        case 379:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_ANALYZE:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_PURGE:
          case K_RENAME:
          case K_REPLACE:
          case K_RESET:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_SHOW:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUE:
          case K_VALUES:
          case K_WITH:
          case 379:{
            stm = SingleStatement();
            break;
            }
          case K_BEGIN:{
            stm = Block();
            if (jj_2_8(2)) {
              jj_consume_token(ST_SEMICOLON);
            } else {
              ;
            }
            break;
            }
          default:
            jj_la1[18] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
stmts.add(stm);
          break;
          }
        default:
          jj_la1[19] = jj_gen;
          if (getAsBoolean(Feature.allowUnsupportedStatements)) {
            stm = UnsupportedStatement();
if ( !((UnsupportedStatement) stm).isEmpty() ) stmts.add(stm);
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        label_4:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ST_SEMICOLON:{
            ;
            break;
            }
          default:
            jj_la1[20] = jj_gen;
            break label_4;
          }
          jj_consume_token(ST_SEMICOLON);
if (stm2!=null)
                                ifElseStatement.setUsingSemicolonForElseStatement(true);
                             else if (ifElseStatement!=null)
                                ifElseStatement.setUsingSemicolonForIfStatement(true);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_IF:{
            jj_consume_token(K_IF);
            condition = Condition();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ALTER:
            case K_ANALYZE:
            case K_CALL:
            case K_COMMIT:
            case K_COMMENT:
            case K_CREATE:
            case K_DECLARE:
            case K_DELETE:
            case K_DESCRIBE:
            case K_DROP:
            case K_EXEC:
            case K_EXECUTE:
            case K_EXPLAIN:
            case K_GRANT:
            case K_INSERT:
            case K_MERGE:
            case K_PURGE:
            case K_RENAME:
            case K_REPLACE:
            case K_RESET:
            case K_ROLLBACK:
            case K_SAVEPOINT:
            case K_SELECT:
            case K_SET:
            case K_SHOW:
            case K_TRUNCATE:
            case K_UPDATE:
            case K_UPSERT:
            case K_USE:
            case K_VALUE:
            case K_VALUES:
            case K_WITH:
            case 379:{
              stm = SingleStatement();
              break;
              }
            case K_BEGIN:{
              stm = Block();
              break;
              }
            default:
              jj_la1[21] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
ifElseStatement = new IfElseStatement(condition, stm);
            if (jj_2_9(2)) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case ST_SEMICOLON:{
                jj_consume_token(ST_SEMICOLON);
ifElseStatement.setUsingSemicolonForIfStatement(true);
                break;
                }
              default:
                jj_la1[22] = jj_gen;
                ;
              }
              jj_consume_token(K_ELSE);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_ALTER:
              case K_ANALYZE:
              case K_CALL:
              case K_COMMIT:
              case K_COMMENT:
              case K_CREATE:
              case K_DECLARE:
              case K_DELETE:
              case K_DESCRIBE:
              case K_DROP:
              case K_EXEC:
              case K_EXECUTE:
              case K_EXPLAIN:
              case K_GRANT:
              case K_INSERT:
              case K_MERGE:
              case K_PURGE:
              case K_RENAME:
              case K_REPLACE:
              case K_RESET:
              case K_ROLLBACK:
              case K_SAVEPOINT:
              case K_SELECT:
              case K_SET:
              case K_SHOW:
              case K_TRUNCATE:
              case K_UPDATE:
              case K_UPSERT:
              case K_USE:
              case K_VALUE:
              case K_VALUES:
              case K_WITH:
              case 379:{
                stm2 = SingleStatement();
                break;
                }
              case K_BEGIN:{
                stm2 = Block();
                break;
                }
              default:
                jj_la1[23] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
ifElseStatement.setElseStatement(stm2);
            } else {
              ;
            }
stmts.add( ifElseStatement );
            break;
            }
          case K_ALTER:
          case K_ANALYZE:
          case K_BEGIN:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_PURGE:
          case K_RENAME:
          case K_REPLACE:
          case K_RESET:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_SHOW:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUE:
          case K_VALUES:
          case K_WITH:
          case 379:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ALTER:
            case K_ANALYZE:
            case K_CALL:
            case K_COMMIT:
            case K_COMMENT:
            case K_CREATE:
            case K_DECLARE:
            case K_DELETE:
            case K_DESCRIBE:
            case K_DROP:
            case K_EXEC:
            case K_EXECUTE:
            case K_EXPLAIN:
            case K_GRANT:
            case K_INSERT:
            case K_MERGE:
            case K_PURGE:
            case K_RENAME:
            case K_REPLACE:
            case K_RESET:
            case K_ROLLBACK:
            case K_SAVEPOINT:
            case K_SELECT:
            case K_SET:
            case K_SHOW:
            case K_TRUNCATE:
            case K_UPDATE:
            case K_UPSERT:
            case K_USE:
            case K_VALUE:
            case K_VALUES:
            case K_WITH:
            case 379:{
              stm = SingleStatement();
              break;
              }
            case K_BEGIN:{
              stm = Block();
              if (jj_2_10(2)) {
                jj_consume_token(ST_SEMICOLON);
              } else {
                ;
              }
              break;
              }
            default:
              jj_la1[24] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
stmts.add(stm);
            break;
            }
          default:
            jj_la1[25] = jj_gen;
            // For any reason, we can't LOOKAHEAD( { getAsBoolean(Feature.allowUnsupportedStatements) } ) here
                           // As it will result in a Stack Overflow
                           stm = UnsupportedStatement();
if ( !((UnsupportedStatement) stm).isEmpty() ) stmts.add(stm);
          }
        }
        jj_consume_token(0);
      } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
        } else {
            {if (true) throw e;}
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return stmts;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  void error_skipto(int kind) throws ParseException {ParseException e = generateParseException();
  Token t;
  do {
    t = getNextToken();
  } while (t.kind != kind && t.kind != EOF);
  }

  final public DeclareStatement Declare() throws ParseException {UserVariable userVariable;
    ColDataType colDataType;
    Expression defaultExpr = null;
    DeclareStatement stmt = new DeclareStatement();
    String typeName;
    String columnName;
    ColumnDefinition colDef;
    jj_consume_token(K_DECLARE);
    userVariable = UserVariable();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TABLE:{
      jj_consume_token(K_TABLE);
      jj_consume_token(379);
      colDef = ColumnDefinition();
stmt.withUserVariable(userVariable)
        .withDeclareType(DeclareType.TABLE)
        .addColumnDefinition(colDef);
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[26] = jj_gen;
          break label_5;
        }
        jj_consume_token(K_COMMA);
        colDef = ColumnDefinition();
stmt.addColumnDefinition(colDef);
      }
      jj_consume_token(380);
      break;
      }
    case K_AS:{
      jj_consume_token(K_AS);
      typeName = RelObjectName();
stmt.withUserVariable(userVariable)
                      .withDeclareType(DeclareType.AS)
                      .withTypeName(typeName);
      break;
      }
    case K_ARRAY_LITERAL:
    case K_BINARY:
    case K_BIT:
    case K_BYTES:
    case K_CHARACTER:
    case K_CHAR:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DOUBLE:
    case K_INTERVAL:
    case K_JSON:
    case K_SET:
    case K_STRING:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_XML:
    case DT_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      colDataType = ColDataType();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 381:{
        jj_consume_token(381);
        defaultExpr = Expression();
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        ;
      }
stmt.withDeclareType(DeclareType.TYPE)
                  .addType(userVariable, colDataType, defaultExpr);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[28] = jj_gen;
          break label_6;
        }
        jj_consume_token(K_COMMA);
        userVariable = UserVariable();
        colDataType = ColDataType();
defaultExpr = null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 381:{
          jj_consume_token(381);
          defaultExpr = Expression();
          break;
          }
        default:
          jj_la1[29] = jj_gen;
          ;
        }
stmt.addType(userVariable, colDataType, defaultExpr);
      }
      break;
      }
    default:
      jj_la1[30] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return stmt;
}

  final public SetStatement Set() throws ParseException {String namePart;
    Object name;
    ExpressionList expList;
    boolean useEqual = false;
    SetStatement set;
    Expression exp = null;
    Token tk = null;
    String effectParameter = null;
    jj_consume_token(K_SET);
    if (jj_2_11(3)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LOCAL:{
        tk = jj_consume_token(K_LOCAL);
        break;
        }
      case K_SESSION:{
        tk = jj_consume_token(K_SESSION);
        break;
        }
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
effectParameter = tk.image;
    } else {
      ;
    }
    if (jj_2_12(2)) {
      jj_consume_token(K_DATETIMELITERAL);
      jj_consume_token(K_ZONE);
name = "Time Zone"; useEqual=false;
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 396:
      case 424:{
        name = UserVariable();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 381:{
          jj_consume_token(381);
useEqual=true;
          break;
          }
        default:
          jj_la1[32] = jj_gen;
          ;
        }
        break;
        }
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALL:
      case K_ALTER:
      case K_ANALYZE:
      case K_ANY:
      case K_APPLY:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONNECT:
      case K_CONVERT:
      case K_COSTS:
      case K_CREATE:
      case K_CURRENT:
      case K_CYCLE:
      case K_DATABASE:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DOUBLE:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FROM:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GLOBAL:
      case K_GRANT:
      case K_GROUP:
      case K_GROUPING:
      case K_GUARD:
      case K_HISTORY:
      case K_HOPPING:
      case K_IF:
      case K_IIF:
      case K_IGNORE:
      case K_IN:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_INTERVAL:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OVERLAPS:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_PURGE:
      case K_QUALIFY:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_REFERENCES:
      case K_REFRESH:
      case K_RLIKE:
      case K_REGISTER:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_RIGHT:
      case K_ROLLBACK:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SEED:
      case K_SELECT:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_SOME:
      case K_START:
      case K_STORED:
      case K_STRING:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VERBOSE:
      case K_VIEW:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 385:
      case 386:
      case 387:
      case 388:
      case 389:{
        name = IdentifierChain();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 381:{
          jj_consume_token(381);
useEqual=true;
          break;
          }
        default:
          jj_la1[33] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    exp = Expression();
expList = new ExpressionList();
        expList.add(exp);
        set = new SetStatement(name, expList)
            .withUseEqual(useEqual)
            .withEffectParameter(effectParameter);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[35] = jj_gen;
        break label_7;
      }
useEqual=false;
      jj_consume_token(K_COMMA);
      if (jj_2_14(3)) {
        if (jj_2_13(2)) {
          jj_consume_token(K_DATETIMELITERAL);
          jj_consume_token(K_ZONE);
name = "Time Zone"; useEqual=false;
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ACTIVE:
          case K_ADD:
          case K_ADVANCE:
          case K_ADVISE:
          case K_AGAINST:
          case K_ALGORITHM:
          case K_ALL:
          case K_ALTER:
          case K_ANALYZE:
          case K_ANY:
          case K_APPLY:
          case K_ARCHIVE:
          case K_ARRAY_LITERAL:
          case K_AT:
          case K_ASC:
          case K_AUTHORIZATION:
          case K_AUTO:
          case K_BEGIN:
          case K_BERNOULLI:
          case K_BINARY:
          case K_BIT:
          case K_BLOCK:
          case K_BROWSE:
          case K_BY:
          case K_BYTES:
          case K_CACHE:
          case K_BUFFERS:
          case K_BYTE:
          case K_CALL:
          case K_CASCADE:
          case K_CASE:
          case K_CASEWHEN:
          case K_CAST:
          case K_CHARACTER:
          case K_CHANGE:
          case K_CHANGES:
          case K_CHECKPOINT:
          case K_CHAR:
          case K_CLOSE:
          case K_COLLATE:
          case K_COLUMN:
          case K_COLUMNS:
          case K_COMMIT:
          case K_COMMENT:
          case K_CONFLICT:
          case K_CONNECT:
          case K_CONVERT:
          case K_COSTS:
          case K_CREATE:
          case K_CYCLE:
          case K_DATABASE:
          case K_DECLARE:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_DEFAULT:
          case K_DEFERRABLE:
          case K_DELAYED:
          case K_DELETE:
          case K_DESC:
          case K_DESCRIBE:
          case K_DISABLE:
          case K_DISCONNECT:
          case K_DIV:
          case K_DDL:
          case K_DML:
          case K_DO:
          case K_DOMAIN:
          case K_DOUBLE:
          case K_DROP:
          case K_DUMP:
          case K_DUPLICATE:
          case K_ELEMENTS:
          case K_EMIT:
          case K_ENABLE:
          case K_END:
          case K_ESCAPE:
          case K_EXCLUDE:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_EXPLICIT:
          case K_EXTENDED:
          case K_EXTRACT:
          case K_ISOLATION:
          case K_FILTER:
          case K_FIRST:
          case K_FALSE:
          case K_FLUSH:
          case K_FOLLOWING:
          case K_FORMAT:
          case K_FULLTEXT:
          case K_FUNCTION:
          case K_GLOBAL:
          case K_GRANT:
          case K_GROUP:
          case K_GROUPING:
          case K_GUARD:
          case K_HISTORY:
          case K_HOPPING:
          case K_IF:
          case K_IIF:
          case K_IGNORE:
          case K_IN:
          case K_INCLUDE:
          case K_INCREMENT:
          case K_INDEX:
          case K_INSERT:
          case K_INTERLEAVE:
          case K_INTERPRET:
          case K_INTERVAL:
          case K_ISNULL:
          case K_JSON:
          case K_KEEP:
          case K_KEY:
          case K_KEYS:
          case K_FN:
          case K_LAST:
          case K_LEADING:
          case K_LEFT:
          case K_LIMIT:
          case K_LOCAL:
          case K_LOCKED:
          case K_LINK:
          case K_LOG:
          case K_MATCH:
          case K_MATCHED:
          case K_MATERIALIZED:
          case K_MAXVALUE:
          case K_MEMBER:
          case K_MERGE:
          case K_MINVALUE:
          case K_MODIFY:
          case K_MOVEMENT:
          case K_NEXT:
          case K_NO:
          case K_NOCACHE:
          case K_NOKEEP:
          case K_NOLOCK:
          case K_NOMAXVALUE:
          case K_NOMINVALUE:
          case K_NOORDER:
          case K_NOTHING:
          case K_NOTNULL:
          case K_NOVALIDATE:
          case K_NULLS:
          case K_NOWAIT:
          case K_OF:
          case K_OFF:
          case K_OFFSET:
          case K_ON:
          case K_OPEN:
          case K_ORDER:
          case K_OVER:
          case K_OVERLAPS:
          case K_OPTIMIZE:
          case K_PARALLEL:
          case K_PARENT:
          case K_PARTITION:
          case K_PATH:
          case K_PERCENT:
          case K_PLACING:
          case K_PRECEDING:
          case K_PRECISION:
          case K_PRIMARY:
          case K_PRIOR:
          case K_PROCEDURE:
          case K_PUBLIC:
          case K_PURGE:
          case K_QUALIFY:
          case K_QUERY:
          case K_QUICK:
          case K_QUIESCE:
          case K_RANGE:
          case K_RAW:
          case K_READ:
          case K_RECYCLEBIN:
          case K_REFERENCES:
          case K_REFRESH:
          case K_RLIKE:
          case K_REGISTER:
          case K_RENAME:
          case K_REPEATABLE:
          case K_REPLACE:
          case K_RESET:
          case K_RESTART:
          case K_RESUMABLE:
          case K_RESUME:
          case K_RESTRICT:
          case K_RESTRICTED:
          case K_RIGHT:
          case K_ROLLBACK:
          case K_ROOT:
          case K_ROW:
          case K_ROWS:
          case K_SAVEPOINT:
          case K_SCHEMA:
          case K_SEED:
          case K_SEQUENCE:
          case K_SEPARATOR:
          case K_SESSION:
          case K_SET:
          case K_SETS:
          case K_SHOW:
          case K_SHUTDOWN:
          case K_SIBLINGS:
          case K_SIMILAR:
          case K_SIZE:
          case K_SKIP:
          case K_SOME:
          case K_START:
          case K_STORED:
          case K_STRING:
          case K_SUSPEND:
          case K_SWITCH:
          case K_SYNONYM:
          case K_SYSTEM:
          case K_TABLE:
          case K_TABLES:
          case K_TABLESPACE:
          case K_TRIGGER:
          case K_THEN:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIME_KEY_EXPR:
          case K_TIMEOUT:
          case K_TO:
          case K_TOP:
          case K_TRUNCATE:
          case K_TRUE:
          case K_TUMBLING:
          case K_TYPE:
          case K_UNLOGGED:
          case K_UPDATE:
          case K_UPSERT:
          case K_UNQIESCE:
          case K_USER:
          case K_SIGNED:
          case K_STRING_FUNCTION_NAME:
          case K_UNSIGNED:
          case K_VALIDATE:
          case K_VALUE:
          case K_VALUES:
          case K_VERBOSE:
          case K_VIEW:
          case K_WAIT:
          case K_WITHIN:
          case K_WITHOUT:
          case K_WORK:
          case K_XML:
          case K_XMLAGG:
          case K_XMLDATA:
          case K_XMLSCHEMA:
          case K_XMLTEXT:
          case K_XSINIL:
          case K_YAML:
          case K_YES:
          case K_ZONE:
          case S_IDENTIFIER:
          case S_QUOTED_IDENTIFIER:
          case 385:
          case 386:
          case 387:
          case 388:
          case 389:{
            name = RelObjectNameExt();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 381:{
              jj_consume_token(381);
useEqual=true;
              break;
              }
            default:
              jj_la1[36] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[37] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        exp = Expression();
expList = new ExpressionList();
                    expList.add(exp);
                    set.add(name, expList, useEqual);
      } else if (jj_2_15(1)) {
        exp = Expression();
expList.add(exp);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return set;
}

  final public ResetStatement Reset() throws ParseException {String name;
    ResetStatement reset;
    Token all;
    jj_consume_token(K_RESET);
    if (jj_2_16(2)) {
      jj_consume_token(K_DATETIMELITERAL);
      jj_consume_token(K_ZONE);
name = "Time Zone";
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALTER:
      case K_ANALYZE:
      case K_APPLY:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONNECT:
      case K_CONVERT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATABASE:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GLOBAL:
      case K_GRANT:
      case K_GROUP:
      case K_GUARD:
      case K_HISTORY:
      case K_HOPPING:
      case K_IGNORE:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_INTERVAL:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_ON:
      case K_OPEN:
      case K_OVER:
      case K_OVERLAPS:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PURGE:
      case K_QUALIFY:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_REFERENCES:
      case K_REFRESH:
      case K_RLIKE:
      case K_REGISTER:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_ROLLBACK:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SEED:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_START:
      case K_STORED:
      case K_STRING:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VERBOSE:
      case K_VIEW:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 385:
      case 386:
      case 387:
      case 388:
      case 389:{
        name = RelObjectName();
        break;
        }
      case K_ALL:{
        all = jj_consume_token(K_ALL);
name = all.image;
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
reset = new ResetStatement(name);   return reset;
}

  final public RenameTableStatement RenameTableStatement() throws ParseException {RenameTableStatement renameTableStatement;
    Table oldName;
    Table newName;
    boolean usingTableKeyword=false;
    boolean usesIfExistsKeyword=false;
    String waitDirective = "";
    Token token;
    jj_consume_token(K_RENAME);
    if (jj_2_17(2)) {
      jj_consume_token(K_TABLE);
usingTableKeyword = true;
    } else {
      ;
    }
    if (jj_2_18(2)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_EXISTS);
usesIfExistsKeyword = true;
    } else {
      ;
    }
    oldName = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOWAIT:
    case K_WAIT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WAIT:{
        jj_consume_token(K_WAIT);
        token = jj_consume_token(S_LONG);
waitDirective = "WAIT " + token.image;
        break;
        }
      case K_NOWAIT:{
        jj_consume_token(K_NOWAIT);
waitDirective = "NOWAIT";
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      ;
    }
    jj_consume_token(K_TO);
    newName = Table();
renameTableStatement = new RenameTableStatement(oldName, newName, usingTableKeyword, usesIfExistsKeyword, waitDirective);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        break label_8;
      }
      jj_consume_token(K_COMMA);
      oldName = Table();
      jj_consume_token(K_TO);
      newName = Table();
renameTableStatement.addTableNames(oldName, newName);
    }
return renameTableStatement;
}

  final public PurgeStatement PurgeStatement() throws ParseException {PurgeStatement purgeStatement = null;
    Table table;
    Index index;
    Token tableSpaceToken;
    Token userToken = null;
    jj_consume_token(K_PURGE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TABLE:{
      jj_consume_token(K_TABLE);
      table = Table();
purgeStatement = new PurgeStatement(table);
      break;
      }
    case K_INDEX:{
      jj_consume_token(K_INDEX);
      index = Index();
purgeStatement = new PurgeStatement(index);
      break;
      }
    case K_RECYCLEBIN:{
      jj_consume_token(K_RECYCLEBIN);
purgeStatement = new PurgeStatement(PurgeObjectType.RECYCLEBIN);
      break;
      }
    case K_DBA_RECYCLEBIN:{
      jj_consume_token(K_DBA_RECYCLEBIN);
purgeStatement = new PurgeStatement(PurgeObjectType.DBA_RECYCLEBIN);
      break;
      }
    case K_TABLESPACE:{
      jj_consume_token(K_TABLESPACE);
      tableSpaceToken = jj_consume_token(S_IDENTIFIER);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_USER:{
        jj_consume_token(K_USER);
        userToken = jj_consume_token(S_IDENTIFIER);
        break;
        }
      default:
        jj_la1[42] = jj_gen;
        ;
      }
purgeStatement = new PurgeStatement(
                PurgeObjectType.TABLESPACE
                , tableSpaceToken.image
                , userToken!=null ? userToken.image : null);
      break;
      }
    default:
      jj_la1[43] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return purgeStatement;
}

  final public DescribeStatement Describe() throws ParseException {Table table;
    jj_consume_token(K_DESCRIBE);
    table = Table();
return new DescribeStatement(table);
}

  final public ExplainStatement Explain() throws ParseException {Select select;
    List<ExplainStatement.Option> options = null;
    jj_consume_token(K_EXPLAIN);
    options = ExplainStatementOptions();
    select = Select();
ExplainStatement es = new ExplainStatement(select);
       if(options != null && !options.isEmpty()) {
         for(ExplainStatement.Option o : options) {
           es.addOption(o);
         }
       }
       return es;
}

/**
 * Postgres supports TRUE,ON,1,FALSE,OFF,0 as values
 */
  final public String ExplainOptionBoolean() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FALSE:
    case K_OFF:
    case K_ON:
    case K_TRUE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TRUE:{
        tk = jj_consume_token(K_TRUE);
        break;
        }
      case K_FALSE:{
        tk = jj_consume_token(K_FALSE);
        break;
        }
      case K_ON:{
        tk = jj_consume_token(K_ON);
        break;
        }
      case K_OFF:{
        tk = jj_consume_token(K_OFF);
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[45] = jj_gen;
      ;
    }
return tk != null ? tk.image : null;
}

/**
 * The output format, which can be TEXT, XML, JSON, or YAML
 */
  final public String ExplainFormatOption() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_JSON:
    case K_XML:
    case K_YAML:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_XML:{
        tk = jj_consume_token(K_XML);
        break;
        }
      case K_JSON:{
        tk = jj_consume_token(K_JSON);
        break;
        }
      case K_YAML:{
        tk = jj_consume_token(K_YAML);
        break;
        }
      default:
        jj_la1[46] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[47] = jj_gen;
      ;
    }
return tk != null ? tk.image : null;
}

/**
 * Options for explain, see https://www.postgresql.org/docs/9.1/sql-explain.html
 */
  final public List<ExplainStatement.Option> ExplainStatementOptions() throws ParseException {List<ExplainStatement.Option> options = new ArrayList<ExplainStatement.Option>();
  ExplainStatement.Option option = null;
  Token token = null;
  String value = null;
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ANALYZE:
      case K_BUFFERS:
      case K_COSTS:
      case K_FORMAT:
      case K_VERBOSE:{
        ;
        break;
        }
      default:
        jj_la1[48] = jj_gen;
        break label_9;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ANALYZE:{
        jj_consume_token(K_ANALYZE);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.ANALYZE);
       option.setValue(value);
       options.add(option);
        break;
        }
      case K_BUFFERS:{
        jj_consume_token(K_BUFFERS);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.BUFFERS);
        option.setValue(value);
        options.add(option);
        break;
        }
      case K_COSTS:{
        jj_consume_token(K_COSTS);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.COSTS);
        option.setValue(value);
        options.add(option);
        break;
        }
      case K_VERBOSE:{
        jj_consume_token(K_VERBOSE);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.VERBOSE);
        option.setValue(value);
        options.add(option);
        break;
        }
      case K_FORMAT:{
        jj_consume_token(K_FORMAT);
        value = ExplainFormatOption();
option = new ExplainStatement.Option(ExplainStatement.OptionType.FORMAT);
        option.setValue(value);
        options.add(option);
        break;
        }
      default:
        jj_la1[49] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return options;
}

  final public UseStatement Use() throws ParseException {String name;
    boolean hasSchemaKeyword = false;
    jj_consume_token(K_USE);
    if (jj_2_19(2)) {
      jj_consume_token(K_SCHEMA);
hasSchemaKeyword = true;
    } else {
      ;
    }
    name = RelObjectNameExt();
return new UseStatement(name, hasSchemaKeyword);
}

  final public Statement Show() throws ParseException {Statement statement;
    List<String> captureRest;
    jj_consume_token(K_SHOW);
    if (jj_2_20(2)) {
      statement = ShowColumns();
    } else if (jj_2_21(2)) {
      statement = ShowIndex();
    } else if (jj_2_22(2)) {
      statement = ShowTables();
    } else {
      // any of the RDBMS specific SHOW syntax
              captureRest = captureRest();
if (captureRest.size()==1) {
                statement = new ShowStatement(captureRest.get(0));
            } else {
                statement = new UnsupportedStatement("SHOW", captureRest);
            }
    }
return statement;
}

  final public ShowColumnsStatement ShowColumns() throws ParseException {String tableName;
    jj_consume_token(K_COLUMNS);
    jj_consume_token(K_FROM);
    tableName = RelObjectNameExt();
return new ShowColumnsStatement(tableName);
}

  final public ShowIndexStatement ShowIndex() throws ParseException {String tableName;
    jj_consume_token(K_INDEX);
    jj_consume_token(K_FROM);
    tableName = RelObjectNameExt();
return new ShowIndexStatement(tableName);
}

// https://dev.mysql.com/doc/refman/8.0/en/show-tables.html
  final public ShowTablesStatement ShowTables() throws ParseException {ShowTablesStatement showTablesStatement;
    EnumSet<ShowTablesStatement.Modifiers> modifiers =  EnumSet.noneOf(ShowTablesStatement.Modifiers.class);
    ShowTablesStatement.SelectionMode selectionMode = null;
    String dbName = null;
    Expression likeExpression = null;
    Expression whereCondition = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXTENDED:{
      jj_consume_token(K_EXTENDED);
modifiers.add(ShowTablesStatement.Modifiers.EXTENDED);
      break;
      }
    default:
      jj_la1[50] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FULL:{
      jj_consume_token(K_FULL);
modifiers.add(ShowTablesStatement.Modifiers.FULL);
      break;
      }
    default:
      jj_la1[51] = jj_gen;
      ;
    }
    jj_consume_token(K_TABLES);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:
    case K_IN:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FROM:{
        jj_consume_token(K_FROM);
selectionMode = ShowTablesStatement.SelectionMode.FROM;
        break;
        }
      case K_IN:{
        jj_consume_token(K_IN);
selectionMode = ShowTablesStatement.SelectionMode.IN;
        break;
        }
      default:
        jj_la1[52] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      dbName = RelObjectNameExt();
      break;
      }
    default:
      jj_la1[53] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIKE:
    case K_WHERE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LIKE:{
        jj_consume_token(K_LIKE);
        likeExpression = SimpleExpression();
        break;
        }
      case K_WHERE:{
        jj_consume_token(K_WHERE);
        whereCondition = Expression();
        break;
        }
      default:
        jj_la1[54] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[55] = jj_gen;
      ;
    }
showTablesStatement = new ShowTablesStatement();
    showTablesStatement.setModifiers(modifiers);
    showTablesStatement.setSelectionMode(selectionMode);
    showTablesStatement.setDbName(dbName);
    showTablesStatement.setLikeExpression(likeExpression);
    showTablesStatement.setWhereCondition(whereCondition);
    return showTablesStatement;
}

  final public Values Values() throws ParseException {ExpressionList expressions;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_VALUES:{
      jj_consume_token(K_VALUES);
      break;
      }
    case K_VALUE:{
      jj_consume_token(K_VALUE);
      break;
      }
    default:
      jj_la1[56] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    expressions = ExpressionList();
return new Values(expressions);
}

  final public ReturningClause ReturningClause() throws ParseException {Token keyword;
    List<SelectItem<?>> selectItems;
    Object dataItem;
    List<Object> dataItems = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURNING:{
      keyword = jj_consume_token(K_RETURNING);
      break;
      }
    case 382:{
      keyword = jj_consume_token(382);
      break;
      }
    default:
      jj_la1[57] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    selectItems = SelectItemsList();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INTO:{
      jj_consume_token(K_INTO);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALL:
      case K_ALTER:
      case K_ANALYZE:
      case K_ANY:
      case K_APPLY:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONNECT:
      case K_CONVERT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATABASE:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DOUBLE:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GLOBAL:
      case K_GRANT:
      case K_GROUP:
      case K_GROUPING:
      case K_GUARD:
      case K_HISTORY:
      case K_HOPPING:
      case K_IF:
      case K_IIF:
      case K_IGNORE:
      case K_IN:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_INTERVAL:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OVERLAPS:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_PURGE:
      case K_QUALIFY:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_REFERENCES:
      case K_REFRESH:
      case K_RLIKE:
      case K_REGISTER:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_RIGHT:
      case K_ROLLBACK:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SEED:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_SOME:
      case K_START:
      case K_STORED:
      case K_STRING:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VERBOSE:
      case K_VIEW:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 385:
      case 386:
      case 387:
      case 388:
      case 389:{
        dataItem = Table();
        break;
        }
      case 396:
      case 424:{
        dataItem = UserVariable();
        break;
        }
      default:
        jj_la1[58] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
dataItems = new ArrayList<Object>(); dataItems.add(dataItem);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[59] = jj_gen;
          break label_10;
        }
        jj_consume_token(K_COMMA);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ACTIVE:
        case K_ADD:
        case K_ADVANCE:
        case K_ADVISE:
        case K_AGAINST:
        case K_ALGORITHM:
        case K_ALL:
        case K_ALTER:
        case K_ANALYZE:
        case K_ANY:
        case K_APPLY:
        case K_ARCHIVE:
        case K_ARRAY_LITERAL:
        case K_AT:
        case K_ASC:
        case K_AUTHORIZATION:
        case K_AUTO:
        case K_BEGIN:
        case K_BERNOULLI:
        case K_BINARY:
        case K_BIT:
        case K_BLOCK:
        case K_BROWSE:
        case K_BY:
        case K_BYTES:
        case K_CACHE:
        case K_BUFFERS:
        case K_BYTE:
        case K_CALL:
        case K_CASCADE:
        case K_CASE:
        case K_CASEWHEN:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHANGES:
        case K_CHECKPOINT:
        case K_CHAR:
        case K_CLOSE:
        case K_COLLATE:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CONFLICT:
        case K_CONNECT:
        case K_CONVERT:
        case K_COSTS:
        case K_CREATE:
        case K_CYCLE:
        case K_DATABASE:
        case K_DECLARE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DEFAULT:
        case K_DEFERRABLE:
        case K_DELAYED:
        case K_DELETE:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DISCONNECT:
        case K_DIV:
        case K_DDL:
        case K_DML:
        case K_DO:
        case K_DOMAIN:
        case K_DOUBLE:
        case K_DROP:
        case K_DUMP:
        case K_DUPLICATE:
        case K_ELEMENTS:
        case K_EMIT:
        case K_ENABLE:
        case K_END:
        case K_ESCAPE:
        case K_EXCLUDE:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_EXPLICIT:
        case K_EXTENDED:
        case K_EXTRACT:
        case K_ISOLATION:
        case K_FILTER:
        case K_FIRST:
        case K_FALSE:
        case K_FLUSH:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_FULLTEXT:
        case K_FUNCTION:
        case K_GLOBAL:
        case K_GRANT:
        case K_GROUP:
        case K_GROUPING:
        case K_GUARD:
        case K_HISTORY:
        case K_HOPPING:
        case K_IF:
        case K_IIF:
        case K_IGNORE:
        case K_IN:
        case K_INCLUDE:
        case K_INCREMENT:
        case K_INDEX:
        case K_INSERT:
        case K_INTERLEAVE:
        case K_INTERPRET:
        case K_INTERVAL:
        case K_ISNULL:
        case K_JSON:
        case K_KEEP:
        case K_KEY:
        case K_KEYS:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LEFT:
        case K_LIMIT:
        case K_LOCAL:
        case K_LOCKED:
        case K_LINK:
        case K_LOG:
        case K_MATCH:
        case K_MATCHED:
        case K_MATERIALIZED:
        case K_MAXVALUE:
        case K_MEMBER:
        case K_MERGE:
        case K_MINVALUE:
        case K_MODIFY:
        case K_MOVEMENT:
        case K_NEXT:
        case K_NO:
        case K_NOCACHE:
        case K_NOKEEP:
        case K_NOLOCK:
        case K_NOMAXVALUE:
        case K_NOMINVALUE:
        case K_NOORDER:
        case K_NOTHING:
        case K_NOTNULL:
        case K_NOVALIDATE:
        case K_NULLS:
        case K_NOWAIT:
        case K_OF:
        case K_OFF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OVERLAPS:
        case K_OPTIMIZE:
        case K_PARALLEL:
        case K_PARENT:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PLACING:
        case K_PRECEDING:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_PURGE:
        case K_QUALIFY:
        case K_QUERY:
        case K_QUICK:
        case K_QUIESCE:
        case K_RANGE:
        case K_RAW:
        case K_READ:
        case K_RECYCLEBIN:
        case K_REFERENCES:
        case K_REFRESH:
        case K_RLIKE:
        case K_REGISTER:
        case K_RENAME:
        case K_REPEATABLE:
        case K_REPLACE:
        case K_RESET:
        case K_RESTART:
        case K_RESUMABLE:
        case K_RESUME:
        case K_RESTRICT:
        case K_RESTRICTED:
        case K_RIGHT:
        case K_ROLLBACK:
        case K_ROOT:
        case K_ROW:
        case K_ROWS:
        case K_SAVEPOINT:
        case K_SCHEMA:
        case K_SEED:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SETS:
        case K_SHOW:
        case K_SHUTDOWN:
        case K_SIBLINGS:
        case K_SIMILAR:
        case K_SIZE:
        case K_SKIP:
        case K_SOME:
        case K_START:
        case K_STORED:
        case K_STRING:
        case K_SUSPEND:
        case K_SWITCH:
        case K_SYNONYM:
        case K_SYSTEM:
        case K_TABLE:
        case K_TABLES:
        case K_TABLESPACE:
        case K_TRIGGER:
        case K_THEN:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TUMBLING:
        case K_TYPE:
        case K_UNLOGGED:
        case K_UPDATE:
        case K_UPSERT:
        case K_UNQIESCE:
        case K_USER:
        case K_SIGNED:
        case K_STRING_FUNCTION_NAME:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VERBOSE:
        case K_VIEW:
        case K_WAIT:
        case K_WITHIN:
        case K_WITHOUT:
        case K_WORK:
        case K_XML:
        case K_XMLAGG:
        case K_XMLDATA:
        case K_XMLSCHEMA:
        case K_XMLTEXT:
        case K_XSINIL:
        case K_YAML:
        case K_YES:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:
        case 385:
        case 386:
        case 387:
        case 388:
        case 389:{
          dataItem = Table();
          break;
          }
        case 396:
        case 424:{
          dataItem = UserVariable();
          break;
          }
        default:
          jj_la1[60] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
dataItems.add(dataItem);
      }
      break;
      }
    default:
      jj_la1[61] = jj_gen;
      ;
    }
return new ReturningClause(keyword.image, selectItems, dataItems);
}

  final public Update Update(List<WithItem> with) throws ParseException {Update update = new Update();
    Table table = null;
    List<Join> startJoins = null;

    List<UpdateSet> updateSets;
    Expression where = null;
    FromItem fromItem = null;
    List<Join> joins = null;
    Limit limit = null;
    List<OrderByElement> orderByElements;
    boolean useColumnsBrackets = false;
    ReturningClause returningClause;
    Token tk = null;
    UpdateModifierPriority modifierPriority = null;
    boolean modifierIgnore = false;

    OutputClause outputClause = null;
    jj_consume_token(K_UPDATE);
update.setOracleHint(getOracleHint());
    if (jj_2_23(2)) {
      jj_consume_token(K_LOW_PRIORITY);
modifierPriority = UpdateModifierPriority.LOW_PRIORITY;
    } else {
      ;
    }
    if (jj_2_24(2)) {
      jj_consume_token(K_IGNORE);
modifierIgnore = true;
    } else {
      ;
    }
    table = TableWithAlias();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_APPLY:
    case K_COMMA:
    case K_CROSS:
    case K_FULL:
    case K_GLOBAL:
    case K_INNER:
    case K_STRAIGHT:
    case K_JOIN:
    case K_LEFT:
    case K_NATURAL:
    case K_OUTER:
    case K_RIGHT:{
      startJoins = JoinsList();
      break;
      }
    default:
      jj_la1[62] = jj_gen;
      ;
    }
    jj_consume_token(K_SET);
    updateSets = UpdateSets();
update.setUpdateSets(updateSets);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OUTPUT:{
      outputClause = OutputClause();
update.setOutputClause(outputClause);
      break;
      }
    default:
      jj_la1[63] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:{
      jj_consume_token(K_FROM);
      fromItem = FromItem();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_APPLY:
      case K_COMMA:
      case K_CROSS:
      case K_FULL:
      case K_GLOBAL:
      case K_INNER:
      case K_STRAIGHT:
      case K_JOIN:
      case K_LEFT:
      case K_NATURAL:
      case K_OUTER:
      case K_RIGHT:{
        joins = JoinsList();
        break;
        }
      default:
        jj_la1[64] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[65] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      where = WhereClause();
update.setWhere(where);
      break;
      }
    default:
      jj_la1[66] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
update.setOrderByElements(orderByElements);
      break;
      }
    default:
      jj_la1[67] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIMIT:{
      limit = PlainLimit();
update.setLimit(limit);
      break;
      }
    default:
      jj_la1[68] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURNING:
    case 382:{
      returningClause = ReturningClause();
update.setReturningClause(returningClause);
      break;
      }
    default:
      jj_la1[69] = jj_gen;
      ;
    }
return update.withWithItemsList(with)
              .withTable(table)
              .withStartJoins(startJoins)
              .withFromItem(fromItem)
              .withJoins(joins)
              .withModifierPriority(modifierPriority)
              .withModifierIgnore(modifierIgnore);
}

  final public List<UpdateSet> UpdateSets() throws ParseException {ArrayList<UpdateSet> updateSets = new ArrayList<UpdateSet>();
    UpdateSet updateSet;
    Column tableColumn;
    Expression valueExpression;

    ExpressionList<Column> columns;
    ExpressionList<Expression>values;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALL:
    case K_ALTER:
    case K_ANALYZE:
    case K_ANY:
    case K_APPLY:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CASEWHEN:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONNECT:
    case K_CONVERT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATABASE:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DOUBLE:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GLOBAL:
    case K_GRANT:
    case K_GROUP:
    case K_GROUPING:
    case K_GUARD:
    case K_HISTORY:
    case K_HOPPING:
    case K_IF:
    case K_IIF:
    case K_IGNORE:
    case K_IN:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LEFT:
    case K_LIMIT:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OVERLAPS:
    case K_OPTIMIZE:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_PURGE:
    case K_QUALIFY:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REFERENCES:
    case K_REFRESH:
    case K_RLIKE:
    case K_REGISTER:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_RIGHT:
    case K_ROLLBACK:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_SOME:
    case K_START:
    case K_STORED:
    case K_STRING:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 385:
    case 386:
    case 387:
    case 388:
    case 389:{
      tableColumn = Column();
      jj_consume_token(381);
      valueExpression = Expression();
updateSets.add( new UpdateSet (tableColumn, valueExpression));
      break;
      }
    case 379:{
updateSet = new UpdateSet(); updateSets.add(updateSet);
      columns = ParenthesedExpressionList();
updateSet.setColumns(columns);
      jj_consume_token(381);
      if (jj_2_25(3)) {
        valueExpression = ParenthesedSelect();
updateSet.setValues( new ExpressionList(valueExpression));
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 379:{
          values = ParenthesedExpressionList();
updateSet.setValues(values);
          break;
          }
        default:
          jj_la1[70] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[71] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:
      case 379:{
        ;
        break;
        }
      default:
        jj_la1[72] = jj_gen;
        break label_11;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        jj_consume_token(K_COMMA);
        tableColumn = Column();
        jj_consume_token(381);
        valueExpression = Expression();
updateSets.add( new UpdateSet (tableColumn, valueExpression));
        break;
        }
      case 379:{
updateSet = new UpdateSet(); updateSets.add(updateSet);
        columns = ParenthesedExpressionList();
updateSet.setColumns(columns);
        jj_consume_token(381);
        if (jj_2_26(3)) {
          valueExpression = ParenthesedSelect();
updateSet.setValues( new ExpressionList(valueExpression));
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 379:{
            values = ParenthesedExpressionList();
updateSet.setValues(values);
            break;
            }
          default:
            jj_la1[73] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[74] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return updateSets;
}

  final public Insert Insert(List<WithItem> with) throws ParseException {Insert insert = new Insert();
    Table table = null;
    Column tableColumn = null;
    ExpressionList<Column> columns = new ExpressionList<Column>();
    Expression exp = null;
    ReturningClause returningClause;
    Select select = null;
    boolean useDuplicate = false;
    Token tk = null;
    InsertModifierPriority modifierPriority = null;
    boolean modifierIgnore = false;

    List<UpdateSet> updateSets;
    List<UpdateSet> duplicateUpdateSets;

    String name = null;
    boolean useAs = false;
    OutputClause outputClause = null;

    InsertConflictTarget conflictTarget = null;
    InsertConflictAction conflictAction = null;
    jj_consume_token(K_INSERT);
insert.setOracleHint(getOracleHint());
    if (jj_2_27(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LOW_PRIORITY:{
        tk = jj_consume_token(K_LOW_PRIORITY);
        break;
        }
      case K_DELAYED:{
        tk = jj_consume_token(K_DELAYED);
        break;
        }
      case K_HIGH_PRIORITY:{
        tk = jj_consume_token(K_HIGH_PRIORITY);
        break;
        }
      default:
        jj_la1[75] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (tk!=null)
            modifierPriority = InsertModifierPriority.from(tk.image);
    } else {
      ;
    }
    if (jj_2_28(2)) {
      jj_consume_token(K_IGNORE);
modifierIgnore = true;
    } else {
      ;
    }
    if (jj_2_29(2)) {
      jj_consume_token(K_INTO);
    } else {
      ;
    }
    table = Table();
    if (jj_2_30(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AS:{
        jj_consume_token(K_AS);
useAs = true;
        break;
        }
      default:
        jj_la1[76] = jj_gen;
        ;
      }
      name = RelObjectNameWithoutValue();
table.setAlias(new Alias(name,useAs));
    } else {
      ;
    }
    if (jj_2_31(2)) {
      jj_consume_token(379);
      columns = ColumnList();
      jj_consume_token(380);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OUTPUT:{
      outputClause = OutputClause();
insert.setOutputClause(outputClause);
      break;
      }
    default:
      jj_la1[77] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SET:{
      jj_consume_token(K_SET);
      updateSets = UpdateSets();
insert.withSetUpdateSets(updateSets);
      break;
      }
    case K_SELECT:
    case K_VALUE:
    case K_VALUES:
    case K_WITH:
    case 379:{
      select = Select();
      break;
      }
    default:
      jj_la1[78] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_32(2)) {
      jj_consume_token(K_ON);
      jj_consume_token(K_DUPLICATE);
      jj_consume_token(K_KEY);
      jj_consume_token(K_UPDATE);
      duplicateUpdateSets = UpdateSets();
insert.withDuplicateUpdateSets(duplicateUpdateSets);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ON:{
      jj_consume_token(K_ON);
      jj_consume_token(K_CONFLICT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ON:
      case 379:{
        conflictTarget = InsertConflictTarget();
        break;
        }
      default:
        jj_la1[79] = jj_gen;
        ;
      }
      conflictAction = InsertConflictAction();
insert.withConflictTarget(conflictTarget).setConflictAction(conflictAction);
      break;
      }
    default:
      jj_la1[80] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURNING:
    case 382:{
      returningClause = ReturningClause();
insert.setReturningClause(returningClause);
      break;
      }
    default:
      jj_la1[81] = jj_gen;
      ;
    }
if (!columns.isEmpty()) {
            insert.setColumns(columns);
        }
        return insert.withWithItemsList(with)
              .withSelect(select)
              .withTable(table)
              .withModifierPriority(modifierPriority)
              .withModifierIgnore(modifierIgnore);
}

  final public InsertConflictTarget InsertConflictTarget() throws ParseException {String indexColumnName;
    ArrayList<String> indexColumnNames = new ArrayList<String>();
    Expression indexExpression = null;
    Expression whereExpression = null;
    String constraintName = null ;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 379:{
      jj_consume_token(379);
      indexColumnName = RelObjectNameExt2();
indexColumnNames.add(indexColumnName);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[82] = jj_gen;
          break label_12;
        }
        jj_consume_token(K_COMMA);
        indexColumnName = RelObjectNameExt2();
indexColumnNames.add(indexColumnName);
      }
      jj_consume_token(380);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WHERE:{
        whereExpression = WhereClause();
        break;
        }
      default:
        jj_la1[83] = jj_gen;
        ;
      }
      break;
      }
    case K_ON:{
      jj_consume_token(K_ON);
      jj_consume_token(K_CONSTRAINT);
      constraintName = RelObjectNameExt2();
      break;
      }
    default:
      jj_la1[84] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return new InsertConflictTarget(indexColumnNames, indexExpression, whereExpression, constraintName);
}

  final public InsertConflictAction InsertConflictAction() throws ParseException {InsertConflictAction conflictAction;
    Expression whereExpression = null;
    List<UpdateSet> updateSets;
    if (jj_2_33(2)) {
      jj_consume_token(K_DO);
      jj_consume_token(K_NOTHING);
conflictAction = new InsertConflictAction( ConflictActionType.DO_NOTHING );
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DO:{
        jj_consume_token(K_DO);
        jj_consume_token(K_UPDATE);
        jj_consume_token(K_SET);
conflictAction = new InsertConflictAction( ConflictActionType.DO_UPDATE );
        updateSets = UpdateSets();
conflictAction.setUpdateSets(updateSets);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHERE:{
          whereExpression = WhereClause();
          break;
          }
        default:
          jj_la1[85] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[86] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return conflictAction
                .withWhereExpression(whereExpression);
}

  final public OutputClause OutputClause() throws ParseException {List<SelectItem<?>> selectItemList = null;
    UserVariable tableVariable = null;
    Table outputTable = null;
    List<String> columnList = null;
    jj_consume_token(K_OUTPUT);
    selectItemList = SelectItemsList();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INTO:{
      jj_consume_token(K_INTO);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 396:
      case 424:{
        tableVariable = UserVariable();
        break;
        }
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALL:
      case K_ALTER:
      case K_ANALYZE:
      case K_ANY:
      case K_APPLY:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONNECT:
      case K_CONVERT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATABASE:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DOUBLE:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GLOBAL:
      case K_GRANT:
      case K_GROUP:
      case K_GROUPING:
      case K_GUARD:
      case K_HISTORY:
      case K_HOPPING:
      case K_IF:
      case K_IIF:
      case K_IGNORE:
      case K_IN:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_INTERVAL:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OVERLAPS:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_PURGE:
      case K_QUALIFY:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_REFERENCES:
      case K_REFRESH:
      case K_RLIKE:
      case K_REGISTER:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_RIGHT:
      case K_ROLLBACK:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SEED:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_SOME:
      case K_START:
      case K_STORED:
      case K_STRING:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VERBOSE:
      case K_VIEW:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 385:
      case 386:
      case 387:
      case 388:
      case 389:{
        outputTable = Table();
        break;
        }
      default:
        jj_la1[87] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_34(2)) {
        columnList = ColumnsNamesList();
      } else {
        ;
      }
      break;
      }
    default:
      jj_la1[88] = jj_gen;
      ;
    }
return new OutputClause(selectItemList, tableVariable, outputTable, columnList);
}

  final public Upsert Upsert() throws ParseException {Upsert upsert = new Upsert();
    Table table = null;
    ExpressionList<Column> columns;
    List<UpdateSet> updateSets;

    Select select = null;
    List<UpdateSet> duplicateUpdateSets;
    Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_UPSERT:{
      jj_consume_token(K_UPSERT);
upsert.setUpsertType(UpsertType.UPSERT);
      break;
      }
    case K_REPLACE:{
      jj_consume_token(K_REPLACE);
upsert.setUpsertType(UpsertType.REPLACE);
      break;
      }
    case K_INSERT:{
      jj_consume_token(K_INSERT);
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
upsert.setUpsertType(UpsertType.INSERT_OR_REPLACE);
      break;
      }
    default:
      jj_la1[89] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_35(2)) {
      jj_consume_token(K_INTO);
upsert.setUsingInto(true);
    } else {
      ;
    }
    table = Table();
upsert.setTable(table);
    if (jj_2_36(2)) {
      columns = ParenthesedColumnList();
upsert.setColumns(columns);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SET:{
      jj_consume_token(K_SET);
      updateSets = UpdateSets();
upsert.setUpdateSets(updateSets);
      break;
      }
    case K_SELECT:
    case K_VALUE:
    case K_VALUES:
    case K_WITH:
    case 379:{
      select = Select();
upsert.setSelect(select);
      break;
      }
    default:
      jj_la1[90] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ON:{
      jj_consume_token(K_ON);
      jj_consume_token(K_DUPLICATE);
      jj_consume_token(K_KEY);
      jj_consume_token(K_UPDATE);
      duplicateUpdateSets = UpdateSets();
upsert.setDuplicateUpdateSets(duplicateUpdateSets);
      break;
      }
    default:
      jj_la1[91] = jj_gen;
      ;
    }
return upsert;
}

  final public Delete Delete(List<WithItem> with) throws ParseException {Delete delete = new Delete();
    Table table = null;
    List<Table> tables = new ArrayList<Table>();
    Table usingTable = null;
    List<Table> usingList = new ArrayList<Table>();
    List<Join> joins = null;
    Expression where = null;
    Limit limit = null;
    List<OrderByElement> orderByElements;
    boolean hasFrom = false;
    Token tk = null;
    DeleteModifierPriority modifierPriority = null;
    boolean modifierIgnore = false;
    boolean modifierQuick = false;

    ReturningClause returningClause;
    OutputClause outputClause;
    jj_consume_token(K_DELETE);
delete.setOracleHint(getOracleHint());
    if (jj_2_37(2)) {
      jj_consume_token(K_LOW_PRIORITY);
modifierPriority = DeleteModifierPriority.LOW_PRIORITY;
    } else {
      ;
    }
    if (jj_2_38(2)) {
      jj_consume_token(K_QUICK);
modifierQuick = true;
    } else {
      ;
    }
    if (jj_2_39(2)) {
      jj_consume_token(K_IGNORE);
modifierIgnore = true;
    } else {
      ;
    }
    if (jj_2_40(4)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALL:
      case K_ALTER:
      case K_ANALYZE:
      case K_ANY:
      case K_APPLY:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONNECT:
      case K_CONVERT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATABASE:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DOUBLE:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GLOBAL:
      case K_GRANT:
      case K_GROUP:
      case K_GROUPING:
      case K_GUARD:
      case K_HISTORY:
      case K_HOPPING:
      case K_IF:
      case K_IIF:
      case K_IGNORE:
      case K_IN:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_INTERVAL:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OVERLAPS:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_PURGE:
      case K_QUALIFY:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_REFERENCES:
      case K_REFRESH:
      case K_RLIKE:
      case K_REGISTER:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_RIGHT:
      case K_ROLLBACK:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SEED:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_SOME:
      case K_START:
      case K_STORED:
      case K_STRING:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VERBOSE:
      case K_VIEW:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 385:
      case 386:
      case 387:
      case 388:
      case 389:{
        table = TableWithAlias();
tables.add(table);
        label_13:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[92] = jj_gen;
            break label_13;
          }
          jj_consume_token(K_COMMA);
          table = TableWithAlias();
tables.add(table);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_OUTPUT:{
          outputClause = OutputClause();
delete.setOutputClause(outputClause);
          break;
          }
        default:
          jj_la1[93] = jj_gen;
          ;
        }
        jj_consume_token(K_FROM);
        break;
        }
      case K_FROM:{
        jj_consume_token(K_FROM);
        break;
        }
      default:
        jj_la1[94] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
hasFrom = true;
    } else {
      ;
    }
    if (jj_2_41(3)) {
      table = TableWithAlias();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_APPLY:
      case K_COMMA:
      case K_CROSS:
      case K_FULL:
      case K_GLOBAL:
      case K_INNER:
      case K_STRAIGHT:
      case K_JOIN:
      case K_LEFT:
      case K_NATURAL:
      case K_OUTER:
      case K_RIGHT:{
        joins = JoinsList();
        break;
        }
      default:
        jj_la1[95] = jj_gen;
        ;
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_USING:{
      jj_consume_token(K_USING);
      usingTable = TableWithAlias();
usingList.add(usingTable);
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[96] = jj_gen;
          break label_14;
        }
        jj_consume_token(K_COMMA);
        usingTable = TableWithAlias();
usingList.add(usingTable);
      }
      break;
      }
    default:
      jj_la1[97] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      where = WhereClause();
delete.setWhere(where);
      break;
      }
    default:
      jj_la1[98] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
delete.setOrderByElements(orderByElements);
      break;
      }
    default:
      jj_la1[99] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIMIT:{
      limit = PlainLimit();
delete.setLimit(limit);
      break;
      }
    default:
      jj_la1[100] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURNING:
    case 382:{
      returningClause = ReturningClause();
delete.setReturningClause(returningClause);
      break;
      }
    default:
      jj_la1[101] = jj_gen;
      ;
    }
if (joins != null && joins.size() > 0) {
            delete.setJoins(joins);
        }
        return delete.withWithItemsList(with)
              .withTables(tables)
              .withTable(table)
              .withHasFrom(hasFrom)
              .withUsingList(usingList)
              .withModifierPriority(modifierPriority)
              .withModifierIgnore(modifierIgnore)
              .withModifierQuick(modifierQuick);
}

  final public Statement Merge(List<WithItem> with) throws ParseException {Merge merge = new Merge();
    Table table;
    FromItem fromItem;
    Expression condition;
    MergeUpdate update;
    MergeInsert insert;
    jj_consume_token(K_MERGE);
merge.setOracleHint(getOracleHint());
    jj_consume_token(K_INTO);
    table = TableWithAlias();
merge.setTable(table);
    jj_consume_token(K_USING);
    fromItem = FromItem();
merge.setFromItem(fromItem);
    jj_consume_token(K_ON);
    jj_consume_token(379);
    condition = Expression();
merge.setOnCondition(condition);
    jj_consume_token(380);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHEN:{
      if (jj_2_42(2)) {
        update = MergeUpdateClause();
merge.setMergeUpdate(update);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          insert = MergeInsertClause();
merge.setMergeInsert(insert);
          break;
          }
        default:
          jj_la1[102] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          insert = MergeInsertClause();
merge.withMergeInsert(insert).withInsertFirst(true);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_WHEN:{
            update = MergeUpdateClause();
merge.setMergeUpdate(update);
            break;
            }
          default:
            jj_la1[103] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[104] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[105] = jj_gen;
      ;
    }
return merge.withWithItemsList(with);
}

  final public MergeUpdate MergeUpdateClause() throws ParseException {MergeUpdate mu;
    List<UpdateSet> updateSets;
    Expression condition;
    jj_consume_token(K_WHEN);
    jj_consume_token(K_MATCHED);
    jj_consume_token(K_THEN);
    jj_consume_token(K_UPDATE);
    jj_consume_token(K_SET);
    updateSets = UpdateSets();
mu = new MergeUpdate(updateSets);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      jj_consume_token(K_WHERE);
      condition = Expression();
mu.setWhereCondition(condition);
      break;
      }
    default:
      jj_la1[106] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DELETE:{
      jj_consume_token(K_DELETE);
      jj_consume_token(K_WHERE);
      condition = Expression();
mu.setDeleteWhereCondition(condition);
      break;
      }
    default:
      jj_la1[107] = jj_gen;
      ;
    }
return mu;
}

  final public MergeInsert MergeInsertClause() throws ParseException {MergeInsert mi = new MergeInsert();
    ExpressionList<Column> columns;
    ExpressionList expList;
    Expression condition;
    jj_consume_token(K_WHEN);
    jj_consume_token(K_NOT);
    jj_consume_token(K_MATCHED);
    jj_consume_token(K_THEN);
    jj_consume_token(K_INSERT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 379:{
      jj_consume_token(379);
      columns = ColumnList();
      jj_consume_token(380);
mi.setColumns( new ParenthesedExpressionList<Column>(columns) );
      break;
      }
    default:
      jj_la1[108] = jj_gen;
      ;
    }
    jj_consume_token(K_VALUES);
    jj_consume_token(379);
    expList = SimpleExpressionList();
    jj_consume_token(380);
mi.setValues( new ParenthesedExpressionList(expList) );
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      jj_consume_token(K_WHERE);
      condition = Expression();
mi.setWhereCondition(condition);
      break;
      }
    default:
      jj_la1[109] = jj_gen;
      ;
    }
return mi;
}

  final public List<String> RelObjectNameList() throws ParseException {String token = null;
    List<String> data = new ArrayList<String>();
    token = RelObjectNameExt();
data.add(token);
    label_15:
    while (true) {
      if (jj_2_43(2)) {
        ;
      } else {
        break label_15;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 383:{
        jj_consume_token(383);
        break;
        }
      case 384:{
        jj_consume_token(384);
        break;
        }
      default:
        jj_la1[110] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 383:{
          ;
          break;
          }
        default:
          jj_la1[111] = jj_gen;
          break label_16;
        }
        jj_consume_token(383);
data.add(null);
      }
      token = RelObjectNameExt2();
data.add(token);
    }
return data;
}

// See: http://technet.microsoft.com/en-us/library/ms187879%28v=sql.105%29.aspx
  final public 
Column Column() throws ParseException {/*@bgen(jjtree) Column */
    SimpleNode jjtn000 = new SimpleNode(JJTCOLUMN);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));List<String> data = new ArrayList<String>();
    ArrayConstructor arrayConstructor = null;
    try {
      data = RelObjectNameList();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 383:{
        jj_consume_token(383);
        jj_consume_token(K_NEXTVAL);
data.add("nextval");
        break;
        }
      default:
        jj_la1[112] = jj_gen;
        ;
      }
      if (jj_2_44(2)) {
        arrayConstructor = ArrayConstructor(false);
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Column col = new Column(data);
        if (arrayConstructor!=null) {
            col.setArrayConstructor(arrayConstructor);
        }
        linkAST(col,jjtn000);
        return col;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

/*
The following tokens are allowed as Names for Schema, Table, Column and Aliases
*/

// Generated Code! Please do not edit manually.
// Instead:
// 1) define the ALL_RESERVED_KEYWORDS in the PARSER DECLARATION above (line 157 ff)
// 2) run the Gradle Task :JSQLParser:updateKeywords, which would update/replace the content of this method
  final public String RelObjectNameWithoutValue() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      tk = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    case K_DATE_LITERAL:{
      tk = jj_consume_token(K_DATE_LITERAL);
      break;
      }
    case K_DATETIMELITERAL:{
      tk = jj_consume_token(K_DATETIMELITERAL);
      break;
      }
    case K_STRING_FUNCTION_NAME:{
      tk = jj_consume_token(K_STRING_FUNCTION_NAME);
      break;
      }
    case K_ISOLATION:{
      tk = jj_consume_token(K_ISOLATION);
      break;
      }
    case K_TIME_KEY_EXPR:{
      tk = jj_consume_token(K_TIME_KEY_EXPR);
      break;
      }
    case K_ACTION:{
      tk = jj_consume_token(K_ACTION);
      break;
      }
    case K_ACTIVE:{
      tk = jj_consume_token(K_ACTIVE);
      break;
      }
    case K_ADD:{
      tk = jj_consume_token(K_ADD);
      break;
      }
    case K_ADVANCE:{
      tk = jj_consume_token(K_ADVANCE);
      break;
      }
    case K_ADVISE:{
      tk = jj_consume_token(K_ADVISE);
      break;
      }
    case K_AGAINST:{
      tk = jj_consume_token(K_AGAINST);
      break;
      }
    case K_ALGORITHM:{
      tk = jj_consume_token(K_ALGORITHM);
      break;
      }
    case K_ALTER:{
      tk = jj_consume_token(K_ALTER);
      break;
      }
    case K_ANALYZE:{
      tk = jj_consume_token(K_ANALYZE);
      break;
      }
    case K_APPLY:{
      tk = jj_consume_token(K_APPLY);
      break;
      }
    case K_ARCHIVE:{
      tk = jj_consume_token(K_ARCHIVE);
      break;
      }
    case K_ARRAY_LITERAL:{
      tk = jj_consume_token(K_ARRAY_LITERAL);
      break;
      }
    case K_ASC:{
      tk = jj_consume_token(K_ASC);
      break;
      }
    case K_AT:{
      tk = jj_consume_token(K_AT);
      break;
      }
    case K_AUTHORIZATION:{
      tk = jj_consume_token(K_AUTHORIZATION);
      break;
      }
    case K_AUTO:{
      tk = jj_consume_token(K_AUTO);
      break;
      }
    case K_BEGIN:{
      tk = jj_consume_token(K_BEGIN);
      break;
      }
    case K_BERNOULLI:{
      tk = jj_consume_token(K_BERNOULLI);
      break;
      }
    case K_BINARY:{
      tk = jj_consume_token(K_BINARY);
      break;
      }
    case K_BIT:{
      tk = jj_consume_token(K_BIT);
      break;
      }
    case K_BLOCK:{
      tk = jj_consume_token(K_BLOCK);
      break;
      }
    case K_BROWSE:{
      tk = jj_consume_token(K_BROWSE);
      break;
      }
    case K_BUFFERS:{
      tk = jj_consume_token(K_BUFFERS);
      break;
      }
    case K_BY:{
      tk = jj_consume_token(K_BY);
      break;
      }
    case K_BYTE:{
      tk = jj_consume_token(K_BYTE);
      break;
      }
    case K_BYTES:{
      tk = jj_consume_token(K_BYTES);
      break;
      }
    case K_CACHE:{
      tk = jj_consume_token(K_CACHE);
      break;
      }
    case K_CALL:{
      tk = jj_consume_token(K_CALL);
      break;
      }
    case K_CASCADE:{
      tk = jj_consume_token(K_CASCADE);
      break;
      }
    case K_CASE:{
      tk = jj_consume_token(K_CASE);
      break;
      }
    case K_CAST:{
      tk = jj_consume_token(K_CAST);
      break;
      }
    case K_CHANGE:{
      tk = jj_consume_token(K_CHANGE);
      break;
      }
    case K_CHANGES:{
      tk = jj_consume_token(K_CHANGES);
      break;
      }
    case K_CHAR:{
      tk = jj_consume_token(K_CHAR);
      break;
      }
    case K_CHARACTER:{
      tk = jj_consume_token(K_CHARACTER);
      break;
      }
    case K_CHECKPOINT:{
      tk = jj_consume_token(K_CHECKPOINT);
      break;
      }
    case K_CLOSE:{
      tk = jj_consume_token(K_CLOSE);
      break;
      }
    case K_COLLATE:{
      tk = jj_consume_token(K_COLLATE);
      break;
      }
    case K_COLUMN:{
      tk = jj_consume_token(K_COLUMN);
      break;
      }
    case K_COLUMNS:{
      tk = jj_consume_token(K_COLUMNS);
      break;
      }
    case K_COMMENT:{
      tk = jj_consume_token(K_COMMENT);
      break;
      }
    case K_COMMIT:{
      tk = jj_consume_token(K_COMMIT);
      break;
      }
    case K_CONFLICT:{
      tk = jj_consume_token(K_CONFLICT);
      break;
      }
    case K_CONVERT:{
      tk = jj_consume_token(K_CONVERT);
      break;
      }
    case K_COSTS:{
      tk = jj_consume_token(K_COSTS);
      break;
      }
    case 385:{
      tk = jj_consume_token(385);
      break;
      }
    case K_CYCLE:{
      tk = jj_consume_token(K_CYCLE);
      break;
      }
    case K_DATABASE:{
      tk = jj_consume_token(K_DATABASE);
      break;
      }
    case K_DDL:{
      tk = jj_consume_token(K_DDL);
      break;
      }
    case K_DECLARE:{
      tk = jj_consume_token(K_DECLARE);
      break;
      }
    case K_DEFAULT:{
      tk = jj_consume_token(K_DEFAULT);
      break;
      }
    case K_DEFERRABLE:{
      tk = jj_consume_token(K_DEFERRABLE);
      break;
      }
    case K_DELAYED:{
      tk = jj_consume_token(K_DELAYED);
      break;
      }
    case K_DELETE:{
      tk = jj_consume_token(K_DELETE);
      break;
      }
    case K_DESC:{
      tk = jj_consume_token(K_DESC);
      break;
      }
    case K_DESCRIBE:{
      tk = jj_consume_token(K_DESCRIBE);
      break;
      }
    case K_DISABLE:{
      tk = jj_consume_token(K_DISABLE);
      break;
      }
    case K_DISCONNECT:{
      tk = jj_consume_token(K_DISCONNECT);
      break;
      }
    case K_DIV:{
      tk = jj_consume_token(K_DIV);
      break;
      }
    case K_DML:{
      tk = jj_consume_token(K_DML);
      break;
      }
    case K_DO:{
      tk = jj_consume_token(K_DO);
      break;
      }
    case K_DOMAIN:{
      tk = jj_consume_token(K_DOMAIN);
      break;
      }
    case K_DROP:{
      tk = jj_consume_token(K_DROP);
      break;
      }
    case K_DUMP:{
      tk = jj_consume_token(K_DUMP);
      break;
      }
    case K_DUPLICATE:{
      tk = jj_consume_token(K_DUPLICATE);
      break;
      }
    case K_ELEMENTS:{
      tk = jj_consume_token(K_ELEMENTS);
      break;
      }
    case K_EMIT:{
      tk = jj_consume_token(K_EMIT);
      break;
      }
    case K_ENABLE:{
      tk = jj_consume_token(K_ENABLE);
      break;
      }
    case K_END:{
      tk = jj_consume_token(K_END);
      break;
      }
    case K_ESCAPE:{
      tk = jj_consume_token(K_ESCAPE);
      break;
      }
    case K_EXCLUDE:{
      tk = jj_consume_token(K_EXCLUDE);
      break;
      }
    case K_EXEC:{
      tk = jj_consume_token(K_EXEC);
      break;
      }
    case K_EXECUTE:{
      tk = jj_consume_token(K_EXECUTE);
      break;
      }
    case K_EXPLAIN:{
      tk = jj_consume_token(K_EXPLAIN);
      break;
      }
    case K_EXPLICIT:{
      tk = jj_consume_token(K_EXPLICIT);
      break;
      }
    case K_EXTENDED:{
      tk = jj_consume_token(K_EXTENDED);
      break;
      }
    case K_EXTRACT:{
      tk = jj_consume_token(K_EXTRACT);
      break;
      }
    case K_FALSE:{
      tk = jj_consume_token(K_FALSE);
      break;
      }
    case K_FILTER:{
      tk = jj_consume_token(K_FILTER);
      break;
      }
    case K_FIRST:{
      tk = jj_consume_token(K_FIRST);
      break;
      }
    case K_FLUSH:{
      tk = jj_consume_token(K_FLUSH);
      break;
      }
    case K_FN:{
      tk = jj_consume_token(K_FN);
      break;
      }
    case K_FOLLOWING:{
      tk = jj_consume_token(K_FOLLOWING);
      break;
      }
    case K_FORMAT:{
      tk = jj_consume_token(K_FORMAT);
      break;
      }
    case K_FULLTEXT:{
      tk = jj_consume_token(K_FULLTEXT);
      break;
      }
    case K_FUNCTION:{
      tk = jj_consume_token(K_FUNCTION);
      break;
      }
    case K_GLOBAL:{
      tk = jj_consume_token(K_GLOBAL);
      break;
      }
    case K_GRANT:{
      tk = jj_consume_token(K_GRANT);
      break;
      }
    case K_GUARD:{
      tk = jj_consume_token(K_GUARD);
      break;
      }
    case K_HISTORY:{
      tk = jj_consume_token(K_HISTORY);
      break;
      }
    case K_HOPPING:{
      tk = jj_consume_token(K_HOPPING);
      break;
      }
    case K_INCLUDE:{
      tk = jj_consume_token(K_INCLUDE);
      break;
      }
    case K_INCREMENT:{
      tk = jj_consume_token(K_INCREMENT);
      break;
      }
    case K_INDEX:{
      tk = jj_consume_token(K_INDEX);
      break;
      }
    case K_INSERT:{
      tk = jj_consume_token(K_INSERT);
      break;
      }
    case K_INTERLEAVE:{
      tk = jj_consume_token(K_INTERLEAVE);
      break;
      }
    case K_INTERPRET:{
      tk = jj_consume_token(K_INTERPRET);
      break;
      }
    case K_ISNULL:{
      tk = jj_consume_token(K_ISNULL);
      break;
      }
    case K_JSON:{
      tk = jj_consume_token(K_JSON);
      break;
      }
    case K_KEEP:{
      tk = jj_consume_token(K_KEEP);
      break;
      }
    case K_KEY:{
      tk = jj_consume_token(K_KEY);
      break;
      }
    case K_KEYS:{
      tk = jj_consume_token(K_KEYS);
      break;
      }
    case K_LAST:{
      tk = jj_consume_token(K_LAST);
      break;
      }
    case K_LEADING:{
      tk = jj_consume_token(K_LEADING);
      break;
      }
    case K_LINK:{
      tk = jj_consume_token(K_LINK);
      break;
      }
    case K_LOCAL:{
      tk = jj_consume_token(K_LOCAL);
      break;
      }
    case K_LOCKED:{
      tk = jj_consume_token(K_LOCKED);
      break;
      }
    case K_LOG:{
      tk = jj_consume_token(K_LOG);
      break;
      }
    case K_MATCH:{
      tk = jj_consume_token(K_MATCH);
      break;
      }
    case K_MATCHED:{
      tk = jj_consume_token(K_MATCHED);
      break;
      }
    case K_MATERIALIZED:{
      tk = jj_consume_token(K_MATERIALIZED);
      break;
      }
    case K_MAXVALUE:{
      tk = jj_consume_token(K_MAXVALUE);
      break;
      }
    case K_MEMBER:{
      tk = jj_consume_token(K_MEMBER);
      break;
      }
    case K_MERGE:{
      tk = jj_consume_token(K_MERGE);
      break;
      }
    case K_MINVALUE:{
      tk = jj_consume_token(K_MINVALUE);
      break;
      }
    case K_MODIFY:{
      tk = jj_consume_token(K_MODIFY);
      break;
      }
    case K_MOVEMENT:{
      tk = jj_consume_token(K_MOVEMENT);
      break;
      }
    case K_NEXT:{
      tk = jj_consume_token(K_NEXT);
      break;
      }
    case K_NO:{
      tk = jj_consume_token(K_NO);
      break;
      }
    case K_NOCACHE:{
      tk = jj_consume_token(K_NOCACHE);
      break;
      }
    case K_NOKEEP:{
      tk = jj_consume_token(K_NOKEEP);
      break;
      }
    case K_NOLOCK:{
      tk = jj_consume_token(K_NOLOCK);
      break;
      }
    case K_NOMAXVALUE:{
      tk = jj_consume_token(K_NOMAXVALUE);
      break;
      }
    case K_NOMINVALUE:{
      tk = jj_consume_token(K_NOMINVALUE);
      break;
      }
    case K_NOORDER:{
      tk = jj_consume_token(K_NOORDER);
      break;
      }
    case K_NOTHING:{
      tk = jj_consume_token(K_NOTHING);
      break;
      }
    case K_NOTNULL:{
      tk = jj_consume_token(K_NOTNULL);
      break;
      }
    case K_NOVALIDATE:{
      tk = jj_consume_token(K_NOVALIDATE);
      break;
      }
    case K_NOWAIT:{
      tk = jj_consume_token(K_NOWAIT);
      break;
      }
    case K_NULLS:{
      tk = jj_consume_token(K_NULLS);
      break;
      }
    case K_OF:{
      tk = jj_consume_token(K_OF);
      break;
      }
    case K_OFF:{
      tk = jj_consume_token(K_OFF);
      break;
      }
    case K_OPEN:{
      tk = jj_consume_token(K_OPEN);
      break;
      }
    case K_OVER:{
      tk = jj_consume_token(K_OVER);
      break;
      }
    case K_OVERLAPS:{
      tk = jj_consume_token(K_OVERLAPS);
      break;
      }
    case K_PARALLEL:{
      tk = jj_consume_token(K_PARALLEL);
      break;
      }
    case K_PARENT:{
      tk = jj_consume_token(K_PARENT);
      break;
      }
    case K_PARTITION:{
      tk = jj_consume_token(K_PARTITION);
      break;
      }
    case K_PATH:{
      tk = jj_consume_token(K_PATH);
      break;
      }
    case K_PERCENT:{
      tk = jj_consume_token(K_PERCENT);
      break;
      }
    case K_PLACING:{
      tk = jj_consume_token(K_PLACING);
      break;
      }
    case K_PRECEDING:{
      tk = jj_consume_token(K_PRECEDING);
      break;
      }
    case K_PRECISION:{
      tk = jj_consume_token(K_PRECISION);
      break;
      }
    case K_PRIMARY:{
      tk = jj_consume_token(K_PRIMARY);
      break;
      }
    case K_PRIOR:{
      tk = jj_consume_token(K_PRIOR);
      break;
      }
    case K_PURGE:{
      tk = jj_consume_token(K_PURGE);
      break;
      }
    case K_QUERY:{
      tk = jj_consume_token(K_QUERY);
      break;
      }
    case K_QUICK:{
      tk = jj_consume_token(K_QUICK);
      break;
      }
    case K_QUIESCE:{
      tk = jj_consume_token(K_QUIESCE);
      break;
      }
    case K_RANGE:{
      tk = jj_consume_token(K_RANGE);
      break;
      }
    case K_RAW:{
      tk = jj_consume_token(K_RAW);
      break;
      }
    case K_READ:{
      tk = jj_consume_token(K_READ);
      break;
      }
    case K_RECYCLEBIN:{
      tk = jj_consume_token(K_RECYCLEBIN);
      break;
      }
    case K_REFERENCES:{
      tk = jj_consume_token(K_REFERENCES);
      break;
      }
    case K_REFRESH:{
      tk = jj_consume_token(K_REFRESH);
      break;
      }
    case K_REGISTER:{
      tk = jj_consume_token(K_REGISTER);
      break;
      }
    case K_RENAME:{
      tk = jj_consume_token(K_RENAME);
      break;
      }
    case K_REPEATABLE:{
      tk = jj_consume_token(K_REPEATABLE);
      break;
      }
    case K_REPLACE:{
      tk = jj_consume_token(K_REPLACE);
      break;
      }
    case K_RESET:{
      tk = jj_consume_token(K_RESET);
      break;
      }
    case K_RESTART:{
      tk = jj_consume_token(K_RESTART);
      break;
      }
    case K_RESTRICT:{
      tk = jj_consume_token(K_RESTRICT);
      break;
      }
    case K_RESTRICTED:{
      tk = jj_consume_token(K_RESTRICTED);
      break;
      }
    case K_RESUMABLE:{
      tk = jj_consume_token(K_RESUMABLE);
      break;
      }
    case K_RESUME:{
      tk = jj_consume_token(K_RESUME);
      break;
      }
    case K_RLIKE:{
      tk = jj_consume_token(K_RLIKE);
      break;
      }
    case K_ROLLBACK:{
      tk = jj_consume_token(K_ROLLBACK);
      break;
      }
    case K_ROOT:{
      tk = jj_consume_token(K_ROOT);
      break;
      }
    case K_ROW:{
      tk = jj_consume_token(K_ROW);
      break;
      }
    case K_ROWS:{
      tk = jj_consume_token(K_ROWS);
      break;
      }
    case 386:{
      tk = jj_consume_token(386);
      break;
      }
    case 387:{
      tk = jj_consume_token(387);
      break;
      }
    case K_SAVEPOINT:{
      tk = jj_consume_token(K_SAVEPOINT);
      break;
      }
    case K_SCHEMA:{
      tk = jj_consume_token(K_SCHEMA);
      break;
      }
    case K_SEED:{
      tk = jj_consume_token(K_SEED);
      break;
      }
    case K_SEPARATOR:{
      tk = jj_consume_token(K_SEPARATOR);
      break;
      }
    case K_SEQUENCE:{
      tk = jj_consume_token(K_SEQUENCE);
      break;
      }
    case K_SESSION:{
      tk = jj_consume_token(K_SESSION);
      break;
      }
    case K_SETS:{
      tk = jj_consume_token(K_SETS);
      break;
      }
    case K_SHOW:{
      tk = jj_consume_token(K_SHOW);
      break;
      }
    case K_SHUTDOWN:{
      tk = jj_consume_token(K_SHUTDOWN);
      break;
      }
    case K_SIBLINGS:{
      tk = jj_consume_token(K_SIBLINGS);
      break;
      }
    case K_SIGNED:{
      tk = jj_consume_token(K_SIGNED);
      break;
      }
    case K_SIMILAR:{
      tk = jj_consume_token(K_SIMILAR);
      break;
      }
    case K_SIZE:{
      tk = jj_consume_token(K_SIZE);
      break;
      }
    case K_SKIP:{
      tk = jj_consume_token(K_SKIP);
      break;
      }
    case K_STORED:{
      tk = jj_consume_token(K_STORED);
      break;
      }
    case K_STRING:{
      tk = jj_consume_token(K_STRING);
      break;
      }
    case K_SUSPEND:{
      tk = jj_consume_token(K_SUSPEND);
      break;
      }
    case K_SWITCH:{
      tk = jj_consume_token(K_SWITCH);
      break;
      }
    case K_SYNONYM:{
      tk = jj_consume_token(K_SYNONYM);
      break;
      }
    case K_SYSTEM:{
      tk = jj_consume_token(K_SYSTEM);
      break;
      }
    case K_TABLE:{
      tk = jj_consume_token(K_TABLE);
      break;
      }
    case K_TABLESPACE:{
      tk = jj_consume_token(K_TABLESPACE);
      break;
      }
    case K_TEMP:{
      tk = jj_consume_token(K_TEMP);
      break;
      }
    case K_TEMPORARY:{
      tk = jj_consume_token(K_TEMPORARY);
      break;
      }
    case K_THEN:{
      tk = jj_consume_token(K_THEN);
      break;
      }
    case K_TIMEOUT:{
      tk = jj_consume_token(K_TIMEOUT);
      break;
      }
    case 388:{
      tk = jj_consume_token(388);
      break;
      }
    case K_TO:{
      tk = jj_consume_token(K_TO);
      break;
      }
    case K_TRIGGER:{
      tk = jj_consume_token(K_TRIGGER);
      break;
      }
    case K_TRUE:{
      tk = jj_consume_token(K_TRUE);
      break;
      }
    case K_TRUNCATE:{
      tk = jj_consume_token(K_TRUNCATE);
      break;
      }
    case K_TUMBLING:{
      tk = jj_consume_token(K_TUMBLING);
      break;
      }
    case K_TYPE:{
      tk = jj_consume_token(K_TYPE);
      break;
      }
    case K_UNLOGGED:{
      tk = jj_consume_token(K_UNLOGGED);
      break;
      }
    case K_UNQIESCE:{
      tk = jj_consume_token(K_UNQIESCE);
      break;
      }
    case K_UNSIGNED:{
      tk = jj_consume_token(K_UNSIGNED);
      break;
      }
    case K_UPDATE:{
      tk = jj_consume_token(K_UPDATE);
      break;
      }
    case K_UPSERT:{
      tk = jj_consume_token(K_UPSERT);
      break;
      }
    case 389:{
      tk = jj_consume_token(389);
      break;
      }
    case K_USER:{
      tk = jj_consume_token(K_USER);
      break;
      }
    case K_VALIDATE:{
      tk = jj_consume_token(K_VALIDATE);
      break;
      }
    case K_VERBOSE:{
      tk = jj_consume_token(K_VERBOSE);
      break;
      }
    case K_VIEW:{
      tk = jj_consume_token(K_VIEW);
      break;
      }
    case K_WAIT:{
      tk = jj_consume_token(K_WAIT);
      break;
      }
    case K_WITHIN:{
      tk = jj_consume_token(K_WITHIN);
      break;
      }
    case K_WITHOUT:{
      tk = jj_consume_token(K_WITHOUT);
      break;
      }
    case K_WORK:{
      tk = jj_consume_token(K_WORK);
      break;
      }
    case K_XML:{
      tk = jj_consume_token(K_XML);
      break;
      }
    case K_XMLAGG:{
      tk = jj_consume_token(K_XMLAGG);
      break;
      }
    case K_XMLDATA:{
      tk = jj_consume_token(K_XMLDATA);
      break;
      }
    case K_XMLSCHEMA:{
      tk = jj_consume_token(K_XMLSCHEMA);
      break;
      }
    case K_XMLTEXT:{
      tk = jj_consume_token(K_XMLTEXT);
      break;
      }
    case K_XSINIL:{
      tk = jj_consume_token(K_XSINIL);
      break;
      }
    case K_YAML:{
      tk = jj_consume_token(K_YAML);
      break;
      }
    case K_YES:{
      tk = jj_consume_token(K_YES);
      break;
      }
    case K_ZONE:{
      tk = jj_consume_token(K_ZONE);
      break;
      }
    default:
      jj_la1[113] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return tk.image;
}

/*
These tokens can be used as names for Schema and Tables and Columns
BUT NOT for Aliases (without quoting)
*/
  final public String RelObjectName() throws ParseException {Token tk = null; String result = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALTER:
    case K_ANALYZE:
    case K_APPLY:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONVERT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATABASE:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GLOBAL:
    case K_GRANT:
    case K_GUARD:
    case K_HISTORY:
    case K_HOPPING:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_OPEN:
    case K_OVER:
    case K_OVERLAPS:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PURGE:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REFERENCES:
    case K_REFRESH:
    case K_RLIKE:
    case K_REGISTER:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_ROLLBACK:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_STORED:
    case K_STRING:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VERBOSE:
    case K_VIEW:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 385:
    case 386:
    case 387:
    case 388:
    case 389:{
      result = RelObjectNameWithoutValue();
      break;
      }
    case K_GROUP:{
      tk = jj_consume_token(K_GROUP);
      break;
      }
    case K_INTERVAL:{
      tk = jj_consume_token(K_INTERVAL);
      break;
      }
    case K_ON:{
      tk = jj_consume_token(K_ON);
      break;
      }
    case K_START:{
      tk = jj_consume_token(K_START);
      break;
      }
    case K_TOP:{
      tk = jj_consume_token(K_TOP);
      break;
      }
    case K_VALUE:{
      tk = jj_consume_token(K_VALUE);
      break;
      }
    case K_VALUES:{
      tk = jj_consume_token(K_VALUES);
      break;
      }
    case K_CREATE:{
      tk = jj_consume_token(K_CREATE);
      break;
      }
    case K_TABLES:{
      tk = jj_consume_token(K_TABLES);
      break;
      }
    case K_CONNECT:{
      tk = jj_consume_token(K_CONNECT);
      break;
      }
    case K_IGNORE:{
      tk = jj_consume_token(K_IGNORE);
      break;
      }
    case K_QUALIFY:{
      tk = jj_consume_token(K_QUALIFY);
      break;
      }
    default:
      jj_la1[114] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return tk!=null ? tk.image : result;
}

  final public String RelObjectNameWithoutStart() throws ParseException {Token tk = null; String result = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALTER:
    case K_ANALYZE:
    case K_APPLY:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONVERT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATABASE:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GLOBAL:
    case K_GRANT:
    case K_GUARD:
    case K_HISTORY:
    case K_HOPPING:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_OPEN:
    case K_OVER:
    case K_OVERLAPS:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PURGE:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REFERENCES:
    case K_REFRESH:
    case K_RLIKE:
    case K_REGISTER:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_ROLLBACK:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_STORED:
    case K_STRING:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VERBOSE:
    case K_VIEW:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 385:
    case 386:
    case 387:
    case 388:
    case 389:{
      result = RelObjectNameWithoutValue();
      break;
      }
    case K_TOP:{
      tk = jj_consume_token(K_TOP);
      break;
      }
    case K_VALUE:{
      tk = jj_consume_token(K_VALUE);
      break;
      }
    case K_VALUES:{
      tk = jj_consume_token(K_VALUES);
      break;
      }
    case K_INTERVAL:{
      tk = jj_consume_token(K_INTERVAL);
      break;
      }
    default:
      jj_la1[115] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return tk!=null ? tk.image : result;
}

/*
Extended version of object names.

These tokens can be used as names for Schema and Tables and Columns
BUT NOT for Aliases (without quoting)

*/
  final public String RelObjectNameExt() throws ParseException {Token tk = null;
  String result=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALTER:
    case K_ANALYZE:
    case K_APPLY:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONNECT:
    case K_CONVERT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATABASE:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GLOBAL:
    case K_GRANT:
    case K_GROUP:
    case K_GUARD:
    case K_HISTORY:
    case K_HOPPING:
    case K_IGNORE:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_ON:
    case K_OPEN:
    case K_OVER:
    case K_OVERLAPS:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PURGE:
    case K_QUALIFY:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REFERENCES:
    case K_REFRESH:
    case K_RLIKE:
    case K_REGISTER:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_ROLLBACK:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_START:
    case K_STORED:
    case K_STRING:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 385:
    case 386:
    case 387:
    case 388:
    case 389:{
      result = RelObjectName();
      break;
      }
    case K_ALL:{
      tk = jj_consume_token(K_ALL);
      break;
      }
    case K_ANY:{
      tk = jj_consume_token(K_ANY);
      break;
      }
    case K_SOME:{
      tk = jj_consume_token(K_SOME);
      break;
      }
    case K_LEFT:{
      tk = jj_consume_token(K_LEFT);
      break;
      }
    case K_RIGHT:{
      tk = jj_consume_token(K_RIGHT);
      break;
      }
    case K_SET:{
      tk = jj_consume_token(K_SET);
      break;
      }
    case K_DOUBLE:{
      tk = jj_consume_token(K_DOUBLE);
      break;
      }
    case K_IF:{
      tk = jj_consume_token(K_IF);
      break;
      }
    case K_IIF:{
      tk = jj_consume_token(K_IIF);
      break;
      }
    case K_OPTIMIZE:{
      tk = jj_consume_token(K_OPTIMIZE);
      break;
      }
    case K_LIMIT:{
      tk = jj_consume_token(K_LIMIT);
      break;
      }
    case K_OFFSET:{
      tk = jj_consume_token(K_OFFSET);
      break;
      }
    case K_PROCEDURE:{
      tk = jj_consume_token(K_PROCEDURE);
      break;
      }
    case K_PUBLIC:{
      tk = jj_consume_token(K_PUBLIC);
      break;
      }
    case K_CASEWHEN:{
      tk = jj_consume_token(K_CASEWHEN);
      break;
      }
    case K_IN:{
      tk = jj_consume_token(K_IN);
      break;
      }
    case K_GROUPING:{
      tk = jj_consume_token(K_GROUPING);
      break;
      }
    case K_ORDER:{
      tk = jj_consume_token(K_ORDER);
      break;
      }
    default:
      jj_la1[116] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return tk!=null ? tk.image : result;
}

/*
Extended usage of object names - part 2. Using within multipart names as following parts.

These tokens can be used as names for Tables and Columns
BUT NOT for Schema or  Aliases (without quoting)

*/
  final public String RelObjectNameExt2() throws ParseException {Token tk = null;
  String result=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALL:
    case K_ALTER:
    case K_ANALYZE:
    case K_ANY:
    case K_APPLY:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CASEWHEN:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONNECT:
    case K_CONVERT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATABASE:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DOUBLE:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GLOBAL:
    case K_GRANT:
    case K_GROUP:
    case K_GROUPING:
    case K_GUARD:
    case K_HISTORY:
    case K_HOPPING:
    case K_IF:
    case K_IIF:
    case K_IGNORE:
    case K_IN:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LEFT:
    case K_LIMIT:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OVERLAPS:
    case K_OPTIMIZE:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_PURGE:
    case K_QUALIFY:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REFERENCES:
    case K_REFRESH:
    case K_RLIKE:
    case K_REGISTER:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_RIGHT:
    case K_ROLLBACK:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_SOME:
    case K_START:
    case K_STORED:
    case K_STRING:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 385:
    case 386:
    case 387:
    case 388:
    case 389:{
      result = RelObjectNameExt();
      break;
      }
    case K_FROM:{
      tk = jj_consume_token(K_FROM);
      break;
      }
    case K_SELECT:{
      tk = jj_consume_token(K_SELECT);
      break;
      }
    case K_CURRENT:{
      tk = jj_consume_token(K_CURRENT);
      break;
      }
    default:
      jj_la1[117] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return tk!=null ? tk.image : result;
}

  final public Table Table() throws ParseException {/*@bgen(jjtree) TableName */
    SimpleNode jjtn000 = new SimpleNode(JJTTABLENAME);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));//String serverName = null, databaseName = null, schemaName = null, tableName = null;
    List<String> data = new ArrayList<String>();
    try {
      data = RelObjectNameList();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Table table = new Table(data);
                linkAST(table,jjtn000);
        return table;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Table TableWithAlias() throws ParseException {Table table = null;
    Alias alias = null;
    table = Table();
    if (jj_2_45(2)) {
      alias = Alias();
table.setAlias(alias);
    } else {
      ;
    }
return table;
}

  final public Number Number() throws ParseException {Token token;
    Number number;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_DOUBLE:{
      token = jj_consume_token(S_DOUBLE);
number = Double.valueOf(token.image);
      break;
      }
    case S_LONG:{
      token = jj_consume_token(S_LONG);
number = Long.valueOf(token.image);
      break;
      }
    default:
      jj_la1[118] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return number;
}

  final public SampleClause SampleClause() throws ParseException {Token token;
    SampleClause sampleClause;
    String keyword;
    String method=null;
    Number percentageArgument;
    Number repeatArgument=null;
    Number seedArgument=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SAMPLE:{
      // Oracle
                  token = jj_consume_token(K_SAMPLE);
keyword = token.image;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_BLOCK:{
        token = jj_consume_token(K_BLOCK);
method = token.image;
        break;
        }
      default:
        jj_la1[119] = jj_gen;
        ;
      }
      break;
      }
    case K_TABLESAMPLE:{
      // SQL:2016 compliant
                  token = jj_consume_token(K_TABLESAMPLE);
keyword = token.image;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SYSTEM:{
        token = jj_consume_token(K_SYSTEM);
        break;
        }
      case K_BERNOULLI:{
        token = jj_consume_token(K_BERNOULLI);
        break;
        }
      default:
        jj_la1[120] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
method = token.image;
      break;
      }
    default:
      jj_la1[121] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(379);
    percentageArgument = Number();
    jj_consume_token(380);
    if (jj_2_46(2)) {
      jj_consume_token(K_REPEATABLE);
      jj_consume_token(379);
      repeatArgument = Number();
      jj_consume_token(380);
    } else {
      ;
    }
    if (jj_2_47(2)) {
      jj_consume_token(K_SEED);
      jj_consume_token(379);
      seedArgument = Number();
      jj_consume_token(380);
    } else {
      ;
    }
return new SampleClause(keyword, method, percentageArgument, repeatArgument, seedArgument);
}

  final public Select SelectWithWithItems(List<WithItem> withItems) throws ParseException {Select select;
    select = Select();
select.setWithItemsList( withItems );
    return select;
}

  final public Select Select() throws ParseException {/*@bgen(jjtree) Select */
    SimpleNode jjtn000 = new SimpleNode(JJTSELECT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Select select = null;
    List<WithItem> with = null;
    List<OrderByElement> orderByElements = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    WithIsolation withIsolation = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WITH:{
        with = WithList();
        break;
        }
      default:
        jj_la1[122] = jj_gen;
        ;
      }
      if (jj_2_48(3)) {
        select = PlainSelect();
      } else if (jj_2_49(3)) {
        select = Values();
      } else if (jj_2_50(3)) {
        select = ParenthesedSelect();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_51(2)) {
        select = SetOperationList(select);
      } else {
        ;
      }
      if (jj_2_52(2147483647)) {
        orderByElements = OrderByElements();
select.setOrderByElements(orderByElements);
      } else {
        ;
      }
      if (jj_2_53(2147483647)) {
        limit = LimitWithOffset();
select.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_54(2147483647)) {
        offset = Offset();
select.setOffset(offset);
      } else {
        ;
      }
      if (jj_2_55(2147483647)) {
        fetch = Fetch();
select.setFetch(fetch);
      } else {
        ;
      }
      if (jj_2_56(2147483647)) {
        withIsolation = WithIsolation();
select.setIsolation(withIsolation);
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(select, jjtn000);
        return select.withWithItemsList(with);
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ParenthesedSelect ParenthesedSelect() throws ParseException {/*@bgen(jjtree) ParenthesedSelect */
    SimpleNode jjtn000 = new SimpleNode(JJTPARENTHESEDSELECT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));ParenthesedSelect parenthesedSelect = new ParenthesedSelect();
    Select select;
    try {
      jj_consume_token(379);
      select = Select();
      jj_consume_token(380);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(parenthesedSelect,jjtn000);
        return parenthesedSelect.withSelect(select);
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public LateralView LateralView() throws ParseException {/*@bgen(jjtree) LateralView */
    SimpleNode jjtn000 = new SimpleNode(JJTLATERALVIEW);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));boolean useOuter = false;
    Function generatorFunction = null;
    String tableName = null;
    String columnName = null;
    Alias tableAlias = null;
    Alias columnAlias = null;
    try {
      jj_consume_token(K_LATERAL);
      jj_consume_token(K_VIEW);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_OUTER:{
        jj_consume_token(K_OUTER);
useOuter=true;
        break;
        }
      default:
        jj_la1[123] = jj_gen;
        ;
      }
      generatorFunction = Function();
      if (jj_2_57(2)) {
        tableName = RelObjectNameWithoutStart();
tableAlias = new Alias(tableName, false);
      } else {
        ;
      }
      jj_consume_token(K_AS);
      columnName = RelObjectNameWithoutStart();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
columnAlias = new Alias(columnName, true);
        return new LateralView(
            useOuter
            , generatorFunction
            , tableAlias
            , columnAlias
        );
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ForClause ForClause() throws ParseException {/*@bgen(jjtree) ForClause */
    SimpleNode jjtn000 = new SimpleNode(JJTFORCLAUSE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Token token = null;
    ForClause forClause = new ForClause();
    try {
      jj_consume_token(K_FOR);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_BROWSE:{
        token = jj_consume_token(K_BROWSE);
        break;
        }
      case K_XML:{
        token = jj_consume_token(K_XML);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_AUTO:
        case K_RAW:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_RAW:{
            jj_consume_token(K_RAW);
            if (jj_2_58(2)) {
              jj_consume_token(379);
              jj_consume_token(S_CHAR_LITERAL);
              jj_consume_token(380);
            } else {
              ;
            }
            break;
            }
          case K_AUTO:{
            jj_consume_token(K_AUTO);
            break;
            }
          default:
            jj_la1[124] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          label_17:
          while (true) {
            if (jj_2_59(2)) {
              ;
            } else {
              break label_17;
            }
            jj_consume_token(K_COMMA);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_BINARY:{
              jj_consume_token(K_BINARY);
              jj_consume_token(K_BASE64);
              break;
              }
            case K_TYPE:{
              jj_consume_token(K_TYPE);
              break;
              }
            case K_ROOT:{
              jj_consume_token(K_ROOT);
              if (jj_2_60(2)) {
                jj_consume_token(379);
                jj_consume_token(S_CHAR_LITERAL);
                jj_consume_token(380);
              } else {
                ;
              }
              break;
              }
            case K_XMLDATA:{
              jj_consume_token(K_XMLDATA);
              break;
              }
            case K_XMLSCHEMA:{
              jj_consume_token(K_XMLSCHEMA);
              if (jj_2_61(2)) {
                jj_consume_token(379);
                jj_consume_token(S_CHAR_LITERAL);
                jj_consume_token(380);
              } else {
                ;
              }
              break;
              }
            case K_ELEMENTS:{
              jj_consume_token(K_ELEMENTS);
              if (jj_2_62(2)) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_XSINIL:{
                  jj_consume_token(K_XSINIL);
                  break;
                  }
                case K_ABSENT:{
                  jj_consume_token(K_ABSENT);
                  break;
                  }
                default:
                  jj_la1[125] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              } else {
                ;
              }
              break;
              }
            default:
              jj_la1[126] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
          }
        case K_EXPLICIT:{
          jj_consume_token(K_EXPLICIT);
          label_18:
          while (true) {
            if (jj_2_63(2)) {
              ;
            } else {
              break label_18;
            }
            jj_consume_token(K_COMMA);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_BINARY:{
              jj_consume_token(K_BINARY);
              jj_consume_token(K_BASE64);
              break;
              }
            case K_TYPE:{
              jj_consume_token(K_TYPE);
              break;
              }
            case K_ROOT:{
              jj_consume_token(K_ROOT);
              if (jj_2_64(2)) {
                jj_consume_token(379);
                jj_consume_token(S_CHAR_LITERAL);
                jj_consume_token(380);
              } else {
                ;
              }
              break;
              }
            case K_XMLDATA:{
              jj_consume_token(K_XMLDATA);
              break;
              }
            default:
              jj_la1[127] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
          }
        case K_PATH:{
          jj_consume_token(K_PATH);
          if (jj_2_65(2)) {
            jj_consume_token(379);
            jj_consume_token(S_CHAR_LITERAL);
            jj_consume_token(380);
          } else {
            ;
          }
          label_19:
          while (true) {
            if (jj_2_66(2)) {
              ;
            } else {
              break label_19;
            }
            jj_consume_token(K_COMMA);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_BINARY:{
              jj_consume_token(K_BINARY);
              jj_consume_token(K_BASE64);
              break;
              }
            case K_TYPE:{
              jj_consume_token(K_TYPE);
              break;
              }
            case K_ROOT:{
              jj_consume_token(K_ROOT);
              if (jj_2_67(2)) {
                jj_consume_token(379);
                jj_consume_token(S_CHAR_LITERAL);
                jj_consume_token(380);
              } else {
                ;
              }
              break;
              }
            case K_ELEMENTS:{
              jj_consume_token(K_ELEMENTS);
              if (jj_2_68(2)) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_XSINIL:{
                  jj_consume_token(K_XSINIL);
                  break;
                  }
                case K_ABSENT:{
                  jj_consume_token(K_ABSENT);
                  break;
                  }
                default:
                  jj_la1[128] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              } else {
                ;
              }
              break;
              }
            default:
              jj_la1[129] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
          }
        default:
          jj_la1[130] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_JSON:{
        token = jj_consume_token(K_JSON);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_AUTO:{
          jj_consume_token(K_AUTO);
          break;
          }
        case K_PATH:{
          jj_consume_token(K_PATH);
          break;
          }
        default:
          jj_la1[131] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_20:
        while (true) {
          if (jj_2_69(2)) {
            ;
          } else {
            break label_20;
          }
          jj_consume_token(K_COMMA);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ROOT:{
            jj_consume_token(K_ROOT);
            if (jj_2_70(2)) {
              jj_consume_token(379);
              jj_consume_token(S_CHAR_LITERAL);
              jj_consume_token(380);
            } else {
              ;
            }
            break;
            }
          case K_INCLUDE_NULL_VALUES:{
            jj_consume_token(K_INCLUDE_NULL_VALUES);
            break;
            }
          case K_WITHOUT_ARRAY_WRAPPER:{
            jj_consume_token(K_WITHOUT_ARRAY_WRAPPER);
            break;
            }
          default:
            jj_la1[132] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[133] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
forClause.setForOption(token.image);
        linkAST(forClause,jjtn000);
        return forClause;
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
}

  final public List<LateralView> LateralViews() throws ParseException {ArrayList<LateralView> lateralViews = new ArrayList<LateralView>();
    LateralView lateralView = null;
    lateralView = LateralView();
lateralViews.add(lateralView);
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LATERAL:{
        ;
        break;
        }
      default:
        jj_la1[134] = jj_gen;
        break label_21;
      }
      lateralView = LateralView();
lateralViews.add(lateralView);
    }
return lateralViews;
}

  final public LateralSubSelect LateralSubSelect() throws ParseException {/*@bgen(jjtree) LateralSubSelect */
    SimpleNode jjtn000 = new SimpleNode(JJTLATERALSUBSELECT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));LateralSubSelect lateralSubSelect = new LateralSubSelect();;
    Select select;
    try {
      jj_consume_token(K_LATERAL);
      jj_consume_token(379);
      select = Select();
      jj_consume_token(380);
lateralSubSelect.withSelect(select).setPrefix("LATERAL");
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(lateralSubSelect,jjtn000);
        return lateralSubSelect;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public PlainSelect PlainSelect() throws ParseException {/*@bgen(jjtree) PlainSelect */
    SimpleNode jjtn000 = new SimpleNode(JJTPLAINSELECT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));PlainSelect plainSelect = new PlainSelect();
    List<SelectItem<?>> selectItems = null;
    FromItem fromItem = null;
    List<LateralView> lateralViews = null;
    List<Join> joins = null;
    List<SelectItem<?>> distinctOn = null;
    Expression where = null;
    ForClause forClause = null;
    List<OrderByElement> orderByElements;
    GroupByElement groupBy = null;
    Expression having = null;
    Expression qualify;
    Limit limitBy = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    WithIsolation withIsolation = null;
    OptimizeFor optimize = null;
    Top top = null;
    Skip skip = null;
    First first = null;
    OracleHierarchicalExpression oracleHierarchicalQueryClause = null;
    List<Table> intoTables = null;
    Table updateTable = null;
    Wait wait = null;
    boolean mySqlSqlCalcFoundRows = false;
    Token token;
    KSQLWindow ksqlWindow = null;
    boolean noWait = false;
    String windowName = null;
    WindowDefinition winDef;
    try {
      jj_consume_token(K_SELECT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_STRAIGHT:{
        jj_consume_token(K_STRAIGHT);
plainSelect.setMySqlHintStraightJoin(true);
        break;
        }
      default:
        jj_la1[135] = jj_gen;
        ;
      }
plainSelect.setOracleHint(getOracleHint());
      if (jj_2_71(2)) {
        skip = Skip();
plainSelect.setSkip(skip);
      } else {
        ;
      }
      if (jj_2_72(2)) {
        first = First();
plainSelect.setFirst(first);
      } else {
        ;
      }
      if (jj_2_74(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALL:{
          jj_consume_token(K_ALL);
          break;
          }
        case K_DISTINCT:{
          jj_consume_token(K_DISTINCT);
Distinct distinct = new Distinct(); plainSelect.setDistinct(distinct);
          if (jj_2_73(2)) {
            jj_consume_token(K_ON);
            jj_consume_token(379);
            distinctOn = SelectItemsList();
plainSelect.getDistinct().setOnSelectItems(distinctOn);
            jj_consume_token(380);
          } else {
            ;
          }
          break;
          }
        case K_UNIQUE:{
          jj_consume_token(K_UNIQUE);
Distinct distinct = new Distinct(true); plainSelect.setDistinct(distinct);
          break;
          }
        case K_SQL_CALC_FOUND_ROWS:{
          jj_consume_token(K_SQL_CALC_FOUND_ROWS);
plainSelect.setMySqlSqlCalcFoundRows(true);
          break;
          }
        case K_SQL_NO_CACHE:{
          jj_consume_token(K_SQL_NO_CACHE);
plainSelect.setMySqlSqlCacheFlag(MySqlSqlCacheFlags.SQL_NO_CACHE);
          break;
          }
        case K_SQL_CACHE:{
          jj_consume_token(K_SQL_CACHE);
plainSelect.setMySqlSqlCacheFlag(MySqlSqlCacheFlags.SQL_CACHE);
          break;
          }
        default:
          jj_la1[136] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
      if (jj_2_75(2)) {
        top = Top();
plainSelect.setTop(top);
      } else {
        ;
      }
      selectItems = SelectItemsList();
      if (jj_2_76(2)) {
        intoTables = IntoClause();
plainSelect.setIntoTables(intoTables);
      } else {
        ;
      }
      if (jj_2_78(2)) {
        jj_consume_token(K_FROM);
        fromItem = FromItem();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_LATERAL:{
          lateralViews = LateralViews();
          break;
          }
        default:
          jj_la1[137] = jj_gen;
          ;
        }
        if (jj_2_77(2)) {
          joins = JoinsList();
        } else {
          ;
        }
      } else {
        ;
      }
      if (jj_2_79(2)) {
        jj_consume_token(K_FINAL);
plainSelect.setUsingFinal(true);
      } else {
        ;
      }
      if (jj_2_80(2)) {
        ksqlWindow = KSQLWindowClause();
plainSelect.setKsqlWindow(ksqlWindow);
      } else {
        ;
      }
      if (jj_2_81(2)) {
        where = WhereClause();
plainSelect.setWhere(where);
      } else {
        ;
      }
      if (jj_2_82(2)) {
        oracleHierarchicalQueryClause = OracleHierarchicalQueryClause();
plainSelect.setOracleHierarchical(oracleHierarchicalQueryClause);
      } else {
        ;
      }
      if (jj_2_83(2)) {
        having = Having();
plainSelect.setHaving(having);
      } else {
        ;
      }
      if (jj_2_84(2)) {
        groupBy = GroupByColumnReferences();
plainSelect.setGroupByElement(groupBy);
      } else {
        ;
      }
      if (jj_2_85(2)) {
        having = Having();
plainSelect.setHaving(having);
      } else {
        ;
      }
      if (jj_2_86(2)) {
        qualify = Qualify();
plainSelect.setQualify(qualify);
      } else {
        ;
      }
      if (jj_2_87(2)) {
        forClause = ForClause();
plainSelect.setForClause(forClause);
      } else {
        ;
      }
      if (jj_2_88(2147483647)) {
        orderByElements = OrderByElements();
plainSelect.setOracleSiblings(true); plainSelect.setOrderByElements(orderByElements);
      } else {
        ;
      }
      if (jj_2_90(2)) {
        jj_consume_token(K_WINDOW);
        windowName = RelObjectName();
        jj_consume_token(K_AS);
        winDef = windowDefinition();
List<WindowDefinition> winDefs = new ArrayList<WindowDefinition>(); winDefs.add(winDef.withWindowName(windowName));
        label_22:
        while (true) {
          if (jj_2_89(2)) {
            ;
          } else {
            break label_22;
          }
          jj_consume_token(K_COMMA);
          windowName = RelObjectName();
          jj_consume_token(K_AS);
          winDef = windowDefinition();
winDefs.add(winDef.withWindowName(windowName));
        }
plainSelect.setWindowDefinitions(winDefs);
      } else {
        ;
      }
      if (jj_2_91(2147483647)) {
        orderByElements = OrderByElements();
plainSelect.setOrderByElements(orderByElements);
      } else {
        ;
      }
      if (jj_2_92(2)) {
        jj_consume_token(K_EMIT);
        jj_consume_token(K_CHANGES);
plainSelect.setEmitChanges(true);
      } else {
        ;
      }
      if (jj_2_93(2147483647)) {
        limit = LimitBy();
plainSelect.setLimitBy(limit);
      } else {
        ;
      }
      if (jj_2_94(2147483647)) {
        limit = LimitWithOffset();
plainSelect.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_95(2147483647)) {
        offset = Offset();
plainSelect.setOffset(offset);
      } else {
        ;
      }
      if (jj_2_96(2147483647) && (limit==null)) {
        limit = LimitWithOffset();
plainSelect.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_97(2147483647)) {
        fetch = Fetch();
plainSelect.setFetch(fetch);
      } else {
        ;
      }
      if (jj_2_98(2147483647)) {
        withIsolation = WithIsolation();
plainSelect.setIsolation(withIsolation);
      } else {
        ;
      }
      if (jj_2_102(2)) {
        jj_consume_token(K_FOR);
        jj_consume_token(K_UPDATE);
plainSelect.setForUpdate(true);
        if (jj_2_99(2)) {
          jj_consume_token(K_OF);
          updateTable = Table();
plainSelect.setForUpdateTable(updateTable);
        } else {
          ;
        }
        if (jj_2_100(2147483647)) {
          wait = Wait();
plainSelect.setWait(wait);
        } else {
          ;
        }
        if (jj_2_101(2)) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOWAIT:{
            jj_consume_token(K_NOWAIT);
plainSelect.setNoWait(true);
            break;
            }
          case K_SKIP:{
            jj_consume_token(K_SKIP);
            jj_consume_token(K_LOCKED);
plainSelect.setSkipLocked(true);
            break;
            }
          default:
            jj_la1[138] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        } else {
          ;
        }
      } else {
        ;
      }
      if (jj_2_103(2147483647)) {
        optimize = OptimizeFor();
plainSelect.setOptimizeFor(optimize);
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
plainSelect.setSelectItems(selectItems);
        plainSelect.setFromItem(fromItem);
        if ( lateralViews!=null && lateralViews.size()>0 ) {
            plainSelect.setLateralViews( lateralViews );
        }
        if ( joins!=null && joins.size()>0 ) {
            plainSelect.setJoins( joins );
        }
        linkAST(plainSelect,jjtn000);
        return plainSelect;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Select SetOperationList(Select select) throws ParseException {/*@bgen(jjtree) SetOperationList */
    SimpleNode jjtn000 = new SimpleNode(JJTSETOPERATIONLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SetOperationList list = new SetOperationList();
    List<OrderByElement> orderByElements = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    WithIsolation withIsolation = null;
    List<Select> selects = new ArrayList<Select>();
    List<SetOperation> operations = new ArrayList<SetOperation>();
    try {
selects.add(select);
      label_23:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_UNION:{
          jj_consume_token(K_UNION);
UnionOp union = new UnionOp(); linkAST(union,jjtn000); operations.add(union);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALL:
          case K_DISTINCT:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ALL:{
              jj_consume_token(K_ALL);
union.setAll(true);
              break;
              }
            case K_DISTINCT:{
              jj_consume_token(K_DISTINCT);
union.setDistinct(true);
              break;
              }
            default:
              jj_la1[139] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[140] = jj_gen;
            ;
          }
          break;
          }
        case K_INTERSECT:{
          jj_consume_token(K_INTERSECT);
operations.add(new IntersectOp());
          break;
          }
        case K_MINUS:{
          jj_consume_token(K_MINUS);
operations.add(new MinusOp());
          break;
          }
        case K_EXCEPT:{
          jj_consume_token(K_EXCEPT);
operations.add(new ExceptOp());
          break;
          }
        default:
          jj_la1[141] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:{
          select = PlainSelect();
          break;
          }
        case K_VALUE:
        case K_VALUES:{
          select = Values();
          break;
          }
        case 379:{
          select = ParenthesedSelect();
          break;
          }
        default:
          jj_la1[142] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
selects.add(select);
        if (jj_2_104(2)) {
          ;
        } else {
          break label_23;
        }
      }
      if (jj_2_105(2)) {
        orderByElements = OrderByElements();
list.setOrderByElements(orderByElements);
      } else {
        ;
      }
      if (jj_2_106(2147483647)) {
        limit = LimitWithOffset();
list.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_107(2147483647)) {
        offset = Offset();
list.setOffset(offset);
      } else {
        ;
      }
      if (jj_2_108(2147483647) && (limit==null)) {
        limit = LimitWithOffset();
list.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_109(2147483647)) {
        fetch = Fetch();
list.setFetch(fetch);
      } else {
        ;
      }
      if (jj_2_110(2147483647)) {
        withIsolation = WithIsolation();
list.setIsolation(withIsolation);
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
if ( selects.get(selects.size()-1) instanceof PlainSelect ) {
            PlainSelect ps = (PlainSelect)selects.get(selects.size()-1);
            if (ps.getOrderByElements() != null) {
                list.setOrderByElements(ps.getOrderByElements());
                list.setLimit(ps.getLimit());
                list.setOffset(ps.getOffset());
                ps.setOrderByElements(null);
                ps.setLimit(null);
                ps.setOffset(null);
            }
            if (ps.getFetch() != null) {
                list.setFetch(ps.getFetch());
                ps.setFetch(null);
            }
            if (ps.getIsolation() != null) {
                list.setIsolation(ps.getIsolation());
                ps.setIsolation(null);
            }
        }
        list.setBracketsOpsAndSelects(selects,operations);
        return list;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public List<WithItem> WithList() throws ParseException {List<WithItem> withItemsList = new ArrayList<WithItem>();
    WithItem with = null;
    jj_consume_token(K_WITH);
    with = WithItem();
withItemsList.add(with);
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[143] = jj_gen;
        break label_24;
      }
      jj_consume_token(K_COMMA);
      with = WithItem();
withItemsList.add(with);
    }
return withItemsList;
}

  final public WithItem WithItem() throws ParseException {/*@bgen(jjtree) WithItem */
    SimpleNode jjtn000 = new SimpleNode(JJTWITHITEM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));WithItem withItem = new WithItem();
    String name;
    List<SelectItem<?>> selectItems;
    Select select;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_RECURSIVE:{
        jj_consume_token(K_RECURSIVE);
withItem.setRecursive(true);
        break;
        }
      default:
        jj_la1[144] = jj_gen;
        ;
      }
      name = RelObjectName();
withItem.setAlias( new Alias( name, false));
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 379:{
        jj_consume_token(379);
        selectItems = SelectItemsList();
        jj_consume_token(380);
withItem.setWithItemList(selectItems);
        break;
        }
      default:
        jj_la1[145] = jj_gen;
        ;
      }
      jj_consume_token(K_AS);
      select = ParenthesedSelect();
withItem.setSelect(select);
jjtree.closeNodeScope(jjtn000, true);
       jjtc000 = false;
       jjtn000.jjtSetLastToken(getToken(0));
return withItem;
    } catch (Throwable jjte000) {
if (jjtc000) {
         jjtree.clearNodeScope(jjtn000);
         jjtc000 = false;
       } else {
         jjtree.popNode();
       }
       if (jjte000 instanceof RuntimeException) {
         {if (true) throw (RuntimeException)jjte000;}
       }
       if (jjte000 instanceof ParseException) {
         {if (true) throw (ParseException)jjte000;}
       }
       {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
         jjtree.closeNodeScope(jjtn000, true);
         jjtn000.jjtSetLastToken(getToken(0));
       }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public List<SelectItem<?>> SelectItemsList() throws ParseException {List<SelectItem<?>> selectItemsList = new ArrayList<SelectItem<?>>();
    SelectItem selectItem = null;
    selectItem = SelectItem();
selectItemsList.add(selectItem);
    label_25:
    while (true) {
      if (jj_2_111(2)) {
        ;
      } else {
        break label_25;
      }
      jj_consume_token(K_COMMA);
      selectItem = SelectItem();
selectItemsList.add(selectItem);
    }
return selectItemsList;
}

  final public SelectItem SelectItem() throws ParseException {/*@bgen(jjtree) SelectItem */
    SimpleNode jjtn000 = new SimpleNode(JJTSELECTITEM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression expression;
    Alias alias = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 390:{
        expression = AllColumns();
        break;
        }
      default:
        jj_la1[146] = jj_gen;
        if (jj_2_112(2147483647)) {
          expression = AllTableColumns();
        } else if (jj_2_113(2147483647)) {
          expression = Condition();
        } else if (jj_2_114(3)) {
          expression = ConcatExpression();
        } else if (jj_2_115(1)) {
          expression = Expression();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      if (jj_2_116(2)) {
        alias = Alias();
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
SelectItem selectItem = new SelectItem(expression, alias);
        linkAST(selectItem,jjtn000);
        return selectItem;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public AllColumns AllColumns() throws ParseException {ParenthesedExpressionList<Column> exceptColumns = null;
    List<SelectItem<?>> replaceExpressions = null;
    jj_consume_token(390);
    if (jj_2_117(2)) {
      jj_consume_token(K_EXCEPT);
      exceptColumns = ParenthesedColumnList();
    } else {
      ;
    }
    if (jj_2_118(2)) {
      jj_consume_token(K_REPLACE);
      jj_consume_token(379);
      replaceExpressions = SelectItemsList();
      jj_consume_token(380);
    } else {
      ;
    }
return new AllColumns(exceptColumns, replaceExpressions);
}

  final public AllTableColumns AllTableColumns() throws ParseException {Table table = null;
    AllColumns allColumns;
    table = Table();
    jj_consume_token(383);
    allColumns = AllColumns();
return new AllTableColumns(table, allColumns);
}

  final public Alias Alias() throws ParseException {String name = null;
  Token token = null;
  boolean useAs = false;
  Alias alias;
  String colname;
  ColDataType colDataType = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:{
      jj_consume_token(K_AS);
useAs = true;
      break;
      }
    default:
      jj_la1[147] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALTER:
    case K_ANALYZE:
    case K_APPLY:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONVERT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATABASE:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GLOBAL:
    case K_GRANT:
    case K_GUARD:
    case K_HISTORY:
    case K_HOPPING:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_OPEN:
    case K_OVER:
    case K_OVERLAPS:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PURGE:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REFERENCES:
    case K_REFRESH:
    case K_RLIKE:
    case K_REGISTER:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_ROLLBACK:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_STORED:
    case K_STRING:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 385:
    case 386:
    case 387:
    case 388:
    case 389:{
      name = RelObjectNameWithoutStart();
      break;
      }
    case S_CHAR_LITERAL:{
      token = jj_consume_token(S_CHAR_LITERAL);
name=token.image;
      break;
      }
    default:
      jj_la1[148] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
alias = new Alias(name,useAs);
    if (jj_2_119(2)) {
      jj_consume_token(379);
List<Alias.AliasColumn> list = new ArrayList<Alias.AliasColumn>();
      colname = RelObjectName();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_BINARY:
      case K_BIT:
      case K_BYTES:
      case K_CHARACTER:
      case K_CHAR:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DOUBLE:
      case K_INTERVAL:
      case K_JSON:
      case K_SET:
      case K_STRING:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_XML:
      case DT_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        colDataType = ColDataType();
        break;
        }
      default:
        jj_la1[149] = jj_gen;
        ;
      }
list.add(new Alias.AliasColumn(colname, colDataType));
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[150] = jj_gen;
          break label_26;
        }
        jj_consume_token(K_COMMA);
colDataType=null;
        colname = RelObjectName();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ARRAY_LITERAL:
        case K_BINARY:
        case K_BIT:
        case K_BYTES:
        case K_CHARACTER:
        case K_CHAR:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DOUBLE:
        case K_INTERVAL:
        case K_JSON:
        case K_SET:
        case K_STRING:
        case K_SIGNED:
        case K_UNSIGNED:
        case K_XML:
        case DT_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          colDataType = ColDataType();
          break;
          }
        default:
          jj_la1[151] = jj_gen;
          ;
        }
list.add(new Alias.AliasColumn(colname, colDataType));
      }
      jj_consume_token(380);
alias.setAliasColumns(list);
    } else {
      ;
    }
return alias;
}

  final public void SQLServerHint(SQLServerHints hints) throws ParseException {String str;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INDEX:{
      jj_consume_token(K_INDEX);
      jj_consume_token(379);
      str = RelObjectName();
      jj_consume_token(380);
hints.setIndexName(str);
      break;
      }
    case K_NOLOCK:{
      jj_consume_token(K_NOLOCK);
hints.withNoLock();
      break;
      }
    default:
      jj_la1[152] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public SQLServerHints SQLServerHints() throws ParseException {SQLServerHints hints = new SQLServerHints();
    jj_consume_token(K_WITH);
    jj_consume_token(379);
    SQLServerHint(hints);
    label_27:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[153] = jj_gen;
        break label_27;
      }
      jj_consume_token(K_COMMA);
      SQLServerHint(hints);
    }
    jj_consume_token(380);
return hints;
}

  final public MySQLIndexHint MySQLIndexHint() throws ParseException {Token actionToken = null;
        Token indexToken = null;
        String indexName = null;
        List<String> indexNameList = new ArrayList<String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_USE:{
      actionToken = jj_consume_token(K_USE);
      break;
      }
    case K_SHOW:{
      actionToken = jj_consume_token(K_SHOW);
      break;
      }
    case K_IGNORE:{
      actionToken = jj_consume_token(K_IGNORE);
      break;
      }
    case K_FORCE:{
      actionToken = jj_consume_token(K_FORCE);
      break;
      }
    default:
      jj_la1[154] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INDEX:{
      indexToken = jj_consume_token(K_INDEX);
      break;
      }
    case K_KEY:{
      indexToken = jj_consume_token(K_KEY);
      break;
      }
    default:
      jj_la1[155] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(379);
    indexName = RelObjectNameWithoutValue();
indexNameList.add(indexName);
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[156] = jj_gen;
        break label_28;
      }
      jj_consume_token(K_COMMA);
      indexName = RelObjectNameWithoutValue();
indexNameList.add(indexName);
    }
    jj_consume_token(380);
return new MySQLIndexHint(actionToken.image, indexToken.image, indexNameList);
}

  final public SelectItem<Function> FunctionItem() throws ParseException {Alias alias = null;
    Function function;
    function = Function();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALTER:
    case K_ANALYZE:
    case K_APPLY:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONVERT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATABASE:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GLOBAL:
    case K_GRANT:
    case K_GUARD:
    case K_HISTORY:
    case K_HOPPING:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_OPEN:
    case K_OVER:
    case K_OVERLAPS:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PURGE:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REFERENCES:
    case K_REFRESH:
    case K_RLIKE:
    case K_REGISTER:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_ROLLBACK:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_STORED:
    case K_STRING:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 385:
    case 386:
    case 387:
    case 388:
    case 389:{
      alias = Alias();
      break;
      }
    default:
      jj_la1[157] = jj_gen;
      ;
    }
return new SelectItem<Function>(function, alias);
}

  final public ExpressionList<Column> PivotForColumns() throws ParseException {ExpressionList<Column> columns;
    Column column;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 379:{
      columns = ParenthesedColumnList();
      break;
      }
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALL:
    case K_ALTER:
    case K_ANALYZE:
    case K_ANY:
    case K_APPLY:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CASEWHEN:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONNECT:
    case K_CONVERT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATABASE:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DOUBLE:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GLOBAL:
    case K_GRANT:
    case K_GROUP:
    case K_GROUPING:
    case K_GUARD:
    case K_HISTORY:
    case K_HOPPING:
    case K_IF:
    case K_IIF:
    case K_IGNORE:
    case K_IN:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LEFT:
    case K_LIMIT:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OVERLAPS:
    case K_OPTIMIZE:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_PURGE:
    case K_QUALIFY:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REFERENCES:
    case K_REFRESH:
    case K_RLIKE:
    case K_REGISTER:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_RIGHT:
    case K_ROLLBACK:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_SOME:
    case K_START:
    case K_STORED:
    case K_STRING:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 385:
    case 386:
    case 387:
    case 388:
    case 389:{
      column = Column();
columns = new ExpressionList<Column>(column);
      break;
      }
    default:
      jj_la1[158] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return columns;
}

  final public List<SelectItem<Function>> PivotFunctionItems() throws ParseException {List<SelectItem<Function>> functionItems = new ArrayList<SelectItem<Function>>();
    SelectItem<Function> item;
    item = FunctionItem();
functionItems.add(item);
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[159] = jj_gen;
        break label_29;
      }
      jj_consume_token(K_COMMA);
      item = FunctionItem();
functionItems.add(item);
    }
return functionItems;
}

  final public SelectItem<ExpressionList> ExpressionListItem() throws ParseException {ExpressionList expressionList;
    Alias alias = null;
    expressionList = ParenthesedExpressionList();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALTER:
    case K_ANALYZE:
    case K_APPLY:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONVERT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATABASE:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GLOBAL:
    case K_GRANT:
    case K_GUARD:
    case K_HISTORY:
    case K_HOPPING:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_OPEN:
    case K_OVER:
    case K_OVERLAPS:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PURGE:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REFERENCES:
    case K_REFRESH:
    case K_RLIKE:
    case K_REGISTER:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_ROLLBACK:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_STORED:
    case K_STRING:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 385:
    case 386:
    case 387:
    case 388:
    case 389:{
      alias = Alias();
      break;
      }
    default:
      jj_la1[160] = jj_gen;
      ;
    }
return new SelectItem<ExpressionList>(expressionList, alias);
}

  final public List<SelectItem<ExpressionList>> PivotMultiInItems() throws ParseException {List<SelectItem<ExpressionList>> retval = new ArrayList<SelectItem<ExpressionList>>();
   SelectItem<ExpressionList> item;
    item = ExpressionListItem();
retval.add(item);
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[161] = jj_gen;
        break label_30;
      }
      jj_consume_token(K_COMMA);
      item = ExpressionListItem();
retval.add(item);
    }
return retval;
}

  final public Pivot Pivot() throws ParseException {Pivot retval = new Pivot();
    List<SelectItem<Function>> functionItems;
    ExpressionList<Column> forColumns;
    List<SelectItem<?>> singleInItems = null;
    List<SelectItem<ExpressionList>> multiInItems = null;
    Alias alias = null;
    jj_consume_token(K_PIVOT);
    jj_consume_token(379);
    functionItems = PivotFunctionItems();
    jj_consume_token(K_FOR);
    forColumns = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(379);
    if (jj_2_120(3)) {
      singleInItems = SelectItemsList();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 379:{
        multiInItems = PivotMultiInItems();
        break;
        }
      default:
        jj_la1[162] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(380);
    jj_consume_token(380);
    if (jj_2_121(2)) {
      alias = Alias();
    } else {
      ;
    }
retval.setFunctionItems(functionItems);
        retval.setForColumns(forColumns);
        retval.setSingleInItems(singleInItems);
        retval.setMultiInItems(multiInItems);
        retval.setAlias(alias);
        return retval;
}

  final public PivotXml PivotXml() throws ParseException {PivotXml retval = new PivotXml();
    List<SelectItem<Function>> functionItems;
    ExpressionList<Column> forColumns;
    List<SelectItem<?>> singleInItems = null;
    List<SelectItem<ExpressionList>> multiInItems = null;
    Select inSelect = null;
    jj_consume_token(K_PIVOT);
    jj_consume_token(K_XML);
    jj_consume_token(379);
    functionItems = PivotFunctionItems();
    jj_consume_token(K_FOR);
    forColumns = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(379);
    if (jj_2_122(2)) {
      jj_consume_token(K_ANY);
retval.setInAny(true);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case K_VALUE:
      case K_VALUES:
      case K_WITH:
      case 379:{
        inSelect = Select();
        break;
        }
      default:
        jj_la1[163] = jj_gen;
        if (jj_2_123(2)) {
          singleInItems = SelectItemsList();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 379:{
            multiInItems = PivotMultiInItems();
            break;
            }
          default:
            jj_la1[164] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    jj_consume_token(380);
    jj_consume_token(380);
retval.setFunctionItems(functionItems);
        retval.setForColumns(forColumns);
        retval.setSingleInItems(singleInItems);
        retval.setMultiInItems(multiInItems);
        retval.setInSelect(inSelect);
        return retval;
}

  final public UnPivot UnPivot() throws ParseException {UnPivot retval = new UnPivot();
    ExpressionList<Column> unpivotClause;
    ExpressionList<Column> unpivotForClause;
    List<SelectItem<?>> unpivotInClause;
    Alias alias = null;
    jj_consume_token(K_UNPIVOT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXCLUDE:
    case K_INCLUDE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_INCLUDE:{
        jj_consume_token(K_INCLUDE);
        jj_consume_token(K_NULLS);
retval.setIncludeNulls(true);
        break;
        }
      case K_EXCLUDE:{
        jj_consume_token(K_EXCLUDE);
        jj_consume_token(K_NULLS);
retval.setIncludeNulls(false);
        break;
        }
      default:
        jj_la1[165] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[166] = jj_gen;
      ;
    }
    jj_consume_token(379);
    unpivotClause = PivotForColumns();
    jj_consume_token(K_FOR);
    unpivotForClause = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(379);
    unpivotInClause = SelectItemsList();
    jj_consume_token(380);
    jj_consume_token(380);
    if (jj_2_124(2)) {
      alias = Alias();
    } else {
      ;
    }
retval.setUnPivotClause(unpivotClause);
        retval.setUnPivotForClause(unpivotForClause);
        retval.setUnPivotInClause(unpivotInClause);
        retval.setAlias(alias);
        return retval;
}

  final public List<Table> IntoClause() throws ParseException {List<Table> tables = new ArrayList<Table>();
    Table table;
    jj_consume_token(K_INTO);
    table = Table();
tables.add(table);
    label_31:
    while (true) {
      if (jj_2_125(2)) {
        ;
      } else {
        break label_31;
      }
      jj_consume_token(K_COMMA);
      table = Table();
tables.add(table);
    }
return tables;
}

  final public FromItem ParenthesedFromItem() throws ParseException {ParenthesedFromItem ParenthesedFromItem = new ParenthesedFromItem();
    FromItem fromItem;
    List<Join> joins = null;
    jj_consume_token(379);
    fromItem = FromItem();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_APPLY:
    case K_COMMA:
    case K_CROSS:
    case K_FULL:
    case K_GLOBAL:
    case K_INNER:
    case K_STRAIGHT:
    case K_JOIN:
    case K_LEFT:
    case K_NATURAL:
    case K_OUTER:
    case K_RIGHT:{
      joins = JoinsList();
      break;
      }
    default:
      jj_la1[167] = jj_gen;
      ;
    }
    jj_consume_token(380);
return ParenthesedFromItem.withFromItem(fromItem).withJoins(joins);
}

  final public FromItem FromItem() throws ParseException {FromItem fromItem = null;
    FromItem fromItem2 = null;
    SampleClause sampleClause;
    Pivot pivot = null;
    UnPivot unpivot = null;
    Alias alias = null;
    MySQLIndexHint indexHint = null;
    SQLServerHints sqlServerHints = null;
    Select select;
    if (jj_2_128(2147483647)) {
      fromItem = TableFunction();
    } else if (jj_2_129(3)) {
      fromItem = Table();
    } else if (jj_2_130(2147483647)) {
      fromItem = ParenthesedFromItem();
    } else if (jj_2_131(3)) {
      fromItem = ParenthesedSelect();
      if (jj_2_126(2)) {
        pivot = Pivot();
fromItem.setPivot(pivot);
      } else {
        ;
      }
      if (jj_2_127(2)) {
        unpivot = UnPivot();
fromItem.setUnPivot(unpivot);
      } else {
        ;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LATERAL:{
        fromItem = LateralSubSelect();
        break;
        }
      default:
        jj_la1[168] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    if (jj_2_132(2)) {
      alias = Alias();
fromItem.setAlias(alias);
    } else {
      ;
    }
    if (jj_2_133(2)) {
      sampleClause = SampleClause();
((Table) fromItem).setSampleClause(sampleClause);
    } else {
      ;
    }
    if (jj_2_134(2)) {
      unpivot = UnPivot();
fromItem.setUnPivot(unpivot);
    } else {
      ;
    }
    if (jj_2_136(2)) {
      if (jj_2_135(2)) {
        pivot = PivotXml();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_PIVOT:{
          pivot = Pivot();
          break;
          }
        default:
          jj_la1[169] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
fromItem.setPivot(pivot);
    } else {
      ;
    }
    if (jj_2_137(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FORCE:
      case K_IGNORE:
      case K_SHOW:
      case K_USE:{
        indexHint = MySQLIndexHint();
if (fromItem instanceof Table)
                    ((Table) fromItem).setHint(indexHint);
        break;
        }
      case K_WITH:{
        sqlServerHints = SQLServerHints();
if (fromItem instanceof Table)
                    ((Table) fromItem).setSqlServerHints(sqlServerHints);
        break;
        }
      default:
        jj_la1[170] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
return fromItem;
}

  final public List<Join> JoinsList() throws ParseException {List<Join> joinsList = new ArrayList<Join>();
    Join join = null;
    label_32:
    while (true) {
      join = JoinerExpression();
joinsList.add(join);
      if (jj_2_138(2)) {
        ;
      } else {
        break label_32;
      }
    }
return joinsList;
}

  final public Join JoinerExpression() throws ParseException {/*@bgen(jjtree) JoinerExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTJOINEREXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Join join = new Join();
    FromItem right = null;
    Expression onExpression = null;
    Column tableColumn;
    List<Column> columns = null;
    KSQLJoinWindow joinWindow = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_GLOBAL:{
        jj_consume_token(K_GLOBAL);
join.setGlobal(true);
        break;
        }
      default:
        jj_la1[171] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NATURAL:{
        jj_consume_token(K_NATURAL);
join.setNatural(true);
        break;
        }
      default:
        jj_la1[172] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CROSS:
      case K_FULL:
      case K_INNER:
      case K_LEFT:
      case K_OUTER:
      case K_RIGHT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_FULL:
        case K_INNER:
        case K_LEFT:
        case K_RIGHT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_LEFT:{
            jj_consume_token(K_LEFT);
join.setLeft(true);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_OUTER:
            case K_SEMI:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_SEMI:{
                jj_consume_token(K_SEMI);
join.setSemi(true);
                break;
                }
              case K_OUTER:{
                jj_consume_token(K_OUTER);
join.setOuter(true);
                break;
                }
              default:
                jj_la1[173] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
              }
            default:
              jj_la1[174] = jj_gen;
              ;
            }
            break;
            }
          case K_FULL:
          case K_RIGHT:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_RIGHT:{
              jj_consume_token(K_RIGHT);
join.setRight(true);
              break;
              }
            case K_FULL:{
              jj_consume_token(K_FULL);
join.setFull(true);
              break;
              }
            default:
              jj_la1[175] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_OUTER:{
              jj_consume_token(K_OUTER);
join.setOuter(true);
              break;
              }
            default:
              jj_la1[176] = jj_gen;
              ;
            }
            break;
            }
          case K_INNER:{
            jj_consume_token(K_INNER);
join.setInner(true);
            break;
            }
          default:
            jj_la1[177] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        case K_CROSS:{
          jj_consume_token(K_CROSS);
join.setCross(true);
          break;
          }
        case K_OUTER:{
          jj_consume_token(K_OUTER);
join.setOuter(true);
          break;
          }
        default:
          jj_la1[178] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[179] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_JOIN:{
        jj_consume_token(K_JOIN);
        break;
        }
      case K_COMMA:{
        jj_consume_token(K_COMMA);
join.setSimple(true);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_OUTER:{
          jj_consume_token(K_OUTER);
join.setOuter(true);
          break;
          }
        default:
          jj_la1[180] = jj_gen;
          ;
        }
        break;
        }
      case K_STRAIGHT:{
        jj_consume_token(K_STRAIGHT);
join.setStraight(true);
        break;
        }
      case K_APPLY:{
        jj_consume_token(K_APPLY);
join.setApply(true);
        break;
        }
      default:
        jj_la1[181] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = FromItem();
      if (jj_2_140(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ON:
        case K_WITHIN:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_WITHIN:{
            jj_consume_token(K_WITHIN);
            jj_consume_token(379);
            joinWindow = JoinWindow();
            jj_consume_token(380);
join.setJoinWindow(joinWindow);
            break;
            }
          default:
            jj_la1[182] = jj_gen;
            ;
          }
          jj_consume_token(K_ON);
          onExpression = Expression();
join.addOnExpression(onExpression);
          label_33:
          while (true) {
            if (jj_2_139(2)) {
              ;
            } else {
              break label_33;
            }
            jj_consume_token(K_ON);
            onExpression = Expression();
join.addOnExpression(onExpression);
          }
          break;
          }
        case K_USING:{
          jj_consume_token(K_USING);
          jj_consume_token(379);
          tableColumn = Column();
columns = new ArrayList<Column>(); columns.add(tableColumn);
          label_34:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[183] = jj_gen;
              break label_34;
            }
            jj_consume_token(K_COMMA);
            tableColumn = Column();
columns.add(tableColumn);
          }
          jj_consume_token(380);
join.setUsingColumns(columns);
          break;
          }
        default:
          jj_la1[184] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
linkAST(join,jjtn000);
    join.setFromItem(right);
  return join;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public KSQLJoinWindow JoinWindow() throws ParseException {KSQLJoinWindow retval = new KSQLJoinWindow();
    boolean beforeAfter;
    Token beforeDurationToken = null;
    Token beforeTimeUnitToken = null;
    Token afterDurationToken = null;
    Token afterTimeUnitToken = null;
    beforeDurationToken = jj_consume_token(S_LONG);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      beforeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case K_DATE_LITERAL:{
      beforeTimeUnitToken = jj_consume_token(K_DATE_LITERAL);
      break;
      }
    default:
      jj_la1[185] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_COMMA:{
      jj_consume_token(K_COMMA);
      afterDurationToken = jj_consume_token(S_LONG);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        afterTimeUnitToken = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_DATE_LITERAL:{
        afterTimeUnitToken = jj_consume_token(K_DATE_LITERAL);
        break;
        }
      default:
        jj_la1[186] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[187] = jj_gen;
      ;
    }
if (afterDurationToken == null) {
            retval.setDuration(Long.parseLong(beforeDurationToken.image));
            retval.setTimeUnit(KSQLWindow.TimeUnit.from(beforeTimeUnitToken.image));
            retval.setBeforeAfterWindow(false);
            return retval;
        }
        retval.setBeforeDuration(Long.parseLong(beforeDurationToken.image));
        retval.setBeforeTimeUnit(KSQLWindow.TimeUnit.from(beforeTimeUnitToken.image));
        retval.setAfterDuration(Long.parseLong(afterDurationToken.image));
        retval.setAfterTimeUnit(KSQLWindow.TimeUnit.from(afterTimeUnitToken.image));
        retval.setBeforeAfterWindow(true);
        return retval;
}

  final public KSQLWindow KSQLWindowClause() throws ParseException {KSQLWindow retval = null;
    Token sizeDurationToken = null;
    Token sizeTimeUnitToken = null;
    Token advanceDurationToken = null;
    Token advanceTimeUnitToken = null;
    jj_consume_token(K_WINDOW);
retval=new KSQLWindow();
        retval.setHoppingWindow(false);
        retval.setSessionWindow(false);
        retval.setTumblingWindow(false);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_HOPPING:{
      jj_consume_token(K_HOPPING);
      jj_consume_token(379);
      jj_consume_token(K_SIZE);
      sizeDurationToken = jj_consume_token(S_LONG);
      sizeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(K_COMMA);
      jj_consume_token(K_ADVANCE);
      jj_consume_token(K_BY);
      advanceDurationToken = jj_consume_token(S_LONG);
      advanceTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(380);
retval.setHoppingWindow(true);
      break;
      }
    case K_SESSION:{
      jj_consume_token(K_SESSION);
      jj_consume_token(379);
      sizeDurationToken = jj_consume_token(S_LONG);
      sizeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(380);
retval.setSessionWindow(true);
      break;
      }
    case K_TUMBLING:{
      jj_consume_token(K_TUMBLING);
      jj_consume_token(379);
      jj_consume_token(K_SIZE);
      sizeDurationToken = jj_consume_token(S_LONG);
      sizeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(380);
retval.setTumblingWindow(true);
      break;
      }
    default:
      jj_la1[188] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
retval.setSizeDuration(Long.parseLong(sizeDurationToken.image));
            retval.setSizeTimeUnit(KSQLWindow.TimeUnit.from(sizeTimeUnitToken.image));
            if (advanceDurationToken != null) {
                retval.setAdvanceDuration(Long.parseLong(advanceDurationToken.image));
                retval.setAdvanceTimeUnit(KSQLWindow.TimeUnit.from(advanceTimeUnitToken.image));
            }
            return retval;
}

  final public Expression WhereClause() throws ParseException {Expression retval = null;
    jj_consume_token(K_WHERE);
    retval = Expression();
return retval;
}

  final public OracleHierarchicalExpression OracleHierarchicalQueryClause() throws ParseException {OracleHierarchicalExpression result = new OracleHierarchicalExpression();
    Expression expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_START:{
      jj_consume_token(K_START);
      jj_consume_token(K_WITH);
      expr = AndExpression();
result.setStartExpression(expr);
      jj_consume_token(K_CONNECT);
      jj_consume_token(K_BY);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOCYCLE:{
        jj_consume_token(K_NOCYCLE);
result.setNoCycle(true);
        break;
        }
      default:
        jj_la1[189] = jj_gen;
        ;
      }
      expr = AndExpression();
result.setConnectExpression(expr);
      break;
      }
    case K_CONNECT:{
      jj_consume_token(K_CONNECT);
      jj_consume_token(K_BY);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOCYCLE:{
        jj_consume_token(K_NOCYCLE);
result.setNoCycle(true);
        break;
        }
      default:
        jj_la1[190] = jj_gen;
        ;
      }
      expr = AndExpression();
result.setConnectExpression(expr);
                result.setConnectFirst(true);
      if (jj_2_141(2)) {
        jj_consume_token(K_START);
        jj_consume_token(K_WITH);
        expr = AndExpression();
result.setStartExpression(expr);
      } else {
        ;
      }
      break;
      }
    default:
      jj_la1[191] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return result;
}

  final public GroupByElement GroupByColumnReferences() throws ParseException {Expression columnReference;
    GroupByElement groupBy = new GroupByElement();
    Expression expr;
    ExpressionList list;
    Token token;
    jj_consume_token(K_GROUP);
    jj_consume_token(K_BY);
    if (jj_2_145(2)) {
      jj_consume_token(K_GROUPING);
      jj_consume_token(K_SETS);
      jj_consume_token(379);
      list = GroupingSet();
groupBy.addGroupingSet(list);
      label_35:
      while (true) {
        if (jj_2_142(2)) {
          ;
        } else {
          break label_35;
        }
        jj_consume_token(K_COMMA);
        list = GroupingSet();
groupBy.addGroupingSet(list);
      }
      jj_consume_token(380);
    } else if (jj_2_146(1)) {
      list = ExpressionList();
groupBy.setGroupByExpressions(list);
      if (jj_2_144(2)) {
        jj_consume_token(K_GROUPING);
        jj_consume_token(K_SETS);
        jj_consume_token(379);
        list = GroupingSet();
groupBy.addGroupingSet(list);
        label_36:
        while (true) {
          if (jj_2_143(2)) {
            ;
          } else {
            break label_36;
          }
          jj_consume_token(K_COMMA);
          list = GroupingSet();
groupBy.addGroupingSet(list);
        }
        jj_consume_token(380);
      } else {
        ;
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
return groupBy;
}

  final public ExpressionList GroupingSet() throws ParseException {ExpressionList list;
    Expression expression;
    if (jj_2_147(2)) {
      list = ParenthesedExpressionList();
    } else if (jj_2_148(1)) {
      expression = SimpleExpression();
list = new ExpressionList(expression);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
return list;
}

  final public Expression Having() throws ParseException {Expression having = null;
    jj_consume_token(K_HAVING);
    having = Expression();
return having;
}

  final public Expression Qualify() throws ParseException {Expression qualify = null;
    jj_consume_token(K_QUALIFY);
    qualify = Expression();
return qualify;
}

  final public List<OrderByElement> OrderByElements() throws ParseException {List<OrderByElement> orderByList = new ArrayList<OrderByElement>();
    OrderByElement orderByElement = null;
    jj_consume_token(K_ORDER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SIBLINGS:{
      jj_consume_token(K_SIBLINGS);
      break;
      }
    default:
      jj_la1[192] = jj_gen;
      ;
    }
    jj_consume_token(K_BY);
    orderByElement = OrderByElement();
orderByList.add(orderByElement);
    label_37:
    while (true) {
      if (jj_2_149(2)) {
        ;
      } else {
        break label_37;
      }
      jj_consume_token(K_COMMA);
      orderByElement = OrderByElement();
orderByList.add(orderByElement);
    }
return orderByList;
}

  final public OrderByElement OrderByElement() throws ParseException {OrderByElement orderByElement = new OrderByElement();
    Expression columnReference = null;
    columnReference = Expression();
    if (jj_2_150(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ASC:{
        jj_consume_token(K_ASC);
        break;
        }
      case K_DESC:{
        jj_consume_token(K_DESC);
orderByElement.setAsc(false);
        break;
        }
      default:
        jj_la1[193] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
orderByElement.setAscDescPresent(true);
    } else {
      ;
    }
    if (jj_2_152(2)) {
      jj_consume_token(K_NULLS);
      if (jj_2_151(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_FIRST:{
          jj_consume_token(K_FIRST);
orderByElement.setNullOrdering(OrderByElement.NullOrdering.NULLS_FIRST);
          break;
          }
        case K_LAST:{
          jj_consume_token(K_LAST);
orderByElement.setNullOrdering(OrderByElement.NullOrdering.NULLS_LAST);
          break;
          }
        default:
          jj_la1[194] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
    } else {
      ;
    }
orderByElement.setExpression(columnReference);
        return orderByElement;
}

  final public JdbcParameter SimpleJdbcParameter() throws ParseException {JdbcParameter retval;
    jj_consume_token(391);
retval = new JdbcParameter(++jdbcParameterIndex, false);
    if (jj_2_153(2)) {
      token = jj_consume_token(S_LONG);
retval.setUseFixedIndex(true); retval.setIndex(Integer.valueOf(token.image));
    } else {
      ;
    }
return retval;
}

  final public JdbcNamedParameter SimpleJdbcNamedParameter() throws ParseException {String name;
    jj_consume_token(384);
    name = RelObjectNameExt();
return new JdbcNamedParameter(token.image);
}

  final public Limit LimitWithOffset() throws ParseException {/*@bgen(jjtree) LimitWithOffset */
    SimpleNode jjtn000 = new SimpleNode(JJTLIMITWITHOFFSET);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Limit limit = new Limit();
    Expression rowCountExpression;
    Expression offsetExpression;
    try {
      if (jj_2_154(2147483647)) {
        jj_consume_token(K_LIMIT);
        offsetExpression = Expression();
limit.setOffset( offsetExpression );
        jj_consume_token(K_COMMA);
        rowCountExpression = Expression();
limit.setRowCount( rowCountExpression );
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_LIMIT:{
          limit = PlainLimit();
          break;
          }
        default:
          jj_la1[195] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(limit,jjtn000);
        return limit;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Limit PlainLimit() throws ParseException {/*@bgen(jjtree) PlainLimit */
    SimpleNode jjtn000 = new SimpleNode(JJTPLAINLIMIT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Limit limit = new Limit();
    Expression rowCountExpression;
    try {
      jj_consume_token(K_LIMIT);
      if (jj_2_155(3)) {
        rowCountExpression = ParenthesedSelect();
      } else if (jj_2_156(1)) {
        rowCountExpression = Expression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
limit.setRowCount(rowCountExpression);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(limit,jjtn000);
        return limit;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

/**
 * Clickhouse LIMIT BY
 * @see <a href='https://clickhouse.com/docs/en/sql-reference/statements/select'>SELECT Query</a>
 */
  final public Limit LimitBy() throws ParseException {Limit limit;
    ExpressionList byExpressions;
    limit = LimitWithOffset();
    jj_consume_token(K_BY);
    byExpressions = ExpressionList();
limit.setByExpressions(byExpressions);
        return limit;
}

  final public Offset Offset() throws ParseException {Offset offset = new Offset();
    Expression offsetExpression;
    jj_consume_token(K_OFFSET);
    offsetExpression = Expression();
offset.setOffset( offsetExpression );
    if (jj_2_157(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ROWS:{
        jj_consume_token(K_ROWS);
offset.setOffsetParam("ROWS");
        break;
        }
      case K_ROW:{
        jj_consume_token(K_ROW);
offset.setOffsetParam("ROW");
        break;
        }
      default:
        jj_la1[196] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
return offset;
}

  final public Fetch Fetch() throws ParseException {Fetch fetch = new Fetch();
    Token token = null;
    Expression expression;
    jj_consume_token(K_FETCH);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
fetch.setFetchParamFirst(true);
      break;
      }
    case K_NEXT:{
      jj_consume_token(K_NEXT);
      break;
      }
    default:
      jj_la1[197] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    expression = Expression();
fetch.setExpression(expression);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROWS:{
      jj_consume_token(K_ROWS);
fetch.setFetchParam("ROWS");
      break;
      }
    case K_ROW:{
      jj_consume_token(K_ROW);
      break;
      }
    default:
      jj_la1[198] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_ONLY);
return fetch;
}

  final public WithIsolation WithIsolation() throws ParseException {WithIsolation withIsolation = new WithIsolation();
    Token token = null;
    JdbcParameter jdbc;
    jj_consume_token(K_WITH);
    token = jj_consume_token(K_ISOLATION);
withIsolation.setIsolation(token.image);
return withIsolation;
}

  final public OptimizeFor OptimizeFor() throws ParseException {Token token;
    LongValue value;
    jj_consume_token(K_OPTIMIZE);
    jj_consume_token(K_FOR);
    token = jj_consume_token(S_LONG);
    jj_consume_token(K_ROWS);
value = new LongValue(token.image);
        return new OptimizeFor(value.getValue());
}

// according to http://technet.microsoft.com/en-us/library/ms189463.aspx
  final public Top Top() throws ParseException {Top top = new Top();
    Token token = null;
    Expression expr = null;
    JdbcParameter jdbc = null;
    jj_consume_token(K_TOP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
top.setExpression(new LongValue(token.image));
      break;
      }
    case 391:{
      jdbc = SimpleJdbcParameter();
top.setExpression(jdbc);
      break;
      }
    case 384:{
      jj_consume_token(384);
top.setExpression(new JdbcNamedParameter());
      if (jj_2_158(2)) {
        token = jj_consume_token(S_IDENTIFIER);
((JdbcNamedParameter)top.getExpression()).setName(token.image);
      } else {
        ;
      }
      break;
      }
    case 379:{
      jj_consume_token(379);
      expr = AdditiveExpression();
top.setExpression(expr);
            top.setParenthesis(true);
      jj_consume_token(380);
      break;
      }
    default:
      jj_la1[199] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_159(2)) {
      jj_consume_token(K_PERCENT);
top.setPercentage(true);
    } else {
      ;
    }
    if (jj_2_160(2)) {
      jj_consume_token(K_WITH_TIES);
top.setWithTies(true);
    } else {
      ;
    }
return top;
}

// according to http://www-01.ibm.com/support/knowledgecenter/SSGU8G_12.1.0/com.ibm.sqls.doc/ids_sqs_0156.htm
  final public Skip Skip() throws ParseException {Skip skip = new Skip();
    Token token = null;
    JdbcParameter jdbc;
    jj_consume_token(K_SKIP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
skip.setRowCount(Long.parseLong(token.image));
      break;
      }
    case S_IDENTIFIER:{
      token = jj_consume_token(S_IDENTIFIER);
skip.setVariable(token.image);
      break;
      }
    case 391:{
      jdbc = SimpleJdbcParameter();
skip.setJdbcParameter(jdbc);
      break;
      }
    default:
      jj_la1[200] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return skip;
}

  OracleHint getOracleHint() throws ParseException {OracleHint hint = null;
  Token tok = getToken(1);
  // Retrieve first comment (if any) prior next token
  if (tok.specialToken != null) {
    tok = tok.specialToken;
    while (tok.specialToken != null) tok = tok.specialToken;
    // Check if it matches Hint pattern?
    if (OracleHint.isHintMatch(tok.image)) {
      hint = new OracleHint();
      hint.setComment(tok.image);
    }
  }
  return hint;
  }

  final public First First() throws ParseException {First first = new First();
    Token token = null;
    JdbcParameter jdbc;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
first.setKeyword(First.Keyword.FIRST);
      break;
      }
    case K_LIMIT:{
      jj_consume_token(K_LIMIT);
first.setKeyword(First.Keyword.LIMIT);
      break;
      }
    default:
      jj_la1[201] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
first.setRowCount(Long.parseLong(token.image));
      break;
      }
    case S_IDENTIFIER:{
      token = jj_consume_token(S_IDENTIFIER);
first.setVariable(token.image);
      break;
      }
    case 391:{
      jdbc = SimpleJdbcParameter();
first.setJdbcParameter(jdbc);
      break;
      }
    default:
      jj_la1[202] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return first;
}

  final public Expression Expression() throws ParseException {/*@bgen(jjtree) Expression */
    SimpleNode jjtn000 = new SimpleNode(JJTEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression retval = null;
    try {
      retval = XorExpression();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression XorExpression() throws ParseException {Expression left, right, result;
    left = OrExpression();
result = left;
    label_38:
    while (true) {
      if (jj_2_161(2)) {
        ;
      } else {
        break label_38;
      }
      jj_consume_token(K_XOR);
      right = OrExpression();
result = new XorExpression(left, right);
            left = result;
    }
return result;
}

  final public Expression OrExpression() throws ParseException {Expression left, right, result;
    left = AndExpression();
result = left;
    label_39:
    while (true) {
      if (jj_2_162(2)) {
        ;
      } else {
        break label_39;
      }
      jj_consume_token(K_OR);
      right = AndExpression();
result = new OrExpression(left, right);
            left = result;
    }
return result;
}

  final public Expression AndExpression() throws ParseException {Expression left, right, result;
    boolean not = false;
        boolean exclamationMarkNot=false;
    if (jj_2_163(2147483647) && (!interrupted)) {
      left = Condition();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:
      case 379:
      case 392:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:
        case 392:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOT:{
            jj_consume_token(K_NOT);
not=true;
            break;
            }
          case 392:{
            jj_consume_token(392);
not=true; exclamationMarkNot=true;
            break;
            }
          default:
            jj_la1[203] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[204] = jj_gen;
          ;
        }
        jj_consume_token(379);
        left = XorExpression();
        jj_consume_token(380);
left = new Parenthesis(left); if (not) { left = new NotExpression(left, exclamationMarkNot); not = false; }
        break;
        }
      default:
        jj_la1[205] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
result = left;
    label_40:
    while (true) {
      if (jj_2_164(2)) {
        ;
      } else {
        break label_40;
      }
boolean useOperator = false;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AND:{
        jj_consume_token(K_AND);
        break;
        }
      case K_AND_OPERATOR:{
        jj_consume_token(K_AND_OPERATOR);
useOperator=true;
        break;
        }
      default:
        jj_la1[206] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_165(2147483647) && (!interrupted)) {
        right = Condition();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:
        case 379:
        case 392:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOT:
          case 392:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_NOT:{
              jj_consume_token(K_NOT);
not=true;
              break;
              }
            case 392:{
              jj_consume_token(392);
not=true; exclamationMarkNot=true;
              break;
              }
            default:
              jj_la1[207] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[208] = jj_gen;
            ;
          }
          jj_consume_token(379);
          right = XorExpression();
          jj_consume_token(380);
right = new Parenthesis(right); if (not) { right = new NotExpression(right, exclamationMarkNot); not = false; }
          break;
          }
        default:
          jj_la1[209] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
result = new AndExpression(left, right);
            ((AndExpression)result).setUseOperator(useOperator);
            left = result;
    }
return result;
}

  final public Expression Condition() throws ParseException {Expression result;
    Token token;
    boolean not = false;
        boolean exclamationMarkNot = false;
    if (jj_2_166(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
not=true;
        break;
        }
      case 392:{
        jj_consume_token(392);
not=true; exclamationMarkNot=true;
        break;
        }
      default:
        jj_la1[210] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    if (jj_2_167(2147483647)) {
      result = RegularCondition();
    } else if (jj_2_168(1)) {
      result = SQLCondition();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
return not?new NotExpression(result, exclamationMarkNot):result;
}

  final public Expression OverlapsCondition() throws ParseException {ExpressionList left = new ExpressionList();
    ExpressionList right = new ExpressionList();
    //As per the sql2003 standard, we need at least two items in the list if there is not explicit ROW prefix
        //More than two expression are allowed per the sql2003 grammar.
        left = ParenthesedExpressionList();
    jj_consume_token(K_OVERLAPS);
    right = ParenthesedExpressionList();
return new OverlapsCondition(left, right);
}

  final public Expression RegularCondition() throws ParseException {/*@bgen(jjtree) RegularCondition */
    SimpleNode jjtn000 = new SimpleNode(JJTREGULARCONDITION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression result = null;
    Expression leftExpression;
    Expression rightExpression;
    int oracleJoin=EqualsTo.NO_ORACLE_JOIN;
    int oraclePrior=EqualsTo.NO_ORACLE_PRIOR;
    boolean binary = false;
    boolean not = false;
    try {
      if (jj_2_169(2)) {
        jj_consume_token(K_PRIOR);
oraclePrior = EqualsTo.ORACLE_PRIOR_START;
      } else {
        ;
      }
      leftExpression = ComparisonItem();
result = leftExpression;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 379:{
        jj_consume_token(379);
        jj_consume_token(393);
        jj_consume_token(380);
oracleJoin=EqualsTo.ORACLE_JOIN_RIGHT;
        break;
        }
      default:
        jj_la1[211] = jj_gen;
        ;
      }
      if (jj_2_170(2)) {
        jj_consume_token(394);
result = new GreaterThan();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 395:{
          jj_consume_token(395);
result = new MinorThan();
          break;
          }
        case 381:{
          jj_consume_token(381);
result = new EqualsTo();
          break;
          }
        case OP_GREATERTHANEQUALS:{
          token = jj_consume_token(OP_GREATERTHANEQUALS);
result = new GreaterThanEquals(token.image);
          break;
          }
        case OP_MINORTHANEQUALS:{
          token = jj_consume_token(OP_MINORTHANEQUALS);
result = new MinorThanEquals(token.image);
          break;
          }
        case OP_NOTEQUALSSTANDARD:{
          token = jj_consume_token(OP_NOTEQUALSSTANDARD);
result = new NotEqualsTo(token.image);
          break;
          }
        case OP_NOTEQUALSBANG:{
          token = jj_consume_token(OP_NOTEQUALSBANG);
result = new NotEqualsTo(token.image);
          break;
          }
        case 396:{
          jj_consume_token(396);
result = new Matches();
          break;
          }
        case 397:{
          jj_consume_token(397);
result = new RegExpMatchOperator(RegExpMatchOperatorType.MATCH_CASESENSITIVE);
          break;
          }
        case 398:{
          jj_consume_token(398);
result = new RegExpMatchOperator(RegExpMatchOperatorType.MATCH_CASEINSENSITIVE);
          break;
          }
        case 399:{
          jj_consume_token(399);
result = new RegExpMatchOperator(RegExpMatchOperatorType.NOT_MATCH_CASESENSITIVE);
          break;
          }
        case 400:{
          jj_consume_token(400);
result = new RegExpMatchOperator(RegExpMatchOperatorType.NOT_MATCH_CASEINSENSITIVE);
          break;
          }
        case 401:{
          jj_consume_token(401);
result = new JsonOperator("@>");
          break;
          }
        case 402:{
          jj_consume_token(402);
result = new JsonOperator("<@");
          break;
          }
        case 391:{
          jj_consume_token(391);
result = new JsonOperator("?");
          break;
          }
        case 403:{
          jj_consume_token(403);
result = new JsonOperator("?|");
          break;
          }
        case 404:{
          jj_consume_token(404);
result = new JsonOperator("?&");
          break;
          }
        case OP_CONCAT:{
          jj_consume_token(OP_CONCAT);
result = new JsonOperator("||");
          break;
          }
        case 405:{
          jj_consume_token(405);
result = new JsonOperator("-");
          break;
          }
        case 406:{
          jj_consume_token(406);
result = new JsonOperator("-#");
          break;
          }
        case 407:{
          jj_consume_token(407);
result = new GeometryDistance("<->");
          break;
          }
        case 408:{
          jj_consume_token(408);
result = new GeometryDistance("<#>");
          break;
          }
        default:
          jj_la1[212] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      if (jj_2_171(2)) {
        jj_consume_token(K_PRIOR);
        rightExpression = ComparisonItem();
oraclePrior = EqualsTo.ORACLE_PRIOR_END;
      } else if (jj_2_172(1)) {
        rightExpression = ComparisonItem();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_173(2)) {
        jj_consume_token(379);
        jj_consume_token(393);
        jj_consume_token(380);
oracleJoin=EqualsTo.ORACLE_JOIN_LEFT;
      } else {
        ;
      }
BinaryExpression regCond = (BinaryExpression) result;
        regCond.setLeftExpression(leftExpression);
        regCond.setRightExpression(rightExpression);

        if (oracleJoin>0)
            ((SupportsOldOracleJoinSyntax)result).setOldOracleJoinSyntax(oracleJoin);

        if (oraclePrior!=EqualsTo.NO_ORACLE_PRIOR)
            ((SupportsOldOracleJoinSyntax)result).setOraclePriorPosition(oraclePrior);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression SQLCondition() throws ParseException {Expression result;
    Expression left;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXISTS:{
      result = ExistsExpression();
      break;
      }
    default:
      jj_la1[215] = jj_gen;
      if (jj_2_180(2147483647) && (!interrupted)) {
        result = InExpression();
      } else if (jj_2_181(2147483647) && (!interrupted)) {
        result = OverlapsCondition();
      } else if (jj_2_182(1)) {
        left = SimpleExpression();
result = left;
        if (jj_2_179(2)) {
          if (jj_2_174(2)) {
            result = Between(left);
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_MEMBER:{
              result = MemberOfExpression(left);
              break;
              }
            default:
              jj_la1[213] = jj_gen;
              if (jj_2_175(2147483647)) {
                result = IsNullExpression(left);
              } else if (jj_2_176(2147483647)) {
                result = IsBooleanExpression(left);
              } else if (jj_2_177(2)) {
                result = LikeExpression(left);
              } else if (jj_2_178(2147483647)) {
                result = IsDistinctExpression(left);
              } else {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_NOT:
                case K_SIMILAR:{
                  result = SimilarToExpression(left);
                  break;
                  }
                default:
                  jj_la1[214] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        } else {
          ;
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return result;
}

  final public Expression InExpression() throws ParseException {/*@bgen(jjtree) InExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTINEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Token token;
    int oldOracleJoin = 0;
    boolean usesNot = false;
    Expression leftExpression;
    Expression rightExpression;
    try {
      leftExpression = SimpleExpression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 379:{
        jj_consume_token(379);
        jj_consume_token(393);
        jj_consume_token(380);
oldOracleJoin=EqualsTo.ORACLE_JOIN_RIGHT;
        break;
        }
      default:
        jj_la1[216] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
usesNot=true;
        break;
        }
      default:
        jj_la1[217] = jj_gen;
        ;
      }
      jj_consume_token(K_IN);
      if (jj_2_183(2)) {
        token = jj_consume_token(S_CHAR_LITERAL);
rightExpression = new StringValue(token.image);
      } else if (jj_2_184(3)) {
        rightExpression = Function();
      } else if (jj_2_185(2147483647) && (!interrupted)) {
        rightExpression = ParenthesedSelect();
      } else if (jj_2_186(3)) {
        rightExpression = ParenthesedExpressionList();
      } else if (jj_2_187(1)) {
        rightExpression = SimpleExpression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
InExpression inExpression =  new InExpression(leftExpression, rightExpression)
                                                .withOldOracleJoinSyntax(oldOracleJoin)
                                                .withNot(usesNot);
        linkAST(inExpression,jjtn000);
        return inExpression;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression Between(Expression leftExpression) throws ParseException {Between result = new Between();
    Expression betweenExpressionStart = null;
    Expression betweenExpressionEnd = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      break;
      }
    default:
      jj_la1[218] = jj_gen;
      ;
    }
    jj_consume_token(K_BETWEEN);
    betweenExpressionStart = SimpleExpression();
    jj_consume_token(K_AND);
    betweenExpressionEnd = SimpleExpression();
result.setLeftExpression(leftExpression);
        result.setBetweenExpressionStart(betweenExpressionStart);
        result.setBetweenExpressionEnd(betweenExpressionEnd);
        return result;
}

  final public Expression LikeExpression(Expression leftExpression) throws ParseException {/*@bgen(jjtree) LikeExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTLIKEEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));LikeExpression result = new LikeExpression();
    Expression rightExpression = null;
    Expression escape;
    Token token;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[219] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LIKE:{
        token = jj_consume_token(K_LIKE);
        break;
        }
      case K_ILIKE:{
        token = jj_consume_token(K_ILIKE);
        break;
        }
      case K_RLIKE:{
        token = jj_consume_token(K_RLIKE);
        break;
        }
      case K_REGEXP:{
        token = jj_consume_token(K_REGEXP);
        break;
        }
      default:
        jj_la1[220] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
result.setLikeKeyWord( LikeExpression.KeyWord.from(token.image));
      if (jj_2_188(2)) {
        jj_consume_token(K_BINARY);
result.setUseBinary(true);
      } else {
        ;
      }
      rightExpression = SimpleExpression();
      if (jj_2_191(2)) {
        jj_consume_token(K_ESCAPE);
        if (jj_2_189(2)) {
          token = jj_consume_token(S_CHAR_LITERAL);
result.setEscape( new StringValue( token.image ) );
        } else if (jj_2_190(1)) {
          escape = Expression();
result.setEscape(escape);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
result.setLeftExpression(leftExpression);
        result.setRightExpression(rightExpression);
        linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression SimilarToExpression(Expression leftExpression) throws ParseException {/*@bgen(jjtree) SimilarToExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTSIMILARTOEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SimilarToExpression result = new SimilarToExpression();
    Expression rightExpression = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[221] = jj_gen;
        ;
      }
      jj_consume_token(K_SIMILAR);
      jj_consume_token(K_TO);
      rightExpression = SimpleExpression();
      if (jj_2_192(2)) {
        jj_consume_token(K_ESCAPE);
        token = jj_consume_token(S_CHAR_LITERAL);
result.setEscape((new StringValue(token.image)).getValue());
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
result.setLeftExpression(leftExpression);
        result.setRightExpression(rightExpression);
        linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression IsDistinctExpression(Expression leftExpression) throws ParseException {/*@bgen(jjtree) IsDistinctExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTISDISTINCTEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));IsDistinctExpression result = new IsDistinctExpression();
    Expression rightExpression = null;
    try {
      jj_consume_token(K_IS);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[222] = jj_gen;
        ;
      }
      jj_consume_token(K_DISTINCT);
      jj_consume_token(K_FROM);
      rightExpression = SimpleExpression();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
result.setLeftExpression(leftExpression);
        result.setRightExpression(rightExpression);
        linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Expression IsNullExpression(Expression leftExpression) throws ParseException {IsNullExpression result = new IsNullExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ISNULL:
    case K_NOT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[223] = jj_gen;
        ;
      }
      jj_consume_token(K_ISNULL);
result.setUseIsNull(true);
      break;
      }
    case K_NOTNULL:{
      jj_consume_token(K_NOTNULL);
result.setUseIsNull(true); result.setUseNotNull(true);
      break;
      }
    case K_IS:{
      jj_consume_token(K_IS);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[224] = jj_gen;
        ;
      }
      jj_consume_token(K_NULL);
      break;
      }
    default:
      jj_la1[225] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
result.setLeftExpression(leftExpression);
        return result;
}

  final public Expression IsBooleanExpression(Expression leftExpression) throws ParseException {IsBooleanExpression result = new IsBooleanExpression();
    jj_consume_token(K_IS);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      break;
      }
    default:
      jj_la1[226] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TRUE:{
      jj_consume_token(K_TRUE);
result.setIsTrue(true);
      break;
      }
    case K_FALSE:{
      jj_consume_token(K_FALSE);
result.setIsTrue(false);
      break;
      }
    default:
      jj_la1[227] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
result.setLeftExpression(leftExpression);
        return result;
}

  final public Expression ExistsExpression() throws ParseException {ExistsExpression result = new ExistsExpression();
    Expression rightExpression = null;
    jj_consume_token(K_EXISTS);
    rightExpression = SimpleExpression();
result.setRightExpression(rightExpression);
        return result;
}

  final public Expression MemberOfExpression(Expression leftExpression) throws ParseException {MemberOfExpression result;
    Expression rightExpression = null;
    jj_consume_token(K_MEMBER);
    jj_consume_token(K_OF);
    rightExpression = Expression();
return new MemberOfExpression(leftExpression, rightExpression );
}

  final public ExpressionList ExpressionList() throws ParseException {/*@bgen(jjtree) ExpressionList */
    SimpleNode jjtn000 = new SimpleNode(JJTEXPRESSIONLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));ExpressionList expressionList;
    try {
      if (jj_2_193(3) && (getAsBoolean(Feature.allowComplexParsing) && !interrupted)) {
        expressionList = ComplexExpressionList();
      } else if (jj_2_194(3)) {
        expressionList = SimpleExpressionList();
      } else if (jj_2_195(3)) {
        expressionList = ParenthesedExpressionList();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
// Avoid redundant ExpressionLists containing only one ParenthesedExpressionList
        // return the Parenthesed Sub ExpressionList instead
        // Same for ParenthesedExpressionList containing only 1 ExpressionList

        if ( expressionList.size() == 1 && expressionList.get(0) instanceof ExpressionList ) {
            ExpressionList subList = (ExpressionList) expressionList.get(0);
            if (expressionList instanceof ParenthesedExpressionList) {
                if (subList instanceof ParenthesedExpressionList) {
                    return expressionList;
                } else {
                    return new ParenthesedExpressionList(subList);
                }
            } else {
                if (subList instanceof ParenthesedExpressionList) {
                    return new ParenthesedExpressionList(subList);
                } else {
                    return subList;
                }
            }
        }
        return expressionList;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ParenthesedExpressionList ParenthesedExpressionList() throws ParseException {ExpressionList expressions=new ExpressionList();
    jj_consume_token(379);
    if (jj_2_197(1)) {
      if (getAsBoolean(Feature.allowComplexParsing) && !interrupted) {
        expressions = ComplexExpressionList();
      } else if (jj_2_196(1)) {
        expressions = SimpleExpressionList();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    jj_consume_token(380);
return new ParenthesedExpressionList(expressions);
}

  final public ExpressionList SimpleExpressionList() throws ParseException {ExpressionList expressions = new ExpressionList();
    Expression expr;
    expr = SimpleExpression();
expressions.add(expr);
    label_41:
    while (true) {
      if (jj_2_198(2) && (!interrupted)) {
        ;
      } else {
        break label_41;
      }
      jj_consume_token(K_COMMA);
      expr = SimpleExpression();
expressions.add(expr);
    }
return expressions;
}

  final public ExpressionList<Column> ColumnList() throws ParseException {ExpressionList<Column> expressions = new ExpressionList<Column>();
    Column expr;
    expr = Column();
expressions.add(expr);
    label_42:
    while (true) {
      if (jj_2_199(2)) {
        ;
      } else {
        break label_42;
      }
      jj_consume_token(K_COMMA);
      expr = Column();
expressions.add(expr);
    }
return expressions;
}

  final public ParenthesedExpressionList<Column> ParenthesedColumnList() throws ParseException {ExpressionList<Column> expressions;
    jj_consume_token(379);
    expressions = ColumnList();
    jj_consume_token(380);
return new ParenthesedExpressionList<Column>(expressions);
}

  final public ExpressionList ComplexExpressionList() throws ParseException {ExpressionList expressions = new ExpressionList();
    Expression expr;
    if (jj_2_200(2)) {
      expr = OracleNamedFunctionParameter();
    } else if (jj_2_201(1)) {
      expr = Expression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
expressions.add(expr);
    label_43:
    while (true) {
      if (jj_2_202(2) && (!interrupted)) {
        ;
      } else {
        break label_43;
      }
      jj_consume_token(K_COMMA);
      if (jj_2_203(2)) {
        expr = OracleNamedFunctionParameter();
      } else if (jj_2_204(1)) {
        expr = Expression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
expressions.add(expr);
    }
return expressions;
}

// @Todo: Refactor this with proper SQL:2016 functions according to https://manticore-projects.com/SQL2016Parser/syntax.html#character-value-function
// substring(expr1 from expr2)
// substring(expr1 from expr2 for expr3)
// trim(expr1 from expr2)   <-- Superceded by TrimFunction() below
// position(expr1 in expr2)
// overlay(expr1 placing expr2 from expr3)
// overlay(expr1 placing expr2 from expr3 for expr4)
// expr1 has already been consumed
  final public NamedExpressionList NamedExpressionListExprFirst() throws ParseException {NamedExpressionList retval = new NamedExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    List<String> names = new ArrayList<String>();
    Expression expr1 = null;
    Expression expr2 = null;
    Expression expr3 = null;
    Expression expr4 = null;
    Token tk2 = null;
    Token tk3 = null;
    Token tk4 = null;
    expr1 = SimpleExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:{
      tk2 = jj_consume_token(K_FROM);
      break;
      }
    case K_IN:{
      tk2 = jj_consume_token(K_IN);
      break;
      }
    case K_PLACING:{
      tk2 = jj_consume_token(K_PLACING);
      break;
      }
    default:
      jj_la1[228] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
names.add("");
                expressions.add(expr1);
                names.add(tk2.image);
    expr2 = SimpleExpression();
expressions.add(expr2);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FOR:
    case K_FROM:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FOR:{
        tk3 = jj_consume_token(K_FOR);
        break;
        }
      case K_FROM:{
        tk3 = jj_consume_token(K_FROM);
        break;
        }
      default:
        jj_la1[229] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr3 = SimpleExpression();
names.add(tk3.image); expressions.add(expr3);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FOR:{
        tk4 = jj_consume_token(K_FOR);
        expr4 = SimpleExpression();
names.add(tk4.image); expressions.add(expr4);
        break;
        }
      default:
        jj_la1[230] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[231] = jj_gen;
      ;
    }
retval.setNames(names);
        retval.setExpressions(expressions);
        return retval;
}

  final public Expression ComparisonItem() throws ParseException {Expression retval = null;
    if (jj_2_205(3)) {
      retval = AnyComparisonExpression();
    } else if (jj_2_206(3)) {
      retval = SimpleExpression();
    } else if (jj_2_207(3)) {
      retval = ParenthesedExpressionList();
    } else if (jj_2_208(3)) {
      retval = RowConstructor();
    } else if (jj_2_209(1)) {
      retval = PrimaryExpression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
return retval;
}

  final public Expression AnyComparisonExpression() throws ParseException {AnyType anyType;
    Select select;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ANY:{
      jj_consume_token(K_ANY);
anyType = AnyType.ANY;
      break;
      }
    case K_SOME:{
      jj_consume_token(K_SOME);
anyType = AnyType.SOME;
      break;
      }
    case K_ALL:{
      jj_consume_token(K_ALL);
anyType = AnyType.ALL;
      break;
      }
    default:
      jj_la1[232] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    select = Select();
return new AnyComparisonExpression(anyType, select);
}

  final public Expression SimpleExpression() throws ParseException {Expression retval = null;
    UserVariable user = null;
    Token operation = null;
    if (jj_2_210(2147483647)) {
      user = UserVariable();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 381:{
        operation = jj_consume_token(381);
        break;
        }
      case 409:{
        operation = jj_consume_token(409);
        break;
        }
      default:
        jj_la1[233] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    retval = ConcatExpression();
if (user != null) {
            VariableAssignment assignment = new VariableAssignment();
            assignment.setVariable(user);
            assignment.setOperation(operation.image);
            assignment.setExpression(retval);
            return assignment;
        } else
            return retval;
}

  final public Expression ConcatExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = BitwiseAndOr();
result = leftExpression;
    label_44:
    while (true) {
      if (jj_2_211(3)) {
        ;
      } else {
        break label_44;
      }
      jj_consume_token(OP_CONCAT);
      /* Oracle allows space between the bars. */
              rightExpression = BitwiseAndOr();
Concat binExp = new Concat();
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            result = binExp;
            leftExpression = result;
    }
return result;
}

  final public Expression BitwiseAndOr() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = AdditiveExpression();
result = leftExpression;
    label_45:
    while (true) {
      if (jj_2_212(2)) {
        ;
      } else {
        break label_45;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 410:{
        jj_consume_token(410);
result = new BitwiseOr();
        break;
        }
      case 411:{
        jj_consume_token(411);
result = new BitwiseAnd();
        break;
        }
      case 412:{
        jj_consume_token(412);
result = new BitwiseLeftShift();
        break;
        }
      case 413:{
        jj_consume_token(413);
result = new BitwiseRightShift();
        break;
        }
      default:
        jj_la1[234] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = AdditiveExpression();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression AdditiveExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = MultiplicativeExpression();
result = leftExpression;
    label_46:
    while (true) {
      if (jj_2_213(2)) {
        ;
      } else {
        break label_46;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 393:{
        jj_consume_token(393);
result = new Addition();
        break;
        }
      case 405:{
        jj_consume_token(405);
result = new Subtraction();
        break;
        }
      default:
        jj_la1[235] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = MultiplicativeExpression();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression MultiplicativeExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = BitwiseXor();
result = leftExpression;
    label_47:
    while (true) {
      if (jj_2_214(2)) {
        ;
      } else {
        break label_47;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 390:{
        jj_consume_token(390);
result = new Multiplication();
        break;
        }
      case 414:{
        jj_consume_token(414);
result = new Division();
        break;
        }
      case K_DIV:{
        jj_consume_token(K_DIV);
result = new IntegerDivision();
        break;
        }
      case 415:{
        jj_consume_token(415);
result = new Modulo();
        break;
        }
      default:
        jj_la1[236] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = BitwiseXor();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression BitwiseXor() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = PrimaryExpression();
result = leftExpression;
    label_48:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 416:{
        ;
        break;
        }
      default:
        jj_la1[237] = jj_gen;
        break label_48;
      }
      jj_consume_token(416);
      rightExpression = PrimaryExpression();
BitwiseXor binExp = new BitwiseXor();
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            result = binExp;
            leftExpression = result;
    }
return result;
}

  final public Expression ArrayExpression(Expression obj) throws ParseException {Expression expr;
    Expression idxExpr = null;
    Expression startExpr = null;
    Expression stopExpr = null;
    jj_consume_token(417);
    if (jj_2_215(3)) {
      idxExpr = SimpleExpression();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 384:{
      jj_consume_token(384);
startExpr=idxExpr; idxExpr=null;
      if (jj_2_216(1)) {
        stopExpr = SimpleExpression();
      } else {
        ;
      }
      break;
      }
    default:
      jj_la1[238] = jj_gen;
      ;
    }
    jj_consume_token(418);
expr =  new ArrayExpression(obj, idxExpr, startExpr, stopExpr);
    label_49:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 417:{
        ;
        break;
        }
      default:
        jj_la1[239] = jj_gen;
        break label_49;
      }
      jj_consume_token(417);
      if (jj_2_217(3)) {
        idxExpr = SimpleExpression();
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 384:{
        jj_consume_token(384);
startExpr=idxExpr; idxExpr=null;
        if (jj_2_218(1)) {
          stopExpr = SimpleExpression();
        } else {
          ;
        }
        break;
        }
      default:
        jj_la1[240] = jj_gen;
        ;
      }
      jj_consume_token(418);
expr =  new ArrayExpression(expr, idxExpr, startExpr, stopExpr);
    }
return expr;
}

  final public Expression PrimaryExpression() throws ParseException {/*@bgen(jjtree) PrimaryExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTPRIMARYEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression retval = null;
    CastExpression castExpr = null;
    TimezoneExpression timezoneExpr = null;
    Expression timezoneRightExpr = null;
    Token token = null;
    Token sign = null;
    String tmp = "";
    ColDataType type = null;
    boolean not = false;
    boolean exclamationMarkNot = false;
    boolean dateExpressionAllowed = true;
    ExpressionList list;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:
      case 392:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:{
          jj_consume_token(K_NOT);
not=true;
          break;
          }
        case 392:{
          jj_consume_token(392);
not=true; exclamationMarkNot=true;
          break;
          }
        default:
          jj_la1[241] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[242] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 393:
      case 397:
      case 405:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 393:{
          sign = jj_consume_token(393);
          break;
          }
        case 405:{
          sign = jj_consume_token(405);
          break;
          }
        case 397:{
          sign = jj_consume_token(397);
          break;
          }
        default:
          jj_la1[243] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[244] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NULL:{
        jj_consume_token(K_NULL);
retval = new NullValue();
        break;
        }
      default:
        jj_la1[247] = jj_gen;
        if (jj_2_220(3) && (!interrupted)) {
          retval = CaseWhenExpression();
        } else if (jj_2_221(3)) {
          retval = SimpleJdbcParameter();
        } else if (jj_2_222(2)) {
          retval = JdbcNamedParameter();
        } else if (jj_2_223(3)) {
          retval = UserVariable();
        } else if (jj_2_224(2) && (!interrupted)) {
          retval = NumericBind();
        } else if (jj_2_225(3) && (!interrupted)) {
          retval = ExtractExpression();
        } else if (jj_2_226(3)) {
          retval = MySQLGroupConcat();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_XMLSERIALIZE:{
            retval = XMLSerializeExpr();
            break;
            }
          default:
            jj_la1[248] = jj_gen;
            if (jj_2_227(2147483647) && (!interrupted)) {
              retval = JsonExpression();
            } else if (jj_2_228(2147483647) && (!interrupted)) {
              retval = JsonFunction();
            } else if (jj_2_229(2147483647) && (!interrupted)) {
              retval = JsonAggregateFunction();
            } else if (jj_2_230(2147483647) && (!interrupted)) {
              retval = FullTextSearch();
            } else if (jj_2_231(2147483647) && (!interrupted)) {
              retval = Function();
              if (jj_2_219(2)) {
                retval = AnalyticExpression((Function) retval);
              } else {
                ;
              }
            } else if (jj_2_232(2) && (!interrupted)) {
              retval = IntervalExpression();
dateExpressionAllowed = false;
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case S_DOUBLE:{
                token = jj_consume_token(S_DOUBLE);
retval = new DoubleValue(token.image);
                break;
                }
              case S_LONG:{
                token = jj_consume_token(S_LONG);
retval = new LongValue(token.image);
                break;
                }
              case S_HEX:{
                token = jj_consume_token(S_HEX);
retval = new HexValue(token.image);
                break;
                }
              default:
                jj_la1[249] = jj_gen;
                if (jj_2_233(2) && (!interrupted)) {
                  retval = CastExpression();
                } else if (jj_2_234(2) && (!interrupted)) {
                  retval = CharacterPrimary();
                } else if (jj_2_235(2) && (!interrupted)) {
                  switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                  case K_TIME_KEY_EXPR:{
                    token = jj_consume_token(K_TIME_KEY_EXPR);
                    break;
                    }
                  case K_CURRENT:{
                    token = jj_consume_token(K_CURRENT);
                    break;
                    }
                  default:
                    jj_la1[245] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
                  }
retval = new TimeKeyExpression(token.image);
                } else if (jj_2_236(2) && (!interrupted)) {
                  retval = DateTimeLiteralExpression();
                } else if (jj_2_237(2) && (!interrupted)) {
                  jj_consume_token(K_ARRAY_LITERAL);
                  retval = ArrayConstructor(true);
                } else if (jj_2_238(2) && (!interrupted)) {
                  retval = NextValExpression();
                } else {
                  switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                  case K_CONNECT_BY_ROOT:{
                    retval = ConnectByRootOperator();
                    break;
                    }
                  default:
                    jj_la1[250] = jj_gen;
                    if (jj_2_239(2) && (!interrupted)) {
                      jj_consume_token(K_ALL);
retval = new AllValue();
                    } else if (jj_2_240(2) && (!interrupted)) {
                      retval = Column();
                    } else {
                      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                      case S_CHAR_LITERAL:{
                        token = jj_consume_token(S_CHAR_LITERAL);
retval = new StringValue(token.image); linkAST(retval,jjtn000);
                        break;
                        }
                      case 419:{
                        jj_consume_token(419);
                        token = jj_consume_token(S_CHAR_LITERAL);
                        jj_consume_token(420);
retval = new DateValue(token.image);
                        break;
                        }
                      case 421:{
                        jj_consume_token(421);
                        token = jj_consume_token(S_CHAR_LITERAL);
                        jj_consume_token(420);
retval = new TimeValue(token.image);
                        break;
                        }
                      case 422:{
                        jj_consume_token(422);
                        token = jj_consume_token(S_CHAR_LITERAL);
                        jj_consume_token(420);
retval = new TimestampValue(token.image);
                        break;
                        }
                      default:
                        jj_la1[251] = jj_gen;
                        if (jj_2_241(2147483647) && (!interrupted)) {
                          retval = ParenthesedSelect();
                        } else {
                          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                          case 379:{
                            list = ParenthesedExpressionList();
if (list.size() == 1) {
                    retval = new Parenthesis( (Expression) list.getExpressions().get(0));
                } else {
                    retval = list;
                }
                            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                            case 383:{
                              jj_consume_token(383);
                              tmp = RelObjectNameExt();
retval = new RowGetExpression(retval, tmp);
                              break;
                              }
                            default:
                              jj_la1[246] = jj_gen;
                              ;
                            }
                            break;
                            }
                          default:
                            jj_la1[252] = jj_gen;
                            jj_consume_token(-1);
                            throw new ParseException();
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      if (jj_2_242(2)) {
        jj_consume_token(K_COLLATE);
        token = jj_consume_token(S_IDENTIFIER);
retval = new CollateExpression(retval, token.image);
      } else {
        ;
      }
      if (jj_2_243(2) && (dateExpressionAllowed)) {
        retval = IntervalExpressionWithoutInterval(retval);
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 417:{
        retval = ArrayExpression(retval);
        break;
        }
      default:
        jj_la1[253] = jj_gen;
        ;
      }
      label_50:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 423:{
          ;
          break;
          }
        default:
          jj_la1[254] = jj_gen;
          break label_50;
        }
        jj_consume_token(423);
        type = ColDataType();
castExpr = new CastExpression();
        castExpr.setUseCastKeyword(false);
        castExpr.setLeftExpression(retval);
        castExpr.setColDataType(type);
        retval=castExpr;
      }
      label_51:
      while (true) {
        if (jj_2_244(2)) {
          ;
        } else {
          break label_51;
        }
        jj_consume_token(K_AT);
        jj_consume_token(K_DATETIMELITERAL);
        jj_consume_token(K_ZONE);
        timezoneRightExpr = PrimaryExpression();
if (timezoneExpr == null)
            timezoneExpr = new TimezoneExpression();

        timezoneExpr.addTimezoneExpression(timezoneRightExpr);
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
if (timezoneExpr != null && !timezoneExpr.getTimezoneExpressions().isEmpty()) {
            timezoneExpr.setLeftExpression(retval);
            retval=timezoneExpr;
        }
        if (sign != null) {
            retval = new SignedExpression(sign.image.charAt(0), retval);
        }
        if (not) {
            retval = new NotExpression(retval, exclamationMarkNot);
        }
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ConnectByRootOperator ConnectByRootOperator() throws ParseException {/*@bgen(jjtree) ConnectByRootOperator */
    SimpleNode jjtn000 = new SimpleNode(JJTCONNECTBYROOTOPERATOR);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Column column;
    try {
      jj_consume_token(K_CONNECT_BY_ROOT);
      column = Column();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return new ConnectByRootOperator(column);
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public NextValExpression NextValExpression() throws ParseException {List<String> data = new ArrayList<String>();
    Token token;
    token = jj_consume_token(K_NEXTVAL);
    data = RelObjectNameList();
return new NextValExpression(data, token.image);
}

  final public JdbcNamedParameter JdbcNamedParameter() throws ParseException {JdbcNamedParameter parameter = new JdbcNamedParameter();
    String name;
    String namePart;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 384:{
      jj_consume_token(384);
      break;
      }
    case 411:{
      jj_consume_token(411);
parameter.setParameterCharacter("&");
      break;
      }
    default:
      jj_la1[255] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    name = IdentifierChain();
parameter.setName(name);
        return parameter;
}

  final public OracleNamedFunctionParameter OracleNamedFunctionParameter() throws ParseException {String name;
    Expression expression;
    name = RelObjectNameExt2();
    jj_consume_token(K_ORACLE_NAMED_PARAMETER_ASSIGNMENT);
    expression = Expression();
return new OracleNamedFunctionParameter(name, expression);
}

  final public UserVariable UserVariable() throws ParseException {UserVariable var = new UserVariable();
    String varName;
    String var2;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 424:{
      jj_consume_token(424);
      break;
      }
    case 396:{
      jj_consume_token(396);
var.setDoubleAdd(true);
      break;
      }
    default:
      jj_la1[256] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    varName = IdentifierChain();
var.setName(varName);
        return var;
}

  final public NumericBind NumericBind() throws ParseException {NumericBind var = new NumericBind();
    Token token;
    jj_consume_token(384);
    token = jj_consume_token(S_LONG);
var.setBindId(Integer.valueOf(token.image));
        return var;
}

  final public DateTimeLiteralExpression DateTimeLiteralExpression() throws ParseException {DateTimeLiteralExpression expr = new DateTimeLiteralExpression();
    Token t;
    t = jj_consume_token(K_DATETIMELITERAL);
expr.setType(DateTimeLiteralExpression.DateTime.from(t.image));
    t = jj_consume_token(S_CHAR_LITERAL);
expr.setValue(t.image); return expr;
}

  final public RangeExpression RangeExpression(Expression startExpression) throws ParseException {Expression endExpression;
    jj_consume_token(384);
    endExpression = Expression();
return new RangeExpression(startExpression, endExpression);
}

  final public ArrayConstructor ArrayConstructor(boolean arrayKeyword) throws ParseException {ExpressionList expList = new ExpressionList();
    ArrayConstructor array = new ArrayConstructor(expList, arrayKeyword);
    Expression exp;
    jj_consume_token(417);
    if (jj_2_247(1)) {
      if (jj_2_245(3)) {
        exp = Expression();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 384:{
          exp = RangeExpression(exp);
          break;
          }
        default:
          jj_la1[257] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 417:{
          exp = ArrayConstructor(false);
          break;
          }
        default:
          jj_la1[258] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
expList.add(exp);
      label_52:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[259] = jj_gen;
          break label_52;
        }
        jj_consume_token(K_COMMA);
        if (jj_2_246(3)) {
          exp = Expression();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 384:{
            exp = RangeExpression(exp);
            break;
            }
          default:
            jj_la1[260] = jj_gen;
            ;
          }
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 417:{
            exp = ArrayConstructor(false);
            break;
            }
          default:
            jj_la1[261] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
expList.add(exp);
      }
    } else {
      ;
    }
    jj_consume_token(418);
return array;
}

  final public Expression ParenthesedExpression() throws ParseException {Expression expression;
    jj_consume_token(379);
    expression = PrimaryExpression();
    jj_consume_token(380);
return new Parenthesis(expression);
}

  final public JsonExpression JsonExpression() throws ParseException {JsonExpression result = new JsonExpression();
  Expression expr;
  Token token;
  ColDataType type = null;
  CastExpression castExpr = null;
    if (jj_2_248(3) && (!interrupted)) {
      expr = CaseWhenExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 391:{
        expr = SimpleJdbcParameter();
        break;
        }
      default:
        jj_la1[262] = jj_gen;
        if (jj_2_249(2) && (!interrupted)) {
          expr = JdbcNamedParameter();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 396:
          case 424:{
            expr = UserVariable();
            break;
            }
          default:
            jj_la1[263] = jj_gen;
            if (jj_2_250(2147483647) && (getAsBoolean(Feature.allowComplexParsing) && !interrupted)) {
              expr = JsonFunction();
            } else if (jj_2_251(2147483647) && (getAsBoolean(Feature.allowComplexParsing) && !interrupted)) {
              expr = JsonAggregateFunction();
            } else if (jj_2_252(2147483647) && (getAsBoolean(Feature.allowComplexParsing) && !interrupted)) {
              expr = FullTextSearch();
            } else if (jj_2_253(2147483647) && (getAsBoolean(Feature.allowComplexParsing) && !interrupted)) {
              expr = Function();
            } else if (jj_2_254(2) && (!interrupted)) {
              expr = Column();
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case S_CHAR_LITERAL:{
                token = jj_consume_token(S_CHAR_LITERAL);
expr = new StringValue(token.image);
                break;
                }
              default:
                jj_la1[264] = jj_gen;
                if (jj_2_255(2147483647) && (getAsBoolean(Feature.allowComplexParsing))) {
                  expr = ParenthesedExpression();
                } else if (jj_2_256(3) && (getAsBoolean(Feature.allowComplexParsing) && !interrupted)) {
                  expr = ParenthesedSelect();
                } else {
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        }
      }
    }
    label_53:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 423:{
        ;
        break;
        }
      default:
        jj_la1[265] = jj_gen;
        break label_53;
      }
      jj_consume_token(423);
      type = ColDataType();
castExpr = new CastExpression();
            castExpr.setUseCastKeyword(false);
            castExpr.setLeftExpression(expr);
            castExpr.setColDataType(type);
            expr=castExpr;
    }
result.setExpression(expr);
    label_54:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 425:{
        jj_consume_token(425);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_CHAR_LITERAL:{
          token = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        case S_LONG:{
          token = jj_consume_token(S_LONG);
          break;
          }
        default:
          jj_la1[266] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
result.addIdent(token.image,"->");
        break;
        }
      case 426:{
        jj_consume_token(426);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_CHAR_LITERAL:{
          token = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        case S_LONG:{
          token = jj_consume_token(S_LONG);
          break;
          }
        default:
          jj_la1[267] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
result.addIdent(token.image,"->>");
        break;
        }
      case 427:{
        jj_consume_token(427);
        token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"#>");
        break;
        }
      case 428:{
        jj_consume_token(428);
        token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"#>>");
        break;
        }
      default:
        jj_la1[268] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_257(2)) {
        ;
      } else {
        break label_54;
      }
    }
    label_55:
    while (true) {
      if (jj_2_258(2) && (!interrupted)) {
        ;
      } else {
        break label_55;
      }
      label_56:
      while (true) {
        jj_consume_token(423);
        type = ColDataType();
castExpr = new CastExpression();
                    castExpr.setUseCastKeyword(false);
                    castExpr.setLeftExpression(result);
                    castExpr.setColDataType(type);
                    expr=castExpr;
        if (jj_2_259(2)) {
          ;
        } else {
          break label_56;
        }
      }
result = new JsonExpression();
            result.setExpression(expr);
      label_57:
      while (true) {
        if (jj_2_260(2)) {
          ;
        } else {
          break label_57;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 425:{
          jj_consume_token(425);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_CHAR_LITERAL:{
            token = jj_consume_token(S_CHAR_LITERAL);
            break;
            }
          case S_LONG:{
            token = jj_consume_token(S_LONG);
            break;
            }
          default:
            jj_la1[269] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
result.addIdent(token.image,"->");
          break;
          }
        case 426:{
          jj_consume_token(426);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_CHAR_LITERAL:{
            token = jj_consume_token(S_CHAR_LITERAL);
            break;
            }
          case S_LONG:{
            token = jj_consume_token(S_LONG);
            break;
            }
          default:
            jj_la1[270] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
result.addIdent(token.image,"->>");
          break;
          }
        case 427:{
          jj_consume_token(427);
          token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"#>");
          break;
          }
        case 428:{
          jj_consume_token(428);
          token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"#>>");
          break;
          }
        default:
          jj_la1[271] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
result.setExpression(expr);
        return result;
}

  final public JsonFunction JsonFunction() throws ParseException {JsonFunction result = new JsonFunction();
    boolean usingKeyKeyword = false;
    boolean usingValueKeyword = false;
    boolean usingFormatJason = false;
    Token keyToken;
    Token valueToken = null;
    Column column = null;
    JsonKeyValuePair keyValuePair;

    Expression expression = null;
    JsonFunctionExpression functionExpression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_JSON_OBJECT:{
      jj_consume_token(K_JSON_OBJECT);
      jj_consume_token(379);
result.setType( JsonFunctionType.OBJECT );
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_KEY:
      case S_CHAR_LITERAL:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_KEY:{
          jj_consume_token(K_KEY);
usingKeyKeyword = true;
          break;
          }
        default:
          jj_la1[272] = jj_gen;
          ;
        }
        keyToken = jj_consume_token(S_CHAR_LITERAL);
        if (jj_2_261(2)) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 384:{
            jj_consume_token(384);
            break;
            }
          case K_COMMA:{
            jj_consume_token(K_COMMA);
result.setType( JsonFunctionType.POSTGRES_OBJECT );
            break;
            }
          case K_VALUE:{
            jj_consume_token(K_VALUE);
usingValueKeyword = true;
            break;
            }
          default:
            jj_la1[273] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          expression = Expression();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_FORMAT:{
            jj_consume_token(K_FORMAT);
            jj_consume_token(K_JSON);
usingFormatJason = true;
            break;
            }
          default:
            jj_la1[274] = jj_gen;
            ;
          }
        } else {
          ;
        }
if (expression !=null) {
                                                                           keyValuePair = new JsonKeyValuePair( keyToken.image, expression, usingKeyKeyword, usingValueKeyword );
                                                                           keyValuePair.setUsingFormatJson( usingFormatJason );
                                                                           result.add(keyValuePair);
                                                                      } else {
                                       result.setType( JsonFunctionType.POSTGRES_OBJECT );
                                       keyValuePair = new JsonKeyValuePair( keyToken.image, null, false, false );
                                       result.add(keyValuePair);
                                  }
        label_58:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[275] = jj_gen;
            break label_58;
          }
          jj_consume_token(K_COMMA);
usingKeyKeyword = false; usingValueKeyword = false;
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_KEY:{
            jj_consume_token(K_KEY);
usingKeyKeyword = true;
            break;
            }
          default:
            jj_la1[276] = jj_gen;
            ;
          }
          keyToken = jj_consume_token(S_CHAR_LITERAL);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 384:{
            jj_consume_token(384);
            break;
            }
          case K_COMMA:{
            jj_consume_token(K_COMMA);
result.setType( JsonFunctionType.MYSQL_OBJECT );
            break;
            }
          case K_VALUE:{
            jj_consume_token(K_VALUE);
usingValueKeyword = true;
            break;
            }
          default:
            jj_la1[277] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          expression = Expression();
keyValuePair = new JsonKeyValuePair( keyToken.image, expression, usingKeyKeyword, usingValueKeyword ); result.add(keyValuePair);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_FORMAT:{
            jj_consume_token(K_FORMAT);
            jj_consume_token(K_JSON);
keyValuePair.setUsingFormatJson( true );
            break;
            }
          default:
            jj_la1[278] = jj_gen;
            ;
          }
        }
        break;
        }
      default:
        jj_la1[279] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ABSENT:
      case K_NULL:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NULL:{
          jj_consume_token(K_NULL);
          jj_consume_token(K_ON);
          jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.NULL );
          break;
          }
        case K_ABSENT:{
          jj_consume_token(K_ABSENT);
          jj_consume_token(K_ON);
          jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.ABSENT );
          break;
          }
        default:
          jj_la1[280] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[281] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WITH:
      case K_WITHOUT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WITH:{
          jj_consume_token(K_WITH);
          jj_consume_token(K_UNIQUE);
          jj_consume_token(K_KEYS);
result.setUniqueKeysType( JsonAggregateUniqueKeysType.WITH );
          break;
          }
        case K_WITHOUT:{
          jj_consume_token(K_WITHOUT);
          jj_consume_token(K_UNIQUE);
          jj_consume_token(K_KEYS);
result.setUniqueKeysType( JsonAggregateUniqueKeysType.WITHOUT );
          break;
          }
        default:
          jj_la1[282] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[283] = jj_gen;
        ;
      }
      jj_consume_token(380);
      break;
      }
    case K_JSON_ARRAY:{
      jj_consume_token(K_JSON_ARRAY);
result.setType( JsonFunctionType.ARRAY );
      jj_consume_token(379);
      label_59:
      while (true) {
        if (jj_2_262(1)) {
          ;
        } else {
          break label_59;
        }
        if (jj_2_265(2)) {
          jj_consume_token(K_NULL);
          jj_consume_token(K_ON);
          jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.NULL );
        } else if (jj_2_266(1)) {
          expression = Expression();
functionExpression = new JsonFunctionExpression( expression ); result.add( functionExpression );
          if (jj_2_263(2)) {
            jj_consume_token(K_FORMAT);
            jj_consume_token(K_JSON);
functionExpression.setUsingFormatJson( true );
          } else {
            ;
          }
          label_60:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[284] = jj_gen;
              break label_60;
            }
            jj_consume_token(K_COMMA);
            expression = Expression();
functionExpression = new JsonFunctionExpression( expression ); result.add( functionExpression );
            if (jj_2_264(2)) {
              jj_consume_token(K_FORMAT);
              jj_consume_token(K_JSON);
functionExpression.setUsingFormatJson( true );
            } else {
              ;
            }
          }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ABSENT:{
        jj_consume_token(K_ABSENT);
        jj_consume_token(K_ON);
        jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.ABSENT );
        break;
        }
      default:
        jj_la1[285] = jj_gen;
        ;
      }
      jj_consume_token(380);
      break;
      }
    default:
      jj_la1[286] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return result;
}

  final public JsonAggregateFunction JsonAggregateFunction() throws ParseException {JsonAggregateFunction result = new JsonAggregateFunction();
    Token token;
    Expression expression;
    List<OrderByElement> expressionOrderByList = null;

    Expression filter;
    ExpressionList expressionList = null;
    List<OrderByElement> olist = null;
    WindowElement windowElement = null;
    boolean partitionByBrackets = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_JSON_OBJECTAGG:{
      jj_consume_token(K_JSON_OBJECTAGG);
      jj_consume_token(379);
result.setType( JsonFunctionType.OBJECT );
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_KEY:{
        jj_consume_token(K_KEY);
result.setUsingKeyKeyword( true );
        break;
        }
      default:
        jj_la1[287] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DT_ZONE:{
        token = jj_consume_token(DT_ZONE);
        break;
        }
      case S_DOUBLE:{
        token = jj_consume_token(S_DOUBLE);
        break;
        }
      case S_LONG:{
        token = jj_consume_token(S_LONG);
        break;
        }
      case S_HEX:{
        token = jj_consume_token(S_HEX);
        break;
        }
      case S_CHAR_LITERAL:{
        token = jj_consume_token(S_CHAR_LITERAL);
        break;
        }
      case S_IDENTIFIER:{
        token = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        token = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[288] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
result.setKey( token.image );
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 384:{
        jj_consume_token(384);
        break;
        }
      case K_VALUE:{
        jj_consume_token(K_VALUE);
result.setUsingValueKeyword( true );
        break;
        }
      default:
        jj_la1[289] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        token = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        token = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[290] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
result.setValue( token.image );
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FORMAT:{
        jj_consume_token(K_FORMAT);
        jj_consume_token(K_JSON);
result.setUsingFormatJson( true );
        break;
        }
      default:
        jj_la1[291] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ABSENT:
      case K_NULL:{
        if (jj_2_267(2)) {
          jj_consume_token(K_NULL);
          jj_consume_token(K_ON);
          jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.NULL );
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ABSENT:{
            jj_consume_token(K_ABSENT);
            jj_consume_token(K_ON);
            jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.ABSENT );
            break;
            }
          default:
            jj_la1[292] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[293] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WITH:
      case K_WITHOUT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WITH:{
          jj_consume_token(K_WITH);
          jj_consume_token(K_UNIQUE);
          jj_consume_token(K_KEYS);
result.setUniqueKeysType( JsonAggregateUniqueKeysType.WITH );
          break;
          }
        case K_WITHOUT:{
          jj_consume_token(K_WITHOUT);
          jj_consume_token(K_UNIQUE);
          jj_consume_token(K_KEYS);
result.setUniqueKeysType( JsonAggregateUniqueKeysType.WITHOUT );
          break;
          }
        default:
          jj_la1[294] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[295] = jj_gen;
        ;
      }
      jj_consume_token(380);
      break;
      }
    case K_JSON_ARRAYAGG:{
      jj_consume_token(K_JSON_ARRAYAGG);
      jj_consume_token(379);
result.setType( JsonFunctionType.ARRAY );
      expression = Expression();
result.setExpression( expression );
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FORMAT:{
        jj_consume_token(K_FORMAT);
        jj_consume_token(K_JSON);
result.setUsingFormatJson( true );
        break;
        }
      default:
        jj_la1[296] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ORDER:{
        expressionOrderByList = OrderByElements();
result.setExpressionOrderByElements( expressionOrderByList );
        break;
        }
      default:
        jj_la1[297] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ABSENT:
      case K_NULL:{
        if (jj_2_268(2)) {
          jj_consume_token(K_NULL);
          jj_consume_token(K_ON);
          jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.NULL );
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ABSENT:{
            jj_consume_token(K_ABSENT);
            jj_consume_token(K_ON);
            jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.ABSENT );
            break;
            }
          default:
            jj_la1[298] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[299] = jj_gen;
        ;
      }
      jj_consume_token(380);
      break;
      }
    default:
      jj_la1[300] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_269(2)) {
      jj_consume_token(K_FILTER);
      jj_consume_token(379);
      jj_consume_token(K_WHERE);
result.setAnalyticType(AnalyticType.FILTER_ONLY);
      filter = Expression();
result.setFilterExpression( filter );
      jj_consume_token(380);
    } else {
      ;
    }
    if (jj_2_271(2)) {
      jj_consume_token(K_OVER);
result.setAnalyticType(AnalyticType.OVER);
      jj_consume_token(379);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_PARTITION:{
        jj_consume_token(K_PARTITION);
        jj_consume_token(K_BY);
        if (jj_2_270(2147483647)) {
          expressionList = ComplexExpressionList();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 379:{
            jj_consume_token(379);
partitionByBrackets = true;
            expressionList = ComplexExpressionList();
            jj_consume_token(380);
            break;
            }
          default:
            jj_la1[301] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[302] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ORDER:{
        olist = OrderByElements();
        break;
        }
      default:
        jj_la1[303] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_RANGE:
      case K_ROWS:{
        windowElement = WindowElement();
        break;
        }
      default:
        jj_la1[304] = jj_gen;
        ;
      }
result.setPartitionExpressionList(expressionList, partitionByBrackets);
                result.setOrderByElements(olist);
                result.setWindowElement(windowElement);
      jj_consume_token(380);
    } else {
      ;
    }
return result;
}

  final public IntervalExpression IntervalExpression() throws ParseException {IntervalExpression interval;
    Token token = null;
    Expression expr = null;
    boolean signed = false;
interval = new IntervalExpression();
    jj_consume_token(K_INTERVAL);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 405:{
      jj_consume_token(405);
signed=true;
      break;
      }
    default:
      jj_la1[305] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
      break;
      }
    case S_DOUBLE:{
      token = jj_consume_token(S_DOUBLE);
      break;
      }
    case S_CHAR_LITERAL:{
      token = jj_consume_token(S_CHAR_LITERAL);
      break;
      }
    default:
      jj_la1[306] = jj_gen;
      if (jj_2_272(2147483647)) {
        expr = SimpleJdbcParameter();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 384:
        case 411:{
          expr = JdbcNamedParameter();
          break;
          }
        default:
          jj_la1[307] = jj_gen;
          if (jj_2_273(2147483647)) {
            expr = Function();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ACTION:
            case K_ACTIVE:
            case K_ADD:
            case K_ADVANCE:
            case K_ADVISE:
            case K_AGAINST:
            case K_ALGORITHM:
            case K_ALL:
            case K_ALTER:
            case K_ANALYZE:
            case K_ANY:
            case K_APPLY:
            case K_ARCHIVE:
            case K_ARRAY_LITERAL:
            case K_AT:
            case K_ASC:
            case K_AUTHORIZATION:
            case K_AUTO:
            case K_BEGIN:
            case K_BERNOULLI:
            case K_BINARY:
            case K_BIT:
            case K_BLOCK:
            case K_BROWSE:
            case K_BY:
            case K_BYTES:
            case K_CACHE:
            case K_BUFFERS:
            case K_BYTE:
            case K_CALL:
            case K_CASCADE:
            case K_CASE:
            case K_CASEWHEN:
            case K_CAST:
            case K_CHARACTER:
            case K_CHANGE:
            case K_CHANGES:
            case K_CHECKPOINT:
            case K_CHAR:
            case K_CLOSE:
            case K_COLLATE:
            case K_COLUMN:
            case K_COLUMNS:
            case K_COMMIT:
            case K_COMMENT:
            case K_CONFLICT:
            case K_CONNECT:
            case K_CONVERT:
            case K_COSTS:
            case K_CREATE:
            case K_CYCLE:
            case K_DATABASE:
            case K_DECLARE:
            case K_DATETIMELITERAL:
            case K_DATE_LITERAL:
            case K_DEFAULT:
            case K_DEFERRABLE:
            case K_DELAYED:
            case K_DELETE:
            case K_DESC:
            case K_DESCRIBE:
            case K_DISABLE:
            case K_DISCONNECT:
            case K_DIV:
            case K_DDL:
            case K_DML:
            case K_DO:
            case K_DOMAIN:
            case K_DOUBLE:
            case K_DROP:
            case K_DUMP:
            case K_DUPLICATE:
            case K_ELEMENTS:
            case K_EMIT:
            case K_ENABLE:
            case K_END:
            case K_ESCAPE:
            case K_EXCLUDE:
            case K_EXEC:
            case K_EXECUTE:
            case K_EXPLAIN:
            case K_EXPLICIT:
            case K_EXTENDED:
            case K_EXTRACT:
            case K_ISOLATION:
            case K_FILTER:
            case K_FIRST:
            case K_FALSE:
            case K_FLUSH:
            case K_FOLLOWING:
            case K_FORMAT:
            case K_FULLTEXT:
            case K_FUNCTION:
            case K_GLOBAL:
            case K_GRANT:
            case K_GROUP:
            case K_GROUPING:
            case K_GUARD:
            case K_HISTORY:
            case K_HOPPING:
            case K_IF:
            case K_IIF:
            case K_IGNORE:
            case K_IN:
            case K_INCLUDE:
            case K_INCREMENT:
            case K_INDEX:
            case K_INSERT:
            case K_INTERLEAVE:
            case K_INTERPRET:
            case K_INTERVAL:
            case K_ISNULL:
            case K_JSON:
            case K_KEEP:
            case K_KEY:
            case K_KEYS:
            case K_FN:
            case K_LAST:
            case K_LEADING:
            case K_LEFT:
            case K_LIMIT:
            case K_LOCAL:
            case K_LOCKED:
            case K_LINK:
            case K_LOG:
            case K_MATCH:
            case K_MATCHED:
            case K_MATERIALIZED:
            case K_MAXVALUE:
            case K_MEMBER:
            case K_MERGE:
            case K_MINVALUE:
            case K_MODIFY:
            case K_MOVEMENT:
            case K_NEXT:
            case K_NO:
            case K_NOCACHE:
            case K_NOKEEP:
            case K_NOLOCK:
            case K_NOMAXVALUE:
            case K_NOMINVALUE:
            case K_NOORDER:
            case K_NOTHING:
            case K_NOTNULL:
            case K_NOVALIDATE:
            case K_NULLS:
            case K_NOWAIT:
            case K_OF:
            case K_OFF:
            case K_OFFSET:
            case K_ON:
            case K_OPEN:
            case K_ORDER:
            case K_OVER:
            case K_OVERLAPS:
            case K_OPTIMIZE:
            case K_PARALLEL:
            case K_PARENT:
            case K_PARTITION:
            case K_PATH:
            case K_PERCENT:
            case K_PLACING:
            case K_PRECEDING:
            case K_PRECISION:
            case K_PRIMARY:
            case K_PRIOR:
            case K_PROCEDURE:
            case K_PUBLIC:
            case K_PURGE:
            case K_QUALIFY:
            case K_QUERY:
            case K_QUICK:
            case K_QUIESCE:
            case K_RANGE:
            case K_RAW:
            case K_READ:
            case K_RECYCLEBIN:
            case K_REFERENCES:
            case K_REFRESH:
            case K_RLIKE:
            case K_REGISTER:
            case K_RENAME:
            case K_REPEATABLE:
            case K_REPLACE:
            case K_RESET:
            case K_RESTART:
            case K_RESUMABLE:
            case K_RESUME:
            case K_RESTRICT:
            case K_RESTRICTED:
            case K_RIGHT:
            case K_ROLLBACK:
            case K_ROOT:
            case K_ROW:
            case K_ROWS:
            case K_SAVEPOINT:
            case K_SCHEMA:
            case K_SEED:
            case K_SEQUENCE:
            case K_SEPARATOR:
            case K_SESSION:
            case K_SET:
            case K_SETS:
            case K_SHOW:
            case K_SHUTDOWN:
            case K_SIBLINGS:
            case K_SIMILAR:
            case K_SIZE:
            case K_SKIP:
            case K_SOME:
            case K_START:
            case K_STORED:
            case K_STRING:
            case K_SUSPEND:
            case K_SWITCH:
            case K_SYNONYM:
            case K_SYSTEM:
            case K_TABLE:
            case K_TABLES:
            case K_TABLESPACE:
            case K_TRIGGER:
            case K_THEN:
            case K_TEMP:
            case K_TEMPORARY:
            case K_TIME_KEY_EXPR:
            case K_TIMEOUT:
            case K_TO:
            case K_TOP:
            case K_TRUNCATE:
            case K_TRUE:
            case K_TUMBLING:
            case K_TYPE:
            case K_UNLOGGED:
            case K_UPDATE:
            case K_UPSERT:
            case K_UNQIESCE:
            case K_USER:
            case K_SIGNED:
            case K_STRING_FUNCTION_NAME:
            case K_UNSIGNED:
            case K_VALIDATE:
            case K_VALUE:
            case K_VALUES:
            case K_VERBOSE:
            case K_VIEW:
            case K_WAIT:
            case K_WITHIN:
            case K_WITHOUT:
            case K_WORK:
            case K_XML:
            case K_XMLAGG:
            case K_XMLDATA:
            case K_XMLSCHEMA:
            case K_XMLTEXT:
            case K_XSINIL:
            case K_YAML:
            case K_YES:
            case K_ZONE:
            case S_IDENTIFIER:
            case S_QUOTED_IDENTIFIER:
            case 385:
            case 386:
            case 387:
            case 388:
            case 389:{
              expr = Column();
              break;
              }
            default:
              jj_la1[308] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
    }
if (expr != null) {
            if (signed) expr = new SignedExpression('-', expr);
            interval.setExpression(expr);
        } else {
            interval.setParameter((signed?"-":"") + token.image);
        }
    if (jj_2_274(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        token = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_DATE_LITERAL:{
        token = jj_consume_token(K_DATE_LITERAL);
        break;
        }
      default:
        jj_la1[309] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
interval.setIntervalType(token.image);
    } else {
      ;
    }
return interval;
}

  final public IntervalExpression IntervalExpressionWithoutInterval(Expression expr) throws ParseException {IntervalExpression interval;
    Token token;
    boolean signed = false;
interval = new IntervalExpression(false);
        interval.setExpression(expr);
    token = jj_consume_token(K_DATE_LITERAL);
interval.setIntervalType(token.image);
        return interval;
}

  final public KeepExpression KeepExpression() throws ParseException {KeepExpression keep = new KeepExpression();
    Token token;
    List<OrderByElement> list;
    jj_consume_token(K_KEEP);
    jj_consume_token(379);
    token = jj_consume_token(S_IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
keep.setFirst(true);
      break;
      }
    case K_LAST:{
      jj_consume_token(K_LAST);
keep.setFirst(false);
      break;
      }
    default:
      jj_la1[310] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    list = OrderByElements();
    jj_consume_token(380);
keep.setName(token.image);
        keep.setOrderByElements(list);
        return keep;
}

  final public void windowFun(AnalyticExpression retval) throws ParseException {ExpressionList expressionList = null;
     boolean partitionByBrackets = false;
     String windowName = null;
     WindowDefinition winDef;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IGNORE:
    case K_OVER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_IGNORE:{
        jj_consume_token(K_IGNORE);
        jj_consume_token(K_NULLS);
retval.setIgnoreNullsOutside(true);
        break;
        }
      default:
        jj_la1[311] = jj_gen;
        ;
      }
      jj_consume_token(K_OVER);
retval.setType(AnalyticType.OVER);
      break;
      }
    case K_WITHIN:{
      jj_consume_token(K_WITHIN);
      jj_consume_token(K_GROUP);
retval.setType(AnalyticType.WITHIN_GROUP);
      break;
      }
    default:
      jj_la1[312] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALTER:
    case K_ANALYZE:
    case K_APPLY:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONNECT:
    case K_CONVERT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATABASE:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GLOBAL:
    case K_GRANT:
    case K_GROUP:
    case K_GUARD:
    case K_HISTORY:
    case K_HOPPING:
    case K_IGNORE:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_ON:
    case K_OPEN:
    case K_OVER:
    case K_OVERLAPS:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PURGE:
    case K_QUALIFY:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REFERENCES:
    case K_REFRESH:
    case K_RLIKE:
    case K_REGISTER:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_ROLLBACK:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_START:
    case K_STORED:
    case K_STRING:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 385:
    case 386:
    case 387:
    case 388:
    case 389:{
      windowName = RelObjectName();
retval.setWindowName(windowName);
      break;
      }
    case 379:{
      winDef = windowDefinition();
retval.setWindowDefinition(winDef);
      if (jj_2_276(2)) {
        jj_consume_token(K_OVER);
        jj_consume_token(379);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_PARTITION:{
          jj_consume_token(K_PARTITION);
          jj_consume_token(K_BY);
          if (jj_2_275(2147483647)) {
            expressionList = ComplexExpressionList();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 379:{
              jj_consume_token(379);
partitionByBrackets = true;
              expressionList = ComplexExpressionList();
              jj_consume_token(380);
              break;
              }
            default:
              jj_la1[313] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
          }
        default:
          jj_la1[314] = jj_gen;
          ;
        }
        jj_consume_token(380);
winDef.setPartitionExpressionList(expressionList, partitionByBrackets); retval.setType(AnalyticType.WITHIN_GROUP_OVER);
      } else {
        ;
      }
      break;
      }
    default:
      jj_la1[315] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public WindowDefinition windowDefinition() throws ParseException {ExpressionList expressionList = null;
    List<OrderByElement> olist = null;
    WindowElement windowElement = null;
    boolean partitionByBrackets = false;
    WindowDefinition winDef = new WindowDefinition();
    jj_consume_token(379);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PARTITION:{
      jj_consume_token(K_PARTITION);
      jj_consume_token(K_BY);
      if (jj_2_277(2147483647)) {
        expressionList = ComplexExpressionList();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 379:{
          jj_consume_token(379);
partitionByBrackets = true;
          expressionList = ComplexExpressionList();
          jj_consume_token(380);
          break;
          }
        default:
          jj_la1[316] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[317] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      olist = OrderByElements();
      break;
      }
    default:
      jj_la1[318] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RANGE:
    case K_ROWS:{
      windowElement = WindowElement();
      break;
      }
    default:
      jj_la1[319] = jj_gen;
      ;
    }
winDef.setPartitionExpressionList(expressionList, partitionByBrackets);
        winDef.setOrderByElements(olist);
        winDef.setWindowElement(windowElement);
    jj_consume_token(380);
return winDef;
}

  final public AnalyticExpression AnalyticExpression(Function function) throws ParseException {AnalyticExpression retval = new AnalyticExpression(function);
    Expression filter = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FILTER:{
      jj_consume_token(K_FILTER);
      jj_consume_token(379);
      jj_consume_token(K_WHERE);
retval.setType(AnalyticType.FILTER_ONLY);
      filter = Expression();
      jj_consume_token(380);
      if (jj_2_278(2)) {
        windowFun(retval);
      } else {
        ;
      }
      break;
      }
    case K_IGNORE:
    case K_OVER:
    case K_WITHIN:{
      windowFun(retval);
      break;
      }
    default:
      jj_la1[320] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
retval.setFilterExpression(filter);
        return retval;
}

  final public WindowElement WindowElement() throws ParseException {WindowElement windowElement = new WindowElement();
    WindowRange range = new WindowRange();
    WindowOffset offset = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROWS:{
      jj_consume_token(K_ROWS);
windowElement.setType(WindowElement.Type.ROWS);
      break;
      }
    case K_RANGE:{
      jj_consume_token(K_RANGE);
windowElement.setType(WindowElement.Type.RANGE);
      break;
      }
    default:
      jj_la1[321] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_BETWEEN:{
      jj_consume_token(K_BETWEEN);
windowElement.setRange(range);
      offset = WindowOffset();
range.setStart(offset);
      jj_consume_token(K_AND);
      offset = WindowOffset();
range.setEnd(offset);
      break;
      }
    default:
      jj_la1[322] = jj_gen;
      if (jj_2_279(1)) {
        offset = WindowOffset();
windowElement.setOffset(offset);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return windowElement;
}

  final public WindowOffset WindowOffset() throws ParseException {WindowOffset offset = new WindowOffset();
    Expression expr = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_UNBOUNDED:{
      jj_consume_token(K_UNBOUNDED);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_PRECEDING:{
        jj_consume_token(K_PRECEDING);
offset.setType(WindowOffset.Type.PRECEDING);
        break;
        }
      case K_FOLLOWING:{
        jj_consume_token(K_FOLLOWING);
offset.setType(WindowOffset.Type.FOLLOWING);
        break;
        }
      default:
        jj_la1[323] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[325] = jj_gen;
      if (jj_2_280(2)) {
        jj_consume_token(K_CURRENT);
        jj_consume_token(K_ROW);
offset.setType(WindowOffset.Type.CURRENT);
      } else if (jj_2_281(1)) {
        expr = SimpleExpression();
offset.setType(WindowOffset.Type.EXPR);
                        offset.setExpression(expr);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_PRECEDING:{
          jj_consume_token(K_PRECEDING);
offset.setType(WindowOffset.Type.PRECEDING);
          break;
          }
        case K_FOLLOWING:{
          jj_consume_token(K_FOLLOWING);
offset.setType(WindowOffset.Type.FOLLOWING);
          break;
          }
        default:
          jj_la1[324] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return offset;
}

  final public ExtractExpression ExtractExpression() throws ParseException {ExtractExpression retval = new ExtractExpression();
    String fieldName = null;
    Token token = null;
    Expression expr = null;
    jj_consume_token(K_EXTRACT);
    jj_consume_token(379);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALTER:
    case K_ANALYZE:
    case K_APPLY:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONNECT:
    case K_CONVERT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATABASE:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GLOBAL:
    case K_GRANT:
    case K_GROUP:
    case K_GUARD:
    case K_HISTORY:
    case K_HOPPING:
    case K_IGNORE:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_ON:
    case K_OPEN:
    case K_OVER:
    case K_OVERLAPS:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PURGE:
    case K_QUALIFY:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REFERENCES:
    case K_REFRESH:
    case K_RLIKE:
    case K_REGISTER:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_ROLLBACK:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_START:
    case K_STORED:
    case K_STRING:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 385:
    case 386:
    case 387:
    case 388:
    case 389:{
      fieldName = RelObjectName();
retval.setName(fieldName);
      break;
      }
    case S_CHAR_LITERAL:{
      token = jj_consume_token(S_CHAR_LITERAL);
retval.setName(token.image);
      break;
      }
    default:
      jj_la1[326] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_FROM);
    expr = SimpleExpression();
retval.setExpression(expr);
    jj_consume_token(380);
return retval;
}

  final public CastExpression CastExpression() throws ParseException {Token keyword;
    CastExpression retval;
    ColumnDefinition columnDefinition;
    ColDataType type;
    Expression expression = null;
    boolean    useCastKeyword;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CAST:{
      keyword = jj_consume_token(K_CAST);
      break;
      }
    case K_SAFE_CAST:{
      keyword = jj_consume_token(K_SAFE_CAST);
      break;
      }
    case K_TRY_CAST:{
      keyword = jj_consume_token(K_TRY_CAST);
      break;
      }
    case K_INTERPRET:{
      keyword = jj_consume_token(K_INTERPRET);
      break;
      }
    default:
      jj_la1[327] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
retval = new CastExpression(keyword.image);
    jj_consume_token(379);
    expression = SimpleExpression();
    jj_consume_token(K_AS);
retval.setUseCastKeyword(true);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROW:{
      jj_consume_token(K_ROW);
      jj_consume_token(379);
      columnDefinition = ColumnDefinition();
retval.addColumnDefinition(columnDefinition);
      label_61:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[328] = jj_gen;
          break label_61;
        }
        jj_consume_token(K_COMMA);
        columnDefinition = ColumnDefinition();
retval.addColumnDefinition(columnDefinition);
      }
      jj_consume_token(380);
      break;
      }
    case K_ARRAY_LITERAL:
    case K_BINARY:
    case K_BIT:
    case K_BYTES:
    case K_CHARACTER:
    case K_CHAR:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DOUBLE:
    case K_INTERVAL:
    case K_JSON:
    case K_SET:
    case K_STRING:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_XML:
    case DT_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      type = ColDataType();
retval.setColDataType(type);
      break;
      }
    default:
      jj_la1[329] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(380);
retval.setLeftExpression(expression);
        return retval;
}

  final public Expression CaseWhenExpression() throws ParseException {/*@bgen(jjtree) CaseWhenExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTCASEWHENEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));CaseExpression caseExp = new CaseExpression();
    Expression switchExp = null;
    WhenClause clause;
    List<WhenClause> whenClauses = new ArrayList<WhenClause>();
    Expression elseExp = null;
    try {
      jj_consume_token(K_CASE);
caseCounter++;
      if (jj_2_282(1)) {
        switchExp = Expression();
      } else {
        ;
      }
      label_62:
      while (true) {
        clause = WhenThenSearchCondition();
whenClauses.add(clause);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          ;
          break;
          }
        default:
          jj_la1[330] = jj_gen;
          break label_62;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ELSE:{
        jj_consume_token(K_ELSE);
        if (getAsBoolean(Feature.allowComplexParsing) && !interrupted) {
          elseExp = Expression();
        } else if (jj_2_283(1)) {
          elseExp = SimpleExpression();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[331] = jj_gen;
        ;
      }
      jj_consume_token(K_END);
caseCounter--;
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
caseExp.setSwitchExpression(switchExp);
        caseExp.setWhenClauses(whenClauses);
        caseExp.setElseExpression(elseExp);
        return caseExp;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public WhenClause WhenThenSearchCondition() throws ParseException {WhenClause whenThen = new WhenClause();
    Expression whenExp;
    Expression thenExp;
    jj_consume_token(K_WHEN);
    whenExp = Expression();
    jj_consume_token(K_THEN);
    if (getAsBoolean(Feature.allowComplexParsing) && !interrupted) {
      thenExp = Expression();
    } else if (jj_2_284(1)) {
      thenExp = SimpleExpression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
whenThen.setWhenExpression(whenExp);
       whenThen.setThenExpression(thenExp);
       return whenThen;
}

  final public RowConstructor RowConstructor() throws ParseException {Token token;
    ParenthesedExpressionList expressions;
    token = jj_consume_token(K_ROW);
    expressions = ParenthesedExpressionList();
return new RowConstructor(token.image, expressions);
}

/**
TODO: VariableExpression should be a standalone class with more operations available.
*/
  final public EqualsTo VariableExpression() throws ParseException {Expression left;
    Expression right;
    left = UserVariable();
    jj_consume_token(381);
    right = SimpleExpression();
EqualsTo equals = new EqualsTo();
        equals.setLeftExpression(left);
        equals.setRightExpression(right);
        return equals;
}

  final public Execute Execute() throws ParseException {Token token;
    List<String> funcName;
    ExpressionList expressionList = null;
    Execute execute = new Execute();
    List<Expression> namedExprList;
    Expression expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXEC:{
      jj_consume_token(K_EXEC);
execute.setExecType(Execute.ExecType.EXEC);
      break;
      }
    case K_EXECUTE:{
      jj_consume_token(K_EXECUTE);
execute.setExecType(Execute.ExecType.EXECUTE);
      break;
      }
    case K_CALL:{
      jj_consume_token(K_CALL);
execute.setExecType(Execute.ExecType.CALL);
      break;
      }
    default:
      jj_la1[332] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    funcName = RelObjectNameList();
execute.setName(funcName);
    if (jj_2_285(1)) {
      expressionList = ExpressionList();
execute.setExprList(expressionList);
    } else {
      ;
    }
return execute;
}

  final public FullTextSearch FullTextSearch() throws ParseException {Token searchModifier;
    Token againstValue;
    JdbcParameter jdbcParameter;
    JdbcNamedParameter jdbcNamedParameter;
    FullTextSearch fs = new FullTextSearch();
    ExpressionList<Column> matchedColumns;
    jj_consume_token(K_MATCH);
    jj_consume_token(379);
    matchedColumns = ColumnList();
    jj_consume_token(380);
    jj_consume_token(K_AGAINST);
    jj_consume_token(379);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_CHAR_LITERAL:{
      againstValue = jj_consume_token(S_CHAR_LITERAL);
fs.setAgainstValue(new StringValue(againstValue.image));
      break;
      }
    case 391:{
      jdbcParameter = SimpleJdbcParameter();
fs.setAgainstValue(  jdbcParameter );
      break;
      }
    case 384:{
      jdbcNamedParameter = SimpleJdbcNamedParameter();
fs.setAgainstValue(  jdbcNamedParameter );
      break;
      }
    default:
      jj_la1[333] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 429:
    case 430:
    case 431:
    case 432:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 429:{
        searchModifier = jj_consume_token(429);
        break;
        }
      case 430:{
        searchModifier = jj_consume_token(430);
        break;
        }
      case 431:{
        searchModifier = jj_consume_token(431);
        break;
        }
      case 432:{
        searchModifier = jj_consume_token(432);
        break;
        }
      default:
        jj_la1[334] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
fs.setSearchModifier(searchModifier.image);
      break;
      }
    default:
      jj_la1[335] = jj_gen;
      ;
    }
    jj_consume_token(380);
fs.setMatchColumns(matchedColumns);
        return fs;
}

  final public Function Function() throws ParseException {/*@bgen(jjtree) Function */
    SimpleNode jjtn000 = new SimpleNode(JJTFUNCTION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Function retval = new Function();
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 433:{
        jj_consume_token(433);
        jj_consume_token(K_FN);
retval.setEscaped(true);
        InternalFunction(retval);
        jj_consume_token(420);
        break;
        }
      default:
        jj_la1[336] = jj_gen;
        if (jj_2_286(3)) {
          retval = SpecialStringFunctionWithNamedParameters();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ACTIVE:
          case K_ADD:
          case K_ADVANCE:
          case K_ADVISE:
          case K_AGAINST:
          case K_ALGORITHM:
          case K_ALL:
          case K_ALTER:
          case K_ANALYZE:
          case K_ANY:
          case K_APPLY:
          case K_ARCHIVE:
          case K_ARRAY_LITERAL:
          case K_AT:
          case K_ASC:
          case K_AUTHORIZATION:
          case K_AUTO:
          case K_BEGIN:
          case K_BERNOULLI:
          case K_BINARY:
          case K_BIT:
          case K_BLOCK:
          case K_BROWSE:
          case K_BY:
          case K_BYTES:
          case K_CACHE:
          case K_BUFFERS:
          case K_BYTE:
          case K_CALL:
          case K_CASCADE:
          case K_CASE:
          case K_CASEWHEN:
          case K_CAST:
          case K_CHARACTER:
          case K_CHANGE:
          case K_CHANGES:
          case K_CHECKPOINT:
          case K_CHAR:
          case K_CLOSE:
          case K_COLLATE:
          case K_COLUMN:
          case K_COLUMNS:
          case K_COMMIT:
          case K_COMMENT:
          case K_CONFLICT:
          case K_CONNECT:
          case K_CONVERT:
          case K_COSTS:
          case K_CREATE:
          case K_CYCLE:
          case K_DATABASE:
          case K_DECLARE:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_DEFAULT:
          case K_DEFERRABLE:
          case K_DELAYED:
          case K_DELETE:
          case K_DESC:
          case K_DESCRIBE:
          case K_DISABLE:
          case K_DISCONNECT:
          case K_DIV:
          case K_DDL:
          case K_DML:
          case K_DO:
          case K_DOMAIN:
          case K_DOUBLE:
          case K_DROP:
          case K_DUMP:
          case K_DUPLICATE:
          case K_ELEMENTS:
          case K_EMIT:
          case K_ENABLE:
          case K_END:
          case K_ESCAPE:
          case K_EXCLUDE:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_EXPLICIT:
          case K_EXTENDED:
          case K_EXTRACT:
          case K_ISOLATION:
          case K_FILTER:
          case K_FIRST:
          case K_FALSE:
          case K_FLUSH:
          case K_FOLLOWING:
          case K_FORMAT:
          case K_FULLTEXT:
          case K_FUNCTION:
          case K_GLOBAL:
          case K_GRANT:
          case K_GROUP:
          case K_GROUPING:
          case K_GUARD:
          case K_HISTORY:
          case K_HOPPING:
          case K_IF:
          case K_IIF:
          case K_IGNORE:
          case K_IN:
          case K_INCLUDE:
          case K_INCREMENT:
          case K_INDEX:
          case K_INSERT:
          case K_INTERLEAVE:
          case K_INTERPRET:
          case K_INTERVAL:
          case K_ISNULL:
          case K_JSON:
          case K_KEEP:
          case K_KEY:
          case K_KEYS:
          case K_FN:
          case K_LAST:
          case K_LEADING:
          case K_LEFT:
          case K_LIMIT:
          case K_LOCAL:
          case K_LOCKED:
          case K_LINK:
          case K_LOG:
          case K_MATCH:
          case K_MATCHED:
          case K_MATERIALIZED:
          case K_MAXVALUE:
          case K_MEMBER:
          case K_MERGE:
          case K_MINVALUE:
          case K_MODIFY:
          case K_MOVEMENT:
          case K_NEXT:
          case K_NO:
          case K_NOCACHE:
          case K_NOKEEP:
          case K_NOLOCK:
          case K_NOMAXVALUE:
          case K_NOMINVALUE:
          case K_NOORDER:
          case K_NOTHING:
          case K_NOTNULL:
          case K_NOVALIDATE:
          case K_NULLS:
          case K_NOWAIT:
          case K_OF:
          case K_OFF:
          case K_OFFSET:
          case K_ON:
          case K_OPEN:
          case K_ORDER:
          case K_OVER:
          case K_OVERLAPS:
          case K_OPTIMIZE:
          case K_PARALLEL:
          case K_PARENT:
          case K_PARTITION:
          case K_PATH:
          case K_PERCENT:
          case K_PLACING:
          case K_PRECEDING:
          case K_PRECISION:
          case K_PRIMARY:
          case K_PRIOR:
          case K_PROCEDURE:
          case K_PUBLIC:
          case K_PURGE:
          case K_QUALIFY:
          case K_QUERY:
          case K_QUICK:
          case K_QUIESCE:
          case K_RANGE:
          case K_RAW:
          case K_READ:
          case K_RECYCLEBIN:
          case K_REFERENCES:
          case K_REFRESH:
          case K_RLIKE:
          case K_REGISTER:
          case K_RENAME:
          case K_REPEATABLE:
          case K_REPLACE:
          case K_RESET:
          case K_RESTART:
          case K_RESUMABLE:
          case K_RESUME:
          case K_RESTRICT:
          case K_RESTRICTED:
          case K_RIGHT:
          case K_ROLLBACK:
          case K_ROOT:
          case K_ROW:
          case K_ROWS:
          case K_SAVEPOINT:
          case K_SCHEMA:
          case K_SEED:
          case K_SEQUENCE:
          case K_SEPARATOR:
          case K_SESSION:
          case K_SET:
          case K_SETS:
          case K_SHOW:
          case K_SHUTDOWN:
          case K_SIBLINGS:
          case K_SIMILAR:
          case K_SIZE:
          case K_SKIP:
          case K_SOME:
          case K_START:
          case K_STORED:
          case K_STRING:
          case K_SUSPEND:
          case K_SWITCH:
          case K_SYNONYM:
          case K_SYSTEM:
          case K_TABLE:
          case K_TABLES:
          case K_TABLESPACE:
          case K_TRIGGER:
          case K_THEN:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIME_KEY_EXPR:
          case K_TIMEOUT:
          case K_TO:
          case K_TOP:
          case K_TRUNCATE:
          case K_TRUE:
          case K_TUMBLING:
          case K_TYPE:
          case K_UNLOGGED:
          case K_UPDATE:
          case K_UPSERT:
          case K_UNQIESCE:
          case K_USER:
          case K_SIGNED:
          case K_STRING_FUNCTION_NAME:
          case K_UNSIGNED:
          case K_VALIDATE:
          case K_VALUE:
          case K_VALUES:
          case K_VERBOSE:
          case K_VIEW:
          case K_WAIT:
          case K_WITHIN:
          case K_WITHOUT:
          case K_WORK:
          case K_XML:
          case K_XMLAGG:
          case K_XMLDATA:
          case K_XMLSCHEMA:
          case K_XMLTEXT:
          case K_XSINIL:
          case K_YAML:
          case K_YES:
          case K_ZONE:
          case S_IDENTIFIER:
          case S_QUOTED_IDENTIFIER:
          case 385:
          case 386:
          case 387:
          case 388:
          case 389:{
            InternalFunction(retval);
            break;
            }
          default:
            jj_la1[337] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(retval,jjtn000);
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Function SpecialStringFunctionWithNamedParameters() throws ParseException {Token funcName;
    NamedExpressionList namedExpressionList = null;
    ExpressionList expressionList = null;
    List<OrderByElement> orderByList;
    funcName = jj_consume_token(K_STRING_FUNCTION_NAME);
    jj_consume_token(379);
    if (jj_2_287(2147483647) && (getAsBoolean(Feature.allowComplexParsing))) {
      namedExpressionList = NamedExpressionListExprFirst();
    } else if (jj_2_288(1)) {
      expressionList = ExpressionList();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(380);
return new Function()
            .withName(funcName.image)
            .withNamedParameters(namedExpressionList)
            .withParameters(expressionList);
}

  final public Function InternalFunction(Function retval) throws ParseException {List<String> funcName;
    Expression allColumnsExpression = null;
    ExpressionList expressionList = null;
    KeepExpression keep = null;
    Select expr = null;
    Token tk1 = null;
    Token tk2 = null;
    Expression attributeExpression = null;
    Column attributeColumn = null;
    List<OrderByElement> orderByList;
    boolean ignoreNulls = false;
    funcName = RelObjectNameList();
    jj_consume_token(379);
    if (jj_2_292(2)) {
      if (jj_2_289(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DISTINCT:{
          jj_consume_token(K_DISTINCT);
retval.setDistinct(true);
          break;
          }
        case K_ALL:{
          jj_consume_token(K_ALL);
retval.setAllColumns(true);
          break;
          }
        case K_UNIQUE:{
          jj_consume_token(K_UNIQUE);
retval.setUnique(true);
          break;
          }
        default:
          jj_la1[338] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 390:{
        jj_consume_token(390);
expressionList = new ExpressionList(new AllColumns());
        break;
        }
      default:
        jj_la1[340] = jj_gen;
        if (jj_2_290(2147483647)) {
          allColumnsExpression = AllTableColumns();
expressionList = new ExpressionList(allColumnsExpression);
        } else if (jj_2_291(3)) {
          expressionList = ExpressionList();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ORDER:{
            orderByList = OrderByElements();
retval.setOrderByElements(orderByList);
            break;
            }
          default:
            jj_la1[339] = jj_gen;
            ;
          }
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_SELECT:
          case K_VALUE:
          case K_VALUES:
          case K_WITH:
          case 379:{
            expr = Select();
expressionList = new ExpressionList(expr);
            break;
            }
          default:
            jj_la1[341] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IGNORE:{
      jj_consume_token(K_IGNORE);
      jj_consume_token(K_NULLS);
retval.setIgnoreNulls(true);
      break;
      }
    default:
      jj_la1[342] = jj_gen;
      ;
    }
    jj_consume_token(380);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 383:{
      jj_consume_token(383);
      if (jj_2_293(2147483647)) {
        attributeExpression = Function();
retval.setAttribute(attributeExpression);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ACTIVE:
        case K_ADD:
        case K_ADVANCE:
        case K_ADVISE:
        case K_AGAINST:
        case K_ALGORITHM:
        case K_ALL:
        case K_ALTER:
        case K_ANALYZE:
        case K_ANY:
        case K_APPLY:
        case K_ARCHIVE:
        case K_ARRAY_LITERAL:
        case K_AT:
        case K_ASC:
        case K_AUTHORIZATION:
        case K_AUTO:
        case K_BEGIN:
        case K_BERNOULLI:
        case K_BINARY:
        case K_BIT:
        case K_BLOCK:
        case K_BROWSE:
        case K_BY:
        case K_BYTES:
        case K_CACHE:
        case K_BUFFERS:
        case K_BYTE:
        case K_CALL:
        case K_CASCADE:
        case K_CASE:
        case K_CASEWHEN:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHANGES:
        case K_CHECKPOINT:
        case K_CHAR:
        case K_CLOSE:
        case K_COLLATE:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CONFLICT:
        case K_CONNECT:
        case K_CONVERT:
        case K_COSTS:
        case K_CREATE:
        case K_CYCLE:
        case K_DATABASE:
        case K_DECLARE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DEFAULT:
        case K_DEFERRABLE:
        case K_DELAYED:
        case K_DELETE:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DISCONNECT:
        case K_DIV:
        case K_DDL:
        case K_DML:
        case K_DO:
        case K_DOMAIN:
        case K_DOUBLE:
        case K_DROP:
        case K_DUMP:
        case K_DUPLICATE:
        case K_ELEMENTS:
        case K_EMIT:
        case K_ENABLE:
        case K_END:
        case K_ESCAPE:
        case K_EXCLUDE:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_EXPLICIT:
        case K_EXTENDED:
        case K_EXTRACT:
        case K_ISOLATION:
        case K_FILTER:
        case K_FIRST:
        case K_FALSE:
        case K_FLUSH:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_FULLTEXT:
        case K_FUNCTION:
        case K_GLOBAL:
        case K_GRANT:
        case K_GROUP:
        case K_GROUPING:
        case K_GUARD:
        case K_HISTORY:
        case K_HOPPING:
        case K_IF:
        case K_IIF:
        case K_IGNORE:
        case K_IN:
        case K_INCLUDE:
        case K_INCREMENT:
        case K_INDEX:
        case K_INSERT:
        case K_INTERLEAVE:
        case K_INTERPRET:
        case K_INTERVAL:
        case K_ISNULL:
        case K_JSON:
        case K_KEEP:
        case K_KEY:
        case K_KEYS:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LEFT:
        case K_LIMIT:
        case K_LOCAL:
        case K_LOCKED:
        case K_LINK:
        case K_LOG:
        case K_MATCH:
        case K_MATCHED:
        case K_MATERIALIZED:
        case K_MAXVALUE:
        case K_MEMBER:
        case K_MERGE:
        case K_MINVALUE:
        case K_MODIFY:
        case K_MOVEMENT:
        case K_NEXT:
        case K_NO:
        case K_NOCACHE:
        case K_NOKEEP:
        case K_NOLOCK:
        case K_NOMAXVALUE:
        case K_NOMINVALUE:
        case K_NOORDER:
        case K_NOTHING:
        case K_NOTNULL:
        case K_NOVALIDATE:
        case K_NULLS:
        case K_NOWAIT:
        case K_OF:
        case K_OFF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OVERLAPS:
        case K_OPTIMIZE:
        case K_PARALLEL:
        case K_PARENT:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PLACING:
        case K_PRECEDING:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_PURGE:
        case K_QUALIFY:
        case K_QUERY:
        case K_QUICK:
        case K_QUIESCE:
        case K_RANGE:
        case K_RAW:
        case K_READ:
        case K_RECYCLEBIN:
        case K_REFERENCES:
        case K_REFRESH:
        case K_RLIKE:
        case K_REGISTER:
        case K_RENAME:
        case K_REPEATABLE:
        case K_REPLACE:
        case K_RESET:
        case K_RESTART:
        case K_RESUMABLE:
        case K_RESUME:
        case K_RESTRICT:
        case K_RESTRICTED:
        case K_RIGHT:
        case K_ROLLBACK:
        case K_ROOT:
        case K_ROW:
        case K_ROWS:
        case K_SAVEPOINT:
        case K_SCHEMA:
        case K_SEED:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SETS:
        case K_SHOW:
        case K_SHUTDOWN:
        case K_SIBLINGS:
        case K_SIMILAR:
        case K_SIZE:
        case K_SKIP:
        case K_SOME:
        case K_START:
        case K_STORED:
        case K_STRING:
        case K_SUSPEND:
        case K_SWITCH:
        case K_SYNONYM:
        case K_SYSTEM:
        case K_TABLE:
        case K_TABLES:
        case K_TABLESPACE:
        case K_TRIGGER:
        case K_THEN:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TUMBLING:
        case K_TYPE:
        case K_UNLOGGED:
        case K_UPDATE:
        case K_UPSERT:
        case K_UNQIESCE:
        case K_USER:
        case K_SIGNED:
        case K_STRING_FUNCTION_NAME:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VERBOSE:
        case K_VIEW:
        case K_WAIT:
        case K_WITHIN:
        case K_WITHOUT:
        case K_WORK:
        case K_XML:
        case K_XMLAGG:
        case K_XMLDATA:
        case K_XMLSCHEMA:
        case K_XMLTEXT:
        case K_XSINIL:
        case K_YAML:
        case K_YES:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:
        case 385:
        case 386:
        case 387:
        case 388:
        case 389:{
          attributeColumn = Column();
retval.setAttribute(attributeColumn);
          break;
          }
        default:
          jj_la1[343] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[344] = jj_gen;
      ;
    }
    if (jj_2_294(2)) {
      keep = KeepExpression();
    } else {
      ;
    }
retval.setParameters(expressionList);
        retval.setName(funcName);
        retval.setKeep(keep);
        return retval;
}

  final public XMLSerializeExpr XMLSerializeExpr() throws ParseException {XMLSerializeExpr result;
   Expression expression;
   List<OrderByElement> orderByElements = null;
   ColDataType dataType;
    jj_consume_token(K_XMLSERIALIZE);
    jj_consume_token(379);
    jj_consume_token(K_XMLAGG);
    jj_consume_token(379);
    jj_consume_token(K_XMLTEXT);
    jj_consume_token(379);
    expression = SimpleExpression();
    jj_consume_token(380);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
      break;
      }
    default:
      jj_la1[345] = jj_gen;
      ;
    }
    jj_consume_token(380);
    jj_consume_token(K_AS);
    dataType = ColDataType();
    jj_consume_token(380);
result = new XMLSerializeExpr();
        result.setExpression(expression);
        result.setOrderByElements(orderByElements);
        result.setDataType(dataType);
        return result;
}

  final public MySQLGroupConcat MySQLGroupConcat() throws ParseException {MySQLGroupConcat retval = new MySQLGroupConcat();
    ExpressionList expressionList = null;
    List<OrderByElement> orderByList = null;
    Token t;
    jj_consume_token(K_GROUP_CONCAT);
    jj_consume_token(379);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DISTINCT:{
      jj_consume_token(K_DISTINCT);
retval.setDistinct(true);
      break;
      }
    default:
      jj_la1[346] = jj_gen;
      ;
    }
    expressionList = ExpressionList();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByList = OrderByElements();
retval.setOrderByElements(orderByList);
      break;
      }
    default:
      jj_la1[347] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SEPARATOR:{
      jj_consume_token(K_SEPARATOR);
      t = jj_consume_token(S_CHAR_LITERAL);
retval.setSeparator(t.image);
      break;
      }
    default:
      jj_la1[348] = jj_gen;
      ;
    }
    jj_consume_token(380);
retval.setExpressionList(expressionList);
        return retval;
}

  final public TableFunction TableFunction() throws ParseException {Token prefix = null;
    Function function;
    TableFunction functionItem;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LATERAL:{
      prefix = jj_consume_token(K_LATERAL);
      break;
      }
    default:
      jj_la1[349] = jj_gen;
      ;
    }
    function = Function();
return  prefix!=null
            ? new TableFunction(prefix.image, function)
            : new TableFunction(function);
}

  final public List<Index.ColumnParams> ColumnNamesWithParamsList() throws ParseException {List<Index.ColumnParams> colNames = new ArrayList<Index.ColumnParams>();
    String columnName;
    List<String> parameter = null;
    jj_consume_token(379);
    columnName = RelObjectName();
parameter = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_ASC:
    case K_BINARY:
    case K_BY:
    case K_CASCADE:
    case K_CHARACTER:
    case K_CHECK:
    case K_COLLATE:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONSTRAINT:
    case K_DEFAULT:
    case K_DELETE:
    case K_DESC:
    case K_DROP:
    case K_EXCLUDE:
    case K_FALSE:
    case K_FOREIGN:
    case K_IN:
    case K_KEY:
    case K_NEXTVAL:
    case K_NOT:
    case K_NULL:
    case K_ON:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PRIMARY:
    case K_REFERENCES:
    case K_ROWS:
    case K_START:
    case K_STORED:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TRUE:
    case K_TYPE:
    case K_UNIQUE:
    case K_UPDATE:
    case K_USING:
    case K_UNSIGNED:
    case K_WHERE:
    case K_WITH:
    case S_DOUBLE:
    case S_LONG:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 379:
    case 381:
    case 393:
    case 405:
    case 423:{
      parameter = CreateParameter();
      break;
      }
    default:
      jj_la1[350] = jj_gen;
      ;
    }
colNames.add(new Index.ColumnParams(columnName,parameter));
    label_63:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[351] = jj_gen;
        break label_63;
      }
      jj_consume_token(K_COMMA);
      columnName = RelObjectName();
parameter = null;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_AS:
      case K_ASC:
      case K_BINARY:
      case K_BY:
      case K_CASCADE:
      case K_CHARACTER:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_DROP:
      case K_EXCLUDE:
      case K_FALSE:
      case K_FOREIGN:
      case K_IN:
      case K_KEY:
      case K_NEXTVAL:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_START:
      case K_STORED:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 379:
      case 381:
      case 393:
      case 405:
      case 423:{
        parameter = CreateParameter();
        break;
        }
      default:
        jj_la1[352] = jj_gen;
        ;
      }
colNames.add(new Index.ColumnParams(columnName,parameter));
    }
    jj_consume_token(380);
return colNames;
}

  final public Index Index() throws ParseException {List<String> name;
    name = RelObjectNameList();
return new Index().withName(name).withType("");
}

  final public CreateIndex CreateIndex() throws ParseException {CreateIndex createIndex = new CreateIndex();
    Table table = null;
    List<Index.ColumnParams> colNames;
    //Token columnName;
    Token using;
    Index index = null;
    //String name = null;
    List<String> parameter = new ArrayList<String>();
    List<String> tailParameters = new ArrayList<String>();
    List<String> name;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_ASC:
    case K_BINARY:
    case K_BY:
    case K_CASCADE:
    case K_CHARACTER:
    case K_CHECK:
    case K_COLLATE:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONSTRAINT:
    case K_DEFAULT:
    case K_DELETE:
    case K_DESC:
    case K_DROP:
    case K_EXCLUDE:
    case K_FALSE:
    case K_FOREIGN:
    case K_IN:
    case K_KEY:
    case K_NEXTVAL:
    case K_NOT:
    case K_NULL:
    case K_ON:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PRIMARY:
    case K_REFERENCES:
    case K_ROWS:
    case K_START:
    case K_STORED:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TRUE:
    case K_TYPE:
    case K_UNIQUE:
    case K_UPDATE:
    case K_USING:
    case K_UNSIGNED:
    case K_WHERE:
    case K_WITH:
    case S_DOUBLE:
    case S_LONG:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 379:
    case 381:
    case 393:
    case 405:
    case 423:{
      parameter = CreateParameter();
      break;
      }
    default:
      jj_la1[353] = jj_gen;
      ;
    }
    jj_consume_token(K_INDEX);
    index = Index();
index.setType(parameter.isEmpty()?null:parameter.get(0));
    jj_consume_token(K_ON);
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_USING:{
      jj_consume_token(K_USING);
      using = jj_consume_token(S_IDENTIFIER);
index.setUsing(using.image);
      break;
      }
    default:
      jj_la1[354] = jj_gen;
      ;
    }
    colNames = ColumnNamesWithParamsList();
    label_64:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_AS:
      case K_ASC:
      case K_BINARY:
      case K_BY:
      case K_CASCADE:
      case K_CHARACTER:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_DROP:
      case K_EXCLUDE:
      case K_FALSE:
      case K_FOREIGN:
      case K_IN:
      case K_KEY:
      case K_NEXTVAL:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_START:
      case K_STORED:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 379:
      case 381:
      case 393:
      case 405:
      case 423:{
        ;
        break;
        }
      default:
        jj_la1[355] = jj_gen;
        break label_64;
      }
      parameter = CreateParameter();
tailParameters.addAll(parameter);
    }
index.setColumns(colNames);
        createIndex.setIndex(index);
        createIndex.setTable(table);
        createIndex.setTailParameters(tailParameters);
        return createIndex;
}

  final public ColumnDefinition ColumnDefinition() throws ParseException {ColumnDefinition coldef;
    String columnName;
    ColDataType colDataType;
    List<String> columnSpecs = new ArrayList<String>();
    List<String> parameter;
    columnName = RelObjectName();
    colDataType = ColDataType();
    label_65:
    while (true) {
      if (jj_2_295(2)) {
        ;
      } else {
        break label_65;
      }
      parameter = CreateParameter();
columnSpecs.addAll(parameter);
    }
coldef = new ColumnDefinition();
        coldef.setColumnName(columnName);
        coldef.setColDataType(colDataType);
        if (columnSpecs.size() > 0)
            coldef.setColumnSpecs(columnSpecs);
        return coldef;
}

  final public CreateSchema CreateSchema() throws ParseException {Token tk = null;
    CreateTable table = null;
    CreateView view = null;
    CreateSchema schema = new CreateSchema();
    //schema.setSchemaName(System.getProperty("user.name"));
    //schema.setAuthorization(System.getProperty("user.name"));
    List<String> schemaPath = null;
    List<Statement> statements = new ArrayList<Statement>();
    jj_consume_token(K_SCHEMA);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[356] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
schema.setSchemaName(tk.image);
      break;
      }
    default:
      jj_la1[357] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AUTHORIZATION:{
      jj_consume_token(K_AUTHORIZATION);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[358] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
schema.setAuthorization(tk.image);
      break;
      }
    default:
      jj_la1[359] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PATH:{
      schemaPath = PathSpecification();
schema.setSchemaPath(schemaPath);
      break;
      }
    default:
      jj_la1[360] = jj_gen;
      ;
    }
    label_66:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CREATE:
      case K_FORCE:
      case K_MATERIALIZED:
      case K_NO:
      case K_TEMP:
      case K_TEMPORARY:
      case K_VIEW:{
        ;
        break;
        }
      default:
        jj_la1[361] = jj_gen;
        break label_66;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CREATE:{
        jj_consume_token(K_CREATE);
        table = CreateTable(false);
table.getTable().setSchemaName(schema.getSchemaName());
            schema.addStatement(table);
        break;
        }
      case K_FORCE:
      case K_MATERIALIZED:
      case K_NO:
      case K_TEMP:
      case K_TEMPORARY:
      case K_VIEW:{
        view = CreateView(false);
view.getView().setSchemaName(schema.getSchemaName());
            schema.addStatement(view);
        break;
        }
      default:
        jj_la1[362] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return schema;
}

  final public List<String> PathSpecification() throws ParseException {Token tk;
    List<String> pathList = new ArrayList<String>();
    jj_consume_token(K_PATH);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      tk = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    default:
      jj_la1[363] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
pathList.add(tk.image);
    label_67:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[364] = jj_gen;
        break label_67;
      }
      jj_consume_token(K_COMMA);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[365] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
pathList.add(tk.image);
    }
return pathList;
}

  final public CreateTable CreateTable(boolean isUsingOrReplace) throws ParseException {CreateTable createTable = new CreateTable();
    Table table = null;
    List<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();
    List<String> columnSpecs = null;
    List<String> tableOptions = new ArrayList<String>();
    List<String> createOptions = new ArrayList<String>();
    String columnName;
    Token tk = null;
    Token tk2 = null;
    Token tk3 = null;
    String sk3 = null;
    ColDataType colDataType = null;
    String stringList = null;
    ColumnDefinition coldef = null;
    List<Index> indexes = new ArrayList<Index>();
    List<Index.ColumnParams> colNames = null;
    List<String> colNames2 = null;
    Index index = null;
    ForeignKeyIndex fkIndex = null;
    List<String> parameter = new ArrayList<String>();
    List<String> idxSpec = new ArrayList<String>();
    Table fkTable = null;
    SpannerInterleaveIn interleaveIn = null;
    Select select = null;
    Table likeTable = null;
    CheckConstraint checkCs = null;
    ExcludeConstraint excludeC = null;
    RowMovement rowMovement = null;
    ReferentialAction.Action action = null;
    String tableColumn = null;
    List<String> columns = new ArrayList<String>();
createTable.setOrReplace(isUsingOrReplace);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_UNLOGGED:{
      jj_consume_token(K_UNLOGGED);
createTable.setUnlogged(true);
      break;
      }
    default:
      jj_la1[366] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_GLOBAL:{
      tk = jj_consume_token(K_GLOBAL);
createOptions.add(tk.image);
      break;
      }
    default:
      jj_la1[367] = jj_gen;
      ;
    }
    label_68:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_AS:
      case K_ASC:
      case K_BINARY:
      case K_BY:
      case K_CASCADE:
      case K_CHARACTER:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_DROP:
      case K_EXCLUDE:
      case K_FALSE:
      case K_FOREIGN:
      case K_IN:
      case K_KEY:
      case K_NEXTVAL:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_START:
      case K_STORED:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 379:
      case 381:
      case 393:
      case 405:
      case 423:{
        ;
        break;
        }
      default:
        jj_la1[368] = jj_gen;
        break label_68;
      }
      parameter = CreateParameter();
createOptions.addAll(parameter);
    }
    jj_consume_token(K_TABLE);
    if (jj_2_296(2)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_NOT);
      jj_consume_token(K_EXISTS);
createTable.setIfNotExists(true);
    } else {
      ;
    }
    table = Table();
    if (jj_2_306(2)) {
      if (jj_2_305(3)) {
        jj_consume_token(379);
        tableColumn = RelObjectName();
columns.add(tableColumn);
        label_69:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[369] = jj_gen;
            break label_69;
          }
          jj_consume_token(K_COMMA);
          tableColumn = RelObjectName();
columns.add(tableColumn);
        }
        jj_consume_token(380);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 379:{
          jj_consume_token(379);
          coldef = ColumnDefinition();
columnDefinitions.add(coldef);
          label_70:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[370] = jj_gen;
              break label_70;
            }
            jj_consume_token(K_COMMA);
            if (jj_2_299(3)) {
              tk = jj_consume_token(K_INDEX);
              sk3 = RelObjectName();
              /* colNames=ColumnsNamesList() */
                                          colNames = ColumnNamesWithParamsList();
idxSpec.clear();
              label_71:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_ARRAY_LITERAL:
                case K_AS:
                case K_ASC:
                case K_BINARY:
                case K_BY:
                case K_CASCADE:
                case K_CHARACTER:
                case K_CHECK:
                case K_COLLATE:
                case K_COMMIT:
                case K_COMMENT:
                case K_CONSTRAINT:
                case K_DEFAULT:
                case K_DELETE:
                case K_DESC:
                case K_DROP:
                case K_EXCLUDE:
                case K_FALSE:
                case K_FOREIGN:
                case K_IN:
                case K_KEY:
                case K_NEXTVAL:
                case K_NOT:
                case K_NULL:
                case K_ON:
                case K_PARALLEL:
                case K_PARTITION:
                case K_PRIMARY:
                case K_REFERENCES:
                case K_ROWS:
                case K_START:
                case K_STORED:
                case K_TABLESPACE:
                case K_TEMP:
                case K_TEMPORARY:
                case K_TIME_KEY_EXPR:
                case K_TRUE:
                case K_TYPE:
                case K_UNIQUE:
                case K_UPDATE:
                case K_USING:
                case K_UNSIGNED:
                case K_WHERE:
                case K_WITH:
                case S_DOUBLE:
                case S_LONG:
                case S_IDENTIFIER:
                case S_CHAR_LITERAL:
                case S_QUOTED_IDENTIFIER:
                case 379:
                case 381:
                case 393:
                case 405:
                case 423:{
                  ;
                  break;
                  }
                default:
                  jj_la1[371] = jj_gen;
                  break label_71;
                }
                parameter = CreateParameter();
idxSpec.addAll(parameter);
              }
index = new Index().withType(tk.image).withName(sk3).withColumns(colNames).withIndexSpec(new ArrayList<String>(idxSpec));
                                indexes.add(index);
            } else if (jj_2_300(3)) {
index = new NamedConstraint();
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CONSTRAINT:{
                jj_consume_token(K_CONSTRAINT);
                sk3 = RelObjectName();
index.setName(sk3);
                break;
                }
              default:
                jj_la1[372] = jj_gen;
                ;
              }
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_PRIMARY:{
                tk = jj_consume_token(K_PRIMARY);
                tk2 = jj_consume_token(K_KEY);
index.setType(tk.image + " " + tk2.image);
                break;
                }
              case K_UNIQUE:{
                tk = jj_consume_token(K_UNIQUE);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_KEY:{
                  tk2 = jj_consume_token(K_KEY);
                  break;
                  }
                default:
                  jj_la1[373] = jj_gen;
                  ;
                }
index.setType(tk.image + (tk2!=null?" " + tk2.image:""));
                break;
                }
              default:
                jj_la1[374] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              /* colNames=ColumnsNamesList() */
                                          colNames = ColumnNamesWithParamsList();
idxSpec.clear();
              label_72:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_ARRAY_LITERAL:
                case K_AS:
                case K_ASC:
                case K_BINARY:
                case K_BY:
                case K_CASCADE:
                case K_CHARACTER:
                case K_CHECK:
                case K_COLLATE:
                case K_COMMIT:
                case K_COMMENT:
                case K_CONSTRAINT:
                case K_DEFAULT:
                case K_DELETE:
                case K_DESC:
                case K_DROP:
                case K_EXCLUDE:
                case K_FALSE:
                case K_FOREIGN:
                case K_IN:
                case K_KEY:
                case K_NEXTVAL:
                case K_NOT:
                case K_NULL:
                case K_ON:
                case K_PARALLEL:
                case K_PARTITION:
                case K_PRIMARY:
                case K_REFERENCES:
                case K_ROWS:
                case K_START:
                case K_STORED:
                case K_TABLESPACE:
                case K_TEMP:
                case K_TEMPORARY:
                case K_TIME_KEY_EXPR:
                case K_TRUE:
                case K_TYPE:
                case K_UNIQUE:
                case K_UPDATE:
                case K_USING:
                case K_UNSIGNED:
                case K_WHERE:
                case K_WITH:
                case S_DOUBLE:
                case S_LONG:
                case S_IDENTIFIER:
                case S_CHAR_LITERAL:
                case S_QUOTED_IDENTIFIER:
                case 379:
                case 381:
                case 393:
                case 405:
                case 423:{
                  ;
                  break;
                  }
                default:
                  jj_la1[375] = jj_gen;
                  break label_72;
                }
                parameter = CreateParameter();
idxSpec.addAll(parameter);
              }
index.withColumns(colNames).withIndexSpec(new ArrayList<String>(idxSpec));
                                indexes.add(index);
tk2=null;
            } else if (jj_2_301(3)) {
tk=null;
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_UNIQUE:{
                tk = jj_consume_token(K_UNIQUE);
                break;
                }
              default:
                jj_la1[376] = jj_gen;
                ;
              }
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_FULLTEXT:{
                tk3 = jj_consume_token(K_FULLTEXT);
                break;
                }
              default:
                jj_la1[377] = jj_gen;
                ;
              }
              tk2 = jj_consume_token(K_KEY);
              sk3 = RelObjectName();
              /* colNames=ColumnsNamesList() */
                                          colNames = ColumnNamesWithParamsList();
idxSpec.clear();
              label_73:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_ARRAY_LITERAL:
                case K_AS:
                case K_ASC:
                case K_BINARY:
                case K_BY:
                case K_CASCADE:
                case K_CHARACTER:
                case K_CHECK:
                case K_COLLATE:
                case K_COMMIT:
                case K_COMMENT:
                case K_CONSTRAINT:
                case K_DEFAULT:
                case K_DELETE:
                case K_DESC:
                case K_DROP:
                case K_EXCLUDE:
                case K_FALSE:
                case K_FOREIGN:
                case K_IN:
                case K_KEY:
                case K_NEXTVAL:
                case K_NOT:
                case K_NULL:
                case K_ON:
                case K_PARALLEL:
                case K_PARTITION:
                case K_PRIMARY:
                case K_REFERENCES:
                case K_ROWS:
                case K_START:
                case K_STORED:
                case K_TABLESPACE:
                case K_TEMP:
                case K_TEMPORARY:
                case K_TIME_KEY_EXPR:
                case K_TRUE:
                case K_TYPE:
                case K_UNIQUE:
                case K_UPDATE:
                case K_USING:
                case K_UNSIGNED:
                case K_WHERE:
                case K_WITH:
                case S_DOUBLE:
                case S_LONG:
                case S_IDENTIFIER:
                case S_CHAR_LITERAL:
                case S_QUOTED_IDENTIFIER:
                case 379:
                case 381:
                case 393:
                case 405:
                case 423:{
                  ;
                  break;
                  }
                default:
                  jj_la1[378] = jj_gen;
                  break label_73;
                }
                parameter = CreateParameter();
idxSpec.addAll(parameter);
              }
index = new Index()
                                .withType((tk!=null?tk.image + " ":"") + (tk3!=null?tk3.image + " ":"") + tk2.image)
                                .withName(sk3)
                                .withColumns(colNames)
                                .withIndexSpec(new ArrayList<String>(idxSpec));
                                indexes.add(index);
            } else if (jj_2_302(3)) {
fkIndex = new ForeignKeyIndex();
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CONSTRAINT:{
                jj_consume_token(K_CONSTRAINT);
                sk3 = RelObjectName();
fkIndex.setName(sk3);
                break;
                }
              default:
                jj_la1[379] = jj_gen;
                ;
              }
              tk = jj_consume_token(K_FOREIGN);
              tk2 = jj_consume_token(K_KEY);
              /* colNames=ColumnsNamesList() */
                                          colNames = ColumnNamesWithParamsList();
fkIndex.withType(tk.image + " " + tk2.image).withColumns(colNames);
              jj_consume_token(K_REFERENCES);
              fkTable = Table();
              colNames2 = ColumnsNamesList();
fkIndex.setTable(fkTable);
                                fkIndex.setReferencedColumnNames(colNames2);
                                indexes.add(fkIndex);
              if (jj_2_297(2)) {
                jj_consume_token(K_ON);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_DELETE:{
                  tk = jj_consume_token(K_DELETE);
                  break;
                  }
                case K_UPDATE:{
                  tk = jj_consume_token(K_UPDATE);
                  break;
                  }
                default:
                  jj_la1[380] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
                action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.from(tk.image), action);
              } else {
                ;
              }
              if (jj_2_298(2)) {
                jj_consume_token(K_ON);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_DELETE:{
                  tk = jj_consume_token(K_DELETE);
                  break;
                  }
                case K_UPDATE:{
                  tk = jj_consume_token(K_UPDATE);
                  break;
                  }
                default:
                  jj_la1[381] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
                action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.from(tk.image), action);
              } else {
                ;
              }
            } else if (jj_2_303(3)) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CONSTRAINT:{
                jj_consume_token(K_CONSTRAINT);
                sk3 = RelObjectName();
                break;
                }
              default:
                jj_la1[382] = jj_gen;
                ;
              }
Expression exp = null;
              jj_consume_token(K_CHECK);
              label_74:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case 379:{
                  ;
                  break;
                  }
                default:
                  jj_la1[383] = jj_gen;
                  break label_74;
                }
                jj_consume_token(379);
                exp = Expression();
                jj_consume_token(380);
              }
checkCs = new CheckConstraint().withName(sk3).withExpression(exp);
                           indexes.add(checkCs);
            } else if (jj_2_304(2)) {
              tk = jj_consume_token(K_EXCLUDE);
excludeC = new ExcludeConstraint(); Expression exp = null;
              tk2 = jj_consume_token(K_WHERE);
              label_75:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case 379:{
                  ;
                  break;
                  }
                default:
                  jj_la1[384] = jj_gen;
                  break label_75;
                }
                jj_consume_token(379);
                exp = Expression();
                jj_consume_token(380);
              }
excludeC.setExpression(exp);
indexes.add(excludeC);
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_ACTION:
              case K_ACTIVE:
              case K_ADD:
              case K_ADVANCE:
              case K_ADVISE:
              case K_AGAINST:
              case K_ALGORITHM:
              case K_ALTER:
              case K_ANALYZE:
              case K_APPLY:
              case K_ARCHIVE:
              case K_ARRAY_LITERAL:
              case K_AT:
              case K_ASC:
              case K_AUTHORIZATION:
              case K_AUTO:
              case K_BEGIN:
              case K_BERNOULLI:
              case K_BINARY:
              case K_BIT:
              case K_BLOCK:
              case K_BROWSE:
              case K_BY:
              case K_BYTES:
              case K_CACHE:
              case K_BUFFERS:
              case K_BYTE:
              case K_CALL:
              case K_CASCADE:
              case K_CASE:
              case K_CAST:
              case K_CHARACTER:
              case K_CHANGE:
              case K_CHANGES:
              case K_CHECKPOINT:
              case K_CHAR:
              case K_CLOSE:
              case K_COLLATE:
              case K_COLUMN:
              case K_COLUMNS:
              case K_COMMIT:
              case K_COMMENT:
              case K_CONFLICT:
              case K_CONNECT:
              case K_CONVERT:
              case K_COSTS:
              case K_CREATE:
              case K_CYCLE:
              case K_DATABASE:
              case K_DECLARE:
              case K_DATETIMELITERAL:
              case K_DATE_LITERAL:
              case K_DEFAULT:
              case K_DEFERRABLE:
              case K_DELAYED:
              case K_DELETE:
              case K_DESC:
              case K_DESCRIBE:
              case K_DISABLE:
              case K_DISCONNECT:
              case K_DIV:
              case K_DDL:
              case K_DML:
              case K_DO:
              case K_DOMAIN:
              case K_DROP:
              case K_DUMP:
              case K_DUPLICATE:
              case K_ELEMENTS:
              case K_EMIT:
              case K_ENABLE:
              case K_END:
              case K_ESCAPE:
              case K_EXCLUDE:
              case K_EXEC:
              case K_EXECUTE:
              case K_EXPLAIN:
              case K_EXPLICIT:
              case K_EXTENDED:
              case K_EXTRACT:
              case K_ISOLATION:
              case K_FILTER:
              case K_FIRST:
              case K_FALSE:
              case K_FLUSH:
              case K_FOLLOWING:
              case K_FORMAT:
              case K_FULLTEXT:
              case K_FUNCTION:
              case K_GLOBAL:
              case K_GRANT:
              case K_GROUP:
              case K_GUARD:
              case K_HISTORY:
              case K_HOPPING:
              case K_IGNORE:
              case K_INCLUDE:
              case K_INCREMENT:
              case K_INDEX:
              case K_INSERT:
              case K_INTERLEAVE:
              case K_INTERPRET:
              case K_INTERVAL:
              case K_ISNULL:
              case K_JSON:
              case K_KEEP:
              case K_KEY:
              case K_KEYS:
              case K_FN:
              case K_LAST:
              case K_LEADING:
              case K_LOCAL:
              case K_LOCKED:
              case K_LINK:
              case K_LOG:
              case K_MATCH:
              case K_MATCHED:
              case K_MATERIALIZED:
              case K_MAXVALUE:
              case K_MEMBER:
              case K_MERGE:
              case K_MINVALUE:
              case K_MODIFY:
              case K_MOVEMENT:
              case K_NEXT:
              case K_NO:
              case K_NOCACHE:
              case K_NOKEEP:
              case K_NOLOCK:
              case K_NOMAXVALUE:
              case K_NOMINVALUE:
              case K_NOORDER:
              case K_NOTHING:
              case K_NOTNULL:
              case K_NOVALIDATE:
              case K_NULLS:
              case K_NOWAIT:
              case K_OF:
              case K_OFF:
              case K_ON:
              case K_OPEN:
              case K_OVER:
              case K_OVERLAPS:
              case K_PARALLEL:
              case K_PARENT:
              case K_PARTITION:
              case K_PATH:
              case K_PERCENT:
              case K_PLACING:
              case K_PRECEDING:
              case K_PRECISION:
              case K_PRIMARY:
              case K_PRIOR:
              case K_PURGE:
              case K_QUALIFY:
              case K_QUERY:
              case K_QUICK:
              case K_QUIESCE:
              case K_RANGE:
              case K_RAW:
              case K_READ:
              case K_RECYCLEBIN:
              case K_REFERENCES:
              case K_REFRESH:
              case K_RLIKE:
              case K_REGISTER:
              case K_RENAME:
              case K_REPEATABLE:
              case K_REPLACE:
              case K_RESET:
              case K_RESTART:
              case K_RESUMABLE:
              case K_RESUME:
              case K_RESTRICT:
              case K_RESTRICTED:
              case K_ROLLBACK:
              case K_ROOT:
              case K_ROW:
              case K_ROWS:
              case K_SAVEPOINT:
              case K_SCHEMA:
              case K_SEED:
              case K_SEQUENCE:
              case K_SEPARATOR:
              case K_SESSION:
              case K_SETS:
              case K_SHOW:
              case K_SHUTDOWN:
              case K_SIBLINGS:
              case K_SIMILAR:
              case K_SIZE:
              case K_SKIP:
              case K_START:
              case K_STORED:
              case K_STRING:
              case K_SUSPEND:
              case K_SWITCH:
              case K_SYNONYM:
              case K_SYSTEM:
              case K_TABLE:
              case K_TABLES:
              case K_TABLESPACE:
              case K_TRIGGER:
              case K_THEN:
              case K_TEMP:
              case K_TEMPORARY:
              case K_TIME_KEY_EXPR:
              case K_TIMEOUT:
              case K_TO:
              case K_TOP:
              case K_TRUNCATE:
              case K_TRUE:
              case K_TUMBLING:
              case K_TYPE:
              case K_UNLOGGED:
              case K_UPDATE:
              case K_UPSERT:
              case K_UNQIESCE:
              case K_USER:
              case K_SIGNED:
              case K_STRING_FUNCTION_NAME:
              case K_UNSIGNED:
              case K_VALIDATE:
              case K_VALUE:
              case K_VALUES:
              case K_VERBOSE:
              case K_VIEW:
              case K_WAIT:
              case K_WITHIN:
              case K_WITHOUT:
              case K_WORK:
              case K_XML:
              case K_XMLAGG:
              case K_XMLDATA:
              case K_XMLSCHEMA:
              case K_XMLTEXT:
              case K_XSINIL:
              case K_YAML:
              case K_YES:
              case K_ZONE:
              case S_IDENTIFIER:
              case S_QUOTED_IDENTIFIER:
              case 385:
              case 386:
              case 387:
              case 388:
              case 389:{
                coldef = ColumnDefinition();
columnDefinitions.add(coldef);
                break;
                }
              default:
                jj_la1[385] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
          jj_consume_token(380);
          break;
          }
        default:
          jj_la1[386] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else {
      ;
    }
    label_76:
    while (true) {
      if (jj_2_307(2) && (getToken(1).kind != K_AS)) {
        ;
      } else {
        break label_76;
      }
      parameter = CreateParameter();
tableOptions.addAll(parameter);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DISABLE:
    case K_ENABLE:{
      rowMovement = RowMovement();
createTable.setRowMovement(rowMovement);
      break;
      }
    default:
      jj_la1[387] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:{
      jj_consume_token(K_AS);
      select = Select();
createTable.setSelect(select, false);
      break;
      }
    default:
      jj_la1[388] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIKE:{
      jj_consume_token(K_LIKE);
      if (jj_2_308(2147483647)) {
        jj_consume_token(379);
        likeTable = Table();
createTable.setLikeTable(likeTable, true);
        jj_consume_token(380);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ACTIVE:
        case K_ADD:
        case K_ADVANCE:
        case K_ADVISE:
        case K_AGAINST:
        case K_ALGORITHM:
        case K_ALL:
        case K_ALTER:
        case K_ANALYZE:
        case K_ANY:
        case K_APPLY:
        case K_ARCHIVE:
        case K_ARRAY_LITERAL:
        case K_AT:
        case K_ASC:
        case K_AUTHORIZATION:
        case K_AUTO:
        case K_BEGIN:
        case K_BERNOULLI:
        case K_BINARY:
        case K_BIT:
        case K_BLOCK:
        case K_BROWSE:
        case K_BY:
        case K_BYTES:
        case K_CACHE:
        case K_BUFFERS:
        case K_BYTE:
        case K_CALL:
        case K_CASCADE:
        case K_CASE:
        case K_CASEWHEN:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHANGES:
        case K_CHECKPOINT:
        case K_CHAR:
        case K_CLOSE:
        case K_COLLATE:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CONFLICT:
        case K_CONNECT:
        case K_CONVERT:
        case K_COSTS:
        case K_CREATE:
        case K_CYCLE:
        case K_DATABASE:
        case K_DECLARE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DEFAULT:
        case K_DEFERRABLE:
        case K_DELAYED:
        case K_DELETE:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DISCONNECT:
        case K_DIV:
        case K_DDL:
        case K_DML:
        case K_DO:
        case K_DOMAIN:
        case K_DOUBLE:
        case K_DROP:
        case K_DUMP:
        case K_DUPLICATE:
        case K_ELEMENTS:
        case K_EMIT:
        case K_ENABLE:
        case K_END:
        case K_ESCAPE:
        case K_EXCLUDE:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_EXPLICIT:
        case K_EXTENDED:
        case K_EXTRACT:
        case K_ISOLATION:
        case K_FILTER:
        case K_FIRST:
        case K_FALSE:
        case K_FLUSH:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_FULLTEXT:
        case K_FUNCTION:
        case K_GLOBAL:
        case K_GRANT:
        case K_GROUP:
        case K_GROUPING:
        case K_GUARD:
        case K_HISTORY:
        case K_HOPPING:
        case K_IF:
        case K_IIF:
        case K_IGNORE:
        case K_IN:
        case K_INCLUDE:
        case K_INCREMENT:
        case K_INDEX:
        case K_INSERT:
        case K_INTERLEAVE:
        case K_INTERPRET:
        case K_INTERVAL:
        case K_ISNULL:
        case K_JSON:
        case K_KEEP:
        case K_KEY:
        case K_KEYS:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LEFT:
        case K_LIMIT:
        case K_LOCAL:
        case K_LOCKED:
        case K_LINK:
        case K_LOG:
        case K_MATCH:
        case K_MATCHED:
        case K_MATERIALIZED:
        case K_MAXVALUE:
        case K_MEMBER:
        case K_MERGE:
        case K_MINVALUE:
        case K_MODIFY:
        case K_MOVEMENT:
        case K_NEXT:
        case K_NO:
        case K_NOCACHE:
        case K_NOKEEP:
        case K_NOLOCK:
        case K_NOMAXVALUE:
        case K_NOMINVALUE:
        case K_NOORDER:
        case K_NOTHING:
        case K_NOTNULL:
        case K_NOVALIDATE:
        case K_NULLS:
        case K_NOWAIT:
        case K_OF:
        case K_OFF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OVERLAPS:
        case K_OPTIMIZE:
        case K_PARALLEL:
        case K_PARENT:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PLACING:
        case K_PRECEDING:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_PURGE:
        case K_QUALIFY:
        case K_QUERY:
        case K_QUICK:
        case K_QUIESCE:
        case K_RANGE:
        case K_RAW:
        case K_READ:
        case K_RECYCLEBIN:
        case K_REFERENCES:
        case K_REFRESH:
        case K_RLIKE:
        case K_REGISTER:
        case K_RENAME:
        case K_REPEATABLE:
        case K_REPLACE:
        case K_RESET:
        case K_RESTART:
        case K_RESUMABLE:
        case K_RESUME:
        case K_RESTRICT:
        case K_RESTRICTED:
        case K_RIGHT:
        case K_ROLLBACK:
        case K_ROOT:
        case K_ROW:
        case K_ROWS:
        case K_SAVEPOINT:
        case K_SCHEMA:
        case K_SEED:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SETS:
        case K_SHOW:
        case K_SHUTDOWN:
        case K_SIBLINGS:
        case K_SIMILAR:
        case K_SIZE:
        case K_SKIP:
        case K_SOME:
        case K_START:
        case K_STORED:
        case K_STRING:
        case K_SUSPEND:
        case K_SWITCH:
        case K_SYNONYM:
        case K_SYSTEM:
        case K_TABLE:
        case K_TABLES:
        case K_TABLESPACE:
        case K_TRIGGER:
        case K_THEN:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TUMBLING:
        case K_TYPE:
        case K_UNLOGGED:
        case K_UPDATE:
        case K_UPSERT:
        case K_UNQIESCE:
        case K_USER:
        case K_SIGNED:
        case K_STRING_FUNCTION_NAME:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VERBOSE:
        case K_VIEW:
        case K_WAIT:
        case K_WITHIN:
        case K_WITHOUT:
        case K_WORK:
        case K_XML:
        case K_XMLAGG:
        case K_XMLDATA:
        case K_XMLSCHEMA:
        case K_XMLTEXT:
        case K_XSINIL:
        case K_YAML:
        case K_YES:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:
        case 385:
        case 386:
        case 387:
        case 388:
        case 389:{
          likeTable = Table();
createTable.setLikeTable(likeTable, false);
          break;
          }
        default:
          jj_la1[389] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[390] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_COMMA:{
      jj_consume_token(K_COMMA);
      interleaveIn = SpannerInterleaveIn();
createTable.setSpannerInterleaveIn(interleaveIn);
      break;
      }
    default:
      jj_la1[391] = jj_gen;
      ;
    }
createTable.setTable(table);
        if (indexes.size() > 0)
            createTable.setIndexes(indexes);
        if (createOptions.size() > 0)
            createTable.setCreateOptionsStrings(createOptions);
        if (tableOptions.size() > 0)
            createTable.setTableOptionsStrings(tableOptions);
        if (columnDefinitions.size() > 0)
            createTable.setColumnDefinitions(columnDefinitions);
        if (columns.size() > 0)
            createTable.setColumns(columns);
        return createTable;
}

  final public SpannerInterleaveIn SpannerInterleaveIn() throws ParseException {Table table = null;
    SpannerInterleaveIn.OnDelete action = null;
    jj_consume_token(K_INTERLEAVE);
    jj_consume_token(K_IN);
    jj_consume_token(K_PARENT);
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ON:{
      jj_consume_token(K_ON);
      jj_consume_token(K_DELETE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NO:{
        jj_consume_token(K_NO);
        jj_consume_token(K_ACTION);
action = SpannerInterleaveIn.OnDelete.NO_ACTION;
        break;
        }
      case K_CASCADE:{
        jj_consume_token(K_CASCADE);
action = SpannerInterleaveIn.OnDelete.CASCADE;
        break;
        }
      default:
        jj_la1[392] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[393] = jj_gen;
      ;
    }
return new SpannerInterleaveIn(table, action);
}

  final public ColDataType ColDataType() throws ParseException {ColDataType colDataType = new ColDataType();
    Token tk = null;
    Token tk2 = null;
    List<String> argumentsStringList = new ArrayList<String>();
    List<Integer> array = new ArrayList<Integer>();
    List<String> name;
    ColDataType arrayType;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ARRAY_LITERAL:{
      tk = jj_consume_token(K_ARRAY_LITERAL);
      jj_consume_token(395);
      arrayType = ColDataType();
      jj_consume_token(394);
colDataType.setDataType("ARRAY<" + arrayType.getDataType() + ">");
      break;
      }
    default:
      jj_la1[403] = jj_gen;
      if (jj_2_311(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_BYTES:{
          tk = jj_consume_token(K_BYTES);
          jj_consume_token(379);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_LONG:{
            tk2 = jj_consume_token(S_LONG);
            break;
            }
          case S_IDENTIFIER:{
            tk2 = jj_consume_token(S_IDENTIFIER);
            break;
            }
          default:
            jj_la1[394] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(380);
          break;
          }
        case K_STRING:{
          tk = jj_consume_token(K_STRING);
          jj_consume_token(379);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_LONG:{
            tk2 = jj_consume_token(S_LONG);
            break;
            }
          case S_IDENTIFIER:{
            tk2 = jj_consume_token(S_IDENTIFIER);
            break;
            }
          default:
            jj_la1[395] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(380);
          break;
          }
        case K_JSON:{
          tk = jj_consume_token(K_JSON);
          jj_consume_token(379);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_LONG:{
            tk2 = jj_consume_token(S_LONG);
            break;
            }
          case S_IDENTIFIER:{
            tk2 = jj_consume_token(S_IDENTIFIER);
            break;
            }
          default:
            jj_la1[396] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(380);
          break;
          }
        default:
          jj_la1[397] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
colDataType.setDataType(tk.image + " (" + tk2.image + ")");
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_BIT:
        case K_CHARACTER:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CHARACTER:{
            tk = jj_consume_token(K_CHARACTER);
            break;
            }
          case K_BIT:{
            tk = jj_consume_token(K_BIT);
            break;
            }
          default:
            jj_la1[398] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_VARYING:{
            tk2 = jj_consume_token(K_VARYING);
            break;
            }
          default:
            jj_la1[399] = jj_gen;
            ;
          }
colDataType.setDataType(tk.image + (tk2!=null?" " + tk2.image:""));
          break;
          }
        case K_DOUBLE:{
          tk = jj_consume_token(K_DOUBLE);
          if (jj_2_309(2)) {
            tk2 = jj_consume_token(K_PRECISION);
          } else {
            ;
          }
colDataType.setDataType(tk.image + (tk2!=null?" " + tk2.image:""));
          break;
          }
        case K_BINARY:
        case K_CHAR:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_INTERVAL:
        case K_JSON:
        case K_SET:
        case K_STRING:
        case K_XML:
        case DT_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_IDENTIFIER:{
            tk = jj_consume_token(S_IDENTIFIER);
            break;
            }
          case S_QUOTED_IDENTIFIER:{
            tk = jj_consume_token(S_QUOTED_IDENTIFIER);
            break;
            }
          case K_DATETIMELITERAL:{
            tk = jj_consume_token(K_DATETIMELITERAL);
            break;
            }
          case K_DATE_LITERAL:{
            tk = jj_consume_token(K_DATE_LITERAL);
            break;
            }
          case K_XML:{
            tk = jj_consume_token(K_XML);
            break;
            }
          case K_INTERVAL:{
            tk = jj_consume_token(K_INTERVAL);
            break;
            }
          case DT_ZONE:{
            tk = jj_consume_token(DT_ZONE);
            break;
            }
          case K_CHAR:{
            tk = jj_consume_token(K_CHAR);
            break;
            }
          case K_SET:{
            tk = jj_consume_token(K_SET);
            break;
            }
          case K_BINARY:{
            tk = jj_consume_token(K_BINARY);
            break;
            }
          case K_JSON:{
            tk = jj_consume_token(K_JSON);
            break;
            }
          case K_STRING:{
            tk = jj_consume_token(K_STRING);
            break;
            }
          default:
            jj_la1[400] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 383:{
            jj_consume_token(383);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S_IDENTIFIER:{
              tk2 = jj_consume_token(S_IDENTIFIER);
              break;
              }
            case S_QUOTED_IDENTIFIER:{
              tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
              break;
              }
            default:
              jj_la1[401] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[402] = jj_gen;
            ;
          }
if (tk2!=null) colDataType.setDataType(tk.image + "." + tk2.image); else colDataType.setDataType(tk.image);
          break;
          }
        case K_UNSIGNED:{
          tk = jj_consume_token(K_UNSIGNED);
          if (jj_2_310(2)) {
            tk2 = jj_consume_token(S_IDENTIFIER);
          } else {
            ;
          }
if (tk2!=null) colDataType.setDataType(tk.image + " " + tk2.image); else colDataType.setDataType(tk.image);
          break;
          }
        default:
          jj_la1[404] = jj_gen;
          if (jj_2_312(2)) {
            tk = jj_consume_token(K_SIGNED);
            tk2 = jj_consume_token(S_IDENTIFIER);
colDataType.setDataType(tk.image + " " + tk2.image);
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_SIGNED:{
              tk = jj_consume_token(K_SIGNED);
colDataType.setDataType(tk.image);
              break;
              }
            default:
              jj_la1[405] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
    }
    if (jj_2_314(2)) {
      jj_consume_token(379);
tk2 =null;
      label_77:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CHAR:
        case S_LONG:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:{
          ;
          break;
          }
        default:
          jj_la1[406] = jj_gen;
          break label_77;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          tk = jj_consume_token(S_LONG);
          if (jj_2_313(2)) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_BYTE:{
              tk2 = jj_consume_token(K_BYTE);
              break;
              }
            case K_CHAR:{
              tk2 = jj_consume_token(K_CHAR);
              break;
              }
            default:
              jj_la1[407] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          } else {
            ;
          }
          break;
          }
        case S_CHAR_LITERAL:{
          tk = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case K_CHAR:{
          tk = jj_consume_token(K_CHAR);
          break;
          }
        default:
          jj_la1[408] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
argumentsStringList.add(tk.image + (tk2!=null?" " + tk2.image:""));
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          jj_consume_token(K_COMMA);

          break;
          }
        default:
          jj_la1[409] = jj_gen;
          ;
        }
      }
      jj_consume_token(380);
    } else {
      ;
    }
    if (jj_2_316(2)) {
      label_78:
      while (true) {
        jj_consume_token(417);
tk=null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          tk = jj_consume_token(S_LONG);
          break;
          }
        default:
          jj_la1[410] = jj_gen;
          ;
        }
array.add(tk!=null?Integer.valueOf(tk.image):null);
        jj_consume_token(418);
        if (jj_2_315(2)) {
          ;
        } else {
          break label_78;
        }
      }
colDataType.setArrayData(array);
    } else {
      ;
    }
    if (jj_2_317(2)) {
      jj_consume_token(K_CHARACTER);
      jj_consume_token(K_SET);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_BINARY:{
        tk = jj_consume_token(K_BINARY);
        break;
        }
      default:
        jj_la1[411] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
colDataType.setCharacterSet(tk.image);
    } else {
      ;
    }
if (argumentsStringList.size() > 0)
            colDataType.setArgumentsStringList(argumentsStringList);
        return colDataType;
}

  final public Analyze Analyze() throws ParseException {Analyze analyze = new Analyze();
    Table table = null;
    jj_consume_token(K_ANALYZE);
    table = Table();
analyze.setTable(table);
        return analyze;
}

  final public CreateView CreateView(boolean isUsingOrReplace) throws ParseException {CreateView createView = new CreateView();
    Table view = null;
    Select select = null;
    List<String> columnNames = null;
    Token tk = null;
createView.setOrReplace(isUsingOrReplace);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FORCE:
    case K_NO:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NO:{
        jj_consume_token(K_NO);
        jj_consume_token(K_FORCE);
createView.setForce(ForceOption.NO_FORCE);
        break;
        }
      case K_FORCE:{
        jj_consume_token(K_FORCE);
createView.setForce(ForceOption.FORCE);
        break;
        }
      default:
        jj_la1[412] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[413] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TEMP:
    case K_TEMPORARY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TEMP:{
        jj_consume_token(K_TEMP);
createView.setTemporary(TemporaryOption.TEMP);
        break;
        }
      case K_TEMPORARY:{
        jj_consume_token(K_TEMPORARY);
createView.setTemporary(TemporaryOption.TEMPORARY);
        break;
        }
      default:
        jj_la1[414] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[415] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_MATERIALIZED:{
      jj_consume_token(K_MATERIALIZED);
createView.setMaterialized(true);
      break;
      }
    default:
      jj_la1[416] = jj_gen;
      ;
    }
    jj_consume_token(K_VIEW);
    view = Table();
createView.setView(view);
    if (jj_2_318(3)) {
      jj_consume_token(K_AUTO);
      jj_consume_token(K_REFRESH);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_YES:{
        tk = jj_consume_token(K_YES);
        break;
        }
      case K_NO:{
        tk = jj_consume_token(K_NO);
        break;
        }
      default:
        jj_la1[417] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
createView.setAutoRefresh(AutoRefreshOption.from(tk.image));
    } else {
      ;
    }
    if (jj_2_319(3)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_NOT);
      jj_consume_token(K_EXISTS);
createView.setIfNotExists(true);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 379:{
      columnNames = ColumnsNamesList();
createView.setColumnNames(columnNames);
      break;
      }
    default:
      jj_la1[418] = jj_gen;
      ;
    }
    jj_consume_token(K_AS);
    select = Select();
createView.setSelect(select);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WITH:{
      jj_consume_token(K_WITH);
      jj_consume_token(K_READ);
      jj_consume_token(K_ONLY);
createView.setWithReadOnly(true);
      break;
      }
    default:
      jj_la1[419] = jj_gen;
      ;
    }
return createView;
}

  final public ReferentialAction.Action Action() throws ParseException {ReferentialAction.Action action = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CASCADE:{
      jj_consume_token(K_CASCADE);
action=ReferentialAction.Action.CASCADE;
      break;
      }
    case K_RESTRICT:{
      jj_consume_token(K_RESTRICT);
action=ReferentialAction.Action.RESTRICT;
      break;
      }
    case K_NO:{
      jj_consume_token(K_NO);
      jj_consume_token(K_ACTION);
action=ReferentialAction.Action.NO_ACTION;
      break;
      }
    case K_SET:{
      jj_consume_token(K_SET);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NULL:{
        jj_consume_token(K_NULL);
action=ReferentialAction.Action.SET_NULL;
        break;
        }
      case K_DEFAULT:{
        jj_consume_token(K_DEFAULT);
action=ReferentialAction.Action.SET_DEFAULT;
        break;
        }
      default:
        jj_la1[420] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[421] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return action;
}

  final public AlterView AlterView(boolean useReplace) throws ParseException {AlterView alterView = new AlterView();
    Table view = null;
    Select select = null;
    List<String> columnNames = null;
    jj_consume_token(K_VIEW);
    view = Table();
alterView.setView(view); alterView.setUseReplace(useReplace);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 379:{
      columnNames = ColumnsNamesList();
alterView.setColumnNames(columnNames);
      break;
      }
    default:
      jj_la1[422] = jj_gen;
      ;
    }
    jj_consume_token(K_AS);
    select = Select();
alterView.setSelect(select);
        return alterView;
}

  final public List<String> CreateParameter() throws ParseException {String retval = "";
    Token tk = null, tk2 = null;
    Expression exp = null;
    ColDataType colDataType;

    List<String> param = new ArrayList<String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NEXTVAL:{
      jj_consume_token(K_NEXTVAL);
      jj_consume_token(379);
      tk = jj_consume_token(S_CHAR_LITERAL);
      jj_consume_token(423);
      colDataType = ColDataType();
      jj_consume_token(380);
param.add("NextVal( " + tk.image + "::" + colDataType + ")" );
      break;
      }
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[423] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
retval+=tk.image;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 383:{
        jj_consume_token(383);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk2 = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[424] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
retval+="."+tk2.image;
        break;
        }
      default:
        jj_la1[425] = jj_gen;
        ;
      }
param.add(retval);
      break;
      }
    default:
      jj_la1[432] = jj_gen;
      if (jj_2_321(3)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_USING:{
          jj_consume_token(K_USING);
          jj_consume_token(K_INDEX);
param.add("USING INDEX");
          break;
          }
        default:
          jj_la1[426] = jj_gen;
          ;
        }
        jj_consume_token(K_TABLESPACE);
        retval = RelObjectName();
param.add("TABLESPACE " + retval);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ASC:
        case K_BINARY:
        case K_BY:
        case K_CASCADE:
        case K_COLLATE:
        case K_COMMIT:
        case K_COMMENT:
        case K_CONSTRAINT:
        case K_DELETE:
        case K_DESC:
        case K_DROP:
        case K_EXCLUDE:
        case K_FALSE:
        case K_FOREIGN:
        case K_IN:
        case K_KEY:
        case K_NOT:
        case K_NULL:
        case K_ON:
        case K_PARALLEL:
        case K_PARTITION:
        case K_PRIMARY:
        case K_REFERENCES:
        case K_ROWS:
        case K_START:
        case K_STORED:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TRUE:
        case K_TYPE:
        case K_UNIQUE:
        case K_UPDATE:
        case K_USING:
        case K_UNSIGNED:
        case K_WHERE:
        case K_WITH:
        case S_CHAR_LITERAL:
        case 381:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_CHAR_LITERAL:{
            tk = jj_consume_token(S_CHAR_LITERAL);
            break;
            }
          case K_NULL:{
            tk = jj_consume_token(K_NULL);
            break;
            }
          case K_NOT:{
            tk = jj_consume_token(K_NOT);
            break;
            }
          case K_PRIMARY:{
            tk = jj_consume_token(K_PRIMARY);
            break;
            }
          case K_FOREIGN:{
            tk = jj_consume_token(K_FOREIGN);
            break;
            }
          case K_REFERENCES:{
            tk = jj_consume_token(K_REFERENCES);
            break;
            }
          case K_KEY:{
            tk = jj_consume_token(K_KEY);
            break;
            }
          case K_STORED:{
            tk = jj_consume_token(K_STORED);
            break;
            }
          case K_ON:{
            tk = jj_consume_token(K_ON);
            break;
            }
          case K_COMMIT:{
            tk = jj_consume_token(K_COMMIT);
            break;
            }
          case K_DROP:{
            tk = jj_consume_token(K_DROP);
            break;
            }
          case K_ROWS:{
            tk = jj_consume_token(K_ROWS);
            break;
            }
          case K_UNIQUE:{
            tk = jj_consume_token(K_UNIQUE);
            break;
            }
          case K_CASCADE:{
            tk = jj_consume_token(K_CASCADE);
            break;
            }
          case K_DELETE:{
            tk = jj_consume_token(K_DELETE);
            break;
            }
          case K_UPDATE:{
            tk = jj_consume_token(K_UPDATE);
            break;
            }
          case K_CONSTRAINT:{
            tk = jj_consume_token(K_CONSTRAINT);
            break;
            }
          case K_WITH:{
            tk = jj_consume_token(K_WITH);
            break;
            }
          case K_EXCLUDE:{
            tk = jj_consume_token(K_EXCLUDE);
            break;
            }
          case K_WHERE:{
            tk = jj_consume_token(K_WHERE);
            break;
            }
          case K_UNSIGNED:{
            tk = jj_consume_token(K_UNSIGNED);
            break;
            }
          case K_TEMP:{
            tk = jj_consume_token(K_TEMP);
            break;
            }
          case K_TEMPORARY:{
            tk = jj_consume_token(K_TEMPORARY);
            break;
            }
          case K_PARTITION:{
            tk = jj_consume_token(K_PARTITION);
            break;
            }
          case K_BY:{
            tk = jj_consume_token(K_BY);
            break;
            }
          case K_IN:{
            tk = jj_consume_token(K_IN);
            break;
            }
          case K_TYPE:{
            tk = jj_consume_token(K_TYPE);
            break;
            }
          case K_COMMENT:{
            tk = jj_consume_token(K_COMMENT);
            break;
            }
          case K_USING:{
            tk = jj_consume_token(K_USING);
            break;
            }
          case K_COLLATE:{
            tk = jj_consume_token(K_COLLATE);
            break;
            }
          case K_ASC:{
            tk = jj_consume_token(K_ASC);
            break;
            }
          case K_DESC:{
            tk = jj_consume_token(K_DESC);
            break;
            }
          case K_TRUE:{
            tk = jj_consume_token(K_TRUE);
            break;
            }
          case K_FALSE:{
            tk = jj_consume_token(K_FALSE);
            break;
            }
          case K_PARALLEL:{
            tk = jj_consume_token(K_PARALLEL);
            break;
            }
          case K_BINARY:{
            tk = jj_consume_token(K_BINARY);
            break;
            }
          case K_START:{
            tk = jj_consume_token(K_START);
            break;
            }
          case K_TIME_KEY_EXPR:{
            tk = jj_consume_token(K_TIME_KEY_EXPR);
            break;
            }
          case 381:{
            tk = jj_consume_token(381);
            break;
            }
          default:
            jj_la1[427] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
param.add(tk.image);
          break;
          }
        case K_AS:
        case K_CHECK:
        case K_DEFAULT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_DEFAULT:{
            tk = jj_consume_token(K_DEFAULT);
            break;
            }
          case K_AS:{
            tk = jj_consume_token(K_AS);
            break;
            }
          case K_CHECK:{
            tk = jj_consume_token(K_CHECK);
            break;
            }
          default:
            jj_la1[428] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          if (jj_2_320(2)) {
            jj_consume_token(379);
            exp = Expression();
            jj_consume_token(380);
          } else {
            ;
          }
param.add(tk.image);
            if (exp!=null) {
                param.add("(" + exp + ")");
            }
          break;
          }
        case S_DOUBLE:
        case S_LONG:
        case 393:
        case 405:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_LONG:
          case 393:
          case 405:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 393:
            case 405:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case 393:{
                tk = jj_consume_token(393);
                break;
                }
              case 405:{
                tk = jj_consume_token(405);
                break;
                }
              default:
                jj_la1[429] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
retval = tk.image;
              break;
              }
            default:
              jj_la1[430] = jj_gen;
              ;
            }
            tk = jj_consume_token(S_LONG);
            break;
            }
          case S_DOUBLE:{
            tk = jj_consume_token(S_DOUBLE);
            break;
            }
          default:
            jj_la1[431] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
param.add( retval + tk.image );
          break;
          }
        case 379:{
          retval = AList();
param.add(retval);
          break;
          }
        case K_CHARACTER:{
          tk = jj_consume_token(K_CHARACTER);
          tk2 = jj_consume_token(K_SET);
param.add(tk.image); param.add(tk2.image);
          break;
          }
        case K_ARRAY_LITERAL:{
          jj_consume_token(K_ARRAY_LITERAL);
          exp = ArrayConstructor(true);
param.add(exp.toString());
          break;
          }
        case 423:{
          tk = jj_consume_token(423);
          colDataType = ColDataType();
param.add(tk.image); param.add(colDataType.toString());
          break;
          }
        default:
          jj_la1[433] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return param;
}

// row_movement_clause https://docs.oracle.com/cd/B19306_01/server.102/b14200/statements_7002.htm#i2204697
  final public RowMovement RowMovement() throws ParseException {RowMovement rowMovement = new RowMovement();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ENABLE:{
      jj_consume_token(K_ENABLE);
      jj_consume_token(K_ROW);
      jj_consume_token(K_MOVEMENT);
rowMovement.setMode(RowMovementMode.ENABLE);
      break;
      }
    case K_DISABLE:{
      jj_consume_token(K_DISABLE);
      jj_consume_token(K_ROW);
      jj_consume_token(K_MOVEMENT);
rowMovement.setMode(RowMovementMode.DISABLE);
      break;
      }
    default:
      jj_la1[434] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return rowMovement;
}

  final public String AList() throws ParseException {StringBuilder retval = new StringBuilder("(");
    Token tk = null;
    String name = null;
    jj_consume_token(379);
    label_79:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALTER:
      case K_ANALYZE:
      case K_APPLY:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONVERT:
      case K_COSTS:
      case K_CYCLE:
      case K_DATABASE:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GLOBAL:
      case K_GRANT:
      case K_GUARD:
      case K_HISTORY:
      case K_HOPPING:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_OPEN:
      case K_OVER:
      case K_OVERLAPS:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PURGE:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_REFERENCES:
      case K_REFRESH:
      case K_RLIKE:
      case K_REGISTER:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_ROLLBACK:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SEED:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_STORED:
      case K_STRING:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VERBOSE:
      case K_VIEW:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 385:
      case 386:
      case 387:
      case 388:
      case 389:{
        ;
        break;
        }
      default:
        jj_la1[435] = jj_gen;
        break label_79;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_DOUBLE:
      case S_LONG:
      case S_CHAR_LITERAL:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          tk = jj_consume_token(S_LONG);
          break;
          }
        case S_DOUBLE:{
          tk = jj_consume_token(S_DOUBLE);
          break;
          }
        case S_CHAR_LITERAL:{
          tk = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        default:
          jj_la1[436] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
retval.append(tk.image);
        break;
        }
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALTER:
      case K_ANALYZE:
      case K_APPLY:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONVERT:
      case K_COSTS:
      case K_CYCLE:
      case K_DATABASE:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GLOBAL:
      case K_GRANT:
      case K_GUARD:
      case K_HISTORY:
      case K_HOPPING:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_OPEN:
      case K_OVER:
      case K_OVERLAPS:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PURGE:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_REFERENCES:
      case K_REFRESH:
      case K_RLIKE:
      case K_REGISTER:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_ROLLBACK:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SEED:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_STORED:
      case K_STRING:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VERBOSE:
      case K_VIEW:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 385:
      case 386:
      case 387:
      case 388:
      case 389:{
        name = RelObjectNameWithoutValue();
retval.append(name);
        break;
        }
      default:
        jj_la1[437] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:
      case 381:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          jj_consume_token(K_COMMA);
retval.append(",");
          break;
          }
        case 381:{
          jj_consume_token(381);
retval.append("=");
          break;
          }
        default:
          jj_la1[438] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[439] = jj_gen;
        ;
      }
    }
    jj_consume_token(380);
retval.append(")");
        return retval.toString();
}

  final public String ColumnsNamesListItem() throws ParseException {Token tk = null;
    String item = null;
    item = RelObjectName();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 379:{
      jj_consume_token(379);
      tk = jj_consume_token(S_LONG);
      jj_consume_token(380);
item = item + "(" + tk.image + ")";
      break;
      }
    default:
      jj_la1[440] = jj_gen;
      ;
    }
return item;
}

  final public List<String> ColumnsNamesList() throws ParseException {List<String> retval = new ArrayList<String>();
    String img = null;
    jj_consume_token(379);
    img = ColumnsNamesListItem();
retval.add(img);
    label_80:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[441] = jj_gen;
        break label_80;
      }
      jj_consume_token(K_COMMA);
      img = ColumnsNamesListItem();
retval.add(img);
    }
    jj_consume_token(380);
return retval;
}

  final public String FuncArgsListItem() throws ParseException {Token tk = null;
    String argName = null;
    String argType = null;
    if (jj_2_322(2)) {
      argName = RelObjectName();
      argType = RelObjectName();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 379:{
        jj_consume_token(379);
        tk = jj_consume_token(S_LONG);
        jj_consume_token(380);
argType = argType + "(" + tk.image + ")";
        break;
        }
      default:
        jj_la1[442] = jj_gen;
        ;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ADD:
      case K_ADVANCE:
      case K_ADVISE:
      case K_AGAINST:
      case K_ALGORITHM:
      case K_ALTER:
      case K_ANALYZE:
      case K_APPLY:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_ASC:
      case K_AUTHORIZATION:
      case K_AUTO:
      case K_BEGIN:
      case K_BERNOULLI:
      case K_BINARY:
      case K_BIT:
      case K_BLOCK:
      case K_BROWSE:
      case K_BY:
      case K_BYTES:
      case K_CACHE:
      case K_BUFFERS:
      case K_BYTE:
      case K_CALL:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHANGES:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_CLOSE:
      case K_COLLATE:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONFLICT:
      case K_CONNECT:
      case K_CONVERT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATABASE:
      case K_DECLARE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DEFAULT:
      case K_DEFERRABLE:
      case K_DELAYED:
      case K_DELETE:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DDL:
      case K_DML:
      case K_DO:
      case K_DOMAIN:
      case K_DROP:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ELEMENTS:
      case K_EMIT:
      case K_ENABLE:
      case K_END:
      case K_ESCAPE:
      case K_EXCLUDE:
      case K_EXEC:
      case K_EXECUTE:
      case K_EXPLAIN:
      case K_EXPLICIT:
      case K_EXTENDED:
      case K_EXTRACT:
      case K_ISOLATION:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_FUNCTION:
      case K_GLOBAL:
      case K_GRANT:
      case K_GROUP:
      case K_GUARD:
      case K_HISTORY:
      case K_HOPPING:
      case K_IGNORE:
      case K_INCLUDE:
      case K_INCREMENT:
      case K_INDEX:
      case K_INSERT:
      case K_INTERLEAVE:
      case K_INTERPRET:
      case K_INTERVAL:
      case K_ISNULL:
      case K_JSON:
      case K_KEEP:
      case K_KEY:
      case K_KEYS:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LOCAL:
      case K_LOCKED:
      case K_LINK:
      case K_LOG:
      case K_MATCH:
      case K_MATCHED:
      case K_MATERIALIZED:
      case K_MAXVALUE:
      case K_MEMBER:
      case K_MERGE:
      case K_MINVALUE:
      case K_MODIFY:
      case K_MOVEMENT:
      case K_NEXT:
      case K_NO:
      case K_NOCACHE:
      case K_NOKEEP:
      case K_NOLOCK:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_NOTHING:
      case K_NOTNULL:
      case K_NOVALIDATE:
      case K_NULLS:
      case K_NOWAIT:
      case K_OF:
      case K_OFF:
      case K_ON:
      case K_OPEN:
      case K_OVER:
      case K_OVERLAPS:
      case K_PARALLEL:
      case K_PARENT:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PLACING:
      case K_PRECEDING:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PURGE:
      case K_QUALIFY:
      case K_QUERY:
      case K_QUICK:
      case K_QUIESCE:
      case K_RANGE:
      case K_RAW:
      case K_READ:
      case K_RECYCLEBIN:
      case K_REFERENCES:
      case K_REFRESH:
      case K_RLIKE:
      case K_REGISTER:
      case K_RENAME:
      case K_REPEATABLE:
      case K_REPLACE:
      case K_RESET:
      case K_RESTART:
      case K_RESUMABLE:
      case K_RESUME:
      case K_RESTRICT:
      case K_RESTRICTED:
      case K_ROLLBACK:
      case K_ROOT:
      case K_ROW:
      case K_ROWS:
      case K_SAVEPOINT:
      case K_SCHEMA:
      case K_SEED:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SETS:
      case K_SHOW:
      case K_SHUTDOWN:
      case K_SIBLINGS:
      case K_SIMILAR:
      case K_SIZE:
      case K_SKIP:
      case K_START:
      case K_STORED:
      case K_STRING:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TRIGGER:
      case K_THEN:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TUMBLING:
      case K_TYPE:
      case K_UNLOGGED:
      case K_UPDATE:
      case K_UPSERT:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VERBOSE:
      case K_VIEW:
      case K_WAIT:
      case K_WITHIN:
      case K_WITHOUT:
      case K_WORK:
      case K_XML:
      case K_XMLAGG:
      case K_XMLDATA:
      case K_XMLSCHEMA:
      case K_XMLTEXT:
      case K_XSINIL:
      case K_YAML:
      case K_YES:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 385:
      case 386:
      case 387:
      case 388:
      case 389:{
        argType = RelObjectName();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 379:{
          jj_consume_token(379);
          tk = jj_consume_token(S_LONG);
          jj_consume_token(380);
argType = argType + "(" + tk.image + ")";
          break;
          }
        default:
          jj_la1[443] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[444] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return argName != null ? String.format("%s %s", argName, argType) : argType;
}

  final public List<String> FuncArgsList() throws ParseException {List<String> retval = null;
    String img = null;
    jj_consume_token(379);
retval = new ArrayList<String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ADD:
    case K_ADVANCE:
    case K_ADVISE:
    case K_AGAINST:
    case K_ALGORITHM:
    case K_ALTER:
    case K_ANALYZE:
    case K_APPLY:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_ASC:
    case K_AUTHORIZATION:
    case K_AUTO:
    case K_BEGIN:
    case K_BERNOULLI:
    case K_BINARY:
    case K_BIT:
    case K_BLOCK:
    case K_BROWSE:
    case K_BY:
    case K_BYTES:
    case K_CACHE:
    case K_BUFFERS:
    case K_BYTE:
    case K_CALL:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHANGES:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_CLOSE:
    case K_COLLATE:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONFLICT:
    case K_CONNECT:
    case K_CONVERT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATABASE:
    case K_DECLARE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DEFAULT:
    case K_DEFERRABLE:
    case K_DELAYED:
    case K_DELETE:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DDL:
    case K_DML:
    case K_DO:
    case K_DOMAIN:
    case K_DROP:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ELEMENTS:
    case K_EMIT:
    case K_ENABLE:
    case K_END:
    case K_ESCAPE:
    case K_EXCLUDE:
    case K_EXEC:
    case K_EXECUTE:
    case K_EXPLAIN:
    case K_EXPLICIT:
    case K_EXTENDED:
    case K_EXTRACT:
    case K_ISOLATION:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_FUNCTION:
    case K_GLOBAL:
    case K_GRANT:
    case K_GROUP:
    case K_GUARD:
    case K_HISTORY:
    case K_HOPPING:
    case K_IGNORE:
    case K_INCLUDE:
    case K_INCREMENT:
    case K_INDEX:
    case K_INSERT:
    case K_INTERLEAVE:
    case K_INTERPRET:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEEP:
    case K_KEY:
    case K_KEYS:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LOCKED:
    case K_LINK:
    case K_LOG:
    case K_MATCH:
    case K_MATCHED:
    case K_MATERIALIZED:
    case K_MAXVALUE:
    case K_MEMBER:
    case K_MERGE:
    case K_MINVALUE:
    case K_MODIFY:
    case K_MOVEMENT:
    case K_NEXT:
    case K_NO:
    case K_NOCACHE:
    case K_NOKEEP:
    case K_NOLOCK:
    case K_NOMAXVALUE:
    case K_NOMINVALUE:
    case K_NOORDER:
    case K_NOTHING:
    case K_NOTNULL:
    case K_NOVALIDATE:
    case K_NULLS:
    case K_NOWAIT:
    case K_OF:
    case K_OFF:
    case K_ON:
    case K_OPEN:
    case K_OVER:
    case K_OVERLAPS:
    case K_PARALLEL:
    case K_PARENT:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PLACING:
    case K_PRECEDING:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PURGE:
    case K_QUALIFY:
    case K_QUERY:
    case K_QUICK:
    case K_QUIESCE:
    case K_RANGE:
    case K_RAW:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REFERENCES:
    case K_REFRESH:
    case K_RLIKE:
    case K_REGISTER:
    case K_RENAME:
    case K_REPEATABLE:
    case K_REPLACE:
    case K_RESET:
    case K_RESTART:
    case K_RESUMABLE:
    case K_RESUME:
    case K_RESTRICT:
    case K_RESTRICTED:
    case K_ROLLBACK:
    case K_ROOT:
    case K_ROW:
    case K_ROWS:
    case K_SAVEPOINT:
    case K_SCHEMA:
    case K_SEED:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SETS:
    case K_SHOW:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIMILAR:
    case K_SIZE:
    case K_SKIP:
    case K_START:
    case K_STORED:
    case K_STRING:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TRIGGER:
    case K_THEN:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TUMBLING:
    case K_TYPE:
    case K_UNLOGGED:
    case K_UPDATE:
    case K_UPSERT:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VERBOSE:
    case K_VIEW:
    case K_WAIT:
    case K_WITHIN:
    case K_WITHOUT:
    case K_WORK:
    case K_XML:
    case K_XMLAGG:
    case K_XMLDATA:
    case K_XMLSCHEMA:
    case K_XMLTEXT:
    case K_XSINIL:
    case K_YAML:
    case K_YES:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
    case 385:
    case 386:
    case 387:
    case 388:
    case 389:{
      img = FuncArgsListItem();
retval.add(img);
      label_81:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[445] = jj_gen;
          break label_81;
        }
        jj_consume_token(K_COMMA);
        img = FuncArgsListItem();
retval.add(img);
      }
      break;
      }
    default:
      jj_la1[446] = jj_gen;
      ;
    }
    jj_consume_token(380);
return retval;
}

  final public Drop Drop() throws ParseException {Drop drop = new Drop();
    Token tk = null;
    Table name;
    List<String> dropArgs = new ArrayList<String>();
    List<String> funcArgs = null;
    boolean useTemporary = false;
    jj_consume_token(K_DROP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_MATERIALIZED:{
      jj_consume_token(K_MATERIALIZED);
drop.setMaterialized(true);
      break;
      }
    default:
      jj_la1[447] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case K_TABLE:
    case K_TEMPORARY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TEMPORARY:{
        jj_consume_token(K_TEMPORARY);
useTemporary=true;
        break;
        }
      default:
        jj_la1[448] = jj_gen;
        ;
      }
      tk = jj_consume_token(K_TABLE);
      break;
      }
    case K_INDEX:{
      tk = jj_consume_token(K_INDEX);
      break;
      }
    case K_VIEW:{
      tk = jj_consume_token(K_VIEW);
      break;
      }
    case K_SCHEMA:{
      tk = jj_consume_token(K_SCHEMA);
      break;
      }
    case K_SEQUENCE:{
      tk = jj_consume_token(K_SEQUENCE);
      break;
      }
    case K_FUNCTION:{
      tk = jj_consume_token(K_FUNCTION);
      break;
      }
    default:
      jj_la1[449] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
drop.setType(tk.image);
    if (jj_2_323(2)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_EXISTS);
drop.setIfExists(true);
    } else {
      ;
    }
    name = Table();
drop.setName(name);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 379:{
      funcArgs = FuncArgsList();
      break;
      }
    default:
      jj_la1[450] = jj_gen;
      ;
    }
    label_82:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CASCADE:
      case K_ON:
      case K_RESTRICT:
      case S_IDENTIFIER:{
        ;
        break;
        }
      default:
        jj_la1[451] = jj_gen;
        break label_82;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_CASCADE:{
        tk = jj_consume_token(K_CASCADE);
        break;
        }
      case K_RESTRICT:{
        tk = jj_consume_token(K_RESTRICT);
        break;
        }
      case K_ON:{
        tk = jj_consume_token(K_ON);
        break;
        }
      default:
        jj_la1[452] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
dropArgs.add(tk.image);
    }
if (dropArgs.size() > 0) {
            drop.setParameters(dropArgs);
        }
        if (drop.getType().equals("FUNCTION")) {
            drop.getTypeToParameters().put("FUNCTION", funcArgs);
        }

        drop.setUsingTemporary(useTemporary);

        return drop;
}

  final public Truncate Truncate() throws ParseException {Truncate truncate = new Truncate();
    Table table;
    jj_consume_token(K_TRUNCATE);
    if (jj_2_324(2)) {
      jj_consume_token(K_TABLE);
truncate.setTableToken(true);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ONLY:{
      jj_consume_token(K_ONLY);
truncate.setOnly(true);
      break;
      }
    default:
      jj_la1[453] = jj_gen;
      ;
    }
    table = Table();
truncate.setTable(table); truncate.setCascade(false);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CASCADE:{
      jj_consume_token(K_CASCADE);
truncate.setCascade(true);
      break;
      }
    default:
      jj_la1[454] = jj_gen;
      ;
    }
return truncate;
}

  final public AlterExpression.ColumnDataType AlterExpressionColumnDataType() throws ParseException {String columnName = null;
    boolean withType = false;
    ColDataType dataType = null;
    List<String> columnSpecs = null;
    List<String> parameter = null;
    columnName = RelObjectName();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TYPE:{
      jj_consume_token(K_TYPE);
withType = true;
      break;
      }
    default:
      jj_la1[455] = jj_gen;
      ;
    }
    dataType = ColDataType();
columnSpecs = new ArrayList<String>();
    label_83:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_AS:
      case K_ASC:
      case K_BINARY:
      case K_BY:
      case K_CASCADE:
      case K_CHARACTER:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_DROP:
      case K_EXCLUDE:
      case K_FALSE:
      case K_FOREIGN:
      case K_IN:
      case K_KEY:
      case K_NEXTVAL:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_START:
      case K_STORED:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 379:
      case 381:
      case 393:
      case 405:
      case 423:{
        ;
        break;
        }
      default:
        jj_la1[456] = jj_gen;
        break label_83;
      }
      parameter = CreateParameter();
columnSpecs.addAll(parameter);
    }
return new AlterExpression.ColumnDataType(columnName, withType, dataType, columnSpecs);
}

  final public AlterExpression.ColumnDropNotNull AlterExpressionColumnDropNotNull() throws ParseException {String columnName = null;
    boolean withNot = false;
    ColDataType dataType = null;
    List<String> columnSpecs = null;
    List<String> parameter = null;
    columnName = RelObjectName();
    jj_consume_token(K_DROP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
withNot = true;
      break;
      }
    default:
      jj_la1[457] = jj_gen;
      ;
    }
    jj_consume_token(K_NULL);
return new AlterExpression.ColumnDropNotNull(columnName, withNot);
}

  final public AlterExpression.ColumnDropDefault AlterExpressionColumnDropDefault() throws ParseException {String columnName = null;
    boolean withNot = false;
    ColDataType dataType = null;
    List<String> columnSpecs = null;
    List<String> parameter = null;
    columnName = RelObjectName();
    jj_consume_token(K_DROP);
    jj_consume_token(K_DEFAULT);
return new AlterExpression.ColumnDropDefault(columnName);
}

  final public List<ConstraintState> AlterExpressionConstraintState() throws ParseException {List<ConstraintState> retval = new ArrayList<ConstraintState>();
    label_84:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFERRABLE:
      case K_DISABLE:
      case K_ENABLE:
      case K_NOT:
      case K_NOVALIDATE:
      case K_VALIDATE:{
        ;
        break;
        }
      default:
        jj_la1[458] = jj_gen;
        break label_84;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFERRABLE:{
        jj_consume_token(K_DEFERRABLE);
retval.add(new DeferrableConstraint(false));
        break;
        }
      case K_NOT:{
        jj_consume_token(K_NOT);
        jj_consume_token(K_DEFERRABLE);
retval.add(new DeferrableConstraint(true));
        break;
        }
      case K_VALIDATE:{
        jj_consume_token(K_VALIDATE);
retval.add(new ValidateConstraint(false));
        break;
        }
      case K_NOVALIDATE:{
        jj_consume_token(K_NOVALIDATE);
retval.add(new ValidateConstraint(true));
        break;
        }
      case K_ENABLE:{
        jj_consume_token(K_ENABLE);
retval.add(new EnableConstraint(false));
        break;
        }
      case K_DISABLE:{
        jj_consume_token(K_DISABLE);
retval.add(new EnableConstraint(true));
        break;
        }
      default:
        jj_la1[459] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return retval;
}

/**
* This production needs refactoring to multiple smaller productions. The target class should
* be splitted as well.
*/
  final public AlterExpression AlterExpression() throws ParseException {AlterExpression alterExp = new AlterExpression();
    Token tk;
    Token tk2 = null;
    String sk3 = null;
    String sk4 = null;
    ColDataType dataType;
    List<String> columnNames = null;
    List<ConstraintState> constraints = null;
    ForeignKeyIndex fkIndex = null;
    Index index = null;
    Table fkTable = null;
    AlterExpression.ColumnDataType alterExpressionColumnDataType = null;
    AlterExpression.ColumnDropNotNull alterExpressionColumnDropNotNull = null;
    AlterExpression.ColumnDropDefault alterExpressionColumnDropDefault = null;
    ReferentialAction.Action action = null;

    // for captureRest()
    List<String> tokens = new LinkedList<String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ADD:
    case K_ALTER:
    case K_MODIFY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ADD:{
        jj_consume_token(K_ADD);
alterExp.setOperation(AlterOperation.ADD);
        break;
        }
      case K_ALTER:{
        jj_consume_token(K_ALTER);
alterExp.setOperation(AlterOperation.ALTER);
        break;
        }
      case K_MODIFY:{
        jj_consume_token(K_MODIFY);
alterExp.setOperation(AlterOperation.MODIFY);
        break;
        }
      default:
        jj_la1[460] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_333(2)) {
        jj_consume_token(K_PRIMARY);
        jj_consume_token(K_KEY);
        columnNames = ColumnsNamesList();
alterExp.setPkColumns(columnNames);
        constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_USING:{
          jj_consume_token(K_USING);
          sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
          break;
          }
        default:
          jj_la1[461] = jj_gen;
          ;
        }
      } else if (jj_2_334(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_KEY:{
          tk = jj_consume_token(K_KEY);
alterExp.setUk(true);
          break;
          }
        case K_INDEX:{
          tk = jj_consume_token(K_INDEX);
          break;
          }
        default:
          jj_la1[462] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        sk3 = RelObjectName();
        columnNames = ColumnsNamesList();
index = new Index().withType(tk.image).withName(sk3).withColumnsNames(columnNames);
                    alterExp.setIndex(index);
        constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_USING:{
          jj_consume_token(K_USING);
          sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
          break;
          }
        default:
          jj_la1[463] = jj_gen;
          ;
        }
      } else if (jj_2_335(3)) {
        if (jj_2_325(2)) {
          jj_consume_token(K_COLUMN);
alterExp.hasColumn(true);
        } else {
          ;
        }
        if (jj_2_326(4)) {
          jj_consume_token(379);
alterExp.useBrackets(true);
          alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
          label_85:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[464] = jj_gen;
              break label_85;
            }
            jj_consume_token(K_COMMA);
            alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
          }
          jj_consume_token(380);
        } else if (jj_2_327(2)) {
          alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
        } else if (jj_2_328(3)) {
          alterExpressionColumnDropNotNull = AlterExpressionColumnDropNotNull();
alterExp.addColDropNotNull( alterExpressionColumnDropNotNull);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ACTIVE:
          case K_ADD:
          case K_ADVANCE:
          case K_ADVISE:
          case K_AGAINST:
          case K_ALGORITHM:
          case K_ALTER:
          case K_ANALYZE:
          case K_APPLY:
          case K_ARCHIVE:
          case K_ARRAY_LITERAL:
          case K_AT:
          case K_ASC:
          case K_AUTHORIZATION:
          case K_AUTO:
          case K_BEGIN:
          case K_BERNOULLI:
          case K_BINARY:
          case K_BIT:
          case K_BLOCK:
          case K_BROWSE:
          case K_BY:
          case K_BYTES:
          case K_CACHE:
          case K_BUFFERS:
          case K_BYTE:
          case K_CALL:
          case K_CASCADE:
          case K_CASE:
          case K_CAST:
          case K_CHARACTER:
          case K_CHANGE:
          case K_CHANGES:
          case K_CHECKPOINT:
          case K_CHAR:
          case K_CLOSE:
          case K_COLLATE:
          case K_COLUMN:
          case K_COLUMNS:
          case K_COMMIT:
          case K_COMMENT:
          case K_CONFLICT:
          case K_CONNECT:
          case K_CONVERT:
          case K_COSTS:
          case K_CREATE:
          case K_CYCLE:
          case K_DATABASE:
          case K_DECLARE:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_DEFAULT:
          case K_DEFERRABLE:
          case K_DELAYED:
          case K_DELETE:
          case K_DESC:
          case K_DESCRIBE:
          case K_DISABLE:
          case K_DISCONNECT:
          case K_DIV:
          case K_DDL:
          case K_DML:
          case K_DO:
          case K_DOMAIN:
          case K_DROP:
          case K_DUMP:
          case K_DUPLICATE:
          case K_ELEMENTS:
          case K_EMIT:
          case K_ENABLE:
          case K_END:
          case K_ESCAPE:
          case K_EXCLUDE:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_EXPLICIT:
          case K_EXTENDED:
          case K_EXTRACT:
          case K_ISOLATION:
          case K_FILTER:
          case K_FIRST:
          case K_FALSE:
          case K_FLUSH:
          case K_FOLLOWING:
          case K_FORMAT:
          case K_FULLTEXT:
          case K_FUNCTION:
          case K_GLOBAL:
          case K_GRANT:
          case K_GROUP:
          case K_GUARD:
          case K_HISTORY:
          case K_HOPPING:
          case K_IGNORE:
          case K_INCLUDE:
          case K_INCREMENT:
          case K_INDEX:
          case K_INSERT:
          case K_INTERLEAVE:
          case K_INTERPRET:
          case K_INTERVAL:
          case K_ISNULL:
          case K_JSON:
          case K_KEEP:
          case K_KEY:
          case K_KEYS:
          case K_FN:
          case K_LAST:
          case K_LEADING:
          case K_LOCAL:
          case K_LOCKED:
          case K_LINK:
          case K_LOG:
          case K_MATCH:
          case K_MATCHED:
          case K_MATERIALIZED:
          case K_MAXVALUE:
          case K_MEMBER:
          case K_MERGE:
          case K_MINVALUE:
          case K_MODIFY:
          case K_MOVEMENT:
          case K_NEXT:
          case K_NO:
          case K_NOCACHE:
          case K_NOKEEP:
          case K_NOLOCK:
          case K_NOMAXVALUE:
          case K_NOMINVALUE:
          case K_NOORDER:
          case K_NOTHING:
          case K_NOTNULL:
          case K_NOVALIDATE:
          case K_NULLS:
          case K_NOWAIT:
          case K_OF:
          case K_OFF:
          case K_ON:
          case K_OPEN:
          case K_OVER:
          case K_OVERLAPS:
          case K_PARALLEL:
          case K_PARENT:
          case K_PARTITION:
          case K_PATH:
          case K_PERCENT:
          case K_PLACING:
          case K_PRECEDING:
          case K_PRECISION:
          case K_PRIMARY:
          case K_PRIOR:
          case K_PURGE:
          case K_QUALIFY:
          case K_QUERY:
          case K_QUICK:
          case K_QUIESCE:
          case K_RANGE:
          case K_RAW:
          case K_READ:
          case K_RECYCLEBIN:
          case K_REFERENCES:
          case K_REFRESH:
          case K_RLIKE:
          case K_REGISTER:
          case K_RENAME:
          case K_REPEATABLE:
          case K_REPLACE:
          case K_RESET:
          case K_RESTART:
          case K_RESUMABLE:
          case K_RESUME:
          case K_RESTRICT:
          case K_RESTRICTED:
          case K_ROLLBACK:
          case K_ROOT:
          case K_ROW:
          case K_ROWS:
          case K_SAVEPOINT:
          case K_SCHEMA:
          case K_SEED:
          case K_SEQUENCE:
          case K_SEPARATOR:
          case K_SESSION:
          case K_SETS:
          case K_SHOW:
          case K_SHUTDOWN:
          case K_SIBLINGS:
          case K_SIMILAR:
          case K_SIZE:
          case K_SKIP:
          case K_START:
          case K_STORED:
          case K_STRING:
          case K_SUSPEND:
          case K_SWITCH:
          case K_SYNONYM:
          case K_SYSTEM:
          case K_TABLE:
          case K_TABLES:
          case K_TABLESPACE:
          case K_TRIGGER:
          case K_THEN:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIME_KEY_EXPR:
          case K_TIMEOUT:
          case K_TO:
          case K_TOP:
          case K_TRUNCATE:
          case K_TRUE:
          case K_TUMBLING:
          case K_TYPE:
          case K_UNLOGGED:
          case K_UPDATE:
          case K_UPSERT:
          case K_UNQIESCE:
          case K_USER:
          case K_SIGNED:
          case K_STRING_FUNCTION_NAME:
          case K_UNSIGNED:
          case K_VALIDATE:
          case K_VALUE:
          case K_VALUES:
          case K_VERBOSE:
          case K_VIEW:
          case K_WAIT:
          case K_WITHIN:
          case K_WITHOUT:
          case K_WORK:
          case K_XML:
          case K_XMLAGG:
          case K_XMLDATA:
          case K_XMLSCHEMA:
          case K_XMLTEXT:
          case K_XSINIL:
          case K_YAML:
          case K_YES:
          case K_ZONE:
          case S_IDENTIFIER:
          case S_QUOTED_IDENTIFIER:
          case 385:
          case 386:
          case 387:
          case 388:
          case 389:{
            alterExpressionColumnDropDefault = AlterExpressionColumnDropDefault();
alterExp.addColDropDefault( alterExpressionColumnDropDefault);
            break;
            }
          default:
            jj_la1[465] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 379:{
          jj_consume_token(379);
          alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
          label_86:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[466] = jj_gen;
              break label_86;
            }
            jj_consume_token(K_COMMA);
            alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
          }
          jj_consume_token(380);
          break;
          }
        case K_UNIQUE:{
          jj_consume_token(K_UNIQUE);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_INDEX:
          case K_KEY:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_KEY:{
              jj_consume_token(K_KEY);
alterExp.setUk(true);
              break;
              }
            case K_INDEX:{
              jj_consume_token(K_INDEX);
              break;
              }
            default:
              jj_la1[467] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S_IDENTIFIER:{
              tk = jj_consume_token(S_IDENTIFIER);
              break;
              }
            case S_QUOTED_IDENTIFIER:{
              tk = jj_consume_token(S_QUOTED_IDENTIFIER);
              break;
              }
            default:
              jj_la1[468] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
alterExp.setUkName(tk.image);
            break;
            }
          default:
            jj_la1[469] = jj_gen;
            ;
          }
          columnNames = ColumnsNamesList();
alterExp.setUkColumns(columnNames);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_USING:{
            jj_consume_token(K_USING);
            sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
            break;
            }
          default:
            jj_la1[470] = jj_gen;
            ;
          }
          break;
          }
        case K_FOREIGN:{
          jj_consume_token(K_FOREIGN);
          jj_consume_token(K_KEY);
          columnNames = ColumnsNamesList();
alterExp.setFkColumns(columnNames); columnNames = null;
          jj_consume_token(K_REFERENCES);
          fkTable = Table();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 379:{
            columnNames = ColumnsNamesList();
            break;
            }
          default:
            jj_la1[471] = jj_gen;
            ;
          }
alterExp.setFkSourceSchema(fkTable.getSchemaName());
                            alterExp.setFkSourceTable(fkTable.getName());
                            alterExp.setFkSourceColumns(columnNames);
          if (jj_2_329(2)) {
            jj_consume_token(K_ON);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_DELETE:{
              tk = jj_consume_token(K_DELETE);
              break;
              }
            case K_UPDATE:{
              tk = jj_consume_token(K_UPDATE);
              break;
              }
            default:
              jj_la1[472] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            action = Action();
alterExp.setReferentialAction(ReferentialAction.Type.from(tk.image), action);
          } else {
            ;
          }
          if (jj_2_330(2)) {
            jj_consume_token(K_ON);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_DELETE:{
              tk = jj_consume_token(K_DELETE);
              break;
              }
            case K_UPDATE:{
              tk = jj_consume_token(K_UPDATE);
              break;
              }
            default:
              jj_la1[473] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            action = Action();
alterExp.setReferentialAction(ReferentialAction.Type.from(tk.image), action);
          } else {
            ;
          }
          break;
          }
        case K_CONSTRAINT:{
          jj_consume_token(K_CONSTRAINT);
          sk3 = RelObjectName();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_FOREIGN:{
            tk = jj_consume_token(K_FOREIGN);
            tk2 = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
fkIndex = new ForeignKeyIndex()
                            .withName(sk3)
                            .withType(tk.image + " " + tk2.image)
                            .withColumnsNames(columnNames);
                                                columnNames = null;
            jj_consume_token(K_REFERENCES);
            fkTable = Table();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 379:{
              columnNames = ColumnsNamesList();
              break;
              }
            default:
              jj_la1[474] = jj_gen;
              ;
            }
fkIndex.withTable(fkTable).withReferencedColumnNames(columnNames);
                            alterExp.setIndex(fkIndex);
            if (jj_2_331(2)) {
              jj_consume_token(K_ON);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_DELETE:{
                tk = jj_consume_token(K_DELETE);
                break;
                }
              case K_UPDATE:{
                tk = jj_consume_token(K_UPDATE);
                break;
                }
              default:
                jj_la1[475] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.from(tk.image), action);
            } else {
              ;
            }
            if (jj_2_332(2)) {
              jj_consume_token(K_ON);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_DELETE:{
                tk = jj_consume_token(K_DELETE);
                break;
                }
              case K_UPDATE:{
                tk = jj_consume_token(K_UPDATE);
                break;
                }
              default:
                jj_la1[476] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.from(tk.image), action);
            } else {
              ;
            }
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            break;
            }
          case K_PRIMARY:{
            tk = jj_consume_token(K_PRIMARY);
            tk2 = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
index = new NamedConstraint()
                            .withName(sk3)
                            .withType(tk.image + " " + tk2.image)
                            .withColumnsNames(columnNames);
                            alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_USING:{
              jj_consume_token(K_USING);
              sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
              break;
              }
            default:
              jj_la1[477] = jj_gen;
              ;
            }
            break;
            }
          case K_CHECK:{
            jj_consume_token(K_CHECK);
Expression exp = null;
            label_87:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case 379:{
                ;
                break;
                }
              default:
                jj_la1[478] = jj_gen;
                break label_87;
              }
              jj_consume_token(379);
              exp = Expression();
              jj_consume_token(380);
            }
CheckConstraint checkCs = new CheckConstraint().withName(sk3).withExpression(exp);
                        alterExp.setIndex(checkCs);
            break;
            }
          case K_UNIQUE:{
            tk = jj_consume_token(K_UNIQUE);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_INDEX:
            case K_KEY:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_KEY:{
                tk2 = jj_consume_token(K_KEY);
alterExp.setUk(true);
                break;
                }
              case K_INDEX:{
                tk2 = jj_consume_token(K_INDEX);
                break;
                }
              default:
                jj_la1[479] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
              }
            default:
              jj_la1[480] = jj_gen;
              ;
            }
            columnNames = ColumnsNamesList();
index = new NamedConstraint()
                                .withName(sk3)
                                .withType(tk.image + (tk2!=null?" " + tk2.image:""))
                                .withColumnsNames(columnNames);
                              alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_USING:{
              jj_consume_token(K_USING);
              sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
              break;
              }
            default:
              jj_la1[481] = jj_gen;
              ;
            }
            break;
            }
          case K_KEY:{
            tk = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
index = new NamedConstraint()
                                .withName(sk3)
                                .withType(tk.image)
                                .withColumnsNames(columnNames);
                              alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            break;
            }
          default:
            jj_la1[482] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        case K_ACTION:
        case K_ACTIVE:
        case K_ADD:
        case K_ADVANCE:
        case K_ADVISE:
        case K_AGAINST:
        case K_ALGORITHM:
        case K_ALTER:
        case K_ANALYZE:
        case K_APPLY:
        case K_ARCHIVE:
        case K_ARRAY_LITERAL:
        case K_AT:
        case K_ASC:
        case K_AUTHORIZATION:
        case K_AUTO:
        case K_BEGIN:
        case K_BERNOULLI:
        case K_BINARY:
        case K_BIT:
        case K_BLOCK:
        case K_BROWSE:
        case K_BY:
        case K_BYTES:
        case K_CACHE:
        case K_BUFFERS:
        case K_BYTE:
        case K_CALL:
        case K_CASCADE:
        case K_CASE:
        case K_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHANGES:
        case K_CHECKPOINT:
        case K_CHAR:
        case K_CLOSE:
        case K_COLLATE:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_CONFLICT:
        case K_CONNECT:
        case K_CONVERT:
        case K_COSTS:
        case K_CREATE:
        case K_CYCLE:
        case K_DATABASE:
        case K_DECLARE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DEFAULT:
        case K_DEFERRABLE:
        case K_DELAYED:
        case K_DELETE:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DISCONNECT:
        case K_DIV:
        case K_DDL:
        case K_DML:
        case K_DO:
        case K_DOMAIN:
        case K_DROP:
        case K_DUMP:
        case K_DUPLICATE:
        case K_ELEMENTS:
        case K_EMIT:
        case K_ENABLE:
        case K_END:
        case K_ESCAPE:
        case K_EXCLUDE:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_EXPLICIT:
        case K_EXTENDED:
        case K_EXTRACT:
        case K_ISOLATION:
        case K_FILTER:
        case K_FIRST:
        case K_FALSE:
        case K_FLUSH:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_FULLTEXT:
        case K_FUNCTION:
        case K_GLOBAL:
        case K_GRANT:
        case K_GROUP:
        case K_GUARD:
        case K_HISTORY:
        case K_HOPPING:
        case K_IGNORE:
        case K_INCLUDE:
        case K_INCREMENT:
        case K_INDEX:
        case K_INSERT:
        case K_INTERLEAVE:
        case K_INTERPRET:
        case K_INTERVAL:
        case K_ISNULL:
        case K_JSON:
        case K_KEEP:
        case K_KEY:
        case K_KEYS:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LOCAL:
        case K_LOCKED:
        case K_LINK:
        case K_LOG:
        case K_MATCH:
        case K_MATCHED:
        case K_MATERIALIZED:
        case K_MAXVALUE:
        case K_MEMBER:
        case K_MERGE:
        case K_MINVALUE:
        case K_MODIFY:
        case K_MOVEMENT:
        case K_NEXT:
        case K_NO:
        case K_NOCACHE:
        case K_NOKEEP:
        case K_NOLOCK:
        case K_NOMAXVALUE:
        case K_NOMINVALUE:
        case K_NOORDER:
        case K_NOTHING:
        case K_NOTNULL:
        case K_NOVALIDATE:
        case K_NULLS:
        case K_NOWAIT:
        case K_OF:
        case K_OFF:
        case K_ON:
        case K_OPEN:
        case K_OVER:
        case K_OVERLAPS:
        case K_PARALLEL:
        case K_PARENT:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PLACING:
        case K_PRECEDING:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PURGE:
        case K_QUALIFY:
        case K_QUERY:
        case K_QUICK:
        case K_QUIESCE:
        case K_RANGE:
        case K_RAW:
        case K_READ:
        case K_RECYCLEBIN:
        case K_REFERENCES:
        case K_REFRESH:
        case K_RLIKE:
        case K_REGISTER:
        case K_RENAME:
        case K_REPEATABLE:
        case K_REPLACE:
        case K_RESET:
        case K_RESTART:
        case K_RESUMABLE:
        case K_RESUME:
        case K_RESTRICT:
        case K_RESTRICTED:
        case K_ROLLBACK:
        case K_ROOT:
        case K_ROW:
        case K_ROWS:
        case K_SAVEPOINT:
        case K_SCHEMA:
        case K_SEED:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SETS:
        case K_SHOW:
        case K_SHUTDOWN:
        case K_SIBLINGS:
        case K_SIMILAR:
        case K_SIZE:
        case K_SKIP:
        case K_START:
        case K_STORED:
        case K_STRING:
        case K_SUSPEND:
        case K_SWITCH:
        case K_SYNONYM:
        case K_SYSTEM:
        case K_TABLE:
        case K_TABLES:
        case K_TABLESPACE:
        case K_TRIGGER:
        case K_THEN:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TUMBLING:
        case K_TYPE:
        case K_UNLOGGED:
        case K_UPDATE:
        case K_UPSERT:
        case K_UNQIESCE:
        case K_USER:
        case K_SIGNED:
        case K_STRING_FUNCTION_NAME:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VERBOSE:
        case K_VIEW:
        case K_WAIT:
        case K_WITHIN:
        case K_WITHOUT:
        case K_WORK:
        case K_XML:
        case K_XMLAGG:
        case K_XMLDATA:
        case K_XMLSCHEMA:
        case K_XMLTEXT:
        case K_XSINIL:
        case K_YAML:
        case K_YES:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:
        case 385:
        case 386:
        case 387:
        case 388:
        case 389:{
          sk3 = RelObjectName();
          jj_consume_token(K_COMMENT);
          tk = jj_consume_token(S_CHAR_LITERAL);
alterExp.withColumnName(sk3).withCommentText(tk.image);
          break;
          }
        default:
          jj_la1[483] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case K_CHANGE:{
      jj_consume_token(K_CHANGE);
alterExp.setOperation(AlterOperation.CHANGE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COLUMN:{
        jj_consume_token(K_COLUMN);
alterExp.hasColumn(true); alterExp.setOptionalSpecifier("COLUMN");
        break;
        }
      default:
        jj_la1[484] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[485] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.withColumnOldName(tk.image).addColDataType(alterExpressionColumnDataType);
      break;
      }
    case K_DROP:{
      jj_consume_token(K_DROP);
alterExp.setOperation(AlterOperation.DROP);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COLUMN:
      case K_IF:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 379:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 379:{
          // we use the PK Columns Field instead of the Column Field
                              // for holding multiple DROP Columns
                              columnNames = ColumnsNamesList();
alterExp.setPkColumns(columnNames); columnNames = null;
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 434:{
            jj_consume_token(434);
alterExp.addParameters("INVALIDATE");
            break;
            }
          default:
            jj_la1[486] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            jj_consume_token(K_CASCADE);
alterExp.addParameters("CASCADE");
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 435:{
              jj_consume_token(435);
alterExp.addParameters("CONSTRAINTS");
              break;
              }
            default:
              jj_la1[487] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[488] = jj_gen;
            ;
          }
          break;
          }
        case K_COLUMN:
        case K_IF:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          if (jj_2_336(2)) {
            jj_consume_token(K_COLUMN);
alterExp.hasColumn(true);
          } else {
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_IF:{
            jj_consume_token(K_IF);
            jj_consume_token(K_EXISTS);
alterExp.setUsingIfExists(true);
            break;
            }
          default:
            jj_la1[489] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_IDENTIFIER:{
            tk = jj_consume_token(S_IDENTIFIER);
            break;
            }
          case S_QUOTED_IDENTIFIER:{
            tk = jj_consume_token(S_QUOTED_IDENTIFIER);
            break;
            }
          default:
            jj_la1[490] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
alterExp.setColumnName(tk.image);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 434:{
            jj_consume_token(434);
alterExp.addParameters("INVALIDATE");
            break;
            }
          default:
            jj_la1[491] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            jj_consume_token(K_CASCADE);
alterExp.addParameters("CASCADE");
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 435:{
              jj_consume_token(435);
alterExp.addParameters("CONSTRAINTS");
              break;
              }
            default:
              jj_la1[492] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[493] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[494] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_INDEX:{
        tk = jj_consume_token(K_INDEX);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk2 = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[495] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
index = new Index().withType(tk.image).withName(tk2.image);
                       alterExp.setIndex(index);
        break;
        }
      case K_UNIQUE:{
        tk = jj_consume_token(K_UNIQUE);
alterExp.setOperation(AlterOperation.DROP_UNIQUE);
        columnNames = ColumnsNamesList();
alterExp.setPkColumns(columnNames); columnNames = null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CASCADE:
        case K_RESTRICT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            tk = jj_consume_token(K_CASCADE);
            break;
            }
          case K_RESTRICT:{
            tk = jj_consume_token(K_RESTRICT);
            break;
            }
          default:
            jj_la1[496] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
alterExp.addParameters(tk.image);
          break;
          }
        default:
          jj_la1[497] = jj_gen;
          ;
        }
        break;
        }
      case K_PRIMARY:{
        tk = jj_consume_token(K_PRIMARY);
        tk2 = jj_consume_token(K_KEY);
alterExp.setOperation(AlterOperation.DROP_PRIMARY_KEY);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CASCADE:
        case K_RESTRICT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            tk = jj_consume_token(K_CASCADE);
            break;
            }
          case K_RESTRICT:{
            tk = jj_consume_token(K_RESTRICT);
            break;
            }
          default:
            jj_la1[498] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
alterExp.addParameters(tk.image);
          break;
          }
        default:
          jj_la1[499] = jj_gen;
          ;
        }
        break;
        }
      case K_FOREIGN:{
        tk = jj_consume_token(K_FOREIGN);
        tk2 = jj_consume_token(K_KEY);
alterExp.setOperation(AlterOperation.DROP_FOREIGN_KEY);
        columnNames = ColumnsNamesList();
alterExp.setPkColumns(columnNames); columnNames = null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CASCADE:
        case K_RESTRICT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            tk = jj_consume_token(K_CASCADE);
            break;
            }
          case K_RESTRICT:{
            tk = jj_consume_token(K_RESTRICT);
            break;
            }
          default:
            jj_la1[500] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
alterExp.addParameters(tk.image);
          break;
          }
        default:
          jj_la1[501] = jj_gen;
          ;
        }
        break;
        }
      case K_CONSTRAINT:{
        jj_consume_token(K_CONSTRAINT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_IF:{
          jj_consume_token(K_IF);
          jj_consume_token(K_EXISTS);
alterExp.setUsingIfExists(true);
          break;
          }
        default:
          jj_la1[502] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[503] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setConstraintName(tk.image);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CASCADE:
        case K_RESTRICT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            tk = jj_consume_token(K_CASCADE);
            break;
            }
          case K_RESTRICT:{
            tk = jj_consume_token(K_RESTRICT);
            break;
            }
          default:
            jj_la1[504] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
alterExp.addParameters(tk.image);
          break;
          }
        default:
          jj_la1[505] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[506] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_ALGORITHM:{
      jj_consume_token(K_ALGORITHM);
alterExp.setOperation(AlterOperation.ALGORITHM);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 381:{
        jj_consume_token(381);
alterExp.setUseEqual(true);
        break;
        }
      default:
        jj_la1[507] = jj_gen;
        ;
      }
      sk3 = RelObjectName();
alterExp.addParameters(sk3);
      break;
      }
    default:
      jj_la1[512] = jj_gen;
      if (jj_2_337(2)) {
        jj_consume_token(K_RENAME);
alterExp.setOperation(AlterOperation.RENAME);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COLUMN:{
          jj_consume_token(K_COLUMN);
alterExp.hasColumn(true);
          break;
          }
        default:
          jj_la1[508] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[509] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setColOldName(tk.image);
        jj_consume_token(K_TO);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk2 = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[510] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setColumnName(tk2.image);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_RENAME:{
          jj_consume_token(K_RENAME);
          jj_consume_token(K_TO);
alterExp.setOperation(AlterOperation.RENAME_TABLE);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_IDENTIFIER:{
            tk2 = jj_consume_token(S_IDENTIFIER);
            break;
            }
          case S_QUOTED_IDENTIFIER:{
            tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
            break;
            }
          default:
            jj_la1[511] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
alterExp.setNewTableName(tk2.image);
          break;
          }
        case K_COMMENT:{
          jj_consume_token(K_COMMENT);
alterExp.setOperation(AlterOperation.COMMENT);
          tk = jj_consume_token(S_CHAR_LITERAL);
alterExp.setCommentText(tk.image);
          break;
          }
        default:
          jj_la1[513] = jj_gen;
          tokens = captureRest();
alterExp.setOperation(AlterOperation.UNSPECIFIC);
                    StringBuilder optionalSpecifier = new StringBuilder();
                    int i=0;

                    for (String s: tokens)
                        if (! (s.equals(";") || s.equals("\n\n\n")) ) {
                            if (i>0)
                                optionalSpecifier.append( " " );
                            optionalSpecifier.append( s );
                            i++;
                        }

                    alterExp.setOptionalSpecifier( optionalSpecifier.toString() );
        }
      }
    }
return alterExp;
}

  final public Statement Alter() throws ParseException {Statement statement;
    List<String> captureRest;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ALTER:{
      jj_consume_token(K_ALTER);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TABLE:{
        statement = AlterTable();
        break;
        }
      case K_SESSION:{
        statement = AlterSession();
        break;
        }
      case K_VIEW:{
        statement = AlterView(false);
        break;
        }
      case K_SYSTEM:{
        statement = AlterSystemStatement();
        break;
        }
      case K_SEQUENCE:{
        statement = AlterSequence();
        break;
        }
      default:
        jj_la1[514] = jj_gen;
        captureRest = captureRest();
statement = new UnsupportedStatement("ALTER", captureRest);
      }
      break;
      }
    case K_REPLACE:{
      jj_consume_token(K_REPLACE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_VIEW:{
        statement = AlterView(true);
        break;
        }
      default:
        jj_la1[515] = jj_gen;
        captureRest = captureRest();
statement = new UnsupportedStatement("REPLACE", captureRest);
      }
      break;
      }
    default:
      jj_la1[516] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return statement;
}

  final public Alter AlterTable() throws ParseException {Alter alter = new Alter();
    Table table;
    AlterExpression alterExp;
    boolean usingIfExists = false;
    jj_consume_token(K_TABLE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ONLY:{
      jj_consume_token(K_ONLY);
alter.setUseOnly(true);
      break;
      }
    default:
      jj_la1[517] = jj_gen;
      ;
    }
    if (jj_2_338(2)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_EXISTS);
usingIfExists = true;
    } else {
      ;
    }
    table = Table();
alter.setTable(table);
    alterExp = AlterExpression();
if (usingIfExists)
                                    alter.addAlterExpression( alterExp.withUsingIfExists(true) );
                                  else
                                    alter.addAlterExpression(alterExp);
    label_88:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[518] = jj_gen;
        break label_88;
      }
      jj_consume_token(K_COMMA);
      alterExp = AlterExpression();
alter.addAlterExpression(alterExp);
    }
return alter;
}

  final public AlterSession AlterSession() throws ParseException {AlterSessionOperation operation = null;
    List<String> parameters = new ArrayList<String>();
    Token token;
    jj_consume_token(K_SESSION);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ADVISE:{
      jj_consume_token(K_ADVISE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMIT:{
        jj_consume_token(K_COMMIT);
operation = AlterSessionOperation.ADVISE_COMMIT;
        break;
        }
      case K_ROLLBACK:{
        jj_consume_token(K_ROLLBACK);
operation = AlterSessionOperation.ADVISE_ROLLBACK;
        break;
        }
      case K_NOTHING:{
        jj_consume_token(K_NOTHING);
operation = AlterSessionOperation.ADVISE_NOTHING;
        break;
        }
      default:
        jj_la1[519] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_CLOSE:{
      jj_consume_token(K_CLOSE);
      jj_consume_token(K_DATABASE);
      jj_consume_token(K_LINK);
operation = AlterSessionOperation.CLOSE_DATABASE_LINK;
      break;
      }
    case K_ENABLE:{
      jj_consume_token(K_ENABLE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMIT:{
        jj_consume_token(K_COMMIT);
        jj_consume_token(K_IN);
        jj_consume_token(K_PROCEDURE);
operation = AlterSessionOperation.ENABLE_COMMIT_IN_PROCEDURE;
        break;
        }
      case K_GUARD:{
        jj_consume_token(K_GUARD);
operation = AlterSessionOperation.ENABLE_GUARD;
        break;
        }
      case K_PARALLEL:{
        jj_consume_token(K_PARALLEL);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DML:{
          jj_consume_token(K_DML);
operation = AlterSessionOperation.ENABLE_PARALLEL_DML;
          break;
          }
        case K_DDL:{
          jj_consume_token(K_DDL);
operation = AlterSessionOperation.ENABLE_PARALLEL_DDL;
          break;
          }
        case K_QUERY:{
          jj_consume_token(K_QUERY);
operation = AlterSessionOperation.ENABLE_PARALLEL_QUERY;
          break;
          }
        default:
          jj_la1[520] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_RESUMABLE:{
        jj_consume_token(K_RESUMABLE);
operation = AlterSessionOperation.ENABLE_RESUMABLE;
        break;
        }
      default:
        jj_la1[521] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_DISABLE:{
      jj_consume_token(K_DISABLE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMIT:{
        jj_consume_token(K_COMMIT);
        jj_consume_token(K_IN);
        jj_consume_token(K_PROCEDURE);
operation = AlterSessionOperation.DISABLE_COMMIT_IN_PROCEDURE;
        break;
        }
      case K_GUARD:{
        jj_consume_token(K_GUARD);
operation = AlterSessionOperation.DISABLE_GUARD;
        break;
        }
      case K_PARALLEL:{
        jj_consume_token(K_PARALLEL);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DML:{
          jj_consume_token(K_DML);
operation = AlterSessionOperation.DISABLE_PARALLEL_DML;
          break;
          }
        case K_DDL:{
          jj_consume_token(K_DDL);
operation = AlterSessionOperation.DISABLE_PARALLEL_DDL;
          break;
          }
        case K_QUERY:{
          jj_consume_token(K_QUERY);
operation = AlterSessionOperation.DISABLE_PARALLEL_QUERY;
          break;
          }
        default:
          jj_la1[522] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_RESUMABLE:{
        jj_consume_token(K_RESUMABLE);
operation = AlterSessionOperation.DISABLE_RESUMABLE;
        break;
        }
      default:
        jj_la1[523] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_FORCE:{
      jj_consume_token(K_FORCE);
      jj_consume_token(K_PARALLEL);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DML:{
        jj_consume_token(K_DML);
operation = AlterSessionOperation.FORCE_PARALLEL_DML;
        break;
        }
      case K_DDL:{
        jj_consume_token(K_DDL);
operation = AlterSessionOperation.FORCE_PARALLEL_DDL;
        break;
        }
      case K_QUERY:{
        jj_consume_token(K_QUERY);
operation = AlterSessionOperation.FORCE_PARALLEL_QUERY;
        break;
        }
      default:
        jj_la1[524] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_SET:{
      jj_consume_token(K_SET);
operation = AlterSessionOperation.SET;
      break;
      }
    default:
      jj_la1[525] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_89:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_PARALLEL:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case 381:{
        ;
        break;
        }
      default:
        jj_la1[526] = jj_gen;
        break label_89;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_CHAR_LITERAL:{
        token = jj_consume_token(S_CHAR_LITERAL);
        break;
        }
      case S_IDENTIFIER:{
        token = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case 381:{
        token = jj_consume_token(381);
        break;
        }
      case S_LONG:{
        token = jj_consume_token(S_LONG);
        break;
        }
      case K_PARALLEL:{
        token = jj_consume_token(K_PARALLEL);
        break;
        }
      default:
        jj_la1[527] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
parameters.add( token.image );
    }
return new AlterSession(operation, parameters);
}

  final public AlterSystemStatement AlterSystemStatement() throws ParseException {AlterSystemOperation operation = null;
    List<String> parameters = new LinkedList<String>();
    jj_consume_token(K_SYSTEM);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ARCHIVE:{
      jj_consume_token(K_ARCHIVE);
      jj_consume_token(K_LOG);
operation = AlterSystemOperation.ARCHIVE_LOG;
      break;
      }
    case K_CHECKPOINT:{
      jj_consume_token(K_CHECKPOINT);
operation = AlterSystemOperation.CHECKPOINT;
      break;
      }
    case K_DUMP:{
      jj_consume_token(K_DUMP);
      jj_consume_token(K_ACTIVE);
      jj_consume_token(K_SESSION);
      jj_consume_token(K_HISTORY);
operation = AlterSystemOperation.DUMP_ACTIVE_SESSION_HISTORY;
      break;
      }
    case K_ENABLE:{
      jj_consume_token(K_ENABLE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 436:{
        jj_consume_token(436);
operation = AlterSystemOperation.ENABLE_DISTRIBUTED_RECOVERY;
        break;
        }
      case 437:{
        jj_consume_token(437);
operation = AlterSystemOperation.ENABLE_DISTRIBUTED_RECOVERY;
        break;
        }
      default:
        jj_la1[528] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_DISABLE:{
      jj_consume_token(K_DISABLE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 436:{
        jj_consume_token(436);
operation = AlterSystemOperation.DISABLE_DISTRIBUTED_RECOVERY;
        break;
        }
      case 437:{
        jj_consume_token(437);
operation = AlterSystemOperation.DISABLE_RESTRICTED_SESSION;
        break;
        }
      default:
        jj_la1[529] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_FLUSH:{
      jj_consume_token(K_FLUSH);
operation = AlterSystemOperation.FLUSH;
      break;
      }
    case K_DISCONNECT:{
      jj_consume_token(K_DISCONNECT);
      jj_consume_token(K_SESSION);
operation = AlterSystemOperation.DISCONNECT_SESSION;
      break;
      }
    case 438:{
      jj_consume_token(438);
operation = AlterSystemOperation.KILL_SESSION;
      break;
      }
    case K_SWITCH:{
      jj_consume_token(K_SWITCH);
operation = AlterSystemOperation.SWITCH;
      break;
      }
    case K_SUSPEND:{
      jj_consume_token(K_SUSPEND);
operation = AlterSystemOperation.SUSPEND;
      break;
      }
    case K_RESUME:{
      jj_consume_token(K_RESUME);
operation = AlterSystemOperation.RESUME;
      break;
      }
    case K_QUIESCE:{
      jj_consume_token(K_QUIESCE);
      jj_consume_token(K_RESTRICTED);
operation = AlterSystemOperation.QUIESCE;
      break;
      }
    case 439:{
      jj_consume_token(439);
operation = AlterSystemOperation.UNQUIESCE;
      break;
      }
    case K_SHUTDOWN:{
      jj_consume_token(K_SHUTDOWN);
operation = AlterSystemOperation.SHUTDOWN;
      break;
      }
    case K_REGISTER:{
      jj_consume_token(K_REGISTER);
operation = AlterSystemOperation.REGISTER;
      break;
      }
    case K_SET:{
      jj_consume_token(K_SET);
operation = AlterSystemOperation.SET;
      break;
      }
    case K_RESET:{
      jj_consume_token(K_RESET);
operation = AlterSystemOperation.RESET;
      break;
      }
    default:
      jj_la1[530] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    parameters = captureRest();
return new AlterSystemStatement(operation, parameters);
}

  final public Wait Wait() throws ParseException {Wait wait = new Wait();
    Token token = null;
    jj_consume_token(K_WAIT);
    token = jj_consume_token(S_LONG);
wait.setTimeout(Long.parseLong(token.image));
        return wait;
}

  final public SavepointStatement SavepointStatement() throws ParseException {SavepointStatement savepointStatement;
    jj_consume_token(K_SAVEPOINT);
    token = jj_consume_token(S_IDENTIFIER);
savepointStatement = new SavepointStatement(token.image);
        return savepointStatement;
}

  final public RollbackStatement RollbackStatement() throws ParseException {RollbackStatement rollbackStatement;
    boolean usingWorkKeyword=false;
    boolean usingSavepointKeyword=false;
    String savepointName=null;
    String forceDistributedTransactionIdentifier=null;
    jj_consume_token(K_ROLLBACK);
rollbackStatement = new RollbackStatement();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WORK:{
      jj_consume_token(K_WORK);
rollbackStatement.setUsingWorkKeyword(true);
      break;
      }
    default:
      jj_la1[531] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FORCE:
    case K_TO:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TO:{
        jj_consume_token(K_TO);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SAVEPOINT:{
          jj_consume_token(K_SAVEPOINT);
rollbackStatement.setUsingSavepointKeyword(true);
          break;
          }
        default:
          jj_la1[532] = jj_gen;
          ;
        }
        token = jj_consume_token(S_IDENTIFIER);
rollbackStatement.setSavepointName(token.image);
        break;
        }
      case K_FORCE:{
        jj_consume_token(K_FORCE);
        token = jj_consume_token(S_CHAR_LITERAL);
rollbackStatement.setForceDistributedTransactionIdentifier(token.image);
        break;
        }
      default:
        jj_la1[533] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[534] = jj_gen;
      ;
    }
return rollbackStatement;
}

  final public Commit Commit() throws ParseException {Commit commit=new Commit();
    jj_consume_token(K_COMMIT);
return commit;
}

  final public Comment Comment() throws ParseException {Comment result = new Comment();
    Table table;
    Table view;
    Column column;
    Token comment;
    jj_consume_token(K_COMMENT);
    jj_consume_token(K_ON);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TABLE:{
      jj_consume_token(K_TABLE);
      table = Table();
result.setTable(table);
      break;
      }
    case K_COLUMN:{
      jj_consume_token(K_COLUMN);
      column = Column();
result.setColumn(column);
      break;
      }
    case K_VIEW:{
      jj_consume_token(K_VIEW);
      view = Table();
result.setView(view);
      break;
      }
    default:
      jj_la1[535] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_IS);
    comment = jj_consume_token(S_CHAR_LITERAL);
result.setComment(new StringValue(comment.image));
        return result;
}

  final public Grant Grant() throws ParseException {Grant grant = new Grant();
        ArrayList<String> privileges = new ArrayList<String>();
        List<String> users;
        Token tk = null;
        List<String> objName;
    jj_consume_token(K_GRANT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ALTER:
    case K_DELETE:
    case K_DROP:
    case K_EXECUTE:
    case K_INSERT:
    case K_ON:
    case K_SELECT:
    case K_UPDATE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ALTER:
      case K_DELETE:
      case K_DROP:
      case K_EXECUTE:
      case K_INSERT:
      case K_SELECT:
      case K_UPDATE:{
        readGrantTypes(privileges);
        label_90:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[536] = jj_gen;
            break label_90;
          }
          jj_consume_token(K_COMMA);
          readGrantTypes(privileges);
        }
        break;
        }
      default:
        jj_la1[537] = jj_gen;
        ;
      }
      jj_consume_token(K_ON);
      objName = RelObjectNameList();
grant.setObjectName(objName);
      break;
      }
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
grant.setRole(tk.image);
      break;
      }
    default:
      jj_la1[538] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_TO);
    users = UsersList();
grant.setUsers(users);
if(privileges.size() > 0) {
                grant.setPrivileges(privileges);
            }
                return grant;
}

  final public List<String> UsersList() throws ParseException {List<String> users = new ArrayList<String>();
    String user = null;
    user = RelObjectName();
users.add(user);
    label_91:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[539] = jj_gen;
        break label_91;
      }
      jj_consume_token(K_COMMA);
      user = ColumnsNamesListItem();
users.add(user);
    }
return users;
}

  final public void readGrantTypes(ArrayList<String> privileges) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SELECT:{
      jj_consume_token(K_SELECT);
privileges.add("SELECT");
      break;
      }
    case K_INSERT:{
      jj_consume_token(K_INSERT);
privileges.add("INSERT");
      break;
      }
    case K_UPDATE:{
      jj_consume_token(K_UPDATE);
privileges.add("UPDATE");
      break;
      }
    case K_DELETE:{
      jj_consume_token(K_DELETE);
privileges.add("DELETE");
      break;
      }
    case K_EXECUTE:{
      jj_consume_token(K_EXECUTE);
privileges.add("EXECUTE");
      break;
      }
    case K_ALTER:{
      jj_consume_token(K_ALTER);
privileges.add("ALTER");
      break;
      }
    case K_DROP:{
      jj_consume_token(K_DROP);
privileges.add("DROP");
      break;
      }
    default:
      jj_la1[540] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public Sequence Sequence() throws ParseException {/*@bgen(jjtree) Sequence */
    SimpleNode jjtn000 = new SimpleNode(JJTSEQUENCE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));List<String> data = new ArrayList<String>();
    String serverName = null, databaseName = null, schemaName = null, sequenceName = null;
    try {
      data = RelObjectNameList();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Sequence sequence = new Sequence(data);
                linkAST(sequence,jjtn000);
        return sequence;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public List<Sequence.Parameter> SequenceParameters() throws ParseException {List<Sequence.Parameter> sequenceParameters = new ArrayList<Sequence.Parameter>();
  Sequence.Parameter parameter = null;
  Token token = null;
    label_92:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CACHE:
      case K_CYCLE:
      case K_GLOBAL:
      case K_INCREMENT:
      case K_KEEP:
      case K_MAXVALUE:
      case K_MINVALUE:
      case K_NOCACHE:
      case K_NOCYCLE:
      case K_NOKEEP:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_ORDER:
      case K_RESTART:
      case K_SESSION:
      case K_START:{
        ;
        break;
        }
      default:
        jj_la1[541] = jj_gen;
        break label_92;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_INCREMENT:{
        jj_consume_token(K_INCREMENT);
        jj_consume_token(K_BY);
        token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.INCREMENT_BY);
        parameter.setValue(Long.parseLong(token.image));
        sequenceParameters.add(parameter);
        break;
        }
      case K_START:{
        jj_consume_token(K_START);
        jj_consume_token(K_WITH);
        token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.START_WITH);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
        break;
        }
      case K_RESTART:{
        jj_consume_token(K_RESTART);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WITH:{
          jj_consume_token(K_WITH);
          token = jj_consume_token(S_LONG);
          break;
          }
        default:
          jj_la1[542] = jj_gen;
          ;
        }
parameter = new Sequence.Parameter(Sequence.ParameterType.RESTART_WITH);
      if(token != null){
        parameter.setValue(Long.parseLong(token.image));
      }
      sequenceParameters.add(parameter);
        break;
        }
      case K_MAXVALUE:
      case K_NOMAXVALUE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOMAXVALUE:{
          jj_consume_token(K_NOMAXVALUE);
parameter = new Sequence.Parameter(Sequence.ParameterType.NOMAXVALUE);
      sequenceParameters.add(parameter);
          break;
          }
        case K_MAXVALUE:{
          jj_consume_token(K_MAXVALUE);
          token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.MAXVALUE);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
          break;
          }
        default:
          jj_la1[543] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_MINVALUE:
      case K_NOMINVALUE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOMINVALUE:{
          jj_consume_token(K_NOMINVALUE);
parameter = new Sequence.Parameter(Sequence.ParameterType.NOMINVALUE);
      sequenceParameters.add(parameter);
          break;
          }
        case K_MINVALUE:{
          jj_consume_token(K_MINVALUE);
          token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.MINVALUE);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
          break;
          }
        default:
          jj_la1[544] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_CYCLE:
      case K_NOCYCLE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOCYCLE:{
          jj_consume_token(K_NOCYCLE);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.NOCYCLE));
          break;
          }
        case K_CYCLE:{
          jj_consume_token(K_CYCLE);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.CYCLE));
          break;
          }
        default:
          jj_la1[545] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_CACHE:
      case K_NOCACHE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOCACHE:{
          jj_consume_token(K_NOCACHE);
parameter = new Sequence.Parameter(Sequence.ParameterType.NOCACHE);
      sequenceParameters.add(parameter);
          break;
          }
        case K_CACHE:{
          jj_consume_token(K_CACHE);
          token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.CACHE);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
          break;
          }
        default:
          jj_la1[546] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_NOORDER:
      case K_ORDER:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ORDER:{
          jj_consume_token(K_ORDER);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.ORDER));
          break;
          }
        case K_NOORDER:{
          jj_consume_token(K_NOORDER);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.NOORDER));
          break;
          }
        default:
          jj_la1[547] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_KEEP:
      case K_NOKEEP:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_KEEP:{
          jj_consume_token(K_KEEP);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.KEEP));
          break;
          }
        case K_NOKEEP:{
          jj_consume_token(K_NOKEEP);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.NOKEEP));
          break;
          }
        default:
          jj_la1[548] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_GLOBAL:
      case K_SESSION:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SESSION:{
          jj_consume_token(K_SESSION);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.SESSION));
          break;
          }
        case K_GLOBAL:{
          jj_consume_token(K_GLOBAL);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.GLOBAL));
          break;
          }
        default:
          jj_la1[549] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[550] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return sequenceParameters;
}

  final public CreateSequence CreateSequence() throws ParseException {CreateSequence createSequence = new CreateSequence();
  Sequence sequence;
  List<Sequence.Parameter> sequenceParameters;
    jj_consume_token(K_SEQUENCE);
    sequence = Sequence();
createSequence.setSequence(sequence);
    sequenceParameters = SequenceParameters();
sequence.setParameters(sequenceParameters);
        return createSequence;
}

  final public AlterSequence AlterSequence() throws ParseException {AlterSequence alterSequence = new AlterSequence();
  Sequence sequence;
  List<Sequence.Parameter> sequenceParameters;
    jj_consume_token(K_SEQUENCE);
    sequence = Sequence();
alterSequence.setSequence(sequence);
    sequenceParameters = SequenceParameters();
sequence.setParameters(sequenceParameters);
        return alterSequence;
}

  final public Statement Create() throws ParseException {boolean isUsingOrReplace=false;
    Token tk;
    Statement statement;
    List<String> captureRest;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OR:{
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
isUsingOrReplace = true;
      break;
      }
    default:
      jj_la1[551] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FUNCTION:
    case K_PROCEDURE:{
      statement = CreateFunctionStatement(isUsingOrReplace);
      break;
      }
    case K_SCHEMA:{
      statement = CreateSchema();
      break;
      }
    case K_SEQUENCE:{
      statement = CreateSequence();
      break;
      }
    case K_PUBLIC:
    case K_SYNONYM:{
      statement = CreateSynonym(isUsingOrReplace);
      break;
      }
    default:
      jj_la1[553] = jj_gen;
      if (jj_2_339(3)) {
        statement = CreateTable(isUsingOrReplace);
      } else if (jj_2_340(2)) {
        statement = CreateView(isUsingOrReplace);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DOMAIN:
        case K_TRIGGER:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_TRIGGER:{
            tk = jj_consume_token(K_TRIGGER);
            break;
            }
          case K_DOMAIN:{
            tk = jj_consume_token(K_DOMAIN);
            break;
            }
          default:
            jj_la1[552] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          captureRest = captureRest();
statement = new UnsupportedStatement("CREATE " + tk.image, captureRest);
          break;
          }
        case K_ARRAY_LITERAL:
        case K_AS:
        case K_ASC:
        case K_BINARY:
        case K_BY:
        case K_CASCADE:
        case K_CHARACTER:
        case K_CHECK:
        case K_COLLATE:
        case K_COMMIT:
        case K_COMMENT:
        case K_CONSTRAINT:
        case K_DEFAULT:
        case K_DELETE:
        case K_DESC:
        case K_DROP:
        case K_EXCLUDE:
        case K_FALSE:
        case K_FOREIGN:
        case K_IN:
        case K_INDEX:
        case K_KEY:
        case K_NEXTVAL:
        case K_NOT:
        case K_NULL:
        case K_ON:
        case K_PARALLEL:
        case K_PARTITION:
        case K_PRIMARY:
        case K_REFERENCES:
        case K_ROWS:
        case K_START:
        case K_STORED:
        case K_TABLESPACE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIME_KEY_EXPR:
        case K_TRUE:
        case K_TYPE:
        case K_UNIQUE:
        case K_UPDATE:
        case K_USING:
        case K_UNSIGNED:
        case K_WHERE:
        case K_WITH:
        case S_DOUBLE:
        case S_LONG:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:
        case 379:
        case 381:
        case 393:
        case 405:
        case 423:{
          /* @fixme
                   *  Create Index uses CreateParameter() which allows all kind of tokens
                   *  it can conflict with other statements and must be at the end right now
                   */
                  statement = CreateIndex();
          break;
          }
        default:
          jj_la1[554] = jj_gen;
          captureRest = captureRest();
statement = new UnsupportedStatement("CREATE", captureRest);
        }
      }
    }
return statement;
}

  final public CreateFunctionalStatement CreateFunctionStatement(boolean isUsingOrReplace) throws ParseException {CreateFunctionalStatement type = null;
  List<String> tokens = new LinkedList<String>();
  String statementType = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FUNCTION:{
      jj_consume_token(K_FUNCTION);
statementType = "FUNCTION";
      break;
      }
    case K_PROCEDURE:{
      jj_consume_token(K_PROCEDURE);
statementType = "PROCEDURE";
      break;
      }
    default:
      jj_la1[555] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    tokens = captureFunctionBody();
if(statementType.equals("FUNCTION")) {
      type = new CreateFunction(isUsingOrReplace, tokens);
    }
    if(statementType.equals("PROCEDURE")) {
      type = new CreateProcedure(isUsingOrReplace, tokens);
    }

    return type;
}

  final public CreateSynonym CreateSynonym(boolean isUsingOrReplace) throws ParseException {CreateSynonym createSynonym = new CreateSynonym();
  Synonym synonym;
  boolean publicSynonym = false;
  List<String> data = new ArrayList<String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PUBLIC:{
      jj_consume_token(K_PUBLIC);
publicSynonym = true;
      break;
      }
    default:
      jj_la1[556] = jj_gen;
      ;
    }
    jj_consume_token(K_SYNONYM);
    synonym = Synonym();
createSynonym.setSynonym(synonym);
    jj_consume_token(K_FOR);
    data = RelObjectNameList();
createSynonym.setOrReplace(isUsingOrReplace);
    createSynonym.setPublicSynonym(publicSynonym);
    createSynonym.setForList(data);
    return createSynonym;
}

  final public Synonym Synonym() throws ParseException {/*@bgen(jjtree) Synonym */
    SimpleNode jjtn000 = new SimpleNode(JJTSYNONYM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));List<String> data = new ArrayList<String>();
    String serverName = null, databaseName = null, schemaName = null, sequenceName = null;
    try {
      data = RelObjectNameList();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Synonym synonym = new Synonym(data);
                linkAST(synonym,jjtn000);
        return synonym;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public UnsupportedStatement UnsupportedStatement() throws ParseException {List<String> tokens = new LinkedList<String>();
    tokens = captureUnsupportedStatementDeclaration();
return new UnsupportedStatement(tokens);
}

  List<String> captureRest() throws ParseException {List<String> tokens = new LinkedList<String>();
  Token tok;
  while(true) {
    tok = getToken(1);
    int l = tokens.size();
    if( tok.kind == EOF ) {
      break;
    } else if ( l>0 && ( tok.image.equals(".") ||  tokens.get(l-1).endsWith(".")) ) {
        tokens.set(l-1, tokens.get(l-1) + tok.image);
    } else {
        tokens.add(tok.image);
    }
    tok = getNextToken();
  }
  return tokens;
  }

  List<String> captureFunctionBody() throws ParseException {List<String> tokens = new LinkedList<String>();
  Token tok;
  boolean foundEnd = false;
  while(true) {
    tok = getToken(1);
    int l = tokens.size();
    if( tok.kind == EOF || ( foundEnd && tok.kind == ST_SEMICOLON) ) {
      if (tok.kind == ST_SEMICOLON) {
        tokens.add(tok.image);
      }
      break;
    } else if ( l>0 && ( tok.image.equals(".") ||  tokens.get(l-1).endsWith(".")) ) {
        tokens.set(l-1, tokens.get(l-1) + tok.image);
    } else {
        tokens.add(tok.image);
    }
    foundEnd |= (tok.kind == K_END)
        || ( tok.image.trim().startsWith("$$") && tok.image.trim().endsWith("$$")) ;

    tok = getNextToken();
  }
  return tokens;
  }

  List<String> captureUnsupportedStatementDeclaration() throws ParseException {List<String> tokens = new LinkedList<String>();
  Token tok;

  while(true) {
    tok = getToken(1);
    if( tok.kind == EOF || tok.kind== ST_SEMICOLON || tok.kind== K_END ) {
      break;
    }
    tokens.add(tok.image);
    tok = getNextToken();
  }
  return tokens;
  }

  final public String IdentifierChain() throws ParseException {String identifierChain;
    String part;
    identifierChain = RelObjectNameExt2();
    label_93:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 383:{
        ;
        break;
        }
      default:
        jj_la1[557] = jj_gen;
        break label_93;
      }
      jj_consume_token(383);
      part = RelObjectNameExt2();
identifierChain += "." + part;
    }
return identifierChain;
}

  final public Expression CharacterPrimary() throws ParseException {Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CONVERT:{
      expression = TranscodingFunction();
      break;
      }
    case K_TRIM:{
      expression = TrimFunction();
      break;
      }
    default:
      jj_la1[558] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return expression;
}

  final public TranscodingFunction TranscodingFunction() throws ParseException {Expression expression;
    String transcodingName;
    jj_consume_token(K_CONVERT);
    jj_consume_token(379);
    expression = Expression();
    jj_consume_token(K_USING);
    transcodingName = IdentifierChain();
    jj_consume_token(380);
return new TranscodingFunction(expression, transcodingName);
}

  final public TrimFunction TrimFunction() throws ParseException {TrimFunction.TrimSpecification trimSpecification=null;
    Expression expression = null;
    boolean usesFrom = false;
    Expression fromExpression = null;
    jj_consume_token(K_TRIM);
    jj_consume_token(379);
    if (jj_2_341(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LEADING:{
        jj_consume_token(K_LEADING);
trimSpecification = TrimFunction.TrimSpecification.LEADING;
        break;
        }
      case K_TRAILING:{
        jj_consume_token(K_TRAILING);
trimSpecification = TrimFunction.TrimSpecification.TRAILING;
        break;
        }
      case K_BOTH:{
        jj_consume_token(K_BOTH);
trimSpecification = TrimFunction.TrimSpecification.BOTH;
        break;
        }
      default:
        jj_la1[559] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    if (jj_2_342(1)) {
      expression = Expression();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_COMMA:
    case K_FROM:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        jj_consume_token(K_COMMA);
        break;
        }
      case K_FROM:{
        jj_consume_token(K_FROM);
usesFrom = true;
        break;
        }
      default:
        jj_la1[560] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      fromExpression = Expression();
      break;
      }
    default:
      jj_la1[561] = jj_gen;
      ;
    }
    jj_consume_token(380);
return new TrimFunction(trimSpecification, expression, fromExpression, usesFrom);
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_26()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_27()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_28()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_29()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_30()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_31()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_32()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_33()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_34()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_35()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_36()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_37()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_38()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_39()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_40()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_41()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_42()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_43()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_44()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_45()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_46()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_47()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_48()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_49()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_50()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_51()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_52()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_53()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_54()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_55()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_56()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_57()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_58()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_59()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_60()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_61()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_62()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_2_63(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_63()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  private boolean jj_2_64(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_64()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  private boolean jj_2_65(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_65()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  private boolean jj_2_66(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_66()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  private boolean jj_2_67(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_67()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  private boolean jj_2_68(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_68()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  private boolean jj_2_69(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_69()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  private boolean jj_2_70(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_70()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  private boolean jj_2_71(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_71()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  private boolean jj_2_72(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_72()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  private boolean jj_2_73(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_73()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  private boolean jj_2_74(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_74()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  private boolean jj_2_75(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_75()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  private boolean jj_2_76(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_76()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  private boolean jj_2_77(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_77()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  private boolean jj_2_78(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_78()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  private boolean jj_2_79(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_79()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  private boolean jj_2_80(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_80()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  private boolean jj_2_81(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_81()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  private boolean jj_2_82(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_82()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  private boolean jj_2_83(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_83()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  private boolean jj_2_84(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_84()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  private boolean jj_2_85(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_85()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  private boolean jj_2_86(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_86()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  private boolean jj_2_87(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_87()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  private boolean jj_2_88(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_88()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  private boolean jj_2_89(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_89()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  private boolean jj_2_90(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_90()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  private boolean jj_2_91(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_91()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  private boolean jj_2_92(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_92()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  private boolean jj_2_93(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_93()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  private boolean jj_2_94(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_94()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  private boolean jj_2_95(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_95()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  private boolean jj_2_96(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_96()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  private boolean jj_2_97(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_97()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  private boolean jj_2_98(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_98()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  private boolean jj_2_99(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_99()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  private boolean jj_2_100(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_100()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  private boolean jj_2_101(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_101()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(100, xla); }
  }

  private boolean jj_2_102(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_102()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(101, xla); }
  }

  private boolean jj_2_103(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_103()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(102, xla); }
  }

  private boolean jj_2_104(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_104()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(103, xla); }
  }

  private boolean jj_2_105(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_105()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(104, xla); }
  }

  private boolean jj_2_106(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_106()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(105, xla); }
  }

  private boolean jj_2_107(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_107()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(106, xla); }
  }

  private boolean jj_2_108(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_108()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(107, xla); }
  }

  private boolean jj_2_109(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_109()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(108, xla); }
  }

  private boolean jj_2_110(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_110()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(109, xla); }
  }

  private boolean jj_2_111(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_111()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(110, xla); }
  }

  private boolean jj_2_112(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_112()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(111, xla); }
  }

  private boolean jj_2_113(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_113()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(112, xla); }
  }

  private boolean jj_2_114(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_114()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(113, xla); }
  }

  private boolean jj_2_115(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_115()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(114, xla); }
  }

  private boolean jj_2_116(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_116()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(115, xla); }
  }

  private boolean jj_2_117(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_117()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(116, xla); }
  }

  private boolean jj_2_118(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_118()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(117, xla); }
  }

  private boolean jj_2_119(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_119()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(118, xla); }
  }

  private boolean jj_2_120(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_120()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(119, xla); }
  }

  private boolean jj_2_121(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_121()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(120, xla); }
  }

  private boolean jj_2_122(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_122()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(121, xla); }
  }

  private boolean jj_2_123(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_123()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(122, xla); }
  }

  private boolean jj_2_124(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_124()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(123, xla); }
  }

  private boolean jj_2_125(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_125()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(124, xla); }
  }

  private boolean jj_2_126(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_126()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(125, xla); }
  }

  private boolean jj_2_127(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_127()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(126, xla); }
  }

  private boolean jj_2_128(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_128()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(127, xla); }
  }

  private boolean jj_2_129(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_129()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(128, xla); }
  }

  private boolean jj_2_130(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_130()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(129, xla); }
  }

  private boolean jj_2_131(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_131()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(130, xla); }
  }

  private boolean jj_2_132(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_132()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(131, xla); }
  }

  private boolean jj_2_133(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_133()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(132, xla); }
  }

  private boolean jj_2_134(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_134()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(133, xla); }
  }

  private boolean jj_2_135(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_135()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(134, xla); }
  }

  private boolean jj_2_136(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_136()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(135, xla); }
  }

  private boolean jj_2_137(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_137()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(136, xla); }
  }

  private boolean jj_2_138(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_138()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(137, xla); }
  }

  private boolean jj_2_139(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_139()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(138, xla); }
  }

  private boolean jj_2_140(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_140()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(139, xla); }
  }

  private boolean jj_2_141(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_141()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(140, xla); }
  }

  private boolean jj_2_142(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_142()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(141, xla); }
  }

  private boolean jj_2_143(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_143()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(142, xla); }
  }

  private boolean jj_2_144(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_144()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(143, xla); }
  }

  private boolean jj_2_145(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_145()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(144, xla); }
  }

  private boolean jj_2_146(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_146()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(145, xla); }
  }

  private boolean jj_2_147(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_147()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(146, xla); }
  }

  private boolean jj_2_148(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_148()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(147, xla); }
  }

  private boolean jj_2_149(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_149()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(148, xla); }
  }

  private boolean jj_2_150(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_150()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(149, xla); }
  }

  private boolean jj_2_151(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_151()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(150, xla); }
  }

  private boolean jj_2_152(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_152()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(151, xla); }
  }

  private boolean jj_2_153(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_153()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(152, xla); }
  }

  private boolean jj_2_154(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_154()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(153, xla); }
  }

  private boolean jj_2_155(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_155()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(154, xla); }
  }

  private boolean jj_2_156(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_156()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(155, xla); }
  }

  private boolean jj_2_157(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_157()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(156, xla); }
  }

  private boolean jj_2_158(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_158()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(157, xla); }
  }

  private boolean jj_2_159(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_159()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(158, xla); }
  }

  private boolean jj_2_160(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_160()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(159, xla); }
  }

  private boolean jj_2_161(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_161()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(160, xla); }
  }

  private boolean jj_2_162(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_162()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(161, xla); }
  }

  private boolean jj_2_163(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_163()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(162, xla); }
  }

  private boolean jj_2_164(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_164()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(163, xla); }
  }

  private boolean jj_2_165(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_165()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(164, xla); }
  }

  private boolean jj_2_166(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_166()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(165, xla); }
  }

  private boolean jj_2_167(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_167()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(166, xla); }
  }

  private boolean jj_2_168(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_168()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(167, xla); }
  }

  private boolean jj_2_169(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_169()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(168, xla); }
  }

  private boolean jj_2_170(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_170()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(169, xla); }
  }

  private boolean jj_2_171(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_171()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(170, xla); }
  }

  private boolean jj_2_172(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_172()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(171, xla); }
  }

  private boolean jj_2_173(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_173()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(172, xla); }
  }

  private boolean jj_2_174(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_174()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(173, xla); }
  }

  private boolean jj_2_175(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_175()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(174, xla); }
  }

  private boolean jj_2_176(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_176()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(175, xla); }
  }

  private boolean jj_2_177(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_177()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(176, xla); }
  }

  private boolean jj_2_178(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_178()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(177, xla); }
  }

  private boolean jj_2_179(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_179()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(178, xla); }
  }

  private boolean jj_2_180(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_180()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(179, xla); }
  }

  private boolean jj_2_181(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_181()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(180, xla); }
  }

  private boolean jj_2_182(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_182()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(181, xla); }
  }

  private boolean jj_2_183(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_183()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(182, xla); }
  }

  private boolean jj_2_184(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_184()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(183, xla); }
  }

  private boolean jj_2_185(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_185()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(184, xla); }
  }

  private boolean jj_2_186(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_186()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(185, xla); }
  }

  private boolean jj_2_187(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_187()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(186, xla); }
  }

  private boolean jj_2_188(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_188()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(187, xla); }
  }

  private boolean jj_2_189(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_189()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(188, xla); }
  }

  private boolean jj_2_190(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_190()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(189, xla); }
  }

  private boolean jj_2_191(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_191()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(190, xla); }
  }

  private boolean jj_2_192(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_192()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(191, xla); }
  }

  private boolean jj_2_193(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_193()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(192, xla); }
  }

  private boolean jj_2_194(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_194()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(193, xla); }
  }

  private boolean jj_2_195(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_195()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(194, xla); }
  }

  private boolean jj_2_196(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_196()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(195, xla); }
  }

  private boolean jj_2_197(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_197()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(196, xla); }
  }

  private boolean jj_2_198(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_198()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(197, xla); }
  }

  private boolean jj_2_199(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_199()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(198, xla); }
  }

  private boolean jj_2_200(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_200()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(199, xla); }
  }

  private boolean jj_2_201(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_201()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(200, xla); }
  }

  private boolean jj_2_202(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_202()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(201, xla); }
  }

  private boolean jj_2_203(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_203()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(202, xla); }
  }

  private boolean jj_2_204(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_204()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(203, xla); }
  }

  private boolean jj_2_205(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_205()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(204, xla); }
  }

  private boolean jj_2_206(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_206()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(205, xla); }
  }

  private boolean jj_2_207(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_207()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(206, xla); }
  }

  private boolean jj_2_208(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_208()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(207, xla); }
  }

  private boolean jj_2_209(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_209()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(208, xla); }
  }

  private boolean jj_2_210(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_210()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(209, xla); }
  }

  private boolean jj_2_211(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_211()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(210, xla); }
  }

  private boolean jj_2_212(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_212()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(211, xla); }
  }

  private boolean jj_2_213(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_213()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(212, xla); }
  }

  private boolean jj_2_214(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_214()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(213, xla); }
  }

  private boolean jj_2_215(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_215()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(214, xla); }
  }

  private boolean jj_2_216(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_216()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(215, xla); }
  }

  private boolean jj_2_217(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_217()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(216, xla); }
  }

  private boolean jj_2_218(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_218()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(217, xla); }
  }

  private boolean jj_2_219(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_219()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(218, xla); }
  }

  private boolean jj_2_220(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_220()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(219, xla); }
  }

  private boolean jj_2_221(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_221()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(220, xla); }
  }

  private boolean jj_2_222(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_222()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(221, xla); }
  }

  private boolean jj_2_223(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_223()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(222, xla); }
  }

  private boolean jj_2_224(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_224()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(223, xla); }
  }

  private boolean jj_2_225(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_225()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(224, xla); }
  }

  private boolean jj_2_226(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_226()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(225, xla); }
  }

  private boolean jj_2_227(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_227()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(226, xla); }
  }

  private boolean jj_2_228(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_228()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(227, xla); }
  }

  private boolean jj_2_229(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_229()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(228, xla); }
  }

  private boolean jj_2_230(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_230()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(229, xla); }
  }

  private boolean jj_2_231(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_231()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(230, xla); }
  }

  private boolean jj_2_232(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_232()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(231, xla); }
  }

  private boolean jj_2_233(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_233()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(232, xla); }
  }

  private boolean jj_2_234(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_234()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(233, xla); }
  }

  private boolean jj_2_235(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_235()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(234, xla); }
  }

  private boolean jj_2_236(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_236()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(235, xla); }
  }

  private boolean jj_2_237(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_237()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(236, xla); }
  }

  private boolean jj_2_238(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_238()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(237, xla); }
  }

  private boolean jj_2_239(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_239()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(238, xla); }
  }

  private boolean jj_2_240(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_240()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(239, xla); }
  }

  private boolean jj_2_241(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_241()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(240, xla); }
  }

  private boolean jj_2_242(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_242()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(241, xla); }
  }

  private boolean jj_2_243(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_243()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(242, xla); }
  }

  private boolean jj_2_244(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_244()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(243, xla); }
  }

  private boolean jj_2_245(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_245()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(244, xla); }
  }

  private boolean jj_2_246(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_246()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(245, xla); }
  }

  private boolean jj_2_247(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_247()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(246, xla); }
  }

  private boolean jj_2_248(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_248()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(247, xla); }
  }

  private boolean jj_2_249(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_249()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(248, xla); }
  }

  private boolean jj_2_250(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_250()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(249, xla); }
  }

  private boolean jj_2_251(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_251()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(250, xla); }
  }

  private boolean jj_2_252(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_252()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(251, xla); }
  }

  private boolean jj_2_253(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_253()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(252, xla); }
  }

  private boolean jj_2_254(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_254()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(253, xla); }
  }

  private boolean jj_2_255(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_255()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(254, xla); }
  }

  private boolean jj_2_256(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_256()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(255, xla); }
  }

  private boolean jj_2_257(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_257()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(256, xla); }
  }

  private boolean jj_2_258(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_258()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(257, xla); }
  }

  private boolean jj_2_259(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_259()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(258, xla); }
  }

  private boolean jj_2_260(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_260()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(259, xla); }
  }

  private boolean jj_2_261(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_261()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(260, xla); }
  }

  private boolean jj_2_262(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_262()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(261, xla); }
  }

  private boolean jj_2_263(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_263()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(262, xla); }
  }

  private boolean jj_2_264(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_264()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(263, xla); }
  }

  private boolean jj_2_265(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_265()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(264, xla); }
  }

  private boolean jj_2_266(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_266()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(265, xla); }
  }

  private boolean jj_2_267(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_267()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(266, xla); }
  }

  private boolean jj_2_268(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_268()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(267, xla); }
  }

  private boolean jj_2_269(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_269()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(268, xla); }
  }

  private boolean jj_2_270(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_270()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(269, xla); }
  }

  private boolean jj_2_271(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_271()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(270, xla); }
  }

  private boolean jj_2_272(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_272()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(271, xla); }
  }

  private boolean jj_2_273(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_273()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(272, xla); }
  }

  private boolean jj_2_274(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_274()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(273, xla); }
  }

  private boolean jj_2_275(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_275()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(274, xla); }
  }

  private boolean jj_2_276(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_276()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(275, xla); }
  }

  private boolean jj_2_277(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_277()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(276, xla); }
  }

  private boolean jj_2_278(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_278()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(277, xla); }
  }

  private boolean jj_2_279(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_279()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(278, xla); }
  }

  private boolean jj_2_280(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_280()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(279, xla); }
  }

  private boolean jj_2_281(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_281()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(280, xla); }
  }

  private boolean jj_2_282(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_282()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(281, xla); }
  }

  private boolean jj_2_283(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_283()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(282, xla); }
  }

  private boolean jj_2_284(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_284()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(283, xla); }
  }

  private boolean jj_2_285(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_285()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(284, xla); }
  }

  private boolean jj_2_286(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_286()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(285, xla); }
  }

  private boolean jj_2_287(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_287()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(286, xla); }
  }

  private boolean jj_2_288(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_288()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(287, xla); }
  }

  private boolean jj_2_289(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_289()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(288, xla); }
  }

  private boolean jj_2_290(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_290()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(289, xla); }
  }

  private boolean jj_2_291(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_291()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(290, xla); }
  }

  private boolean jj_2_292(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_292()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(291, xla); }
  }

  private boolean jj_2_293(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_293()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(292, xla); }
  }

  private boolean jj_2_294(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_294()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(293, xla); }
  }

  private boolean jj_2_295(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_295()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(294, xla); }
  }

  private boolean jj_2_296(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_296()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(295, xla); }
  }

  private boolean jj_2_297(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_297()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(296, xla); }
  }

  private boolean jj_2_298(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_298()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(297, xla); }
  }

  private boolean jj_2_299(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_299()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(298, xla); }
  }

  private boolean jj_2_300(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_300()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(299, xla); }
  }

  private boolean jj_2_301(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_301()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(300, xla); }
  }

  private boolean jj_2_302(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_302()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(301, xla); }
  }

  private boolean jj_2_303(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_303()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(302, xla); }
  }

  private boolean jj_2_304(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_304()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(303, xla); }
  }

  private boolean jj_2_305(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_305()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(304, xla); }
  }

  private boolean jj_2_306(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_306()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(305, xla); }
  }

  private boolean jj_2_307(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_307()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(306, xla); }
  }

  private boolean jj_2_308(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_308()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(307, xla); }
  }

  private boolean jj_2_309(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_309()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(308, xla); }
  }

  private boolean jj_2_310(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_310()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(309, xla); }
  }

  private boolean jj_2_311(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_311()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(310, xla); }
  }

  private boolean jj_2_312(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_312()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(311, xla); }
  }

  private boolean jj_2_313(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_313()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(312, xla); }
  }

  private boolean jj_2_314(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_314()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(313, xla); }
  }

  private boolean jj_2_315(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_315()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(314, xla); }
  }

  private boolean jj_2_316(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_316()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(315, xla); }
  }

  private boolean jj_2_317(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_317()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(316, xla); }
  }

  private boolean jj_2_318(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_318()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(317, xla); }
  }

  private boolean jj_2_319(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_319()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(318, xla); }
  }

  private boolean jj_2_320(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_320()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(319, xla); }
  }

  private boolean jj_2_321(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_321()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(320, xla); }
  }

  private boolean jj_2_322(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_322()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(321, xla); }
  }

  private boolean jj_2_323(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_323()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(322, xla); }
  }

  private boolean jj_2_324(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_324()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(323, xla); }
  }

  private boolean jj_2_325(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_325()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(324, xla); }
  }

  private boolean jj_2_326(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_326()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(325, xla); }
  }

  private boolean jj_2_327(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_327()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(326, xla); }
  }

  private boolean jj_2_328(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_328()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(327, xla); }
  }

  private boolean jj_2_329(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_329()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(328, xla); }
  }

  private boolean jj_2_330(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_330()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(329, xla); }
  }

  private boolean jj_2_331(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_331()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(330, xla); }
  }

  private boolean jj_2_332(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_332()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(331, xla); }
  }

  private boolean jj_2_333(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_333()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(332, xla); }
  }

  private boolean jj_2_334(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_334()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(333, xla); }
  }

  private boolean jj_2_335(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_335()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(334, xla); }
  }

  private boolean jj_2_336(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_336()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(335, xla); }
  }

  private boolean jj_2_337(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_337()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(336, xla); }
  }

  private boolean jj_2_338(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_338()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(337, xla); }
  }

  private boolean jj_2_339(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_339()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(338, xla); }
  }

  private boolean jj_2_340(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_340()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(339, xla); }
  }

  private boolean jj_2_341(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_341()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(340, xla); }
  }

  private boolean jj_2_342(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_342()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(341, xla); }
  }

  private boolean jj_3R_Offset_3059_5_587()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_157()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_LimitBy_3045_5_162()
 {
    if (jj_3R_LimitWithOffset_2997_5_381()) return true;
    if (jj_scan_token(K_BY)) return true;
    if (jj_3R_ExpressionList_3606_5_192()) return true;
    return false;
  }

  private boolean jj_3_156()
 {
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3_155()
 {
    if (jj_3R_ParenthesedSelect_1944_5_115()) return true;
    return false;
  }

  private boolean jj_3_332()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(305)) return true;
    }
    return false;
  }

  private boolean jj_3_331()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(305)) return true;
    }
    return false;
  }

  private boolean jj_3R_PlainLimit_3020_5_673()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_155()) {
    jj_scanpos = xsp;
    if (jj_3_156()) return true;
    }
    return false;
  }

  private boolean jj_3_154()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_3006_9_593()
 {
    if (jj_3R_PlainLimit_3020_5_673()) return true;
    return false;
  }

  private boolean jj_3_330()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(305)) return true;
    }
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2998_9_592()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3_329()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(305)) return true;
    }
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2997_5_381()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_LimitWithOffset_2998_9_592()) {
    jj_scanpos = xsp;
    if (jj_3R_LimitWithOffset_3006_9_593()) return true;
    }
    return false;
  }

  private boolean jj_3_153()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_SimpleJdbcNamedParameter_2984_5_637()
 {
    if (jj_scan_token(384)) return true;
    if (jj_3R_RelObjectNameExt_1792_5_332()) return true;
    return false;
  }

  private boolean jj_3R_OrderByElement_2954_32_196()
 {
    if (jj_scan_token(K_DESC)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpression_6027_25_310()
 {
    if (jj_3R_AlterExpressionColumnDropDefault_5902_5_531()) return true;
    return false;
  }

  private boolean jj_3R_SimpleJdbcParameter_2973_5_249()
 {
    if (jj_scan_token(391)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_153()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AlterExpression_6011_37_307()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3_328()
 {
    if (jj_3R_AlterExpressionColumnDropNotNull_5884_5_308()) return true;
    return false;
  }

  private boolean jj_3_327()
 {
    if (jj_3R_AlterExpressionColumnDataType_5866_5_306()) return true;
    return false;
  }

  private boolean jj_3R_OrderByElement_2959_13_198()
 {
    if (jj_scan_token(K_LAST)) return true;
    return false;
  }

  private boolean jj_3R_OrderByElement_2957_13_197()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3_151()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OrderByElement_2957_13_197()) {
    jj_scanpos = xsp;
    if (jj_3R_OrderByElement_2959_13_198()) return true;
    }
    return false;
  }

  private boolean jj_3_152()
 {
    if (jj_scan_token(K_NULLS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_151()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_150()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_3R_OrderByElement_2954_32_196()) return true;
    }
    return false;
  }

  private boolean jj_3_326()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_AlterExpressionColumnDataType_5866_5_306()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_AlterExpression_6011_37_307()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_OrderByElement_2953_5_195()
 {
    if (jj_3R_Expression_3221_5_111()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_150()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_152()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_325()
 {
    if (jj_scan_token(K_COLUMN)) return true;
    return false;
  }

  private boolean jj_3_149()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_OrderByElement_2953_5_195()) return true;
    return false;
  }

  private boolean jj_3_335()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_325()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_326()) {
    jj_scanpos = xsp;
    if (jj_3_327()) {
    jj_scanpos = xsp;
    if (jj_3_328()) {
    jj_scanpos = xsp;
    if (jj_3R_AlterExpression_6027_25_310()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_OrderByElements_2940_5_173()
 {
    if (jj_scan_token(K_ORDER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(269)) jj_scanpos = xsp;
    if (jj_scan_token(K_BY)) return true;
    if (jj_3R_OrderByElement_2953_5_195()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_149()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_AlterExpression_5990_20_309()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3_334()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpression_5990_20_309()) {
    jj_scanpos = xsp;
    if (jj_scan_token(138)) return true;
    }
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    return false;
  }

  private boolean jj_3R_Qualify_2928_5_159()
 {
    if (jj_scan_token(K_QUALIFY)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3_333()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_Having_2917_5_157()
 {
    if (jj_scan_token(K_HAVING)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3_148()
 {
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    return false;
  }

  private boolean jj_3_147()
 {
    if (jj_3R_ParenthesedExpressionList_3643_5_193()) return true;
    return false;
  }

  private boolean jj_3R_GroupingSet_2902_5_191()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_147()) {
    jj_scanpos = xsp;
    if (jj_3_148()) return true;
    }
    return false;
  }

  private boolean jj_3_143()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_GroupingSet_2902_5_191()) return true;
    return false;
  }

  private boolean jj_3_144()
 {
    if (jj_scan_token(K_GROUPING)) return true;
    if (jj_scan_token(K_SETS)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_GroupingSet_2902_5_191()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_143()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_142()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_GroupingSet_2902_5_191()) return true;
    return false;
  }

  private boolean jj_3_146()
 {
    if (jj_3R_ExpressionList_3606_5_192()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_144()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2850_34_793()
 {
    if (jj_scan_token(K_NOCYCLE)) return true;
    return false;
  }

  private boolean jj_3_145()
 {
    if (jj_scan_token(K_GROUPING)) return true;
    if (jj_scan_token(K_SETS)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_GroupingSet_2902_5_191()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_142()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2843_34_792()
 {
    if (jj_scan_token(K_NOCYCLE)) return true;
    return false;
  }

  private boolean jj_3R_GroupByColumnReferences_2872_5_158()
 {
    if (jj_scan_token(K_GROUP)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_145()) {
    jj_scanpos = xsp;
    if (jj_3_146()) return true;
    }
    return false;
  }

  private boolean jj_3_141()
 {
    if (jj_scan_token(K_START)) return true;
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_AndExpression_3272_5_202()) return true;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2849_9_377()
 {
    if (jj_scan_token(K_CONNECT)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OracleHierarchicalQueryClause_2850_34_793()) jj_scanpos = xsp;
    if (jj_3R_AndExpression_3272_5_202()) return true;
    xsp = jj_scanpos;
    if (jj_3_141()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2841_9_376()
 {
    if (jj_scan_token(K_START)) return true;
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_AndExpression_3272_5_202()) return true;
    if (jj_scan_token(K_CONNECT)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OracleHierarchicalQueryClause_2843_34_792()) jj_scanpos = xsp;
    if (jj_3R_AndExpression_3272_5_202()) return true;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2840_5_156()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OracleHierarchicalQueryClause_2841_9_376()) {
    jj_scanpos = xsp;
    if (jj_3R_OracleHierarchicalQueryClause_2849_9_377()) return true;
    }
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDropDefault_5902_5_531()
 {
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    if (jj_scan_token(K_DROP)) return true;
    if (jj_scan_token(K_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_WhereClause_2830_5_155()
 {
    if (jj_scan_token(K_WHERE)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDropNotNull_5886_6_530()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_KSQLWindowClause_2809_9_375()
 {
    if (jj_scan_token(K_TUMBLING)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(K_SIZE)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDropNotNull_5884_5_308()
 {
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    if (jj_scan_token(K_DROP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpressionColumnDropNotNull_5886_6_530()) jj_scanpos = xsp;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_KSQLWindowClause_2805_9_374()
 {
    if (jj_scan_token(K_SESSION)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_KSQLWindowClause_2799_9_373()
 {
    if (jj_scan_token(K_HOPPING)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(K_SIZE)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_scan_token(K_ADVANCE)) return true;
    if (jj_scan_token(K_BY)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDataType_5869_7_529()
 {
    if (jj_3R_CreateParameter_5618_5_291()) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDataType_5867_6_528()
 {
    if (jj_scan_token(K_TYPE)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDataType_5866_5_306()
 {
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpressionColumnDataType_5867_6_528()) jj_scanpos = xsp;
    if (jj_3R_ColDataType_5490_5_272()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_AlterExpressionColumnDataType_5869_7_529()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_324()
 {
    if (jj_scan_token(K_TABLE)) return true;
    return false;
  }

  private boolean jj_3R_KSQLWindowClause_2791_5_154()
 {
    if (jj_scan_token(K_WINDOW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_KSQLWindowClause_2799_9_373()) {
    jj_scanpos = xsp;
    if (jj_3R_KSQLWindowClause_2805_9_374()) {
    jj_scanpos = xsp;
    if (jj_3R_KSQLWindowClause_2809_9_375()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2704_83_762()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_Truncate_5849_5_657()
 {
    if (jj_scan_token(K_TRUNCATE)) return true;
    return false;
  }

  private boolean jj_3R_JoinWindow_2765_7_810()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_scan_token(S_LONG)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) return true;
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2741_31_789()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Column_1723_5_227()) return true;
    return false;
  }

  private boolean jj_3R_JoinWindow_2764_5_807()
 {
    if (jj_scan_token(S_LONG)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_JoinWindow_2765_7_810()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_139()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2739_25_190()
 {
    if (jj_scan_token(K_USING)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_Column_1723_5_227()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JoinerExpression_2741_31_789()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2723_40_602()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2734_27_401()
 {
    if (jj_scan_token(K_WITHIN)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_JoinWindow_2764_5_807()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2734_25_189()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2734_27_401()) jj_scanpos = xsp;
    if (jj_scan_token(K_ON)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_139()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2704_48_761()
 {
    if (jj_scan_token(K_SEMI)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2704_48_714()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2704_48_761()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2704_83_762()) return true;
    }
    return false;
  }

  private boolean jj_3_323()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_EXISTS)) return true;
    return false;
  }

  private boolean jj_3_140()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2734_25_189()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2739_25_190()) return true;
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2727_9_400()
 {
    if (jj_scan_token(K_APPLY)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2725_9_399()
 {
    if (jj_scan_token(K_STRAIGHT)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2723_9_398()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2723_40_602()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Drop_5794_5_655()
 {
    if (jj_scan_token(K_DROP)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2710_17_717()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2717_9_601()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2709_17_716()
 {
    if (jj_scan_token(K_FULL)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2712_13_683()
 {
    if (jj_scan_token(K_INNER)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2715_9_600()
 {
    if (jj_scan_token(K_CROSS)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2707_17_715()
 {
    if (jj_scan_token(K_RIGHT)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2706_13_682()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2707_17_715()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2709_17_716()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2710_17_717()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2704_13_681()
 {
    if (jj_scan_token(K_LEFT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2704_48_714()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2703_9_397()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2703_9_599()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2715_9_600()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2717_9_601()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2703_9_599()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2704_13_681()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2706_13_682()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2712_13_683()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_FromItem_2655_54_185()
 {
    if (jj_3R_Pivot_2517_5_179()) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2700_7_396()
 {
    if (jj_scan_token(K_NATURAL)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2699_7_395()
 {
    if (jj_scan_token(K_GLOBAL)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2699_5_188()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2699_7_395()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2700_7_396()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2703_9_397()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(149)) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2723_9_398()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2725_9_399()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2727_9_400()) return true;
    }
    }
    }
    if (jj_3R_FromItem_2636_5_153()) return true;
    xsp = jj_scanpos;
    if (jj_3_140()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_138()
 {
    if (jj_3R_JoinerExpression_2699_5_188()) return true;
    return false;
  }

  private boolean jj_3_322()
 {
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    return false;
  }

  private boolean jj_3R_JoinsList_2681_5_152()
 {
    Token xsp;
    if (jj_3_138()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_138()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_FromItem_2664_13_187()
 {
    if (jj_3R_SQLServerHints_2414_5_394()) return true;
    return false;
  }

  private boolean jj_3_135()
 {
    if (jj_3R_PivotXml_2545_5_184()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2659_13_186()
 {
    if (jj_3R_MySQLIndexHint_2428_9_393()) return true;
    return false;
  }

  private boolean jj_3R_AList_5704_38_805()
 {
    if (jj_scan_token(381)) return true;
    return false;
  }

  private boolean jj_3_137()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_2659_13_186()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2664_13_187()) return true;
    }
    return false;
  }

  private boolean jj_3R_ColumnsNamesList_5732_5_119()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_ColumnsNamesListItem_5719_9_340()) return true;
    return false;
  }

  private boolean jj_3_136()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_135()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2655_54_185()) return true;
    }
    return false;
  }

  private boolean jj_3_134()
 {
    if (jj_3R_UnPivot_2575_5_180()) return true;
    return false;
  }

  private boolean jj_3_130()
 {
    if (jj_3R_ParenthesedFromItem_2613_5_182()) return true;
    return false;
  }

  private boolean jj_3_127()
 {
    if (jj_3R_UnPivot_2575_5_180()) return true;
    return false;
  }

  private boolean jj_3_133()
 {
    if (jj_3R_SampleClause_1869_5_183()) return true;
    return false;
  }

  private boolean jj_3_126()
 {
    if (jj_3R_Pivot_2517_5_179()) return true;
    return false;
  }

  private boolean jj_3_132()
 {
    if (jj_3R_Alias_2389_5_128()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2649_9_372()
 {
    if (jj_3R_LateralSubSelect_2077_5_591()) return true;
    return false;
  }

  private boolean jj_3_128()
 {
    if (jj_3R_TableFunction_5087_5_181()) return true;
    return false;
  }

  private boolean jj_3R_ColumnsNamesListItem_5719_9_340()
 {
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    return false;
  }

  private boolean jj_3_125()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Table_1821_5_163()) return true;
    return false;
  }

  private boolean jj_3_131()
 {
    if (jj_3R_ParenthesedSelect_1944_5_115()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_126()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_127()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_FromItem_2641_9_371()
 {
    if (jj_3R_ParenthesedFromItem_2613_5_182()) return true;
    return false;
  }

  private boolean jj_3_129()
 {
    if (jj_3R_Table_1821_5_163()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2637_9_370()
 {
    if (jj_3R_TableFunction_5087_5_181()) return true;
    return false;
  }

  private boolean jj_3R_AList_5703_12_747()
 {
    if (jj_3R_RelObjectNameWithoutValue_1750_5_117()) return true;
    return false;
  }

  private boolean jj_3R_AList_5704_10_804()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_AList_5704_9_785()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AList_5704_10_804()) {
    jj_scanpos = xsp;
    if (jj_3R_AList_5704_38_805()) return true;
    }
    return false;
  }

  private boolean jj_3R_FromItem_2636_5_153()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_2637_9_370()) {
    jj_scanpos = xsp;
    if (jj_3_129()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2641_9_371()) {
    jj_scanpos = xsp;
    if (jj_3_131()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2649_9_372()) return true;
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_132()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_133()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_134()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_136()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_137()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AList_5702_10_746()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(352)) {
    jj_scanpos = xsp;
    if (jj_scan_token(351)) {
    jj_scanpos = xsp;
    if (jj_scan_token(377)) return true;
    }
    }
    return false;
  }

  private boolean jj_3_320()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_AList_5702_8_705()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AList_5702_10_746()) {
    jj_scanpos = xsp;
    if (jj_3R_AList_5703_12_747()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_AList_5704_9_785()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AList_5699_6_647()
 {
    if (jj_scan_token(379)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_AList_5702_8_705()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_ParenthesedFromItem_2615_11_390()
 {
    if (jj_3R_JoinsList_2681_5_152()) return true;
    return false;
  }

  private boolean jj_3R_RowMovement_5687_5_708()
 {
    if (jj_scan_token(K_DISABLE)) return true;
    return false;
  }

  private boolean jj_3R_RowMovement_5685_5_707()
 {
    if (jj_scan_token(K_ENABLE)) return true;
    return false;
  }

  private boolean jj_3R_ParenthesedFromItem_2613_5_182()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_FromItem_2636_5_153()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ParenthesedFromItem_2615_11_390()) jj_scanpos = xsp;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_RowMovement_5684_3_648()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RowMovement_5685_5_707()) {
    jj_scanpos = xsp;
    if (jj_3R_RowMovement_5687_5_708()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_5673_9_525()
 {
    if (jj_scan_token(423)) return true;
    if (jj_3R_ColDataType_5490_5_272()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5671_9_524()
 {
    if (jj_scan_token(K_ARRAY_LITERAL)) return true;
    if (jj_3R_ArrayConstructor_4229_5_127()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5669_9_523()
 {
    if (jj_scan_token(K_CHARACTER)) return true;
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5662_15_704()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(393)) {
    jj_scanpos = xsp;
    if (jj_scan_token(405)) return true;
    }
    return false;
  }

  private boolean jj_3R_IntoClause_2600_5_151()
 {
    if (jj_scan_token(K_INTO)) return true;
    if (jj_3R_Table_1821_5_163()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_125()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_5667_9_522()
 {
    if (jj_3R_AList_5699_6_647()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5662_13_646()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_5662_15_704()) jj_scanpos = xsp;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5661_9_521()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_5662_13_646()) {
    jj_scanpos = xsp;
    if (jj_scan_token(351)) return true;
    }
    return false;
  }

  private boolean jj_3_124()
 {
    if (jj_3R_Alias_2389_5_128()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5653_9_520()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3_320()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateParameter_5637_23_305()
 {
    if (jj_scan_token(K_USING)) return true;
    if (jj_scan_token(K_INDEX)) return true;
    return false;
  }

  private boolean jj_3R_UnPivot_2576_9_596()
 {
    if (jj_scan_token(K_INCLUDE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3R_UnPivot_2577_7_597()
 {
    if (jj_scan_token(K_EXCLUDE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3R_UnPivot_2576_7_389()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_UnPivot_2576_9_596()) {
    jj_scanpos = xsp;
    if (jj_3R_UnPivot_2577_7_597()) return true;
    }
    return false;
  }

  private boolean jj_3R_UnPivot_2575_5_180()
 {
    if (jj_scan_token(K_UNPIVOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_UnPivot_2576_7_389()) jj_scanpos = xsp;
    if (jj_scan_token(379)) return true;
    if (jj_3R_PivotForColumns_2466_5_713()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_PivotForColumns_2466_5_713()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_SelectItemsList_2313_5_178()) return true;
    if (jj_scan_token(380)) return true;
    if (jj_scan_token(380)) return true;
    xsp = jj_scanpos;
    if (jj_3_124()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateParameter_5640_9_519()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(377)) {
    jj_scanpos = xsp;
    if (jj_scan_token(195)) {
    jj_scanpos = xsp;
    if (jj_scan_token(191)) {
    jj_scanpos = xsp;
    if (jj_scan_token(221)) {
    jj_scanpos = xsp;
    if (jj_scan_token(114)) {
    jj_scanpos = xsp;
    if (jj_scan_token(235)) {
    jj_scanpos = xsp;
    if (jj_scan_token(156)) {
    jj_scanpos = xsp;
    if (jj_scan_token(275)) {
    jj_scanpos = xsp;
    if (jj_scan_token(201)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(254)) {
    jj_scanpos = xsp;
    if (jj_scan_token(302)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(305)) {
    jj_scanpos = xsp;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(327)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(325)) {
    jj_scanpos = xsp;
    if (jj_scan_token(316)) {
    jj_scanpos = xsp;
    if (jj_scan_token(287)) {
    jj_scanpos = xsp;
    if (jj_scan_token(288)) {
    jj_scanpos = xsp;
    if (jj_scan_token(214)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(299)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(313)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(296)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) {
    jj_scanpos = xsp;
    if (jj_scan_token(212)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(274)) {
    jj_scanpos = xsp;
    if (jj_scan_token(289)) {
    jj_scanpos = xsp;
    if (jj_scan_token(381)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_5630_17_645()
 {
    if (jj_scan_token(383)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(378)) return true;
    }
    return false;
  }

  private boolean jj_3_321()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_5637_23_305()) jj_scanpos = xsp;
    if (jj_scan_token(K_TABLESPACE)) return true;
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5625_9_518()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(378)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_5630_17_645()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PivotXml_2552_9_757()
 {
    if (jj_3R_PivotMultiInItems_2502_4_774()) return true;
    return false;
  }

  private boolean jj_3_123()
 {
    if (jj_3R_SelectItemsList_2313_5_178()) return true;
    return false;
  }

  private boolean jj_3R_PivotXml_2550_9_756()
 {
    if (jj_3R_Select_1915_5_339()) return true;
    return false;
  }

  private boolean jj_3_122()
 {
    if (jj_scan_token(K_ANY)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5620_9_517()
 {
    if (jj_scan_token(K_NEXTVAL)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(423)) return true;
    if (jj_3R_ColDataType_5490_5_272()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5618_5_291()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_5620_9_517()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5625_9_518()) {
    jj_scanpos = xsp;
    if (jj_3_321()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5640_9_519()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5653_9_520()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5661_9_521()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5667_9_522()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5669_9_523()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5671_9_524()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5673_9_525()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_PivotXml_2545_5_184()
 {
    if (jj_scan_token(K_PIVOT)) return true;
    if (jj_scan_token(K_XML)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_PivotFunctionItems_2480_5_748()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_PivotForColumns_2466_5_713()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(379)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_122()) {
    jj_scanpos = xsp;
    if (jj_3R_PivotXml_2550_9_756()) {
    jj_scanpos = xsp;
    if (jj_3_123()) {
    jj_scanpos = xsp;
    if (jj_3R_PivotXml_2552_9_757()) return true;
    }
    }
    }
    if (jj_scan_token(380)) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_5515_90_766()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_AlterView_5598_5_677()
 {
    if (jj_scan_token(K_VIEW)) return true;
    return false;
  }

  private boolean jj_3_121()
 {
    if (jj_3R_Alias_2389_5_128()) return true;
    return false;
  }

  private boolean jj_3R_Pivot_2521_7_749()
 {
    if (jj_3R_PivotMultiInItems_2502_4_774()) return true;
    return false;
  }

  private boolean jj_3_120()
 {
    if (jj_3R_SelectItemsList_2313_5_178()) return true;
    return false;
  }

  private boolean jj_3R_Pivot_2517_5_179()
 {
    if (jj_scan_token(K_PIVOT)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_PivotFunctionItems_2480_5_748()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_PivotForColumns_2466_5_713()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(379)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_120()) {
    jj_scanpos = xsp;
    if (jj_3R_Pivot_2521_7_749()) return true;
    }
    if (jj_scan_token(380)) return true;
    if (jj_scan_token(380)) return true;
    xsp = jj_scanpos;
    if (jj_3_121()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PivotMultiInItems_2503_5_788()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_ExpressionListItem_2491_5_787()) return true;
    return false;
  }

  private boolean jj_3R_PivotMultiInItems_2502_4_774()
 {
    if (jj_3R_ExpressionListItem_2491_5_787()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PivotMultiInItems_2503_5_788()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ExpressionListItem_2492_7_806()
 {
    if (jj_3R_Alias_2389_5_128()) return true;
    return false;
  }

  private boolean jj_3_313()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) return true;
    }
    return false;
  }

  private boolean jj_3_319()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_NOT)) return true;
    if (jj_scan_token(K_EXISTS)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_5557_11_652()
 {
    if (jj_scan_token(K_TEMPORARY)) return true;
    return false;
  }

  private boolean jj_3R_ExpressionListItem_2491_5_787()
 {
    if (jj_3R_ParenthesedExpressionList_3643_5_193()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionListItem_2492_7_806()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_318()
 {
    if (jj_scan_token(K_AUTO)) return true;
    if (jj_scan_token(K_REFRESH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(342)) {
    jj_scanpos = xsp;
    if (jj_scan_token(183)) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateView_5559_7_541()
 {
    if (jj_scan_token(K_MATERIALIZED)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_5556_9_540()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_5556_9_651()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateView_5557_11_652()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateView_5556_9_651()
 {
    if (jj_scan_token(K_TEMP)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_5553_11_650()
 {
    if (jj_scan_token(K_FORCE)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_5552_9_539()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_5552_9_649()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateView_5553_11_650()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateView_5552_9_649()
 {
    if (jj_scan_token(K_NO)) return true;
    if (jj_scan_token(K_FORCE)) return true;
    return false;
  }

  private boolean jj_3R_PivotFunctionItems_2481_7_773()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_FunctionItem_2455_5_772()) return true;
    return false;
  }

  private boolean jj_3R_PivotFunctionItems_2480_5_748()
 {
    if (jj_3R_FunctionItem_2455_5_772()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PivotFunctionItems_2481_7_773()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CreateView_5550_5_313()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_5552_9_539()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_5556_9_540()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_5559_7_541()) jj_scanpos = xsp;
    if (jj_scan_token(K_VIEW)) return true;
    if (jj_3R_Table_1821_5_163()) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_5514_40_527()
 {
    if (jj_scan_token(S_LONG)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_313()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ColDataType_5514_38_304()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_5514_40_527()) {
    jj_scanpos = xsp;
    if (jj_scan_token(377)) {
    jj_scanpos = xsp;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_5515_90_766()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PivotForColumns_2469_9_755()
 {
    if (jj_3R_Column_1723_5_227()) return true;
    return false;
  }

  private boolean jj_3R_PivotForColumns_2467_9_754()
 {
    if (jj_3R_ParenthesedColumnList_3687_5_120()) return true;
    return false;
  }

  private boolean jj_3_310()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_PivotForColumns_2466_5_713()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PivotForColumns_2467_9_754()) {
    jj_scanpos = xsp;
    if (jj_3R_PivotForColumns_2469_9_755()) return true;
    }
    return false;
  }

  private boolean jj_3R_Alias_2395_72_775()
 {
    if (jj_3R_ColDataType_5490_5_272()) return true;
    return false;
  }

  private boolean jj_3_315()
 {
    if (jj_scan_token(417)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(352)) jj_scanpos = xsp;
    if (jj_scan_token(418)) return true;
    return false;
  }

  private boolean jj_3R_Analyze_5532_5_656()
 {
    if (jj_scan_token(K_ANALYZE)) return true;
    return false;
  }

  private boolean jj_3R_FunctionItem_2456_7_786()
 {
    if (jj_3R_Alias_2389_5_128()) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_5506_27_706()
 {
    if (jj_scan_token(383)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(378)) return true;
    }
    return false;
  }

  private boolean jj_3R_FunctionItem_2455_5_772()
 {
    if (jj_3R_Function_4941_5_223()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FunctionItem_2456_7_786()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ColDataType_5511_19_509()
 {
    if (jj_scan_token(K_SIGNED)) return true;
    return false;
  }

  private boolean jj_3_312()
 {
    if (jj_scan_token(K_SIGNED)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_309()
 {
    if (jj_scan_token(K_PRECISION)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_5508_19_508()
 {
    if (jj_scan_token(K_UNSIGNED)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_310()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_MySQLIndexHint_2442_10_758()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectNameWithoutValue_1750_5_117()) return true;
    return false;
  }

  private boolean jj_3_317()
 {
    if (jj_scan_token(K_CHARACTER)) return true;
    if (jj_scan_token(K_SET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) return true;
    }
    return false;
  }

  private boolean jj_3_316()
 {
    Token xsp;
    if (jj_3_315()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_315()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ColDataType_5504_19_507()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(378)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(333)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(350)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(265)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) {
    jj_scanpos = xsp;
    if (jj_scan_token(276)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_5506_27_706()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_314()
 {
    if (jj_scan_token(379)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ColDataType_5514_38_304()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHints_2415_31_760()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SQLServerHint_2405_9_759()) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_5500_15_303()
 {
    if (jj_scan_token(K_JSON)) return true;
    if (jj_scan_token(379)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(352)) {
    jj_scanpos = xsp;
    if (jj_scan_token(358)) return true;
    }
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_5499_15_302()
 {
    if (jj_scan_token(K_STRING)) return true;
    if (jj_scan_token(379)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(352)) {
    jj_scanpos = xsp;
    if (jj_scan_token(358)) return true;
    }
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_5503_11_506()
 {
    if (jj_scan_token(K_DOUBLE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_309()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ColDataType_5502_11_505()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(320)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ColDataType_5498_13_301()
 {
    if (jj_scan_token(K_BYTES)) return true;
    if (jj_scan_token(379)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(352)) {
    jj_scanpos = xsp;
    if (jj_scan_token(358)) return true;
    }
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_Alias_2394_45_750()
 {
    if (jj_3R_ColDataType_5490_5_272()) return true;
    return false;
  }

  private boolean jj_3R_MySQLIndexHint_2428_9_393()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(308)) {
    jj_scanpos = xsp;
    if (jj_scan_token(267)) {
    jj_scanpos = xsp;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(138)) {
    jj_scanpos = xsp;
    if (jj_scan_token(156)) return true;
    }
    if (jj_scan_token(379)) return true;
    if (jj_3R_RelObjectNameWithoutValue_1750_5_117()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_MySQLIndexHint_2442_10_758()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_5491_17_504()
 {
    if (jj_scan_token(K_ARRAY_LITERAL)) return true;
    if (jj_scan_token(395)) return true;
    if (jj_3R_ColDataType_5490_5_272()) return true;
    if (jj_scan_token(394)) return true;
    return false;
  }

  private boolean jj_3R_Alias_2390_46_346()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_311()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_5498_13_301()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_5499_15_302()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_5500_15_303()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_ColDataType_5490_5_272()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_5491_17_504()) {
    jj_scanpos = xsp;
    if (jj_3_311()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_5502_11_505()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_5503_11_506()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_5504_19_507()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_5508_19_508()) {
    jj_scanpos = xsp;
    if (jj_3_312()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_5511_19_509()) return true;
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_314()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_316()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_317()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SQLServerHints_2414_5_394()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_SQLServerHint_2405_9_759()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SQLServerHints_2415_31_760()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHint_2407_9_777()
 {
    if (jj_scan_token(K_NOLOCK)) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHint_2405_9_776()
 {
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHint_2405_9_759()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SQLServerHint_2405_9_776()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLServerHint_2407_9_777()) return true;
    }
    return false;
  }

  private boolean jj_3R_Alias_2395_18_751()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_2395_72_775()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_119()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_2394_45_750()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_Alias_2395_18_751()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_Alias_2390_11_345()
 {
    if (jj_3R_RelObjectNameWithoutStart_1774_5_132()) return true;
    return false;
  }

  private boolean jj_3R_Alias_2389_6_344()
 {
    if (jj_scan_token(K_AS)) return true;
    return false;
  }

  private boolean jj_3_308()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_Table_1821_5_163()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_Alias_2389_5_128()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_2389_6_344()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_2390_11_345()) {
    jj_scanpos = xsp;
    if (jj_3R_Alias_2390_46_346()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_119()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AllTableColumns_2373_6_175()
 {
    if (jj_3R_Table_1821_5_163()) return true;
    if (jj_scan_token(383)) return true;
    if (jj_3R_AllColumns_2358_5_387()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5443_7_538()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5438_7_536()
 {
    if (jj_scan_token(K_AS)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5440_5_537()
 {
    if (jj_scan_token(K_LIKE)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5437_7_535()
 {
    if (jj_3R_RowMovement_5684_3_648()) return true;
    return false;
  }

  private boolean jj_3_307()
 {
    if (jj_3R_CreateParameter_5618_5_291()) return true;
    return false;
  }

  private boolean jj_3_118()
 {
    if (jj_scan_token(K_REPLACE)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_SelectItemsList_2313_5_178()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_117()
 {
    if (jj_scan_token(K_EXCEPT)) return true;
    if (jj_3R_ParenthesedColumnList_3687_5_120()) return true;
    return false;
  }

  private boolean jj_3R_AllColumns_2358_5_387()
 {
    if (jj_scan_token(390)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_117()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_118()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_113()
 {
    if (jj_3R_Condition_3310_5_176()) return true;
    return false;
  }

  private boolean jj_3_112()
 {
    if (jj_3R_AllTableColumns_2373_6_175()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5389_37_298()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3_116()
 {
    if (jj_3R_Alias_2389_5_128()) return true;
    return false;
  }

  private boolean jj_3_115()
 {
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3_114()
 {
    if (jj_3R_ConcatExpression_3837_5_177()) return true;
    return false;
  }

  private boolean jj_3_304()
 {
    if (jj_scan_token(K_EXCLUDE)) return true;
    if (jj_scan_token(K_WHERE)) return true;
    return false;
  }

  private boolean jj_3R_SelectItem_2338_9_386()
 {
    if (jj_3R_Condition_3310_5_176()) return true;
    return false;
  }

  private boolean jj_3R_SelectItem_2336_9_385()
 {
    if (jj_3R_AllTableColumns_2373_6_175()) return true;
    return false;
  }

  private boolean jj_3R_WithList_2285_60_718()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_WithItem_2298_6_319()) return true;
    return false;
  }

  private boolean jj_3R_SelectItem_2334_9_384()
 {
    if (jj_3R_AllColumns_2358_5_387()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5387_26_297()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    return false;
  }

  private boolean jj_3_303()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5387_26_297()) jj_scanpos = xsp;
    if (jj_scan_token(K_CHECK)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_5389_37_298()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_SelectItem_2331_5_174()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SelectItem_2334_9_384()) {
    jj_scanpos = xsp;
    if (jj_3R_SelectItem_2336_9_385()) {
    jj_scanpos = xsp;
    if (jj_3R_SelectItem_2338_9_386()) {
    jj_scanpos = xsp;
    if (jj_3_114()) {
    jj_scanpos = xsp;
    if (jj_3_115()) return true;
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_116()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_298()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(305)) return true;
    }
    return false;
  }

  private boolean jj_3_297()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(305)) return true;
    }
    return false;
  }

  private boolean jj_3_111()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SelectItem_2331_5_174()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5365_26_296()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    return false;
  }

  private boolean jj_3R_SelectItemsList_2313_5_178()
 {
    if (jj_3R_SelectItem_2331_5_174()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_111()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_302()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5365_26_296()) jj_scanpos = xsp;
    if (jj_scan_token(K_FOREIGN)) return true;
    if (jj_scan_token(K_KEY)) return true;
    if (jj_3R_ColumnNamesWithParamsList_5102_6_292()) return true;
    return false;
  }

  private boolean jj_3R_WithItem_2300_8_672()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_SelectItemsList_2313_5_178()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_WithItem_2298_8_562()
 {
    if (jj_scan_token(K_RECURSIVE)) return true;
    return false;
  }

  private boolean jj_3R_WithItem_2298_6_319()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WithItem_2298_8_562()) jj_scanpos = xsp;
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    xsp = jj_scanpos;
    if (jj_3R_WithItem_2300_8_672()) jj_scanpos = xsp;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_ParenthesedSelect_1944_5_115()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5297_77_299()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3_301()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(302)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(118)) jj_scanpos = xsp;
    if (jj_scan_token(K_KEY)) return true;
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    if (jj_3R_ColumnNamesWithParamsList_5102_6_292()) return true;
    return false;
  }

  private boolean jj_3R_WithList_2285_5_96()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_WithItem_2298_6_319()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_WithList_2285_60_718()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CreateTable_5328_28_295()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(156)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateTable_5327_26_294()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5325_26_293()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2225_53_595()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3_300()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5325_26_293()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5327_26_294()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateTable_5328_28_295()) return true;
    }
    if (jj_3R_ColumnNamesWithParamsList_5102_6_292()) return true;
    return false;
  }

  private boolean jj_3_110()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_ISOLATION)) return true;
    return false;
  }

  private boolean jj_3_109()
 {
    if (jj_scan_token(K_FETCH)) return true;
    return false;
  }

  private boolean jj_3_108()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3_107()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    return false;
  }

  private boolean jj_3_106()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2252_7_723()
 {
    if (jj_3R_WithIsolation_3098_5_589()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2251_7_722()
 {
    if (jj_3R_Fetch_3080_5_588()) return true;
    return false;
  }

  private boolean jj_3_299()
 {
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    if (jj_3R_ColumnNamesWithParamsList_5102_6_292()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2250_7_721()
 {
    if (jj_3R_LimitWithOffset_2997_5_381()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2249_7_720()
 {
    if (jj_3R_Offset_3059_5_587()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2248_7_719()
 {
    if (jj_3R_LimitWithOffset_2997_5_381()) return true;
    return false;
  }

  private boolean jj_3_105()
 {
    if (jj_3R_OrderByElements_2940_5_173()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2240_13_172()
 {
    if (jj_3R_ParenthesedSelect_1944_5_115()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2238_13_171()
 {
    if (jj_3R_Values_1248_5_130()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2236_13_170()
 {
    if (jj_3R_PlainSelect_2119_5_129()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2232_13_169()
 {
    if (jj_scan_token(K_EXCEPT)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2225_19_383()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2225_19_594()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_2225_53_595()) return true;
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_2225_19_594()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2230_13_168()
 {
    if (jj_scan_token(K_MINUS)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2228_13_167()
 {
    if (jj_scan_token(K_INTERSECT)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5299_13_300()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_ColumnDefinition_5178_5_526()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2223_13_166()
 {
    if (jj_scan_token(K_UNION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2225_19_383()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_305()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_5297_77_299()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_306()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_305()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateTable_5299_13_300()) return true;
    }
    return false;
  }

  private boolean jj_3_104()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2223_13_166()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_2228_13_167()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_2230_13_168()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_2232_13_169()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2236_13_170()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_2238_13_171()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_2240_13_172()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_296()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5290_6_534()
 {
    if (jj_3R_CreateParameter_5618_5_291()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_2217_5_131()
 {
    Token xsp;
    if (jj_3_104()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_104()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_105()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2248_7_719()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2249_7_720()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2250_7_721()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2251_7_722()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_2252_7_723()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateTable_5286_7_533()
 {
    if (jj_scan_token(K_GLOBAL)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5283_7_532()
 {
    if (jj_scan_token(K_UNLOGGED)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5282_5_312()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5283_7_532()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5286_7_533()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_5290_6_534()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(K_TABLE)) return true;
    xsp = jj_scanpos;
    if (jj_3_296()) jj_scanpos = xsp;
    if (jj_3R_Table_1821_5_163()) return true;
    xsp = jj_scanpos;
    if (jj_3_306()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_307()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5437_7_535()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5438_7_536()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5440_5_537()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5443_7_538()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PlainSelect_2187_25_164()
 {
    if (jj_scan_token(K_NOWAIT)) return true;
    return false;
  }

  private boolean jj_3_103()
 {
    if (jj_scan_token(K_OPTIMIZE)) return true;
    return false;
  }

  private boolean jj_3_100()
 {
    if (jj_scan_token(K_WAIT)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2188_18_165()
 {
    if (jj_scan_token(K_SKIP)) return true;
    if (jj_scan_token(K_LOCKED)) return true;
    return false;
  }

  private boolean jj_3_96()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3_98()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_ISOLATION)) return true;
    return false;
  }

  private boolean jj_3_97()
 {
    if (jj_scan_token(K_FETCH)) return true;
    return false;
  }

  private boolean jj_3_101()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2187_25_164()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_2188_18_165()) return true;
    }
    return false;
  }

  private boolean jj_3R_PlainSelect_2191_7_356()
 {
    if (jj_3R_OptimizeFor_3115_5_590()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2186_11_764()
 {
    if (jj_3R_Wait_6495_5_782()) return true;
    return false;
  }

  private boolean jj_3_95()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    return false;
  }

  private boolean jj_3_99()
 {
    if (jj_scan_token(K_OF)) return true;
    if (jj_3R_Table_1821_5_163()) return true;
    return false;
  }

  private boolean jj_3_94()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3_93()
 {
    if (jj_3R_LimitBy_3045_5_162()) return true;
    return false;
  }

  private boolean jj_3_91()
 {
    if (jj_scan_token(K_ORDER)) return true;
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2181_11_353()
 {
    if (jj_3R_LimitWithOffset_2997_5_381()) return true;
    return false;
  }

  private boolean jj_3_102()
 {
    if (jj_scan_token(K_FOR)) return true;
    if (jj_scan_token(K_UPDATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_99()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2186_11_764()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_101()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PlainSelect_2183_7_355()
 {
    if (jj_3R_WithIsolation_3098_5_589()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2182_7_354()
 {
    if (jj_3R_Fetch_3080_5_588()) return true;
    return false;
  }

  private boolean jj_3_88()
 {
    if (jj_scan_token(K_ORDER)) return true;
    if (jj_scan_token(K_SIBLINGS)) return true;
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2180_7_352()
 {
    if (jj_3R_Offset_3059_5_587()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2179_7_351()
 {
    if (jj_3R_LimitWithOffset_2997_5_381()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2178_7_350()
 {
    if (jj_3R_LimitBy_3045_5_162()) return true;
    return false;
  }

  private boolean jj_3_92()
 {
    if (jj_scan_token(K_EMIT)) return true;
    if (jj_scan_token(K_CHANGES)) return true;
    return false;
  }

  private boolean jj_3_89()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_windowDefinition_4660_5_643()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2176_7_349()
 {
    if (jj_3R_OrderByElements_2940_5_173()) return true;
    return false;
  }

  private boolean jj_3_90()
 {
    if (jj_scan_token(K_WINDOW)) return true;
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_windowDefinition_4660_5_643()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_89()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_PlainSelect_2170_7_348()
 {
    if (jj_3R_OrderByElements_2940_5_173()) return true;
    return false;
  }

  private boolean jj_3_87()
 {
    if (jj_3R_ForClause_1989_5_160()) return true;
    return false;
  }

  private boolean jj_3_86()
 {
    if (jj_3R_Qualify_2928_5_159()) return true;
    return false;
  }

  private boolean jj_3_85()
 {
    if (jj_3R_Having_2917_5_157()) return true;
    return false;
  }

  private boolean jj_3_84()
 {
    if (jj_3R_GroupByColumnReferences_2872_5_158()) return true;
    return false;
  }

  private boolean jj_3_83()
 {
    if (jj_3R_Having_2917_5_157()) return true;
    return false;
  }

  private boolean jj_3_82()
 {
    if (jj_3R_OracleHierarchicalQueryClause_2840_5_156()) return true;
    return false;
  }

  private boolean jj_3_81()
 {
    if (jj_3R_WhereClause_2830_5_155()) return true;
    return false;
  }

  private boolean jj_3_80()
 {
    if (jj_3R_KSQLWindowClause_2791_5_154()) return true;
    return false;
  }

  private boolean jj_3_79()
 {
    if (jj_scan_token(K_FINAL)) return true;
    return false;
  }

  private boolean jj_3_77()
 {
    if (jj_3R_JoinsList_2681_5_152()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2154_11_763()
 {
    if (jj_3R_LateralViews_2063_5_778()) return true;
    return false;
  }

  private boolean jj_3_78()
 {
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_FromItem_2636_5_153()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2154_11_763()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_77()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_76()
 {
    if (jj_3R_IntoClause_2600_5_151()) return true;
    return false;
  }

  private boolean jj_3_75()
 {
    if (jj_3R_Top_3131_5_150()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2144_9_149()
 {
    if (jj_scan_token(K_SQL_CACHE)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2142_9_148()
 {
    if (jj_scan_token(K_SQL_NO_CACHE)) return true;
    return false;
  }

  private boolean jj_3_73()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_SelectItemsList_2313_5_178()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2140_9_147()
 {
    if (jj_scan_token(K_SQL_CALC_FOUND_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2138_9_146()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2133_9_145()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_73()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_74()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_2133_9_145()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_2138_9_146()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_2140_9_147()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_2142_9_148()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_2144_9_149()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_72()
 {
    if (jj_3R_First_3198_5_144()) return true;
    return false;
  }

  private boolean jj_3_71()
 {
    if (jj_3R_Skip_3162_5_143()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2121_7_347()
 {
    if (jj_scan_token(K_STRAIGHT)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_2119_5_129()
 {
    if (jj_scan_token(K_SELECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2121_7_347()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_71()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_72()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_74()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_75()) jj_scanpos = xsp;
    if (jj_3R_SelectItemsList_2313_5_178()) return true;
    xsp = jj_scanpos;
    if (jj_3_76()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_78()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_79()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_80()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_81()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_82()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_83()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_84()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_85()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_86()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_87()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2170_7_348()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_90()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2176_7_349()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_92()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2178_7_350()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2179_7_351()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2180_7_352()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2181_11_353()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2182_7_354()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2183_7_355()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_102()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_2191_7_356()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_295()
 {
    if (jj_3R_CreateParameter_5618_5_291()) return true;
    return false;
  }

  private boolean jj_3R_ColumnDefinition_5178_5_526()
 {
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    if (jj_3R_ColDataType_5490_5_272()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_295()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_LateralSubSelect_2077_5_591()
 {
    if (jj_scan_token(K_LATERAL)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_Select_1915_5_339()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_70()
 {
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_68()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(340)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) return true;
    }
    return false;
  }

  private boolean jj_3R_LateralViews_2064_7_791()
 {
    if (jj_3R_LateralView_1963_5_790()) return true;
    return false;
  }

  private boolean jj_3R_LateralViews_2063_5_778()
 {
    if (jj_3R_LateralView_1963_5_790()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_LateralViews_2064_7_791()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_67()
 {
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_ForClause_2042_21_142()
 {
    if (jj_scan_token(K_ROOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_70()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ForClause_2031_27_141()
 {
    if (jj_scan_token(K_ELEMENTS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_68()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ForClause_2030_27_140()
 {
    if (jj_scan_token(K_ROOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_67()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_69()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ForClause_2042_21_142()) {
    jj_scanpos = xsp;
    if (jj_scan_token(136)) {
    jj_scanpos = xsp;
    if (jj_scan_token(331)) return true;
    }
    }
    return false;
  }

  private boolean jj_3_64()
 {
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_ForClause_2028_25_139()
 {
    if (jj_scan_token(K_BINARY)) return true;
    if (jj_scan_token(K_BASE64)) return true;
    return false;
  }

  private boolean jj_3_65()
 {
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_61()
 {
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_62()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(340)) {
    jj_scanpos = xsp;
    if (jj_scan_token(2)) return true;
    }
    return false;
  }

  private boolean jj_3_66()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ForClause_2028_25_139()) {
    jj_scanpos = xsp;
    if (jj_scan_token(299)) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2030_27_140()) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2031_27_141()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ForClause_2037_9_379()
 {
    if (jj_scan_token(K_JSON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(215)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_69()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ForClause_2017_27_138()
 {
    if (jj_scan_token(K_ROOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_64()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ForClause_2015_25_137()
 {
    if (jj_scan_token(K_BINARY)) return true;
    if (jj_scan_token(K_BASE64)) return true;
    return false;
  }

  private boolean jj_3_60()
 {
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_ColumnNamesWithParamsList_5102_6_292()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    return false;
  }

  private boolean jj_3R_ForClause_2023_13_796()
 {
    if (jj_scan_token(K_PATH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_65()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_66()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_63()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ForClause_2015_25_137()) {
    jj_scanpos = xsp;
    if (jj_scan_token(299)) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2017_27_138()) {
    jj_scanpos = xsp;
    if (jj_scan_token(337)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ForClause_2005_27_136()
 {
    if (jj_scan_token(K_ELEMENTS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_62()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ForClause_2004_27_135()
 {
    if (jj_scan_token(K_XMLSCHEMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_61()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ForClause_2002_27_134()
 {
    if (jj_scan_token(K_ROOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_60()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ForClause_2000_25_133()
 {
    if (jj_scan_token(K_BINARY)) return true;
    if (jj_scan_token(K_BASE64)) return true;
    return false;
  }

  private boolean jj_3_58()
 {
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_ForClause_2010_13_795()
 {
    if (jj_scan_token(K_EXPLICIT)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_63()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_TableFunction_5087_5_181()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(160)) jj_scanpos = xsp;
    if (jj_3R_Function_4941_5_223()) return true;
    return false;
  }

  private boolean jj_3_59()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ForClause_2000_25_133()) {
    jj_scanpos = xsp;
    if (jj_scan_token(299)) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2002_27_134()) {
    jj_scanpos = xsp;
    if (jj_scan_token(337)) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2004_27_135()) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2005_27_136()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ForClause_1996_19_809()
 {
    if (jj_scan_token(K_RAW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_58()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_5072_10_740()
 {
    if (jj_scan_token(K_SEPARATOR)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_5071_10_739()
 {
    if (jj_3R_OrderByElements_2940_5_173()) return true;
    return false;
  }

  private boolean jj_3R_ForClause_1995_13_794()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ForClause_1996_19_809()) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_59()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_5069_9_477()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_ForClause_1993_9_378()
 {
    if (jj_scan_token(K_XML)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ForClause_1995_13_794()) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2010_13_795()) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2023_13_796()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_5068_5_253()
 {
    if (jj_scan_token(K_GROUP_CONCAT)) return true;
    if (jj_scan_token(379)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_MySQLGroupConcat_5069_9_477()) jj_scanpos = xsp;
    if (jj_3R_ExpressionList_3606_5_192()) return true;
    xsp = jj_scanpos;
    if (jj_3R_MySQLGroupConcat_5071_10_739()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_MySQLGroupConcat_5072_10_740()) jj_scanpos = xsp;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5009_60_286()
 {
    if (jj_3R_OrderByElements_2940_5_173()) return true;
    return false;
  }

  private boolean jj_3R_XMLSerializeExpr_5048_19_741()
 {
    if (jj_3R_OrderByElements_2940_5_173()) return true;
    return false;
  }

  private boolean jj_3R_ForClause_1989_5_160()
 {
    if (jj_scan_token(K_FOR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_1993_9_378()) {
    jj_scanpos = xsp;
    if (jj_3R_ForClause_2037_9_379()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_LateralView_1963_28_808()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_XMLSerializeExpr_5044_5_618()
 {
    if (jj_scan_token(K_XMLSERIALIZE)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(K_XMLAGG)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(K_XMLTEXT)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    if (jj_scan_token(380)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_XMLSerializeExpr_5048_19_741()) jj_scanpos = xsp;
    if (jj_scan_token(380)) return true;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_ColDataType_5490_5_272()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_293()
 {
    if (jj_3R_Function_4941_5_223()) return true;
    return false;
  }

  private boolean jj_3_57()
 {
    if (jj_3R_RelObjectNameWithoutStart_1774_5_132()) return true;
    return false;
  }

  private boolean jj_3R_LateralView_1963_5_790()
 {
    if (jj_scan_token(K_LATERAL)) return true;
    if (jj_scan_token(K_VIEW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_LateralView_1963_28_808()) jj_scanpos = xsp;
    if (jj_3R_Function_4941_5_223()) return true;
    xsp = jj_scanpos;
    if (jj_3_57()) jj_scanpos = xsp;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_RelObjectNameWithoutStart_1774_5_132()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5023_13_738()
 {
    if (jj_3R_Column_1723_5_227()) return true;
    return false;
  }

  private boolean jj_3_294()
 {
    if (jj_3R_KeepExpression_4613_5_290()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5021_13_737()
 {
    if (jj_3R_Function_4941_5_223()) return true;
    return false;
  }

  private boolean jj_3_290()
 {
    if (jj_3R_AllTableColumns_2373_6_175()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5011_13_289()
 {
    if (jj_3R_Select_1915_5_339()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5017_7_701()
 {
    if (jj_scan_token(383)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_5021_13_737()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_5023_13_738()) return true;
    }
    return false;
  }

  private boolean jj_3_291()
 {
    if (jj_3R_ExpressionList_3606_5_192()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_5009_60_286()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_InternalFunction_5014_8_686()
 {
    if (jj_scan_token(K_IGNORE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3R_ParenthesedSelect_1944_5_115()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_Select_1915_5_339()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5007_13_288()
 {
    if (jj_3R_AllTableColumns_2373_6_175()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5001_19_285()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5000_19_284()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3_56()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_ISOLATION)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_5005_13_287()
 {
    if (jj_scan_token(390)) return true;
    return false;
  }

  private boolean jj_3_55()
 {
    if (jj_scan_token(K_FETCH)) return true;
    return false;
  }

  private boolean jj_3_54()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4999_17_283()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3_53()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3_52()
 {
    if (jj_scan_token(K_ORDER)) return true;
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3_289()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_4999_17_283()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_5000_19_284()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_5001_19_285()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_Select_1930_7_615()
 {
    if (jj_3R_WithIsolation_3098_5_589()) return true;
    return false;
  }

  private boolean jj_3R_Select_1929_7_614()
 {
    if (jj_3R_Fetch_3080_5_588()) return true;
    return false;
  }

  private boolean jj_3R_Select_1928_7_613()
 {
    if (jj_3R_Offset_3059_5_587()) return true;
    return false;
  }

  private boolean jj_3_292()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_289()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_5005_13_287()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_5007_13_288()) {
    jj_scanpos = xsp;
    if (jj_3_291()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_5011_13_289()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_Select_1927_7_612()
 {
    if (jj_3R_LimitWithOffset_2997_5_381()) return true;
    return false;
  }

  private boolean jj_3R_Select_1925_7_611()
 {
    if (jj_3R_OrderByElements_2940_5_173()) return true;
    return false;
  }

  private boolean jj_3_50()
 {
    if (jj_3R_ParenthesedSelect_1944_5_115()) return true;
    return false;
  }

  private boolean jj_3_51()
 {
    if (jj_3R_SetOperationList_2217_5_131()) return true;
    return false;
  }

  private boolean jj_3_49()
 {
    if (jj_3R_Values_1248_5_130()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4993_5_610()
 {
    if (jj_3R_RelObjectNameList_1709_5_382()) return true;
    if (jj_scan_token(379)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_292()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_5014_8_686()) jj_scanpos = xsp;
    if (jj_scan_token(380)) return true;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_5017_7_701()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_294()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_48()
 {
    if (jj_3R_PlainSelect_2119_5_129()) return true;
    return false;
  }

  private boolean jj_3R_Select_1915_7_585()
 {
    if (jj_3R_WithList_2285_5_96()) return true;
    return false;
  }

  private boolean jj_3R_Select_1915_5_339()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Select_1915_7_585()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_48()) {
    jj_scanpos = xsp;
    if (jj_3_49()) {
    jj_scanpos = xsp;
    if (jj_3_50()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3_51()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Select_1925_7_611()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Select_1927_7_612()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Select_1928_7_613()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Select_1929_7_614()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Select_1930_7_615()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_287()
 {
    if (jj_3R_NamedExpressionListExprFirst_3742_9_282()) return true;
    return false;
  }

  private boolean jj_3_288()
 {
    if (jj_3R_ExpressionList_3606_5_192()) return true;
    return false;
  }

  private boolean jj_3R_SpecialStringFunctionWithNamedParameters_4964_13_515()
 {
    if (jj_3R_NamedExpressionListExprFirst_3742_9_282()) return true;
    return false;
  }

  private boolean jj_3R_SelectWithWithItems_1899_5_320()
 {
    if (jj_3R_Select_1915_5_339()) return true;
    return false;
  }

  private boolean jj_3R_SpecialStringFunctionWithNamedParameters_4960_9_281()
 {
    if (jj_scan_token(K_STRING_FUNCTION_NAME)) return true;
    if (jj_scan_token(379)) return true;
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_SpecialStringFunctionWithNamedParameters_4964_13_515()) {
    jj_scanpos = xsp;
    if (jj_3_288()) return true;
    }
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_47()
 {
    if (jj_scan_token(K_SEED)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_Number_1847_5_712()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_46()
 {
    if (jj_scan_token(K_REPEATABLE)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_Number_1847_5_712()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_SampleClause_1873_15_598()
 {
    if (jj_scan_token(K_BLOCK)) return true;
    return false;
  }

  private boolean jj_3R_SampleClause_1876_9_392()
 {
    if (jj_scan_token(K_TABLESAMPLE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(280)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) return true;
    }
    return false;
  }

  private boolean jj_3R_Function_4944_11_446()
 {
    if (jj_3R_InternalFunction_4993_5_610()) return true;
    return false;
  }

  private boolean jj_3_286()
 {
    if (jj_3R_SpecialStringFunctionWithNamedParameters_4960_9_281()) return true;
    return false;
  }

  private boolean jj_3R_Function_4942_9_445()
 {
    if (jj_scan_token(433)) return true;
    if (jj_scan_token(K_FN)) return true;
    if (jj_3R_InternalFunction_4993_5_610()) return true;
    if (jj_scan_token(420)) return true;
    return false;
  }

  private boolean jj_3R_SampleClause_1870_9_391()
 {
    if (jj_scan_token(K_SAMPLE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SampleClause_1873_15_598()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Function_4941_5_223()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Function_4942_9_445()) {
    jj_scanpos = xsp;
    if (jj_3_286()) {
    jj_scanpos = xsp;
    if (jj_3R_Function_4944_11_446()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_SampleClause_1869_5_183()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SampleClause_1870_9_391()) {
    jj_scanpos = xsp;
    if (jj_3R_SampleClause_1876_9_392()) return true;
    }
    if (jj_scan_token(379)) return true;
    if (jj_3R_Number_1847_5_712()) return true;
    if (jj_scan_token(380)) return true;
    xsp = jj_scanpos;
    if (jj_3_46()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_47()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Number_1850_9_753()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_FullTextSearch_4921_9_494()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(429)) {
    jj_scanpos = xsp;
    if (jj_scan_token(430)) {
    jj_scanpos = xsp;
    if (jj_scan_token(431)) {
    jj_scanpos = xsp;
    if (jj_scan_token(432)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_Number_1848_9_752()
 {
    if (jj_scan_token(S_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_FullTextSearch_4918_7_493()
 {
    if (jj_3R_SimpleJdbcNamedParameter_2984_5_637()) return true;
    return false;
  }

  private boolean jj_3R_Number_1847_5_712()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Number_1848_9_752()) {
    jj_scanpos = xsp;
    if (jj_3R_Number_1850_9_753()) return true;
    }
    return false;
  }

  private boolean jj_3R_FullTextSearch_4916_7_492()
 {
    if (jj_3R_SimpleJdbcParameter_2973_5_249()) return true;
    return false;
  }

  private boolean jj_3R_FullTextSearch_4914_7_491()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_FullTextSearch_4911_5_257()
 {
    if (jj_scan_token(K_MATCH)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_ColumnList_3675_5_118()) return true;
    if (jj_scan_token(380)) return true;
    if (jj_scan_token(K_AGAINST)) return true;
    if (jj_scan_token(379)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FullTextSearch_4914_7_491()) {
    jj_scanpos = xsp;
    if (jj_3R_FullTextSearch_4916_7_492()) {
    jj_scanpos = xsp;
    if (jj_3R_FullTextSearch_4918_7_493()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_FullTextSearch_4921_9_494()) jj_scanpos = xsp;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_45()
 {
    if (jj_3R_Alias_2389_5_128()) return true;
    return false;
  }

  private boolean jj_3R_TableWithAlias_1836_5_122()
 {
    if (jj_3R_Table_1821_5_163()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_45()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_285()
 {
    if (jj_3R_ExpressionList_3606_5_192()) return true;
    return false;
  }

  private boolean jj_3R_Execute_4889_11_711()
 {
    if (jj_scan_token(K_CALL)) return true;
    return false;
  }

  private boolean jj_3R_Execute_4888_11_710()
 {
    if (jj_scan_token(K_EXECUTE)) return true;
    return false;
  }

  private boolean jj_3R_Table_1821_5_163()
 {
    if (jj_3R_RelObjectNameList_1709_5_382()) return true;
    return false;
  }

  private boolean jj_3R_Execute_4887_6_709()
 {
    if (jj_scan_token(K_EXEC)) return true;
    return false;
  }

  private boolean jj_3R_Execute_4887_5_658()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Execute_4887_6_709()) {
    jj_scanpos = xsp;
    if (jj_3R_Execute_4888_11_710()) {
    jj_scanpos = xsp;
    if (jj_3R_Execute_4889_11_711()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_RelObjectNameExt2_1811_7_343()
 {
    if (jj_3R_RelObjectNameExt_1792_5_332()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameExt2_1811_5_126()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectNameExt2_1811_7_343()) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_RelObjectNameExt_1792_7_580()
 {
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameExt_1792_5_332()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectNameExt_1792_7_580()) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(273)) {
    jj_scanpos = xsp;
    if (jj_scan_token(162)) {
    jj_scanpos = xsp;
    if (jj_scan_token(250)) {
    jj_scanpos = xsp;
    if (jj_scan_token(265)) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) {
    jj_scanpos = xsp;
    if (jj_scan_token(130)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(211)) {
    jj_scanpos = xsp;
    if (jj_scan_token(164)) {
    jj_scanpos = xsp;
    if (jj_scan_token(200)) {
    jj_scanpos = xsp;
    if (jj_scan_token(223)) {
    jj_scanpos = xsp;
    if (jj_scan_token(224)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(206)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_RowConstructor_4855_5_230()
 {
    if (jj_scan_token(K_ROW)) return true;
    if (jj_3R_ParenthesedExpressionList_3643_5_193()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameWithoutStart_1774_6_357()
 {
    if (jj_3R_RelObjectNameWithoutValue_1750_5_117()) return true;
    return false;
  }

  private boolean jj_3_284()
 {
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameWithoutStart_1774_5_132()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectNameWithoutStart_1774_6_357()) {
    jj_scanpos = xsp;
    if (jj_scan_token(293)) {
    jj_scanpos = xsp;
    if (jj_scan_token(318)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_WhenThenSearchCondition_4840_9_765()
 {
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3R_WhenThenSearchCondition_4837_5_621()
 {
    if (jj_scan_token(K_WHEN)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    if (jj_scan_token(K_THEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing) && !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_WhenThenSearchCondition_4840_9_765()) {
    jj_scanpos = xsp;
    if (jj_3_284()) return true;
    }
    return false;
  }

  private boolean jj_3R_RelObjectName_1762_6_380()
 {
    if (jj_3R_RelObjectNameWithoutValue_1750_5_117()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectName_1762_5_161()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectName_1762_6_380()) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(201)) {
    jj_scanpos = xsp;
    if (jj_scan_token(274)) {
    jj_scanpos = xsp;
    if (jj_scan_token(293)) {
    jj_scanpos = xsp;
    if (jj_scan_token(318)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(282)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(226)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_283()
 {
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_4817_15_727()
 {
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameWithoutValue_1750_5_117()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(378)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(315)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(289)) {
    jj_scanpos = xsp;
    if (jj_scan_token(3)) {
    jj_scanpos = xsp;
    if (jj_scan_token(4)) {
    jj_scanpos = xsp;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(6)) {
    jj_scanpos = xsp;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(385)) {
    jj_scanpos = xsp;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(97)) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) {
    jj_scanpos = xsp;
    if (jj_scan_token(106)) {
    jj_scanpos = xsp;
    if (jj_scan_token(108)) {
    jj_scanpos = xsp;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(158)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_scan_token(118)) {
    jj_scanpos = xsp;
    if (jj_scan_token(119)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_scan_token(125)) {
    jj_scanpos = xsp;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_scan_token(129)) {
    jj_scanpos = xsp;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) {
    jj_scanpos = xsp;
    if (jj_scan_token(138)) {
    jj_scanpos = xsp;
    if (jj_scan_token(141)) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) {
    jj_scanpos = xsp;
    if (jj_scan_token(143)) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) {
    jj_scanpos = xsp;
    if (jj_scan_token(155)) {
    jj_scanpos = xsp;
    if (jj_scan_token(156)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) {
    jj_scanpos = xsp;
    if (jj_scan_token(159)) {
    jj_scanpos = xsp;
    if (jj_scan_token(161)) {
    jj_scanpos = xsp;
    if (jj_scan_token(167)) {
    jj_scanpos = xsp;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(166)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) {
    jj_scanpos = xsp;
    if (jj_scan_token(170)) {
    jj_scanpos = xsp;
    if (jj_scan_token(171)) {
    jj_scanpos = xsp;
    if (jj_scan_token(172)) {
    jj_scanpos = xsp;
    if (jj_scan_token(173)) {
    jj_scanpos = xsp;
    if (jj_scan_token(174)) {
    jj_scanpos = xsp;
    if (jj_scan_token(175)) {
    jj_scanpos = xsp;
    if (jj_scan_token(177)) {
    jj_scanpos = xsp;
    if (jj_scan_token(178)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(181)) {
    jj_scanpos = xsp;
    if (jj_scan_token(183)) {
    jj_scanpos = xsp;
    if (jj_scan_token(184)) {
    jj_scanpos = xsp;
    if (jj_scan_token(186)) {
    jj_scanpos = xsp;
    if (jj_scan_token(187)) {
    jj_scanpos = xsp;
    if (jj_scan_token(188)) {
    jj_scanpos = xsp;
    if (jj_scan_token(189)) {
    jj_scanpos = xsp;
    if (jj_scan_token(190)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) {
    jj_scanpos = xsp;
    if (jj_scan_token(193)) {
    jj_scanpos = xsp;
    if (jj_scan_token(194)) {
    jj_scanpos = xsp;
    if (jj_scan_token(197)) {
    jj_scanpos = xsp;
    if (jj_scan_token(196)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) {
    jj_scanpos = xsp;
    if (jj_scan_token(199)) {
    jj_scanpos = xsp;
    if (jj_scan_token(203)) {
    jj_scanpos = xsp;
    if (jj_scan_token(209)) {
    jj_scanpos = xsp;
    if (jj_scan_token(210)) {
    jj_scanpos = xsp;
    if (jj_scan_token(212)) {
    jj_scanpos = xsp;
    if (jj_scan_token(213)) {
    jj_scanpos = xsp;
    if (jj_scan_token(214)) {
    jj_scanpos = xsp;
    if (jj_scan_token(215)) {
    jj_scanpos = xsp;
    if (jj_scan_token(216)) {
    jj_scanpos = xsp;
    if (jj_scan_token(218)) {
    jj_scanpos = xsp;
    if (jj_scan_token(219)) {
    jj_scanpos = xsp;
    if (jj_scan_token(220)) {
    jj_scanpos = xsp;
    if (jj_scan_token(221)) {
    jj_scanpos = xsp;
    if (jj_scan_token(222)) {
    jj_scanpos = xsp;
    if (jj_scan_token(225)) {
    jj_scanpos = xsp;
    if (jj_scan_token(227)) {
    jj_scanpos = xsp;
    if (jj_scan_token(228)) {
    jj_scanpos = xsp;
    if (jj_scan_token(229)) {
    jj_scanpos = xsp;
    if (jj_scan_token(230)) {
    jj_scanpos = xsp;
    if (jj_scan_token(231)) {
    jj_scanpos = xsp;
    if (jj_scan_token(232)) {
    jj_scanpos = xsp;
    if (jj_scan_token(233)) {
    jj_scanpos = xsp;
    if (jj_scan_token(235)) {
    jj_scanpos = xsp;
    if (jj_scan_token(236)) {
    jj_scanpos = xsp;
    if (jj_scan_token(239)) {
    jj_scanpos = xsp;
    if (jj_scan_token(240)) {
    jj_scanpos = xsp;
    if (jj_scan_token(241)) {
    jj_scanpos = xsp;
    if (jj_scan_token(242)) {
    jj_scanpos = xsp;
    if (jj_scan_token(243)) {
    jj_scanpos = xsp;
    if (jj_scan_token(244)) {
    jj_scanpos = xsp;
    if (jj_scan_token(247)) {
    jj_scanpos = xsp;
    if (jj_scan_token(248)) {
    jj_scanpos = xsp;
    if (jj_scan_token(245)) {
    jj_scanpos = xsp;
    if (jj_scan_token(246)) {
    jj_scanpos = xsp;
    if (jj_scan_token(238)) {
    jj_scanpos = xsp;
    if (jj_scan_token(251)) {
    jj_scanpos = xsp;
    if (jj_scan_token(252)) {
    jj_scanpos = xsp;
    if (jj_scan_token(253)) {
    jj_scanpos = xsp;
    if (jj_scan_token(254)) {
    jj_scanpos = xsp;
    if (jj_scan_token(386)) {
    jj_scanpos = xsp;
    if (jj_scan_token(387)) {
    jj_scanpos = xsp;
    if (jj_scan_token(257)) {
    jj_scanpos = xsp;
    if (jj_scan_token(258)) {
    jj_scanpos = xsp;
    if (jj_scan_token(259)) {
    jj_scanpos = xsp;
    if (jj_scan_token(263)) {
    jj_scanpos = xsp;
    if (jj_scan_token(262)) {
    jj_scanpos = xsp;
    if (jj_scan_token(264)) {
    jj_scanpos = xsp;
    if (jj_scan_token(266)) {
    jj_scanpos = xsp;
    if (jj_scan_token(267)) {
    jj_scanpos = xsp;
    if (jj_scan_token(268)) {
    jj_scanpos = xsp;
    if (jj_scan_token(269)) {
    jj_scanpos = xsp;
    if (jj_scan_token(314)) {
    jj_scanpos = xsp;
    if (jj_scan_token(270)) {
    jj_scanpos = xsp;
    if (jj_scan_token(271)) {
    jj_scanpos = xsp;
    if (jj_scan_token(272)) {
    jj_scanpos = xsp;
    if (jj_scan_token(275)) {
    jj_scanpos = xsp;
    if (jj_scan_token(276)) {
    jj_scanpos = xsp;
    if (jj_scan_token(277)) {
    jj_scanpos = xsp;
    if (jj_scan_token(278)) {
    jj_scanpos = xsp;
    if (jj_scan_token(279)) {
    jj_scanpos = xsp;
    if (jj_scan_token(280)) {
    jj_scanpos = xsp;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(284)) {
    jj_scanpos = xsp;
    if (jj_scan_token(287)) {
    jj_scanpos = xsp;
    if (jj_scan_token(288)) {
    jj_scanpos = xsp;
    if (jj_scan_token(286)) {
    jj_scanpos = xsp;
    if (jj_scan_token(290)) {
    jj_scanpos = xsp;
    if (jj_scan_token(388)) {
    jj_scanpos = xsp;
    if (jj_scan_token(292)) {
    jj_scanpos = xsp;
    if (jj_scan_token(285)) {
    jj_scanpos = xsp;
    if (jj_scan_token(296)) {
    jj_scanpos = xsp;
    if (jj_scan_token(295)) {
    jj_scanpos = xsp;
    if (jj_scan_token(298)) {
    jj_scanpos = xsp;
    if (jj_scan_token(299)) {
    jj_scanpos = xsp;
    if (jj_scan_token(303)) {
    jj_scanpos = xsp;
    if (jj_scan_token(307)) {
    jj_scanpos = xsp;
    if (jj_scan_token(316)) {
    jj_scanpos = xsp;
    if (jj_scan_token(305)) {
    jj_scanpos = xsp;
    if (jj_scan_token(306)) {
    jj_scanpos = xsp;
    if (jj_scan_token(389)) {
    jj_scanpos = xsp;
    if (jj_scan_token(309)) {
    jj_scanpos = xsp;
    if (jj_scan_token(317)) {
    jj_scanpos = xsp;
    if (jj_scan_token(321)) {
    jj_scanpos = xsp;
    if (jj_scan_token(322)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) {
    jj_scanpos = xsp;
    if (jj_scan_token(329)) {
    jj_scanpos = xsp;
    if (jj_scan_token(330)) {
    jj_scanpos = xsp;
    if (jj_scan_token(332)) {
    jj_scanpos = xsp;
    if (jj_scan_token(333)) {
    jj_scanpos = xsp;
    if (jj_scan_token(336)) {
    jj_scanpos = xsp;
    if (jj_scan_token(337)) {
    jj_scanpos = xsp;
    if (jj_scan_token(338)) {
    jj_scanpos = xsp;
    if (jj_scan_token(339)) {
    jj_scanpos = xsp;
    if (jj_scan_token(340)) {
    jj_scanpos = xsp;
    if (jj_scan_token(341)) {
    jj_scanpos = xsp;
    if (jj_scan_token(342)) {
    jj_scanpos = xsp;
    if (jj_scan_token(343)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_4815_9_687()
 {
    if (jj_scan_token(K_ELSE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing) && !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_CaseWhenExpression_4817_15_727()) {
    jj_scanpos = xsp;
    if (jj_3_283()) return true;
    }
    return false;
  }

  private boolean jj_3R_WindowOffset_4730_91_802()
 {
    if (jj_scan_token(K_FOLLOWING)) return true;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_4813_7_473()
 {
    if (jj_3R_WhenThenSearchCondition_4837_5_621()) return true;
    return false;
  }

  private boolean jj_3_282()
 {
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3R_ExtractExpression_4749_70_476()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_4811_5_248()
 {
    if (jj_scan_token(K_CASE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_282()) jj_scanpos = xsp;
    if (jj_3R_CaseWhenExpression_4813_7_473()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CaseWhenExpression_4813_7_473()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_CaseWhenExpression_4815_9_687()) jj_scanpos = xsp;
    if (jj_scan_token(K_END)) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameList_1710_34_125()
 {
    if (jj_scan_token(383)) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_4575_237_499()
 {
    if (jj_3R_Column_1723_5_227()) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_4721_89_800()
 {
    if (jj_scan_token(K_FOLLOWING)) return true;
    return false;
  }

  private boolean jj_3_44()
 {
    if (jj_3R_ArrayConstructor_4229_5_127()) return true;
    return false;
  }

  private boolean jj_3R_Column_1726_7_502()
 {
    if (jj_scan_token(383)) return true;
    if (jj_scan_token(K_NEXTVAL)) return true;
    return false;
  }

  private boolean jj_3R_CastExpression_4788_15_769()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_ColumnDefinition_5178_5_526()) return true;
    return false;
  }

  private boolean jj_3R_CastExpression_4792_9_743()
 {
    if (jj_3R_ColDataType_5490_5_272()) return true;
    return false;
  }

  private boolean jj_3R_Column_1723_5_227()
 {
    if (jj_3R_RelObjectNameList_1709_5_382()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Column_1726_7_502()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_44()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CastExpression_4784_9_742()
 {
    if (jj_scan_token(K_ROW)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_ColumnDefinition_5178_5_526()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CastExpression_4788_15_769()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_43()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(383)) {
    jj_scanpos = xsp;
    if (jj_scan_token(384)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_RelObjectNameList_1710_34_125()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_RelObjectNameExt2_1811_5_126()) return true;
    return false;
  }

  private boolean jj_3_278()
 {
    if (jj_3R_windowFun_4630_5_279()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameList_1709_5_382()
 {
    if (jj_3R_RelObjectNameExt_1792_5_332()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_43()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_273()
 {
    if (jj_3R_Function_4941_5_223()) return true;
    return false;
  }

  private boolean jj_3R_CastExpression_4768_5_259()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(255)) {
    jj_scanpos = xsp;
    if (jj_scan_token(297)) {
    jj_scanpos = xsp;
    if (jj_scan_token(143)) return true;
    }
    }
    }
    if (jj_scan_token(379)) return true;
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    if (jj_scan_token(K_AS)) return true;
    xsp = jj_scanpos;
    if (jj_3R_CastExpression_4784_9_742()) {
    jj_scanpos = xsp;
    if (jj_3R_CastExpression_4792_9_743()) return true;
    }
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_4575_195_498()
 {
    if (jj_3R_Function_4941_5_223()) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_4697_71_735()
 {
    if (jj_scan_token(K_RANGE)) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_4720_40_799()
 {
    if (jj_scan_token(K_PRECEDING)) return true;
    return false;
  }

  private boolean jj_3R_ExtractExpression_4749_11_475()
 {
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_4730_26_801()
 {
    if (jj_scan_token(K_PRECEDING)) return true;
    return false;
  }

  private boolean jj_3R_ExtractExpression_4747_5_252()
 {
    if (jj_scan_token(K_EXTRACT)) return true;
    if (jj_scan_token(379)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExtractExpression_4749_11_475()) {
    jj_scanpos = xsp;
    if (jj_3R_ExtractExpression_4749_70_476()) return true;
    }
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_MergeUpdateClause_1671_5_124()
 {
    if (jj_scan_token(K_WHEN)) return true;
    if (jj_scan_token(K_MATCHED)) return true;
    return false;
  }

  private boolean jj_3_281()
 {
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowOffset_4730_26_801()) {
    jj_scanpos = xsp;
    if (jj_3R_WindowOffset_4730_91_802()) return true;
    }
    return false;
  }

  private boolean jj_3_280()
 {
    if (jj_scan_token(K_CURRENT)) return true;
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_4575_165_497()
 {
    if (jj_3R_JdbcNamedParameter_4157_5_250()) return true;
    return false;
  }

  private boolean jj_3_42()
 {
    if (jj_3R_MergeUpdateClause_1671_5_124()) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_4719_17_514()
 {
    if (jj_scan_token(K_UNBOUNDED)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowOffset_4720_40_799()) {
    jj_scanpos = xsp;
    if (jj_3R_WindowOffset_4721_89_800()) return true;
    }
    return false;
  }

  private boolean jj_3R_Delete_1618_45_123()
 {
    if (jj_3R_JoinsList_2681_5_152()) return true;
    return false;
  }

  private boolean jj_3R_Merge_1650_5_324()
 {
    if (jj_scan_token(K_MERGE)) return true;
    if (jj_scan_token(K_INTO)) return true;
    if (jj_3R_TableWithAlias_1836_5_122()) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_4718_5_280()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowOffset_4719_17_514()) {
    jj_scanpos = xsp;
    if (jj_3_280()) {
    jj_scanpos = xsp;
    if (jj_3_281()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_279()
 {
    if (jj_3R_WindowOffset_4718_5_280()) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_4698_7_736()
 {
    if (jj_scan_token(K_BETWEEN)) return true;
    if (jj_3R_WindowOffset_4718_5_280()) return true;
    if (jj_scan_token(K_AND)) return true;
    if (jj_3R_WindowOffset_4718_5_280()) return true;
    return false;
  }

  private boolean jj_3R_Delete_1613_20_121()
 {
    if (jj_3R_TableWithAlias_1836_5_122()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_Delete_1614_12_341()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_Delete_1615_7_342()) jj_scanpos = xsp;
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3R_Delete_1625_7_571()
 {
    if (jj_3R_ReturningClause_1264_5_674()) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_4697_6_734()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_4697_5_700()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowElement_4697_6_734()) {
    jj_scanpos = xsp;
    if (jj_3R_WindowElement_4697_71_735()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_WindowElement_4698_7_736()) {
    jj_scanpos = xsp;
    if (jj_3_279()) return true;
    }
    return false;
  }

  private boolean jj_3R_Delete_1623_6_570()
 {
    if (jj_3R_PlainLimit_3020_5_673()) return true;
    return false;
  }

  private boolean jj_3R_Delete_1622_6_569()
 {
    if (jj_3R_OrderByElements_2940_5_173()) return true;
    return false;
  }

  private boolean jj_3R_Delete_1621_6_568()
 {
    if (jj_3R_WhereClause_2830_5_155()) return true;
    return false;
  }

  private boolean jj_3R_Delete_1614_12_341()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_TableWithAlias_1836_5_122()) return true;
    return false;
  }

  private boolean jj_3R_Delete_1619_7_567()
 {
    if (jj_scan_token(K_USING)) return true;
    if (jj_3R_TableWithAlias_1836_5_122()) return true;
    return false;
  }

  private boolean jj_3_41()
 {
    if (jj_3R_TableWithAlias_1836_5_122()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Delete_1618_45_123()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AnalyticExpression_4683_11_472()
 {
    if (jj_3R_windowFun_4630_5_279()) return true;
    return false;
  }

  private boolean jj_3R_Delete_1615_7_342()
 {
    if (jj_3R_OutputClause_1523_5_586()) return true;
    return false;
  }

  private boolean jj_3R_KeepExpression_4613_79_768()
 {
    if (jj_scan_token(K_LAST)) return true;
    return false;
  }

  private boolean jj_3_39()
 {
    if (jj_scan_token(K_IGNORE)) return true;
    return false;
  }

  private boolean jj_3_40()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Delete_1613_20_121()) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) return true;
    }
    return false;
  }

  private boolean jj_3_38()
 {
    if (jj_scan_token(K_QUICK)) return true;
    return false;
  }

  private boolean jj_3_37()
 {
    if (jj_scan_token(K_LOW_PRIORITY)) return true;
    return false;
  }

  private boolean jj_3R_AnalyticExpression_4682_6_471()
 {
    if (jj_scan_token(K_FILTER)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(K_WHERE)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    if (jj_scan_token(380)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_278()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AnalyticExpression_4682_5_247()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AnalyticExpression_4682_6_471()) {
    jj_scanpos = xsp;
    if (jj_3R_AnalyticExpression_4683_11_472()) return true;
    }
    return false;
  }

  private boolean jj_3_272()
 {
    if (jj_3R_SimpleJdbcParameter_2973_5_249()) return true;
    return false;
  }

  private boolean jj_3R_Delete_1609_5_323()
 {
    if (jj_scan_token(K_DELETE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_37()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_38()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_39()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_40()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_41()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Delete_1619_7_567()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Delete_1621_6_568()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Delete_1622_6_569()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Delete_1623_6_570()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Delete_1625_7_571()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_277()
 {
    if (jj_3R_ComplexExpressionList_3699_5_224()) return true;
    return false;
  }

  private boolean jj_3_275()
 {
    if (jj_3R_ComplexExpressionList_3699_5_224()) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_4575_101_496()
 {
    if (jj_3R_SimpleJdbcParameter_2973_5_249()) return true;
    return false;
  }

  private boolean jj_3R_windowDefinition_4663_11_798()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_ComplexExpressionList_3699_5_224()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_windowDefinition_4662_10_797()
 {
    if (jj_3R_ComplexExpressionList_3699_5_224()) return true;
    return false;
  }

  private boolean jj_3R_windowDefinition_4666_6_781()
 {
    if (jj_3R_WindowElement_4697_5_700()) return true;
    return false;
  }

  private boolean jj_3R_windowDefinition_4665_6_780()
 {
    if (jj_3R_OrderByElements_2940_5_173()) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4646_23_813()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_ComplexExpressionList_3699_5_224()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4645_22_812()
 {
    if (jj_3R_ComplexExpressionList_3699_5_224()) return true;
    return false;
  }

  private boolean jj_3R_windowDefinition_4661_6_779()
 {
    if (jj_scan_token(K_PARTITION)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowDefinition_4662_10_797()) {
    jj_scanpos = xsp;
    if (jj_3R_windowDefinition_4663_11_798()) return true;
    }
    return false;
  }

  private boolean jj_3R_windowDefinition_4660_5_643()
 {
    if (jj_scan_token(379)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowDefinition_4661_6_779()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowDefinition_4665_6_780()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowDefinition_4666_6_781()) jj_scanpos = xsp;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4644_17_811()
 {
    if (jj_scan_token(K_PARTITION)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_4645_22_812()) {
    jj_scanpos = xsp;
    if (jj_3R_windowFun_4646_23_813()) return true;
    }
    return false;
  }

  private boolean jj_3_276()
 {
    if (jj_scan_token(K_OVER)) return true;
    if (jj_scan_token(379)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_4644_17_811()) jj_scanpos = xsp;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_KeepExpression_4613_42_767()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_Upsert_1573_9_329()
 {
    if (jj_3R_Select_1915_5_339()) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4640_9_513()
 {
    if (jj_3R_windowDefinition_4660_5_643()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_276()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Upsert_1568_9_328()
 {
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4638_9_512()
 {
    if (jj_3R_RelObjectName_1762_5_161()) return true;
    return false;
  }

  private boolean jj_3_36()
 {
    if (jj_3R_ParenthesedColumnList_3687_5_120()) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4634_9_511()
 {
    if (jj_scan_token(K_WITHIN)) return true;
    if (jj_scan_token(K_GROUP)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4631_10_642()
 {
    if (jj_scan_token(K_IGNORE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3_35()
 {
    if (jj_scan_token(K_INTO)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4631_9_510()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_4631_10_642()) jj_scanpos = xsp;
    if (jj_scan_token(K_OVER)) return true;
    return false;
  }

  private boolean jj_3R_Upsert_1558_9_327()
 {
    if (jj_scan_token(K_INSERT)) return true;
    if (jj_scan_token(K_OR)) return true;
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3R_Upsert_1556_9_326()
 {
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4630_5_279()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_4631_9_510()) {
    jj_scanpos = xsp;
    if (jj_3R_windowFun_4634_9_511()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_windowFun_4638_9_512()) {
    jj_scanpos = xsp;
    if (jj_3R_windowFun_4640_9_513()) return true;
    }
    return false;
  }

  private boolean jj_3R_Upsert_1554_9_325()
 {
    if (jj_scan_token(K_UPSERT)) return true;
    return false;
  }

  private boolean jj_3R_Upsert_1553_5_102()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Upsert_1554_9_325()) {
    jj_scanpos = xsp;
    if (jj_3R_Upsert_1556_9_326()) {
    jj_scanpos = xsp;
    if (jj_3R_Upsert_1558_9_327()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3_35()) jj_scanpos = xsp;
    if (jj_3R_Table_1821_5_163()) return true;
    xsp = jj_scanpos;
    if (jj_3_36()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Upsert_1568_9_328()) {
    jj_scanpos = xsp;
    if (jj_3R_Upsert_1573_9_329()) return true;
    }
    return false;
  }

  private boolean jj_3R_KeepExpression_4613_5_290()
 {
    if (jj_scan_token(K_KEEP)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_KeepExpression_4613_42_767()) {
    jj_scanpos = xsp;
    if (jj_3R_KeepExpression_4613_79_768()) return true;
    }
    if (jj_3R_OrderByElements_2940_5_173()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_34()
 {
    if (jj_3R_ColumnsNamesList_5732_5_119()) return true;
    return false;
  }

  private boolean jj_3R_OutputClause_1525_9_680()
 {
    if (jj_scan_token(K_INTO)) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpressionWithoutInterval_4596_5_263()
 {
    if (jj_scan_token(K_DATE_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_OutputClause_1523_5_586()
 {
    if (jj_scan_token(K_OUTPUT)) return true;
    if (jj_3R_SelectItemsList_2313_5_178()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OutputClause_1525_9_680()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_IntervalExpression_4575_19_495()
 {
    if (jj_scan_token(405)) return true;
    return false;
  }

  private boolean jj_3_274()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) return true;
    }
    return false;
  }

  private boolean jj_3_33()
 {
    if (jj_scan_token(K_DO)) return true;
    if (jj_scan_token(K_NOTHING)) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_4574_1_258()
 {
    if (jj_scan_token(K_INTERVAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IntervalExpression_4575_19_495()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(352)) {
    jj_scanpos = xsp;
    if (jj_scan_token(351)) {
    jj_scanpos = xsp;
    if (jj_scan_token(377)) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_4575_101_496()) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_4575_165_497()) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_4575_195_498()) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_4575_237_499()) return true;
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_274()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_270()
 {
    if (jj_3R_ComplexExpressionList_3699_5_224()) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4548_19_699()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_ComplexExpressionList_3699_5_224()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4551_14_636()
 {
    if (jj_3R_WindowElement_4697_5_700()) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4547_18_698()
 {
    if (jj_3R_ComplexExpressionList_3699_5_224()) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4550_14_635()
 {
    if (jj_3R_OrderByElements_2940_5_173()) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4546_14_634()
 {
    if (jj_scan_token(K_PARTITION)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4547_18_698()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_4548_19_699()) return true;
    }
    return false;
  }

  private boolean jj_3_271()
 {
    if (jj_scan_token(K_OVER)) return true;
    if (jj_scan_token(379)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4546_14_634()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4550_14_635()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4551_14_636()) jj_scanpos = xsp;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_269()
 {
    if (jj_scan_token(K_FILTER)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(K_WHERE)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4530_15_697()
 {
    if (jj_scan_token(K_ABSENT)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3_268()
 {
    if (jj_scan_token(K_NULL)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4526_15_633()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_268()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_4530_15_697()) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4523_15_632()
 {
    if (jj_3R_OrderByElements_2940_5_173()) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4522_15_631()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4518_11_490()
 {
    if (jj_scan_token(K_JSON_ARRAYAGG)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4522_15_631()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4523_15_632()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4526_15_633()) jj_scanpos = xsp;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4511_15_696()
 {
    if (jj_scan_token(K_WITHOUT)) return true;
    if (jj_scan_token(K_UNIQUE)) return true;
    if (jj_scan_token(K_KEYS)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4507_15_630()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4507_15_695()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_4511_15_696()) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4507_15_695()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_UNIQUE)) return true;
    if (jj_scan_token(K_KEYS)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4501_15_694()
 {
    if (jj_scan_token(K_ABSENT)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_Insert_1423_21_116()
 {
    if (jj_scan_token(K_AS)) return true;
    return false;
  }

  private boolean jj_3_32()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_DUPLICATE)) return true;
    return false;
  }

  private boolean jj_3R_Insert_1434_9_565()
 {
    if (jj_3R_Select_1915_5_339()) return true;
    return false;
  }

  private boolean jj_3_267()
 {
    if (jj_scan_token(K_NULL)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4491_21_627()
 {
    if (jj_scan_token(K_VALUE)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4497_15_629()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_267()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_4501_15_694()) return true;
    }
    return false;
  }

  private boolean jj_3R_Insert_1430_9_564()
 {
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4494_15_628()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4408_101_731()
 {
    if (jj_scan_token(K_VALUE)) return true;
    return false;
  }

  private boolean jj_3R_Insert_1427_7_563()
 {
    if (jj_3R_OutputClause_1523_5_586()) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4489_15_626()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3_31()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_ColumnList_3675_5_118()) return true;
    return false;
  }

  private boolean jj_3_30()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Insert_1423_21_116()) jj_scanpos = xsp;
    if (jj_3R_RelObjectNameWithoutValue_1750_5_117()) return true;
    return false;
  }

  private boolean jj_3_29()
 {
    if (jj_scan_token(K_INTO)) return true;
    return false;
  }

  private boolean jj_3_28()
 {
    if (jj_scan_token(K_IGNORE)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4487_11_489()
 {
    if (jj_scan_token(K_JSON_OBJECTAGG)) return true;
    if (jj_scan_token(379)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4489_15_626()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(350)) {
    jj_scanpos = xsp;
    if (jj_scan_token(351)) {
    jj_scanpos = xsp;
    if (jj_scan_token(352)) {
    jj_scanpos = xsp;
    if (jj_scan_token(354)) {
    jj_scanpos = xsp;
    if (jj_scan_token(377)) {
    jj_scanpos = xsp;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(378)) return true;
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(384)) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_4491_21_627()) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(378)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4494_15_628()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4497_15_629()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4507_15_630()) jj_scanpos = xsp;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_27()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(169)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(127)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_JsonFunction_4387_104_278()
 {
    if (jj_scan_token(K_VALUE)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4485_5_256()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4487_11_489()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_4518_11_490()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_269()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_271()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Insert_1411_5_321()
 {
    if (jj_scan_token(K_INSERT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_27()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_28()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_29()) jj_scanpos = xsp;
    if (jj_3R_Table_1821_5_163()) return true;
    xsp = jj_scanpos;
    if (jj_3_30()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_31()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Insert_1427_7_563()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Insert_1430_9_564()) {
    jj_scanpos = xsp;
    if (jj_3R_Insert_1434_9_565()) return true;
    }
    return false;
  }

  private boolean jj_3_264()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4459_19_625()
 {
    if (jj_scan_token(K_ABSENT)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4452_25_733()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_264()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_263()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3_266()
 {
    if (jj_3R_Expression_3221_5_111()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_263()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JsonFunction_4452_25_733()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_262()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_265()) {
    jj_scanpos = xsp;
    if (jj_3_266()) return true;
    }
    return false;
  }

  private boolean jj_3_265()
 {
    if (jj_scan_token(K_NULL)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_3R_ParenthesedSelect_1944_5_115()) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4432_23_693()
 {
    if (jj_scan_token(K_WITHOUT)) return true;
    if (jj_scan_token(K_UNIQUE)) return true;
    if (jj_scan_token(K_KEYS)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4440_11_488()
 {
    if (jj_scan_token(K_JSON_ARRAY)) return true;
    if (jj_scan_token(379)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_262()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4459_19_625()) jj_scanpos = xsp;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4428_23_624()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4428_23_692()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4432_23_693()) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonFunction_4428_23_692()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_UNIQUE)) return true;
    if (jj_scan_token(K_KEYS)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4408_41_730()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4412_35_732()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4422_23_691()
 {
    if (jj_scan_token(K_ABSENT)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3_25()
 {
    if (jj_3R_ParenthesedSelect_1944_5_115()) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4406_37_729()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4418_23_623()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4418_23_690()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4422_23_691()) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonFunction_4418_23_690()
 {
    if (jj_scan_token(K_NULL)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4405_33_689()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4406_37_729()) jj_scanpos = xsp;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(384)) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4408_41_730()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4408_101_731()) return true;
    }
    }
    if (jj_3R_Expression_3221_5_111()) return true;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4412_35_732()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JsonFunction_4387_42_277()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4391_35_728()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3_261()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(384)) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4387_42_277()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4387_104_278()) return true;
    }
    }
    if (jj_3R_Expression_3221_5_111()) return true;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4391_35_728()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JsonFunction_4383_33_688()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_Update_1307_30_566()
 {
    if (jj_3R_JoinsList_2681_5_152()) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4382_25_622()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4383_33_688()) jj_scanpos = xsp;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    xsp = jj_scanpos;
    if (jj_3_261()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JsonFunction_4405_33_689()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_JsonFunction_4377_11_487()
 {
    if (jj_scan_token(K_JSON_OBJECT)) return true;
    if (jj_scan_token(379)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4382_25_622()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4418_23_623()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4428_23_624()) jj_scanpos = xsp;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_scan_token(K_IGNORE)) return true;
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_scan_token(K_LOW_PRIORITY)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4375_5_255()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4377_11_487()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4440_11_488()) return true;
    }
    return false;
  }

  private boolean jj_3R_Update_1304_4_322()
 {
    if (jj_scan_token(K_UPDATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_23()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_24()) jj_scanpos = xsp;
    if (jj_3R_TableWithAlias_1836_5_122()) return true;
    xsp = jj_scanpos;
    if (jj_3R_Update_1307_30_566()) jj_scanpos = xsp;
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4349_17_276()
 {
    if (jj_scan_token(428)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4347_17_275()
 {
    if (jj_scan_token(427)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4345_17_274()
 {
    if (jj_scan_token(426)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(377)) {
    jj_scanpos = xsp;
    if (jj_scan_token(352)) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonExpression_4343_17_273()
 {
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(377)) {
    jj_scanpos = xsp;
    if (jj_scan_token(352)) return true;
    }
    return false;
  }

  private boolean jj_3R_ShowTables_1233_53_584()
 {
    if (jj_scan_token(K_WHERE)) return true;
    return false;
  }

  private boolean jj_3_260()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonExpression_4343_17_273()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_4345_17_274()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_4347_17_275()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_4349_17_276()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ReturningClause_1264_5_674()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(249)) {
    jj_scanpos = xsp;
    if (jj_scan_token(382)) return true;
    }
    if (jj_3R_SelectItemsList_2313_5_178()) return true;
    return false;
  }

  private boolean jj_3_259()
 {
    if (jj_scan_token(423)) return true;
    if (jj_3R_ColDataType_5490_5_272()) return true;
    return false;
  }

  private boolean jj_3_258()
 {
    Token xsp;
    if (jj_3_259()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_259()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_260()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_JsonExpression_4317_13_271()
 {
    if (jj_scan_token(428)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4315_13_270()
 {
    if (jj_scan_token(427)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4313_13_269()
 {
    if (jj_scan_token(426)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(377)) {
    jj_scanpos = xsp;
    if (jj_scan_token(352)) return true;
    }
    return false;
  }

  private boolean jj_3R_Values_1248_5_130()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(318)) return true;
    }
    if (jj_3R_ExpressionList_3606_5_192()) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4311_13_268()
 {
    if (jj_scan_token(425)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(377)) {
    jj_scanpos = xsp;
    if (jj_scan_token(352)) return true;
    }
    return false;
  }

  private boolean jj_3_257()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonExpression_4311_13_268()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_4313_13_269()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_4315_13_270()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_4317_13_271()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ShowTables_1233_6_583()
 {
    if (jj_scan_token(K_LIKE)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1233_5_338()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1233_6_583()) {
    jj_scanpos = xsp;
    if (jj_3R_ShowTables_1233_53_584()) return true;
    }
    return false;
  }

  private boolean jj_3_255()
 {
    if (jj_3R_ParenthesedExpression_4255_5_267()) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1229_7_582()
 {
    if (jj_scan_token(K_IN)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1228_7_581()
 {
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4296_9_486()
 {
    if (jj_scan_token(423)) return true;
    if (jj_3R_ColDataType_5490_5_272()) return true;
    return false;
  }

  private boolean jj_3_253()
 {
    if (jj_3R_Function_4941_5_223()) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1227_5_337()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1228_7_581()) {
    jj_scanpos = xsp;
    if (jj_3R_ShowTables_1229_7_582()) return true;
    }
    return false;
  }

  private boolean jj_3_252()
 {
    if (jj_3R_FullTextSearch_4911_5_257()) return true;
    return false;
  }

  private boolean jj_3_256()
 {
    if (jj_3R_ParenthesedSelect_1944_5_115()) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1224_5_336()
 {
    if (jj_scan_token(K_FULL)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1223_5_335()
 {
    if (jj_scan_token(K_EXTENDED)) return true;
    return false;
  }

  private boolean jj_3_251()
 {
    if (jj_3R_JsonAggregateFunction_4485_5_256()) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4290_9_485()
 {
    if (jj_3R_ParenthesedExpression_4255_5_267()) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1223_3_114()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1223_5_335()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1224_5_336()) jj_scanpos = xsp;
    if (jj_scan_token(K_TABLES)) return true;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1227_5_337()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1233_5_338()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_250()
 {
    if (jj_3R_JsonFunction_4375_5_255()) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4288_9_484()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_254()
 {
    if (jj_3R_Column_1723_5_227()) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4284_9_483()
 {
    if (jj_3R_Function_4941_5_223()) return true;
    return false;
  }

  private boolean jj_3R_ArrayConstructor_4240_51_265()
 {
    if (jj_3R_RangeExpression_4218_5_503()) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4282_9_482()
 {
    if (jj_3R_FullTextSearch_4911_5_257()) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4280_9_481()
 {
    if (jj_3R_JsonAggregateFunction_4485_5_256()) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4278_9_480()
 {
    if (jj_3R_JsonFunction_4375_5_255()) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4276_9_479()
 {
    if (jj_3R_UserVariable_4184_5_232()) return true;
    return false;
  }

  private boolean jj_3R_ShowIndex_1207_5_113()
 {
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3_249()
 {
    if (jj_3R_JdbcNamedParameter_4157_5_250()) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4272_9_478()
 {
    if (jj_3R_SimpleJdbcParameter_2973_5_249()) return true;
    return false;
  }

  private boolean jj_3R_ArrayConstructor_4232_47_264()
 {
    if (jj_3R_RangeExpression_4218_5_503()) return true;
    return false;
  }

  private boolean jj_3_248()
 {
    if (jj_3R_CaseWhenExpression_4811_5_248()) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_4269_5_254()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_248()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_4272_9_478()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_249()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_4276_9_479()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing) && !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_JsonExpression_4278_9_480()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing) && !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_JsonExpression_4280_9_481()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing) && !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_JsonExpression_4282_9_482()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing) && !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_JsonExpression_4284_9_483()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_254()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_4288_9_484()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_JsonExpression_4290_9_485()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing) && !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_256()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JsonExpression_4296_9_486()) { jj_scanpos = xsp; break; }
    }
    if (jj_3_257()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_257()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_258()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ShowColumns_1197_5_112()
 {
    if (jj_scan_token(K_COLUMNS)) return true;
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3R_ParenthesedExpression_4255_5_267()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_PrimaryExpression_4005_5_231()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_ArrayConstructor_4242_17_784()
 {
    if (jj_3R_ArrayConstructor_4229_5_127()) return true;
    return false;
  }

  private boolean jj_3_246()
 {
    if (jj_3R_Expression_3221_5_111()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayConstructor_4240_51_265()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_3R_ShowTables_1223_3_114()) return true;
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_3R_ShowIndex_1207_5_113()) return true;
    return false;
  }

  private boolean jj_3_20()
 {
    if (jj_3R_ShowColumns_1197_5_112()) return true;
    return false;
  }

  private boolean jj_3R_ArrayConstructor_4238_13_770()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_246()) {
    jj_scanpos = xsp;
    if (jj_3R_ArrayConstructor_4242_17_784()) return true;
    }
    return false;
  }

  private boolean jj_3R_ArrayConstructor_4234_13_266()
 {
    if (jj_3R_ArrayConstructor_4229_5_127()) return true;
    return false;
  }

  private boolean jj_3R_Show_1170_5_661()
 {
    if (jj_scan_token(K_SHOW)) return true;
    return false;
  }

  private boolean jj_3_245()
 {
    if (jj_3R_Expression_3221_5_111()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayConstructor_4232_47_264()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_19()
 {
    if (jj_scan_token(K_SCHEMA)) return true;
    return false;
  }

  private boolean jj_3_247()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_245()) {
    jj_scanpos = xsp;
    if (jj_3R_ArrayConstructor_4234_13_266()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ArrayConstructor_4238_13_770()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Use_1158_5_662()
 {
    if (jj_scan_token(K_USE)) return true;
    return false;
  }

  private boolean jj_3R_ArrayConstructor_4229_5_127()
 {
    if (jj_scan_token(417)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_247()) jj_scanpos = xsp;
    if (jj_scan_token(418)) return true;
    return false;
  }

  private boolean jj_3R_RangeExpression_4218_5_503()
 {
    if (jj_scan_token(384)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3R_DateTimeLiteralExpression_4208_5_261()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_NumericBind_4197_5_251()
 {
    if (jj_scan_token(384)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_UserVariable_4184_12_469()
 {
    if (jj_scan_token(396)) return true;
    return false;
  }

  private boolean jj_3R_UserVariable_4184_5_232()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(424)) {
    jj_scanpos = xsp;
    if (jj_3R_UserVariable_4184_12_469()) return true;
    }
    if (jj_3R_IdentifierChain_6963_5_470()) return true;
    return false;
  }

  private boolean jj_3R_OracleNamedFunctionParameter_4170_5_228()
 {
    if (jj_3R_RelObjectNameExt2_1811_5_126()) return true;
    if (jj_scan_token(K_ORACLE_NAMED_PARAMETER_ASSIGNMENT)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3R_JdbcNamedParameter_4157_12_474()
 {
    if (jj_scan_token(411)) return true;
    return false;
  }

  private boolean jj_3R_JdbcNamedParameter_4157_5_250()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(384)) {
    jj_scanpos = xsp;
    if (jj_3R_JdbcNamedParameter_4157_12_474()) return true;
    }
    if (jj_3R_IdentifierChain_6963_5_470()) return true;
    return false;
  }

  private boolean jj_3R_NextValExpression_4145_6_262()
 {
    if (jj_scan_token(K_NEXTVAL)) return true;
    if (jj_3R_RelObjectNameList_1709_5_382()) return true;
    return false;
  }

  private boolean jj_3R_ConnectByRootOperator_4134_5_619()
 {
    if (jj_scan_token(K_CONNECT_BY_ROOT)) return true;
    if (jj_3R_Column_1723_5_227()) return true;
    return false;
  }

  private boolean jj_3R_Explain_1052_5_668()
 {
    if (jj_scan_token(K_EXPLAIN)) return true;
    return false;
  }

  private boolean jj_3R_Describe_1042_5_667()
 {
    if (jj_scan_token(K_DESCRIBE)) return true;
    return false;
  }

  private boolean jj_3_244()
 {
    if (jj_scan_token(K_AT)) return true;
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(K_ZONE)) return true;
    if (jj_3R_PrimaryExpression_4005_5_231()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4099_7_641()
 {
    if (jj_scan_token(423)) return true;
    if (jj_3R_ColDataType_5490_5_272()) return true;
    return false;
  }

  private boolean jj_3_219()
 {
    if (jj_3R_AnalyticExpression_4682_5_247()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4097_7_640()
 {
    if (jj_3R_ArrayExpression_3968_5_703()) return true;
    return false;
  }

  private boolean jj_3_243()
 {
    if (jj_3R_IntervalExpressionWithoutInterval_4596_5_263()) return true;
    return false;
  }

  private boolean jj_3_242()
 {
    if (jj_scan_token(K_COLLATE)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4085_14_702()
 {
    if (jj_scan_token(383)) return true;
    if (jj_3R_RelObjectNameExt_1792_5_332()) return true;
    return false;
  }

  private boolean jj_3_241()
 {
    if (jj_3R_ParenthesedSelect_1944_5_115()) return true;
    return false;
  }

  private boolean jj_3R_PurgeStatement_1016_5_671()
 {
    if (jj_scan_token(K_PURGE)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4076_9_468()
 {
    if (jj_3R_ParenthesedExpressionList_3643_5_193()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_4085_14_702()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4073_11_467()
 {
    if (jj_3R_ParenthesedSelect_1944_5_115()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4071_11_466()
 {
    if (jj_scan_token(422)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(420)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4069_11_465()
 {
    if (jj_scan_token(421)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(420)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4067_11_464()
 {
    if (jj_scan_token(419)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(420)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4065_11_463()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_240()
 {
    if (jj_3R_Column_1723_5_227()) return true;
    return false;
  }

  private boolean jj_3_239()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4059_11_462()
 {
    if (jj_3R_ConnectByRootOperator_4134_5_619()) return true;
    return false;
  }

  private boolean jj_3_238()
 {
    if (jj_3R_NextValExpression_4145_6_262()) return true;
    return false;
  }

  private boolean jj_3_237()
 {
    if (jj_scan_token(K_ARRAY_LITERAL)) return true;
    if (jj_3R_ArrayConstructor_4229_5_127()) return true;
    return false;
  }

  private boolean jj_3_236()
 {
    if (jj_3R_DateTimeLiteralExpression_4208_5_261()) return true;
    return false;
  }

  private boolean jj_3_235()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(289)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) return true;
    }
    return false;
  }

  private boolean jj_3R_Set_941_49_333()
 {
    if (jj_scan_token(381)) return true;
    return false;
  }

  private boolean jj_3_234()
 {
    if (jj_3R_CharacterPrimary_6976_5_260()) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_EXISTS)) return true;
    return false;
  }

  private boolean jj_3_231()
 {
    if (jj_3R_Function_4941_5_223()) return true;
    return false;
  }

  private boolean jj_3_233()
 {
    if (jj_3R_CastExpression_4768_5_259()) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_scan_token(K_TABLE)) return true;
    return false;
  }

  private boolean jj_3_230()
 {
    if (jj_3R_FullTextSearch_4911_5_257()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4044_11_461()
 {
    if (jj_scan_token(S_HEX)) return true;
    return false;
  }

  private boolean jj_3R_RenameTableStatement_977_5_653()
 {
    if (jj_scan_token(K_RENAME)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4042_11_460()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(K_ZONE)) return true;
    return false;
  }

  private boolean jj_3_229()
 {
    if (jj_3R_JsonAggregateFunction_4485_5_256()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4040_11_459()
 {
    if (jj_scan_token(S_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3_228()
 {
    if (jj_3R_JsonFunction_4375_5_255()) return true;
    return false;
  }

  private boolean jj_3_232()
 {
    if (jj_3R_IntervalExpression_4574_1_258()) return true;
    return false;
  }

  private boolean jj_3_227()
 {
    if (jj_3R_JsonExpression_4269_5_254()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4036_11_458()
 {
    if (jj_3R_Function_4941_5_223()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_219()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4034_11_457()
 {
    if (jj_3R_FullTextSearch_4911_5_257()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4030_11_456()
 {
    if (jj_3R_JsonAggregateFunction_4485_5_256()) return true;
    return false;
  }

  private boolean jj_3R_Reset_963_5_660()
 {
    if (jj_scan_token(K_RESET)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4028_11_455()
 {
    if (jj_3R_JsonFunction_4375_5_255()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4026_11_454()
 {
    if (jj_3R_JsonExpression_4269_5_254()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4005_31_617()
 {
    if (jj_scan_token(392)) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4024_11_453()
 {
    if (jj_3R_XMLSerializeExpr_5044_5_618()) return true;
    return false;
  }

  private boolean jj_3R_Set_941_21_110()
 {
    if (jj_3R_RelObjectNameExt_1792_5_332()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Set_941_49_333()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_226()
 {
    if (jj_3R_MySQLGroupConcat_5068_5_253()) return true;
    return false;
  }

  private boolean jj_3_225()
 {
    if (jj_3R_ExtractExpression_4747_5_252()) return true;
    return false;
  }

  private boolean jj_3_224()
 {
    if (jj_3R_NumericBind_4197_5_251()) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(K_ZONE)) return true;
    return false;
  }

  private boolean jj_3_223()
 {
    if (jj_3R_UserVariable_4184_5_232()) return true;
    return false;
  }

  private boolean jj_3_222()
 {
    if (jj_3R_JdbcNamedParameter_4157_5_250()) return true;
    return false;
  }

  private boolean jj_3_221()
 {
    if (jj_3R_SimpleJdbcParameter_2973_5_249()) return true;
    return false;
  }

  private boolean jj_3_220()
 {
    if (jj_3R_CaseWhenExpression_4811_5_248()) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3R_Set_941_21_110()) return true;
    }
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4008_9_452()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4005_7_450()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_4005_7_616()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4005_31_617()) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4006_6_451()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(393)) {
    jj_scanpos = xsp;
    if (jj_scan_token(405)) {
    jj_scanpos = xsp;
    if (jj_scan_token(397)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4005_7_616()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_4005_5_231()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_4005_7_450()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_4006_6_451()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_4008_9_452()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_220()) {
    jj_scanpos = xsp;
    if (jj_3_221()) {
    jj_scanpos = xsp;
    if (jj_3_222()) {
    jj_scanpos = xsp;
    if (jj_3_223()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_224()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_225()) {
    jj_scanpos = xsp;
    if (jj_3_226()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4024_11_453()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_PrimaryExpression_4026_11_454()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_PrimaryExpression_4028_11_455()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_PrimaryExpression_4030_11_456()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_PrimaryExpression_4034_11_457()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_PrimaryExpression_4036_11_458()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_232()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4040_11_459()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4042_11_460()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4044_11_461()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_233()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_234()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_235()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_236()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_237()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_238()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4059_11_462()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_239()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_240()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4065_11_463()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4067_11_464()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4069_11_465()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4071_11_466()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_PrimaryExpression_4073_11_467()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_4076_9_468()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_242()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_243()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_4097_7_640()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PrimaryExpression_4099_7_641()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_244()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_218()
 {
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    return false;
  }

  private boolean jj_3R_ArrayExpression_3980_15_771()
 {
    if (jj_scan_token(384)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_218()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(K_ZONE)) return true;
    return false;
  }

  private boolean jj_3_217()
 {
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(264)) return true;
    }
    return false;
  }

  private boolean jj_3R_ArrayExpression_3977_9_745()
 {
    if (jj_scan_token(417)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_217()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayExpression_3980_15_771()) jj_scanpos = xsp;
    if (jj_scan_token(418)) return true;
    return false;
  }

  private boolean jj_3R_Set_909_5_659()
 {
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3_216()
 {
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    return false;
  }

  private boolean jj_3R_ArrayExpression_3971_11_744()
 {
    if (jj_scan_token(384)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_216()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_TrimFunction_7037_13_803()
 {
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3_215()
 {
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    return false;
  }

  private boolean jj_3R_ArrayExpression_3968_5_703()
 {
    if (jj_scan_token(417)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_215()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayExpression_3971_11_744()) jj_scanpos = xsp;
    if (jj_scan_token(418)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ArrayExpression_3977_9_745()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_TrimFunction_7034_9_783()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_3R_TrimFunction_7037_13_803()) return true;
    }
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3R_TrimFunction_7026_13_316()
 {
    if (jj_scan_token(K_BOTH)) return true;
    return false;
  }

  private boolean jj_3_342()
 {
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3R_TrimFunction_7024_13_315()
 {
    if (jj_scan_token(K_TRAILING)) return true;
    return false;
  }

  private boolean jj_3R_TrimFunction_7022_13_314()
 {
    if (jj_scan_token(K_LEADING)) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3924_39_245()
 {
    if (jj_scan_token(415)) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3923_39_244()
 {
    if (jj_scan_token(K_DIV)) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3922_39_243()
 {
    if (jj_scan_token(414)) return true;
    return false;
  }

  private boolean jj_3_341()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_TrimFunction_7022_13_314()) {
    jj_scanpos = xsp;
    if (jj_3R_TrimFunction_7024_13_315()) {
    jj_scanpos = xsp;
    if (jj_3R_TrimFunction_7026_13_316()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_BitwiseXor_3948_9_726()
 {
    if (jj_scan_token(416)) return true;
    if (jj_3R_PrimaryExpression_4005_5_231()) return true;
    return false;
  }

  private boolean jj_3R_TrimFunction_7019_5_639()
 {
    if (jj_scan_token(K_TRIM)) return true;
    if (jj_scan_token(379)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_341()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_342()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_TrimFunction_7034_9_783()) jj_scanpos = xsp;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_BitwiseXor_3946_5_246()
 {
    if (jj_3R_PrimaryExpression_4005_5_231()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_BitwiseXor_3948_9_726()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Statements_813_63_109()
 {
    if (jj_3R_Block_729_5_318()) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3921_23_242()
 {
    if (jj_scan_token(390)) return true;
    return false;
  }

  private boolean jj_3R_Declare_864_5_669()
 {
    if (jj_scan_token(K_DECLARE)) return true;
    return false;
  }

  private boolean jj_3R_TranscodingFunction_7004_5_638()
 {
    if (jj_scan_token(K_CONVERT)) return true;
    if (jj_scan_token(379)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    if (jj_scan_token(K_USING)) return true;
    if (jj_3R_IdentifierChain_6963_5_470()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_AdditiveExpression_3895_39_240()
 {
    if (jj_scan_token(405)) return true;
    return false;
  }

  private boolean jj_3_214()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_MultiplicativeExpression_3921_23_242()) {
    jj_scanpos = xsp;
    if (jj_3R_MultiplicativeExpression_3922_39_243()) {
    jj_scanpos = xsp;
    if (jj_3R_MultiplicativeExpression_3923_39_244()) {
    jj_scanpos = xsp;
    if (jj_3R_MultiplicativeExpression_3924_39_245()) return true;
    }
    }
    }
    if (jj_3R_BitwiseXor_3946_5_246()) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3916_5_241()
 {
    if (jj_3R_BitwiseXor_3946_5_246()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_214()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Statements_813_36_108()
 {
    if (jj_3R_SingleStatement_649_5_317()) return true;
    return false;
  }

  private boolean jj_3R_Statements_785_61_106()
 {
    if (jj_3R_Block_729_5_318()) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_scan_token(ST_SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_CharacterPrimary_6979_9_501()
 {
    if (jj_3R_TrimFunction_7019_5_639()) return true;
    return false;
  }

  private boolean jj_3R_CharacterPrimary_6977_9_500()
 {
    if (jj_3R_TranscodingFunction_7004_5_638()) return true;
    return false;
  }

  private boolean jj_3R_Statements_812_27_107()
 {
    if (jj_scan_token(ST_SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_CharacterPrimary_6976_5_260()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CharacterPrimary_6977_9_500()) {
    jj_scanpos = xsp;
    if (jj_3R_CharacterPrimary_6979_9_501()) return true;
    }
    return false;
  }

  private boolean jj_3_9()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Statements_812_27_107()) jj_scanpos = xsp;
    if (jj_scan_token(K_ELSE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_Statements_813_36_108()) {
    jj_scanpos = xsp;
    if (jj_3R_Statements_813_63_109()) return true;
    }
    return false;
  }

  private boolean jj_3R_AdditiveExpression_3894_10_239()
 {
    if (jj_scan_token(393)) return true;
    return false;
  }

  private boolean jj_3_213()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AdditiveExpression_3894_10_239()) {
    jj_scanpos = xsp;
    if (jj_3R_AdditiveExpression_3895_39_240()) return true;
    }
    if (jj_3R_MultiplicativeExpression_3916_5_241()) return true;
    return false;
  }

  private boolean jj_3R_IdentifierChain_6964_7_620()
 {
    if (jj_scan_token(383)) return true;
    if (jj_3R_RelObjectNameExt2_1811_5_126()) return true;
    return false;
  }

  private boolean jj_3R_AdditiveExpression_3892_5_238()
 {
    if (jj_3R_MultiplicativeExpression_3916_5_241()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_213()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_IdentifierChain_6963_5_470()
 {
    if (jj_3R_RelObjectNameExt2_1811_5_126()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_IdentifierChain_6964_7_620()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3869_25_237()
 {
    if (jj_scan_token(413)) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3867_25_236()
 {
    if (jj_scan_token(412)) return true;
    return false;
  }

  private boolean jj_3R_Statements_785_33_105()
 {
    if (jj_3R_SingleStatement_649_5_317()) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_scan_token(ST_SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_Statements_784_24_104()
 {
    if (jj_scan_token(ST_SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3865_13_235()
 {
    if (jj_scan_token(411)) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3863_13_234()
 {
    if (jj_scan_token(410)) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Statements_784_24_104()) jj_scanpos = xsp;
    if (jj_scan_token(K_ELSE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_Statements_785_33_105()) {
    jj_scanpos = xsp;
    if (jj_3R_Statements_785_61_106()) return true;
    }
    return false;
  }

  private boolean jj_3_212()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_BitwiseAndOr_3863_13_234()) {
    jj_scanpos = xsp;
    if (jj_3R_BitwiseAndOr_3865_13_235()) {
    jj_scanpos = xsp;
    if (jj_3R_BitwiseAndOr_3867_25_236()) {
    jj_scanpos = xsp;
    if (jj_3R_BitwiseAndOr_3869_25_237()) return true;
    }
    }
    }
    if (jj_3R_AdditiveExpression_3892_5_238()) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3860_5_233()
 {
    if (jj_3R_AdditiveExpression_3892_5_238()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_212()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(ST_SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_211()
 {
    if (jj_scan_token(OP_CONCAT)) return true;
    if (jj_3R_BitwiseAndOr_3860_5_233()) return true;
    return false;
  }

  private boolean jj_3R_ConcatExpression_3837_5_177()
 {
    if (jj_3R_BitwiseAndOr_3860_5_233()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_211()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_210()
 {
    if (jj_3R_UserVariable_4184_5_232()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(381)) {
    jj_scanpos = xsp;
    if (jj_scan_token(409)) return true;
    }
    return false;
  }

  private boolean jj_3R_SimpleExpression_3812_11_402()
 {
    if (jj_3R_UserVariable_4184_5_232()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(381)) {
    jj_scanpos = xsp;
    if (jj_scan_token(409)) return true;
    }
    return false;
  }

  private boolean jj_3R_SimpleExpression_3811_5_194()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SimpleExpression_3812_11_402()) jj_scanpos = xsp;
    if (jj_3R_ConcatExpression_3837_5_177()) return true;
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_3795_11_449()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_Block_729_5_318()
 {
    if (jj_scan_token(K_BEGIN)) return true;
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_3794_11_448()
 {
    if (jj_scan_token(K_SOME)) return true;
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_3793_9_447()
 {
    if (jj_scan_token(K_ANY)) return true;
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_3792_5_229()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AnyComparisonExpression_3793_9_447()) {
    jj_scanpos = xsp;
    if (jj_3R_AnyComparisonExpression_3794_11_448()) {
    jj_scanpos = xsp;
    if (jj_3R_AnyComparisonExpression_3795_11_449()) return true;
    }
    }
    if (jj_3R_Select_1915_5_339()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_709_13_561()
 {
    if (jj_3R_PurgeStatement_1016_5_671()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_707_13_560()
 {
    if (jj_3R_Grant_6589_9_670()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_705_13_559()
 {
    if (jj_3R_Declare_864_5_669()) return true;
    return false;
  }

  private boolean jj_3R_NamedExpressionListExprFirst_3755_33_644()
 {
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_703_13_558()
 {
    if (jj_3R_Explain_1052_5_668()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_701_13_557()
 {
    if (jj_3R_Describe_1042_5_667()) return true;
    return false;
  }

  private boolean jj_3_209()
 {
    if (jj_3R_PrimaryExpression_4005_5_231()) return true;
    return false;
  }

  private boolean jj_3_208()
 {
    if (jj_3R_RowConstructor_4855_5_230()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_699_13_556()
 {
    if (jj_3R_Comment_6559_5_666()) return true;
    return false;
  }

  private boolean jj_3_207()
 {
    if (jj_3R_ParenthesedExpressionList_3643_5_193()) return true;
    return false;
  }

  private boolean jj_3_206()
 {
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_697_13_555()
 {
    if (jj_3R_Commit_6544_3_665()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_695_13_554()
 {
    if (jj_3R_RollbackStatement_6523_5_664()) return true;
    return false;
  }

  private boolean jj_3_205()
 {
    if (jj_3R_AnyComparisonExpression_3792_5_229()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_693_13_553()
 {
    if (jj_3R_SavepointStatement_6507_5_663()) return true;
    return false;
  }

  private boolean jj_3R_NamedExpressionListExprFirst_3752_25_516()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) return true;
    }
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    xsp = jj_scanpos;
    if (jj_3R_NamedExpressionListExprFirst_3755_33_644()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ComparisonItem_3773_3_210()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_205()) {
    jj_scanpos = xsp;
    if (jj_3_206()) {
    jj_scanpos = xsp;
    if (jj_3_207()) {
    jj_scanpos = xsp;
    if (jj_3_208()) {
    jj_scanpos = xsp;
    if (jj_3_209()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_SingleStatement_691_13_552()
 {
    if (jj_3R_Use_1158_5_662()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_689_13_551()
 {
    if (jj_3R_Show_1170_5_661()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_687_13_550()
 {
    if (jj_3R_Reset_963_5_660()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_685_13_549()
 {
    if (jj_3R_Set_909_5_659()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_683_13_548()
 {
    if (jj_3R_Execute_4887_5_658()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_681_13_547()
 {
    if (jj_3R_Truncate_5849_5_657()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_679_13_546()
 {
    if (jj_3R_Analyze_5532_5_656()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_677_13_545()
 {
    if (jj_3R_Drop_5794_5_655()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_675_13_544()
 {
    if (jj_3R_Create_6784_5_654()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_673_13_543()
 {
    if (jj_3R_RenameTableStatement_977_5_653()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_662_21_101()
 {
    if (jj_3R_Merge_1650_5_324()) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_Alter_6268_5_103()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_660_21_100()
 {
    if (jj_3R_Delete_1609_5_323()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_Upsert_1553_5_102()) return true;
    return false;
  }

  private boolean jj_3R_NamedExpressionListExprFirst_3742_9_282()
 {
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(218)) return true;
    }
    }
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    xsp = jj_scanpos;
    if (jj_3R_NamedExpressionListExprFirst_3752_25_516()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SingleStatement_658_21_99()
 {
    if (jj_3R_Update_1304_4_322()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_666_13_542()
 {
    if (jj_3R_Select_1915_5_339()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_656_21_98()
 {
    if (jj_3R_Insert_1411_5_321()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_654_21_97()
 {
    if (jj_3R_SelectWithWithItems_1899_5_320()) return true;
    return false;
  }

  private boolean jj_3R_Statement_616_55_95()
 {
    if (jj_3R_Block_729_5_318()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_WithList_2285_5_96()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_2()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SingleStatement_654_21_97()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_656_21_98()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_658_21_99()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_660_21_100()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_662_21_101()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_340()
 {
    if (jj_3R_CreateView_5550_5_313()) return true;
    return false;
  }

  private boolean jj_3_339()
 {
    if (jj_3R_CreateTable_5282_5_312()) return true;
    return false;
  }

  private boolean jj_3_204()
 {
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_649_5_317()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_666_13_542()) {
    jj_scanpos = xsp;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_673_13_543()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_675_13_544()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_677_13_545()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_679_13_546()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_681_13_547()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_683_13_548()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_685_13_549()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_687_13_550()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_689_13_551()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_691_13_552()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_693_13_553()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_695_13_554()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_697_13_555()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_699_13_556()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_701_13_557()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_703_13_558()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_705_13_559()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_707_13_560()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_709_13_561()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_203()
 {
    if (jj_3R_OracleNamedFunctionParameter_4170_5_228()) return true;
    return false;
  }

  private boolean jj_3R_Create_6784_5_654()
 {
    if (jj_scan_token(K_CREATE)) return true;
    return false;
  }

  private boolean jj_3_202()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_203()) {
    jj_scanpos = xsp;
    if (jj_3_204()) return true;
    }
    return false;
  }

  private boolean jj_3R_Statement_616_28_94()
 {
    if (jj_3R_SingleStatement_649_5_317()) return true;
    return false;
  }

  private boolean jj_3_201()
 {
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3_200()
 {
    if (jj_3R_OracleNamedFunctionParameter_4170_5_228()) return true;
    return false;
  }

  private boolean jj_3R_ComplexExpressionList_3699_5_224()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_200()) {
    jj_scanpos = xsp;
    if (jj_3_201()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_202()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_AlterSequence_6768_5_679()
 {
    if (jj_scan_token(K_SEQUENCE)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(K_ELSE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Statement_616_28_94()) {
    jj_scanpos = xsp;
    if (jj_3R_Statement_616_55_95()) return true;
    }
    return false;
  }

  private boolean jj_3R_ParenthesedColumnList_3687_5_120()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_ColumnList_3675_5_118()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_199()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Column_1723_5_227()) return true;
    return false;
  }

  private boolean jj_3R_ColumnList_3675_5_118()
 {
    if (jj_3R_Column_1723_5_227()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_199()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_198()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpressionList_3661_5_225()
 {
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_198()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_3567_94_437()
 {
    if (jj_scan_token(K_FALSE)) return true;
    return false;
  }

  private boolean jj_3_196()
 {
    if (jj_3R_SimpleExpressionList_3661_5_225()) return true;
    return false;
  }

  private boolean jj_3R_ParenthesedExpressionList_3645_9_226()
 {
    if (jj_3R_ComplexExpressionList_3699_5_224()) return true;
    return false;
  }

  private boolean jj_3_197()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing) && !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_ParenthesedExpressionList_3645_9_226()) {
    jj_scanpos = xsp;
    if (jj_3_196()) return true;
    }
    return false;
  }

  private boolean jj_3R_ParenthesedExpressionList_3643_5_193()
 {
    if (jj_scan_token(379)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_197()) jj_scanpos = xsp;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_3567_55_436()
 {
    if (jj_scan_token(K_TRUE)) return true;
    return false;
  }

  private boolean jj_3_195()
 {
    if (jj_3R_ParenthesedExpressionList_3643_5_193()) return true;
    return false;
  }

  private boolean jj_3_194()
 {
    if (jj_3R_SimpleExpressionList_3661_5_225()) return true;
    return false;
  }

  private boolean jj_3_193()
 {
    if (jj_3R_ComplexExpressionList_3699_5_224()) return true;
    return false;
  }

  private boolean jj_3R_ExpressionList_3606_5_192()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing) && !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_193()) {
    jj_scanpos = xsp;
    if (jj_3_194()) {
    jj_scanpos = xsp;
    if (jj_3_195()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_MemberOfExpression_3595_5_440()
 {
    if (jj_scan_token(K_MEMBER)) return true;
    if (jj_scan_token(K_OF)) return true;
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3R_ExistsExpression_3582_5_606()
 {
    if (jj_scan_token(K_EXISTS)) return true;
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_3567_19_435()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_3566_9_213()
 {
    if (jj_scan_token(K_IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsBooleanExpression_3567_19_435()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsBooleanExpression_3567_55_436()) {
    jj_scanpos = xsp;
    if (jj_3R_IsBooleanExpression_3567_94_437()) return true;
    }
    return false;
  }

  private boolean jj_3R_IsNullExpression_3553_19_608()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_IsNullExpression_3553_11_434()
 {
    if (jj_scan_token(K_IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsNullExpression_3553_19_608()) jj_scanpos = xsp;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_IsNullExpression_3552_11_433()
 {
    if (jj_scan_token(K_NOTNULL)) return true;
    return false;
  }

  private boolean jj_3R_IsNullExpression_3551_11_607()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_IsNullExpression_3551_9_432()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsNullExpression_3551_11_607()) jj_scanpos = xsp;
    if (jj_scan_token(K_ISNULL)) return true;
    return false;
  }

  private boolean jj_3R_IsNullExpression_3550_5_212()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsNullExpression_3551_9_432()) {
    jj_scanpos = xsp;
    if (jj_3R_IsNullExpression_3552_11_433()) {
    jj_scanpos = xsp;
    if (jj_3R_IsNullExpression_3553_11_434()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_IsDistinctExpression_3535_13_439()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_IsDistinctExpression_3535_5_215()
 {
    if (jj_scan_token(K_IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsDistinctExpression_3535_13_439()) jj_scanpos = xsp;
    if (jj_scan_token(K_DISTINCT)) return true;
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    return false;
  }

  private boolean jj_3_192()
 {
    if (jj_scan_token(K_ESCAPE)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_Grant_6589_9_670()
 {
    if (jj_scan_token(K_GRANT)) return true;
    return false;
  }

  private boolean jj_3R_SimilarToExpression_3517_6_609()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_SimilarToExpression_3517_5_441()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SimilarToExpression_3517_6_609()) jj_scanpos = xsp;
    if (jj_scan_token(K_SIMILAR)) return true;
    if (jj_scan_token(K_TO)) return true;
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    xsp = jj_scanpos;
    if (jj_3_192()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_190()
 {
    if (jj_3R_Expression_3221_5_111()) return true;
    return false;
  }

  private boolean jj_3_189()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_191()
 {
    if (jj_scan_token(K_ESCAPE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_189()) {
    jj_scanpos = xsp;
    if (jj_3_190()) return true;
    }
    return false;
  }

  private boolean jj_3_188()
 {
    if (jj_scan_token(K_BINARY)) return true;
    return false;
  }

  private boolean jj_3R_LikeExpression_3487_6_438()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_Comment_6559_5_666()
 {
    if (jj_scan_token(K_COMMENT)) return true;
    return false;
  }

  private boolean jj_3R_LikeExpression_3487_5_214()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_LikeExpression_3487_6_438()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(163)) {
    jj_scanpos = xsp;
    if (jj_scan_token(133)) {
    jj_scanpos = xsp;
    if (jj_scan_token(238)) {
    jj_scanpos = xsp;
    if (jj_scan_token(237)) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_188()) jj_scanpos = xsp;
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    xsp = jj_scanpos;
    if (jj_3_191()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Between_3468_10_431()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_Between_3468_9_211()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Between_3468_10_431()) jj_scanpos = xsp;
    if (jj_scan_token(K_BETWEEN)) return true;
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    if (jj_scan_token(K_AND)) return true;
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    return false;
  }

  private boolean jj_3R_Commit_6544_3_665()
 {
    if (jj_scan_token(K_COMMIT)) return true;
    return false;
  }

  private boolean jj_3_185()
 {
    if (jj_3R_ParenthesedSelect_1944_5_115()) return true;
    return false;
  }

  private boolean jj_3_187()
 {
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    return false;
  }

  private boolean jj_3_186()
 {
    if (jj_3R_ParenthesedExpressionList_3643_5_193()) return true;
    return false;
  }

  private boolean jj_3R_InExpression_3448_11_444()
 {
    if (jj_3R_ParenthesedSelect_1944_5_115()) return true;
    return false;
  }

  private boolean jj_3_184()
 {
    if (jj_3R_Function_4941_5_223()) return true;
    return false;
  }

  private boolean jj_3R_RollbackStatement_6523_5_664()
 {
    if (jj_scan_token(K_ROLLBACK)) return true;
    return false;
  }

  private boolean jj_3_183()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_InExpression_3444_6_443()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3_178()
 {
    if (jj_3R_IsDistinctExpression_3535_5_215()) return true;
    return false;
  }

  private boolean jj_3R_InExpression_3442_7_442()
 {
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(393)) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_InExpression_3441_5_221()
 {
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InExpression_3442_7_442()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_InExpression_3444_6_443()) jj_scanpos = xsp;
    if (jj_scan_token(K_IN)) return true;
    xsp = jj_scanpos;
    if (jj_3_183()) {
    jj_scanpos = xsp;
    if (jj_3_184()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_InExpression_3448_11_444()) {
    jj_scanpos = xsp;
    if (jj_3_186()) {
    jj_scanpos = xsp;
    if (jj_3_187()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_176()
 {
    if (jj_3R_IsBooleanExpression_3566_9_213()) return true;
    return false;
  }

  private boolean jj_3_175()
 {
    if (jj_3R_IsNullExpression_3550_5_212()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3424_17_220()
 {
    if (jj_3R_SimilarToExpression_3517_5_441()) return true;
    return false;
  }

  private boolean jj_3R_SavepointStatement_6507_5_663()
 {
    if (jj_scan_token(K_SAVEPOINT)) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3422_17_219()
 {
    if (jj_3R_IsDistinctExpression_3535_5_215()) return true;
    return false;
  }

  private boolean jj_3_177()
 {
    if (jj_3R_LikeExpression_3487_5_214()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3418_17_218()
 {
    if (jj_3R_IsBooleanExpression_3566_9_213()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3416_17_217()
 {
    if (jj_3R_IsNullExpression_3550_5_212()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3414_17_216()
 {
    if (jj_3R_MemberOfExpression_3595_5_440()) return true;
    return false;
  }

  private boolean jj_3R_Wait_6495_5_782()
 {
    if (jj_scan_token(K_WAIT)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_174()
 {
    if (jj_3R_Between_3468_9_211()) return true;
    return false;
  }

  private boolean jj_3_181()
 {
    if (jj_3R_OverlapsCondition_3326_5_222()) return true;
    return false;
  }

  private boolean jj_3_179()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_174()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_3414_17_216()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_3416_17_217()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_3418_17_218()) {
    jj_scanpos = xsp;
    if (jj_3_177()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_3422_17_219()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_3424_17_220()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_180()
 {
    if (jj_3R_InExpression_3441_5_221()) return true;
    return false;
  }

  private boolean jj_3_182()
 {
    if (jj_3R_SimpleExpression_3811_5_194()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_179()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SQLCondition_3407_7_430()
 {
    if (jj_3R_OverlapsCondition_3326_5_222()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3406_7_429()
 {
    if (jj_3R_InExpression_3441_5_221()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3405_5_428()
 {
    if (jj_3R_ExistsExpression_3582_5_606()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3404_5_209()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SQLCondition_3405_5_428()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_SQLCondition_3406_7_429()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_SQLCondition_3407_7_430()) {
    jj_scanpos = xsp;
    if (jj_3_182()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_172()
 {
    if (jj_3R_ComparisonItem_3773_3_210()) return true;
    return false;
  }

  private boolean jj_3_173()
 {
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(393)) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3372_11_427()
 {
    if (jj_scan_token(408)) return true;
    return false;
  }

  private boolean jj_3_171()
 {
    if (jj_scan_token(K_PRIOR)) return true;
    if (jj_3R_ComparisonItem_3773_3_210()) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3371_11_426()
 {
    if (jj_scan_token(407)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3370_11_425()
 {
    if (jj_scan_token(406)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3369_11_424()
 {
    if (jj_scan_token(405)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3368_11_423()
 {
    if (jj_scan_token(OP_CONCAT)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3367_11_422()
 {
    if (jj_scan_token(404)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3366_11_421()
 {
    if (jj_scan_token(403)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3365_11_420()
 {
    if (jj_scan_token(391)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3364_11_419()
 {
    if (jj_scan_token(402)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3363_11_418()
 {
    if (jj_scan_token(401)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3361_7_417()
 {
    if (jj_scan_token(400)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3360_7_416()
 {
    if (jj_scan_token(399)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3359_7_415()
 {
    if (jj_scan_token(398)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3358_7_414()
 {
    if (jj_scan_token(397)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3357_7_413()
 {
    if (jj_scan_token(396)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3356_7_412()
 {
    if (jj_scan_token(OP_NOTEQUALSBANG)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3355_7_411()
 {
    if (jj_scan_token(OP_NOTEQUALSSTANDARD)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3354_7_410()
 {
    if (jj_scan_token(OP_MINORTHANEQUALS)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3353_7_409()
 {
    if (jj_scan_token(OP_GREATERTHANEQUALS)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3352_7_408()
 {
    if (jj_scan_token(381)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3351_7_407()
 {
    if (jj_scan_token(395)) return true;
    return false;
  }

  private boolean jj_3_170()
 {
    if (jj_scan_token(394)) return true;
    return false;
  }

  private boolean jj_3R_Condition_3310_45_207()
 {
    if (jj_scan_token(392)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3347_7_406()
 {
    if (jj_scan_token(379)) return true;
    if (jj_scan_token(393)) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3_169()
 {
    if (jj_scan_token(K_PRIOR)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3344_5_208()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_169()) jj_scanpos = xsp;
    if (jj_3R_ComparisonItem_3773_3_210()) return true;
    xsp = jj_scanpos;
    if (jj_3R_RegularCondition_3347_7_406()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_170()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3351_7_407()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3352_7_408()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3353_7_409()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3354_7_410()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3355_7_411()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3356_7_412()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3357_7_413()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3358_7_414()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3359_7_415()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3360_7_416()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3361_7_417()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3363_11_418()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3364_11_419()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3365_11_420()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3366_11_421()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3367_11_422()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3368_11_423()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3369_11_424()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3370_11_425()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3371_11_426()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3372_11_427()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_171()) {
    jj_scanpos = xsp;
    if (jj_3_172()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_173()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AlterSystemStatement_6405_5_678()
 {
    if (jj_scan_token(K_SYSTEM)) return true;
    return false;
  }

  private boolean jj_3R_OverlapsCondition_3326_5_222()
 {
    if (jj_3R_ParenthesedExpressionList_3643_5_193()) return true;
    if (jj_scan_token(K_OVERLAPS)) return true;
    if (jj_3R_ParenthesedExpressionList_3643_5_193()) return true;
    return false;
  }

  private boolean jj_3R_Condition_3310_21_206()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3_167()
 {
    if (jj_3R_RegularCondition_3344_5_208()) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3288_39_605()
 {
    if (jj_scan_token(392)) return true;
    return false;
  }

  private boolean jj_3_168()
 {
    if (jj_3R_SQLCondition_3404_5_209()) return true;
    return false;
  }

  private boolean jj_3R_Condition_3312_9_388()
 {
    if (jj_3R_RegularCondition_3344_5_208()) return true;
    return false;
  }

  private boolean jj_3_166()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Condition_3310_21_206()) {
    jj_scanpos = xsp;
    if (jj_3R_Condition_3310_45_207()) return true;
    }
    return false;
  }

  private boolean jj_3R_Condition_3310_5_176()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_166()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Condition_3312_9_388()) {
    jj_scanpos = xsp;
    if (jj_3_168()) return true;
    }
    return false;
  }

  private boolean jj_3R_AndExpression_3276_35_685()
 {
    if (jj_scan_token(392)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3283_21_203()
 {
    if (jj_scan_token(K_AND_OPERATOR)) return true;
    return false;
  }

  private boolean jj_3_165()
 {
    if (jj_3R_Condition_3310_5_176()) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3288_15_405()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_3288_15_604()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_3288_39_605()) return true;
    }
    return false;
  }

  private boolean jj_3R_AndExpression_3288_15_604()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3288_13_205()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_3288_15_405()) jj_scanpos = xsp;
    if (jj_scan_token(379)) return true;
    if (jj_3R_XorExpression_3231_5_334()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3285_9_204()
 {
    if (jj_3R_Condition_3310_5_176()) return true;
    return false;
  }

  private boolean jj_3_163()
 {
    if (jj_3R_Condition_3310_5_176()) return true;
    return false;
  }

  private boolean jj_3_164()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_3283_21_203()) return true;
    }
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_AndExpression_3285_9_204()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_3288_13_205()) return true;
    }
    return false;
  }

  private boolean jj_3R_AndExpression_3276_11_603()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_3276_11_684()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_3276_35_685()) return true;
    }
    return false;
  }

  private boolean jj_3R_AndExpression_3276_11_684()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3276_9_404()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_3276_11_603()) jj_scanpos = xsp;
    if (jj_scan_token(379)) return true;
    if (jj_3R_XorExpression_3231_5_334()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3273_9_403()
 {
    if (jj_3R_Condition_3310_5_176()) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3272_5_202()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = !interrupted;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_AndExpression_3273_9_403()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_3276_9_404()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_164()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_AlterSession_6339_5_676()
 {
    if (jj_scan_token(K_SESSION)) return true;
    return false;
  }

  private boolean jj_3_162()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_3R_AndExpression_3272_5_202()) return true;
    return false;
  }

  private boolean jj_3R_OrExpression_3250_5_201()
 {
    if (jj_3R_AndExpression_3272_5_202()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_162()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_338()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_EXISTS)) return true;
    return false;
  }

  private boolean jj_3R_AlterTable_6314_5_675()
 {
    if (jj_scan_token(K_TABLE)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpression_6226_85_311()
 {
    if (jj_scan_token(K_COLUMN)) return true;
    return false;
  }

  private boolean jj_3R_Alter_6294_17_579()
 {
    if (true) { jj_la = 0; jj_scanpos = jj_lastpos; return false;}
    return false;
  }

  private boolean jj_3_161()
 {
    if (jj_scan_token(K_XOR)) return true;
    if (jj_3R_OrExpression_3250_5_201()) return true;
    return false;
  }

  private boolean jj_3R_Alter_6292_17_578()
 {
    if (jj_3R_AlterView_5598_5_677()) return true;
    return false;
  }

  private boolean jj_3R_XorExpression_3231_5_334()
 {
    if (jj_3R_OrExpression_3250_5_201()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_161()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_158()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_Alter_6282_17_577()
 {
    if (true) { jj_la = 0; jj_scanpos = jj_lastpos; return false;}
    return false;
  }

  private boolean jj_3R_Alter_6289_9_331()
 {
    if (jj_scan_token(K_REPLACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alter_6292_17_578()) {
    jj_scanpos = xsp;
    if (jj_3R_Alter_6294_17_579()) return true;
    }
    return false;
  }

  private boolean jj_3R_Expression_3221_5_111()
 {
    if (jj_3R_XorExpression_3231_5_334()) return true;
    return false;
  }

  private boolean jj_3R_Alter_6280_17_576()
 {
    if (jj_3R_AlterSequence_6768_5_679()) return true;
    return false;
  }

  private boolean jj_3R_Alter_6278_17_575()
 {
    if (jj_3R_AlterSystemStatement_6405_5_678()) return true;
    return false;
  }

  private boolean jj_3R_Alter_6276_17_574()
 {
    if (jj_3R_AlterView_5598_5_677()) return true;
    return false;
  }

  private boolean jj_3R_Alter_6274_17_573()
 {
    if (jj_3R_AlterSession_6339_5_676()) return true;
    return false;
  }

  private boolean jj_3R_Alter_6272_17_572()
 {
    if (jj_3R_AlterTable_6314_5_675()) return true;
    return false;
  }

  private boolean jj_3R_First_3208_9_365()
 {
    if (jj_3R_SimpleJdbcParameter_2973_5_249()) return true;
    return false;
  }

  private boolean jj_3R_First_3206_9_364()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_First_3204_9_363()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_First_3201_9_362()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3R_First_3199_9_361()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_Alter_6269_9_330()
 {
    if (jj_scan_token(K_ALTER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alter_6272_17_572()) {
    jj_scanpos = xsp;
    if (jj_3R_Alter_6274_17_573()) {
    jj_scanpos = xsp;
    if (jj_3R_Alter_6276_17_574()) {
    jj_scanpos = xsp;
    if (jj_3R_Alter_6278_17_575()) {
    jj_scanpos = xsp;
    if (jj_3R_Alter_6280_17_576()) {
    jj_scanpos = xsp;
    if (jj_3R_Alter_6282_17_577()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_First_3198_5_144()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_First_3199_9_361()) {
    jj_scanpos = xsp;
    if (jj_3R_First_3201_9_362()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_First_3204_9_363()) {
    jj_scanpos = xsp;
    if (jj_3R_First_3206_9_364()) {
    jj_scanpos = xsp;
    if (jj_3R_First_3208_9_365()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_Alter_6268_5_103()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alter_6269_9_330()) {
    jj_scanpos = xsp;
    if (jj_3R_Alter_6289_9_331()) return true;
    }
    return false;
  }

  private boolean jj_3R_Skip_3166_19_360()
 {
    if (jj_3R_SimpleJdbcParameter_2973_5_249()) return true;
    return false;
  }

  private boolean jj_3R_Skip_3165_19_359()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_Skip_3164_10_358()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_Skip_3162_5_143()
 {
    if (jj_scan_token(K_SKIP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Skip_3164_10_358()) {
    jj_scanpos = xsp;
    if (jj_3R_Skip_3165_19_359()) {
    jj_scanpos = xsp;
    if (jj_3R_Skip_3166_19_360()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_337()
 {
    if (jj_scan_token(K_RENAME)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpression_6226_85_311()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(358)) {
    jj_scanpos = xsp;
    if (jj_scan_token(378)) return true;
    }
    return false;
  }

  private boolean jj_3_160()
 {
    if (jj_scan_token(K_WITH_TIES)) return true;
    return false;
  }

  private boolean jj_3_159()
 {
    if (jj_scan_token(K_PERCENT)) return true;
    return false;
  }

  private boolean jj_3R_Top_3140_8_369()
 {
    if (jj_scan_token(379)) return true;
    if (jj_3R_AdditiveExpression_3892_5_238()) return true;
    if (jj_scan_token(380)) return true;
    return false;
  }

  private boolean jj_3R_Top_3138_8_368()
 {
    if (jj_scan_token(384)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_158()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Top_3135_10_367()
 {
    if (jj_3R_SimpleJdbcParameter_2973_5_249()) return true;
    return false;
  }

  private boolean jj_3R_Top_3133_10_366()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_Offset_3065_76_200()
 {
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3R_Top_3131_5_150()
 {
    if (jj_scan_token(K_TOP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Top_3133_10_366()) {
    jj_scanpos = xsp;
    if (jj_3R_Top_3135_10_367()) {
    jj_scanpos = xsp;
    if (jj_3R_Top_3138_8_368()) {
    jj_scanpos = xsp;
    if (jj_3R_Top_3140_8_369()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_159()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_160()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_336()
 {
    if (jj_scan_token(K_COLUMN)) return true;
    return false;
  }

  private boolean jj_3R_OptimizeFor_3115_5_590()
 {
    if (jj_scan_token(K_OPTIMIZE)) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_WithIsolation_3098_5_589()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_ISOLATION)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_3082_20_724()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_Offset_3065_30_199()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_3084_10_725()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_3080_5_588()
 {
    if (jj_scan_token(K_FETCH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Fetch_3082_20_724()) {
    jj_scanpos = xsp;
    if (jj_scan_token(181)) return true;
    }
    if (jj_3R_Expression_3221_5_111()) return true;
    xsp = jj_scanpos;
    if (jj_3R_Fetch_3084_10_725()) {
    jj_scanpos = xsp;
    if (jj_scan_token(253)) return true;
    }
    if (jj_scan_token(K_ONLY)) return true;
    return false;
  }

  private boolean jj_3_157()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Offset_3065_30_199()) {
    jj_scanpos = xsp;
    if (jj_3R_Offset_3065_76_200()) return true;
    }
    return false;
  }

  /** Generated Token Manager. */
  public CCJSqlParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[562];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static private int[] jj_la1_7;
  static private int[] jj_la1_8;
  static private int[] jj_la1_9;
  static private int[] jj_la1_10;
  static private int[] jj_la1_11;
  static private int[] jj_la1_12;
  static private int[] jj_la1_13;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	   jj_la1_init_4();
	   jj_la1_init_5();
	   jj_la1_init_6();
	   jj_la1_init_7();
	   jj_la1_init_8();
	   jj_la1_init_9();
	   jj_la1_init_10();
	   jj_la1_init_11();
	   jj_la1_init_12();
	   jj_la1_init_13();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x2001800,0x0,0x2001800,0x0,0x2001800,0x0,0x2001800,0x0,0x0,0x1000,0x0,0x2001800,0x2001800,0x2001800,0x0,0x2001800,0x0,0x2001800,0x2001800,0x2001800,0x0,0x2001800,0x0,0x2001800,0x2001800,0x2001800,0x0,0x0,0x0,0x0,0x300c0000,0x0,0x0,0x0,0x76f79ff8,0x0,0x0,0x76f79ff8,0x76f71ff8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x76f79ff8,0x0,0x76f79ff8,0x0,0x10000,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x76f79ff8,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x76f79ff8,0x0,0x0,0x0,0x0,0x0,0x0,0x76f79ff8,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x76f71bf8,0x76f71bf8,0x76f71bf8,0x76f79ff8,0x76f79ff8,0x0,0x40000000,0x4000000,0x0,0x0,0x0,0x800000,0x4,0x10000000,0x10000000,0x4,0x10000000,0x800000,0x800000,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x76f71bf8,0x30040000,0x0,0x30040000,0x0,0x0,0x0,0x0,0x0,0x76ff1bf8,0x76f79ff8,0x0,0x76ff1bf8,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x0,0x0,0x0,0x0,0x4,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x76f79ff8,0x0,0x0,0x0,0x0,0x0,0x0,0x76f71bf8,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x76f71bf8,0x0,0x0,0x30040000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x76f79ff8,0x400,0x0,0x0,0x0,0x0,0x76f79ff8,0x0,0x0,0x0,0x0,0x0,0x0,0x102c0000,0x0,0x102c0000,0x102c0000,0x0,0x102c0000,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x102c0000,0x0,0x0,0x102c0000,0x0,0x0,0x0,0x102c0000,0x0,0x0,0x102c0000,0x0,0x0,0x0,0x0,0x0,0x0,0x76f71bf8,0x0,0x0,0x80000,0x76f79ff8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x10000000,0x0,0x0,0x40000,0x30000000,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10200000,0x80000,0x0,0x0,0x0,0x0,0x102c0000,0x0,0x76f71bf8,0x0,0x76f71bf8,0x0,0x0,0x0,0x0,0x0,0x0,0x76f71bf8,0x0,0x76f71bf8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x102c0000,0x0,0x0,0x0,0x820,0x0,0x0,0x0,0x0,0x76f71bf8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x76f71bf8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa20,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x800,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x102c0000,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x40c00040,0x0,0x40c00040,0x0,0x40c00040,0x0,0x40c00040,0x0,0x0,0x40c00040,0x0,0x40c00040,0x40c00040,0x40c00040,0x0,0x40c00040,0x0,0x40c00040,0x40c00040,0x40c00040,0x0,0x40c00040,0x0,0x40c00040,0x40c00040,0x40c00040,0x200000,0x0,0x200000,0x0,0x10804,0x0,0x0,0x0,0x73dfbfff,0x200000,0x0,0x73dfbfff,0x73dfbdff,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x20000010,0x20000010,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x73dfbfff,0x200000,0x73dfbfff,0x0,0x80200000,0x0,0x80200000,0x0,0x0,0x0,0x0,0x0,0x0,0x73dfbfff,0x200000,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x73dfbfff,0x0,0x0,0x0,0x0,0x200000,0x0,0x73dfbfff,0x80200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x31dfbdff,0x73dfbdff,0x31dfbdff,0x73dfbfff,0x73dfbfff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x31dfbdff,0x10804,0x200000,0x10804,0x0,0x200000,0x0,0x0,0x200000,0x31dfbdff,0x73dfbfff,0x200000,0x31dfbdff,0x200000,0x0,0x0,0x0,0x0,0x0,0x80200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x200000,0x0,0x200000,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x200000,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x73dfbfff,0x0,0x0,0x0,0x0,0x0,0x0,0x73dfbdff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x73dfbdff,0x400,0x200000,0x10804,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x73dfbfff,0x0,0x0,0x0,0x0,0x0,0x73dfbfff,0x0,0x0,0x0,0x0,0x0,0x0,0x8c44882,0x200000,0x8c44882,0x8c44882,0x0,0x8c44882,0x0,0x0,0x0,0x0,0x0,0x40000000,0x40000000,0x0,0x200000,0x0,0x0,0x0,0x8c44882,0x200000,0x200000,0x8c44882,0x8000000,0x0,0x0,0x8c44882,0x0,0x0,0x8c44882,0x8000000,0x0,0x0,0x8000000,0x0,0x0,0x73dfbdff,0x0,0x0,0x0,0x73dfbfff,0x0,0x200000,0x80,0x0,0x0,0x0,0x0,0x4,0x800,0x0,0x10000,0x0,0x0,0x0,0x10800,0x0,0x10000,0x10020,0x10000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x8c40082,0x4000,0x0,0x0,0x0,0x0,0x8c44882,0x0,0x31dfbdff,0x0,0x31dfbdff,0x200000,0x200000,0x0,0x200000,0x0,0x0,0x73dfbdff,0x200000,0x73dfbdff,0x0,0x0,0x0,0x0,0x80,0x80,0x0,0x80,0x0,0x8c44882,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x73dfbdff,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x7bdfbdff,0x80000,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x80,0x80000,0x0,0x80,0x80,0x80,0x80,0x80,0x80,0x0,0x0,0x80,0x80,0x8080000,0x0,0x80000,0x0,0x0,0x0,0x1000,0x800000,0x0,0x0,0x0,0x0,0x200000,0x400000,0x0,0x400000,0x0,0x400000,0x0,0x20000,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x80000,0x200000,0x0,0x0,0x200000,0x0,0x8,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x8c44882,0x0,0x0,0x0,0x10000000,0x0,0x200000,0x200000,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x401408,0x0,0x401408,0x0,0x401408,0x0,0x401408,0x400,0x0,0x401008,0x0,0x401408,0x401408,0x401408,0x0,0x401408,0x0,0x401408,0x401408,0x401408,0x0,0x401408,0x0,0x401408,0x401408,0x401408,0x0,0x0,0x0,0x0,0x200030,0x0,0x0,0x0,0x7bff7fbf,0x0,0x0,0x7bff7fbe,0x7bdf7fbe,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7bff7fbe,0x0,0x7bff7fbe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7bff7fbe,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x7bff7fbe,0x0,0x0,0x0,0x0,0x0,0x0,0x7bff7fbe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x7bdf7fbe,0x7bdf7fbe,0x7bdf7fbe,0x7bff7fbe,0x7bff7fbf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x8000,0x8000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x7bdf7fbe,0x200030,0x0,0x200030,0x0,0x0,0x0,0x0,0x0,0x7bdf7fbe,0x7bff7fbe,0x0,0x7bdf7fbe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7bff7fbe,0x20,0x0,0x0,0x0,0x0,0x0,0x7bdf7fbe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7bdf7fbe,0x0,0x0,0x200030,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x7bff7fbe,0x8000,0x0,0x0,0x0,0x0,0x7bff7fbe,0x0,0x0,0x8000,0x0,0x0,0x0,0x400c80,0x0,0x400c80,0x400c80,0x0,0x400c80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400c80,0x0,0x0,0x400c80,0x0,0x0,0x0,0x400c80,0x0,0x0,0x400c80,0x0,0x400,0x400,0x0,0x0,0x0,0x7bdf7fbe,0x0,0x10002000,0x0,0x7bff7fbe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30,0x0,0x0,0x0,0x200030,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x400c00,0x80,0x0,0x0,0x0,0x0,0x400c80,0x10002000,0x7bdf7fbe,0x0,0x7bdf7fbe,0x0,0x0,0x0,0x0,0x0,0x0,0x7bdf7fbe,0x0,0x7bdf7fbe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400c80,0x0,0x10002100,0x10002100,0x0,0x0,0x0,0x0,0x0,0x7bdf7fbe,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x7bdf7fbe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000,0x0,0x60000,0x0,0x60000,0x10002000,0x0,0x0,0x0,0x0,0x10806000,0x0,0x0,0x0,0x0,0x0,0x0,0x400400,0x400400,0x0,0x400400,0x2,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x2,0x0,0x100000,0x0,0x500c80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x2000016,0x0,0x2000016,0x0,0x2000016,0x0,0x2000016,0x0,0x0,0x2000016,0x0,0x2000016,0x2000016,0x2000016,0x0,0x2000016,0x0,0x2000016,0x2000016,0x2000016,0x0,0x2000016,0x0,0x2000016,0x2000016,0x2000016,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2fd8f6f7,0x0,0x0,0x2fc8f6f7,0x27c8f6f7,0x0,0x0,0x0,0x0,0x0,0x2000,0x2000,0x0,0x0,0x80000,0x80000,0x40,0x200000,0x100000,0x100000,0x0,0x0,0x0,0x0,0x2fc8f6f7,0x0,0x2fc8f6f7,0x0,0x1200000,0x0,0x1200000,0x100000,0x0,0x0,0x0,0x0,0x0,0x2fc8f6f7,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2fc8f6f7,0x0,0x0,0x0,0x0,0x0,0x0,0x2fd8f6f7,0x1200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x23c8f6f7,0x27c8f6f7,0x23c8f6f7,0x2fc8f6f7,0x2fd8f6f7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x23c8f6f7,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x23c8f6f7,0x2fc8f6f7,0x0,0x23c8f6f7,0x0,0x0,0x0,0x0,0x1,0x1,0x1200000,0x0,0x0,0x20000,0x1000000,0x0,0x0,0x0,0x200000,0x0,0x200000,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x1000,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x100000,0x110000,0x10000,0x110000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2fc8f6f7,0x0,0x1000,0x0,0x0,0x0,0x0,0x27c8f6f7,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x8000,0x8000,0x0,0x27c8f6f7,0x0,0x0,0x0,0x0,0x0,0x6,0x0,0x0,0x0,0x0,0x2fc8f6f7,0x0,0x0,0x0,0x0,0x0,0x2fc8f6f7,0x0,0x0,0x0,0x0,0x0,0x0,0x42001,0x0,0x42001,0x42001,0x0,0x42001,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x1000000,0x42001,0x0,0x0,0x42001,0x0,0x0,0x0,0x42001,0x0,0x400000,0x42001,0x0,0x0,0x0,0x0,0x0,0x0,0x27c8f6f7,0x0,0x0,0x0,0x2fc8f6f7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x42001,0x0,0x0,0x0,0x0,0x0,0x42001,0x0,0x23c8f6f7,0x0,0x23c8f6f7,0x0,0x0,0x0,0x0,0x0,0x0,0x27c8f6f7,0x0,0x27c8f6f7,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x42001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x27c8f6f7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x27ccf6f7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x20000000,0x0,0x20000,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x20000,0x20000,0x0,0x0,0x4,0x4,0x0,0x4,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x0,0x0,0x800000,0x42001,0x800000,0x0,0x0,0x0,0x0,0x100000,0x100000,};
	}
	private static void jj_la1_init_4() {
	   jj_la1_4 = new int[] {0x2000,0x0,0x2000,0x0,0x2000,0x0,0x2004,0x2000,0x0,0x0,0x0,0x2000,0x2000,0x2000,0x0,0x2000,0x0,0x2000,0x2000,0x2004,0x0,0x2000,0x0,0x2000,0x2000,0x2004,0x0,0x0,0x0,0x0,0x420000,0x0,0x0,0x0,0xf852e6df,0x0,0x0,0xf852e6df,0xf852e693,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x400000,0x400000,0x0,0x0,0x0,0x0,0x40,0x40,0x0,0x0,0x0,0x0,0xf852e6df,0x0,0xf852e6df,0x40000,0x201800,0x0,0x201800,0x0,0x0,0x0,0x0,0x0,0x0,0xf852e6df,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf852e6df,0x40000,0x2000,0x0,0x0,0x0,0x0,0xf852e6df,0x201800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf850e683,0xf852e693,0xf852e683,0xf852e6df,0xf852e6df,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x400000,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0xf852e683,0x420000,0x0,0x420000,0x400,0x0,0x10,0x10000400,0x0,0xf852e683,0xf852e6df,0x0,0xf852e683,0x0,0x0,0x0,0x0,0x80,0x80,0x201800,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x800,0x800,0x0,0x201000,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x180000,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x10000000,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x2800000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf852e6df,0x0,0x80000000,0x10,0x10,0x0,0x0,0xf852e693,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0xf852e693,0x8000,0x0,0x420000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf852e6df,0x0,0x0,0x0,0x0,0x10,0xf852e6df,0x0,0x0,0x0,0x0,0x0,0x0,0x10000040,0x0,0x10000040,0x10000040,0x0,0x10000040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000040,0x0,0x0,0x10000040,0x0,0x10000000,0x0,0x10000040,0x0,0x0,0x10000040,0x0,0x0,0x0,0x0,0x0,0x0,0xf852e693,0x0,0x0,0x0,0xf852e6df,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x420000,0x0,0x0,0x0,0x420000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000040,0x0,0x0,0x0,0x0,0x0,0x10000040,0x0,0xf850e683,0x0,0xf850e683,0x0,0x0,0x0,0x0,0x0,0x0,0xf852e693,0x0,0xf852e693,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x10000040,0x0,0x0,0x0,0x0,0x0,0x10000400,0x0,0x0,0xf852e693,0x0,0x10000400,0x0,0x10000400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000400,0x10000400,0x0,0x10000000,0xf852e693,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x404,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x2000,0x0,0x2000,0x8000200,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x8000200,0x0,0x0,0x0,0x10000440,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_5() {
	   jj_la1_5 = new int[] {0x8000,0x0,0x8000,0x0,0x8000,0x0,0x8000,0x8000,0x0,0x0,0x0,0x8000,0x8000,0x8000,0x0,0x8000,0x0,0x8000,0x8000,0x8000,0x0,0x8000,0x0,0x8000,0x8000,0x8000,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x7daefdf6,0x0,0x0,0x7daefdf6,0x7daefde2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x0,0x0,0x7daefdf6,0x0,0x7daefdf6,0x0,0x100004,0x0,0x100004,0x0,0x0,0x0,0x10,0x0,0x0,0x7daefdf6,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7daefdf6,0x0,0x0,0x0,0x0,0x0,0x0,0x7daefdf6,0x100004,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7daefde2,0x7daefde2,0x7daefde2,0x7daefdf6,0x7daefdf6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x1,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x7daefde2,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x7daefde2,0x7daefdf6,0x0,0x7daefde2,0x0,0x0,0x0,0x0,0x0,0x0,0x100004,0x1,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x10,0x0,0x200000,0x0,0x0,0x0,0x10,0x0,0x80000000,0x80000000,0x80000000,0x0,0x80000000,0x80000000,0x80000000,0x80000000,0x0,0x0,0x4000,0x80000000,0x0,0x0,0x80000000,0x80000000,0x80000000,0x8,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7daefdf6,0x0,0x0,0x0,0x0,0x0,0x0,0x7daefde2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7daefde2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7daefdf6,0x0,0x0,0x0,0x0,0x0,0x7daefdf6,0x0,0x0,0x0,0x0,0x0,0x1,0x80400000,0x0,0x80400000,0x80400000,0x0,0x80400000,0x0,0x0,0x0,0x0,0x0,0x801000,0x801000,0x0,0x0,0x0,0x0,0x0,0x80400000,0x0,0x0,0x80400000,0x0,0x0,0x0,0x80400000,0x0,0x0,0x80400000,0x0,0x0,0x0,0x0,0x0,0x0,0x7daefde2,0x0,0x0,0x0,0x7daefdf6,0x8,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x800000,0x0,0x0,0x1000,0x800000,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x400000,0x80000000,0x0,0x7daefde2,0x0,0x7daefde2,0x0,0x0,0x0,0x0,0x0,0x0,0x7daefde2,0x0,0x7daefde2,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80400000,0x80000000,0x80000000,0x80000000,0x40000,0x0,0x0,0x0,0x0,0x7daefde2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7daefde2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x77022000,0x0,0x10002000,0x20020000,0x2000000,0x1000000,0x40000000,0x4000000,0x0,0x77022000,0x0,0x0,0x0,0x80400000,0x0,0x0,0x0,0x0,0x2,0x0,0x0,};
	}
	private static void jj_la1_init_6() {
	   jj_la1_6 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfdfe4bf7,0x0,0x0,0xfdfe4bf7,0x7df60af7,0x20,0x20,0x0,0x0,0x0,0x280,0x280,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfdfe4bf7,0x0,0xfdfe4bf7,0x0,0x8000,0x10000,0x8000,0x0,0x0,0x4000,0x0,0x0,0x0,0xfdfe4bf7,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x200,0x200,0x0,0x0,0x0,0x200,0x0,0x0,0xfdfe4bf7,0x0,0x0,0x0,0x200,0x0,0x10000,0xfdfe4bf7,0x8000,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7df608f7,0x7df60af7,0x7df608f7,0xfdfe4bf7,0xfdfe4bf7,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7df608f7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7df608f7,0xfdfe4bf7,0x0,0x7df608f7,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x2000000,0x0,0x0,0x0,0x8000,0x8000,0x0,0x8000,0x0,0x8000,0x8000,0x8000,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x4000,0x0,0x8,0x0,0x0,0x400000,0x4000,0x0,0x0,0x0,0x0,0xfdfe4bf7,0x0,0x0,0x0,0x20000,0x0,0x400000,0x7df60af7,0x0,0x400000,0x4000,0x0,0x20000,0x0,0x0,0x8000000,0x8000000,0x0,0x7df60af7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfdfe4bf7,0x0,0x4000,0x0,0x0,0x0,0xfdfe4bf7,0x0,0x4000,0x0,0x4000,0x0,0x0,0x20500208,0x0,0x20500208,0x20500208,0x0,0x20500208,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20500208,0x0,0x0,0x20500208,0x0,0x0,0x20000000,0x20500208,0x0,0x0,0x20500208,0x0,0x0,0x0,0x0,0x0,0x0,0x7df60af7,0x0,0x0,0x0,0xfdfe4bf7,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x20500208,0x0,0x0,0x0,0x0,0x0,0x20500208,0x0,0x7df608f7,0x0,0x7df608f7,0x0,0x0,0x0,0x0,0x0,0x0,0x7df60af7,0x0,0x7df60af7,0x0,0x0,0x0,0x0,0x200,0x200,0x400,0x0,0x0,0x20500208,0x0,0x4,0x4,0x0,0x0,0x0,0x0,0x0,0x7df60af7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x7df60af7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x1,0x0,0x100000,0x0,0x100000,0x0,0x0,0x100000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x4000,0x1000,0x0,0x80000000,0x20500208,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_7() {
	   jj_la1_7 = new int[] {0x80d0002,0x0,0x80d0002,0x0,0x80d0002,0x0,0x80d0002,0x0,0x0,0x8090002,0x0,0x80d0002,0x80d0002,0x80d0002,0x0,0x80d0002,0x0,0x80d0002,0x80d0002,0x80d0002,0x0,0x80d0002,0x0,0x80d0002,0x80d0002,0x80d0002,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7dffdbff,0x0,0x0,0x7dffdbff,0x79ffdbfe,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x7dffdbff,0x0,0x7dffdbff,0x0,0x4000000,0x0,0x4000000,0x0,0x0,0x0,0x0,0x2000000,0x0,0x7dffdbff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x7dffdbff,0x0,0x40000,0x0,0x0,0x0,0x0,0x7dffdbff,0x4000000,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x79ffdbfa,0x79ffdbfe,0x79ffdbfa,0x7dffdbff,0x7dffdbff,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x10000000,0x10000000,0x0,0x10000000,0x80,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x79ffdbfa,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x79ffdbfa,0x7dffdbff,0x0,0x79ffdbfa,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x4000000,0x4000000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000000,0x0,0x60000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000040,0x0,0x0,0x0,0x7dffdbff,0x0,0x0,0x0,0x0,0x0,0x0,0x79ffdbfe,0x0,0x0,0x0,0x40000040,0x0,0x40000040,0x0,0x0,0x0,0x0,0x79ffdbfe,0x80000000,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7dffdbff,0x0,0x0,0x0,0x0,0x0,0x7dffdbff,0x0,0x0,0x0,0x0,0x0,0x0,0x40000800,0x0,0x40000800,0x40000800,0x0,0x40000800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000800,0x0,0x0,0x40000800,0x0,0x0,0x0,0x40000800,0x0,0x0,0x40000800,0x0,0x0,0x0,0x0,0x0,0x0,0x79ffdbfe,0x0,0x0,0x0,0x7dffdbff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x40000800,0x0,0x0,0x0,0x0,0x0,0x40000800,0x0,0x79ffdbfa,0x0,0x79ffdbfa,0x0,0x0,0x0,0x0,0x0,0x0,0x79ffdbfe,0x0,0x79ffdbfe,0x0,0x0,0x0,0x0,0x800000,0x800000,0x0,0x0,0x0,0x40000800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x79ffdbfe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x79ffdbfe,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x800000,0x800000,0x800000,0x800000,0x800000,0x0,0x0,0x800000,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x40000,0x0,0x0,0x8000000,0x8,0x200000,0x8,0x200000,0x8,0x0,0x0,0x0,0x0,0x0,0x488020,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x1,0x40000800,0x0,0x1,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_8() {
	   jj_la1_8 = new int[] {0xa12,0x0,0xa12,0x0,0xa12,0x0,0xa12,0x10,0x10,0xa02,0x0,0xa12,0xa12,0xa12,0x0,0xa12,0x0,0xa12,0xa12,0xa12,0x0,0xa12,0x0,0xa12,0xa12,0xa12,0x0,0x0,0x0,0x0,0x2100200,0x100,0x0,0x0,0xf7ffffde,0x0,0x0,0xf7ffffce,0xf7fdfdce,0x0,0x0,0x0,0x0,0x12000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf7ffffce,0x0,0xf7ffffce,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf7ffffce,0x0,0x0,0x0,0x0,0x0,0x0,0x210,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf7ffffce,0x0,0x0,0x210,0x0,0x0,0x0,0xf7ffffce,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf3f9fdce,0xf7fdfdce,0xf3f9fdce,0xf7ffffce,0xf7ffffde,0x0,0x0,0x1000000,0x8000001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0xf3f9fdce,0x100200,0x0,0x100200,0x0,0x0,0x800,0x0,0x0,0xf3f9fdce,0xf7ffffce,0x0,0xf3f9fdce,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x40000,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf7ffffce,0x0,0x0,0x0,0x0,0x0,0x0,0xf7fdfdce,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf7fdfdce,0x0,0x0,0x100200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf7ffffce,0x0,0x0,0x0,0x10,0x0,0xf7ffffce,0x0,0x0,0x0,0x0,0x80,0x0,0x900c0000,0x0,0x900c0000,0x900c0000,0x0,0x900c0000,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x900c0000,0x0,0x0,0x900c0000,0x0,0x0,0x0,0x900c0000,0x0,0x0,0x900c0000,0x0,0x0,0x0,0x0,0x0,0x0,0xf7fdfdce,0x0,0x0,0x0,0xf7ffffce,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x100200,0x0,0x0,0x0,0x100200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x800c0000,0x0,0x0,0x0,0x0,0x0,0x800c0000,0x0,0xf3f9fdce,0x0,0xf3f9fdce,0x0,0x0,0x0,0x0,0x0,0x0,0xf7fdfdce,0x0,0xf7fdfdce,0x0,0x0,0x2000044,0x0,0x0,0x0,0x0,0x0,0x0,0x900c0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf7fdfdce,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf7fdfdce,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3000140,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x601200,0x0,0x2,0x0,0x0,0x2000000,0x0,0x10,0x10,0x0,0x10,0x40100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x40100,0x0,0x20000000,0x800044,0xb00c0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_9() {
	   jj_la1_9 = new int[] {0xc0160080,0x0,0xc0160080,0x0,0xc0160080,0x0,0xc0160080,0xc0020000,0xc0000000,0x100080,0x0,0xc0160080,0xc0160080,0xc0160080,0x0,0xc0160080,0x0,0xc0160080,0xc0160080,0xc0160080,0x0,0xc0160080,0x0,0xc0160080,0xc0160080,0xc0160080,0x0,0x0,0x0,0x0,0x14000000,0x0,0x0,0x0,0xfc2e8db7,0x0,0x0,0xfc2e8db7,0xfc2e8db7,0x0,0x0,0x0,0x200000,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0x0,0xfc2e8db7,0x0,0xfc2e8db7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc2e8db7,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc2e8db7,0x0,0x40000,0xc0000000,0x0,0x0,0x0,0xfc2e8db7,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c2e8d97,0xfc2e8db7,0xfc2e8db7,0xfc2e8db7,0xfc2e8db7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x800,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x1c04000,0x0,0x0,0x0,0x0,0x2000,0xc0000000,0x0,0x0,0x0,0x0,0x0,0xfc2e8db7,0x14000000,0x0,0x14000000,0x0,0x0,0x100000,0x0,0x0,0xfc2e8db7,0xfc2e8db7,0x0,0xfc2e8db7,0x0,0x0,0xc0000000,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc2e8db7,0x0,0x0,0x0,0x0,0x0,0x0,0xfc2e8db7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0xfc2e8db7,0x200,0x0,0x14000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfc2e8db7,0x4000,0x0,0x0,0xc0000000,0x0,0xfc2e8db7,0x0,0x0,0x0,0x0,0x0,0x0,0x12024903,0x0,0x12024903,0x12024903,0x2000000,0x12024903,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0x8000,0x0,0x12024903,0x0,0x0,0x12024903,0x0,0x0,0x4000,0x12024903,0x4000,0x0,0x12024903,0x0,0x20000,0x20000,0x0,0x0,0x0,0xfc2e8db7,0x0,0x0,0x0,0xfc2e8db7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x12024903,0x0,0x0,0x0,0x0,0x0,0x12024903,0x0,0x3c2e8d97,0x0,0x3c2e8d97,0x0,0x0,0x0,0x0,0x0,0x0,0xfc2e8db7,0x0,0xfc2e8db7,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x800,0x12024903,0x0,0x20000000,0x20000000,0x0,0x2000000,0x0,0x2000000,0x0,0xfc2e8db7,0x0,0x0,0x0,0x0,0x2000000,0x0,0x20000,0x20000,0x0,0x20000,0x20000,0x2000000,0x0,0x0,0x0,0x2000000,0x4000,0xfc2ecdb7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x20000,0x20000,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x12024903,0x0,0x0,0x0,0x8,0x40,0x0,0x0,};
	}
	private static void jj_la1_init_10() {
	   jj_la1_10 = new int[] {0x80,0x1000000,0x80,0x1000000,0x80,0x1000000,0x80,0x80,0x80,0x0,0x1000000,0x80,0x80,0x80,0x1000000,0x80,0x1000000,0x80,0x80,0x80,0x1000000,0x80,0x1000000,0x80,0x80,0x80,0x0,0x0,0x0,0x0,0x40002000,0x0,0x0,0x0,0xff360e,0x0,0x0,0xff360e,0xff360e,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x202000,0x202000,0x2,0x2,0x0,0x0,0x0,0x0,0x20,0x20,0x0,0x0,0xff360e,0x0,0xff360e,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0xff360e,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x20,0x0,0x20,0x0,0xff360e,0x0,0x0,0x80,0x0,0x0,0x0,0xff360e,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x10,0x10,0x10,0x10,0x20,0x0,0x0,0x20,0x0,0x0,0x0,0xff360e,0xff360e,0xff360e,0xff360e,0xff360e,0x80000000,0x0,0x0,0x0,0x80,0x0,0x0,0x100000,0x60000,0x20000,0x100000,0x0,0x0,0x0,0x800,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff360e,0x40002000,0x0,0x40002000,0x0,0x0,0x0,0x0,0x0,0xff360e,0xff360e,0x0,0xff360e,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x480,0x480,0x0,0x0,0x0,0x0,0xc0000000,0x0,0x0,0x0,0x0,0x0,0x480,0x480,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0xff360e,0x0,0x0,0x0,0x200,0x0,0x0,0xff360e,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0xff360e,0x0,0x0,0x40002000,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0xff360e,0x0,0x0,0x0,0x80,0x0,0xff360e,0x0,0x0,0x0,0x0,0x0,0x0,0x800000a0,0x0,0x800000a0,0x800000a0,0x0,0x800000a0,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x0,0x0,0x0,0x0,0x0,0x800000a0,0x0,0x0,0x800000a0,0x0,0x0,0x0,0x800000a0,0x0,0x0,0x800000a0,0x0,0x0,0x0,0x0,0x0,0x0,0xff360e,0x0,0x0,0x0,0xff360e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x40002000,0x0,0x0,0x0,0x40002000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa0,0x0,0x0,0x0,0x80000000,0x0,0x800000a0,0x0,0x80ff360e,0x80000000,0x80ff360e,0x0,0x0,0x0,0x0,0x0,0x0,0xff360e,0x0,0xff360e,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x800000a0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff360e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff360e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000a0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_11() {
	   jj_la1_11 = new int[] {0x8000000,0x0,0x8000000,0x0,0x8000000,0x0,0x8000000,0x8000000,0x8000000,0x0,0x0,0x8000000,0x8000000,0x8000000,0x0,0x8000000,0x0,0x8000000,0x8000000,0x8000000,0x0,0x8000000,0x0,0x8000000,0x8000000,0x8000000,0x0,0x20000000,0x0,0x20000000,0x4000040,0x0,0x20000000,0x20000000,0x4000040,0x0,0x20000000,0x4000040,0x4000040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x4000040,0x0,0x4000040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x8000000,0xc000040,0x8000000,0x8000000,0x8000000,0x0,0x0,0x0,0x8000000,0x8000000,0x0,0x40000000,0x0,0x0,0x8000000,0x0,0x0,0x4000040,0x0,0x0,0x8000000,0x0,0x0,0x0,0x4000040,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x80000000,0x80000000,0x80000000,0x4000040,0x4000040,0x4000040,0x4000040,0x4000040,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x8000000,0x0,0x0,0x6000040,0x4000040,0x0,0x4000040,0x0,0x0,0x0,0x0,0x0,0x6000040,0xc000040,0x0,0x6000040,0x0,0x8000000,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000001,0x41,0x0,0x41,0x0,0x0,0x8000000,0x0,0x0,0x0,0x8000000,0x0,0x8000000,0x20000000,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x5,0x0,0x2000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x2000001,0x2000001,0x0,0x2000001,0x2000001,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6000045,0x0,0x4000040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x2000001,0x0,0x4000040,0x40,0x0,0x0,0x0,0x8000000,0x0,0xc000040,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6000040,0x0,0x0,0x4000040,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x4000040,0x0,0x0,0x0,0x8000000,0x0,0x4000040,0x80000000,0x0,0x0,0x0,0x0,0x0,0x2e000041,0x0,0x2e000041,0x2e000041,0x0,0x2e000041,0x4000040,0x4000040,0x4000040,0x0,0x0,0x0,0x0,0x4000040,0x0,0x4000040,0x0,0x0,0x2e000041,0x0,0x0,0x2e000041,0x0,0x0,0x0,0x2e000041,0x0,0x0,0x2e000041,0x0,0x0,0x0,0x0,0x8000000,0x8000000,0x4000040,0x8000000,0x0,0x0,0x4000040,0x0,0x0,0x0,0x0,0x41,0x41,0x41,0x0,0x0,0x0,0x4000040,0x4000040,0x80000000,0x0,0x4000040,0x0,0x2000041,0x0,0x2000041,0x0,0x1,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x8000000,0x4000040,0x4000040,0x80000000,0x0,0x22000000,0x0,0x0,0x0,0x1,0x4000040,0x2a000001,0x0,0x6000041,0x2000001,0x6000041,0x20000000,0x20000000,0x8000000,0x0,0x8000000,0x8000000,0x4000040,0x0,0x4000040,0x0,0x0,0x40,0x8000000,0x40,0x40,0x0,0x0,0x0,0x2e000041,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000040,0x0,0x0,0x4000040,0x0,0x0,0x8000000,0x0,0x0,0x8000000,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0xc000040,0x0,0x4000040,0x0,0x0,0x0,0x0,0x4000040,0x0,0x0,0x0,0xc000040,0x4000040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000040,0x0,0x0,0xc000040,0x20000000,0x0,0x4000040,0x4000040,0x4000040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x22000041,0x22000041,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2e000041,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_12() {
	   jj_la1_12 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x103e,0x0,0x0,0x3e,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x103e,0x0,0x103e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x103e,0x0,0x0,0x0,0x0,0x0,0x0,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x3e,0x3e,0x3e,0x3e,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e,0x3e,0x0,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x81,0x80,0x0,0x80,0x100,0x100,0x100,0x0,0x100,0x100,0x100,0x100,0x0,0x1fff880,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x3c000000,0x200200,0xc0000040,0x0,0x1,0x0,0x1,0x100,0x100,0x202200,0x202200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000001,0x1000,0x1,0x0,0x0,0x1,0x0,0x80,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x8000001,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x81,0x0,0x0,0x0,0x3e,0x0,0x0,0x40,0x0,0x0,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x200200,0x0,0x200200,0x200200,0x0,0x200200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200200,0x0,0x0,0x200200,0x0,0x0,0x0,0x200200,0x0,0x0,0x200200,0x0,0x0,0x0,0x0,0x0,0x0,0x3e,0x0,0x0,0x0,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200200,0x200200,0x200200,0x0,0x200200,0x0,0x3e,0x0,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x3e,0x0,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_13() {
	   jj_la1_13 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x68,0x0,0x2,0x80,0x0,0x100,0x0,0x2,0x0,0x0,0x2,0x0,0x100,0x0,0x80,0x0,0x0,0x1e00,0x0,0x0,0x1e00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e000,0x1e000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x80,0x80,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x80,0x0,0x0,0x0,0x80,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x80000,0x0,0x0,0x0,0x40000,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x300000,0x300000,0xc00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[342];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public CCJSqlParser(Provider stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new CCJSqlParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 562; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public CCJSqlParser(String dsl) throws ParseException, TokenMgrException {
	   this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
	  ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new CCJSqlParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jjtree.reset();
	 jj_gen = 0;
	 for (int i = 0; i < 562; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public CCJSqlParser(CCJSqlParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 562; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CCJSqlParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jjtree.reset();
	 jj_gen = 0;
	 for (int i = 0; i < 562; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = jj_lookingAhead ? jj_scanpos : token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[440];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 562; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		   if ((jj_la1_3[i] & (1<<j)) != 0) {
			 la1tokens[96+j] = true;
		   }
		   if ((jj_la1_4[i] & (1<<j)) != 0) {
			 la1tokens[128+j] = true;
		   }
		   if ((jj_la1_5[i] & (1<<j)) != 0) {
			 la1tokens[160+j] = true;
		   }
		   if ((jj_la1_6[i] & (1<<j)) != 0) {
			 la1tokens[192+j] = true;
		   }
		   if ((jj_la1_7[i] & (1<<j)) != 0) {
			 la1tokens[224+j] = true;
		   }
		   if ((jj_la1_8[i] & (1<<j)) != 0) {
			 la1tokens[256+j] = true;
		   }
		   if ((jj_la1_9[i] & (1<<j)) != 0) {
			 la1tokens[288+j] = true;
		   }
		   if ((jj_la1_10[i] & (1<<j)) != 0) {
			 la1tokens[320+j] = true;
		   }
		   if ((jj_la1_11[i] & (1<<j)) != 0) {
			 la1tokens[352+j] = true;
		   }
		   if ((jj_la1_12[i] & (1<<j)) != 0) {
			 la1tokens[384+j] = true;
		   }
		   if ((jj_la1_13[i] & (1<<j)) != 0) {
			 la1tokens[416+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 440; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : CCJSqlParserTokenManager.lexStateNames[token_source.curLexState]);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 342; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			   case 7: jj_3_8(); break;
			   case 8: jj_3_9(); break;
			   case 9: jj_3_10(); break;
			   case 10: jj_3_11(); break;
			   case 11: jj_3_12(); break;
			   case 12: jj_3_13(); break;
			   case 13: jj_3_14(); break;
			   case 14: jj_3_15(); break;
			   case 15: jj_3_16(); break;
			   case 16: jj_3_17(); break;
			   case 17: jj_3_18(); break;
			   case 18: jj_3_19(); break;
			   case 19: jj_3_20(); break;
			   case 20: jj_3_21(); break;
			   case 21: jj_3_22(); break;
			   case 22: jj_3_23(); break;
			   case 23: jj_3_24(); break;
			   case 24: jj_3_25(); break;
			   case 25: jj_3_26(); break;
			   case 26: jj_3_27(); break;
			   case 27: jj_3_28(); break;
			   case 28: jj_3_29(); break;
			   case 29: jj_3_30(); break;
			   case 30: jj_3_31(); break;
			   case 31: jj_3_32(); break;
			   case 32: jj_3_33(); break;
			   case 33: jj_3_34(); break;
			   case 34: jj_3_35(); break;
			   case 35: jj_3_36(); break;
			   case 36: jj_3_37(); break;
			   case 37: jj_3_38(); break;
			   case 38: jj_3_39(); break;
			   case 39: jj_3_40(); break;
			   case 40: jj_3_41(); break;
			   case 41: jj_3_42(); break;
			   case 42: jj_3_43(); break;
			   case 43: jj_3_44(); break;
			   case 44: jj_3_45(); break;
			   case 45: jj_3_46(); break;
			   case 46: jj_3_47(); break;
			   case 47: jj_3_48(); break;
			   case 48: jj_3_49(); break;
			   case 49: jj_3_50(); break;
			   case 50: jj_3_51(); break;
			   case 51: jj_3_52(); break;
			   case 52: jj_3_53(); break;
			   case 53: jj_3_54(); break;
			   case 54: jj_3_55(); break;
			   case 55: jj_3_56(); break;
			   case 56: jj_3_57(); break;
			   case 57: jj_3_58(); break;
			   case 58: jj_3_59(); break;
			   case 59: jj_3_60(); break;
			   case 60: jj_3_61(); break;
			   case 61: jj_3_62(); break;
			   case 62: jj_3_63(); break;
			   case 63: jj_3_64(); break;
			   case 64: jj_3_65(); break;
			   case 65: jj_3_66(); break;
			   case 66: jj_3_67(); break;
			   case 67: jj_3_68(); break;
			   case 68: jj_3_69(); break;
			   case 69: jj_3_70(); break;
			   case 70: jj_3_71(); break;
			   case 71: jj_3_72(); break;
			   case 72: jj_3_73(); break;
			   case 73: jj_3_74(); break;
			   case 74: jj_3_75(); break;
			   case 75: jj_3_76(); break;
			   case 76: jj_3_77(); break;
			   case 77: jj_3_78(); break;
			   case 78: jj_3_79(); break;
			   case 79: jj_3_80(); break;
			   case 80: jj_3_81(); break;
			   case 81: jj_3_82(); break;
			   case 82: jj_3_83(); break;
			   case 83: jj_3_84(); break;
			   case 84: jj_3_85(); break;
			   case 85: jj_3_86(); break;
			   case 86: jj_3_87(); break;
			   case 87: jj_3_88(); break;
			   case 88: jj_3_89(); break;
			   case 89: jj_3_90(); break;
			   case 90: jj_3_91(); break;
			   case 91: jj_3_92(); break;
			   case 92: jj_3_93(); break;
			   case 93: jj_3_94(); break;
			   case 94: jj_3_95(); break;
			   case 95: jj_3_96(); break;
			   case 96: jj_3_97(); break;
			   case 97: jj_3_98(); break;
			   case 98: jj_3_99(); break;
			   case 99: jj_3_100(); break;
			   case 100: jj_3_101(); break;
			   case 101: jj_3_102(); break;
			   case 102: jj_3_103(); break;
			   case 103: jj_3_104(); break;
			   case 104: jj_3_105(); break;
			   case 105: jj_3_106(); break;
			   case 106: jj_3_107(); break;
			   case 107: jj_3_108(); break;
			   case 108: jj_3_109(); break;
			   case 109: jj_3_110(); break;
			   case 110: jj_3_111(); break;
			   case 111: jj_3_112(); break;
			   case 112: jj_3_113(); break;
			   case 113: jj_3_114(); break;
			   case 114: jj_3_115(); break;
			   case 115: jj_3_116(); break;
			   case 116: jj_3_117(); break;
			   case 117: jj_3_118(); break;
			   case 118: jj_3_119(); break;
			   case 119: jj_3_120(); break;
			   case 120: jj_3_121(); break;
			   case 121: jj_3_122(); break;
			   case 122: jj_3_123(); break;
			   case 123: jj_3_124(); break;
			   case 124: jj_3_125(); break;
			   case 125: jj_3_126(); break;
			   case 126: jj_3_127(); break;
			   case 127: jj_3_128(); break;
			   case 128: jj_3_129(); break;
			   case 129: jj_3_130(); break;
			   case 130: jj_3_131(); break;
			   case 131: jj_3_132(); break;
			   case 132: jj_3_133(); break;
			   case 133: jj_3_134(); break;
			   case 134: jj_3_135(); break;
			   case 135: jj_3_136(); break;
			   case 136: jj_3_137(); break;
			   case 137: jj_3_138(); break;
			   case 138: jj_3_139(); break;
			   case 139: jj_3_140(); break;
			   case 140: jj_3_141(); break;
			   case 141: jj_3_142(); break;
			   case 142: jj_3_143(); break;
			   case 143: jj_3_144(); break;
			   case 144: jj_3_145(); break;
			   case 145: jj_3_146(); break;
			   case 146: jj_3_147(); break;
			   case 147: jj_3_148(); break;
			   case 148: jj_3_149(); break;
			   case 149: jj_3_150(); break;
			   case 150: jj_3_151(); break;
			   case 151: jj_3_152(); break;
			   case 152: jj_3_153(); break;
			   case 153: jj_3_154(); break;
			   case 154: jj_3_155(); break;
			   case 155: jj_3_156(); break;
			   case 156: jj_3_157(); break;
			   case 157: jj_3_158(); break;
			   case 158: jj_3_159(); break;
			   case 159: jj_3_160(); break;
			   case 160: jj_3_161(); break;
			   case 161: jj_3_162(); break;
			   case 162: jj_3_163(); break;
			   case 163: jj_3_164(); break;
			   case 164: jj_3_165(); break;
			   case 165: jj_3_166(); break;
			   case 166: jj_3_167(); break;
			   case 167: jj_3_168(); break;
			   case 168: jj_3_169(); break;
			   case 169: jj_3_170(); break;
			   case 170: jj_3_171(); break;
			   case 171: jj_3_172(); break;
			   case 172: jj_3_173(); break;
			   case 173: jj_3_174(); break;
			   case 174: jj_3_175(); break;
			   case 175: jj_3_176(); break;
			   case 176: jj_3_177(); break;
			   case 177: jj_3_178(); break;
			   case 178: jj_3_179(); break;
			   case 179: jj_3_180(); break;
			   case 180: jj_3_181(); break;
			   case 181: jj_3_182(); break;
			   case 182: jj_3_183(); break;
			   case 183: jj_3_184(); break;
			   case 184: jj_3_185(); break;
			   case 185: jj_3_186(); break;
			   case 186: jj_3_187(); break;
			   case 187: jj_3_188(); break;
			   case 188: jj_3_189(); break;
			   case 189: jj_3_190(); break;
			   case 190: jj_3_191(); break;
			   case 191: jj_3_192(); break;
			   case 192: jj_3_193(); break;
			   case 193: jj_3_194(); break;
			   case 194: jj_3_195(); break;
			   case 195: jj_3_196(); break;
			   case 196: jj_3_197(); break;
			   case 197: jj_3_198(); break;
			   case 198: jj_3_199(); break;
			   case 199: jj_3_200(); break;
			   case 200: jj_3_201(); break;
			   case 201: jj_3_202(); break;
			   case 202: jj_3_203(); break;
			   case 203: jj_3_204(); break;
			   case 204: jj_3_205(); break;
			   case 205: jj_3_206(); break;
			   case 206: jj_3_207(); break;
			   case 207: jj_3_208(); break;
			   case 208: jj_3_209(); break;
			   case 209: jj_3_210(); break;
			   case 210: jj_3_211(); break;
			   case 211: jj_3_212(); break;
			   case 212: jj_3_213(); break;
			   case 213: jj_3_214(); break;
			   case 214: jj_3_215(); break;
			   case 215: jj_3_216(); break;
			   case 216: jj_3_217(); break;
			   case 217: jj_3_218(); break;
			   case 218: jj_3_219(); break;
			   case 219: jj_3_220(); break;
			   case 220: jj_3_221(); break;
			   case 221: jj_3_222(); break;
			   case 222: jj_3_223(); break;
			   case 223: jj_3_224(); break;
			   case 224: jj_3_225(); break;
			   case 225: jj_3_226(); break;
			   case 226: jj_3_227(); break;
			   case 227: jj_3_228(); break;
			   case 228: jj_3_229(); break;
			   case 229: jj_3_230(); break;
			   case 230: jj_3_231(); break;
			   case 231: jj_3_232(); break;
			   case 232: jj_3_233(); break;
			   case 233: jj_3_234(); break;
			   case 234: jj_3_235(); break;
			   case 235: jj_3_236(); break;
			   case 236: jj_3_237(); break;
			   case 237: jj_3_238(); break;
			   case 238: jj_3_239(); break;
			   case 239: jj_3_240(); break;
			   case 240: jj_3_241(); break;
			   case 241: jj_3_242(); break;
			   case 242: jj_3_243(); break;
			   case 243: jj_3_244(); break;
			   case 244: jj_3_245(); break;
			   case 245: jj_3_246(); break;
			   case 246: jj_3_247(); break;
			   case 247: jj_3_248(); break;
			   case 248: jj_3_249(); break;
			   case 249: jj_3_250(); break;
			   case 250: jj_3_251(); break;
			   case 251: jj_3_252(); break;
			   case 252: jj_3_253(); break;
			   case 253: jj_3_254(); break;
			   case 254: jj_3_255(); break;
			   case 255: jj_3_256(); break;
			   case 256: jj_3_257(); break;
			   case 257: jj_3_258(); break;
			   case 258: jj_3_259(); break;
			   case 259: jj_3_260(); break;
			   case 260: jj_3_261(); break;
			   case 261: jj_3_262(); break;
			   case 262: jj_3_263(); break;
			   case 263: jj_3_264(); break;
			   case 264: jj_3_265(); break;
			   case 265: jj_3_266(); break;
			   case 266: jj_3_267(); break;
			   case 267: jj_3_268(); break;
			   case 268: jj_3_269(); break;
			   case 269: jj_3_270(); break;
			   case 270: jj_3_271(); break;
			   case 271: jj_3_272(); break;
			   case 272: jj_3_273(); break;
			   case 273: jj_3_274(); break;
			   case 274: jj_3_275(); break;
			   case 275: jj_3_276(); break;
			   case 276: jj_3_277(); break;
			   case 277: jj_3_278(); break;
			   case 278: jj_3_279(); break;
			   case 279: jj_3_280(); break;
			   case 280: jj_3_281(); break;
			   case 281: jj_3_282(); break;
			   case 282: jj_3_283(); break;
			   case 283: jj_3_284(); break;
			   case 284: jj_3_285(); break;
			   case 285: jj_3_286(); break;
			   case 286: jj_3_287(); break;
			   case 287: jj_3_288(); break;
			   case 288: jj_3_289(); break;
			   case 289: jj_3_290(); break;
			   case 290: jj_3_291(); break;
			   case 291: jj_3_292(); break;
			   case 292: jj_3_293(); break;
			   case 293: jj_3_294(); break;
			   case 294: jj_3_295(); break;
			   case 295: jj_3_296(); break;
			   case 296: jj_3_297(); break;
			   case 297: jj_3_298(); break;
			   case 298: jj_3_299(); break;
			   case 299: jj_3_300(); break;
			   case 300: jj_3_301(); break;
			   case 301: jj_3_302(); break;
			   case 302: jj_3_303(); break;
			   case 303: jj_3_304(); break;
			   case 304: jj_3_305(); break;
			   case 305: jj_3_306(); break;
			   case 306: jj_3_307(); break;
			   case 307: jj_3_308(); break;
			   case 308: jj_3_309(); break;
			   case 309: jj_3_310(); break;
			   case 310: jj_3_311(); break;
			   case 311: jj_3_312(); break;
			   case 312: jj_3_313(); break;
			   case 313: jj_3_314(); break;
			   case 314: jj_3_315(); break;
			   case 315: jj_3_316(); break;
			   case 316: jj_3_317(); break;
			   case 317: jj_3_318(); break;
			   case 318: jj_3_319(); break;
			   case 319: jj_3_320(); break;
			   case 320: jj_3_321(); break;
			   case 321: jj_3_322(); break;
			   case 322: jj_3_323(); break;
			   case 323: jj_3_324(); break;
			   case 324: jj_3_325(); break;
			   case 325: jj_3_326(); break;
			   case 326: jj_3_327(); break;
			   case 327: jj_3_328(); break;
			   case 328: jj_3_329(); break;
			   case 329: jj_3_330(); break;
			   case 330: jj_3_331(); break;
			   case 331: jj_3_332(); break;
			   case 332: jj_3_333(); break;
			   case 333: jj_3_334(); break;
			   case 334: jj_3_335(); break;
			   case 335: jj_3_336(); break;
			   case 336: jj_3_337(); break;
			   case 337: jj_3_338(); break;
			   case 338: jj_3_339(); break;
			   case 339: jj_3_340(); break;
			   case 340: jj_3_341(); break;
			   case 341: jj_3_342(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
