/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.Offset;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.TableStatement;
import net.sf.jsqlparser.statement.select.Values;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.LimitDeparser;
import net.sf.jsqlparser.util.deparser.OrderByDeParser;

public class TableStatementDeParser
extends AbstractDeParser<TableStatement>
implements SelectVisitor<StringBuilder> {
    private final ExpressionVisitor<StringBuilder> expressionVisitor;

    public TableStatementDeParser(ExpressionVisitor<StringBuilder> expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(TableStatement tableStatement) {
        tableStatement.accept(this, null);
    }

    public void deparse(Offset offset) {
        this.buffer.append(" OFFSET ");
        offset.getOffset().accept(this.expressionVisitor, null);
        if (offset.getOffsetParam() != null) {
            this.buffer.append(" ").append(offset.getOffsetParam());
        }
    }

    @Override
    public <S> StringBuilder visit(ParenthesedSelect parenthesedSelect, S context) {
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(PlainSelect plainSelect, S context) {
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(SetOperationList setOperationList, S context) {
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(WithItem withItem, S context) {
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(Values values, S context) {
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(LateralSubSelect lateralSubSelect, S context) {
        return this.buffer;
    }

    @Override
    public <S> StringBuilder visit(TableStatement tableStatement, S context) {
        this.buffer.append("TABLE ");
        this.buffer.append(tableStatement.getTable());
        if (tableStatement.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(tableStatement.getOrderByElements());
        }
        if (tableStatement.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.buffer).deParse(tableStatement.getLimit());
        }
        if (tableStatement.getOffset() != null) {
            this.deparse(tableStatement.getOffset());
        }
        return this.buffer;
    }
}

