/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.MySQLIndexHint;
import net.sf.jsqlparser.expression.SQLServerHints;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.ExceptOp;
import net.sf.jsqlparser.statement.select.Fetch;
import net.sf.jsqlparser.statement.select.ForMode;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.IntersectOp;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.MinusOp;
import net.sf.jsqlparser.statement.select.Offset;
import net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.Pivot;
import net.sf.jsqlparser.statement.select.PivotVisitor;
import net.sf.jsqlparser.statement.select.PivotXml;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.TableStatement;
import net.sf.jsqlparser.statement.select.UnPivot;
import net.sf.jsqlparser.statement.select.UnionOp;
import net.sf.jsqlparser.statement.select.Values;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.ValidationUtil;
import net.sf.jsqlparser.util.validation.metadata.NamedObject;
import net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import net.sf.jsqlparser.util.validation.validator.ExpressionValidator;
import net.sf.jsqlparser.util.validation.validator.GroupByValidator;
import net.sf.jsqlparser.util.validation.validator.LimitValidator;
import net.sf.jsqlparser.util.validation.validator.TableStatementValidator;
import net.sf.jsqlparser.util.validation.validator.ValuesStatementValidator;

public class SelectValidator
extends AbstractValidator<SelectItem<?>>
implements SelectVisitor<Void>,
SelectItemVisitor<Void>,
FromItemVisitor<Void>,
PivotVisitor<Void> {
    @Override
    public <S> Void visit(PlainSelect plainSelect, S context) {
        if (this.isNotEmpty(plainSelect.getWithItemsList())) {
            plainSelect.getWithItemsList().forEach(withItem -> withItem.accept(this, context));
        }
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.select);
            this.validateFeature(c, plainSelect.getMySqlHintStraightJoin(), Feature.mySqlHintStraightJoin);
            this.validateOptionalFeature(c, plainSelect.getOracleHint(), Feature.oracleHint);
            this.validateOptionalFeature(c, plainSelect.getSkip(), Feature.skip);
            this.validateOptionalFeature(c, plainSelect.getFirst(), Feature.first);
            if (plainSelect.getDistinct() != null) {
                if (plainSelect.getDistinct().isUseUnique()) {
                    this.validateFeature(c, Feature.selectUnique);
                } else {
                    this.validateFeature(c, Feature.distinct);
                }
                this.validateOptionalFeature(c, plainSelect.getDistinct().getOnSelectItems(), Feature.distinctOn);
            }
            this.validateOptionalFeature(c, plainSelect.getTop(), Feature.top);
            this.validateFeature(c, plainSelect.getMySqlSqlCacheFlag() != null, Feature.mysqlSqlCacheFlag);
            this.validateFeature(c, plainSelect.getMySqlSqlCalcFoundRows(), Feature.mysqlCalcFoundRows);
            this.validateOptionalFeature(c, plainSelect.getIntoTables(), Feature.selectInto);
            this.validateOptionalFeature(c, plainSelect.getKsqlWindow(), Feature.kSqlWindow);
            this.validateFeature(c, this.isNotEmpty(plainSelect.getOrderByElements()) && plainSelect.isOracleSiblings(), Feature.oracleOrderBySiblings);
            if (plainSelect.getForMode() != null) {
                this.validateFeature(c, Feature.selectForUpdate);
                this.validateFeature(c, plainSelect.getForMode() == ForMode.KEY_SHARE, Feature.selectForKeyShare);
                this.validateFeature(c, plainSelect.getForMode() == ForMode.NO_KEY_UPDATE, Feature.selectForNoKeyUpdate);
                this.validateFeature(c, plainSelect.getForMode() == ForMode.SHARE, Feature.selectForShare);
                this.validateOptionalFeature(c, plainSelect.getForUpdateTable(), Feature.selectForUpdateOfTable);
                this.validateOptionalFeature(c, plainSelect.getWait(), Feature.selectForUpdateWait);
                this.validateFeature(c, plainSelect.isNoWait(), Feature.selectForUpdateNoWait);
                this.validateFeature(c, plainSelect.isSkipLocked(), Feature.selectForUpdateSkipLocked);
            }
            this.validateOptionalFeature(c, plainSelect.getForXmlPath(), Feature.selectForXmlPath);
            this.validateOptionalFeature(c, plainSelect.getOptimizeFor(), Feature.optimizeFor);
        }
        this.validateOptionalFromItem(plainSelect.getFromItem());
        this.validateOptionalFromItems(plainSelect.getIntoTables());
        this.validateOptionalJoins(plainSelect.getJoins());
        this.validateOptionalExpression(plainSelect.getWhere());
        this.validateOptionalExpression(plainSelect.getOracleHierarchical());
        if (plainSelect.getGroupBy() != null) {
            plainSelect.getGroupBy().accept(this.getValidator(GroupByValidator.class), context);
        }
        this.validateOptionalExpression(plainSelect.getHaving());
        this.validateOptionalOrderByElements(plainSelect.getOrderByElements());
        if (plainSelect.getLimit() != null) {
            this.getValidator(LimitValidator.class).validate(plainSelect.getLimit());
        }
        if (plainSelect.getOffset() != null) {
            this.validateOffset(plainSelect.getOffset());
        }
        if (plainSelect.getFetch() != null) {
            this.validateFetch(plainSelect.getFetch());
        }
        return null;
    }

    @Override
    public <S> Void visit(SelectItem<?> selectExpressionItem, S context) {
        selectExpressionItem.getExpression().accept(this.getValidator(ExpressionValidator.class), context);
        return null;
    }

    @Override
    public <S> Void visit(ParenthesedSelect selectBody, S context) {
        if (this.isNotEmpty(selectBody.getWithItemsList())) {
            selectBody.getWithItemsList().forEach(withItem -> withItem.accept(this, context));
        }
        selectBody.getSelect().accept(this, context);
        this.validateOptional(selectBody.getPivot(), p -> p.accept(this, context));
        return null;
    }

    @Override
    public <S> Void visit(Table table, S context) {
        SQLServerHints sqlServerHints;
        this.validateNameWithAlias(NamedObject.table, table.getFullyQualifiedName(), ValidationUtil.getAlias(table.getAlias()));
        this.validateOptional(table.getPivot(), p -> p.accept(this, context));
        this.validateOptional(table.getUnPivot(), up -> up.accept(this, context));
        MySQLIndexHint indexHint = table.getIndexHint();
        if (indexHint != null && this.isNotEmpty(indexHint.getIndexNames())) {
            indexHint.getIndexNames().forEach(i -> this.validateName(NamedObject.index, (String)i));
        }
        if ((sqlServerHints = table.getSqlServerHints()) != null) {
            this.validateName(NamedObject.index, sqlServerHints.getIndexName());
        }
        return null;
    }

    @Override
    public <S> Void visit(Pivot pivot, S context) {
        this.validateFeature(Feature.pivot);
        this.validateOptionalExpressions(pivot.getForColumns());
        return null;
    }

    @Override
    public <S> Void visit(UnPivot unpivot, S context) {
        this.validateFeature(Feature.unpivot);
        this.validateOptionalExpressions(unpivot.getUnPivotForClause());
        this.validateOptionalExpressions(unpivot.getUnPivotClause());
        return null;
    }

    @Override
    public <S> Void visit(PivotXml pivot, S context) {
        this.validateFeature(Feature.pivotXml);
        this.validateOptionalExpressions(pivot.getForColumns());
        if (this.isNotEmpty(pivot.getFunctionItems())) {
            ExpressionValidator v = this.getValidator(ExpressionValidator.class);
            pivot.getFunctionItems().forEach(f -> ((Function)f.getExpression()).accept(v, context));
        }
        if (pivot.getInSelect() != null) {
            pivot.getInSelect().accept(this, context);
        }
        return null;
    }

    public void validateOffset(Offset offset) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.offset);
            this.validateOptionalFeature(c, offset.getOffsetParam(), Feature.offsetParam);
        }
    }

    public void validateFetch(Fetch fetch) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.fetch);
            this.validateFeature(c, fetch.isFetchParamFirst(), Feature.fetchFirst);
            this.validateFeature(c, !fetch.isFetchParamFirst(), Feature.fetchNext);
        }
        this.validateOptionalExpression(fetch.getFetchJdbcParameter());
    }

    public void validateOptionalJoins(List<Join> joins) {
        if (joins != null) {
            for (Join join : joins) {
                this.validateOptionalJoin(join);
            }
        }
    }

    public void validateOptionalJoin(Join join) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.join);
            this.validateFeature(c, join.isSimple() && join.isOuter(), Feature.joinOuterSimple);
            this.validateFeature(c, join.isSimple(), Feature.joinSimple);
            this.validateFeature(c, join.isRight(), Feature.joinRight);
            this.validateFeature(c, join.isNatural(), Feature.joinNatural);
            this.validateFeature(c, join.isFull(), Feature.joinFull);
            this.validateFeature(c, join.isLeft(), Feature.joinLeft);
            this.validateFeature(c, join.isCross(), Feature.joinCross);
            this.validateFeature(c, join.isOuter(), Feature.joinOuter);
            this.validateFeature(c, join.isInner(), Feature.joinInner);
            this.validateFeature(c, join.isSemi(), Feature.joinSemi);
            this.validateFeature(c, join.isStraight(), Feature.joinStraight);
            this.validateFeature(c, join.isApply(), Feature.joinApply);
            this.validateFeature(c, join.isWindowJoin(), Feature.joinWindow);
            this.validateOptionalFeature(c, join.getUsingColumns(), Feature.joinUsingColumns);
        }
        this.validateOptionalFromItem(join.getFromItem());
        for (Expression onExpression : join.getOnExpressions()) {
            this.validateOptionalExpression(onExpression);
        }
        this.validateOptionalExpressions(join.getUsingColumns());
    }

    @Override
    public <S> Void visit(SetOperationList setOperation, S context) {
        if (this.isNotEmpty(setOperation.getWithItemsList())) {
            setOperation.getWithItemsList().forEach(withItem -> withItem.accept(this, context));
        }
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.setOperation);
            this.validateFeature(c, setOperation.getOperations().stream().anyMatch(o -> o instanceof UnionOp), Feature.setOperationUnion);
            this.validateFeature(c, setOperation.getOperations().stream().anyMatch(o -> o instanceof IntersectOp), Feature.setOperationIntersect);
            this.validateFeature(c, setOperation.getOperations().stream().anyMatch(o -> o instanceof ExceptOp), Feature.setOperationExcept);
            this.validateFeature(c, setOperation.getOperations().stream().anyMatch(o -> o instanceof MinusOp), Feature.setOperationMinus);
        }
        if (this.isNotEmpty(setOperation.getSelects())) {
            setOperation.getSelects().forEach(s -> s.accept(this, context));
        }
        this.validateOptionalOrderByElements(setOperation.getOrderByElements());
        if (setOperation.getLimit() != null) {
            this.getValidator(LimitValidator.class).validate(setOperation.getLimit());
        }
        if (setOperation.getOffset() != null) {
            this.validateOffset(setOperation.getOffset());
        }
        if (setOperation.getFetch() != null) {
            this.validateFetch(setOperation.getFetch());
        }
        return null;
    }

    @Override
    public <S> Void visit(WithItem withItem, S context) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.withItem);
            this.validateFeature(c, withItem.isRecursive(), Feature.withItemRecursive);
        }
        if (this.isNotEmpty(withItem.getWithItemList())) {
            withItem.getWithItemList().forEach(wi -> wi.accept(this, context));
        }
        withItem.getSelect().accept(this, context);
        return null;
    }

    @Override
    public <S> Void visit(LateralSubSelect lateralSubSelect, S context) {
        if (this.isNotEmpty(lateralSubSelect.getWithItemsList())) {
            lateralSubSelect.getWithItemsList().forEach(withItem -> withItem.accept(this, context));
        }
        this.validateFeature(Feature.lateralSubSelect);
        this.validateOptional(lateralSubSelect.getPivot(), p -> p.accept(this, context));
        this.validateOptional(lateralSubSelect.getUnPivot(), up -> up.accept(this, context));
        this.validateOptional(lateralSubSelect.getSelect(), e -> e.accept(this, context));
        return null;
    }

    @Override
    public <S> Void visit(TableStatement tableStatement, S context) {
        this.getValidator(TableStatementValidator.class).validate(tableStatement);
        return null;
    }

    @Override
    public <S> Void visit(TableFunction tableFunction, S context) {
        this.validateFeature(Feature.tableFunction);
        this.validateOptional(tableFunction.getPivot(), p -> p.accept(this, context));
        this.validateOptional(tableFunction.getUnPivot(), up -> up.accept(this, context));
        return null;
    }

    @Override
    public <S> Void visit(ParenthesedFromItem parenthesis, S context) {
        this.validateOptional(parenthesis.getFromItem(), e -> e.accept(this, context));
        return null;
    }

    @Override
    public <S> Void visit(Values values, S context) {
        this.getValidator(ValuesStatementValidator.class).validate(values);
        return null;
    }

    @Override
    public void validate(SelectItem<?> statement) {
        statement.accept(this, null);
    }

    @Override
    public void visit(PlainSelect plainSelect) {
        this.visit(plainSelect, (Object)null);
    }

    @Override
    public void visit(SelectItem<?> selectExpressionItem) {
        this.visit((SelectItem)selectExpressionItem, (Object)null);
    }

    @Override
    public void visit(ParenthesedSelect selectBody) {
        this.visit(selectBody, (Object)null);
    }

    @Override
    public void visit(Table table) {
        this.visit(table, (Object)null);
    }

    @Override
    public void visit(Pivot pivot) {
        this.visit(pivot, (Object)null);
    }

    @Override
    public void visit(UnPivot unpivot) {
        this.visit(unpivot, (Object)null);
    }

    @Override
    public void visit(PivotXml pivot) {
        this.visit(pivot, (Object)null);
    }

    @Override
    public void visit(SetOperationList setOperation) {
        this.visit(setOperation, (Object)null);
    }

    @Override
    public void visit(WithItem withItem) {
        this.visit(withItem, (Object)null);
    }

    @Override
    public void visit(LateralSubSelect lateralSubSelect) {
        this.visit(lateralSubSelect, (Object)null);
    }

    @Override
    public void visit(TableStatement tableStatement) {
        this.visit(tableStatement, (Object)null);
    }

    @Override
    public void visit(TableFunction tableFunction) {
        this.visit(tableFunction, (Object)null);
    }

    @Override
    public void visit(ParenthesedFromItem parenthesis) {
        this.visit(parenthesis, (Object)null);
    }

    @Override
    public void visit(Values values) {
        this.visit(values, (Object)null);
    }
}

