/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import java.util.Collection;
import org.jsfr.json.DispatchUtil;
import org.jsfr.json.JsonDomBuilder;
import org.jsfr.json.JsonPathListener;
import org.jsfr.json.ParsingContext;
import org.jsfr.json.SurfingConfiguration;

class JsonCollector
extends JsonDomBuilder {
    private Collection<JsonPathListener> jsonPathListeners;
    private ParsingContext context;
    private SurfingConfiguration config;

    public JsonCollector(Collection<JsonPathListener> jsonPathListeners, ParsingContext context, SurfingConfiguration config) {
        super(config.getJsonProvider());
        this.jsonPathListeners = jsonPathListeners;
        this.context = context;
        this.config = config;
    }

    @Override
    public boolean endObject() {
        super.endObject();
        if (this.isInRoot()) {
            Object result = this.rootValue();
            DispatchUtil.dispatchValueToListeners(result, this.jsonPathListeners, this.context, this.config.getErrorHandlingStrategy());
            this.clear();
            return false;
        }
        return true;
    }

    @Override
    public boolean endArray() {
        super.endArray();
        if (this.isInRoot()) {
            Object result = this.rootValue();
            DispatchUtil.dispatchValueToListeners(result, this.jsonPathListeners, this.context, this.config.getErrorHandlingStrategy());
            this.clear();
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.context = null;
        this.jsonPathListeners = null;
        this.config = null;
    }
}

