/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.zipkin;

import com.github.kristofa.brave.internal.Util;
import com.github.kristofa.brave.zipkin.ThriftClientProvider;
import com.twitter.zipkin.gen.scribe;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

class ZipkinCollectorClientProvider
implements ThriftClientProvider<scribe.Client> {
    private static final Logger LOGGER = Logger.getLogger(ZipkinCollectorClientProvider.class.getName());
    private final String host;
    private final int port;
    private final int timeout;
    private TTransport transport;
    private scribe.Client client;

    public ZipkinCollectorClientProvider(String host, int port, int timeout) {
        this.host = Util.checkNotBlank((String)host, (String)"Null or empty host", (Object[])new Object[0]);
        this.port = port;
        this.timeout = timeout;
    }

    @Override
    public void setup() throws TException {
        TSocket socket = new TSocket(this.host, this.port);
        socket.setTimeout(this.timeout);
        this.transport = new TFramedTransport((TTransport)socket);
        TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
        this.client = new scribe.Client((TProtocol)protocol);
        this.transport.open();
    }

    @Override
    public scribe.Client getClient() {
        return this.client;
    }

    @Override
    public scribe.Client exception(TException exception) {
        if (exception instanceof TTransportException) {
            LOGGER.log(Level.FINE, "TransportException detected, closing current connection and opening new one", exception);
            this.close();
            try {
                this.setup();
            }
            catch (TException e) {
                LOGGER.log(Level.WARNING, "Trying to reconnect to Thrift server failed.", e);
                return null;
            }
            return this.client;
        }
        LOGGER.log(Level.WARNING, "Thrift exception.", exception);
        return null;
    }

    @Override
    public void close() {
        if (this.transport != null) {
            this.transport.close();
        }
    }
}

