/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.bootstrap;

import com.github.ldeitos.exception.InvalidConfigurationException;
import com.github.ldeitos.validation.impl.configuration.ConfigInfoProvider;
import com.github.ldeitos.validation.impl.configuration.Configuration;
import java.lang.annotation.Annotation;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedValidationBootstrap
implements Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedValidationBootstrap.class);

    public void startup(@Observes AfterDeploymentValidation event, BeanManager bm) {
        if (Configuration.isUnloaded()) {
            ConfigInfoProvider cp = (ConfigInfoProvider)CDI.current().select(ConfigInfoProvider.class, new Annotation[0]).get();
            try {
                LOGGER.info("Loading ExtendedValidation configurations.");
                Configuration.load(cp);
                LOGGER.info("ExtendedValidation configurations sucefully loaded.");
            }
            catch (InvalidConfigurationException e) {
                LOGGER.error("Error loading configuration. Audit process will not work.", (Throwable)e);
            }
        }
    }
}

