/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validation.impl;

import com.github.ldeitos.validation.ConstraintSeverity;
import com.github.ldeitos.validation.Message;
import com.github.ldeitos.validation.Severity;
import java.lang.annotation.Annotation;
import javax.validation.ConstraintViolation;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class MessageImpl
implements Message {
    private static final long serialVersionUID = 1L;
    private Severity severity;
    private String message;
    private ConstraintViolation<?> originConstraint;

    MessageImpl(ConstraintViolation<?> originConstraint) {
        this(originConstraint.getMessage(), MessageImpl.getSeverity(originConstraint.getConstraintDescriptor()));
        this.originConstraint = originConstraint;
    }

    MessageImpl(String message, Severity severity) {
        this.message = message;
        this.severity = severity;
    }

    private static <T extends Annotation> Severity getSeverity(ConstraintDescriptor<T> descriptor) {
        Severity severity = Severity.ERROR;
        for (Class payload : descriptor.getPayload()) {
            if (!ConstraintSeverity.class.isAssignableFrom(payload)) continue;
            severity = Severity.fromConstraintSeverity((Class)payload);
            break;
        }
        return severity;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public ConstraintViolation<?> getOriginConstraint() {
        return this.originConstraint;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

