/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validation.impl;

import com.github.ldeitos.validation.Message;
import com.github.ldeitos.validation.MessageResolver;
import com.github.ldeitos.validation.Severity;
import com.github.ldeitos.validation.impl.MessageImpl;
import com.github.ldeitos.validation.impl.interpolator.PreInterpolator;
import com.github.ldeitos.validation.impl.util.PresentationMessageFormatter;
import javax.inject.Inject;

public class MessageResolverImpl
implements MessageResolver {
    @Inject
    private PreInterpolator interpolator;

    public Message getMessage(Severity severity, String template, String ... parameters) {
        String msg = PresentationMessageFormatter.format(template, this.interpolator.interpolate(template, parameters));
        return new MessageImpl(msg, severity);
    }

    public Message getInfo(String template, String ... parameters) {
        return this.getMessage(Severity.INFO, template, parameters);
    }

    public Message getWarn(String template, String ... parameters) {
        return this.getMessage(Severity.WARN, template, parameters);
    }

    public Message getAlert(String template, String ... parameters) {
        return this.getMessage(Severity.ALERT, template, parameters);
    }

    public Message getError(String template, String ... parameters) {
        return this.getMessage(Severity.ERROR, template, parameters);
    }

    public Message getFatal(String template, String ... parameters) {
        return this.getMessage(Severity.FATAL, template, parameters);
    }
}

