/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validation.impl;

import com.github.ldeitos.exception.ViolationException;
import com.github.ldeitos.qualifier.ExtendedValidator;
import com.github.ldeitos.validation.Message;
import com.github.ldeitos.validation.Validator;
import com.github.ldeitos.validation.impl.MessageImpl;
import java.security.InvalidParameterException;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import javax.validation.metadata.BeanDescriptor;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections4.CollectionUtils;

@ExtendedValidator
public class ValidatorImpl
implements Validator {
    private static final Transformer<ConstraintViolation<?>, Message> toMessage = new Transformer<ConstraintViolation<?>, Message>(){

        public Message transform(ConstraintViolation<?> arg0) {
            return new MessageImpl(arg0);
        }
    };
    private ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
    private javax.validation.Validator delegate = this.factory.getValidator();

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        return this.delegate.validate(object, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        return this.delegate.validateProperty(object, propertyName, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        return this.delegate.validateValue(beanType, propertyName, value, (Class[])groups);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.delegate.getConstraintsForClass(clazz);
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(Validator.class)) {
            return type.cast(this);
        }
        throw new InvalidParameterException(String.format("Impossible to get %s instance.", type.getName()));
    }

    public ExecutableValidator forExecutables() {
        return this.delegate.forExecutables();
    }

    public <T> Set<Message> validateBean(T object, Class<?> ... groups) {
        Set<ConstraintViolation<T>> constraints = this.validate(object, groups);
        return new HashSet<Message>(org.apache.commons.collections15.CollectionUtils.collect(constraints, toMessage));
    }

    public <T> Set<Message> validatePropertyBean(T object, String propertyName, Class<?> ... groups) {
        Set<ConstraintViolation<T>> constraints = this.validateProperty(object, propertyName, groups);
        return new HashSet<Message>(org.apache.commons.collections15.CollectionUtils.collect(constraints, toMessage));
    }

    public <T> Set<Message> validateValueBean(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        Set<ConstraintViolation<T>> constraints = this.validateValue(beanType, propertyName, value, groups);
        return new HashSet<Message>(org.apache.commons.collections15.CollectionUtils.collect(constraints, toMessage));
    }

    public <T> void validateAndThrow(T object, Class<?> ... groups) throws ViolationException {
        Set<Message> violations = this.validateBean(object, groups);
        if (CollectionUtils.isNotEmpty(violations)) {
            ViolationException.throwNew((String)String.format("Validated object [%s] has violations.", object), violations);
        }
    }
}

