/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validation.impl.configuration;

import com.github.ldeitos.exception.InvalidConfigurationException;
import com.github.ldeitos.validation.MessagesSource;
import com.github.ldeitos.validation.ValidationClosure;
import com.github.ldeitos.validation.impl.configuration.ConfigInfoProvider;
import com.github.ldeitos.validation.impl.configuration.ConfigurationLoader;
import com.github.ldeitos.validation.impl.configuration.dto.ConfigurationDTO;
import com.github.ldeitos.validation.impl.configuration.dto.MessageFileDTO;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.inject.spi.CDI;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    public static final Pattern PRESENTATION_MESSAGE = Pattern.compile("\\$M");
    public static final Pattern PRESENTATION_TEMPLATE = Pattern.compile("\\$T");
    private static Configuration instance;
    private Logger log = LoggerFactory.getLogger(Configuration.class);
    private ConfigurationDTO configuration;
    private MessagesSource messagesSource;
    private ValidationClosure validationClosure;

    private Configuration(ConfigInfoProvider configProvider) {
        this.configuration = ConfigurationLoader.loadConfiguration(configProvider);
    }

    public static Configuration getConfiguration(ConfigInfoProvider configProvider) {
        if (Configuration.isUnloaded() || configProvider.isInTest()) {
            instance = new Configuration(configProvider);
            if (!configProvider.isInTest()) {
                Configuration.init(instance);
            }
        }
        return instance;
    }

    private static void init(Configuration instance) {
        instance.getConfiguredMessagesSource();
        instance.getConfiguredValidationClosure();
    }

    public Collection<String> getConfituredMessageFiles() {
        ArrayList<String> messageFiles = new ArrayList<String>(this.getMessageFilesFromXML());
        messageFiles.addAll(this.getMessageFilesFromEnvironmentProperty());
        return Collections.unmodifiableList(messageFiles);
    }

    private Collection<String> getMessageFilesFromEnvironmentProperty() {
        Transformer<String, String> toTrimString = new Transformer<String, String>(){

            public String transform(String arg0) {
                return arg0.trim();
            }
        };
        String configuredFiles = System.getProperty("com.github.ldeitos.validation.message.files");
        ArrayList<String> fileNames = new ArrayList<String>();
        if (configuredFiles != null) {
            fileNames.addAll(org.apache.commons.collections15.CollectionUtils.collect(Arrays.asList(configuredFiles.split(",")), (Transformer)toTrimString));
        }
        this.logTraceConfiguredFileNames(fileNames, "by system propertie");
        return fileNames;
    }

    private Collection<String> getMessageFilesFromXML() {
        Transformer<MessageFileDTO, String> toFileName = new Transformer<MessageFileDTO, String>(){

            public String transform(MessageFileDTO arg0) {
                return arg0.toString();
            }
        };
        Collection fileNames = org.apache.commons.collections15.CollectionUtils.collect(this.configuration.getMessageFiles(), (Transformer)toFileName);
        this.logTraceConfiguredFileNames(fileNames, "by validation.xml file");
        return fileNames;
    }

    private void logTraceConfiguredFileNames(Collection<String> fileNames, String string) {
        if (CollectionUtils.isNotEmpty(fileNames) && this.log.isTraceEnabled()) {
            final StringBuilder sbLog = new StringBuilder("Files configured ");
            sbLog.append(string).append(": [");
            Closure<String> buildLogMsg = new Closure<String>(){

                public void execute(String arg0) {
                    sbLog.append(arg0).append(", ");
                }
            };
            CollectionUtils.forAllDo(fileNames, (Closure)buildLogMsg);
            int start = sbLog.lastIndexOf(",");
            int end = sbLog.lastIndexOf(" ");
            sbLog.replace(start, end, "]");
            this.log.trace(sbLog.toString());
        }
    }

    public ValidationClosure getConfiguredValidationClosure() {
        if (this.validationClosure == null) {
            Class<?> beanType = null;
            String closureClassName = this.configuration.getValidationClosure();
            try {
                this.log.debug(String.format("Getting default ValidationSource instance from class %s.", closureClassName));
                beanType = Class.forName(closureClassName);
            }
            catch (ClassNotFoundException e) {
                this.log.error(String.format("Class %s not found in class path.", closureClassName), (Throwable)e);
                InvalidConfigurationException.throwNew((String)e.getMessage(), (Throwable)e);
            }
            this.validationClosure = (ValidationClosure)this.resolveBean(beanType);
        }
        return this.validationClosure;
    }

    public MessagesSource getConfiguredMessagesSource() {
        if (this.messagesSource == null) {
            Class<?> beanType = null;
            String messageSourceClassName = this.configuration.getMessageSource();
            try {
                this.log.debug(String.format("Getting MessagesSource instance from class %s.", messageSourceClassName));
                beanType = Class.forName(messageSourceClassName);
            }
            catch (ClassNotFoundException e) {
                this.log.error(String.format("Class %s not found in class path.", messageSourceClassName), (Throwable)e);
                InvalidConfigurationException.throwNew((String)e.getMessage(), (Throwable)e);
            }
            this.messagesSource = (MessagesSource)this.resolveBean(beanType);
            this.log.info(String.format("Using [%s] as message source.", beanType.getCanonicalName()));
        }
        return this.messagesSource;
    }

    public String getMessagePresentationTemplate() {
        return this.configuration.getMessagePresentationTemplate();
    }

    public boolean showTemplate() {
        Matcher matcher = PRESENTATION_TEMPLATE.matcher(this.getMessagePresentationTemplate());
        return matcher.find();
    }

    public boolean showMessage() {
        Matcher matcher = PRESENTATION_MESSAGE.matcher(this.getMessagePresentationTemplate());
        return matcher.find();
    }

    private <T> T resolveBean(Class<? extends T> beanType) {
        T bean = null;
        try {
            bean = this.getByCDIContext(beanType);
            if (bean != null) {
                this.log.debug(String.format("Reference from [%s] obtained by CDI Context.", beanType.getCanonicalName()));
            } else {
                this.log.debug(String.format("Unable to get [%s] reference by CDI Context.", beanType.getCanonicalName()));
                bean = this.getByReflection(beanType);
            }
        }
        catch (Exception e) {
            String warnMsg = String.format("Error to obtain [%s] reference by CDI Context. Cause: %s.", beanType.getCanonicalName(), e.getMessage());
            this.log.warn(warnMsg);
            bean = this.getByReflection(beanType);
        }
        return bean;
    }

    private <T> T getByReflection(Class<? extends T> beanType) {
        Object bean = null;
        String msgError = String.format("Error to obtain %s instance from [%s] by reflection.", beanType.getInterfaces()[0].getSimpleName(), beanType.getCanonicalName());
        try {
            this.log.warn("Trying by reflection...");
            bean = ConstructorUtils.invokeConstructor(beanType, (Object[])new Object[0]);
            this.log.debug(String.format("Reference from [%s] obtained by reflection.", beanType.getCanonicalName()));
        }
        catch (NoSuchMethodException e) {
            this.log.error(msgError, (Throwable)e);
            InvalidConfigurationException.throwNew((String)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.log.error(msgError, (Throwable)e);
            InvalidConfigurationException.throwNew((String)e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.log.error(msgError, (Throwable)e);
            InvalidConfigurationException.throwNew((String)e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            this.log.error(msgError, (Throwable)e);
            InvalidConfigurationException.throwNew((String)e.getMessage(), (Throwable)e);
        }
        return (T)bean;
    }

    private <T> T getByCDIContext(Class<? extends T> type) {
        return (T)CDI.current().select(type, new Annotation[0]).get();
    }

    public static void load(ConfigInfoProvider cp) throws InvalidConfigurationException {
        if (Configuration.isUnloaded() || cp.isInTest()) {
            instance = new Configuration(cp);
        }
    }

    public static boolean isLoaded() {
        return !Configuration.isUnloaded();
    }

    public static boolean isUnloaded() {
        return instance == null;
    }
}

