/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validation.impl.configuration;

import com.github.ldeitos.validation.impl.configuration.ConfigInfoProvider;
import com.github.ldeitos.validation.impl.configuration.dto.ConfigurationDTO;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurationLoader {
    private static ConfigurationDTO configuration;
    private static Logger log;

    ConfigurationLoader() {
    }

    static ConfigurationDTO loadConfiguration(ConfigInfoProvider configProvider) {
        if (configuration == null || configProvider.isInTest()) {
            ConfigurationLoader.load(configProvider);
        }
        return configuration;
    }

    private static void load(ConfigInfoProvider configProvider) {
        String configFileName = configProvider.getConfigFileName();
        try {
            log.info(String.format("Loading configuration by %s files in class path.", configFileName));
            DefaultConfigurationBuilder confBuilder = new DefaultConfigurationBuilder(configFileName);
            confBuilder.load();
            ConfigurationLoader.loadFromXMLFiles(confBuilder);
        }
        catch (ConfigurationException e) {
            log.warn(String.format("Error on obtain %s files in class path: [%s]", configFileName, e.getMessage()));
            log.warn("Loading by default configuration...");
        }
        if (configuration == null) {
            ConfigurationLoader.loadDefaultConfiguration();
        }
        ConfigurationLoader.traceConfiguration(configuration);
    }

    private static void loadFromXMLFiles(DefaultConfigurationBuilder confBuilder) {
        if (!confBuilder.isEmpty()) {
            String config;
            configuration = new ConfigurationDTO();
            if (confBuilder.containsKey("validation-closure")) {
                config = confBuilder.getString("validation-closure");
                log.debug(String.format("Configured ValidationClosure: [%s]", config));
                configuration.setValidationClosure(config);
            }
            if (confBuilder.containsKey("message-source")) {
                config = confBuilder.getString("message-source");
                log.debug(String.format("Configured MessagesSource: [%s]", config));
                configuration.setMessageSource(config);
            }
            if (confBuilder.containsKey("template-message-presentation")) {
                config = confBuilder.getString("template-message-presentation");
                ConfigurationLoader.verifyTemplateMessagePresentation(config);
                log.debug(String.format("Message presentation template: [%s]", config));
                configuration.setMessagePresentationTemplate(config);
            }
            for (HierarchicalConfiguration nextConf : confBuilder.configurationsAt("message-files")) {
                for (HierarchicalConfiguration nextFile : nextConf.configurationsAt("message-file")) {
                    config = nextFile.getRoot().getValue().toString();
                    log.debug(String.format("Adding configured message file: [%s]", config));
                    configuration.addMessageFile(config);
                }
            }
        }
    }

    private static void verifyTemplateMessagePresentation(String input) {
        Matcher matcher = Pattern.compile("\\$M").matcher(input);
        if (!matcher.find()) {
            log.warn(String.format("Message presentation template does not shows the message text, try add %s to pattern.", "\\$M"));
        }
    }

    private static void loadDefaultConfiguration() {
        if (configuration == null) {
            configuration = ConfigurationLoader.getDefaultConfiguration();
        }
    }

    private static ConfigurationDTO getDefaultConfiguration() {
        ConfigurationDTO configuration = new ConfigurationDTO();
        configuration.setMessageSource("com.github.ldeitos.validation.impl.interpolator.MultipleBundlesSource");
        log.info("Default configuration loaded.");
        return configuration;
    }

    private static void traceConfiguration(ConfigurationDTO configuration) {
        if (log.isTraceEnabled()) {
            log.trace(String.format("Configuration content: [%s]", configuration));
        }
    }

    static {
        log = LoggerFactory.getLogger(ConfigurationLoader.class);
    }
}

