/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validation.impl.configuration.dto;

import com.github.ldeitos.exception.InvalidConfigurationException;
import com.github.ldeitos.validation.impl.configuration.dto.MessageFileDTO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ConfigurationDTO {
    private String messageSource = "com.github.ldeitos.validation.impl.interpolator.MultipleBundlesSource";
    private String validationClosure = "com.github.ldeitos.validation.impl.util.DefaultValidationClosure";
    private String messagePesentationTemplate = "$M";
    private List<MessageFileDTO> messageFiles = new ArrayList<MessageFileDTO>();

    public String getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(String messageSource) {
        this.messageSource = messageSource;
    }

    public String getValidationClosure() {
        return this.validationClosure;
    }

    public void setMessagePresentationTemplate(String templateMessagePresentation) {
        this.messagePesentationTemplate = templateMessagePresentation;
    }

    public String getMessagePresentationTemplate() {
        return this.messagePesentationTemplate;
    }

    public void setValidationClosure(String validationClosure) {
        this.validationClosure = validationClosure;
    }

    public List<MessageFileDTO> getMessageFiles() {
        return this.messageFiles;
    }

    public void merge(ConfigurationDTO toMerge) {
        if (toMerge == this) {
            return;
        }
        this.assertUniqueMessageSourceName(toMerge);
        this.mergeMessageSource(toMerge);
        this.mergeMessageFiles(toMerge);
    }

    private void mergeMessageSource(ConfigurationDTO toMerge) {
        if (this.getMessageSource() == null) {
            this.messageSource = toMerge.getMessageSource();
        }
    }

    private void mergeMessageFiles(ConfigurationDTO toMerge) {
        HashSet<MessageFileDTO> currentContent = new HashSet<MessageFileDTO>(this.messageFiles);
        currentContent.addAll(toMerge.getMessageFiles());
        this.messageFiles.clear();
        this.messageFiles.addAll(currentContent);
    }

    private void assertUniqueMessageSourceName(ConfigurationDTO toMerge) {
        boolean invalido = this.getMessageSource() != null && toMerge.getMessageFiles() != null;
        if (invalido &= !StringUtils.equals((String)this.messageSource, (String)toMerge.getMessageSource())) {
            InvalidConfigurationException.throwNew((String)"Multiple configuration files in application class path containing different MessagesSource references.");
        }
    }

    public void addMessageFile(String fileName) {
        this.getMessageFiles().add(new MessageFileDTO(fileName));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

