/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validation.impl.factory;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.CDI;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CdiLookupConstraintValidationFactory
implements ConstraintValidatorFactory {
    private Logger log = LoggerFactory.getLogger(CdiLookupConstraintValidationFactory.class);
    private ConstraintValidatorFactory delegate = Validation.byDefaultProvider().configure().getDefaultConstraintValidatorFactory();

    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
        ConstraintValidator constraintValidator = null;
        this.log.trace(String.format("Getting reference to validator [%s].", key.getName()));
        try {
            constraintValidator = (ConstraintValidator)CDI.current().select(key, new Annotation[0]).get();
            if (constraintValidator == null) {
                this.log.debug(String.format("Unable to get reference to validator [%s] by CDI.", key.getName()));
                this.log.debug("Trying by default ConstraintValidatorFactory.");
                constraintValidator = this.delegate.getInstance(key);
            }
        }
        catch (Exception e) {
            this.log.debug(String.format("Error trying get reference to validator [%s] by CDI.", key.getName()));
            this.log.debug("Trying by default ConstraintValidatorFactory.");
            constraintValidator = this.delegate.getInstance(key);
        }
        return (T)constraintValidator;
    }

    public void releaseInstance(ConstraintValidator<?, ?> instance) {
        this.delegate.releaseInstance(instance);
    }
}

