/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validation.impl.interceptor;

import com.github.ldeitos.qualifier.Closure;
import com.github.ldeitos.qualifier.ExtendedValidator;
import com.github.ldeitos.validation.Message;
import com.github.ldeitos.validation.ValidationClosure;
import com.github.ldeitos.validation.Validator;
import com.github.ldeitos.validation.annotation.SkipValidation;
import com.github.ldeitos.validation.annotation.ValidateParameters;
import com.github.ldeitos.validation.impl.configuration.ConfigInfoProvider;
import com.github.ldeitos.validation.impl.configuration.Configuration;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ValidateParameters
@Any
@Interceptor
public class ValidateParametersInterceptor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    @ExtendedValidator
    private Validator validator;
    @Inject
    private ConfigInfoProvider configProvider;

    @AroundInvoke
    public Object doAudit(InvocationContext invCtx) throws Exception {
        Set<Message> violations = this.doValidation(invCtx);
        if (CollectionUtils.isNotEmpty(violations)) {
            ValidationClosure closure = this.getClosure(invCtx);
            closure.proceed(violations);
            this.logger.info("Validation process successfuly completed.");
        }
        return invCtx.proceed();
    }

    private Set<Message> doValidation(InvocationContext invCtx) {
        Object[] toValidate;
        Method invokedMethod = invCtx.getMethod();
        this.logger.info(String.format("Init method [%s] parameters validation process.", invokedMethod.getName()));
        HashSet<Message> violations = new HashSet<Message>();
        HashSet objectViolations = new HashSet();
        Annotation[][] parameterAnnotations = invokedMethod.getParameterAnnotations();
        for (Object object : toValidate = this.getParametersToValidate(invCtx.getParameters(), parameterAnnotations)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Doing parameter [%s] validation. Parameter class: [%s]", String.valueOf(object), object.getClass().getSimpleName()));
            }
            objectViolations.addAll(this.validator.validateBean(object, (Class[])this.getValidationGroups(invCtx)));
            violations.addAll(objectViolations);
            if (!CollectionUtils.isNotEmpty(objectViolations)) continue;
            this.logger.debug("Violations found during validation process.");
            objectViolations.clear();
        }
        return violations;
    }

    private Class<?>[] getValidationGroups(InvocationContext invCtx) {
        ValidateParameters conf = this.getInterceptorConfiguration(invCtx);
        return conf.groups();
    }

    private ValidateParameters getInterceptorConfiguration(InvocationContext invCtx) {
        ValidateParameters conf = invCtx.getMethod().getAnnotation(ValidateParameters.class);
        if (conf == null) {
            Class<?> invokedTarget = invCtx.getTarget().getClass();
            conf = invokedTarget.getAnnotation(ValidateParameters.class);
        }
        return conf;
    }

    private Object[] getParametersToValidate(Object[] parameters, Annotation[][] parameterAnnotations) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations;
            SkipValidation skipped;
            Object parameter = parameters[i];
            if (!this.assertNotNull(parameter)) continue;
            if (this.logger.isDebugEnabled()) {
                String log = String.format("Processing parameter [%s], parameter index [%d].", String.valueOf(parameter), i);
                this.logger.debug(log);
            }
            if ((skipped = this.getAnnotation(annotations = parameterAnnotations[i], SkipValidation.class)) != null) continue;
            this.logger.debug(String.format("Parameter [%s] added to validation process.", String.valueOf(parameter)));
            result.add(parameter);
        }
        this.logParamtersToValidate(result);
        return result.toArray();
    }

    private boolean assertNotNull(Object parameter) {
        boolean notNull;
        boolean bl = notNull = parameter != null;
        if (!notNull && this.logger.isDebugEnabled()) {
            this.logger.debug("Parameter value is null, skipping.");
        }
        return notNull;
    }

    private void logParamtersToValidate(List<Object> toValidate) {
        if (CollectionUtils.isEmpty(toValidate)) {
            this.logger.warn("Has no parameters to be validated.");
        } else {
            this.logger.debug(String.format("Found %d paramters to validate.", toValidate.size()));
        }
    }

    private ValidationClosure getClosure(InvocationContext invCtx) {
        ValidationClosure closure = Configuration.getConfiguration(this.configProvider).getConfiguredValidationClosure();
        ValidateParameters conf = this.getInterceptorConfiguration(invCtx);
        if (this.mustUseSpecificClosure(conf.closure())) {
            closure = (ValidationClosure)CDI.current().select(ValidationClosure.class, new Annotation[]{conf.closure()}).get();
        }
        return closure;
    }

    private boolean mustUseSpecificClosure(Closure qualifier) {
        String stringQualifier = qualifier.value();
        return !stringQualifier.equals("extededValidation.default.closure");
    }

    private <T> T getAnnotation(Annotation[] annotations, Class<T> annotationClass) {
        for (Annotation annotation : annotations) {
            if (!annotationClass.isAssignableFrom(annotation.getClass())) continue;
            this.logger.debug("Parameter identified with @SkipValidation annotation, will be ignored.");
            return (T)annotation;
        }
        return null;
    }
}

