/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validation.impl.interpolator;

import com.github.ldeitos.validation.MessagesSource;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractMessagesSource
implements MessagesSource {
    protected static final Pattern PATTERN_BUNDLE_KEY = Pattern.compile("^(\\{|\\[)(.*)(\\}|\\])$");
    protected static int BUNDLE_KEY_GROUP = 2;

    public String getMessage(String key) {
        return this.getMessage(key, null);
    }

    public String getMessage(String key, Locale locale) {
        String msg = new String(key);
        Matcher matcher = this.getMatcher(key);
        if (matcher.matches()) {
            msg = this.getInSource(msg, matcher.group(BUNDLE_KEY_GROUP), locale);
        }
        return msg;
    }

    protected Matcher getMatcher(String msg) {
        return PATTERN_BUNDLE_KEY.matcher(msg);
    }

    protected abstract String getInSource(String var1, String var2, Locale var3);
}

