/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validation.impl.interpolator;

import com.github.ldeitos.validation.Validator;
import com.github.ldeitos.validation.impl.util.ParameterUtils;
import java.lang.annotation.Annotation;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintTarget;
import javax.validation.ConstraintValidator;
import javax.validation.MessageInterpolator;
import javax.validation.Payload;
import javax.validation.metadata.ConstraintDescriptor;

class ExtendedParameterContext
implements MessageInterpolator.Context {
    private final MessageInterpolator.Context decorated;

    public ExtendedParameterContext(MessageInterpolator.Context contexto) {
        this.decorated = contexto;
    }

    public ConstraintDescriptor<?> getConstraintDescriptor() {
        return new ExtendedConstraintDescriptor(this.decorated.getConstraintDescriptor());
    }

    public Object getValidatedValue() {
        return this.decorated.getValidatedValue();
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(Validator.class)) {
            return type.cast(this);
        }
        throw new InvalidParameterException(String.format("Impossible to get %s instance.", type.getName()));
    }

    private static class ExtendedConstraintDescriptor<T extends Annotation>
    implements ConstraintDescriptor<T> {
        private final ConstraintDescriptor<T> decorated;
        private Map<String, Object> attributes;

        ExtendedConstraintDescriptor(ConstraintDescriptor<T> descriptor) {
            this.decorated = descriptor;
        }

        public T getAnnotation() {
            return (T)this.decorated.getAnnotation();
        }

        public String getMessageTemplate() {
            return this.decorated.getMessageTemplate();
        }

        public Set<Class<?>> getGroups() {
            return this.decorated.getGroups();
        }

        public Set<Class<? extends Payload>> getPayload() {
            return this.decorated.getPayload();
        }

        public ConstraintTarget getValidationAppliesTo() {
            return this.decorated.getValidationAppliesTo();
        }

        public List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorClasses() {
            return this.decorated.getConstraintValidatorClasses();
        }

        public Map<String, Object> getAttributes() {
            if (this.attributes == null) {
                this.attributes = this.buildExtendedParametersAttributes();
            }
            return this.attributes;
        }

        private Map<String, Object> buildExtendedParametersAttributes() {
            HashMap<String, Object> atributes = new HashMap<String, Object>(this.decorated.getAttributes());
            String[] parameters = this.getDeclaredParameters(atributes);
            atributes.putAll(ParameterUtils.buildParametersMap(parameters));
            return Collections.unmodifiableMap(atributes);
        }

        private String[] getDeclaredParameters(Map<String, Object> atributes) {
            String[] declaredParameters = new String[]{};
            if (atributes.containsKey("messageParameters")) {
                declaredParameters = (String[])atributes.get("messageParameters");
            }
            return declaredParameters;
        }

        public Set<ConstraintDescriptor<?>> getComposingConstraints() {
            return this.decorated.getComposingConstraints();
        }

        public boolean isReportAsSingleViolation() {
            return this.decorated.isReportAsSingleViolation();
        }
    }
}

