/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validation.impl.interpolator;

import com.github.ldeitos.validation.impl.configuration.ConfigInfoProvider;
import com.github.ldeitos.validation.impl.configuration.Configuration;
import com.github.ldeitos.validation.impl.interpolator.AbstractMessagesSource;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.enterprise.inject.spi.CDI;

public class MultipleBundlesSource
extends AbstractMessagesSource {
    private Set<String> bundleFiles = new HashSet<String>(Arrays.asList("ValidationMessages"));
    private Map<String, ResourceBundle> cache = new HashMap<String, ResourceBundle>();

    public MultipleBundlesSource() {
        ConfigInfoProvider configProvider = (ConfigInfoProvider)CDI.current().select(ConfigInfoProvider.class, new Annotation[0]).get();
        this.bundleFiles.addAll(Configuration.getConfiguration(configProvider).getConfituredMessageFiles());
    }

    @Override
    protected String getInSource(String original, String key, Locale locale) {
        String msg = new String(original);
        for (String fileName : this.bundleFiles) {
            ResourceBundle resource = this.getBundle(fileName, locale);
            if (resource == null || !resource.containsKey(key)) continue;
            msg = resource.getString(key);
            break;
        }
        return msg;
    }

    private ResourceBundle getBundle(String fileName, Locale locale) {
        ResourceBundle resource;
        String cacheKey = this.parseCacheKey(fileName, locale);
        if (this.cache.containsKey(cacheKey)) {
            resource = this.cache.get(cacheKey);
        } else {
            try {
                resource = locale == null ? ResourceBundle.getBundle(fileName) : ResourceBundle.getBundle(fileName, locale);
                this.cache.put(cacheKey, resource);
            }
            catch (MissingResourceException ex) {
                resource = null;
            }
        }
        return resource;
    }

    private String parseCacheKey(String fileName, Locale locale) {
        StringBuilder sb = new StringBuilder(fileName);
        if (locale != null) {
            sb.append("-").append(locale.getDisplayName());
        }
        return sb.toString();
    }
}

