/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validation.impl.interpolator;

import com.github.ldeitos.validation.impl.interpolator.BaseInterpolator;
import com.github.ldeitos.validation.impl.util.ParameterUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreInterpolator
extends BaseInterpolator {
    private static final Pattern PARAM_PATTERN = Pattern.compile("(\\{|\\[)(.*)(\\}|\\])");
    private Logger log = LoggerFactory.getLogger(PreInterpolator.class);

    public String interpolate(String msg, String ... parameters) {
        this.log.debug(String.format("Message template: [%s]", msg));
        String resolvedMsg = this.getMessageSource().getMessage(msg);
        resolvedMsg = this.doInterpolation(resolvedMsg, parameters);
        return resolvedMsg;
    }

    private String doInterpolation(String msg, String ... parameters) {
        String toInterpolate = new String(msg);
        Map<String, Object> paramsMap = this.addParamMarkOnMapKeys(ParameterUtils.buildParametersMap(parameters));
        Matcher paramPatternMatcher = PARAM_PATTERN.matcher(msg);
        this.log.debug(String.format("Message to interpolate: [%s]", toInterpolate));
        if (paramPatternMatcher.find()) {
            for (Map.Entry<String, Object> entry : paramsMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                Matcher paramMatcher = Pattern.compile(key).matcher(toInterpolate);
                if (!paramMatcher.find()) continue;
                this.logTrace(key, value);
                toInterpolate = paramMatcher.replaceAll(Matcher.quoteReplacement(String.valueOf(value)));
            }
        }
        this.log.debug(String.format("Message after interpolation: [%s]", toInterpolate));
        return toInterpolate;
    }

    private Map<String, Object> addParamMarkOnMapKeys(Map<String, Object> map) {
        HashMap<String, Object> retorno = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Matcher paramPatternMatcher = PARAM_PATTERN.matcher(key);
            this.log.trace(String.format("Parameter: key=[%s], value=[%s]", key, value));
            if (!paramPatternMatcher.matches()) {
                key = "\\{" + key + "\\}";
            }
            retorno.put(key, value);
        }
        return retorno;
    }

    private void logTrace(String key, Object value) {
        Matcher matcher;
        if (this.log.isTraceEnabled() && (matcher = PARAM_PATTERN.matcher(key)).matches()) {
            this.log.trace(String.format("Parameter [%s] resolved to [%s]", matcher.group(2), String.valueOf(value)));
        }
    }
}

