/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validators;

import com.github.ldeitos.validation.impl.interpolator.PreInterpolator;
import com.github.ldeitos.validation.impl.util.PresentationMessageFormatter;
import com.github.ldeitos.validators.util.ConstraintBuilderAdapter;
import com.github.ldeitos.validators.util.NodeBuilderCustomizableContextAdapter;
import com.github.ldeitos.validators.util.Path;
import com.github.ldeitos.validators.util.PathBuilder;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExtendedValidator<A extends Annotation, T>
implements ConstraintValidator<A, T> {
    private Logger log = LoggerFactory.getLogger(AbstractExtendedValidator.class);
    private ThreadLocal<Boolean> validMap = new ThreadLocal();
    private ThreadLocal<ConstraintValidatorContext> contextMap = new ThreadLocal();
    @Inject
    private PreInterpolator preInterpolator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isValid(T value, ConstraintValidatorContext context) {
        Boolean valid = true;
        this.contextMap.set(context);
        this.validMap.set(valid);
        try {
            this.doValidation(value);
            valid = this.validMap.get();
            if (!valid.booleanValue()) {
                String logMsg = "[%s] value are invalided by [%s] validator call.";
                this.log.info(String.format(logMsg, value, this.getClass().getName()));
            }
        }
        finally {
            this.release();
        }
        return valid;
    }

    public abstract void doValidation(T var1);

    protected void addViolationWithDefaultTemplate(String ... msgParameters) {
        ConstraintValidatorContext context = this.contextMap.get();
        String msg = context.getDefaultConstraintMessageTemplate();
        String msgInterpolated = this.preInterpolator.interpolate(msg, msgParameters);
        msgInterpolated = PresentationMessageFormatter.format(msg, msgInterpolated);
        this.log.debug("Adding violation with default template.");
        this.doTraceLog(msgParameters);
        this.makeInvalid();
        context.buildConstraintViolationWithTemplate(msgInterpolated).addConstraintViolation();
    }

    protected void addViolationWithDefaultTemplate(Path atPath, String ... msgParameters) {
        ConstraintValidatorContext context = this.contextMap.get();
        String msg = context.getDefaultConstraintMessageTemplate();
        String msgInterpolated = this.preInterpolator.interpolate(msg, msgParameters);
        msgInterpolated = PresentationMessageFormatter.format(msg, msgInterpolated);
        this.log.debug("Adding violation with default template.");
        this.doTraceLog(msgParameters);
        this.makeInvalid();
        ConstraintValidatorContext.ConstraintViolationBuilder cvBuilder = context.buildConstraintViolationWithTemplate(msgInterpolated);
        if (atPath.isRootIterablePath()) {
            this.buildIterablePathAndAddConstraint(cvBuilder, atPath);
        } else {
            this.buildPath(cvBuilder, atPath).addConstraintViolation();
        }
    }

    protected void addViolationWithDefaultTemplate(PathBuilder pathBuilder, String ... msgParameters) {
        this.addViolationWithDefaultTemplate(pathBuilder.getPath(), msgParameters);
    }

    protected void addViolation(String msgTemplate, String ... msgParameters) {
        ConstraintValidatorContext context = this.contextMap.get();
        String msgInterpolated = this.preInterpolator.interpolate(msgTemplate, msgParameters);
        msgInterpolated = PresentationMessageFormatter.format(msgTemplate, msgInterpolated);
        this.log.debug(PresentationMessageFormatter.format("Adding violation with [%s] template.", msgTemplate));
        this.doTraceLog(msgParameters);
        this.makeInvalid();
        context.buildConstraintViolationWithTemplate(msgInterpolated).addConstraintViolation();
    }

    protected void addViolation(Path path, String msgTemplate, String ... msgParameters) {
        ConstraintValidatorContext context = this.contextMap.get();
        String msgInterpolated = this.preInterpolator.interpolate(msgTemplate, msgParameters);
        msgInterpolated = PresentationMessageFormatter.format(msgTemplate, msgInterpolated);
        this.log.debug(PresentationMessageFormatter.format("Adding violation with [%s] template.", msgTemplate));
        this.doTraceLog(msgParameters);
        this.makeInvalid();
        ConstraintValidatorContext.ConstraintViolationBuilder vBuilder = context.buildConstraintViolationWithTemplate(msgInterpolated);
        if (path.isRootIterablePath()) {
            this.buildIterablePathAndAddConstraint(vBuilder, path);
        } else {
            this.buildPath(vBuilder, path).addConstraintViolation();
        }
    }

    protected void addViolation(PathBuilder pathBuilder, String msgTemplate, String ... msgParameters) {
        this.addViolation(pathBuilder.getPath(), msgTemplate, msgParameters);
    }

    private void doTraceLog(String[] msgParameters) {
        if (this.log.isTraceEnabled()) {
            for (int i = 0; i < msgParameters.length; ++i) {
                String parameter = msgParameters[i];
                this.log.trace(String.format("Parameter #%d: %s", i, parameter));
            }
        }
    }

    private void makeInvalid() {
        if (this.validMap.get().booleanValue()) {
            ConstraintValidatorContext context = this.contextMap.get();
            this.validMap.set(false);
            context.disableDefaultConstraintViolation();
            this.log.debug("Value marked as invalid.");
        }
    }

    protected PathBuilder buildPath(String path) {
        return new PathBuilder().add(path);
    }

    protected PathBuilder buildPath(String path, Object key) {
        return new PathBuilder().add(path, key);
    }

    protected Path atKey(Object key) {
        return new PathBuilder().addAtKey(key).getPath();
    }

    protected PathBuilder buildPath(String path, Integer index) {
        return new PathBuilder().add(path, index);
    }

    protected Path atIndex(Integer index) {
        return new PathBuilder().addAtIndex(index).getPath();
    }

    private ConstraintBuilderAdapter buildPath(ConstraintValidatorContext.ConstraintViolationBuilder cvBuilder, Path path) {
        ConstraintBuilderAdapter constraintBuilderAdapter = new NodeBuilderCustomizableContextAdapter(cvBuilder.addPropertyNode(path.getPath()));
        while (path.hasNext()) {
            path = path.getNext();
            constraintBuilderAdapter = constraintBuilderAdapter.addPropertyNode(path);
        }
        return constraintBuilderAdapter;
    }

    private void buildIterablePathAndAddConstraint(ConstraintValidatorContext.ConstraintViolationBuilder vBuilder, Path path) {
        ConstraintValidatorContext.ConstraintViolationBuilder.LeafNodeBuilderCustomizableContext leafNodeBCxt = vBuilder.addBeanNode();
        if (path.hasKey()) {
            leafNodeBCxt.inIterable().atKey(path.getKey()).addConstraintViolation();
        } else if (path.hasIndex()) {
            leafNodeBCxt.inIterable().atIndex(path.getIndex()).addConstraintViolation();
        }
    }

    private void release() {
        this.validMap.remove();
        this.contextMap.remove();
    }
}

