/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validators;

import com.github.ldeitos.validators.MultiTargetValidator;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.InvalidParameterException;

abstract class BigDecimalComparativeValidator<A extends Annotation>
extends MultiTargetValidator<A> {
    private final Class<?>[] targetClasses = new Class[]{Number.class, CharSequence.class};

    BigDecimalComparativeValidator() {
    }

    @Override
    protected boolean doValidation(Object value) {
        BigDecimal n;
        Class<?> valueClass = value.getClass();
        if (BigDecimal.class.isAssignableFrom(valueClass)) {
            n = (BigDecimal)BigDecimal.class.cast(value);
        } else if (BigInteger.class.isAssignableFrom(valueClass)) {
            n = new BigDecimal((BigInteger)BigInteger.class.cast(value));
        } else if (CharSequence.class.isAssignableFrom(valueClass)) {
            try {
                n = new BigDecimal(value.toString());
            }
            catch (NumberFormatException e) {
                throw new InvalidParameterException(String.format("Value [%s] invalid to be validated by [%s] validator.", value, this.getClass().getName()));
            }
        } else {
            n = Long.class.isAssignableFrom(valueClass) ? new BigDecimal((Long)Long.class.cast(value)) : new BigDecimal(((Number)Number.class.cast(value)).doubleValue());
        }
        return this.compareValid(n);
    }

    @Override
    protected Class<?>[] getTargetClasses() {
        return this.targetClasses;
    }

    protected abstract boolean compareValid(BigDecimal var1);
}

