/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validators;

import com.github.ldeitos.constraint.Digits;
import com.github.ldeitos.validators.BigDecimalComparativeValidator;
import com.github.ldeitos.validators.DigitsValidator;
import java.math.BigDecimal;
import java.security.InvalidParameterException;

public class DigitsValidatorImpl
extends BigDecimalComparativeValidator<Digits>
implements DigitsValidator {
    private int integerPart;
    private int fractionPart;

    public void initialize(Digits constraintAnnotation) {
        this.integerPart = this.validateParam(constraintAnnotation.integer(), "integer length");
        this.fractionPart = this.validateParam(constraintAnnotation.fraction(), "fraction length");
    }

    private int validateParam(int value, String param) {
        if (value < 0) {
            throw new InvalidParameterException(String.format("Invalid %s: [%d]", param, value));
        }
        return value;
    }

    @Override
    protected boolean compareValid(BigDecimal n) {
        int integerPartLength = n.precision() - n.scale();
        int fractionPartLength = n.scale() < 0 ? 0 : n.scale();
        return this.integerPart >= integerPartLength && this.fractionPart >= fractionPartLength;
    }
}

