/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validators;

import java.lang.annotation.Annotation;
import java.security.InvalidParameterException;
import java.util.Arrays;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;

abstract class MultiTargetValidator<A extends Annotation>
implements ConstraintValidator<A, Object> {
    MultiTargetValidator() {
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        boolean ret = true;
        if (value != null) {
            ret = this.validate(value);
        }
        return ret;
    }

    private boolean validate(Object value) {
        Class<?> valueClass = value.getClass();
        boolean ret = true;
        Predicate<Class<?>> assignableFrom = this.getMustValidatePredicate(valueClass);
        if (!CollectionUtils.exists(Arrays.asList(this.getTargetClasses()), assignableFrom)) {
            throw new InvalidParameterException(String.format("Invalid target type [%s] to be validated by [%s] validator.", valueClass.getName(), this.getClass().getName()));
        }
        ret = this.doValidation(value);
        return ret;
    }

    protected Predicate<Class<?>> getMustValidatePredicate(final Class<?> valueClass) {
        Predicate assignableFrom = new Predicate<Class<?>>(){

            public boolean evaluate(Class<?> arg0) {
                return arg0.isAssignableFrom(valueClass);
            }
        };
        return assignableFrom;
    }

    protected abstract boolean doValidation(Object var1);

    protected abstract Class<?>[] getTargetClasses();
}

