/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validators;

import com.github.ldeitos.constraint.Size;
import com.github.ldeitos.validators.MultiTargetValidator;
import com.github.ldeitos.validators.SizeValidator;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.lang.ArrayUtils;

public class SizeValidatorImpl
extends MultiTargetValidator<Size>
implements SizeValidator {
    private static final Class<?>[] targetClasses = new Class[]{Collection.class, Map.class, CharSequence.class};
    private int min;
    private int max;

    public void initialize(Size constraintAnnotation) {
        this.min = constraintAnnotation.min();
        this.max = constraintAnnotation.max();
        this.validateParameters();
    }

    private void validateParameters() {
        this.doValidation(this.min, 0, "'min'", "zero");
        this.doValidation(this.max, 0, "'max'", "zero");
        this.doValidation(this.max, this.min, "'max'", "'min'");
    }

    private void doValidation(int val, int valReference, String fieldName, String valueReference) {
        if (val < valReference) {
            String msg = "Attribute %s must be greater than %s.";
            throw new InvalidParameterException(String.format(msg, fieldName, valueReference));
        }
    }

    @Override
    protected boolean doValidation(Object value) {
        Class<?> valueClass = value.getClass();
        int size = CharSequence.class.isAssignableFrom(valueClass) ? ((CharSequence)CharSequence.class.cast(value)).length() : (Collection.class.isAssignableFrom(valueClass) ? ((Collection)Collection.class.cast(value)).size() : (Map.class.isAssignableFrom(valueClass) ? ((Map)Map.class.cast(value)).size() : ArrayUtils.getLength((Object)value)));
        return this.minValid(size) && this.maxValid(size);
    }

    private boolean maxValid(int size) {
        return size <= this.max;
    }

    private boolean minValid(int size) {
        return size >= this.min;
    }

    @Override
    protected Class<?>[] getTargetClasses() {
        return targetClasses;
    }

    @Override
    protected Predicate<Class<?>> getMustValidatePredicate(final Class<?> valueClass) {
        Predicate assignableFrom = new Predicate<Class<?>>(){

            public boolean evaluate(Class<?> arg0) {
                return valueClass.getName().startsWith("[") || arg0.isAssignableFrom(valueClass);
            }
        };
        return assignableFrom;
    }
}

