/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validators.util;

public class Path {
    private final String path;
    private Path nextPath;
    private Object key;
    private Integer index;
    private boolean shifted;

    Path(String path) {
        this.path = path;
    }

    Path(String path, Object key) {
        this(path);
        this.key = key;
    }

    Path(String path, Integer index) {
        this(path);
        this.index = index;
    }

    void addNext(Path path) {
        this.nextPath = path;
    }

    public Path getNext() {
        return this.nextPath;
    }

    public boolean isIterable() {
        return this.hasKey() || this.hasIndex();
    }

    public boolean isRootIterablePath() {
        return this.isIterable() && this.getPath() == null;
    }

    public boolean hasIndex() {
        return this.index != null;
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public String getPath() {
        return this.path;
    }

    void setKey(Object key) {
        this.key = key;
    }

    public Object getKey() {
        return this.key;
    }

    void setIndex(Integer index) {
        this.index = index;
    }

    public Integer getIndex() {
        return this.index;
    }

    public boolean hasNext() {
        return this.nextPath != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.formatPath(this));
        Path nextPath = this.nextPath;
        while (nextPath != null) {
            sb.append(".").append(this.formatPath(nextPath));
            nextPath = nextPath.nextPath;
        }
        return sb.toString();
    }

    private String formatPath(Path pathInstance) {
        StringBuilder sb = new StringBuilder(pathInstance.getPath());
        if (pathInstance.getKey() != null) {
            sb.append(String.format("[%s]", pathInstance.getKey().toString()));
        } else if (pathInstance.getIndex() != null) {
            sb.append(String.format("(%d)", pathInstance.getIndex()));
        }
        return sb.toString();
    }

    boolean isShifted() {
        return this.shifted;
    }

    public void setShifted(boolean shifted) {
        this.shifted = shifted;
    }
}

