/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validators.util;

import com.github.ldeitos.validators.util.Path;
import com.github.ldeitos.validators.util.PathDecoder;

public class PathBuilder {
    private Path path;
    private Path lastPath;

    public PathBuilder add(String path) {
        this.addPath(PathDecoder.decodePath(path));
        return this;
    }

    public PathBuilder add(String path, Object atKey) {
        this.addPath(new Path(path, atKey));
        return this;
    }

    public PathBuilder addAtKey(Object atKey) {
        this.addPath(new Path(null, atKey));
        return this;
    }

    public PathBuilder add(String path, Integer atIndex) {
        this.addPath(new Path(path, atIndex));
        return this;
    }

    public PathBuilder addAtIndex(Integer atIndex) {
        this.addPath(new Path(null, atIndex));
        return this;
    }

    void addPath(Path path) {
        if (this.path == null) {
            this.path = path;
        }
        if (this.lastPath != null) {
            this.lastPath.addNext(path);
        }
        this.lastPath = path;
    }

    public Path getPath() {
        PathDecoder.shiftIterables(this.path);
        return this.path;
    }
}

