/*
 * Decompiled with CFR 0.152.
 */
package com.github.ldeitos.validators.util;

import com.github.ldeitos.exception.InvalidPathConfigurationException;
import com.github.ldeitos.validators.util.Path;
import com.github.ldeitos.validators.util.PathBuilder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class PathDecoder {
    private static final Pattern ITERABLE_PATH_PATTERN = Pattern.compile("^(\\w+)(\\[(.+)\\]|(\\((.+)\\)))");
    private static final Pattern INVALID_ITERABLE_PATH_PATTERN = Pattern.compile("\\w+\\[\\w+\\.\\w*\\]");
    private static final Pattern NUMERIC = Pattern.compile("\\d+");
    private static final Pattern INDEXED_ITERABLE = Pattern.compile("(\\(.+\\))");
    private static final int PATH_NAME = 1;
    private static final int ITERABLE_KEY = 3;
    private static final int ITERABLE_INDEX = 5;

    public static Path decodePath(String fullPath) {
        PathDecoder.validateKeyFormat(fullPath);
        String[] paths = StringUtils.split((String)fullPath, (String)".");
        PathBuilder pathBuilder = new PathBuilder();
        for (String pathPart : paths) {
            pathBuilder.addPath(PathDecoder.decodeSimplePath(pathPart));
        }
        return pathBuilder.getPath();
    }

    private static Path decodeSimplePath(String fullPath) {
        Path path = null;
        Matcher matcherIterable = ITERABLE_PATH_PATTERN.matcher(fullPath);
        if (matcherIterable.matches()) {
            String pathName = matcherIterable.group(1);
            Matcher matcherIndexed = INDEXED_ITERABLE.matcher(fullPath);
            if (matcherIndexed.find()) {
                String index = matcherIterable.group(5);
                PathDecoder.validateIndexFormat(index);
                path = new Path(pathName, NumberUtils.toInt((String)index));
            } else {
                String key = matcherIterable.group(3);
                path = new Path(pathName, key);
            }
        } else {
            path = new Path(fullPath);
        }
        return path;
    }

    private static void validateIndexFormat(String iterable) {
        if (!NUMERIC.matcher(iterable).matches()) {
            InvalidPathConfigurationException.throwNew((String)String.format("[%s] - Invalid format to indexed iterable path, only numbers are allowed.", iterable));
        }
    }

    private static void validateKeyFormat(String fullPath) {
        Matcher matcher = INVALID_ITERABLE_PATH_PATTERN.matcher(fullPath);
        if (matcher.find()) {
            InvalidPathConfigurationException.throwNew((String)String.format("Invalid format to mapped iterable path: -> %s <- Maybe a \".\" used in key map value? (i.e: [not.use.dot])", fullPath));
        }
    }

    static void shiftIterables(Path path) {
        if (path == null || path.isShifted()) {
            return;
        }
        Path nextPath = path.getNext();
        PathDecoder.shiftIterables(nextPath);
        if (path.isIterable() && nextPath != null) {
            nextPath.setKey(path.getKey());
            nextPath.setIndex(path.getIndex());
            path.setKey(null);
            path.setIndex(null);
        }
        path.setShifted(true);
    }
}

