/*
 * Decompiled with CFR 0.152.
 */
package com.github.lltyk.rhino17r1.tools.shell;

import com.github.lltyk.rhino17r1.Context;
import com.github.lltyk.rhino17r1.ContextAction;
import com.github.lltyk.rhino17r1.EvaluatorException;
import com.github.lltyk.rhino17r1.Function;
import com.github.lltyk.rhino17r1.GeneratedClassLoader;
import com.github.lltyk.rhino17r1.Kit;
import com.github.lltyk.rhino17r1.NativeArray;
import com.github.lltyk.rhino17r1.RhinoException;
import com.github.lltyk.rhino17r1.Script;
import com.github.lltyk.rhino17r1.Scriptable;
import com.github.lltyk.rhino17r1.SecurityController;
import com.github.lltyk.rhino17r1.tools.ToolErrorReporter;
import com.github.lltyk.rhino17r1.tools.shell.Global;
import com.github.lltyk.rhino17r1.tools.shell.QuitAction;
import com.github.lltyk.rhino17r1.tools.shell.SecurityProxy;
import com.github.lltyk.rhino17r1.tools.shell.ShellContextFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class Main {
    public static ShellContextFactory shellContextFactory = new ShellContextFactory();
    public static Global global = new Global();
    protected static ToolErrorReporter errorReporter;
    protected static int exitCode;
    private static final int EXITCODE_RUNTIME_ERROR = 3;
    private static final int EXITCODE_FILE_NOT_FOUND = 4;
    static boolean processStdin;
    static Vector fileList;
    private static SecurityProxy securityImpl;

    public static void main(String[] args) {
        try {
            if (Boolean.getBoolean("rhino.use_java_policy_security")) {
                Main.initJavaPolicySecuritySupport();
            }
        }
        catch (SecurityException ex) {
            ex.printStackTrace(System.err);
        }
        int result = Main.exec(args);
        if (result != 0) {
            System.exit(result);
        }
    }

    public static int exec(String[] origArgs) {
        errorReporter = new ToolErrorReporter(false, global.getErr());
        shellContextFactory.setErrorReporter(errorReporter);
        String[] args = Main.processOptions(origArgs);
        if (processStdin) {
            fileList.addElement(null);
        }
        if (!Main.global.initialized) {
            global.init(shellContextFactory);
        }
        IProxy iproxy = new IProxy(1);
        iproxy.args = args;
        shellContextFactory.call(iproxy);
        return exitCode;
    }

    static void processFiles(Context cx, String[] args) {
        Object[] array = new Object[args.length];
        System.arraycopy(args, 0, array, 0, args.length);
        Scriptable argsObj = cx.newArray((Scriptable)global, array);
        global.defineProperty("arguments", argsObj, 2);
        for (int i = 0; i < fileList.size(); ++i) {
            Main.processSource(cx, (String)fileList.elementAt(i));
        }
    }

    public static Global getGlobal() {
        return global;
    }

    public static String[] processOptions(String[] args) {
        String usageError;
        int i = 0;
        while (true) {
            if (i == args.length) {
                return new String[0];
            }
            String arg = args[i];
            if (!arg.startsWith("-")) {
                processStdin = false;
                fileList.addElement(arg);
                String[] result = new String[args.length - i - 1];
                System.arraycopy(args, i + 1, result, 0, args.length - i - 1);
                return result;
            }
            if (arg.equals("-version")) {
                int version;
                if (++i == args.length) {
                    usageError = arg;
                    break;
                }
                try {
                    version = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    usageError = args[i];
                    break;
                }
                if (!Context.isValidLanguageVersion(version)) {
                    usageError = args[i];
                    break;
                }
                shellContextFactory.setLanguageVersion(version);
            } else if (arg.equals("-opt") || arg.equals("-O")) {
                int opt;
                if (++i == args.length) {
                    usageError = arg;
                    break;
                }
                try {
                    opt = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    usageError = args[i];
                    break;
                }
                if (opt == -2) {
                    opt = -1;
                } else if (!Context.isValidOptimizationLevel(opt)) {
                    usageError = args[i];
                    break;
                }
                shellContextFactory.setOptimizationLevel(opt);
            } else if (arg.equals("-strict")) {
                shellContextFactory.setStrictMode(true);
                errorReporter.setIsReportingWarnings(true);
            } else if (arg.equals("-fatal-warnings")) {
                shellContextFactory.setWarningAsError(true);
            } else if (arg.equals("-e")) {
                processStdin = false;
                if (++i == args.length) {
                    usageError = arg;
                    break;
                }
                if (!Main.global.initialized) {
                    global.init(shellContextFactory);
                }
                IProxy iproxy = new IProxy(2);
                iproxy.scriptText = args[i];
                shellContextFactory.call(iproxy);
            } else if (arg.equals("-w")) {
                errorReporter.setIsReportingWarnings(true);
            } else if (arg.equals("-f")) {
                processStdin = false;
                if (++i == args.length) {
                    usageError = arg;
                    break;
                }
                fileList.addElement(args[i].equals("-") ? null : args[i]);
            } else if (arg.equals("-sealedlib")) {
                global.setSealedStdLib(true);
            } else if (arg.equals("-debug")) {
                shellContextFactory.setGeneratingDebug(true);
            } else {
                if (arg.equals("-?") || arg.equals("-help")) {
                    global.getOut().println(ToolErrorReporter.getMessage("msg.shell.usage", Main.class.getName()));
                    System.exit(1);
                }
                usageError = arg;
                break;
            }
            ++i;
        }
        global.getOut().println(ToolErrorReporter.getMessage("msg.shell.invalid", usageError));
        global.getOut().println(ToolErrorReporter.getMessage("msg.shell.usage", Main.class.getName()));
        System.exit(1);
        return null;
    }

    private static void initJavaPolicySecuritySupport() {
        Throwable exObj;
        try {
            Class<?> cl = Class.forName("com.github.lltyk.rhino17r1.tools.shell.JavaPolicySecurity");
            securityImpl = (SecurityProxy)cl.newInstance();
            SecurityController.initGlobal(securityImpl);
            return;
        }
        catch (ClassNotFoundException ex) {
            exObj = ex;
        }
        catch (IllegalAccessException ex) {
            exObj = ex;
        }
        catch (InstantiationException ex) {
            exObj = ex;
        }
        catch (LinkageError ex) {
            exObj = ex;
        }
        throw Kit.initCause(new IllegalStateException("Can not load security support: " + exObj), exObj);
    }

    public static void processSource(Context cx, String filename) {
        if (filename == null || filename.equals("-")) {
            PrintStream ps = global.getErr();
            if (filename == null) {
                ps.println(cx.getImplementationVersion());
            }
            cx.setOptimizationLevel(-1);
            BufferedReader in = new BufferedReader(new InputStreamReader(global.getIn()));
            int lineno = 1;
            boolean hitEOF = false;
            while (!hitEOF) {
                Script script;
                String[] prompts = global.getPrompts(cx);
                if (filename == null) {
                    ps.print(prompts[0]);
                }
                ps.flush();
                String source = "";
                while (true) {
                    String newline;
                    try {
                        newline = in.readLine();
                    }
                    catch (IOException ioe) {
                        ps.println(ioe.toString());
                        break;
                    }
                    if (newline == null) {
                        hitEOF = true;
                        break;
                    }
                    source = source + newline + "\n";
                    ++lineno;
                    if (cx.stringIsCompilableUnit(source)) break;
                    ps.print(prompts[1]);
                }
                if ((script = Main.loadScriptFromSource(cx, source, "<stdin>", lineno, null)) == null) continue;
                Object result = Main.evaluateScript(script, cx, global);
                if (!(result == Context.getUndefinedValue() || result instanceof Function && source.trim().startsWith("function"))) {
                    try {
                        ps.println(Context.toString(result));
                    }
                    catch (RhinoException rex) {
                        ToolErrorReporter.reportException(cx.getErrorReporter(), rex);
                    }
                }
                NativeArray h = Main.global.history;
                h.put((int)h.getLength(), (Scriptable)h, (Object)source);
            }
            ps.println();
        } else {
            Main.processFile(cx, global, filename);
        }
        System.gc();
    }

    public static void processFile(Context cx, Scriptable scope, String filename) {
        if (securityImpl == null) {
            Main.processFileSecure(cx, scope, filename, null);
        } else {
            securityImpl.callProcessFileSecure(cx, scope, filename);
        }
    }

    static void processFileSecure(Context cx, Scriptable scope, String path, Object securityDomain) {
        Script script;
        if (path.endsWith(".class")) {
            script = Main.loadCompiledScript(cx, path, securityDomain);
        } else {
            String source = (String)Main.readFileOrUrl(path, true);
            if (source == null) {
                exitCode = 4;
                return;
            }
            if (source.length() > 0 && source.charAt(0) == '#') {
                for (int i = 1; i != source.length(); ++i) {
                    char c = source.charAt(i);
                    if (c != '\n' && c != '\r') continue;
                    source = source.substring(i);
                    break;
                }
            }
            script = Main.loadScriptFromSource(cx, source, path, 1, securityDomain);
        }
        if (script != null) {
            Main.evaluateScript(script, cx, scope);
        }
    }

    public static Script loadScriptFromSource(Context cx, String scriptSource, String path, int lineno, Object securityDomain) {
        try {
            return cx.compileString(scriptSource, path, lineno, securityDomain);
        }
        catch (EvaluatorException ee) {
            exitCode = 3;
        }
        catch (RhinoException rex) {
            ToolErrorReporter.reportException(cx.getErrorReporter(), rex);
            exitCode = 3;
        }
        catch (VirtualMachineError ex) {
            ex.printStackTrace();
            String msg = ToolErrorReporter.getMessage("msg.uncaughtJSException", ex.toString());
            exitCode = 3;
            Context.reportError(msg);
        }
        return null;
    }

    private static Script loadCompiledScript(Context cx, String path, Object securityDomain) {
        byte[] data = (byte[])Main.readFileOrUrl(path, false);
        if (data == null) {
            exitCode = 4;
            return null;
        }
        int nameStart = path.lastIndexOf(47);
        nameStart = nameStart < 0 ? 0 : ++nameStart;
        int nameEnd = path.lastIndexOf(46);
        if (nameEnd < nameStart) {
            nameEnd = path.length();
        }
        String name = path.substring(nameStart, nameEnd);
        try {
            GeneratedClassLoader loader = SecurityController.createLoader(cx.getApplicationClassLoader(), securityDomain);
            Class clazz = loader.defineClass(name, data);
            loader.linkClass(clazz);
            if (!Script.class.isAssignableFrom(clazz)) {
                throw Context.reportRuntimeError("msg.must.implement.Script");
            }
            return (Script)clazz.newInstance();
        }
        catch (RhinoException rex) {
            ToolErrorReporter.reportException(cx.getErrorReporter(), rex);
            exitCode = 3;
        }
        catch (IllegalAccessException iaex) {
            exitCode = 3;
            Context.reportError(iaex.toString());
        }
        catch (InstantiationException inex) {
            exitCode = 3;
            Context.reportError(inex.toString());
        }
        return null;
    }

    public static Object evaluateScript(Script script, Context cx, Scriptable scope) {
        try {
            return script.exec(cx, scope);
        }
        catch (RhinoException rex) {
            ToolErrorReporter.reportException(cx.getErrorReporter(), rex);
            exitCode = 3;
        }
        catch (VirtualMachineError ex) {
            ex.printStackTrace();
            String msg = ToolErrorReporter.getMessage("msg.uncaughtJSException", ex.toString());
            exitCode = 3;
            Context.reportError(msg);
        }
        return Context.getUndefinedValue();
    }

    public static InputStream getIn() {
        return Main.getGlobal().getIn();
    }

    public static void setIn(InputStream in) {
        Main.getGlobal().setIn(in);
    }

    public static PrintStream getOut() {
        return Main.getGlobal().getOut();
    }

    public static void setOut(PrintStream out) {
        Main.getGlobal().setOut(out);
    }

    public static PrintStream getErr() {
        return Main.getGlobal().getErr();
    }

    public static void setErr(PrintStream err) {
        Main.getGlobal().setErr(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object readFileOrUrl(String path, boolean convertToString) {
        byte[] data;
        URL url = null;
        if (path.indexOf(58) >= 2) {
            try {
                url = new URL(path);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
        }
        InputStream is = null;
        int capacityHint = 0;
        if (url == null) {
            File file = new File(path);
            capacityHint = (int)file.length();
            try {
                is = new FileInputStream(file);
            }
            catch (IOException ex) {
                Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open", path));
                return null;
            }
        }
        try {
            URLConnection uc = url.openConnection();
            is = uc.getInputStream();
            capacityHint = uc.getContentLength();
            if (capacityHint > 0x100000) {
                capacityHint = -1;
            }
        }
        catch (IOException ex) {
            Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open.url", url.toString(), ex.toString()));
            return null;
        }
        if (capacityHint <= 0) {
            capacityHint = 4096;
        }
        try {
            try {
                data = Kit.readStream(is, capacityHint);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            Context.reportError(ex.toString());
            return null;
        }
        Object result = !convertToString ? data : (Object)new String(data);
        return result;
    }

    static {
        exitCode = 0;
        processStdin = true;
        fileList = new Vector(5);
        global.initQuitAction(new IProxy(3));
    }

    private static class IProxy
    implements ContextAction,
    QuitAction {
        private static final int PROCESS_FILES = 1;
        private static final int EVAL_INLINE_SCRIPT = 2;
        private static final int SYSTEM_EXIT = 3;
        private int type;
        String[] args;
        String scriptText;

        IProxy(int type) {
            this.type = type;
        }

        public Object run(Context cx) {
            if (this.type == 1) {
                Main.processFiles(cx, this.args);
            } else if (this.type == 2) {
                Script script = Main.loadScriptFromSource(cx, this.scriptText, "<command>", 1, null);
                if (script != null) {
                    Main.evaluateScript(script, cx, Main.getGlobal());
                }
            } else {
                throw Kit.codeBug();
            }
            return null;
        }

        public void quit(Context cx, int exitCode) {
            if (this.type == 3) {
                System.exit(exitCode);
                return;
            }
            throw Kit.codeBug();
        }
    }
}

