/*
 * Decompiled with CFR 0.152.
 */
package org.dojotoolkit.shrinksafe;

import com.github.lltyk.rhino17r1.ScriptOrFnNode;
import com.github.lltyk.rhino17r1.ScriptRuntime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dojotoolkit.shrinksafe.DebugData;
import org.dojotoolkit.shrinksafe.ReplacedTokens;

public class TokenMapper {
    private List functionBracePositions = new ArrayList();
    private List replacedTokens = new ArrayList();
    private List functionVarMappings = new ArrayList();
    private Map debugDataList = new HashMap();
    private int functionNum = 0;
    private int parentScope = 0;
    private int lastTokenCount = 0;

    public TokenMapper(ScriptOrFnNode parseTree) {
        this.collectFunctionMappings(parseTree);
    }

    public void incrementFunctionNumber() {
        ++this.functionNum;
    }

    private String getMappedToken(String token, boolean hasNewMapping) {
        String newToken = null;
        Map tokens = null;
        String blank = new String("");
        int localScope = this.functionBracePositions.size() - 1;
        String oldToken = this.getPreviousTokenMapping(token, hasNewMapping);
        if (!oldToken.equalsIgnoreCase(blank)) {
            return oldToken;
        }
        if (hasNewMapping || this.isInScopeChain(token)) {
            newToken = new String("_" + Integer.toHexString(++this.lastTokenCount));
            if (newToken.length() >= token.length() && token.charAt(0) != '_') {
                newToken = token;
                --this.lastTokenCount;
            }
            tokens = (Map)this.replacedTokens.get(hasNewMapping ? localScope : this.parentScope);
            tokens.put(token, newToken);
            return newToken;
        }
        return token;
    }

    private boolean isInScopeChain(String token) {
        int scope = this.functionBracePositions.size();
        Map chainedScopeVars = (Map)this.functionVarMappings.get(this.functionNum);
        if (!chainedScopeVars.isEmpty()) {
            for (int i = scope; i > 0; --i) {
                if (!chainedScopeVars.containsKey(new Integer(i))) continue;
                this.parentScope = i - 1;
                List<String> temp = Arrays.asList((String[])chainedScopeVars.get(new Integer(i)));
                if (temp.indexOf(token) == -1) continue;
                return true;
            }
        }
        return false;
    }

    private String getPreviousTokenMapping(String token, boolean hasNewMapping) {
        String result = new String("");
        int scope = this.replacedTokens.size() - 1;
        if (scope < 0) {
            return result;
        }
        if (hasNewMapping) {
            Map tokens = (Map)this.replacedTokens.get(scope);
            if (tokens.containsKey(token)) {
                result = (String)tokens.get(token);
                return result;
            }
        } else {
            for (int i = scope; i > -1; --i) {
                Map tokens = (Map)this.replacedTokens.get(i);
                if (!tokens.containsKey(token)) continue;
                result = (String)tokens.get(token);
                return result;
            }
        }
        return result;
    }

    private void collectFunctionMappings(ScriptOrFnNode parseTree) {
        int level = -1;
        this.collectFuncNodes(parseTree, level, null);
    }

    private void collectFuncNodes(ScriptOrFnNode parseTree, int level, ScriptOrFnNode parent) {
        ++level;
        DebugData debugData = new DebugData();
        debugData.start = parseTree.getBaseLineno();
        debugData.end = parseTree.getEndLineno();
        debugData.paramAndVarNames = parseTree.getParamAndVarNames();
        this.debugDataList.put(new Integer(parseTree.getEncodedSourceStart()), debugData);
        this.functionVarMappings.add(new HashMap());
        Map bindingNames = (Map)this.functionVarMappings.get(this.functionVarMappings.size() - 1);
        bindingNames.put(new Integer(level), parseTree.getParamAndVarNames());
        if (parent != null) {
            bindingNames.put(new Integer(level - 1), parent.getParamAndVarNames());
        }
        int nestedCount = parseTree.getFunctionCount();
        for (int i = 0; i != nestedCount; ++i) {
            this.collectFuncNodes(parseTree.getFunctionNode(i), level, parseTree);
            bindingNames = (Map)this.functionVarMappings.get(this.functionVarMappings.size() - 1);
            bindingNames.put(new Integer(level), parseTree.getParamAndVarNames());
        }
    }

    public int sourceCompress(String encodedSource, int offset, boolean asQuotedString, StringBuffer sb, int prevToken, boolean inArgsList, int currentLevel, ReplacedTokens replacedTokens) {
        boolean hasNewMapping = false;
        int length = encodedSource.charAt(offset);
        ++offset;
        if ((0x8000 & length) != 0) {
            length = (Short.MAX_VALUE & length) << 16 | encodedSource.charAt(offset);
            ++offset;
        }
        String str = encodedSource.substring(offset, offset + length);
        if (prevToken == 121 || inArgsList) {
            hasNewMapping = true;
        }
        if (sb != null) {
            String sourceStr = new String(str);
            if ((this.functionBracePositions.size() > 0 && currentLevel >= (Integer)this.functionBracePositions.get(this.functionBracePositions.size() - 1) || inArgsList) && prevToken != 107) {
                str = replacedTokens.find(str);
            }
            if (!inArgsList && asQuotedString && (prevToken == 84 || prevToken == 88)) {
                str = sourceStr;
            }
            if (!asQuotedString) {
                sb.append(str);
            } else {
                sb.append('\"');
                sb.append(ScriptRuntime.escapeString(str));
                sb.append('\"');
            }
        } else if ((this.functionBracePositions.size() > 0 && currentLevel >= (Integer)this.functionBracePositions.get(this.functionBracePositions.size() - 1) || inArgsList) && prevToken != 107) {
            this.getMappedToken(str, hasNewMapping);
        }
        return offset + length;
    }

    public void enterNestingLevel(int braceNesting) {
        this.functionBracePositions.add(new Integer(braceNesting + 1));
        this.replacedTokens.add(new HashMap());
    }

    public boolean leaveNestingLevel(int braceNesting) {
        boolean tokensRemoved = false;
        Integer bn = new Integer(braceNesting);
        if (this.functionBracePositions.contains(bn) && this.replacedTokens.size() > 0) {
            int scopedSize = this.replacedTokens.size();
            this.replacedTokens.remove(scopedSize - 1);
            this.functionBracePositions.remove(bn);
            tokensRemoved = true;
        }
        return tokensRemoved;
    }

    public Map getCurrentTokens() {
        Map m = null;
        if (this.replacedTokens.size() > 0) {
            m = (Map)this.replacedTokens.get(this.replacedTokens.size() - 1);
        }
        return m;
    }

    public DebugData getDebugData(Integer functionPosition) {
        return (DebugData)this.debugDataList.get(functionPosition);
    }

    public void reset() {
        this.functionNum = 0;
        this.parentScope = 0;
        this.lastTokenCount = 0;
        this.functionBracePositions = new ArrayList();
        this.replacedTokens = new ArrayList();
    }
}

