/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.xmldoclet;

import com.github.markusbernhardt.xmldoclet.LoggingLevelEnum;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;

class LoggingOutputStream
extends OutputStream {
    protected Logger log;
    protected LoggingLevelEnum loggingLevel;
    protected boolean hasBeenClosed = false;
    protected StringBuffer buffer = new StringBuffer();

    public LoggingOutputStream(Logger log, LoggingLevelEnum loggingLevel) throws IllegalArgumentException {
        if (log == null) {
            throw new IllegalArgumentException("log == null");
        }
        this.loggingLevel = loggingLevel;
        this.log = log;
    }

    @Override
    public void close() {
        this.flush();
        this.hasBeenClosed = true;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.hasBeenClosed) {
            throw new IOException("The stream has been closed.");
        }
        byte[] bytes = new byte[]{(byte)(b & 0xFF)};
        String s = new String(bytes);
        if (s.equals("\n")) {
            this.flush();
        } else {
            this.buffer.append(s);
        }
    }

    @Override
    public void flush() {
        String message = this.buffer.toString().trim();
        if (message.length() > 0) {
            this.loggingLevel.log(this.log, message);
        }
        this.reset();
    }

    private void reset() {
        this.buffer = new StringBuffer();
    }
}

