/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.xmldoclet;

import com.github.markusbernhardt.xmldoclet.xjc.Annotation;
import com.github.markusbernhardt.xmldoclet.xjc.AnnotationArgument;
import com.github.markusbernhardt.xmldoclet.xjc.AnnotationElement;
import com.github.markusbernhardt.xmldoclet.xjc.AnnotationInstance;
import com.github.markusbernhardt.xmldoclet.xjc.Class;
import com.github.markusbernhardt.xmldoclet.xjc.Constructor;
import com.github.markusbernhardt.xmldoclet.xjc.Enum;
import com.github.markusbernhardt.xmldoclet.xjc.EnumConstant;
import com.github.markusbernhardt.xmldoclet.xjc.Field;
import com.github.markusbernhardt.xmldoclet.xjc.Interface;
import com.github.markusbernhardt.xmldoclet.xjc.Method;
import com.github.markusbernhardt.xmldoclet.xjc.MethodParameter;
import com.github.markusbernhardt.xmldoclet.xjc.ObjectFactory;
import com.github.markusbernhardt.xmldoclet.xjc.Package;
import com.github.markusbernhardt.xmldoclet.xjc.Root;
import com.github.markusbernhardt.xmldoclet.xjc.TagInfo;
import com.github.markusbernhardt.xmldoclet.xjc.TypeInfo;
import com.github.markusbernhardt.xmldoclet.xjc.TypeParameter;
import com.github.markusbernhardt.xmldoclet.xjc.Wildcard;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import com.sun.javadoc.WildcardType;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger log = LoggerFactory.getLogger(Parser.class);
    protected Map<String, Package> packages = new TreeMap<String, Package>();
    protected ObjectFactory objectFactory = new ObjectFactory();

    public Root parseRootDoc(RootDoc rootDoc) {
        Root rootNode = this.objectFactory.createRoot();
        for (ClassDoc classDoc : rootDoc.classes()) {
            PackageDoc packageDoc = classDoc.containingPackage();
            Package packageNode = this.packages.get(packageDoc.name());
            if (packageNode == null) {
                packageNode = this.parsePackage(packageDoc);
                this.packages.put(packageDoc.name(), packageNode);
                rootNode.getPackage().add(packageNode);
            }
            if (classDoc instanceof AnnotationTypeDoc) {
                packageNode.getAnnotation().add(this.parseAnnotationTypeDoc((AnnotationTypeDoc)classDoc));
                continue;
            }
            if (classDoc.isEnum()) {
                packageNode.getEnum().add(this.parseEnum(classDoc));
                continue;
            }
            if (classDoc.isInterface()) {
                packageNode.getInterface().add(this.parseInterface(classDoc));
                continue;
            }
            packageNode.getClazz().add(this.parseClass(classDoc));
        }
        return rootNode;
    }

    protected Package parsePackage(PackageDoc packageDoc) {
        Package packageNode = this.objectFactory.createPackage();
        packageNode.setName(packageDoc.name());
        String comment = packageDoc.commentText();
        if (comment.length() > 0) {
            packageNode.setComment(comment);
        }
        for (Tag tag : packageDoc.tags()) {
            packageNode.getTag().add(this.parseTag(tag));
        }
        return packageNode;
    }

    protected Annotation parseAnnotationTypeDoc(AnnotationTypeDoc annotationTypeDoc) {
        Annotation annotationNode = this.objectFactory.createAnnotation();
        annotationNode.setName(annotationTypeDoc.name());
        annotationNode.setQualified(annotationTypeDoc.qualifiedName());
        String comment = annotationTypeDoc.commentText();
        if (comment.length() > 0) {
            annotationNode.setComment(comment);
        }
        annotationNode.setIncluded(annotationTypeDoc.isIncluded());
        annotationNode.setScope(this.parseScope((ProgramElementDoc)annotationTypeDoc));
        for (AnnotationTypeElementDoc annotationTypeElementDoc : annotationTypeDoc.elements()) {
            annotationNode.getElement().add(this.parseAnnotationTypeElementDoc(annotationTypeElementDoc));
        }
        for (AnnotationTypeElementDoc annotationTypeElementDoc : annotationTypeDoc.annotations()) {
            annotationNode.getAnnotation().add(this.parseAnnotationDesc((AnnotationDesc)annotationTypeElementDoc, annotationTypeDoc.qualifiedName()));
        }
        for (AnnotationTypeElementDoc annotationTypeElementDoc : annotationTypeDoc.tags()) {
            annotationNode.getTag().add(this.parseTag((Tag)annotationTypeElementDoc));
        }
        return annotationNode;
    }

    protected AnnotationElement parseAnnotationTypeElementDoc(AnnotationTypeElementDoc annotationTypeElementDoc) {
        AnnotationElement annotationElementNode = this.objectFactory.createAnnotationElement();
        annotationElementNode.setName(annotationTypeElementDoc.name());
        annotationElementNode.setQualified(annotationTypeElementDoc.qualifiedName());
        annotationElementNode.setType(this.parseTypeInfo(annotationTypeElementDoc.returnType()));
        AnnotationValue value = annotationTypeElementDoc.defaultValue();
        if (value != null) {
            annotationElementNode.setDefault(value.toString());
        }
        return annotationElementNode;
    }

    protected AnnotationInstance parseAnnotationDesc(AnnotationDesc annotationDesc, String programElement) {
        AnnotationInstance annotationInstanceNode = this.objectFactory.createAnnotationInstance();
        try {
            AnnotationTypeDoc annotTypeInfo = annotationDesc.annotationType();
            annotationInstanceNode.setName(annotTypeInfo.name());
            annotationInstanceNode.setQualified(annotTypeInfo.qualifiedTypeName());
        }
        catch (ClassCastException castException) {
            log.error("Unable to obtain type data about an annotation found on: " + programElement);
            log.error("Add to the classpath the class/jar that defines this annotation.");
        }
        for (AnnotationDesc.ElementValuePair elementValuesPair : annotationDesc.elementValues()) {
            AnnotationArgument annotationArgumentNode = this.objectFactory.createAnnotationArgument();
            annotationArgumentNode.setName(elementValuesPair.element().name());
            Type annotationArgumentType = elementValuesPair.element().returnType();
            annotationArgumentNode.setType(this.parseTypeInfo(annotationArgumentType));
            annotationArgumentNode.setPrimitive(annotationArgumentType.isPrimitive());
            annotationArgumentNode.setArray(annotationArgumentType.dimension().length() > 0);
            Object objValue = elementValuesPair.value().value();
            if (objValue instanceof AnnotationValue[]) {
                for (AnnotationValue annotationValue : (AnnotationValue[])objValue) {
                    annotationArgumentNode.getValue().add(annotationValue.value().toString());
                }
            } else if (objValue instanceof FieldDoc) {
                annotationArgumentNode.getValue().add(((FieldDoc)objValue).name());
            } else if (objValue instanceof ClassDoc) {
                annotationArgumentNode.getValue().add(((ClassDoc)objValue).qualifiedTypeName());
            } else {
                annotationArgumentNode.getValue().add(objValue.toString());
            }
            annotationInstanceNode.getArgument().add(annotationArgumentNode);
        }
        return annotationInstanceNode;
    }

    protected Enum parseEnum(ClassDoc classDoc) {
        Enum enumNode = this.objectFactory.createEnum();
        enumNode.setName(classDoc.name());
        enumNode.setQualified(classDoc.qualifiedName());
        String comment = classDoc.commentText();
        if (comment.length() > 0) {
            enumNode.setComment(comment);
        }
        enumNode.setIncluded(classDoc.isIncluded());
        enumNode.setScope(this.parseScope((ProgramElementDoc)classDoc));
        Type superClassType = classDoc.superclassType();
        if (superClassType != null) {
            enumNode.setClazz(this.parseTypeInfo(superClassType));
        }
        for (Type type : classDoc.interfaceTypes()) {
            enumNode.getInterface().add(this.parseTypeInfo(type));
        }
        for (Type type : classDoc.enumConstants()) {
            enumNode.getConstant().add(this.parseEnumConstant((FieldDoc)type));
        }
        for (Type type : classDoc.annotations()) {
            enumNode.getAnnotation().add(this.parseAnnotationDesc((AnnotationDesc)type, classDoc.qualifiedName()));
        }
        for (Type type : classDoc.tags()) {
            enumNode.getTag().add(this.parseTag((Tag)type));
        }
        return enumNode;
    }

    protected EnumConstant parseEnumConstant(FieldDoc fieldDoc) {
        EnumConstant enumConstant = this.objectFactory.createEnumConstant();
        enumConstant.setName(fieldDoc.name());
        String comment = fieldDoc.commentText();
        if (comment.length() > 0) {
            enumConstant.setComment(comment);
        }
        for (AnnotationDesc annotationDesc : fieldDoc.annotations()) {
            enumConstant.getAnnotation().add(this.parseAnnotationDesc(annotationDesc, fieldDoc.qualifiedName()));
        }
        for (AnnotationDesc annotationDesc : fieldDoc.tags()) {
            enumConstant.getTag().add(this.parseTag((Tag)annotationDesc));
        }
        return enumConstant;
    }

    protected Interface parseInterface(ClassDoc classDoc) {
        Interface interfaceNode = this.objectFactory.createInterface();
        interfaceNode.setName(classDoc.name());
        interfaceNode.setQualified(classDoc.qualifiedName());
        String comment = classDoc.commentText();
        if (comment.length() > 0) {
            interfaceNode.setComment(comment);
        }
        interfaceNode.setIncluded(classDoc.isIncluded());
        interfaceNode.setScope(this.parseScope((ProgramElementDoc)classDoc));
        for (TypeVariable typeVariable : classDoc.typeParameters()) {
            interfaceNode.getGeneric().add(this.parseTypeParameter(typeVariable));
        }
        for (TypeVariable typeVariable : classDoc.interfaceTypes()) {
            interfaceNode.getInterface().add(this.parseTypeInfo((Type)typeVariable));
        }
        for (TypeVariable typeVariable : classDoc.methods()) {
            interfaceNode.getMethod().add(this.parseMethod((MethodDoc)typeVariable));
        }
        for (TypeVariable typeVariable : classDoc.annotations()) {
            interfaceNode.getAnnotation().add(this.parseAnnotationDesc((AnnotationDesc)typeVariable, classDoc.qualifiedName()));
        }
        for (TypeVariable typeVariable : classDoc.tags()) {
            interfaceNode.getTag().add(this.parseTag((Tag)typeVariable));
        }
        for (TypeVariable typeVariable : classDoc.fields()) {
            interfaceNode.getField().add(this.parseField((FieldDoc)typeVariable));
        }
        return interfaceNode;
    }

    protected Class parseClass(ClassDoc classDoc) {
        Class classNode = this.objectFactory.createClass();
        classNode.setName(classDoc.name());
        classNode.setQualified(classDoc.qualifiedName());
        String comment = classDoc.commentText();
        if (comment.length() > 0) {
            classNode.setComment(comment);
        }
        classNode.setAbstract(classDoc.isAbstract());
        classNode.setError(classDoc.isError());
        classNode.setException(classDoc.isException());
        classNode.setExternalizable(classDoc.isExternalizable());
        classNode.setIncluded(classDoc.isIncluded());
        classNode.setSerializable(classDoc.isSerializable());
        classNode.setScope(this.parseScope((ProgramElementDoc)classDoc));
        for (TypeVariable typeVariable : classDoc.typeParameters()) {
            classNode.getGeneric().add(this.parseTypeParameter(typeVariable));
        }
        Type superClassType = classDoc.superclassType();
        if (superClassType != null) {
            classNode.setClazz(this.parseTypeInfo(superClassType));
        }
        for (Type type : classDoc.interfaceTypes()) {
            classNode.getInterface().add(this.parseTypeInfo(type));
        }
        for (Type type : classDoc.methods()) {
            classNode.getMethod().add(this.parseMethod((MethodDoc)type));
        }
        for (Type type : classDoc.annotations()) {
            classNode.getAnnotation().add(this.parseAnnotationDesc((AnnotationDesc)type, classDoc.qualifiedName()));
        }
        for (Type type : classDoc.constructors()) {
            classNode.getConstructor().add(this.parseConstructor((ConstructorDoc)type));
        }
        for (Type type : classDoc.fields()) {
            classNode.getField().add(this.parseField((FieldDoc)type));
        }
        for (Type type : classDoc.tags()) {
            classNode.getTag().add(this.parseTag((Tag)type));
        }
        return classNode;
    }

    protected Constructor parseConstructor(ConstructorDoc constructorDoc) {
        Constructor constructorNode = this.objectFactory.createConstructor();
        constructorNode.setName(constructorDoc.name());
        constructorNode.setQualified(constructorDoc.qualifiedName());
        String comment = constructorDoc.commentText();
        if (comment.length() > 0) {
            constructorNode.setComment(comment);
        }
        constructorNode.setScope(this.parseScope((ProgramElementDoc)constructorDoc));
        constructorNode.setIncluded(constructorDoc.isIncluded());
        constructorNode.setFinal(constructorDoc.isFinal());
        constructorNode.setNative(constructorDoc.isNative());
        constructorNode.setStatic(constructorDoc.isStatic());
        constructorNode.setSynchronized(constructorDoc.isSynchronized());
        constructorNode.setVarArgs(constructorDoc.isVarArgs());
        constructorNode.setSignature(constructorDoc.signature());
        for (Parameter parameter : constructorDoc.parameters()) {
            constructorNode.getParameter().add(this.parseMethodParameter(parameter));
        }
        for (Parameter parameter : constructorDoc.thrownExceptionTypes()) {
            constructorNode.getException().add(this.parseTypeInfo((Type)parameter));
        }
        for (Parameter parameter : constructorDoc.annotations()) {
            constructorNode.getAnnotation().add(this.parseAnnotationDesc((AnnotationDesc)parameter, constructorDoc.qualifiedName()));
        }
        for (Parameter parameter : constructorDoc.tags()) {
            constructorNode.getTag().add(this.parseTag((Tag)parameter));
        }
        return constructorNode;
    }

    protected Method parseMethod(MethodDoc methodDoc) {
        Method methodNode = this.objectFactory.createMethod();
        methodNode.setName(methodDoc.name());
        methodNode.setQualified(methodDoc.qualifiedName());
        String comment = methodDoc.commentText();
        if (comment.length() > 0) {
            methodNode.setComment(comment);
        }
        methodNode.setScope(this.parseScope((ProgramElementDoc)methodDoc));
        methodNode.setAbstract(methodDoc.isAbstract());
        methodNode.setIncluded(methodDoc.isIncluded());
        methodNode.setFinal(methodDoc.isFinal());
        methodNode.setNative(methodDoc.isNative());
        methodNode.setStatic(methodDoc.isStatic());
        methodNode.setSynchronized(methodDoc.isSynchronized());
        methodNode.setVarArgs(methodDoc.isVarArgs());
        methodNode.setSignature(methodDoc.signature());
        methodNode.setReturn(this.parseTypeInfo(methodDoc.returnType()));
        for (Parameter parameter : methodDoc.parameters()) {
            methodNode.getParameter().add(this.parseMethodParameter(parameter));
        }
        for (Parameter parameter : methodDoc.thrownExceptionTypes()) {
            methodNode.getException().add(this.parseTypeInfo((Type)parameter));
        }
        for (Parameter parameter : methodDoc.annotations()) {
            methodNode.getAnnotation().add(this.parseAnnotationDesc((AnnotationDesc)parameter, methodDoc.qualifiedName()));
        }
        for (Parameter parameter : methodDoc.tags()) {
            methodNode.getTag().add(this.parseTag((Tag)parameter));
        }
        return methodNode;
    }

    protected MethodParameter parseMethodParameter(Parameter parameter) {
        MethodParameter parameterMethodNode = this.objectFactory.createMethodParameter();
        parameterMethodNode.setName(parameter.name());
        parameterMethodNode.setType(this.parseTypeInfo(parameter.type()));
        for (AnnotationDesc annotationDesc : parameter.annotations()) {
            parameterMethodNode.getAnnotation().add(this.parseAnnotationDesc(annotationDesc, parameter.typeName()));
        }
        return parameterMethodNode;
    }

    protected Field parseField(FieldDoc fieldDoc) {
        Field fieldNode = this.objectFactory.createField();
        fieldNode.setType(this.parseTypeInfo(fieldDoc.type()));
        fieldNode.setName(fieldDoc.name());
        fieldNode.setQualified(fieldDoc.qualifiedName());
        String comment = fieldDoc.commentText();
        if (comment.length() > 0) {
            fieldNode.setComment(comment);
        }
        fieldNode.setScope(this.parseScope((ProgramElementDoc)fieldDoc));
        fieldNode.setFinal(fieldDoc.isFinal());
        fieldNode.setStatic(fieldDoc.isStatic());
        fieldNode.setVolatile(fieldDoc.isVolatile());
        fieldNode.setTransient(fieldDoc.isTransient());
        fieldNode.setConstant(fieldDoc.constantValueExpression());
        for (AnnotationDesc annotationDesc : fieldDoc.annotations()) {
            fieldNode.getAnnotation().add(this.parseAnnotationDesc(annotationDesc, fieldDoc.qualifiedName()));
        }
        for (AnnotationDesc annotationDesc : fieldDoc.tags()) {
            fieldNode.getTag().add(this.parseTag((Tag)annotationDesc));
        }
        return fieldNode;
    }

    protected TypeInfo parseTypeInfo(Type type) {
        ParameterizedType parameterized;
        WildcardType wildcard;
        TypeInfo typeInfoNode = this.objectFactory.createTypeInfo();
        typeInfoNode.setQualified(type.qualifiedTypeName());
        String dimension = type.dimension();
        if (dimension.length() > 0) {
            typeInfoNode.setDimension(dimension);
        }
        if ((wildcard = type.asWildcardType()) != null) {
            typeInfoNode.setWildcard(this.parseWildcard(wildcard));
        }
        if ((parameterized = type.asParameterizedType()) != null) {
            for (Type typeArgument : parameterized.typeArguments()) {
                typeInfoNode.getGeneric().add(this.parseTypeInfo(typeArgument));
            }
        }
        return typeInfoNode;
    }

    protected Wildcard parseWildcard(WildcardType wildcard) {
        Wildcard wildcardNode = this.objectFactory.createWildcard();
        for (Type extendType : wildcard.extendsBounds()) {
            wildcardNode.getExtendsBound().add(this.parseTypeInfo(extendType));
        }
        for (Type superType : wildcard.superBounds()) {
            wildcardNode.getSuperBound().add(this.parseTypeInfo(superType));
        }
        return wildcardNode;
    }

    protected TypeParameter parseTypeParameter(TypeVariable typeVariable) {
        TypeParameter typeParameter = this.objectFactory.createTypeParameter();
        typeParameter.setName(typeVariable.typeName());
        for (Type bound : typeVariable.bounds()) {
            typeParameter.getBound().add(bound.qualifiedTypeName());
        }
        return typeParameter;
    }

    protected TagInfo parseTag(Tag tagDoc) {
        TagInfo tagNode = this.objectFactory.createTagInfo();
        tagNode.setName(tagDoc.kind());
        tagNode.setText(tagDoc.text());
        return tagNode;
    }

    protected String parseScope(ProgramElementDoc doc) {
        if (doc.isPrivate()) {
            return "private";
        }
        if (doc.isProtected()) {
            return "protected";
        }
        if (doc.isPublic()) {
            return "public";
        }
        return "";
    }
}

