/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.xmldoclet;

import com.github.markusbernhardt.xmldoclet.LoggingLevelEnum;
import com.github.markusbernhardt.xmldoclet.LoggingOutputStream;
import com.github.markusbernhardt.xmldoclet.Parser;
import com.github.markusbernhardt.xmldoclet.xjc.Root;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDoclet {
    private static final Logger log = LoggerFactory.getLogger(Parser.class);
    public static Root root;
    public static final Options options;

    public static int optionLength(String optionName) {
        Option option = options.getOption(optionName);
        if (option == null) {
            return 0;
        }
        return option.getArgs() + 1;
    }

    public static boolean validOptions(String[][] optionsArrayArray, DocErrorReporter reporter) {
        return null != XmlDoclet.parseCommandLine(optionsArrayArray);
    }

    public static boolean start(RootDoc rootDoc) {
        CommandLine commandLine = XmlDoclet.parseCommandLine(rootDoc.options());
        Parser parser = new Parser();
        root = parser.parseRootDoc(rootDoc);
        XmlDoclet.save(commandLine, root);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(CommandLine commandLine, Root root) {
        if (commandLine.hasOption("dryrun")) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        FilterOutputStream bufferedOutputStream = null;
        try {
            JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{Root.class});
            Marshaller marshaller = contextObj.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            if (commandLine.hasOption("docencoding")) {
                marshaller.setProperty("jaxb.encoding", (Object)commandLine.getOptionValue("docencoding"));
            }
            String filename = "javadoc.xml";
            if (commandLine.hasOption("filename")) {
                filename = commandLine.getOptionValue("filename");
            }
            if (commandLine.hasOption("d")) {
                filename = commandLine.getOptionValue("d") + File.separator + filename;
            }
            fileOutputStream = new FileOutputStream(filename);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 0x100000);
            marshaller.marshal((Object)root, (OutputStream)bufferedOutputStream);
            ((BufferedOutputStream)bufferedOutputStream).flush();
            fileOutputStream.flush();
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static CommandLine parseCommandLine(String[][] optionsArrayArray) {
        try {
            ArrayList<String> argumentList = new ArrayList<String>();
            for (String[] optionsArray : optionsArrayArray) {
                argumentList.addAll(Arrays.asList(optionsArray));
            }
            BasicParser commandLineParser = new BasicParser(){

                protected void processOption(String arg, ListIterator iter) throws ParseException {
                    boolean hasOption = this.getOptions().hasOption(arg);
                    if (hasOption) {
                        super.processOption(arg, iter);
                    }
                }
            };
            CommandLine commandLine = commandLineParser.parse(options, argumentList.toArray(new String[0]));
            return commandLine;
        }
        catch (ParseException e) {
            LoggingOutputStream loggingOutputStream = new LoggingOutputStream(log, LoggingLevelEnum.INFO);
            PrintWriter printWriter = new PrintWriter(loggingOutputStream);
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp(printWriter, 74, "javadoc -doclet " + XmlDoclet.class.getName() + " [options]", null, options, 1, 3, null, false);
            return null;
        }
    }

    static {
        options = new Options();
        OptionBuilder.withArgName((String)"directory");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Destination directory for output file.\nDefault: .");
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withArgName((String)"encoding");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Encoding of the output file.\nDefault: UTF8");
        options.addOption(OptionBuilder.create((String)"docencoding"));
        OptionBuilder.withArgName((String)"dryrun");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArgs((int)0);
        OptionBuilder.withDescription((String)"Parse javadoc, but don't write output file.\nDefault: false");
        options.addOption(OptionBuilder.create((String)"dryrun"));
        OptionBuilder.withArgName((String)"filename");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Name of the output file.\nDefault: javadoc.xml");
        options.addOption(OptionBuilder.create((String)"filename"));
    }
}

