/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.avg;

import org.streaminer.stream.avg.IAverage;

public class ExponentialMovingAverage
implements IAverage {
    private volatile int count;
    private volatile double weight;
    private volatile double sum;
    private volatile double sumSquares;
    private volatile double min;
    private volatile double max;
    private final double decay;

    public ExponentialMovingAverage(int window) {
        this.decay = 1.0 - 1.0 / (double)window;
    }

    public synchronized void clear() {
        this.weight = 0.0;
        this.sum = 0.0;
        this.sumSquares = 0.0;
        this.count = 0;
        this.min = 0.0;
        this.max = 0.0;
    }

    public synchronized void add(double value) {
        if (value > this.max || this.count == 0) {
            this.max = value;
        }
        if (value < this.min || this.count == 0) {
            this.min = value;
        }
        this.sum = this.decay * this.sum + value;
        this.sumSquares = this.decay * this.sumSquares + value * value;
        this.weight = this.decay * this.weight + 1.0;
        ++this.count;
    }

    public int getCount() {
        return this.count;
    }

    public double getAverage() {
        return this.weight > 0.0 ? this.sum / this.weight : 0.0;
    }

    public double getStandardDeviation() {
        double mean = this.getAverage();
        double var = this.weight > 0.0 ? this.sumSquares / this.weight - mean * mean : 0.0;
        return var > 0.0 ? Math.sqrt(var) : 0.0;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }
}

