/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.avg;

import java.util.LinkedList;
import java.util.Queue;
import org.streaminer.stream.avg.IAverage;

public class MovingAverage
implements IAverage {
    private final Queue<Double> window = new LinkedList<Double>();
    private final int period;
    private double sum;

    public MovingAverage(int period) {
        if (period <= 0) {
            throw new RuntimeException("Period must be a positive integer");
        }
        this.period = period;
    }

    public void add(double num) {
        this.sum += num;
        this.window.add(num);
        if (this.window.size() > this.period) {
            this.sum -= this.window.remove().doubleValue();
        }
    }

    public double getAverage() {
        if (this.window.isEmpty()) {
            return 0.0;
        }
        return this.sum / (double)this.window.size();
    }

    public void clear() {
        this.window.clear();
        this.sum = 0.0;
    }
}

