/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.avg;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class TEWMA {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private MessageDigest sha1;
    private double beta;
    private double logBeta;
    private int nhash;
    private int shash;
    private double w;
    private int digest;
    private double[] counters;
    private long[] timers;

    public TEWMA(int nhash, int shash, double beta, double w) {
        if (w < 1.0) {
            throw new IllegalArgumentException("w should be greater than zero.");
        }
        if (nhash < 1) {
            throw new IllegalArgumentException("nhash should be greater than zero.");
        }
        if (shash < 1 || shash % 8 != 0) {
            throw new IllegalArgumentException("shash should be greater than zero and multiple of eight.");
        }
        try {
            this.sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("SHA-1 algorithm not found", ex);
        }
        this.nhash = nhash;
        this.shash = shash;
        this.beta = beta;
        this.w = w;
        this.digest = 1 << shash;
        this.logBeta = -Math.log(beta);
        this.counters = new double[this.digest];
        this.timers = new long[this.digest];
    }

    public double add(Object item, double quantity, long timestamp) {
        int[] idx = this.indexes(item);
        double minCounter = this.getMinCounter(idx, timestamp);
        double newCounter = minCounter + quantity * this.logBeta;
        if (newCounter > 1.0E99) {
            throw new AssertionError((Object)"newCounter shouldn't be greater than 1.0e99.");
        }
        for (int i = 0; i < this.nhash; ++i) {
            if (!(this.counters[idx[i]] < newCounter)) continue;
            this.counters[idx[i]] = newCounter;
        }
        return newCounter;
    }

    public double check(Object item, long timestamp) {
        return this.getMinCounter(this.indexes(item), timestamp);
    }

    protected double getMinCounter(int[] idx, long timestamp) {
        double minCouter = this.counters[idx[0]];
        for (int i = 0; i < this.nhash; ++i) {
            double deltat = (double)(timestamp - this.timers[idx[i]]) / this.w;
            this.timers[idx[i]] = timestamp;
            if (deltat < 0.0) {
                throw new AssertionError((Object)"deltat shouldn't be less than zero.");
            }
            int n = idx[i];
            this.counters[n] = this.counters[n] * Math.pow(this.beta, deltat);
            if (!(this.counters[idx[i]] < minCouter)) continue;
            minCouter = this.counters[idx[i]];
        }
        return minCouter;
    }

    protected int[] indexes(Object o) {
        int[] indexes = new int[this.nhash];
        byte[] msgDigest = this.toSHA1(o);
        int numBytes = this.shash / 8;
        int k = 0;
        for (int i = 0; i < this.nhash; ++i) {
            byte[] bytes = new byte[numBytes];
            int j = numBytes - 1;
            while (j >= 0) {
                if (k >= msgDigest.length) {
                    msgDigest = this.toSHA1(msgDigest);
                    k = 0;
                }
                bytes[j] = msgDigest[k];
                --j;
                ++k;
            }
            String hex = this.bytesToHex(bytes);
            indexes[i] = Integer.parseInt(hex, 16);
        }
        return indexes;
    }

    protected String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    protected byte[] toSHA1(Object o) {
        if (o instanceof byte[]) {
            return this.toSHA1((byte[])o);
        }
        if (o instanceof String) {
            return this.toSHA1(((String)o).getBytes());
        }
        if (o instanceof Number) {
            return this.toSHA1(String.valueOf(o).getBytes());
        }
        return this.toSHA1(String.valueOf(o.hashCode()).getBytes());
    }

    protected byte[] toSHA1(byte[] in) {
        this.sha1.reset();
        byte[] tmp = this.sha1.digest(in);
        byte[] msgDigest = new byte[tmp.length];
        int left = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (i != 0 && i % 4 == 0) {
                left += 4;
            }
            msgDigest[i] = tmp[4 - (i + 1 - left) + left];
        }
        return msgDigest;
    }
}

