/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.cardinality;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.streaminer.util.hash.function.HashFunction;
import org.streaminer.util.hash.function.MurmurHashFunction;

public class BJKST
implements Serializable {
    private static final long serialVersionUID = -2032575802259420762L;
    private int numMedians = 25;
    private int sizeOfMedianSet;
    private double error = 0.02f;
    private List<Integer> limits;
    private int bufferSize = 100;
    private List<HashSet<String>> buffers;
    private List<HashFunction<Object>> hHashers;
    private List<HashFunction<Object>> gHashers;
    private int intLength = Integer.toString(Integer.MAX_VALUE).length();
    private String lengthOfIntegerRepresentation = null;

    public BJKST(int numberOfMedianAttempts, int sizeOfEachMedianSet) {
        this.numMedians = numberOfMedianAttempts;
        this.sizeOfMedianSet = sizeOfEachMedianSet;
        this.init();
    }

    public BJKST(int numberOfMedianAttempts, int sizeOfEachMedianSet, double allowedError) {
        if (allowedError < 0.0 || allowedError > 1.0) {
            throw new IllegalArgumentException("Permitted error should be < 1 and in float format");
        }
        this.numMedians = numberOfMedianAttempts;
        this.sizeOfMedianSet = sizeOfEachMedianSet;
        this.error = allowedError;
        this.init();
    }

    private void init() {
        this.bufferSize = (int)((double)this.sizeOfMedianSet / Math.pow(this.error, 2.0));
        this.lengthOfIntegerRepresentation = "%0" + this.intLength + "d";
        this.limits = new ArrayList<Integer>(this.numMedians);
        this.buffers = new ArrayList<HashSet<String>>(this.numMedians);
        this.hHashers = new ArrayList<HashFunction<Object>>(this.numMedians);
        this.gHashers = new ArrayList<HashFunction<Object>>(this.numMedians);
        for (int i = 0; i < this.numMedians; ++i) {
            this.limits.add(0);
            this.buffers.add(new HashSet());
            this.hHashers.add(new MurmurHashFunction());
            this.gHashers.add(new MurmurHashFunction());
        }
    }

    public void offer(Object o) {
        for (int i = 0; i < this.numMedians; ++i) {
            int currentZ;
            String binaryRepr = Long.toBinaryString(this.hHashers.get(i).hash(o));
            int zereosP = binaryRepr.length() - binaryRepr.lastIndexOf(49);
            if (zereosP < (currentZ = this.limits.get(i).intValue())) continue;
            HashSet<String> currentBuffer = this.buffers.get(i);
            currentBuffer.add(String.format(this.lengthOfIntegerRepresentation, this.gHashers.get(i).hash(o)) + String.format(this.lengthOfIntegerRepresentation, zereosP));
            while (currentBuffer.size() > this.bufferSize) {
                ++currentZ;
                Iterator<String> itr = currentBuffer.iterator();
                while (itr.hasNext()) {
                    String element = itr.next();
                    long zeroesOld = Long.parseLong(element.substring(this.intLength));
                    if (zeroesOld >= (long)currentZ) continue;
                    itr.remove();
                }
            }
        }
    }

    public long cardinality() {
        HashMap<Integer, Integer> results = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.numMedians; ++i) {
            int currentGuess = (int)((double)this.buffers.get(i).size() * Math.pow(2.0, this.limits.get(i).intValue()));
            if (!results.containsKey(currentGuess)) {
                results.put(currentGuess, 1);
                continue;
            }
            int currentCount = (Integer)results.get(currentGuess);
            results.put(currentGuess, currentCount + 1);
        }
        int finalEstimate = 0;
        int highestVote = 0;
        for (Map.Entry pair : results.entrySet()) {
            int possibleAnswer = (Integer)pair.getValue();
            if (possibleAnswer <= highestVote) continue;
            highestVote = possibleAnswer;
            finalEstimate = (Integer)pair.getKey();
        }
        return finalEstimate;
    }
}

