/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.cardinality;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.streaminer.stream.cardinality.AdaptiveCounting;
import org.streaminer.stream.cardinality.CardinalityMergeException;
import org.streaminer.stream.cardinality.HyperLogLog;
import org.streaminer.stream.cardinality.HyperLogLogPlus;
import org.streaminer.stream.cardinality.IRichCardinality;
import org.streaminer.stream.cardinality.LinearCounting;
import org.streaminer.stream.cardinality.LogLog;
import org.streaminer.util.ExternalizableUtil;
import org.streaminer.util.IBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountThenEstimate
implements IRichCardinality,
Externalizable {
    protected static final byte LC = 1;
    protected static final byte AC = 2;
    protected static final byte HLC = 3;
    protected static final byte LLC = 4;
    protected static final byte HLPC = 5;
    protected int tippingPoint;
    protected boolean tipped = false;
    protected IBuilder<IRichCardinality> builder;
    protected IRichCardinality estimator;
    protected Set<Object> counter;

    public CountThenEstimate() {
        this(1000, AdaptiveCounting.Builder.obyCount(1000000000L));
    }

    public CountThenEstimate(int tippingPoint, IBuilder<IRichCardinality> builder) {
        this.tippingPoint = tippingPoint;
        this.builder = builder;
        this.counter = new HashSet<Object>();
    }

    public CountThenEstimate(byte[] bytes) throws IOException, ClassNotFoundException {
        this.readExternal(new ObjectInputStream(new ByteArrayInputStream(bytes)));
        if (!this.tipped && this.builder.sizeof() <= bytes.length) {
            this.tip();
        }
    }

    @Override
    public long cardinality() {
        if (this.tipped) {
            return this.estimator.cardinality();
        }
        return this.counter.size();
    }

    @Override
    public boolean offerHashed(long hashedLong) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offerHashed(int hashedInt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(Object o) {
        boolean modified = false;
        if (this.tipped) {
            modified = this.estimator.offer(o);
        } else if (this.counter.add(o)) {
            modified = true;
            if (this.counter.size() > this.tippingPoint) {
                this.tip();
            }
        }
        return modified;
    }

    @Override
    public int sizeof() {
        if (this.tipped) {
            return this.estimator.sizeof();
        }
        return -1;
    }

    private void tip() {
        this.estimator = this.builder.build();
        for (Object o : this.counter) {
            this.estimator.offer(o);
        }
        this.counter = null;
        this.builder = null;
        this.tipped = true;
    }

    public boolean tipped() {
        return this.tipped;
    }

    @Override
    public byte[] getBytes() throws IOException {
        return ExternalizableUtil.toBytes(this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tipped = in.readBoolean();
        if (this.tipped) {
            byte type = in.readByte();
            byte[] bytes = new byte[in.readInt()];
            in.readFully(bytes);
            switch (type) {
                case 1: {
                    this.estimator = new LinearCounting(bytes);
                    break;
                }
                case 2: {
                    this.estimator = new AdaptiveCounting(bytes);
                    break;
                }
                case 3: {
                    this.estimator = HyperLogLog.Builder.build(bytes);
                    break;
                }
                case 5: {
                    this.estimator = HyperLogLogPlus.Builder.build(bytes);
                    break;
                }
                case 4: {
                    this.estimator = new LinearCounting(bytes);
                    break;
                }
                default: {
                    throw new IOException("Unrecognized estimator type: " + type);
                }
            }
        } else {
            this.tippingPoint = in.readInt();
            this.builder = (IBuilder)in.readObject();
            int count = in.readInt();
            assert (count <= this.tippingPoint) : String.format("Invalid serialization: count (%d) > tippingPoint (%d)", count, this.tippingPoint);
            this.counter = new HashSet<Object>(count);
            for (int i = 0; i < count; ++i) {
                this.counter.add(in.readObject());
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.tipped);
        if (this.tipped) {
            if (this.estimator instanceof LinearCounting) {
                out.writeByte(1);
            } else if (this.estimator instanceof AdaptiveCounting) {
                out.writeByte(2);
            } else if (this.estimator instanceof HyperLogLog) {
                out.writeByte(3);
            } else if (this.estimator instanceof HyperLogLogPlus) {
                out.writeByte(5);
            } else if (this.estimator instanceof LogLog) {
                out.writeByte(4);
            } else {
                throw new IOException("Estimator unsupported for serialization: " + this.estimator.getClass().getName());
            }
            byte[] bytes = this.estimator.getBytes();
            out.writeInt(bytes.length);
            out.write(bytes);
        } else {
            out.writeInt(this.tippingPoint);
            out.writeObject(this.builder);
            out.writeInt(this.counter.size());
            for (Object o : this.counter) {
                out.writeObject(o);
            }
        }
    }

    @Override
    public IRichCardinality merge(IRichCardinality ... estimators) throws CardinalityMergeException {
        if (estimators == null) {
            return CountThenEstimate.mergeEstimators(this);
        }
        CountThenEstimate[] all = (CountThenEstimate[])Arrays.copyOf(estimators, estimators.length + 1, CountThenEstimate[].class);
        all[all.length - 1] = this;
        return CountThenEstimate.mergeEstimators(all);
    }

    public static CountThenEstimate mergeEstimators(CountThenEstimate ... estimators) throws CardinalityMergeException {
        int numEstimators;
        CountThenEstimate merged = null;
        int n = numEstimators = estimators == null ? 0 : estimators.length;
        if (numEstimators > 0) {
            ArrayList<IRichCardinality> tipped = new ArrayList<IRichCardinality>(numEstimators);
            ArrayList<CountThenEstimate> untipped = new ArrayList<CountThenEstimate>(numEstimators);
            for (CountThenEstimate estimator : estimators) {
                if (estimator.tipped) {
                    tipped.add(estimator.estimator);
                    continue;
                }
                untipped.add(estimator);
            }
            if (untipped.size() > 0) {
                merged = new CountThenEstimate(((CountThenEstimate)untipped.get((int)0)).tippingPoint, ((CountThenEstimate)untipped.get((int)0)).builder);
                for (CountThenEstimate cte : untipped) {
                    for (Object o : cte.counter) {
                        merged.offer(o);
                    }
                }
            } else {
                merged = new CountThenEstimate(0, new LinearCounting.Builder(1));
                merged.tip();
                merged.estimator = (IRichCardinality)tipped.remove(0);
            }
            if (!tipped.isEmpty()) {
                if (!merged.tipped) {
                    merged.tip();
                }
                merged.estimator = merged.estimator.merge(tipped.toArray(new IRichCardinality[tipped.size()]));
            }
        }
        return merged;
    }

    protected static class CountThenEstimateMergeException
    extends CardinalityMergeException {
        public CountThenEstimateMergeException(String message) {
            super(message);
        }
    }
}

