/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.cardinality;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlajoletMartin {
    private static final double PHI = 0.77351;
    private int numHashGroups;
    private int numHashFunctionsInHashGroup;
    private HashFunction[][] hashes;
    private int bitmapSize;
    private boolean[][][] bitmaps;
    private long numWords;

    public FlajoletMartin(int bitmapSize, int numHashGroups, int numHashFunctionsInEachGroup) {
        this.numHashGroups = numHashGroups;
        this.numHashFunctionsInHashGroup = numHashFunctionsInEachGroup;
        this.bitmapSize = bitmapSize;
        this.bitmaps = new boolean[numHashGroups][numHashFunctionsInEachGroup][bitmapSize];
        this.hashes = new HashFunction[numHashGroups][numHashFunctionsInEachGroup];
        this.generateHashFunctions();
    }

    private void generateHashFunctions() {
        HashMap<Integer, Collection<Integer>> mnMap = new HashMap<Integer, Collection<Integer>>();
        for (int i = 0; i < this.numHashGroups; ++i) {
            for (int j = 0; j < this.numHashFunctionsInHashGroup; ++j) {
                this.hashes[i][j] = this.generateUniqueHashFunction(mnMap);
            }
        }
    }

    private HashFunction generateUniqueHashFunction(Map<Integer, Collection<Integer>> mnMap) {
        int m = 0;
        while ((m = (int)(2.147483647E9 * Math.random())) % 2 == 0) {
        }
        int n = 0;
        while ((n = (int)(2.147483647E9 * Math.random())) % 2 == 0 || FlajoletMartin.contains(mnMap, m, n)) {
        }
        Collection<Integer> valueCollection = mnMap.get(m);
        if (valueCollection == null) {
            valueCollection = new HashSet<Integer>();
            mnMap.put(m, valueCollection);
        }
        valueCollection.add(n);
        return new HashFunction(m, n, this.bitmapSize);
    }

    private static boolean contains(Map<Integer, Collection<Integer>> map, int m, int n) {
        Collection<Integer> valueList = map.get(m);
        return valueList != null && valueList.contains(n);
    }

    public boolean offer(Object o) {
        boolean affected = false;
        for (int i = 0; i < this.numHashGroups; ++i) {
            for (int j = 0; j < this.numHashFunctionsInHashGroup; ++j) {
                HashFunction f = this.hashes[i][j];
                long v = f.hash(o);
                int index = this.rho(v);
                if (this.bitmaps[i][j][index]) continue;
                this.bitmaps[i][j][index] = true;
                affected = true;
            }
        }
        return affected;
    }

    public long cardinality() {
        ArrayList<Double> averageR = new ArrayList<Double>();
        for (int i = 0; i < this.numHashGroups; ++i) {
            int sumR = 0;
            for (int j = 0; j < this.numHashFunctionsInHashGroup; ++j) {
                sumR += FlajoletMartin.getFirstZeroBit(this.bitmaps[i][j]);
            }
            averageR.add((double)sumR * 1.0 / (double)this.numHashFunctionsInHashGroup);
        }
        Collections.sort(averageR);
        double r = 0.0;
        int averageRMid = averageR.size() / 2;
        r = averageR.size() % 2 == 0 ? ((Double)averageR.get(averageRMid) + (Double)averageR.get(averageRMid + 1)) / 2.0 : (Double)averageR.get(averageRMid + 1);
        return (long)(Math.pow(2.0, r) / 0.77351);
    }

    private int rho(long v) {
        int rho = 0;
        for (int i = 0; i < this.bitmapSize && (v & 1L) == 0L; ++i) {
            v >>= 1;
            ++rho;
        }
        return rho == this.bitmapSize ? 0 : rho;
    }

    private static int getFirstZeroBit(boolean[] b) {
        for (int i = 0; i < b.length; ++i) {
            if (b[i]) continue;
            return i;
        }
        return b.length;
    }

    private static class HashFunction {
        private int m_m;
        private int m_n;
        private int m_bitmapSize;
        private long m_pow2BitmapSize;

        public HashFunction(int m, int n, int bitmapSize) {
            if (bitmapSize > 64) {
                throw new IllegalArgumentException("bitmap size should be at max. 64");
            }
            this.m_m = m;
            this.m_n = n;
            this.m_bitmapSize = bitmapSize;
            this.m_pow2BitmapSize = 1 << this.m_bitmapSize;
        }

        public long hash(Object o) {
            if (o instanceof String) {
                return this.hash(((String)o).hashCode());
            }
            if (o instanceof Number) {
                return this.hash(String.valueOf(o).hashCode());
            }
            return this.hash(o.hashCode());
        }

        public long hash(long hashCode) {
            return (long)this.m_m + (long)this.m_n * hashCode;
        }
    }
}

